/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autenticazione;

import java.io.Serializable;
import org.openspcoop2.pdd.core.autenticazione.ParametriAutenticazione;
import org.openspcoop2.utils.BooleanNullable;

public class ParametriAutenticazioneApiKey
extends ParametriAutenticazione
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_HEADER_API_KEY = "X-API-KEY";
    public static final String DEFAULT_COOKIE_API_KEY = "X-API-KEY";
    public static final String DEFAULT_QUERY_PARAMETER_API_KEY = "api_key";
    public static final String DEFAULT_HEADER_APP_ID = "X-APP-ID";
    public static final String DEFAULT_COOKIE_APP_ID = "X-APP-ID";
    public static final String DEFAULT_QUERY_PARAMETER_APP_ID = "app_id";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String HEADER = "header";
    public static final String HEADER_TRUE = "true";
    public static final String HEADER_FALSE = "false";
    public static final String COOKIE = "cookie";
    public static final String COOKIE_TRUE = "true";
    public static final String COOKIE_FALSE = "false";
    public static final String QUERY_PARAMETER = "queryParameter";
    public static final String QUERY_PARAMETER_TRUE = "true";
    public static final String QUERY_PARAMETER_FALSE = "false";
    public static final String USE_OAS3_NAMES = "useOAS3Names";
    public static final String USE_OAS3_NAMES_TRUE = "true";
    public static final String USE_OAS3_NAMES_FALSE = "false";
    public static final String NOME_HEADER_API_KEY = "headerApiKey";
    public static final String NOME_COOKIE_API_KEY = "cookieApiKey";
    public static final String NOME_QUERY_PARAMETER_API_KEY = "queryParameterApiKey";
    public static final String APP_ID = "appId";
    public static final String APP_ID_TRUE = "true";
    public static final String APP_ID_FALSE = "false";
    public static final String NOME_HEADER_APP_ID = "headerAppId";
    public static final String NOME_COOKIE_APP_ID = "cookieAppId";
    public static final String NOME_QUERY_PARAMETER_APP_ID = "queryParameterAppId";
    public static final String CLEAN_API_KEY = "cleanApiKey";
    public static final String CLEAN_API_KEY_TRUE = "true";
    public static final String CLEAN_API_KEY_FALSE = "false";
    public static final String CLEAN_APP_ID = "cleanAppId";
    public static final String CLEAN_APP_ID_TRUE = "true";
    public static final String CLEAN_APP_ID_FALSE = "false";

    public ParametriAutenticazioneApiKey(ParametriAutenticazione parametri) {
        super(parametri);
    }

    public BooleanNullable getHeader() {
        return this._get(HEADER);
    }

    public BooleanNullable getCookie() {
        return this._get(COOKIE);
    }

    public BooleanNullable getQueryParameter() {
        return this._get(QUERY_PARAMETER);
    }

    public String getNomeHeaderApiKey() {
        return this._getNome("X-API-KEY", NOME_HEADER_API_KEY);
    }

    public String getNomeCookieApiKey() {
        return this._getNome("X-API-KEY", NOME_COOKIE_API_KEY);
    }

    public String getNomeQueryParameterApiKey() {
        return this._getNome(DEFAULT_QUERY_PARAMETER_API_KEY, NOME_QUERY_PARAMETER_API_KEY);
    }

    public BooleanNullable getAppId() {
        return this._get(APP_ID);
    }

    public String getNomeHeaderAppId() {
        return this._getNome("X-APP-ID", NOME_HEADER_APP_ID);
    }

    public String getNomeCookieAppId() {
        return this._getNome("X-APP-ID", NOME_COOKIE_APP_ID);
    }

    public String getNomeQueryParameterAppId() {
        return this._getNome(DEFAULT_QUERY_PARAMETER_APP_ID, NOME_QUERY_PARAMETER_APP_ID);
    }

    public BooleanNullable getCleanApiKey() {
        return this._get(CLEAN_API_KEY);
    }

    public BooleanNullable getCleanAppId() {
        return this._get(CLEAN_APP_ID);
    }

    private BooleanNullable _get(String name) {
        String valore = this.get(name);
        if (valore == null || "".equals(valore)) {
            return BooleanNullable.NULL();
        }
        if ("false".equalsIgnoreCase(valore)) {
            return BooleanNullable.FALSE();
        }
        if ("true".equalsIgnoreCase(valore)) {
            return BooleanNullable.TRUE();
        }
        return BooleanNullable.NULL();
    }

    private String _getNome(String defaultName, String nome) {
        BooleanNullable useOAS3NamesNullable = this._get(USE_OAS3_NAMES);
        if (useOAS3NamesNullable != null && useOAS3NamesNullable.getValue() != null && useOAS3NamesNullable.getValue().booleanValue()) {
            return defaultName;
        }
        String nomeCustom = this.get(nome);
        if (nomeCustom == null || "".equals(nomeCustom)) {
            return defaultName;
        }
        return nomeCustom;
    }
}

