/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autenticazione;

import org.openspcoop2.core.config.constants.TipoAutenticazionePrincipal;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.autenticazione.AutenticazioneException;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop2.pdd.core.token.InformazioniToken;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;

public class PrincipalUtilities {
    private PrincipalUtilities() {
    }

    /*
     * Unable to fully structure code
     */
    public static String getPrincipal(TipoAutenticazionePrincipal tipoAutenticazionePrincipal, String nome, String pattern, TipoCredenzialeMittente token, InfoConnettoreIngresso infoConnettore, PdDContext pddContext, boolean throwException, StringBuilder fullCredential) throws AutenticazioneException {
        principal = null;
        switch (1.$SwitchMap$org$openspcoop2$core$config$constants$TipoAutenticazionePrincipal[tipoAutenticazionePrincipal.ordinal()]) {
            case 1: {
                if (infoConnettore != null && infoConnettore.getCredenziali() != null) {
                    principal = infoConnettore.getCredenziali().getPrincipal();
                }
                if ((principal == null || "".equals(principal)) && throwException) {
                    throw new AutenticazioneException("[" + tipoAutenticazionePrincipal + "] Principal non presente all'interno delle credenziali");
                }
                return principal;
            }
            case 2: {
                if (nome == null && throwException) {
                    throw new AutenticazioneException("[" + tipoAutenticazionePrincipal + "] Nome dell'header, da cui estrarre il principal, non indicato");
                }
                if (nome != null && infoConnettore != null && infoConnettore.getUrlProtocolContext() != null) {
                    principal = infoConnettore.getUrlProtocolContext().getHeaderFirstValue(nome);
                }
                if ((principal == null || "".equals(principal)) && throwException) {
                    throw new AutenticazioneException("[" + tipoAutenticazionePrincipal + "] Principal non presente nell'header http '" + nome + "'");
                }
                if (fullCredential.length() > 0) {
                    fullCredential.append("\n");
                }
                fullCredential.append("Principal").append(" (http) '").append(nome).append(": ").append(principal).append("'");
                return principal;
            }
            case 3: {
                if (nome == null && throwException) {
                    throw new AutenticazioneException("[" + tipoAutenticazionePrincipal + "] Nome del parametro della query, da cui estrarre il principal, non indicato");
                }
                if (nome != null && infoConnettore != null && infoConnettore.getUrlProtocolContext() != null) {
                    principal = infoConnettore.getUrlProtocolContext().getParameterFirstValue(nome);
                }
                if ((principal == null || "".equals(principal)) && throwException) {
                    throw new AutenticazioneException("[" + tipoAutenticazionePrincipal + "] Principal non presente nel parametro della query '" + nome + "'");
                }
                if (fullCredential.length() > 0) {
                    fullCredential.append("\n");
                }
                fullCredential.append("Principal").append(" (query) '").append(nome).append(": ").append(principal).append("'");
                return principal;
            }
            case 4: {
                if (pattern == null && throwException) {
                    throw new AutenticazioneException("[" + tipoAutenticazionePrincipal + "] Espressione Regolare, da utilizzare sulla url per estrarre il principal, non indicata");
                }
                msgErrore = "[" + tipoAutenticazionePrincipal + "] Principal non estraibile con l'espressione regolare '" + pattern + "', url non presente";
                if (pattern == null || infoConnettore == null || infoConnettore.getUrlProtocolContext() == null) ** GOTO lbl47
                msgErrore = "[" + tipoAutenticazionePrincipal + "] Principal non estraibile con l'espressione regolare '" + pattern + "' dalla url '" + infoConnettore.getUrlProtocolContext().getUrlInvocazione_formBased() + "'";
                try {
                    principal = RegularExpressionEngine.getStringMatchPattern((String)infoConnettore.getUrlProtocolContext().getUrlInvocazione_formBased(), (String)pattern);
                }
                catch (Exception t) {
                    if (!throwException) ** GOTO lbl47
                    throw new AutenticazioneException(msgErrore + ": " + t.getMessage(), t);
                }
lbl47:
                // 3 sources

                if ((principal == null || "".equals(principal)) && throwException) {
                    throw new AutenticazioneException(msgErrore);
                }
                return principal;
            }
            case 5: {
                if (pddContext != null && pddContext.containsKey(Costanti.CLIENT_IP_REMOTE_ADDRESS)) {
                    principal = PdDContext.getValue((MapKey<String>)Costanti.CLIENT_IP_REMOTE_ADDRESS, pddContext);
                }
                if ((principal == null || "".equals(principal)) && throwException) {
                    throw new AutenticazioneException("[" + tipoAutenticazionePrincipal + "] Indirizzo IP del Client non disponibile");
                }
                return principal;
            }
            case 6: {
                if (pddContext != null && pddContext.containsKey(Costanti.CLIENT_IP_TRANSPORT_ADDRESS)) {
                    principal = PdDContext.getValue((MapKey<String>)Costanti.CLIENT_IP_TRANSPORT_ADDRESS, pddContext);
                }
                if ((principal == null || "".equals(principal)) && throwException) {
                    throw new AutenticazioneException("[" + tipoAutenticazionePrincipal + "] Indirizzo IP del Client, tramite 'X-Forwarded-For', non disponibile");
                }
                return principal;
            }
            case 7: {
                informazioniTokenNormalizzate = null;
                if (pddContext != null && pddContext.containsKey(org.openspcoop2.pdd.core.token.Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_NORMALIZZATE) && (oInformazioniTokenNormalizzate = pddContext.getObject(org.openspcoop2.pdd.core.token.Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_NORMALIZZATE)) != null) {
                    informazioniTokenNormalizzate = (InformazioniToken)oInformazioniTokenNormalizzate;
                }
                nomeClaim = null;
                switch (1.$SwitchMap$org$openspcoop2$core$transazioni$utils$TipoCredenzialeMittente[token.ordinal()]) {
                    case 1: {
                        nomeClaim = "issuer";
                        if (informazioniTokenNormalizzate == null) break;
                        principal = informazioniTokenNormalizzate.getIss();
                        break;
                    }
                    case 2: {
                        nomeClaim = "subject";
                        if (informazioniTokenNormalizzate == null) break;
                        principal = informazioniTokenNormalizzate.getSub();
                        break;
                    }
                    case 3: {
                        nomeClaim = "clientId";
                        if (informazioniTokenNormalizzate == null) break;
                        principal = informazioniTokenNormalizzate.getClientId();
                        break;
                    }
                    case 4: {
                        nomeClaim = "username";
                        if (informazioniTokenNormalizzate == null) break;
                        principal = informazioniTokenNormalizzate.getUsername();
                        break;
                    }
                    case 5: {
                        nomeClaim = "eMail";
                        if (informazioniTokenNormalizzate == null || informazioniTokenNormalizzate.getUserInfo() == null) break;
                        principal = informazioniTokenNormalizzate.getUserInfo().getEMail();
                        break;
                    }
                    case 6: {
                        nomeClaim = nome;
                        if (informazioniTokenNormalizzate == null || informazioniTokenNormalizzate.getClaims() == null || !((oValueClaim = informazioniTokenNormalizzate.getClaims().get(nomeClaim)) instanceof String)) break;
                        principal = (String)oValueClaim;
                        break;
                    }
                }
                if ((principal == null || "".equals(principal)) && throwException) {
                    throw new AutenticazioneException("[" + tipoAutenticazionePrincipal + "] Token claim '" + nomeClaim + "' non disponibile");
                }
                return principal;
            }
        }
        return null;
    }
}

