/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autenticazione.pa;

import org.openspcoop2.core.config.constants.TipoAutenticazionePrincipal;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.autenticazione.AutenticazioneException;
import org.openspcoop2.pdd.core.autenticazione.AutenticazioneUtils;
import org.openspcoop2.pdd.core.autenticazione.ParametriAutenticazione;
import org.openspcoop2.pdd.core.autenticazione.ParametriAutenticazionePrincipal;
import org.openspcoop2.pdd.core.autenticazione.PrincipalUtilities;
import org.openspcoop2.pdd.core.autenticazione.WWWAuthenticateConfig;
import org.openspcoop2.pdd.core.autenticazione.pa.AbstractAutenticazioneBase;
import org.openspcoop2.pdd.core.autenticazione.pa.DatiInvocazionePortaApplicativa;
import org.openspcoop2.pdd.core.autenticazione.pa.EsitoAutenticazionePortaApplicativa;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.utils.BooleanNullable;

public class AutenticazionePrincipal
extends AbstractAutenticazioneBase {
    private TipoAutenticazionePrincipal tipoAutenticazionePrincipal = TipoAutenticazionePrincipal.CONTAINER;
    private String nome = null;
    private String pattern = null;
    private TipoCredenzialeMittente tipoTokenClaim = null;
    private boolean cleanPrincipal = true;
    private boolean logError = true;

    @Override
    public void setLogError(boolean logError) {
        this.logError = logError;
    }

    @Override
    public void initParametri(ParametriAutenticazione parametri) throws AutenticazioneException {
        super.initParametri(parametri);
        ParametriAutenticazionePrincipal authPrincipal = new ParametriAutenticazionePrincipal(this.parametri);
        if (authPrincipal.getTipoAutenticazione() != null) {
            this.tipoAutenticazionePrincipal = authPrincipal.getTipoAutenticazione();
            switch (this.tipoAutenticazionePrincipal) {
                case CONTAINER: 
                case INDIRIZZO_IP: 
                case INDIRIZZO_IP_X_FORWARDED_FOR: {
                    break;
                }
                case HEADER: {
                    this.nome = authPrincipal.getNome();
                    if (this.nome != null) break;
                    throw new AutenticazioneException("Nome dell'header, da cui estrarre il principal, non indicato");
                }
                case FORM: {
                    this.nome = authPrincipal.getNome();
                    if (this.nome != null) break;
                    throw new AutenticazioneException("Nome del parametro della query, da cui estrarre il principal, non indicato");
                }
                case URL: {
                    this.pattern = authPrincipal.getPattern();
                    if (this.pattern != null) break;
                    throw new AutenticazioneException("Espressione Regolare, da utilizzare sulla url per estrarre il principal, non indicata");
                }
                case TOKEN: {
                    this.tipoTokenClaim = authPrincipal.getTokenClaim();
                    if (this.tipoTokenClaim == null) {
                        throw new AutenticazioneException("Token Claim, da cui estrarre il principal, non indicato");
                    }
                    if (!TipoCredenzialeMittente.TRASPORTO.equals((Object)this.tipoTokenClaim)) break;
                    this.nome = authPrincipal.getNome();
                    if (this.nome != null) break;
                    throw new AutenticazioneException("Nome del token claim, da cui estrarre il principal, non indicato");
                }
            }
            BooleanNullable cleanNullable = authPrincipal.getCleanPrincipal();
            if (cleanNullable != null && cleanNullable.getValue() != null) {
                this.cleanPrincipal = cleanNullable.getValue();
            }
        }
    }

    @Override
    public String getSuffixKeyAuthenticationResultInCache(DatiInvocazionePortaApplicativa datiInvocazione) {
        switch (this.tipoAutenticazionePrincipal) {
            case CONTAINER: {
                return null;
            }
            case INDIRIZZO_IP: 
            case INDIRIZZO_IP_X_FORWARDED_FOR: 
            case HEADER: 
            case FORM: 
            case URL: 
            case TOKEN: {
                if (datiInvocazione == null) {
                    return null;
                }
                try {
                    return PrincipalUtilities.getPrincipal(this.tipoAutenticazionePrincipal, this.nome, this.pattern, this.tipoTokenClaim, datiInvocazione.getInfoConnettoreIngresso(), this.getPddContext(), false, new StringBuilder());
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public EsitoAutenticazionePortaApplicativa process(DatiInvocazionePortaApplicativa datiInvocazione) throws AutenticazioneException {
        EsitoAutenticazionePortaApplicativa esito = new EsitoAutenticazionePortaApplicativa();
        if (datiInvocazione == null) {
            throw new AutenticazioneException("Param datiInvocazione is null");
        }
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        WWWAuthenticateConfig wwwAuthenticateConfig = op2Properties.getRealmAutenticazionePrincipalWWWAuthenticateConfig(this.tipoAutenticazionePrincipal);
        StringBuilder fullCredential = new StringBuilder();
        String principal = null;
        try {
            principal = PrincipalUtilities.getPrincipal(this.tipoAutenticazionePrincipal, this.nome, this.pattern, this.tipoTokenClaim, datiInvocazione.getInfoConnettoreIngresso(), this.getPddContext(), true, fullCredential);
        }
        catch (Exception e) {
            if (this.logError) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("AutenticazionePrincipal non riuscita", (Throwable)e);
            }
            esito.setErroreCooperazione(IntegrationFunctionError.AUTHENTICATION_CREDENTIALS_NOT_FOUND, ErroriCooperazione.AUTENTICAZIONE_FALLITA_CREDENZIALI_NON_FORNITE.getErroreCooperazione());
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            if (wwwAuthenticateConfig != null) {
                esito.setWwwAuthenticateErrorHeader(wwwAuthenticateConfig.buildWWWAuthenticateHeaderValue_notFound());
            }
            return esito;
        }
        if (principal == null || "".equals(principal)) {
            esito.setErroreCooperazione(IntegrationFunctionError.AUTHENTICATION_CREDENTIALS_NOT_FOUND, ErroriCooperazione.AUTENTICAZIONE_FALLITA_CREDENZIALI_NON_FORNITE.getErroreCooperazione());
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            if (wwwAuthenticateConfig != null) {
                esito.setWwwAuthenticateErrorHeader(wwwAuthenticateConfig.buildWWWAuthenticateHeaderValue_notFound());
            }
            return esito;
        }
        esito.setFullCredential(fullCredential.toString());
        esito.setClientAuthenticated(true);
        esito.setCredential(principal);
        esito.setEnrichPrincipal(true);
        IDSoggetto idSoggetto = null;
        try {
            idSoggetto = RegistroServiziManager.getInstance((IState)datiInvocazione.getState()).getIdSoggettoByCredenzialiPrincipal(principal, null);
        }
        catch (DriverRegistroServiziNotFound notFound) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().debug("AutenticazionePrincipal non ha trovato risultati", (Throwable)notFound);
        }
        catch (Exception e) {
            if (this.logError) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("AutenticazionePrincipal non riuscita", (Throwable)e);
            }
            esito.setErroreCooperazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione());
            esito.setClientIdentified(false);
            esito.setEccezioneProcessamento(e);
            return esito;
        }
        IDServizioApplicativo idServizioApplicativo = null;
        try {
            if (idSoggetto == null && this.getProtocolFactory().createProtocolConfiguration().isSupportoAutenticazioneApplicativiErogazioni() && (idServizioApplicativo = ConfigurazionePdDManager.getInstance(datiInvocazione.getState()).getIdServizioApplicativoByCredenzialiPrincipal(principal)) != null) {
                idSoggetto = idServizioApplicativo.getIdSoggettoProprietario();
            }
        }
        catch (Exception e) {
            if (this.logError) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("AutenticazionePrincipal (Applicativi) non riuscita", (Throwable)e);
            }
            esito.setErroreCooperazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione());
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            esito.setEccezioneProcessamento(e);
            return esito;
        }
        if (idSoggetto == null) {
            esito.setClientIdentified(false);
            return esito;
        }
        esito.setClientIdentified(true);
        esito.setIdSoggetto(idSoggetto);
        esito.setIdServizioApplicativo(idServizioApplicativo);
        return esito;
    }

    @Override
    public void cleanPostAuth(OpenSPCoop2Message message) throws AutenticazioneException {
        AutenticazioneUtils.finalizeProcessPrincipal(message, this.tipoAutenticazionePrincipal, this.nome, this.cleanPrincipal);
    }
}

