/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autenticazione.pd;

import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.autenticazione.AutenticazioneException;
import org.openspcoop2.pdd.core.autenticazione.AutenticazioneUtils;
import org.openspcoop2.pdd.core.autenticazione.ParametriAutenticazione;
import org.openspcoop2.pdd.core.autenticazione.ParametriAutenticazioneBasic;
import org.openspcoop2.pdd.core.autenticazione.WWWAuthenticateConfig;
import org.openspcoop2.pdd.core.autenticazione.pd.AbstractAutenticazioneBase;
import org.openspcoop2.pdd.core.autenticazione.pd.DatiInvocazionePortaDelegata;
import org.openspcoop2.pdd.core.autenticazione.pd.EsitoAutenticazionePortaDelegata;
import org.openspcoop2.pdd.core.credenziali.Credenziali;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.crypt.CryptConfig;

public class AutenticazioneBasic
extends AbstractAutenticazioneBase {
    protected boolean cleanHeaderAuthorization = true;
    private boolean logError = true;

    @Override
    public void setLogError(boolean logError) {
        this.logError = logError;
    }

    @Override
    public void initParametri(ParametriAutenticazione parametri) throws AutenticazioneException {
        super.initParametri(parametri);
        ParametriAutenticazioneBasic authBasic = new ParametriAutenticazioneBasic(this.parametri);
        BooleanNullable cleanNullable = authBasic.getCleanHeaderAuthorization();
        if (cleanNullable != null && cleanNullable.getValue() != null) {
            this.cleanHeaderAuthorization = cleanNullable.getValue();
        }
    }

    @Override
    public EsitoAutenticazionePortaDelegata process(DatiInvocazionePortaDelegata datiInvocazione) throws AutenticazioneException {
        EsitoAutenticazionePortaDelegata esito = new EsitoAutenticazionePortaDelegata();
        if (datiInvocazione == null) {
            throw new AutenticazioneException("Param datiInvocazione is null");
        }
        Credenziali credenziali = datiInvocazione.getInfoConnettoreIngresso().getCredenziali();
        IDSoggetto soggettoFruitore = null;
        if (datiInvocazione != null && datiInvocazione.getPd() != null) {
            soggettoFruitore = new IDSoggetto(datiInvocazione.getPd().getTipoSoggettoProprietario(), datiInvocazione.getPd().getNomeSoggettoProprietario());
        }
        String user = credenziali.getUsername();
        String password = credenziali.getPassword();
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        CryptConfig cryptConfigApplicativi = op2Properties.getCryptConfigAutenticazioneApplicativi();
        WWWAuthenticateConfig wwwAuthenticateConfig = op2Properties.getRealmAutenticazioneBasicWWWAuthenticateConfig();
        if (user == null || "".equals(user) || password == null || "".equals(password)) {
            esito.setErroreIntegrazione(IntegrationFunctionError.AUTHENTICATION_CREDENTIALS_NOT_FOUND, ErroriIntegrazione.ERRORE_402_AUTENTICAZIONE_FALLITA.getErrore402_AutenticazioneFallitaBasic("credenziali non fornite", user, password));
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            if (wwwAuthenticateConfig != null) {
                esito.setWwwAuthenticateErrorHeader(wwwAuthenticateConfig.buildWWWAuthenticateHeaderValue_notFound());
            }
            return esito;
        }
        esito.setCredential(user);
        IDServizioApplicativo idServizioApplicativo = null;
        try {
            idServizioApplicativo = ConfigurazionePdDManager.getInstance(datiInvocazione.getState()).getIdServizioApplicativoByCredenzialiBasic(user, password, cryptConfigApplicativi);
            if (idServizioApplicativo != null && soggettoFruitore == null) {
                soggettoFruitore = idServizioApplicativo.getIdSoggettoProprietario();
            }
        }
        catch (Exception e) {
            if (this.logError) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("AutenticazioneBasic non riuscita", (Throwable)e);
            }
            esito.setErroreIntegrazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            esito.setEccezioneProcessamento(e);
            return esito;
        }
        if (idServizioApplicativo == null) {
            esito.setErroreIntegrazione(IntegrationFunctionError.AUTHENTICATION_INVALID_CREDENTIALS, ErroriIntegrazione.ERRORE_402_AUTENTICAZIONE_FALLITA.getErrore402_AutenticazioneFallitaBasic("credenziali fornite non corrette", user, password));
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            if (wwwAuthenticateConfig != null) {
                esito.setWwwAuthenticateErrorHeader(wwwAuthenticateConfig.buildWWWAuthenticateHeaderValue_invalid());
            }
            return esito;
        }
        if (!idServizioApplicativo.getIdSoggettoProprietario().equals((Object)soggettoFruitore)) {
            esito.setErroreIntegrazione(IntegrationFunctionError.AUTHENTICATION_INVALID_CREDENTIALS, ErroriIntegrazione.ERRORE_402_AUTENTICAZIONE_FALLITA.getErrore402_AutenticazioneFallitaBasic("soggetto proprietario (" + idServizioApplicativo.getIdSoggettoProprietario() + ") dell'applicativo identificato (" + idServizioApplicativo.getNome() + ") differente dal soggetto proprietario della porta invocata (" + soggettoFruitore + ")", user, password));
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            if (wwwAuthenticateConfig != null) {
                esito.setWwwAuthenticateErrorHeader(wwwAuthenticateConfig.buildWWWAuthenticateHeaderValue_invalid());
            }
            return esito;
        }
        esito.setClientAuthenticated(true);
        esito.setClientIdentified(true);
        esito.setIdServizioApplicativo(idServizioApplicativo);
        return esito;
    }

    @Override
    public void cleanPostAuth(OpenSPCoop2Message message) throws AutenticazioneException {
        AutenticazioneUtils.finalizeProcessHeaderAuthorization(message, this.cleanHeaderAuthorization);
    }
}

