/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autenticazione.pd;

import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.autenticazione.AutenticazioneException;
import org.openspcoop2.pdd.core.autenticazione.pd.AbstractAutenticazioneBase;
import org.openspcoop2.pdd.core.autenticazione.pd.DatiInvocazionePortaDelegata;
import org.openspcoop2.pdd.core.autenticazione.pd.EsitoAutenticazionePortaDelegata;
import org.openspcoop2.pdd.core.token.Costanti;
import org.openspcoop2.pdd.core.token.InformazioniToken;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;

public class AutenticazioneToken
extends AbstractAutenticazioneBase {
    private boolean logError = true;
    private String tokenPolicy = null;
    private String clientId = null;

    @Override
    public void setLogError(boolean logError) {
        this.logError = logError;
    }

    private void readDati(DatiInvocazionePortaDelegata datiInvocazione) {
        if (this.clientId == null) {
            InformazioniToken informazioniTokenNormalizzate = null;
            if (this.getPddContext() != null && this.getPddContext().containsKey(Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_NORMALIZZATE)) {
                informazioniTokenNormalizzate = (InformazioniToken)this.getPddContext().getObject(Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_NORMALIZZATE);
            }
            if (informazioniTokenNormalizzate == null) {
                return;
            }
            this.clientId = informazioniTokenNormalizzate.getClientId();
            if (this.clientId == null || StringUtils.isEmpty((String)this.clientId)) {
                return;
            }
        }
        if (this.tokenPolicy == null && datiInvocazione.getPd() != null && datiInvocazione.getPd().getGestioneToken() != null) {
            this.tokenPolicy = datiInvocazione.getPd().getGestioneToken().getPolicy();
            if (this.tokenPolicy == null || StringUtils.isEmpty((String)this.tokenPolicy)) {
                return;
            }
        }
    }

    public String toStringCredentials() {
        if (this.clientId == null || this.tokenPolicy == null) {
            return null;
        }
        return "TokenPolicy-" + this.tokenPolicy + ".clientId:" + this.clientId;
    }

    @Override
    public String getSuffixKeyAuthenticationResultInCache(DatiInvocazionePortaDelegata datiInvocazione) {
        this.readDati(datiInvocazione);
        return this.toStringCredentials();
    }

    @Override
    public EsitoAutenticazionePortaDelegata process(DatiInvocazionePortaDelegata datiInvocazione) throws AutenticazioneException {
        EsitoAutenticazionePortaDelegata esito = new EsitoAutenticazionePortaDelegata();
        if (datiInvocazione == null) {
            throw new AutenticazioneException("Param datiInvocazione is null");
        }
        this.readDati(datiInvocazione);
        if (this.clientId == null || this.tokenPolicy == null) {
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            esito.setNoCache(true);
            return esito;
        }
        IDSoggetto soggettoFruitore = null;
        if (datiInvocazione != null && datiInvocazione.getPd() != null) {
            soggettoFruitore = new IDSoggetto(datiInvocazione.getPd().getTipoSoggettoProprietario(), datiInvocazione.getPd().getNomeSoggettoProprietario());
        }
        esito.setClientAuthenticated(true);
        esito.setCredential(this.toStringCredentials());
        IDServizioApplicativo idServizioApplicativo = null;
        try {
            ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance(datiInvocazione.getState());
            idServizioApplicativo = configurazionePdDManager.getIdServizioApplicativoByCredenzialiToken(this.tokenPolicy, this.clientId);
        }
        catch (Exception e) {
            if (this.logError) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("AutenticazioneToken non riuscita", (Throwable)e);
            }
            esito.setErroreIntegrazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            esito.setEccezioneProcessamento(e);
            return esito;
        }
        if (idServizioApplicativo == null) {
            esito.setClientIdentified(false);
            return esito;
        }
        if (OpenSPCoop2Properties.getInstance().isAutenticazioneTokenPortaDelegataCheckSoggettiProprietari() && !idServizioApplicativo.getIdSoggettoProprietario().equals((Object)soggettoFruitore)) {
            esito.setErroreIntegrazione(IntegrationFunctionError.AUTHENTICATION_INVALID_CREDENTIALS, ErroriIntegrazione.ERRORE_402_AUTENTICAZIONE_FALLITA.getErrore402_AutenticazioneFallitaToken("soggetto proprietario (" + idServizioApplicativo.getIdSoggettoProprietario() + ") dell'applicativo token identificato (" + idServizioApplicativo.getNome() + ") differente dal soggetto proprietario della porta invocata (" + soggettoFruitore + ")", this.clientId));
            esito.setClientIdentified(false);
            return esito;
        }
        esito.setClientIdentified(true);
        esito.setIdServizioApplicativo(idServizioApplicativo);
        return esito;
    }
}

