/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autorizzazione.pd;

import java.util.List;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.core.autorizzazione.AutorizzazioneException;
import org.openspcoop2.pdd.core.autorizzazione.GestoreAutorizzazioneContenutiBuiltIn;
import org.openspcoop2.pdd.core.autorizzazione.pd.AbstractAutorizzazioneContenutoBase;
import org.openspcoop2.pdd.core.autorizzazione.pd.DatiInvocazionePortaDelegata;
import org.openspcoop2.pdd.core.autorizzazione.pd.EsitoAutorizzazionePortaDelegata;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;

public class AutorizzazioneContenutoBuiltIn
extends AbstractAutorizzazioneContenutoBase {
    @Override
    public EsitoAutorizzazionePortaDelegata process(DatiInvocazionePortaDelegata datiInvocazione, OpenSPCoop2Message msg) throws AutorizzazioneException {
        EsitoAutorizzazionePortaDelegata esito = new EsitoAutorizzazionePortaDelegata();
        try {
            if (datiInvocazione.getPd() == null) {
                throw new Exception("Porta Delegata non presente");
            }
            List regole = datiInvocazione.getPd().getProprietaAutorizzazioneContenutoList();
            GestoreAutorizzazioneContenutiBuiltIn gestore = new GestoreAutorizzazioneContenutiBuiltIn();
            gestore.process(msg, datiInvocazione, this.getPddContext(), regole);
            if (!gestore.isAutorizzato()) {
                String servizioApplicativo = null;
                if (datiInvocazione.getIdServizioApplicativo() != null) {
                    servizioApplicativo = datiInvocazione.getIdServizioApplicativo().getNome();
                }
                if (servizioApplicativo == null) {
                    servizioApplicativo = "Anonimo";
                }
                esito.setErroreIntegrazione(IntegrationFunctionError.CONTENT_AUTHORIZATION_DENY, ErroriIntegrazione.ERRORE_428_AUTORIZZAZIONE_CONTENUTO_FALLITA.getErrore428_AutorizzazioneContenutoFallita(servizioApplicativo));
                esito.setAutorizzato(false);
                esito.setDetails(gestore.getErrorMessage());
            } else {
                esito.setAutorizzato(true);
            }
            return esito;
        }
        catch (Exception e) {
            esito.setEccezioneProcessamento(e);
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("Autorizzazione per contenuto non riuscita", (Throwable)e);
            throw new AutorizzazioneException("Errore inatteso durante la gestione dell'autorizzazione per contenuti: " + e.getMessage(), e);
        }
    }
}

