/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.behaviour.built_in.load_balance;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.behaviour.BehaviourException;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.LoadBalancerPool;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.LoadBalancerType;

public class LoadBalancer {
    private static Random rndInternal = null;
    private PdDContext pddContext;
    private LoadBalancerPool pool;
    private LoadBalancerType type;

    private static synchronized void initRandomInstance() {
        if (rndInternal == null) {
            rndInternal = new SecureRandom();
        }
    }

    public static Random getRandomInstance() {
        if (rndInternal == null) {
            LoadBalancer.initRandomInstance();
        }
        return rndInternal;
    }

    public LoadBalancer(LoadBalancerType type, LoadBalancerPool pool, PdDContext pddContext) {
        this.pddContext = pddContext;
        this.type = type;
        this.pool = pool;
    }

    public String selectConnector() throws BehaviourException {
        switch (this.type) {
            case ROUND_ROBIN: {
                return this.getRoundRobin();
            }
            case WEIGHT_ROUND_ROBIN: {
                return this.getWeightRoundRobin();
            }
            case RANDOM: {
                return this.getRandom();
            }
            case WEIGHT_RANDOM: {
                return this.getWeightRandom();
            }
            case IP_HASH: {
                return this.getIpSourceHash();
            }
            case LEAST_CONNECTIONS: {
                return this.getLeastConnections();
            }
        }
        throw new BehaviourException("Type '" + this.type + "' unknown");
    }

    private String getRoundRobin() throws BehaviourException {
        Set<String> servers = this.pool.getConnectorNames(false);
        ArrayList<String> serverList = new ArrayList<String>();
        serverList.addAll(servers);
        int position = this.pool.getNextPosition(false);
        return (String)serverList.get(position);
    }

    private String getWeightRoundRobin() throws BehaviourException {
        List<String> serverList = this.pool.getWeightList(false);
        int position = this.pool.getNextPosition(true);
        return serverList.get(position);
    }

    private String getRandom() throws BehaviourException {
        Set<String> servers = this.pool.getConnectorNames(true);
        if (servers.isEmpty()) {
            throw new BehaviourException("Nessun connettore selezionabile (passive health check)");
        }
        ArrayList<String> serverList = new ArrayList<String>();
        serverList.addAll(servers);
        int randomIndex = LoadBalancer.getRandomInstance().nextInt(serverList.size());
        return (String)serverList.get(randomIndex);
    }

    private String getWeightRandom() throws BehaviourException {
        List<String> serverList = this.pool.getWeightList(true);
        Integer index = LoadBalancer.getRandomInstance().nextInt(serverList.size());
        return serverList.get(index);
    }

    public static String getIpSourceFromContet(PdDContext pddContext) {
        Object oIpAddressRemote = pddContext.getObject(Costanti.CLIENT_IP_REMOTE_ADDRESS);
        String ipAddressRemote = null;
        if (oIpAddressRemote instanceof String) {
            ipAddressRemote = (String)oIpAddressRemote;
        }
        if (ipAddressRemote == null) {
            ipAddressRemote = "127.0.0.1";
        }
        Object oIpAddressTransport = pddContext.getObject(Costanti.CLIENT_IP_TRANSPORT_ADDRESS);
        String ipAddressTransport = null;
        if (oIpAddressTransport instanceof String) {
            ipAddressTransport = (String)oIpAddressTransport;
        }
        if (ipAddressTransport == null) {
            ipAddressTransport = "-";
        }
        return ipAddressRemote + " " + ipAddressTransport;
    }

    private String getIpSourceHash() throws BehaviourException {
        String clientIp = LoadBalancer.getIpSourceFromContet(this.pddContext);
        Set<String> servers = this.pool.getConnectorNames(false);
        ArrayList<String> serverList = new ArrayList<String>();
        serverList.addAll(servers);
        String remoteId = clientIp;
        int hashCodeCalcolato = remoteId.hashCode();
        if (hashCodeCalcolato == Integer.MIN_VALUE) {
            hashCodeCalcolato = -2147483647;
        }
        int absoluteHashCode = Math.abs(hashCodeCalcolato);
        Integer index = absoluteHashCode % serverList.size();
        String target = (String)serverList.get(index);
        if (this.pool.isPassiveHealthCheck()) {
            Set<String> setAfterPassiveHealthCheck = this.pool.getConnectorNames(true);
            if (setAfterPassiveHealthCheck.contains(target)) {
                return target;
            }
            int nextPos = index + 1;
            if (nextPos == serverList.size()) {
                nextPos = 0;
            }
            while (nextPos != index) {
                target = (String)serverList.get(nextPos);
                if (setAfterPassiveHealthCheck.contains(target)) {
                    return target;
                }
                if (++nextPos != serverList.size()) continue;
                nextPos = 0;
            }
            throw new BehaviourException("Nessun connettore selezionabile (passive health check)");
        }
        return target;
    }

    private String getLeastConnections() {
        return this.pool.getNextConnectorLeastConnections();
    }
}

