/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.behaviour.built_in.load_balance.sticky;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.xml.XPathExpressionEngine;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.behaviour.BehaviourEmitDiagnosticException;
import org.openspcoop2.pdd.core.behaviour.BehaviourException;
import org.openspcoop2.pdd.core.behaviour.BehaviourPropertiesUtils;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.sticky.StickyConfigurazione;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.sticky.StickyCookieConfig;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.sticky.StickyResult;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.sticky.StickyTipoSelettore;
import org.openspcoop2.pdd.core.behaviour.conditional.ConditionalUtils;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.core.dynamic.ErrorHandler;
import org.openspcoop2.pdd.core.dynamic.MessageContent;
import org.openspcoop2.pdd.core.dynamic.Template;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.services.connector.FormUrlEncodedHttpServletRequest;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpServletTransportRequestContext;
import org.openspcoop2.utils.xml.AbstractXPathExpressionEngine;
import org.openspcoop2.utils.xml2json.JsonXmlPathExpressionEngine;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class StickyUtils {
    public static StickyResult getStickyResult(PortaApplicativa pa, OpenSPCoop2Message message, Busta busta, RequestInfo requestInfo, PdDContext pddContext, MsgDiagnostico msgDiag, Logger log, IState state) throws BehaviourException, BehaviourEmitDiagnosticException {
        if (!StickyUtils.isConfigurazioneSticky(pa, log)) {
            return null;
        }
        StickyResult result = new StickyResult();
        StickyConfigurazione config = StickyUtils.read(pa, log);
        StickyTipoSelettore tipoSelettore = config.getTipoSelettore();
        String patternSelettore = config.getPattern();
        Object pattern = "";
        try {
            Map pTrasporto = null;
            String urlInvocazione = null;
            Map pQuery = null;
            Map<String, List<String>> pForm = null;
            if (requestInfo != null && requestInfo.getProtocolContext() != null) {
                FormUrlEncodedHttpServletRequest formServlet;
                URLProtocolContext httpServletContext;
                HttpServletRequest httpServletRequest;
                pTrasporto = requestInfo.getProtocolContext().getHeaders();
                urlInvocazione = requestInfo.getProtocolContext().getUrlInvocazione_formBased();
                pQuery = requestInfo.getProtocolContext().getParameters();
                if (requestInfo.getProtocolContext() instanceof HttpServletTransportRequestContext && (httpServletRequest = (httpServletContext = requestInfo.getProtocolContext()).getHttpServletRequest()) != null && httpServletRequest instanceof FormUrlEncodedHttpServletRequest && (formServlet = (FormUrlEncodedHttpServletRequest)httpServletRequest).getFormUrlEncodedParametersValues() != null && !formServlet.getFormUrlEncodedParametersValues().isEmpty()) {
                    pForm = formServlet.getFormUrlEncodedParametersValues();
                }
            }
            MessageContent messageContent = null;
            boolean bufferMessage_readOnly = OpenSPCoop2Properties.getInstance().isReadByPathBufferEnabled();
            if (StickyTipoSelettore.CONTENT_BASED.equals(tipoSelettore) || tipoSelettore.isTemplate()) {
                if (ServiceBinding.SOAP.equals((Object)message.getServiceBinding())) {
                    messageContent = new MessageContent(message.castAsSoap(), bufferMessage_readOnly, (Context)pddContext);
                } else if (MessageType.XML.equals((Object)message.getMessageType())) {
                    messageContent = new MessageContent(message.castAsRestXml(), bufferMessage_readOnly, (Context)pddContext);
                } else if (MessageType.JSON.equals((Object)message.getMessageType())) {
                    messageContent = new MessageContent(message.castAsRestJson(), bufferMessage_readOnly, (Context)pddContext);
                } else if (StickyTipoSelettore.CONTENT_BASED.equals(tipoSelettore)) {
                    throw new Exception("Selettore '" + tipoSelettore.getValue() + "' non supportato per il message-type '" + message.getMessageType() + "'");
                }
            }
            msgDiag.addKeyword("@TIPO_SELETTORE@", tipoSelettore.getValue());
            msgDiag.addKeyword("@PATTERN_SELETTORE@", (String)pattern);
            String condition = null;
            switch (tipoSelettore) {
                case COOKIE_BASED: {
                    Cookie[] cookies;
                    pattern = " (Cookie: " + patternSelettore + ")";
                    msgDiag.addKeyword("@PATTERN_SELETTORE@", (String)pattern);
                    StickyCookieConfig stickyCookie = new StickyCookieConfig(patternSelettore);
                    if (requestInfo != null && requestInfo.getProtocolContext() != null && requestInfo.getProtocolContext().getHttpServletRequest() != null && (cookies = requestInfo.getProtocolContext().getHttpServletRequest().getCookies()) != null && cookies.length > 0) {
                        for (Cookie cookie : cookies) {
                            if (!cookie.getName().equalsIgnoreCase(stickyCookie.getName()) || !StringUtils.isEmpty((String)stickyCookie.getDomain()) && !stickyCookie.getDomain().equals(cookie.getDomain()) || !StringUtils.isEmpty((String)stickyCookie.getPath()) && !stickyCookie.getPath().equals(cookie.getPath())) continue;
                            condition = cookie.getValue();
                            if (cookie.getMaxAge() <= 0) break;
                            result.setMaxAgeSeconds(cookie.getMaxAge());
                            break;
                        }
                    }
                    if (condition != null) break;
                    throw new Exception("cookie non presente");
                }
                case HEADER_BASED: {
                    pattern = " (Header HTTP: " + patternSelettore + ")";
                    msgDiag.addKeyword("@PATTERN_SELETTORE@", (String)pattern);
                    condition = TransportUtils.getFirstValue((Map)pTrasporto, (String)patternSelettore);
                    if (condition != null) break;
                    throw new Exception("header non presente");
                }
                case URLBASED: {
                    pattern = " (Espressione Regolare: " + patternSelettore + ")";
                    msgDiag.addKeyword("@PATTERN_SELETTORE@", (String)pattern);
                    try {
                        condition = RegularExpressionEngine.getStringMatchPattern((String)urlInvocazione, (String)patternSelettore);
                    }
                    catch (RegExpNotFoundException cookies) {}
                    break;
                }
                case FORM_BASED: {
                    pattern = " (Parametro URL: " + patternSelettore + ")";
                    msgDiag.addKeyword("@PATTERN_SELETTORE@", (String)pattern);
                    condition = TransportUtils.getFirstValue((Map)pQuery, (String)patternSelettore);
                    if (condition != null) break;
                    throw new Exception("parametro della url non presente");
                }
                case CONTENT_BASED: {
                    XPathExpressionEngine xPathEngine = null;
                    if (messageContent == null) {
                        throw new Exception("messaggio non presente");
                    }
                    if (messageContent.isXml()) {
                        pattern = " (xPath: " + patternSelettore + ")";
                        msgDiag.addKeyword("@PATTERN_SELETTORE@", (String)pattern);
                        xPathEngine = new XPathExpressionEngine(message.getFactory());
                        condition = AbstractXPathExpressionEngine.extractAndConvertResultAsString((Element)messageContent.getElement(), (AbstractXPathExpressionEngine)xPathEngine, (String)patternSelettore, (Logger)log);
                        break;
                    }
                    pattern = " (jsonPath: " + patternSelettore + ")";
                    msgDiag.addKeyword("@PATTERN_SELETTORE@", (String)pattern);
                    condition = JsonXmlPathExpressionEngine.extractAndConvertResultAsString((String)messageContent.getElementJson(), (String)patternSelettore, (Logger)log);
                    break;
                }
                case INDIRIZZO_IP: {
                    if (pddContext == null || !pddContext.containsKey(Costanti.CLIENT_IP_REMOTE_ADDRESS)) break;
                    condition = (String)pddContext.getObject(Costanti.CLIENT_IP_REMOTE_ADDRESS);
                    break;
                }
                case INDIRIZZO_IP_FORWARDED: {
                    if (pddContext == null || !pddContext.containsKey(Costanti.CLIENT_IP_TRANSPORT_ADDRESS)) break;
                    condition = (String)pddContext.getObject(Costanti.CLIENT_IP_TRANSPORT_ADDRESS);
                    break;
                }
                case TEMPLATE: {
                    pattern = patternSelettore.length() < 50 ? " (" + patternSelettore + ")" : "";
                    msgDiag.addKeyword("@PATTERN_SELETTORE@", (String)pattern);
                    HashMap<String, Object> dynamicMap = new HashMap<String, Object>();
                    ErrorHandler errorHandler = new ErrorHandler();
                    DynamicUtils.fillDynamicMapRequest(log, dynamicMap, pddContext, urlInvocazione, message, messageContent, busta, pTrasporto, pQuery, pForm, errorHandler);
                    condition = DynamicUtils.convertDynamicPropertyValue("ConditionalConfig.gwt", patternSelettore, dynamicMap, pddContext);
                    if (condition == null) break;
                    condition = ConditionalUtils.normalizeTemplateResult(condition);
                    break;
                }
                case FREEMARKER_TEMPLATE: {
                    pattern = patternSelettore.length() < 50 ? " (" + patternSelettore + ")" : "";
                    msgDiag.addKeyword("@PATTERN_SELETTORE@", (String)pattern);
                    HashMap<String, Object> dynamicMap = new HashMap<String, Object>();
                    ErrorHandler errorHandler = new ErrorHandler();
                    DynamicUtils.fillDynamicMapRequest(log, dynamicMap, pddContext, urlInvocazione, message, messageContent, busta, pTrasporto, pQuery, pForm, errorHandler);
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance(state);
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setNome(pa.getNome());
                    Template template = configurazionePdDManager.getTemplateConnettoreMultiploSticky(idPA, patternSelettore.getBytes(), requestInfo);
                    DynamicUtils.convertFreeMarkerTemplate(template, dynamicMap, bout);
                    bout.flush();
                    bout.close();
                    condition = bout.toString();
                    if (condition == null) break;
                    condition = ConditionalUtils.normalizeTemplateResult(condition);
                    break;
                }
                case VELOCITY_TEMPLATE: {
                    pattern = patternSelettore.length() < 50 ? " (" + patternSelettore + ")" : "";
                    msgDiag.addKeyword("@PATTERN_SELETTORE@", (String)pattern);
                    HashMap<String, Object> dynamicMap = new HashMap<String, Object>();
                    ErrorHandler errorHandler = new ErrorHandler();
                    DynamicUtils.fillDynamicMapRequest(log, dynamicMap, pddContext, urlInvocazione, message, messageContent, busta, pTrasporto, pQuery, pForm, errorHandler);
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance(state);
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setNome(pa.getNome());
                    Template template = configurazionePdDManager.getTemplateConnettoreMultiploSticky(idPA, patternSelettore.getBytes(), requestInfo);
                    DynamicUtils.convertVelocityTemplate(template, dynamicMap, bout);
                    bout.flush();
                    bout.close();
                    condition = bout.toString();
                    if (condition == null) break;
                    condition = ConditionalUtils.normalizeTemplateResult(condition);
                }
            }
            if (condition == null || "".equals(condition)) {
                throw new Exception("Nessuna condizione estratta");
            }
            result.setCondition(condition);
            result.setFound(true);
            msgDiag.addKeyword("@CONDIZIONE_STICKY@", condition);
            msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "connettoriMultipli.loadBalancer.sticky.identificazioneRiuscita");
        }
        catch (Exception e) {
            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
            msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "connettoriMultipli.loadBalancer.sticky.identificazioneFallita");
        }
        if (result.isFound() && config.getMaxAgeSeconds() != null && result.getMaxAgeSeconds() == null) {
            result.setMaxAgeSeconds(config.getMaxAgeSeconds());
        }
        return result;
    }

    public static boolean isConfigurazioneSticky(PortaApplicativa pa, Logger log) {
        if (pa.getBehaviour() == null || pa.getBehaviour().sizeProprietaList() <= 0) {
            return false;
        }
        String type = null;
        for (Proprieta p : pa.getBehaviour().getProprietaList()) {
            if (!"sticky".equals(p.getNome())) continue;
            type = p.getValore();
            break;
        }
        if (type == null) {
            return false;
        }
        return "true".equals(type);
    }

    public static StickyConfigurazione read(PortaApplicativa pa, Logger log) throws BehaviourException {
        StickyConfigurazione config = new StickyConfigurazione();
        if (pa.getBehaviour() == null || pa.getBehaviour().sizeProprietaList() <= 0) {
            throw new BehaviourException("Configurazione sticky non disponibile");
        }
        for (Proprieta p : pa.getBehaviour().getProprietaList()) {
            String nome = p.getNome();
            String valore = p.getValore().trim();
            try {
                if ("sticky".equals(nome)) {
                    config.setStickyEnabled("true".equals(valore));
                    continue;
                }
                if ("sticky_selettore".equals(nome)) {
                    config.setTipoSelettore(StickyTipoSelettore.toEnumConstant(valore, true));
                    continue;
                }
                if ("sticky_pattern".equals(nome)) {
                    config.setPattern(valore);
                    continue;
                }
                if (!"sticky_expire".equals(nome)) continue;
                config.setMaxAgeSeconds(Integer.valueOf(valore));
            }
            catch (Exception e) {
                throw new BehaviourException("Configurazione sticky non corretta (propriet\u00e0:" + p.getNome() + " valore:'" + p.getValore() + "'): " + e.getMessage(), e);
            }
        }
        return config;
    }

    public static void save(PortaApplicativa pa, StickyConfigurazione configurazione) throws BehaviourException {
        if (pa.getBehaviour() == null) {
            throw new BehaviourException("Configurazione behaviour non abilitata");
        }
        if (configurazione == null) {
            throw new BehaviourException("Configurazione condizionale non fornita");
        }
        BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "sticky", "" + configurazione.isStickyEnabled());
        BehaviourPropertiesUtils.removeProprieta(pa.getBehaviour(), "sticky_selettore");
        BehaviourPropertiesUtils.removeProprieta(pa.getBehaviour(), "sticky_pattern");
        BehaviourPropertiesUtils.removeProprieta(pa.getBehaviour(), "sticky_expire");
        if (configurazione.isStickyEnabled()) {
            if (configurazione.getTipoSelettore() != null) {
                BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "sticky_selettore", configurazione.getTipoSelettore().getValue());
            }
            if (StringUtils.isNotEmpty((String)configurazione.getPattern())) {
                BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "sticky_pattern", configurazione.getPattern());
            }
            if (configurazione.getMaxAgeSeconds() != null && configurazione.getMaxAgeSeconds() > 0) {
                BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "sticky_expire", "" + configurazione.getMaxAgeSeconds());
            }
        }
    }
}

