/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativoConnettore;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.pdd.core.behaviour.BehaviourException;
import org.openspcoop2.pdd.core.behaviour.BehaviourPropertiesUtils;
import org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver.ConfigurazioneGestioneConsegnaNotifiche;
import org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver.ConfigurazioneMultiDeliver;
import org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver.GestioneConsegnaNotificheUtils;
import org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver.MessaggioDaNotificare;
import org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver.TipoGestioneNotificaFault;
import org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver.TipoGestioneNotificaTrasporto;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;

public class MultiDeliverUtils {
    private MultiDeliverUtils() {
    }

    public static ConfigurazioneMultiDeliver read(PortaApplicativa pa) throws BehaviourException {
        ConfigurazioneMultiDeliver config = new ConfigurazioneMultiDeliver();
        if (pa.getBehaviour() == null) {
            throw new BehaviourException("Configurazione non disponibile");
        }
        if (pa.getBehaviour().sizeProprietaList() > 0) {
            for (Proprieta p : pa.getBehaviour().getProprietaList()) {
                String nome = p.getNome();
                String valore = p.getValore().trim();
                try {
                    if ("md_api_connector".equals(nome)) {
                        config.setTransazioneSincrona_nomeConnettore(valore);
                        continue;
                    }
                    if ("md_notifiche_by_esito".equals(nome)) {
                        config.setNotificheByEsito("true".equals(valore));
                        continue;
                    }
                    if ("md_notifiche_by_esito_ok".equals(nome)) {
                        config.setNotificheByEsito_ok("true".equals(valore));
                        continue;
                    }
                    if ("md_notifiche_by_esito_fault".equals(nome)) {
                        config.setNotificheByEsito_fault("true".equals(valore));
                        continue;
                    }
                    if ("md_notifiche_by_esito_errori_consegna".equals(nome)) {
                        config.setNotificheByEsito_erroriConsegna("true".equals(valore));
                        continue;
                    }
                    if (!"md_notifiche_by_esito_processamento".equals(nome)) continue;
                    config.setNotificheByEsito_erroriProcessamento("true".equals(valore));
                }
                catch (Exception e) {
                    throw new BehaviourException("Configurazione condizionale non corretta (propriet\u00e0:" + p.getNome() + " valore:'" + p.getValore() + "'): " + e.getMessage(), e);
                }
            }
        }
        return config;
    }

    public static void save(PortaApplicativa pa, ConfigurazioneMultiDeliver configurazione, boolean differenziazioneConsegnaDaNotifiche) throws BehaviourException {
        if (pa == null) {
            throw new BehaviourException("Param pa is null");
        }
        if (pa.getBehaviour() == null) {
            throw new BehaviourException("Configurazione behaviour non abilitata");
        }
        if (configurazione == null) {
            throw new BehaviourException("Configurazione condizionale non fornita");
        }
        if (StringUtils.isNotEmpty((String)configurazione.getTransazioneSincrona_nomeConnettore())) {
            BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "md_api_connector", configurazione.getTransazioneSincrona_nomeConnettore());
            if (differenziazioneConsegnaDaNotifiche && pa.sizeServizioApplicativoList() > 0) {
                MultiDeliverUtils.saveNormalizeConfig(pa, configurazione);
            }
        }
        BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "md_notifiche_by_esito", "" + configurazione.isNotificheByEsito());
        BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "md_notifiche_by_esito_ok", "" + configurazione.isNotificheByEsito_ok());
        BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "md_notifiche_by_esito_fault", "" + configurazione.isNotificheByEsito_fault());
        BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "md_notifiche_by_esito_errori_consegna", "" + configurazione.isNotificheByEsito_erroriConsegna());
        BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "md_notifiche_by_esito_processamento", "" + configurazione.isNotificheByEsito_erroriProcessamento());
    }

    private static void saveNormalizeConfig(PortaApplicativa pa, ConfigurazioneMultiDeliver configurazione) {
        for (PortaApplicativaServizioApplicativo paSA : pa.getServizioApplicativoList()) {
            if (paSA.getDatiConnettore() == null) {
                paSA.setDatiConnettore(new PortaApplicativaServizioApplicativoConnettore());
            }
            if (paSA.getDatiConnettore().getNome() == null) {
                paSA.getDatiConnettore().setNome("Default");
            }
            paSA.getDatiConnettore().setNotifica(!configurazione.getTransazioneSincrona_nomeConnettore().equals(paSA.getDatiConnettore().getNome()));
        }
    }

    public static ConfigurazioneGestioneConsegnaNotifiche read(PortaApplicativaServizioApplicativo pasa) throws BehaviourException {
        ConfigurazioneGestioneConsegnaNotifiche config = new ConfigurazioneGestioneConsegnaNotifiche();
        if (pasa == null || pasa.getDatiConnettore() == null || pasa.getDatiConnettore().sizeProprietaList() == 0) {
            return GestioneConsegnaNotificheUtils.getGestioneDefault();
        }
        for (Proprieta p : pasa.getDatiConnettore().getProprietaList()) {
            MultiDeliverUtils.read(config, p);
        }
        return config;
    }

    private static void read(ConfigurazioneGestioneConsegnaNotifiche config, Proprieta p) throws BehaviourException {
        try {
            String nome = p.getNome();
            String valore = p.getValore().trim();
            if ("md_notifiche_err_cadenza".equals(nome)) {
                config.setCadenzaRispedizione(Integer.valueOf(valore));
            } else if ("md_notifiche_err_trasporto_2xx".equals(nome) || "md_notifiche_err_trasporto_2xx_codes".equals(nome) || "md_notifiche_err_trasporto_2xx_left".equals(nome) || "md_notifiche_err_trasporto_2xx_right".equals(nome)) {
                MultiDeliverUtils.read2xx(config, nome, valore);
            } else if ("md_notifiche_err_trasporto_3xx".equals(nome) || "md_notifiche_err_trasporto_3xx_codes".equals(nome) || "md_notifiche_err_trasporto_3xx_left".equals(nome) || "md_notifiche_err_trasporto_3xx_right".equals(nome)) {
                MultiDeliverUtils.read3xx(config, nome, valore);
            } else if ("md_notifiche_err_trasporto_4xx".equals(nome) || "md_notifiche_err_trasporto_4xx_codes".equals(nome) || "md_notifiche_err_trasporto_4xx_left".equals(nome) || "md_notifiche_err_trasporto_4xx_right".equals(nome)) {
                MultiDeliverUtils.read4xx(config, nome, valore);
            } else if ("md_notifiche_err_trasporto_5xx".equals(nome) || "md_notifiche_err_trasporto_5xx_codes".equals(nome) || "md_notifiche_err_trasporto_5xx_left".equals(nome) || "md_notifiche_err_trasporto_5xx_right".equals(nome)) {
                MultiDeliverUtils.read5xx(config, nome, valore);
            } else if ("md_notifiche_err_fault".equals(nome) || "md_notifiche_err_fault_code".equals(nome) || "md_notifiche_err_fault_actor".equals(nome) || "md_notifiche_err_fault_message".equals(nome)) {
                MultiDeliverUtils.readFault(config, nome, valore);
            } else if ("md_tipo_msg_da_notificare".equals(nome)) {
                MultiDeliverUtils.setMultiDeliverNotificheGestioneTipoMessaggioDaNotificare(config, valore);
            } else if ("md_inject_sync_context_da_notificare".equals(nome)) {
                MultiDeliverUtils.setMultiDeliverNotificheGestioneIniettaContestSincronoDaNotificare(config, valore);
            } else if ("md_tipo_http_notifica".equals(nome)) {
                MultiDeliverUtils.setMultiDeliverNotificheGestioneTipoHttpNotifica(config, valore);
            }
        }
        catch (Exception e) {
            throw new BehaviourException("Configurazione condizionale non corretta (propriet\u00e0:" + p.getNome() + " valore:'" + p.getValore() + "'): " + e.getMessage(), e);
        }
    }

    private static void read2xx(ConfigurazioneGestioneConsegnaNotifiche config, String nome, String valore) throws NotFoundException {
        if ("md_notifiche_err_trasporto_2xx".equals(nome)) {
            config.setGestioneTrasporto2xx(TipoGestioneNotificaTrasporto.toEnumConstant(valore, true));
        } else if ("md_notifiche_err_trasporto_2xx_codes".equals(nome)) {
            MultiDeliverUtils.setMultiDeliverNotificheGestioneErroreTipoGestioneTrasporto2xxCodeList(config, valore);
        } else if ("md_notifiche_err_trasporto_2xx_left".equals(nome)) {
            config.setGestioneTrasporto2xx_leftInterval(Integer.valueOf(valore));
        } else if ("md_notifiche_err_trasporto_2xx_right".equals(nome)) {
            config.setGestioneTrasporto2xx_rightInterval(Integer.valueOf(valore));
        }
    }

    private static void setMultiDeliverNotificheGestioneErroreTipoGestioneTrasporto2xxCodeList(ConfigurazioneGestioneConsegnaNotifiche config, String valore) {
        if (valore.contains(",")) {
            String[] tmp;
            for (String t : tmp = valore.split(",")) {
                config.getGestioneTrasporto2xx_codes().add(Integer.valueOf(t.trim()));
            }
        } else {
            config.getGestioneTrasporto2xx_codes().add(Integer.valueOf(valore));
        }
    }

    private static void read3xx(ConfigurazioneGestioneConsegnaNotifiche config, String nome, String valore) throws NotFoundException {
        if ("md_notifiche_err_trasporto_3xx".equals(nome)) {
            config.setGestioneTrasporto3xx(TipoGestioneNotificaTrasporto.toEnumConstant(valore, true));
        } else if ("md_notifiche_err_trasporto_3xx_codes".equals(nome)) {
            MultiDeliverUtils.setMultiDeliverNotificheGestioneErroreTipoGestioneTrasporto3xxCodeList(config, valore);
        } else if ("md_notifiche_err_trasporto_3xx_left".equals(nome)) {
            config.setGestioneTrasporto3xx_leftInterval(Integer.valueOf(valore));
        } else if ("md_notifiche_err_trasporto_3xx_right".equals(nome)) {
            config.setGestioneTrasporto3xx_rightInterval(Integer.valueOf(valore));
        }
    }

    private static void setMultiDeliverNotificheGestioneErroreTipoGestioneTrasporto3xxCodeList(ConfigurazioneGestioneConsegnaNotifiche config, String valore) {
        if (valore.contains(",")) {
            String[] tmp;
            for (String t : tmp = valore.split(",")) {
                config.getGestioneTrasporto3xx_codes().add(Integer.valueOf(t.trim()));
            }
        } else {
            config.getGestioneTrasporto3xx_codes().add(Integer.valueOf(valore));
        }
    }

    private static void read4xx(ConfigurazioneGestioneConsegnaNotifiche config, String nome, String valore) throws NotFoundException {
        if ("md_notifiche_err_trasporto_4xx".equals(nome)) {
            config.setGestioneTrasporto4xx(TipoGestioneNotificaTrasporto.toEnumConstant(valore, true));
        } else if ("md_notifiche_err_trasporto_4xx_codes".equals(nome)) {
            MultiDeliverUtils.setMultiDeliverNotificheGestioneErroreTipoGestioneTrasporto4xxCodeList(config, valore);
        } else if ("md_notifiche_err_trasporto_4xx_left".equals(nome)) {
            config.setGestioneTrasporto4xx_leftInterval(Integer.valueOf(valore));
        } else if ("md_notifiche_err_trasporto_4xx_right".equals(nome)) {
            config.setGestioneTrasporto4xx_rightInterval(Integer.valueOf(valore));
        }
    }

    private static void setMultiDeliverNotificheGestioneErroreTipoGestioneTrasporto4xxCodeList(ConfigurazioneGestioneConsegnaNotifiche config, String valore) {
        if (valore.contains(",")) {
            String[] tmp;
            for (String t : tmp = valore.split(",")) {
                config.getGestioneTrasporto4xx_codes().add(Integer.valueOf(t.trim()));
            }
        } else {
            config.getGestioneTrasporto4xx_codes().add(Integer.valueOf(valore));
        }
    }

    private static void read5xx(ConfigurazioneGestioneConsegnaNotifiche config, String nome, String valore) throws NotFoundException {
        if ("md_notifiche_err_trasporto_5xx".equals(nome)) {
            config.setGestioneTrasporto5xx(TipoGestioneNotificaTrasporto.toEnumConstant(valore, true));
        } else if ("md_notifiche_err_trasporto_5xx_codes".equals(nome)) {
            MultiDeliverUtils.setMultiDeliverNotificheGestioneErroreTipoGestioneTrasporto5xxCodeList(config, valore);
        } else if ("md_notifiche_err_trasporto_5xx_left".equals(nome)) {
            config.setGestioneTrasporto5xx_leftInterval(Integer.valueOf(valore));
        } else if ("md_notifiche_err_trasporto_5xx_right".equals(nome)) {
            config.setGestioneTrasporto5xx_rightInterval(Integer.valueOf(valore));
        }
    }

    private static void setMultiDeliverNotificheGestioneErroreTipoGestioneTrasporto5xxCodeList(ConfigurazioneGestioneConsegnaNotifiche config, String valore) {
        if (valore.contains(",")) {
            String[] tmp;
            for (String t : tmp = valore.split(",")) {
                config.getGestioneTrasporto5xx_codes().add(Integer.valueOf(t.trim()));
            }
        } else {
            config.getGestioneTrasporto5xx_codes().add(Integer.valueOf(valore));
        }
    }

    private static void readFault(ConfigurazioneGestioneConsegnaNotifiche config, String nome, String valore) throws NotFoundException {
        if ("md_notifiche_err_fault".equals(nome)) {
            config.setFault(TipoGestioneNotificaFault.toEnumConstant(valore, true));
        } else if ("md_notifiche_err_fault_code".equals(nome)) {
            config.setFaultCode(valore);
        } else if ("md_notifiche_err_fault_actor".equals(nome)) {
            config.setFaultActor(valore);
        } else if ("md_notifiche_err_fault_message".equals(nome)) {
            config.setFaultMessage(valore);
        }
    }

    private static void setMultiDeliverNotificheGestioneTipoMessaggioDaNotificare(ConfigurazioneGestioneConsegnaNotifiche config, String valore) throws NotFoundException {
        MessaggioDaNotificare tipo;
        if (valore != null && (tipo = MessaggioDaNotificare.toEnumConstant(valore, false)) != null) {
            config.setMessaggioDaNotificare(tipo);
        }
    }

    private static void setMultiDeliverNotificheGestioneIniettaContestSincronoDaNotificare(ConfigurazioneGestioneConsegnaNotifiche config, String valore) throws NotFoundException {
        if (valore != null) {
            config.setInjectTransactionSyncContext("true".equals(valore));
        }
    }

    private static void setMultiDeliverNotificheGestioneTipoHttpNotifica(ConfigurazioneGestioneConsegnaNotifiche config, String valore) {
        if (valore != null) {
            HttpRequestMethod tipoHttp = null;
            if (!"asRequest".equals(valore)) {
                try {
                    tipoHttp = HttpRequestMethod.valueOf((String)valore.toUpperCase());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (tipoHttp != null) {
                config.setHttpMethod(tipoHttp);
            }
        }
    }

    public static void save(PortaApplicativaServizioApplicativo pasa, ConfigurazioneGestioneConsegnaNotifiche configurazione) throws BehaviourException {
        if (pasa == null || pasa.getDatiConnettore() == null) {
            throw new BehaviourException("Configurazione behaviour non disponibile");
        }
        if (configurazione == null) {
            throw new BehaviourException("Configurazione condizionale non fornita");
        }
        if (configurazione.getCadenzaRispedizione() != null) {
            BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_notifiche_err_cadenza", "" + configurazione.getCadenzaRispedizione());
        } else {
            BehaviourPropertiesUtils.removeProprieta(pasa.getDatiConnettore(), "md_notifiche_err_cadenza");
        }
        if (configurazione.getGestioneTrasporto2xx() != null) {
            MultiDeliverUtils.save2xx(pasa, configurazione);
        }
        if (configurazione.getGestioneTrasporto3xx() != null) {
            MultiDeliverUtils.save3xx(pasa, configurazione);
        }
        if (configurazione.getGestioneTrasporto4xx() != null) {
            MultiDeliverUtils.save4xx(pasa, configurazione);
        }
        if (configurazione.getGestioneTrasporto5xx() != null) {
            MultiDeliverUtils.save5xx(pasa, configurazione);
        }
        if (configurazione.getFault() != null) {
            MultiDeliverUtils.saveFault(pasa, configurazione);
        }
        if (configurazione.getMessaggioDaNotificare() != null) {
            BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_tipo_msg_da_notificare", configurazione.getMessaggioDaNotificare().getValue());
        } else {
            BehaviourPropertiesUtils.removeProprieta(pasa.getDatiConnettore(), "md_tipo_msg_da_notificare");
        }
        if (configurazione.isInjectTransactionSyncContext()) {
            BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_inject_sync_context_da_notificare", "true");
        } else {
            BehaviourPropertiesUtils.removeProprieta(pasa.getDatiConnettore(), "md_inject_sync_context_da_notificare");
        }
        if (configurazione.getHttpMethod() != null) {
            BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_tipo_http_notifica", configurazione.getHttpMethod().name());
        } else {
            BehaviourPropertiesUtils.removeProprieta(pasa.getDatiConnettore(), "md_tipo_http_notifica");
        }
    }

    private static void save2xx(PortaApplicativaServizioApplicativo pasa, ConfigurazioneGestioneConsegnaNotifiche configurazione) throws BehaviourException {
        BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_2xx", configurazione.getGestioneTrasporto2xx().getValue());
        BehaviourPropertiesUtils.removeProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_2xx_left");
        BehaviourPropertiesUtils.removeProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_2xx_right");
        BehaviourPropertiesUtils.removeProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_2xx_codes");
        switch (configurazione.getGestioneTrasporto2xx()) {
            case CONSEGNA_COMPLETATA: 
            case CONSEGNA_FALLITA: {
                break;
            }
            case INTERVALLO_CONSEGNA_COMPLETATA: {
                if (configurazione.getGestioneTrasporto2xx_leftInterval() == null) {
                    throw new BehaviourException("[2xx] Left Interval undefined");
                }
                BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_2xx_left", "" + configurazione.getGestioneTrasporto2xx_leftInterval());
                if (configurazione.getGestioneTrasporto2xx_rightInterval() != null) {
                    BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_2xx_right", "" + configurazione.getGestioneTrasporto2xx_rightInterval());
                    break;
                }
                throw new BehaviourException("[2xx] Right Interval undefined");
            }
            case CODICI_CONSEGNA_COMPLETATA: {
                if (configurazione.getGestioneTrasporto2xx_codes() != null && !configurazione.getGestioneTrasporto2xx_codes().isEmpty()) {
                    BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_2xx_codes", MultiDeliverUtils.convertAsStringValue(configurazione.getGestioneTrasporto2xx_codes()));
                    break;
                }
                throw new BehaviourException("[2xx] Code undefined");
            }
        }
    }

    private static void save3xx(PortaApplicativaServizioApplicativo pasa, ConfigurazioneGestioneConsegnaNotifiche configurazione) throws BehaviourException {
        BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_3xx", configurazione.getGestioneTrasporto3xx().getValue());
        BehaviourPropertiesUtils.removeProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_3xx_left");
        BehaviourPropertiesUtils.removeProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_3xx_right");
        BehaviourPropertiesUtils.removeProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_3xx_codes");
        switch (configurazione.getGestioneTrasporto3xx()) {
            case CONSEGNA_COMPLETATA: 
            case CONSEGNA_FALLITA: {
                break;
            }
            case INTERVALLO_CONSEGNA_COMPLETATA: {
                if (configurazione.getGestioneTrasporto3xx_leftInterval() == null) {
                    throw new BehaviourException("[3xx] Left Interval undefined");
                }
                BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_3xx_left", "" + configurazione.getGestioneTrasporto3xx_leftInterval());
                if (configurazione.getGestioneTrasporto3xx_rightInterval() != null) {
                    BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_3xx_right", "" + configurazione.getGestioneTrasporto3xx_rightInterval());
                    break;
                }
                throw new BehaviourException("[3xx] Right Interval undefined");
            }
            case CODICI_CONSEGNA_COMPLETATA: {
                if (configurazione.getGestioneTrasporto3xx_codes() != null && !configurazione.getGestioneTrasporto3xx_codes().isEmpty()) {
                    BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_3xx_codes", MultiDeliverUtils.convertAsStringValue(configurazione.getGestioneTrasporto3xx_codes()));
                    break;
                }
                throw new BehaviourException("[3xx] Code undefined");
            }
        }
    }

    private static void save4xx(PortaApplicativaServizioApplicativo pasa, ConfigurazioneGestioneConsegnaNotifiche configurazione) throws BehaviourException {
        BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_4xx", configurazione.getGestioneTrasporto4xx().getValue());
        BehaviourPropertiesUtils.removeProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_4xx_left");
        BehaviourPropertiesUtils.removeProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_4xx_right");
        BehaviourPropertiesUtils.removeProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_4xx_codes");
        switch (configurazione.getGestioneTrasporto4xx()) {
            case CONSEGNA_COMPLETATA: 
            case CONSEGNA_FALLITA: {
                break;
            }
            case INTERVALLO_CONSEGNA_COMPLETATA: {
                if (configurazione.getGestioneTrasporto4xx_leftInterval() == null) {
                    throw new BehaviourException("[4xx] Left Interval undefined");
                }
                BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_4xx_left", "" + configurazione.getGestioneTrasporto4xx_leftInterval());
                if (configurazione.getGestioneTrasporto4xx_rightInterval() != null) {
                    BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_4xx_right", "" + configurazione.getGestioneTrasporto4xx_rightInterval());
                    break;
                }
                throw new BehaviourException("[4xx] Right Interval undefined");
            }
            case CODICI_CONSEGNA_COMPLETATA: {
                if (configurazione.getGestioneTrasporto4xx_codes() != null && !configurazione.getGestioneTrasporto4xx_codes().isEmpty()) {
                    BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_4xx_codes", MultiDeliverUtils.convertAsStringValue(configurazione.getGestioneTrasporto4xx_codes()));
                    break;
                }
                throw new BehaviourException("[4xx] Code undefined");
            }
        }
    }

    private static void save5xx(PortaApplicativaServizioApplicativo pasa, ConfigurazioneGestioneConsegnaNotifiche configurazione) throws BehaviourException {
        BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_5xx", configurazione.getGestioneTrasporto5xx().getValue());
        BehaviourPropertiesUtils.removeProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_5xx_left");
        BehaviourPropertiesUtils.removeProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_5xx_right");
        BehaviourPropertiesUtils.removeProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_5xx_codes");
        switch (configurazione.getGestioneTrasporto5xx()) {
            case CONSEGNA_COMPLETATA: 
            case CONSEGNA_FALLITA: {
                break;
            }
            case INTERVALLO_CONSEGNA_COMPLETATA: {
                if (configurazione.getGestioneTrasporto5xx_leftInterval() == null) {
                    throw new BehaviourException("[5xx] Left Interval undefined");
                }
                BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_5xx_left", "" + configurazione.getGestioneTrasporto5xx_leftInterval());
                if (configurazione.getGestioneTrasporto5xx_rightInterval() != null) {
                    BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_5xx_right", "" + configurazione.getGestioneTrasporto5xx_rightInterval());
                    break;
                }
                throw new BehaviourException("[5xx] Right Interval undefined");
            }
            case CODICI_CONSEGNA_COMPLETATA: {
                if (configurazione.getGestioneTrasporto5xx_codes() != null && !configurazione.getGestioneTrasporto5xx_codes().isEmpty()) {
                    BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_notifiche_err_trasporto_5xx_codes", MultiDeliverUtils.convertAsStringValue(configurazione.getGestioneTrasporto5xx_codes()));
                    break;
                }
                throw new BehaviourException("[5xx] Code undefined");
            }
        }
    }

    private static void saveFault(PortaApplicativaServizioApplicativo pasa, ConfigurazioneGestioneConsegnaNotifiche configurazione) {
        BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_notifiche_err_fault", configurazione.getFault().getValue());
        BehaviourPropertiesUtils.removeProprieta(pasa.getDatiConnettore(), "md_notifiche_err_fault_code");
        BehaviourPropertiesUtils.removeProprieta(pasa.getDatiConnettore(), "md_notifiche_err_fault_actor");
        BehaviourPropertiesUtils.removeProprieta(pasa.getDatiConnettore(), "md_notifiche_err_fault_message");
        switch (configurazione.getFault()) {
            case CONSEGNA_COMPLETATA: 
            case CONSEGNA_FALLITA: {
                break;
            }
            case CONSEGNA_COMPLETATA_PERSONALIZZATA: 
            case CONSEGNA_FALLITA_PERSONALIZZATA: {
                if (configurazione.getFaultCode() != null) {
                    BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_notifiche_err_fault_code", configurazione.getFaultCode());
                }
                if (configurazione.getFaultActor() != null) {
                    BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_notifiche_err_fault_actor", configurazione.getFaultActor());
                }
                if (configurazione.getFaultMessage() == null) break;
                BehaviourPropertiesUtils.addProprieta(pasa.getDatiConnettore(), "md_notifiche_err_fault_message", configurazione.getFaultMessage());
            }
        }
    }

    private static String convertAsStringValue(List<Integer> codes) {
        StringBuilder bf = new StringBuilder();
        for (Integer code : codes) {
            if (bf.length() > 0) {
                bf.append(",");
            }
            bf.append(code);
        }
        return bf.toString();
    }

    public static MessaggioDaNotificare readMessaggiNotificabili(PortaApplicativa pa, List<String> serviziApplicativiAbilitatiForwardTo) throws BehaviourException {
        BooleanNullable richiesta = BooleanNullable.NULL();
        BooleanNullable risposta = BooleanNullable.NULL();
        if (serviziApplicativiAbilitatiForwardTo != null && !serviziApplicativiAbilitatiForwardTo.isEmpty()) {
            for (PortaApplicativaServizioApplicativo pasa : pa.getServizioApplicativoList()) {
                if (!serviziApplicativiAbilitatiForwardTo.contains(pasa.getNome())) continue;
                MultiDeliverUtils.readMessaggioDaNotificare(pasa, richiesta, risposta);
                if (richiesta.getValue() == null || !richiesta.getValue().booleanValue() || risposta.getValue() == null || !risposta.getValue().booleanValue()) continue;
                break;
            }
        }
        return MultiDeliverUtils.convertToMessaggioDaNotificare(richiesta, risposta);
    }

    private static void readMessaggioDaNotificare(PortaApplicativaServizioApplicativo pasa, BooleanNullable richiesta, BooleanNullable risposta) throws BehaviourException {
        ConfigurazioneGestioneConsegnaNotifiche config = MultiDeliverUtils.read(pasa);
        if (config != null) {
            MessaggioDaNotificare check = config.getMessaggioDaNotificare();
            if (check != null) {
                switch (check) {
                    case RICHIESTA: {
                        richiesta.setValue(Boolean.valueOf(true));
                        break;
                    }
                    case RISPOSTA: {
                        risposta.setValue(Boolean.valueOf(true));
                        break;
                    }
                    case ENTRAMBI: {
                        richiesta.setValue(Boolean.valueOf(true));
                        risposta.setValue(Boolean.valueOf(true));
                    }
                }
            } else {
                richiesta.setValue(Boolean.valueOf(true));
            }
        }
    }

    private static MessaggioDaNotificare convertToMessaggioDaNotificare(BooleanNullable richiesta, BooleanNullable risposta) {
        MessaggioDaNotificare tipiMessaggiNotificabili = null;
        if (richiesta.getValue() != null && richiesta.getValue().booleanValue() && risposta.getValue() != null && risposta.getValue().booleanValue()) {
            tipiMessaggiNotificabili = MessaggioDaNotificare.ENTRAMBI;
        } else if (risposta.getValue() != null && risposta.getValue().booleanValue()) {
            tipiMessaggiNotificabili = MessaggioDaNotificare.RISPOSTA;
        } else if (richiesta.getValue() != null && richiesta.getValue().booleanValue()) {
            tipiMessaggiNotificabili = MessaggioDaNotificare.RICHIESTA;
        }
        return tipiMessaggiNotificabili;
    }

    public static boolean isSaveTransactionContext(PortaApplicativa pa, List<String> serviziApplicativiAbilitatiForwardTo) throws BehaviourException {
        if (serviziApplicativiAbilitatiForwardTo != null && !serviziApplicativiAbilitatiForwardTo.isEmpty()) {
            for (PortaApplicativaServizioApplicativo pasa : pa.getServizioApplicativoList()) {
                ConfigurazioneGestioneConsegnaNotifiche config;
                if (!serviziApplicativiAbilitatiForwardTo.contains(pasa.getNome()) || (config = MultiDeliverUtils.read(pasa)) == null || !config.isInjectTransactionSyncContext()) continue;
                return true;
            }
        }
        return false;
    }
}

