/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.behaviour.conditional;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.ModalitaIdentificazione;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.TipoBehaviour;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.xml.XPathExpressionEngine;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.Utilities;
import org.openspcoop2.pdd.core.behaviour.BehaviourEmitDiagnosticException;
import org.openspcoop2.pdd.core.behaviour.BehaviourException;
import org.openspcoop2.pdd.core.behaviour.BehaviourPropertiesUtils;
import org.openspcoop2.pdd.core.behaviour.conditional.ConditionalFilterResult;
import org.openspcoop2.pdd.core.behaviour.conditional.ConfigurazioneCondizionale;
import org.openspcoop2.pdd.core.behaviour.conditional.ConfigurazioneSelettoreCondizione;
import org.openspcoop2.pdd.core.behaviour.conditional.ConfigurazioneSelettoreCondizioneRegola;
import org.openspcoop2.pdd.core.behaviour.conditional.IdentificazioneFallitaConfigurazione;
import org.openspcoop2.pdd.core.behaviour.conditional.TipoSelettore;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.core.dynamic.ErrorHandler;
import org.openspcoop2.pdd.core.dynamic.MessageContent;
import org.openspcoop2.pdd.core.dynamic.Template;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.services.connector.FormUrlEncodedHttpServletRequest;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpServletTransportRequestContext;
import org.openspcoop2.utils.xml.AbstractXPathExpressionEngine;
import org.openspcoop2.utils.xml2json.JsonXmlPathExpressionEngine;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class ConditionalUtils {
    public static ConditionalFilterResult filter(PortaApplicativa pa, OpenSPCoop2Message message, Busta busta, RequestInfo requestInfo, PdDContext pddContext, MsgDiagnostico msgDiag, Logger log, TipoBehaviour behaviourType, IState state) throws BehaviourException, BehaviourEmitDiagnosticException {
        BehaviourEmitDiagnosticException be;
        if (!ConditionalUtils.isConfigurazioneCondizionale(pa, log)) {
            return null;
        }
        ConditionalFilterResult result = new ConditionalFilterResult();
        ConfigurazioneCondizionale config = ConditionalUtils.read(pa, log);
        String nomeRegola = null;
        TipoSelettore tipoSelettore = null;
        String patternSelettore = null;
        String prefixSelettore = null;
        String suffixSelettore = null;
        Object staticInfo = null;
        if (busta.getAzione() != null && !"".equals(busta.getAzione())) {
            ConfigurazioneSelettoreCondizioneRegola regola = null;
            Resource restResource = null;
            if (message != null && ServiceBinding.REST.equals((Object)message.getServiceBinding()) && StringUtils.isNotEmpty((String)busta.getTipoDestinatario()) && StringUtils.isNotEmpty((String)busta.getDestinatario()) && StringUtils.isNotEmpty((String)busta.getTipoServizio()) && StringUtils.isNotEmpty((String)busta.getServizio()) && busta.getVersioneServizio() != null) {
                IDServizio idServizio = null;
                try {
                    idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(busta.getTipoServizio(), busta.getServizio(), busta.getTipoDestinatario(), busta.getDestinatario(), busta.getVersioneServizio().intValue());
                    idServizio.setAzione(busta.getAzione());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (idServizio != null) {
                    restResource = Utilities.getRestResource(log, state, idServizio, requestInfo);
                }
            }
            try {
                regola = config.getRegolaByOperazione(busta.getAzione(), restResource);
            }
            catch (Exception e) {
                throw new BehaviourException(e.getMessage(), e);
            }
            if (regola != null) {
                nomeRegola = regola.getRegola();
                tipoSelettore = regola.getTipoSelettore();
                patternSelettore = regola.getPattern();
                prefixSelettore = regola.getPrefix();
                suffixSelettore = regola.getSuffix();
                staticInfo = regola.getStaticInfo();
                result.setRegola(regola.getRegola());
            }
        }
        if (tipoSelettore == null) {
            nomeRegola = null;
            ConfigurazioneSelettoreCondizione c = config.getDefaultConfig();
            tipoSelettore = c.getTipoSelettore();
            patternSelettore = c.getPattern();
            prefixSelettore = c.getPrefix();
            suffixSelettore = c.getSuffix();
        }
        result.setByFilter(config.isByFilter());
        Object condition = null;
        String nomeConnettoreDaUsare = null;
        if (staticInfo != null && !"".equals(staticInfo)) {
            condition = staticInfo;
            msgDiag.addKeyword("@TIPO_SELETTORE@", ModalitaIdentificazione.STATIC.getLabel());
            msgDiag.addKeyword("@PATTERN_SELETTORE@", "");
        } else {
            Object pattern = "";
            try {
                msgDiag.addKeyword("@TIPO_SELETTORE@", tipoSelettore.getValue());
                msgDiag.addKeyword("@PATTERN_SELETTORE@", (String)pattern);
                Map pTrasporto = null;
                String urlInvocazione = null;
                Map pQuery = null;
                Map<String, List<String>> pForm = null;
                if (requestInfo != null && requestInfo.getProtocolContext() != null) {
                    FormUrlEncodedHttpServletRequest formServlet;
                    URLProtocolContext httpServletContext;
                    HttpServletRequest httpServletRequest;
                    pTrasporto = requestInfo.getProtocolContext().getHeaders();
                    urlInvocazione = requestInfo.getProtocolContext().getUrlInvocazione_formBased();
                    pQuery = requestInfo.getProtocolContext().getParameters();
                    if (requestInfo.getProtocolContext() instanceof HttpServletTransportRequestContext && (httpServletRequest = (httpServletContext = requestInfo.getProtocolContext()).getHttpServletRequest()) != null && httpServletRequest instanceof FormUrlEncodedHttpServletRequest && (formServlet = (FormUrlEncodedHttpServletRequest)httpServletRequest).getFormUrlEncodedParametersValues() != null && !formServlet.getFormUrlEncodedParametersValues().isEmpty()) {
                        pForm = formServlet.getFormUrlEncodedParametersValues();
                    }
                }
                MessageContent messageContent = null;
                boolean bufferMessage_readOnly = OpenSPCoop2Properties.getInstance().isReadByPathBufferEnabled();
                if (TipoSelettore.CONTENT_BASED.equals(tipoSelettore) || tipoSelettore.isTemplate()) {
                    if (ServiceBinding.SOAP.equals((Object)message.getServiceBinding())) {
                        messageContent = new MessageContent(message.castAsSoap(), bufferMessage_readOnly, (Context)pddContext);
                    } else if (MessageType.XML.equals((Object)message.getMessageType())) {
                        messageContent = new MessageContent(message.castAsRestXml(), bufferMessage_readOnly, (Context)pddContext);
                    } else if (MessageType.JSON.equals((Object)message.getMessageType())) {
                        messageContent = new MessageContent(message.castAsRestJson(), bufferMessage_readOnly, (Context)pddContext);
                    } else if (TipoSelettore.CONTENT_BASED.equals(tipoSelettore)) {
                        throw new Exception("Selettore '" + tipoSelettore.getValue() + "' non supportato per il message-type '" + message.getMessageType() + "'");
                    }
                }
                switch (tipoSelettore) {
                    case HEADER_BASED: {
                        pattern = " (Header HTTP: " + patternSelettore + ")";
                        msgDiag.addKeyword("@PATTERN_SELETTORE@", (String)pattern);
                        condition = TransportUtils.getFirstValue((Map)pTrasporto, (String)patternSelettore);
                        if (condition != null) break;
                        throw new Exception("header non presente");
                    }
                    case URLBASED: {
                        pattern = " (Espressione Regolare: " + patternSelettore + ")";
                        msgDiag.addKeyword("@PATTERN_SELETTORE@", (String)pattern);
                        try {
                            condition = RegularExpressionEngine.getStringMatchPattern((String)urlInvocazione, (String)patternSelettore);
                        }
                        catch (RegExpNotFoundException formServlet) {}
                        break;
                    }
                    case FORM_BASED: {
                        pattern = " (Parametro URL: " + patternSelettore + ")";
                        msgDiag.addKeyword("@PATTERN_SELETTORE@", (String)pattern);
                        condition = TransportUtils.getFirstValue((Map)pQuery, (String)patternSelettore);
                        if (condition != null) break;
                        throw new Exception("parametro della url non presente");
                    }
                    case CONTENT_BASED: {
                        XPathExpressionEngine xPathEngine = null;
                        if (messageContent == null) {
                            throw new Exception("messaggio non presente");
                        }
                        if (messageContent.isXml()) {
                            pattern = " (xPath: " + patternSelettore + ")";
                            msgDiag.addKeyword("@PATTERN_SELETTORE@", (String)pattern);
                            xPathEngine = new XPathExpressionEngine(message.getFactory());
                            condition = AbstractXPathExpressionEngine.extractAndConvertResultAsString((Element)messageContent.getElement(), (AbstractXPathExpressionEngine)xPathEngine, (String)patternSelettore, (Logger)log);
                            break;
                        }
                        pattern = " (jsonPath: " + patternSelettore + ")";
                        msgDiag.addKeyword("@PATTERN_SELETTORE@", (String)pattern);
                        condition = JsonXmlPathExpressionEngine.extractAndConvertResultAsString((String)messageContent.getElementJson(), (String)patternSelettore, (Logger)log);
                        break;
                    }
                    case INDIRIZZO_IP: {
                        if (pddContext == null || !pddContext.containsKey(Costanti.CLIENT_IP_REMOTE_ADDRESS)) break;
                        condition = (String)pddContext.getObject(Costanti.CLIENT_IP_REMOTE_ADDRESS);
                        break;
                    }
                    case INDIRIZZO_IP_FORWARDED: {
                        if (pddContext == null || !pddContext.containsKey(Costanti.CLIENT_IP_TRANSPORT_ADDRESS)) break;
                        condition = (String)pddContext.getObject(Costanti.CLIENT_IP_TRANSPORT_ADDRESS);
                        break;
                    }
                    case SOAPACTION_BASED: {
                        if (!ServiceBinding.SOAP.equals((Object)message.getServiceBinding()) || (condition = message.castAsSoap().getSoapAction()) == null) break;
                        if (((String)(condition = ((String)condition).trim())).startsWith("\"") && ((String)condition).length() > 1) {
                            condition = ((String)condition).substring(1);
                        }
                        if (!((String)condition).endsWith("\"") || ((String)condition).length() <= 1) break;
                        condition = ((String)condition).substring(0, ((String)condition).length() - 1);
                        break;
                    }
                    case TEMPLATE: {
                        pattern = patternSelettore.length() < 50 ? " (" + patternSelettore + ")" : "";
                        msgDiag.addKeyword("@PATTERN_SELETTORE@", (String)pattern);
                        HashMap<String, Object> dynamicMap = new HashMap<String, Object>();
                        ErrorHandler errorHandler = new ErrorHandler();
                        DynamicUtils.fillDynamicMapRequest(log, dynamicMap, pddContext, urlInvocazione, message, messageContent, busta, pTrasporto, pQuery, pForm, errorHandler);
                        condition = DynamicUtils.convertDynamicPropertyValue("ConditionalConfig.gwt", patternSelettore, dynamicMap, pddContext);
                        if (condition == null) break;
                        condition = ConditionalUtils.normalizeTemplateResult((String)condition);
                        break;
                    }
                    case FREEMARKER_TEMPLATE: {
                        pattern = patternSelettore.length() < 50 ? " (" + patternSelettore + ")" : "";
                        msgDiag.addKeyword("@PATTERN_SELETTORE@", (String)pattern);
                        HashMap<String, Object> dynamicMap = new HashMap<String, Object>();
                        ErrorHandler errorHandler = new ErrorHandler();
                        DynamicUtils.fillDynamicMapRequest(log, dynamicMap, pddContext, urlInvocazione, message, messageContent, busta, pTrasporto, pQuery, pForm, errorHandler);
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance(state);
                        IDPortaApplicativa idPA = new IDPortaApplicativa();
                        idPA.setNome(pa.getNome());
                        Template template = configurazionePdDManager.getTemplateConnettoreMultiploCondizionale(idPA, nomeRegola, patternSelettore.getBytes(), requestInfo);
                        DynamicUtils.convertFreeMarkerTemplate(template, dynamicMap, bout);
                        bout.flush();
                        bout.close();
                        condition = bout.toString();
                        if (condition == null) break;
                        condition = ConditionalUtils.normalizeTemplateResult((String)condition);
                        break;
                    }
                    case VELOCITY_TEMPLATE: {
                        pattern = patternSelettore.length() < 50 ? " (" + patternSelettore + ")" : "";
                        msgDiag.addKeyword("@PATTERN_SELETTORE@", (String)pattern);
                        HashMap<String, Object> dynamicMap = new HashMap<String, Object>();
                        ErrorHandler errorHandler = new ErrorHandler();
                        DynamicUtils.fillDynamicMapRequest(log, dynamicMap, pddContext, urlInvocazione, message, messageContent, busta, pTrasporto, pQuery, pForm, errorHandler);
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance(state);
                        IDPortaApplicativa idPA = new IDPortaApplicativa();
                        idPA.setNome(pa.getNome());
                        Template template = configurazionePdDManager.getTemplateConnettoreMultiploCondizionale(idPA, nomeRegola, patternSelettore.getBytes(), requestInfo);
                        DynamicUtils.convertVelocityTemplate(template, dynamicMap, bout);
                        bout.flush();
                        bout.close();
                        condition = bout.toString();
                        if (condition == null) break;
                        condition = ConditionalUtils.normalizeTemplateResult((String)condition);
                    }
                }
                if (condition == null || "".equals(condition)) {
                    throw new Exception("Nessuna condizione estratta");
                }
                msgDiag.addKeyword("@CONDIZIONE_CONNETTORE@", (String)condition);
                msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "connettoriMultipli.consegnaCondizionale.identificazioneRiuscita");
            }
            catch (Exception e) {
                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                if (config.getCondizioneNonIdentificata().isAbortTransaction()) {
                    BehaviourEmitDiagnosticException be2 = new BehaviourEmitDiagnosticException(msgDiag, "consegnaContenutiApplicativi.", "connettoriMultipli.consegnaCondizionale.identificazioneFallita.error", (Throwable)e);
                    be2.setIntegrationFunctionError(IntegrationFunctionError.CONNECTOR_NOT_FOUND);
                    throw be2;
                }
                if (config.getCondizioneNonIdentificata().isEmitDiagnosticError()) {
                    msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "connettoriMultipli.consegnaCondizionale.identificazioneFallita.error");
                } else if (config.getCondizioneNonIdentificata().isEmitDiagnosticInfo()) {
                    msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "connettoriMultipli.consegnaCondizionale.identificazioneFallita.info");
                }
                if (TipoBehaviour.CONSEGNA_LOAD_BALANCE.equals((Object)behaviourType)) {
                    msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "connettoriMultipli.consegnaCondizionale.loadBalancer.tuttiConnettori");
                    result.setListServiziApplicativi(ConditionalUtils.getAllEnabled(pa.getServizioApplicativoList()));
                    return result;
                }
                nomeConnettoreDaUsare = config.getCondizioneNonIdentificata().getNomeConnettore();
                if (nomeConnettoreDaUsare == null || "".equals(nomeConnettoreDaUsare)) {
                    if (TipoBehaviour.CONSEGNA_MULTIPLA.equals((Object)behaviourType)) {
                        msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "connettoriMultipli.consegnaCondizionale.tuttiConnettori");
                        result.setListServiziApplicativi(ConditionalUtils.getAllEnabled(pa.getServizioApplicativoList()));
                        return result;
                    }
                    if (TipoBehaviour.CONSEGNA_CONDIZIONALE.equals((Object)behaviourType)) {
                        throw new BehaviourException("Connettore da utilizzare in caso di identificazione fallita non indicato");
                    }
                    if (TipoBehaviour.CONSEGNA_CON_NOTIFICHE.equals((Object)behaviourType)) {
                        msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "connettoriMultipli.consegnaCondizionale.tuttiConnettori");
                        result.setListServiziApplicativi(ConditionalUtils.getAllEnabled(pa.getServizioApplicativoList()));
                        return result;
                    }
                } else if (TipoBehaviour.CONSEGNA_CON_NOTIFICHE.equals((Object)behaviourType) && "##c_connettore_nessuno".equals(nomeConnettoreDaUsare)) {
                    msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "connettoriMultipli.consegnaCondizionale.nessunConnettore");
                    result.setListServiziApplicativi(new ArrayList<PortaApplicativaServizioApplicativo>());
                    return result;
                }
                result.setListServiziApplicativi(ConditionalUtils.filter(pa.getServizioApplicativoList(), false, nomeConnettoreDaUsare));
                if (result.getListServiziApplicativi().isEmpty()) {
                    throw new BehaviourException("Connettore '" + nomeConnettoreDaUsare + "' indicato, da utilizzare in caso di identificazione fallita, non esistente");
                }
                msgDiag.addKeyword("@NOME_CONNETTORE@", nomeConnettoreDaUsare);
                if (TipoBehaviour.CONSEGNA_CON_NOTIFICHE.equals((Object)behaviourType)) {
                    msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "connettoriMultipli.consegnaCondizionale.connettoreNotificaDefault");
                } else {
                    msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "connettoriMultipli.consegnaCondizionale.connettoreDefault");
                }
                return result;
            }
        }
        String conditionFinal = condition;
        if (prefixSelettore != null) {
            conditionFinal = prefixSelettore + conditionFinal;
        }
        if (suffixSelettore != null) {
            conditionFinal = conditionFinal + suffixSelettore;
        }
        result.setCondition(conditionFinal);
        msgDiag.addKeyword("@CONDIZIONE_CONNETTORE@", conditionFinal);
        List<PortaApplicativaServizioApplicativo> l = ConditionalUtils.filter(pa.getServizioApplicativoList(), config.isByFilter(), conditionFinal);
        if (!l.isEmpty()) {
            if (TipoBehaviour.CONSEGNA_CONDIZIONALE.equals((Object)behaviourType) && l.size() > 1) {
                be = new BehaviourEmitDiagnosticException(msgDiag, "consegnaContenutiApplicativi.", "connettoriMultipli.servizioSincrono.consegnaVersoNServiziApplicativi");
                be.setIntegrationFunctionError(IntegrationFunctionError.CONNECTOR_NOT_FOUND);
                throw be;
            }
            result.setListServiziApplicativi(l);
            return result;
        }
        if (config.getNessunConnettoreTrovato().isAbortTransaction()) {
            if (config.isByFilter()) {
                be = new BehaviourEmitDiagnosticException(msgDiag, "consegnaContenutiApplicativi.", "connettoriMultipli.consegnaCondizionale.connettoreNonEsistente.filtro.error");
                be.setIntegrationFunctionError(IntegrationFunctionError.CONNECTOR_NOT_FOUND);
                throw be;
            }
            be = new BehaviourEmitDiagnosticException(msgDiag, "consegnaContenutiApplicativi.", "connettoriMultipli.consegnaCondizionale.connettoreNonEsistente.nomeConnettore.error");
            be.setIntegrationFunctionError(IntegrationFunctionError.CONNECTOR_NOT_FOUND);
            throw be;
        }
        if (config.getNessunConnettoreTrovato().isEmitDiagnosticError()) {
            if (config.isByFilter()) {
                msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "connettoriMultipli.consegnaCondizionale.connettoreNonEsistente.filtro.error");
            } else {
                msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "connettoriMultipli.consegnaCondizionale.connettoreNonEsistente.nomeConnettore.error");
            }
        } else if (config.getNessunConnettoreTrovato().isEmitDiagnosticInfo()) {
            if (config.isByFilter()) {
                msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "connettoriMultipli.consegnaCondizionale.connettoreNonEsistente.filtro.info");
            } else {
                msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "connettoriMultipli.consegnaCondizionale.connettoreNonEsistente.nomeConnettore.info");
            }
        }
        if (TipoBehaviour.CONSEGNA_LOAD_BALANCE.equals((Object)behaviourType)) {
            msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "connettoriMultipli.consegnaCondizionale.loadBalancer.tuttiConnettori");
            result.setListServiziApplicativi(ConditionalUtils.getAllEnabled(pa.getServizioApplicativoList()));
            return result;
        }
        nomeConnettoreDaUsare = config.getNessunConnettoreTrovato().getNomeConnettore();
        if (nomeConnettoreDaUsare == null || "".equals(nomeConnettoreDaUsare)) {
            if (TipoBehaviour.CONSEGNA_MULTIPLA.equals((Object)behaviourType)) {
                msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "connettoriMultipli.consegnaCondizionale.nessunConnettoreIdentificato.tuttiConnettori");
                result.setListServiziApplicativi(ConditionalUtils.getAllEnabled(pa.getServizioApplicativoList()));
                return result;
            }
            if (TipoBehaviour.CONSEGNA_CONDIZIONALE.equals((Object)behaviourType)) {
                throw new BehaviourException("Connettore da utilizzare in caso di identificazione del connettore fallita non indicato");
            }
            if (TipoBehaviour.CONSEGNA_CON_NOTIFICHE.equals((Object)behaviourType)) {
                msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "connettoriMultipli.consegnaCondizionale.nessunConnettoreIdentificato.tuttiConnettoriNotifica");
                result.setListServiziApplicativi(ConditionalUtils.getAllEnabled(pa.getServizioApplicativoList()));
                return result;
            }
        } else if (TipoBehaviour.CONSEGNA_CON_NOTIFICHE.equals((Object)behaviourType) && "##c_connettore_nessuno".equals(nomeConnettoreDaUsare)) {
            msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "connettoriMultipli.consegnaCondizionale.nessunConnettoreIdentificato");
            result.setListServiziApplicativi(new ArrayList<PortaApplicativaServizioApplicativo>());
            return result;
        }
        result.setListServiziApplicativi(ConditionalUtils.filter(pa.getServizioApplicativoList(), false, nomeConnettoreDaUsare));
        if (result.getListServiziApplicativi().isEmpty()) {
            throw new BehaviourException("Connettore '" + nomeConnettoreDaUsare + "' indicato, da utilizzare in caso di identificazione condizionale fallita, non esistente");
        }
        msgDiag.addKeyword("@NOME_CONNETTORE@", nomeConnettoreDaUsare);
        if (TipoBehaviour.CONSEGNA_CON_NOTIFICHE.equals((Object)behaviourType)) {
            msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "connettoriMultipli.consegnaCondizionale.nessunConnettoreIdentificato.connettoreNotificaDefault");
        } else {
            msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "connettoriMultipli.consegnaCondizionale.nessunConnettoreIdentificato.connettoreDefault");
        }
        return result;
    }

    private static List<PortaApplicativaServizioApplicativo> filter(List<PortaApplicativaServizioApplicativo> listPASA, boolean filter, String condition) {
        ArrayList<PortaApplicativaServizioApplicativo> l = new ArrayList<PortaApplicativaServizioApplicativo>();
        for (PortaApplicativaServizioApplicativo portaApplicativaServizioApplicativo : listPASA) {
            if (portaApplicativaServizioApplicativo.getDatiConnettore() != null && portaApplicativaServizioApplicativo.getDatiConnettore().getStato() != null && !StatoFunzionalita.ABILITATO.equals((Object)portaApplicativaServizioApplicativo.getDatiConnettore().getStato())) continue;
            if (filter) {
                if (portaApplicativaServizioApplicativo.getDatiConnettore() == null || portaApplicativaServizioApplicativo.getDatiConnettore().getFiltroList() == null || !portaApplicativaServizioApplicativo.getDatiConnettore().getFiltroList().contains(condition)) continue;
                l.add(portaApplicativaServizioApplicativo);
                continue;
            }
            String nomeConnettore = "Default";
            if (portaApplicativaServizioApplicativo.getDatiConnettore() != null && portaApplicativaServizioApplicativo.getDatiConnettore().getNome() != null) {
                nomeConnettore = portaApplicativaServizioApplicativo.getDatiConnettore().getNome();
            }
            if (!condition.equals(nomeConnettore)) continue;
            l.add(portaApplicativaServizioApplicativo);
        }
        return l;
    }

    private static List<PortaApplicativaServizioApplicativo> getAllEnabled(List<PortaApplicativaServizioApplicativo> listPASA) {
        ArrayList<PortaApplicativaServizioApplicativo> l = new ArrayList<PortaApplicativaServizioApplicativo>();
        for (PortaApplicativaServizioApplicativo servizioApplicativo : listPASA) {
            if (servizioApplicativo.getDatiConnettore() != null && servizioApplicativo.getDatiConnettore().getStato() != null && !StatoFunzionalita.ABILITATO.equals((Object)servizioApplicativo.getDatiConnettore().getStato())) continue;
            l.add(servizioApplicativo);
        }
        return l;
    }

    public static String normalizeTemplateResult(String condition) {
        if (condition != null) {
            if ((condition = condition.trim()).startsWith("\n") && condition.length() > 1) {
                condition = condition.substring(1);
            }
            if (condition.endsWith("\n") && condition.length() > 1) {
                condition = condition.substring(0, condition.length() - 1);
            }
        }
        return condition;
    }

    public static boolean isConfigurazioneCondizionale(PortaApplicativa pa, Logger log) {
        if (pa.getBehaviour() == null || pa.getBehaviour().sizeProprietaList() <= 0) {
            return false;
        }
        String type = null;
        for (Proprieta p : pa.getBehaviour().getProprietaList()) {
            if (!"c_enabled".equals(p.getNome())) continue;
            type = p.getValore();
            break;
        }
        if (type == null) {
            return false;
        }
        return "true".equals(type);
    }

    public static boolean isConfigurazioneCondizionaleByFilter(PortaApplicativa pa, Logger log) {
        if (pa.getBehaviour() == null || pa.getBehaviour().sizeProprietaList() <= 0) {
            return false;
        }
        String type = null;
        String byFilter = null;
        for (Proprieta p : pa.getBehaviour().getProprietaList()) {
            if ("c_enabled".equals(p.getNome())) {
                type = p.getValore();
                continue;
            }
            if (!"c_by_filter".equals(p.getNome())) continue;
            byFilter = p.getValore();
        }
        if (type == null || byFilter == null) {
            return false;
        }
        return "true".equals(type) && "true".equals(byFilter);
    }

    public static ConfigurazioneCondizionale read(PortaApplicativa pa, Logger log) throws BehaviourException {
        ConfigurazioneCondizionale config = new ConfigurazioneCondizionale();
        if (pa.getBehaviour() == null || pa.getBehaviour().sizeProprietaList() <= 0) {
            throw new BehaviourException("Configurazione condizionale non disponibile");
        }
        ConfigurazioneSelettoreCondizione selettoreConfigurazioneDefault = new ConfigurazioneSelettoreCondizione();
        config.setDefaultConfig(selettoreConfigurazioneDefault);
        IdentificazioneFallitaConfigurazione condizioneNonIdentificata = new IdentificazioneFallitaConfigurazione();
        config.setCondizioneNonIdentificata(condizioneNonIdentificata);
        IdentificazioneFallitaConfigurazione nessunConnettoreTrovato = new IdentificazioneFallitaConfigurazione();
        config.setNessunConnettoreTrovato(nessunConnettoreTrovato);
        ArrayList<String> idRegole = new ArrayList<String>();
        for (Proprieta p : pa.getBehaviour().getProprietaList()) {
            String nome = p.getNome();
            String valore = p.getValore().trim();
            try {
                if ("c_by_filter".equals(nome)) {
                    config.setByFilter("true".equals(valore));
                    continue;
                }
                if ("c_selettore".equals(nome)) {
                    selettoreConfigurazioneDefault.setTipoSelettore(TipoSelettore.toEnumConstant(valore, true));
                    continue;
                }
                if ("c_pattern".equals(nome)) {
                    selettoreConfigurazioneDefault.setPattern(valore);
                    continue;
                }
                if ("c_prefix".equals(nome)) {
                    selettoreConfigurazioneDefault.setPrefix(valore);
                    continue;
                }
                if ("c_suffix".equals(nome)) {
                    selettoreConfigurazioneDefault.setSuffix(valore);
                    continue;
                }
                if (nome.startsWith("c_rule_") && nome.endsWith("_name")) {
                    String idRegola = nome.substring("c_rule_".length(), nome.length() - "_name".length());
                    idRegole.add(idRegola);
                    continue;
                }
                if ("c_selector_not_found_c_abort".equals(nome)) {
                    condizioneNonIdentificata.setAbortTransaction("true".equals(valore));
                    continue;
                }
                if ("c_selector_not_found_c_diag_info".equals(nome)) {
                    condizioneNonIdentificata.setEmitDiagnosticInfo("true".equals(valore));
                    continue;
                }
                if ("c_selector_not_found_c_diag_error".equals(nome)) {
                    condizioneNonIdentificata.setEmitDiagnosticError("true".equals(valore));
                    continue;
                }
                if ("c_selector_not_found_c_connettore".equals(nome)) {
                    condizioneNonIdentificata.setNomeConnettore(valore);
                    continue;
                }
                if ("c_connector_not_found_c_abort".equals(nome)) {
                    nessunConnettoreTrovato.setAbortTransaction("true".equals(valore));
                    continue;
                }
                if ("c_connector_not_found_c_diag_info".equals(nome)) {
                    nessunConnettoreTrovato.setEmitDiagnosticInfo("true".equals(valore));
                    continue;
                }
                if ("c_connector_not_found_c_diag_error".equals(nome)) {
                    nessunConnettoreTrovato.setEmitDiagnosticError("true".equals(valore));
                    continue;
                }
                if (!"c_connector_not_found_c_connettore".equals(nome)) continue;
                nessunConnettoreTrovato.setNomeConnettore(valore);
            }
            catch (Exception e) {
                throw new BehaviourException("Configurazione condizionale non corretta (propriet\u00e0:" + p.getNome() + " valore:'" + p.getValore() + "'): " + e.getMessage(), e);
            }
        }
        if (!idRegole.isEmpty()) {
            for (String idRegola : idRegole) {
                String prefixGruppo = "c_rule_" + idRegola;
                String prefixGruppoConUnderscore = prefixGruppo + "_";
                ConfigurazioneSelettoreCondizioneRegola selettoreConfigurazioneRegola = new ConfigurazioneSelettoreCondizioneRegola();
                for (Proprieta p : pa.getBehaviour().getProprietaList()) {
                    String nome = p.getNome();
                    String valore = p.getValore().trim();
                    try {
                        if ((prefixGruppo + "_name").equals(nome)) {
                            selettoreConfigurazioneRegola.setRegola(valore);
                            continue;
                        }
                        if ((prefixGruppoConUnderscore + "pattern_operazione").equals(nome)) {
                            selettoreConfigurazioneRegola.setPatternOperazione(valore);
                            continue;
                        }
                        if ((prefixGruppoConUnderscore + "static_info").equals(nome)) {
                            selettoreConfigurazioneRegola.setStaticInfo(valore);
                            continue;
                        }
                        if ((prefixGruppoConUnderscore + "c_selettore").equals(nome)) {
                            selettoreConfigurazioneRegola.setTipoSelettore(TipoSelettore.toEnumConstant(valore, true));
                            continue;
                        }
                        if ((prefixGruppoConUnderscore + "c_pattern").equals(nome)) {
                            selettoreConfigurazioneRegola.setPattern(valore);
                            continue;
                        }
                        if ((prefixGruppoConUnderscore + "c_prefix").equals(nome)) {
                            selettoreConfigurazioneRegola.setPrefix(valore);
                            continue;
                        }
                        if (!(prefixGruppoConUnderscore + "c_suffix").equals(nome)) continue;
                        selettoreConfigurazioneRegola.setSuffix(valore);
                    }
                    catch (Exception e) {
                        throw new BehaviourException("Configurazione condizionale non corretta (propriet\u00e0:" + p.getNome() + " valore:'" + p.getValore() + "'): " + e.getMessage(), e);
                    }
                }
                config.addRegola(selettoreConfigurazioneRegola);
            }
        }
        return config;
    }

    public static void save(PortaApplicativa pa, ConfigurazioneCondizionale configurazione) throws BehaviourException {
        if (pa.getBehaviour() == null) {
            throw new BehaviourException("Configurazione behaviour non abilitata");
        }
        if (configurazione == null) {
            throw new BehaviourException("Configurazione condizionale non fornita");
        }
        BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "c_enabled", "true");
        BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "c_by_filter", "" + configurazione.isByFilter());
        if (configurazione.getDefaultConfig() == null) {
            throw new BehaviourException("Configurazione selettore condizione di default non fornita");
        }
        BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "c_selettore", configurazione.getDefaultConfig().getTipoSelettore().getValue());
        if (StringUtils.isNotEmpty((String)configurazione.getDefaultConfig().getPattern())) {
            BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "c_pattern", configurazione.getDefaultConfig().getPattern());
        } else {
            BehaviourPropertiesUtils.removeProprieta(pa.getBehaviour(), "c_pattern");
        }
        if (StringUtils.isNotEmpty((String)configurazione.getDefaultConfig().getPrefix())) {
            BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "c_prefix", configurazione.getDefaultConfig().getPrefix());
        } else {
            BehaviourPropertiesUtils.removeProprieta(pa.getBehaviour(), "c_prefix");
        }
        if (StringUtils.isNotEmpty((String)configurazione.getDefaultConfig().getSuffix())) {
            BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "c_suffix", configurazione.getDefaultConfig().getSuffix());
        } else {
            BehaviourPropertiesUtils.removeProprieta(pa.getBehaviour(), "c_suffix");
        }
        ArrayList<String> listProprietaDaRimuovere = new ArrayList<String>();
        for (Proprieta p : pa.getBehaviour().getProprietaList()) {
            if (!p.getNome().startsWith("c_rule_")) continue;
            listProprietaDaRimuovere.add(p.getNome());
        }
        if (!listProprietaDaRimuovere.isEmpty()) {
            for (String propertyName : listProprietaDaRimuovere) {
                BehaviourPropertiesUtils.removeProprieta(pa.getBehaviour(), propertyName);
            }
        }
        if (configurazione.getRegoleOrdinate() != null && !configurazione.getRegoleOrdinate().isEmpty()) {
            int indexRegola = 1;
            for (String nomeRegola : configurazione.getRegoleOrdinate()) {
                String prefixRegola = "c_rule_" + indexRegola;
                BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), prefixRegola + "_name", nomeRegola);
                ConfigurazioneSelettoreCondizioneRegola regola = configurazione.getRegola(nomeRegola);
                BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), prefixRegola + "_pattern_operazione", regola.getPatternOperazione());
                if (StringUtils.isNotEmpty((String)regola.getStaticInfo())) {
                    BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), prefixRegola + "_static_info", regola.getStaticInfo());
                }
                if (regola.getTipoSelettore() != null) {
                    BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), prefixRegola + "_c_selettore", regola.getTipoSelettore().getValue());
                }
                if (StringUtils.isNotEmpty((String)regola.getPattern())) {
                    BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), prefixRegola + "_c_pattern", regola.getPattern());
                }
                if (StringUtils.isNotEmpty((String)regola.getPrefix())) {
                    BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), prefixRegola + "_c_prefix", regola.getPrefix());
                }
                if (StringUtils.isNotEmpty((String)regola.getSuffix())) {
                    BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), prefixRegola + "_c_suffix", regola.getSuffix());
                }
                ++indexRegola;
            }
        }
        if (configurazione.getCondizioneNonIdentificata() == null) {
            throw new BehaviourException("Configurazione 'condizione non identificata' non fornita");
        }
        BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "c_selector_not_found_c_abort", "" + configurazione.getCondizioneNonIdentificata().isAbortTransaction());
        BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "c_selector_not_found_c_diag_info", "" + configurazione.getCondizioneNonIdentificata().isEmitDiagnosticInfo());
        BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "c_selector_not_found_c_diag_error", "" + configurazione.getCondizioneNonIdentificata().isEmitDiagnosticError());
        if (StringUtils.isNotEmpty((String)configurazione.getCondizioneNonIdentificata().getNomeConnettore())) {
            BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "c_selector_not_found_c_connettore", configurazione.getCondizioneNonIdentificata().getNomeConnettore());
        }
        if (configurazione.getNessunConnettoreTrovato() == null) {
            throw new BehaviourException("Configurazione 'nessun connettore trovato' non fornita");
        }
        BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "c_connector_not_found_c_abort", "" + configurazione.getNessunConnettoreTrovato().isAbortTransaction());
        BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "c_connector_not_found_c_diag_info", "" + configurazione.getNessunConnettoreTrovato().isEmitDiagnosticInfo());
        BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "c_connector_not_found_c_diag_error", "" + configurazione.getNessunConnettoreTrovato().isEmitDiagnosticError());
        if (StringUtils.isNotEmpty((String)configurazione.getNessunConnettoreTrovato().getNomeConnettore())) {
            BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "c_connector_not_found_c_connettore", configurazione.getNessunConnettoreTrovato().getNomeConnettore());
        }
    }
}

