/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.byok;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.byok.BYOKUtilities;
import org.openspcoop2.core.byok.BYOKWrappedValue;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.pdd.core.byok.DriverBYOKUtilities;
import org.openspcoop2.pdd.core.dynamic.DynamicInfo;
import org.openspcoop2.pdd.core.dynamic.DynamicMapBuilderUtils;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.BYOKLocalEncrypt;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.byok.BYOKInstance;
import org.openspcoop2.utils.certificate.byok.BYOKManager;
import org.openspcoop2.utils.certificate.byok.BYOKMode;
import org.openspcoop2.utils.certificate.byok.BYOKProvider;
import org.openspcoop2.utils.certificate.byok.BYOKRemoteUtils;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;
import org.openspcoop2.utils.certificate.byok.BYOKSecurityConfig;
import org.openspcoop2.utils.certificate.byok.BYOKSecurityConfigParameter;
import org.openspcoop2.utils.transport.http.HttpRequest;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.slf4j.Logger;

public class DriverBYOK
implements IDriverBYOK {
    private Logger log;
    private String securityPolicy;
    private String securityRemotePolicy;
    private Map<String, Map<String, Object>> dynamicMapForSecurityPolicy;
    private boolean checkJmxPrefixOperazioneNonRiuscita;
    private Semaphore semaphoreDynamicMap = new Semaphore("dynamicMap");

    public DriverBYOK(Logger log, String securityPolicy, String securityRemotePolicy) {
        this(log, securityPolicy, securityRemotePolicy, DriverBYOK.buildDynamicMap(log), false);
    }

    public static Map<String, Object> buildDynamicMap(Logger log) {
        HashMap<String, Object> dynamicMap = new HashMap<String, Object>();
        DynamicInfo dynamicInfo = new DynamicInfo();
        DynamicUtils.fillDynamicMap(log, dynamicMap, dynamicInfo);
        return dynamicMap;
    }

    DriverBYOK(Logger log, String securityPolicy, String securityRemotePolicy, Map<String, Object> dynamicMapParam, boolean checkJmxPrefixOperazioneNonRiuscita) {
        this.log = log;
        if (securityPolicy != null && StringUtils.isNotEmpty((String)securityPolicy)) {
            this.securityPolicy = securityPolicy;
        }
        if (securityRemotePolicy != null && StringUtils.isNotEmpty((String)securityRemotePolicy)) {
            this.securityRemotePolicy = securityRemotePolicy;
        }
        this.dynamicMapForSecurityPolicy = new HashMap<String, Map<String, Object>>();
        HashMap defaultPolicy = dynamicMapParam == null ? new HashMap() : dynamicMapParam;
        this.dynamicMapForSecurityPolicy.put(this.securityRemotePolicy != null ? this.securityRemotePolicy : this.securityPolicy, defaultPolicy);
        this.checkJmxPrefixOperazioneNonRiuscita = checkJmxPrefixOperazioneNonRiuscita;
    }

    private Map<String, Object> getDynamicMap(String securityPolicy) throws UtilsException {
        if (!this.dynamicMapForSecurityPolicy.containsKey(securityPolicy)) {
            this.initDynamicMap(securityPolicy);
        }
        return this.dynamicMapForSecurityPolicy.get(securityPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDynamicMap(String securityPolicy) throws UtilsException {
        SemaphoreLock lock = this.semaphoreDynamicMap.acquire("initDynamicMap");
        try {
            if (!this.dynamicMapForSecurityPolicy.containsKey(securityPolicy)) {
                Map<String, Object> mDefault = this.dynamicMapForSecurityPolicy.get(this.securityRemotePolicy != null ? this.securityRemotePolicy : this.securityPolicy);
                HashMap<String, Object> mNew = new HashMap<String, Object>();
                for (Map.Entry<String, Object> entry : mDefault.entrySet()) {
                    if ("kms".equals(entry.getKey()) || "ksm".equals(entry.getKey())) continue;
                    mNew.put(entry.getKey(), entry.getValue());
                }
                this.dynamicMapForSecurityPolicy.put(securityPolicy, mNew);
            }
        }
        finally {
            this.semaphoreDynamicMap.release(lock, "initDynamicMap");
        }
    }

    public BYOKWrappedValue wrap(String value) throws UtilsException {
        if (value == null) {
            throw new UtilsException("Value undefined");
        }
        if (BYOKUtilities.isWrappedValue((String)value)) {
            return new BYOKWrappedValue(value, BYOKUtilities.extractPrefixWrappedValue((String)value));
        }
        if (this.securityPolicy == null || StringUtils.isEmpty((String)value)) {
            return null;
        }
        BYOKRequestParams p = this.getBYOKRequestParams(true, this.securityPolicy);
        String prefix = BYOKUtilities.newPrefixWrappedValue((String)(this.securityRemotePolicy != null ? this.securityRemotePolicy : this.securityPolicy));
        byte[] wrapped = this.process(this.getBYOKInstance(this.log, value.getBytes(), p));
        Object wrappedValue = new String(wrapped);
        if (!((String)wrappedValue).startsWith(prefix)) {
            wrappedValue = prefix + (String)wrappedValue;
        }
        return new BYOKWrappedValue((String)wrappedValue, prefix.substring(0, prefix.length() - 1));
    }

    public BYOKWrappedValue wrap(byte[] value) throws UtilsException {
        if (value == null) {
            throw new UtilsException("Value undefined");
        }
        if (BYOKUtilities.isWrappedValue((byte[])value)) {
            return new BYOKWrappedValue(value, BYOKUtilities.extractPrefixWrappedValue((byte[])value));
        }
        if (this.securityPolicy == null) {
            return null;
        }
        BYOKRequestParams p = this.getBYOKRequestParams(true, this.securityPolicy);
        String prefix = BYOKUtilities.newPrefixWrappedValue((String)(this.securityRemotePolicy != null ? this.securityRemotePolicy : this.securityPolicy));
        byte[] wrapped = this.process(this.getBYOKInstance(this.log, value, p));
        Object wrappedValue = new String(wrapped);
        if (!((String)wrappedValue).startsWith(prefix)) {
            wrappedValue = prefix + (String)wrappedValue;
        }
        return new BYOKWrappedValue((String)wrappedValue, prefix.substring(0, prefix.length() - 1));
    }

    public boolean isAlreadyWrappedBySecPolicy(String check) throws UtilsException {
        try {
            return this.getSecPolicyIdForUnwrap(check) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getSecPolicyIdForUnwrap(String check) throws UtilsException {
        String secPolicy = this.securityPolicy;
        String wrapPolicy = BYOKUtilities.getPolicy((String)check);
        if (!secPolicy.equals(wrapPolicy)) {
            if (BYOKManager.getInstance().existsSecurityEngineByType(wrapPolicy)) {
                secPolicy = wrapPolicy;
            } else {
                throw new UtilsException("Security policy '" + wrapPolicy + "' unknown");
            }
        }
        return secPolicy;
    }

    public byte[] unwrap(byte[] value) throws UtilsException {
        if (value == null || value.length <= 0) {
            return value;
        }
        String check = new String(value);
        if (BYOKUtilities.isWrappedValue((String)check)) {
            if (this.securityPolicy == null) {
                return value;
            }
            String rawWrappedValue = BYOKUtilities.getRawWrappedValue((String)check);
            BYOKRequestParams p = this.getBYOKRequestParams(false, this.getSecPolicyIdForUnwrap(check));
            return this.process(this.getBYOKInstance(this.log, rawWrappedValue.getBytes(), p));
        }
        return value;
    }

    public byte[] unwrap(String value) throws UtilsException {
        return this.unwrap(value, null, false);
    }

    public byte[] unwrap(String value, boolean checkAppendPrefix) throws UtilsException {
        return this.unwrap(value, this.securityRemotePolicy != null ? this.securityRemotePolicy : this.securityPolicy, checkAppendPrefix);
    }

    public byte[] unwrap(String value, String securityPolicy, boolean checkAppendPrefix) throws UtilsException {
        if (BYOKUtilities.isWrappedValue((String)value)) {
            if (this.securityPolicy == null) {
                return value.getBytes();
            }
            String rawWrappedValue = BYOKUtilities.getRawWrappedValue((String)value);
            BYOKRequestParams p = this.getBYOKRequestParams(false, this.getSecPolicyIdForUnwrap(value));
            return this.process(this.getBYOKInstance(this.log, rawWrappedValue.getBytes(), p));
        }
        if (checkAppendPrefix) {
            String newWrappedValue = BYOKUtilities.newPrefixWrappedValue((String)securityPolicy) + value;
            return this.unwrap(newWrappedValue);
        }
        return value.getBytes();
    }

    public String unwrapAsString(String value, boolean checkAppendPrefix) throws UtilsException {
        return this.unwrapAsString(value, this.securityRemotePolicy != null ? this.securityRemotePolicy : this.securityPolicy, checkAppendPrefix);
    }

    public String unwrapAsString(String value, String securityPolicy, boolean checkAppendPrefix) throws UtilsException {
        if (BYOKUtilities.isWrappedValue((String)value)) {
            return this.unwrapAsString(value);
        }
        if (checkAppendPrefix) {
            String unwrappedValue;
            String newWrappedValue = BYOKUtilities.newPrefixWrappedValue((String)securityPolicy) + value;
            if (newWrappedValue.equals(unwrappedValue = this.unwrapAsString(newWrappedValue))) {
                return value;
            }
            return unwrappedValue;
        }
        return value;
    }

    private BYOKInstance getBYOKInstance(Logger log, byte[] key, BYOKRequestParams p) throws UtilsException {
        return BYOKInstance.newInstance((Logger)log, (BYOKRequestParams)p, (byte[])key);
    }

    private BYOKRequestParams getBYOKRequestParams(boolean wrap, String securityPolicy) throws UtilsException {
        return DriverBYOK.getBYOKRequestParamsBySecurityPolicy(wrap, securityPolicy, this.getDynamicMap(securityPolicy));
    }

    public static BYOKRequestParams getBYOKRequestParamsBySecurityPolicy(boolean wrap, String securityPolicy, Map<String, Object> dynamicMap) throws UtilsException {
        String kmsId;
        if (securityPolicy == null) {
            return null;
        }
        BYOKManager manager = BYOKManager.getInstance();
        if (manager == null) {
            throw new UtilsException("BYOKManager not initialized");
        }
        BYOKSecurityConfig secConfig = manager.getKMSSecurityConfig(securityPolicy);
        String string = kmsId = wrap ? secConfig.getWrapId() : secConfig.getUnwrapId();
        if (kmsId == null) {
            throw new UtilsException("BYOK security configuration '" + securityPolicy + "' without " + (wrap ? "wrap" : "unwrap") + " kms id");
        }
        HashMap<String, String> inputMap = new HashMap<String, String>();
        if (secConfig.getInputParameters() != null && !secConfig.getInputParameters().isEmpty()) {
            for (BYOKSecurityConfigParameter sec : secConfig.getInputParameters()) {
                inputMap.put(sec.getName(), sec.getValue());
            }
        }
        return DriverBYOK.getBYOKRequestParamsByKmsId(kmsId, manager, inputMap, dynamicMap);
    }

    public static BYOKRequestParams getBYOKRequestParamsByUnwrapBYOKPolicy(String kmsId, Busta busta, RequestInfo requestInfo, Context context, Logger log) throws UtilsException {
        if (BYOKProvider.isPolicyDefined((String)kmsId)) {
            Map<String, Object> dynamicMap = DynamicMapBuilderUtils.buildDynamicMap(busta, requestInfo, context, log);
            return BYOKProvider.getBYOKRequestParamsByUnwrapBYOKPolicy((String)kmsId, dynamicMap);
        }
        return null;
    }

    public static BYOKRequestParams getBYOKRequestParamsByKmsId(String kmsId, Map<String, String> inputMap, Map<String, Object> dynamicMap) throws UtilsException {
        return BYOKRequestParams.getBYOKRequestParamsByKmsId((String)kmsId, inputMap, dynamicMap);
    }

    public static BYOKRequestParams getBYOKRequestParamsByKmsId(String kmsId, BYOKManager manager, Map<String, String> inputMap, Map<String, Object> dynamicMap) throws UtilsException {
        return BYOKRequestParams.getBYOKRequestParamsByKmsId((String)kmsId, (BYOKManager)manager, inputMap, dynamicMap);
    }

    private byte[] process(BYOKInstance instance) throws UtilsException {
        return DriverBYOK.processInstance(instance, this.checkJmxPrefixOperazioneNonRiuscita);
    }

    public static byte[] processInstance(BYOKInstance instance, boolean checkJmxPrefixOperazioneNonRiuscita) throws UtilsException {
        try {
            if (instance == null) {
                throw new SecurityException("Instance non fornita");
            }
            if (instance.getHttpRequest() != null) {
                return DriverBYOK.remoteProcess(instance, checkJmxPrefixOperazioneNonRiuscita);
            }
            BYOKLocalEncrypt localEncrypt = new BYOKLocalEncrypt();
            if (BYOKMode.WRAP.equals((Object)instance.getConfig().getMode())) {
                return localEncrypt.wrap(instance.getLocalConfigResolved(), instance.getLocalKey()).getBytes();
            }
            return localEncrypt.unwrap(instance.getLocalConfigResolved(), instance.getLocalKey());
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    private static byte[] remoteProcess(BYOKInstance instance, boolean checkJmxPrefixOperazioneNonRiuscita) throws UtilsException {
        String debugUrl = "'" + instance.getConfig().getLabel() + "' (endpoint:" + instance.getHttpRequest().getUrl() + ")";
        HttpResponse httpResponse = HttpUtilities.httpInvoke((HttpRequest)instance.getHttpRequest());
        if (httpResponse == null || httpResponse.getContent() == null) {
            throw new UtilsException("Store " + debugUrl + " unavailable");
        }
        if (httpResponse.getResultHTTPOperation() != 200) {
            throw new UtilsException("Retrieve store " + debugUrl + " failed (returnCode:" + httpResponse.getResultHTTPOperation() + ")");
        }
        byte[] content = null;
        if (checkJmxPrefixOperazioneNonRiuscita) {
            byte[] b = httpResponse.getContent();
            if (b == null || b.length <= 0) {
                throw new UtilsException("Store " + debugUrl + " empty response");
            }
            String check = new String(b);
            if (check.startsWith("Operazione non riuscita: ")) {
                throw new UtilsException("Retrieve store " + debugUrl + " failed (returnCode:" + httpResponse.getResultHTTPOperation() + "): " + check);
            }
            content = b;
        } else {
            content = httpResponse.getContent();
        }
        if (content != null && content.length > 0) {
            content = BYOKRemoteUtils.normalizeResponse((BYOKInstance)instance, (byte[])content, (Logger)LoggerWrapperFactory.getLogger(DriverBYOK.class));
        }
        return content;
    }

    public boolean isWrappedWithInternalPolicy(byte[] value) {
        if (value == null || value.length <= 0) {
            return false;
        }
        return this.isWrappedWithInternalPolicy(new String(value));
    }

    public boolean isWrappedWithInternalPolicy(String value) {
        String policy = this.securityRemotePolicy != null ? this.securityRemotePolicy : this.securityPolicy;
        return DriverBYOKUtilities.isWrappedWithPolicy(this.log, value, policy);
    }
}

