/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.byok;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.byok.BYOKUtilities;
import org.openspcoop2.core.byok.BYOKWrappedValue;
import org.openspcoop2.pdd.config.ConfigurazioneNodiRuntime;
import org.openspcoop2.pdd.config.ConfigurazioneNodiRuntimeBYOKRemoteConfig;
import org.openspcoop2.pdd.core.byok.DriverBYOK;
import org.openspcoop2.pdd.core.dynamic.DynamicInfo;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.byok.BYOKManager;
import org.slf4j.Logger;

public class DriverBYOKUtilities {
    private Logger log;
    private ConfigurazioneNodiRuntime configurazioneNodiRuntime;
    private boolean nodoruntime;
    private boolean initFromJmx = false;

    public static DriverBYOK newInstanceDriverBYOKRuntimeNode(Logger log, boolean wrap, boolean unwrap) throws UtilsException {
        return DriverBYOKUtilities.newInstanceDriverBYOKRuntimeNode(log, wrap, unwrap, false);
    }

    public static DriverBYOK newInstanceDriverBYOKRuntimeNodeForJmxOperation(Logger log, boolean wrap, boolean unwrap) throws UtilsException {
        return DriverBYOKUtilities.newInstanceDriverBYOKRuntimeNode(log, wrap, unwrap, true);
    }

    private static DriverBYOK newInstanceDriverBYOKRuntimeNode(Logger log, boolean wrap, boolean unwrap, boolean initFromJmx) throws UtilsException {
        String securityRuntimePolicy = BYOKManager.getSecurityEngineGovWayPolicy();
        if (securityRuntimePolicy != null) {
            DriverBYOKUtilities utils = new DriverBYOKUtilities(log);
            utils.setInitFromJmx(initFromJmx);
            return utils.getDriverBYOKRuntimeNode(wrap, unwrap);
        }
        return null;
    }

    public void setInitFromJmx(boolean initFromJmx) {
        this.initFromJmx = initFromJmx;
    }

    public DriverBYOKUtilities(Logger log) {
        this.log = log;
        this.nodoruntime = true;
    }

    public DriverBYOKUtilities(boolean nodoruntime, Logger log, ConfigurazioneNodiRuntime config) {
        this.log = log;
        this.configurazioneNodiRuntime = config;
        this.nodoruntime = nodoruntime;
    }

    public DriverBYOK getDriverBYOK(boolean wrap, boolean unwrap) throws UtilsException {
        return this.nodoruntime ? this.getDriverBYOKRuntimeNode(wrap, unwrap) : this.getDriverBYOKManagerNode(wrap, unwrap);
    }

    public DriverBYOK getDriverBYOKRuntimeNode(boolean wrap, boolean unwrap) throws UtilsException {
        String securityManagerPolicy = BYOKManager.getSecurityRemoteEngineGovWayPolicy();
        if (securityManagerPolicy == null || StringUtils.isEmpty((String)securityManagerPolicy)) {
            securityManagerPolicy = BYOKManager.getSecurityEngineGovWayPolicy();
        }
        return this.getDriverBYOK(securityManagerPolicy, null, wrap, unwrap);
    }

    public DriverBYOK getDriverBYOKManagerNode(boolean wrap, boolean unwrap) throws UtilsException {
        return this.getDriverBYOK(BYOKManager.getSecurityEngineGovWayPolicy(), BYOKManager.getSecurityRemoteEngineGovWayPolicy(), wrap, unwrap);
    }

    private DriverBYOK getDriverBYOK(String securityManagerPolicy, String securityManagerRemotePolicy, boolean wrap, boolean unwrap) throws UtilsException {
        if (securityManagerPolicy != null && StringUtils.isNotEmpty((String)securityManagerPolicy)) {
            HashMap<String, Object> dynamicMap = new HashMap<String, Object>();
            DynamicInfo dynamicInfo = new DynamicInfo();
            DynamicUtils.fillDynamicMap(this.log, dynamicMap, dynamicInfo, this.initFromJmx);
            if (securityManagerRemotePolicy != null && StringUtils.isNotEmpty((String)securityManagerRemotePolicy) && !securityManagerPolicy.equals(securityManagerRemotePolicy) && this.isBYOKRemoteGovWayNodeConfig(securityManagerPolicy, wrap, unwrap)) {
                this.initBYOKDynamicMapRemoteGovWayNode(dynamicMap, wrap, unwrap);
            }
            return new DriverBYOK(this.log, securityManagerPolicy, securityManagerRemotePolicy, dynamicMap, true);
        }
        return null;
    }

    private boolean isBYOKRemoteGovWayNodeConfig(String securityManagerPolicy, boolean wrap, boolean unwrap) throws UtilsException {
        BYOKManager byokManager = BYOKManager.getInstance();
        if (byokManager != null) {
            return byokManager.isBYOKRemoteGovWayNodeConfig(securityManagerPolicy, wrap, unwrap);
        }
        return false;
    }

    private void initBYOKDynamicMapRemoteGovWayNode(Map<String, Object> dynamicMap, boolean wrap, boolean unwrap) {
        ConfigurazioneNodiRuntimeBYOKRemoteConfig remoteConfig = new ConfigurazioneNodiRuntimeBYOKRemoteConfig();
        this.configurazioneNodiRuntime.initBYOKDynamicMapRemoteGovWayNode(this.log, dynamicMap, wrap, unwrap, remoteConfig);
    }

    public String wrap(String value) throws UtilsException {
        try {
            if (value == null || StringUtils.isEmpty((String)value)) {
                return value;
            }
            DriverBYOK driverBYOK = this.getDriverBYOK(true, false);
            if (driverBYOK == null) {
                return value;
            }
            BYOKWrappedValue v = driverBYOK.wrap(value);
            if (v != null && v.getWrappedValue() != null) {
                return v.getWrappedValue();
            }
            throw new UtilsException("Wrap value failed");
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public String unwrap(String value) throws UtilsException {
        try {
            if (value == null || StringUtils.isEmpty((String)value)) {
                return value;
            }
            DriverBYOK driverBYOK = this.getDriverBYOK(false, true);
            if (driverBYOK == null) {
                return value;
            }
            return driverBYOK.unwrapAsString(value);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public byte[] wrap(byte[] value) throws UtilsException {
        try {
            if (value == null || value.length <= 0) {
                return value;
            }
            DriverBYOK driverBYOK = this.getDriverBYOK(true, false);
            if (driverBYOK == null) {
                return value;
            }
            BYOKWrappedValue v = driverBYOK.wrap(value);
            if (v != null && v.getWrappedValue() != null) {
                return v.getWrappedValue().getBytes();
            }
            throw new UtilsException("Wrap value failed");
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public byte[] unwrap(byte[] value) throws UtilsException {
        try {
            if (value == null || value.length <= 0) {
                return value;
            }
            DriverBYOK driverBYOK = this.getDriverBYOK(false, true);
            if (driverBYOK == null) {
                return value;
            }
            return driverBYOK.unwrap(value);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isWrappedWithAnyPolicy(String value) {
        if (value != null && StringUtils.isNotEmpty((String)value)) {
            return BYOKUtilities.isWrappedValue((String)value);
        }
        return false;
    }

    public boolean isWrappedWithActivePolicy(String value) {
        String driverSecurityManagerPolicy = null;
        try {
            if (value == null || StringUtils.isEmpty((String)value) || !this.isEnabledBYOK()) {
                return false;
            }
            String securityManagerPolicy = BYOKManager.getSecurityEngineGovWayPolicy();
            driverSecurityManagerPolicy = BYOKManager.getSecurityRemoteEngineGovWayPolicy();
            if (driverSecurityManagerPolicy == null || StringUtils.isEmpty((String)driverSecurityManagerPolicy)) {
                driverSecurityManagerPolicy = securityManagerPolicy;
            }
        }
        catch (Exception e) {
            this.log.error("isWrapped failed [" + value + "]: " + e.getMessage(), (Throwable)e);
            return false;
        }
        return DriverBYOKUtilities.isWrappedWithPolicy(this.log, value, driverSecurityManagerPolicy);
    }

    public static boolean isWrappedWithPolicy(Logger log, String value, String policy) {
        try {
            if (value == null || StringUtils.isEmpty((String)value)) {
                return false;
            }
            String prefix = BYOKUtilities.newPrefixWrappedValue((String)policy);
            return value.startsWith(prefix) && value.length() > prefix.length();
        }
        catch (Exception e) {
            log.error("isWrapped failed [" + value + "]: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean isEnabledBYOK() {
        return BYOKManager.isEnabledBYOK();
    }
}

