/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.util.Map;
import org.openspcoop2.core.config.InvocazioneCredenziali;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.pdd.core.connettori.ConnettoreBase;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.messages.DirectVMConnectorInMessage;
import org.openspcoop2.pdd.services.connector.messages.DirectVMConnectorOutMessage;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.IDService;

public abstract class AbstractConnettoreDirectVM
extends ConnettoreBase {
    @Override
    public String getProtocollo() {
        return "VM";
    }

    @Override
    protected boolean initializePreSend(ResponseCachingConfigurazione responseCachingConfig, ConnettoreMsg request) {
        return this.initialize(request, true, responseCachingConfig);
    }

    @Override
    protected boolean send(ConnettoreMsg request) {
        IProtocolFactory<?> pFactory = null;
        try {
            pFactory = this.buildProtocolFactoryForForwardMessage(this.properties);
        }
        catch (Exception e) {
            this.errore = this.readExceptionMessageFromException(e);
            return false;
        }
        if (this.credenziali == null) {
            String user = (String)this.properties.get("user");
            String password = (String)this.properties.get("password");
            if (user != null || password != null) {
                this.credenziali = new InvocazioneCredenziali();
                this.credenziali.setUser(user);
                this.credenziali.setPassword(password);
            }
        }
        if (this.validate(request)) {
            try {
                if (this.debug) {
                    this.logger.debug("Creazione URL...");
                }
                this.buildLocation(this.properties, true);
            }
            catch (Exception e) {
                this.errore = this.readExceptionMessageFromException(e);
                return false;
            }
            return this.sendByVM(pFactory);
        }
        return false;
    }

    private IProtocolFactory<?> buildProtocolFactoryForForwardMessage(Map<String, String> properties) throws Exception {
        IProtocolFactory pFactory = this.getProtocolFactory();
        String protocol = properties.get("protocol");
        if (protocol != null) {
            try {
                pFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocol);
            }
            catch (Exception e) {
                throw new Exception("Proprieta' 'protocol' fornita contiene un tipo di protocollo [" + protocol + "] non valido: " + e.getMessage());
            }
        }
        return pFactory;
    }

    public void buildLocation(Map<String, String> properties, boolean setFormBasedParameter) throws Exception {
        IProtocolFactory<?> pFactory = this.buildProtocolFactoryForForwardMessage(properties);
        String webContext = "openspcoop2";
        String context = properties.get("context");
        if (context != null) {
            webContext = context;
        }
        this.location = "/" + webContext + "/" + pFactory.getProtocol() + "/" + this.getFunction();
        String suffix = this.getFunctionParameters();
        if (suffix != null && !"".equals(suffix)) {
            this.location = this.location + "/" + suffix;
        }
        if (setFormBasedParameter) {
            // empty if block
        }
    }

    /*
     * Exception decompiling
     */
    private boolean sendByVM(IProtocolFactory<?> pFactory) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public abstract boolean validate(ConnettoreMsg var1);

    public abstract String getFunctionParameters();

    public abstract String getIdModulo();

    public abstract IDService getIdModuloAsIDService();

    public abstract String getFunction();

    public abstract void process(DirectVMConnectorInMessage var1, DirectVMConnectorOutMessage var2) throws ConnectorException;

    protected String normalizeFunctionParamters(String value) {
        if (value == null) {
            return null;
        }
        if (value.contains("?")) {
            return value.substring(0, value.indexOf("?"));
        }
        return value;
    }
}

