/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.InvocazioneCredenziali;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.config.ResponseCachingConfigurazioneControl;
import org.openspcoop2.core.config.ResponseCachingConfigurazioneRegola;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageProperties;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.ParseExceptionUtils;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.Utilities;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreLogger;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.connettori.DumpRaw;
import org.openspcoop2.pdd.core.connettori.IConnettore;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreUscita;
import org.openspcoop2.pdd.core.controllo_traffico.PolicyTimeoutConfig;
import org.openspcoop2.pdd.core.controllo_traffico.SogliaDimensioneMessaggio;
import org.openspcoop2.pdd.core.dynamic.DynamicInfo;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.core.handlers.GestoreHandlers;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.OutRequestContext;
import org.openspcoop2.pdd.core.handlers.PostOutRequestContext;
import org.openspcoop2.pdd.core.handlers.PreInResponseContext;
import org.openspcoop2.pdd.core.response_caching.GestoreCacheResponseCaching;
import org.openspcoop2.pdd.core.response_caching.ResponseCached;
import org.openspcoop2.pdd.core.token.EsitoNegoziazioneToken;
import org.openspcoop2.pdd.core.token.GestoreToken;
import org.openspcoop2.pdd.core.token.NegoziazioneTokenDynamicParameters;
import org.openspcoop2.pdd.core.token.PolicyNegoziazioneToken;
import org.openspcoop2.pdd.core.token.TokenException;
import org.openspcoop2.pdd.core.token.dpop.DPoPParams;
import org.openspcoop2.pdd.core.token.dpop.EsitoDPoPBackend;
import org.openspcoop2.pdd.core.token.dpop.InformazioniJWTDpop;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.core.transazioni.TransactionNotExistsException;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.transazioni.ConfigurazioneTracciamento;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.dump.DumpException;
import org.openspcoop2.protocol.sdk.dump.Messaggio;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.protocol.utils.ModIValidazioneSemanticaProfiloSicurezza;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.NameValue;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateTimeFormatterWrapper;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.slf4j.Logger;

public abstract class ConnettoreBase
extends AbstractCore
implements IConnettore {
    public static final MapKey<String> RESPONSE_FROM_CACHE = org.openspcoop2.utils.Map.newMapKey((String)"RESPONSE_READED_FROM_CACHE");
    public static final String LOCATION_CACHED = "govway://responseCaching";
    public static final String LOCATION_CACHED_SEPARATOR_REQUEST_URL = "\n";
    protected Map<String, String> properties;
    protected String tipoConnettore;
    protected OpenSPCoop2Message requestMsg;
    protected boolean isSoap = false;
    protected boolean isRest = false;
    protected boolean sbustamentoSoap;
    protected Map<String, List<String>> propertiesTrasporto;
    protected Map<String, List<String>> propertiesUrlBased;
    protected InvocazioneCredenziali credenziali;
    protected Busta busta;
    protected boolean debug = false;
    protected OpenSPCoop2Properties openspcoopProperties = null;
    protected String idMessaggio;
    protected ConnettoreLogger logger = null;
    protected Loader loader = null;
    protected boolean generateErrorWithConnectorPrefix = true;
    protected String idModulo = null;
    protected String errore = null;
    protected OpenSPCoop2Message responseMsg = null;
    protected int codice;
    protected long contentLength = -1L;
    protected String location = null;
    protected Exception eccezioneProcessamento = null;
    protected Map<String, List<String>> propertiesTrasportoRisposta = new HashMap<String, List<String>>();
    protected Date creationDate;
    protected MsgDiagnostico msgDiagnostico;
    protected OutRequestContext outRequestContext;
    protected PostOutRequestContext postOutRequestContext;
    protected PreInResponseContext preInResponseContext;
    protected IState state;
    protected String soapAction = null;
    protected RequestInfo requestInfo;
    private boolean responseAlready = false;
    private ResponseCachingConfigurazione responseCachingConfig = null;
    private String responseCachingDigest = null;
    private PolicyNegoziazioneToken policyNegoziazioneToken;
    private String dpopBackendProof;
    private EsitoNegoziazioneToken cachedEsitoNegoziazioneToken;
    protected PolicyTimeoutConfig policyTimeoutConfig;
    protected Date dataRichiestaInoltrata;
    protected Date dataAccettazioneRisposta;
    protected DumpRaw dumpRaw = null;
    protected boolean logFileTrace_headers = false;
    protected boolean logFileTrace_payload = false;
    private boolean registerSendIntoContext = true;
    private IDAccordo idAccordo = null;
    protected String idTransazione;
    protected int dumpBinario_soglia;
    protected File dumpBinario_repositoryFile;
    protected PortaApplicativa pa;
    protected String nomeConnettoreAsincrono;
    protected PortaDelegata pd;
    protected boolean useTimeoutInputStream = false;
    protected boolean useLimitedInputStream = false;
    protected SogliaDimensioneMessaggio limitBytes = null;
    protected boolean useDiagnosticInputStream = false;
    protected List<Proprieta> proprietaPorta;
    private static final String format = "yyyy-MM-dd HH:mm:ss.SSS";
    private ModIValidazioneSemanticaProfiloSicurezza modIValidazioneSemanticaProfiloSicurezza;
    private InfoConnettoreUscita infoConnettoreUscita = null;
    protected Map<String, Object> dynamicMap = null;
    private Map<String, List<String>> headersImpostati = new HashMap<String, List<String>>();
    private Messaggio messaggioDumpUscita = null;
    private boolean emitDiagnosticResponseRead = false;

    @Override
    public Date getDataRichiestaInoltrata() {
        return this.dataRichiestaInoltrata;
    }

    @Override
    public Date getDataAccettazioneRisposta() {
        return this.dataAccettazioneRisposta;
    }

    public void setRegisterSendIntoContext(boolean registerSendIntoContext) {
        this.registerSendIntoContext = registerSendIntoContext;
    }

    protected IDAccordo getIdAccordo() {
        return this.idAccordo;
    }

    protected ConnettoreBase() {
        this.creationDate = DateManager.getDate();
    }

    public void setPa(PortaApplicativa pa) {
        this.pa = pa;
    }

    public void setPd(PortaDelegata pd) {
        this.pd = pd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected boolean initialize(ConnettoreMsg request, boolean connectorPropertiesRequired, ResponseCachingConfigurazione responseCachingConfig) {
        this.openspcoopProperties = OpenSPCoop2Properties.getInstance();
        this.loader = Loader.getInstance();
        if (request == null) {
            this.errore = "Messaggio da consegnare is Null (ConnettoreMsg)";
            return false;
        }
        this.properties = request.getConnectorProperties();
        if (connectorPropertiesRequired) {
            if (this.properties == null) {
                this.errore = "Proprieta' del connettore non definite";
            } else if (this.properties.size() == 0) {
                this.errore = "Proprieta' del connettore non definite";
            }
        }
        this.tipoConnettore = request.getTipoConnettore();
        this.generateErrorWithConnectorPrefix = request.isGenerateErrorWithConnectorPrefix();
        this.busta = request.getBusta();
        if (this.busta != null) {
            this.idMessaggio = this.busta.getID();
        }
        if (this.properties != null && this.properties.get("debug") != null && "true".equalsIgnoreCase(this.properties.get("debug").trim())) {
            this.debug = true;
        }
        this.logger = new ConnettoreLogger(this.debug, this.idMessaggio, this.getPddContext());
        if (this.getPddContext() != null && this.getPddContext().containsKey(Costanti.REQUEST_INFO)) {
            this.requestInfo = (RequestInfo)this.getPddContext().getObject(Costanti.REQUEST_INFO);
        }
        this.state = request.getState();
        try {
            this.requestMsg = request.getRequestMessage(this.requestInfo, this.getPddContext());
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.logger.error("Errore durante la lettura del messaggio da consegnare: " + this.readExceptionMessageFromException(e), e);
            this.errore = "Errore durante la lettura del messaggio da consegnare: " + this.readExceptionMessageFromException(e);
            return false;
        }
        if (this.requestMsg == null) {
            this.errore = "Messaggio da consegnare is Null (Msg)";
            return false;
        }
        if (ServiceBinding.SOAP.equals((Object)this.requestMsg.getServiceBinding())) {
            this.isSoap = true;
        } else {
            this.isRest = true;
        }
        this.sbustamentoSoap = request.isSbustamentoSOAP();
        this.propertiesTrasporto = request.getPropertiesTrasporto();
        this.propertiesUrlBased = request.getPropertiesUrlBased();
        this.credenziali = request.getCredenziali();
        this.idModulo = request.getIdModulo();
        this.policyTimeoutConfig = request.getPolicyTimeoutConfig();
        this.outRequestContext = request.getOutRequestContext();
        this.msgDiagnostico = request.getMsgDiagnostico();
        if (this.getPddContext() != null && this.getPddContext().containsKey(Costanti.LIMITED_STREAM) && (o = this.getPddContext().getObject(Costanti.LIMITED_STREAM)) != null && o instanceof SogliaDimensioneMessaggio) {
            try {
                soglia = (SogliaDimensioneMessaggio)o;
                if (soglia != null && soglia.getSogliaKb() > 0L) {
                    this.useLimitedInputStream = true;
                    this.limitBytes = soglia;
                }
            }
            catch (Throwable soglia) {
                // empty catch block
            }
        }
        this.useTimeoutInputStream = this.openspcoopProperties.isConnettoriUseTimeoutInputStream();
        dumpBinario = this.debug;
        dumpConfigurazione = null;
        protocol = this.getProtocolFactory() != null ? this.getProtocolFactory().getProtocol() : null;
        dominio = this.requestInfo != null ? this.requestInfo.getIdentitaPdD() : this.openspcoopProperties.getIdentitaPortaDefault(protocol, this.requestInfo);
        v0 = nomePorta = this.requestInfo != null && this.requestInfo.getProtocolContext() != null ? this.requestInfo.getProtocolContext().getInterfaceName() : null;
        if (this.policyTimeoutConfig != null) {
            try {
                configurazionePdDManager = ConfigurazionePdDManager.getInstance();
                if (this.pa != null) {
                    this.useTimeoutInputStream = configurazionePdDManager.isConnettoriUseTimeoutInputStream(this.pa);
                    this.proprietaPorta = this.pa.getProprietaList();
                }
                if (this.pd == null) ** GOTO lbl138
                this.useTimeoutInputStream = configurazionePdDManager.isConnettoriUseTimeoutInputStream(this.pd);
                this.proprietaPorta = this.pd.getProprietaList();
            }
            catch (Exception e) {
                this.eccezioneProcessamento = e;
                this.logger.error("Errore durante l'inizializzazione della configurazione di timeout: " + this.readExceptionMessageFromException(e), e);
                this.errore = "Errore durante l'inizializzazione della configurazione di timeout: " + this.readExceptionMessageFromException(e);
                return false;
            }
        } else if (this.idModulo != null) {
            try {
                this.dumpBinario_soglia = this.openspcoopProperties.getDumpBinarioInMemoryThreshold();
                this.dumpBinario_repositoryFile = this.openspcoopProperties.getDumpBinarioRepository();
                configurazionePdDManager = ConfigurazionePdDManager.getInstance();
                if ("ConsegnaContenutiApplicativi".equals(this.idModulo)) {
                    idPA = null;
                    if (request.getIdPortaApplicativa() != null) {
                        idPA = request.getIdPortaApplicativa();
                    } else if (nomePorta != null) {
                        idPA = new IDPortaApplicativa();
                        idPA.setNome(nomePorta);
                    }
                    configurazioneTracciamento = new ConfigurazioneTracciamento(this.logger.getLogger(), configurazionePdDManager, TipoPdD.APPLICATIVA);
                    this.logFileTrace_headers = configurazioneTracciamento.isTransazioniFileTraceDumpBinarioConnettoreHeaderEnabled();
                    this.logFileTrace_payload = configurazioneTracciamento.isTransazioniFileTraceDumpBinarioConnettorePayloadEnabled();
                    if (idPA != null) {
                        this.pa = configurazionePdDManager.getPortaApplicativaSafeMethod(idPA, this.requestInfo);
                        if (this.pa != null) {
                            this.useTimeoutInputStream = configurazionePdDManager.isConnettoriUseTimeoutInputStream(this.pa);
                            dumpConfigurazione = configurazionePdDManager.getDumpConfigurazione(this.pa);
                            configurazioneTracciamento = new ConfigurazioneTracciamento(this.logger.getLogger(), configurazionePdDManager, this.pa);
                            this.logFileTrace_headers = configurazioneTracciamento.isTransazioniFileTraceDumpBinarioConnettoreHeaderEnabled();
                            this.logFileTrace_payload = configurazioneTracciamento.isTransazioniFileTraceDumpBinarioConnettorePayloadEnabled();
                            this.proprietaPorta = this.pa.getProprietaList();
                            if (request.getTransazioneApplicativoServer() != null) {
                                this.nomeConnettoreAsincrono = request.getTransazioneApplicativoServer().getConnettoreNome();
                            }
                        }
                    }
                } else {
                    idPD = null;
                    if (nomePorta != null) {
                        idPD = new IDPortaDelegata();
                        idPD.setNome(nomePorta);
                    }
                    configurazioneTracciamento = new ConfigurazioneTracciamento(this.logger.getLogger(), configurazionePdDManager, TipoPdD.DELEGATA);
                    this.logFileTrace_headers = configurazioneTracciamento.isTransazioniFileTraceDumpBinarioConnettoreHeaderEnabled();
                    this.logFileTrace_payload = configurazioneTracciamento.isTransazioniFileTraceDumpBinarioConnettorePayloadEnabled();
                    if (idPD != null) {
                        this.pd = configurazionePdDManager.getPortaDelegataSafeMethod(idPD, this.requestInfo);
                        if (this.pd != null) {
                            this.useTimeoutInputStream = configurazionePdDManager.isConnettoriUseTimeoutInputStream(this.pd);
                            dumpConfigurazione = configurazionePdDManager.getDumpConfigurazione(this.pd);
                            configurazioneTracciamento = new ConfigurazioneTracciamento(this.logger.getLogger(), configurazionePdDManager, this.pd);
                            this.logFileTrace_headers = configurazioneTracciamento.isTransazioniFileTraceDumpBinarioConnettoreHeaderEnabled();
                            this.logFileTrace_payload = configurazioneTracciamento.isTransazioniFileTraceDumpBinarioConnettorePayloadEnabled();
                            this.proprietaPorta = this.pd.getProprietaList();
                        }
                    }
                }
                if (request.getTransazioneApplicativoServer() != null) {
                    this.logFileTrace_headers = false;
                    this.logFileTrace_payload = false;
                }
                this.dumpRaw = new DumpRaw(this.logger, dominio, this.idModulo, this.outRequestContext.getTipoPorta(), dumpBinario, dumpConfigurazione, this.logFileTrace_headers, this.logFileTrace_payload);
                if (this.dumpRaw.isActiveDumpDatabase()) {
                    if (request.getTransazioneApplicativoServer() != null) {
                        this.dumpRaw.initDump(nomePorta, this.outRequestContext.getPddContext(), request.getTransazioneApplicativoServer(), request.getIdPortaApplicativa(), request.getDataConsegnaTransazioneApplicativoServer());
                    } else {
                        this.dumpRaw.initDump(nomePorta, this.outRequestContext.getPddContext());
                    }
                }
            }
            catch (Exception e) {
                this.eccezioneProcessamento = e;
                this.logger.error("Errore durante l'inizializzazione del dump binario: " + this.readExceptionMessageFromException(e), e);
                this.errore = "Errore durante l'inizializzazione del dump binario: " + this.readExceptionMessageFromException(e);
                return false;
            }
        }
lbl138:
        // 7 sources

        if (this.idModulo != null && this.msgDiagnostico != null) {
            this.useDiagnosticInputStream = "ConsegnaContenutiApplicativi".equals(this.idModulo) != false ? this.openspcoopProperties.isConnettoriUseDiagnosticInputStream_consegnaContenutiApplicativi() : this.openspcoopProperties.isConnettoriUseDiagnosticInputStream_inoltroBuste();
        }
        if (this.getPddContext() != null && (oIdTransazione = this.getPddContext().getObject(Costanti.ID_TRANSAZIONE)) != null && oIdTransazione instanceof String) {
            this.idTransazione = (String)oIdTransazione;
        }
        this.responseCachingConfig = responseCachingConfig;
        if (this.responseCachingConfig != null && StatoFunzionalita.ABILITATO.equals((Object)this.responseCachingConfig.getStato()) && this.requestMsg != null && (digestO = this.requestMsg.getContextProperty(CostantiPdD.RESPONSE_CACHE_REQUEST_DIGEST)) != null) {
            transactionNullable = null;
            try {
                if (this.idTransazione != null) {
                    transactionNullable = TransactionContext.getTransaction(this.idTransazione);
                }
            }
            catch (Throwable configurazioneTracciamento) {
                // empty catch block
            }
            if (transactionNullable != null) {
                transactionNullable.getTempiElaborazione().startResponseCachingReadFromCache();
            }
            this.responseCachingDigest = (String)digestO;
            try {
                responseCached = GestoreCacheResponseCaching.getInstance().readByDigest(this.responseCachingDigest);
                if (responseCached != null) {
                    cacheControl = this.responseCachingConfig.getControl();
                    if (cacheControl == null) {
                        cacheControl = new ResponseCachingConfigurazioneControl();
                    }
                    if (cacheControl != null) {
                        trasportoRichiesta = null;
                        if (this.requestMsg != null && this.requestMsg.getTransportRequestContext() != null && this.requestMsg.getTransportRequestContext().getHeaders() != null) {
                            trasportoRichiesta = this.requestMsg.getTransportRequestContext().getHeaders();
                        }
                        if (cacheControl.isNoCache() && HttpUtilities.isDirectiveNoCache(trasportoRichiesta)) {
                            GestoreCacheResponseCaching.getInstance().removeByUUID(responseCached.getUuid());
                            responseCached = null;
                        }
                        if (responseCached != null && cacheControl.isMaxAge() && (maxAge = HttpUtilities.getDirectiveCacheMaxAge(trasportoRichiesta)) != null && maxAge > 0 && responseCached.getAgeInSeconds() > (long)maxAge.intValue()) {
                            GestoreCacheResponseCaching.getInstance().removeByUUID(responseCached.getUuid());
                            responseCached = null;
                        }
                    }
                    if (responseCached != null) {
                        this.responseMsg = msgResponse = responseCached.toOpenSPCoop2Message(Utilities.getOpenspcoop2MessageFactory(this.logger.getLogger(), this.requestMsg, this.requestInfo, MessageRole.RESPONSE), this.openspcoopProperties.getAttachmentsProcessingMode(), this.openspcoopProperties.getCachingResponseHeaderCacheKey());
                        this.dataAccettazioneRisposta = DateManager.getDate();
                        transportResponseContenxt = msgResponse.getTransportResponseContext();
                        if (transportResponseContenxt != null && transportResponseContenxt.getCodiceTrasporto() != null) {
                            try {
                                this.codice = Integer.parseInt(transportResponseContenxt.getCodiceTrasporto());
                            }
                            catch (Exception e) {
                                this.logger.error("Errore durante la conversione del codice di trasporto [" + transportResponseContenxt.getCodiceTrasporto() + "]");
                                this.codice = 200;
                            }
                        } else {
                            this.codice = 200;
                        }
                        if (transportResponseContenxt != null) {
                            this.propertiesTrasportoRisposta = transportResponseContenxt.getHeaders();
                        }
                        this.contentLength = responseCached.getMessageLength();
                        if (this.getPddContext() != null) {
                            this.getPddContext().addObject(ConnettoreBase.RESPONSE_FROM_CACHE, true);
                        }
                        this.location = "govway://responseCaching";
                        this.responseAlready = true;
                    }
                }
            }
            catch (Exception e) {
                this.eccezioneProcessamento = e;
                this.logger.error("Errore durante la lettura della cache delle risposte: " + this.readExceptionMessageFromException(e), e);
                this.errore = "Errore durante la lettura della cache delle risposte: " + this.readExceptionMessageFromException(e);
                var12_20 = false;
                return var12_20;
            }
            finally {
                if (transactionNullable != null) {
                    transactionNullable.getTempiElaborazione().endResponseCachingReadFromCache();
                }
            }
        }
        this.policyNegoziazioneToken = request.getPolicyNegoziazioneToken();
        this.idAccordo = request.getIdAccordo();
        return true;
    }

    protected NameValue getTokenHeader() throws ConnettoreException {
        return this.getTokenParameter(true);
    }

    protected NameValue getTokenQueryParameter() throws ConnettoreException {
        return this.getTokenParameter(false);
    }

    protected String getNameTokenHeader() throws ConnettoreException {
        return this.readNameTokenParameter(true);
    }

    protected String getNameTokenQueryParameter() throws ConnettoreException {
        return this.readNameTokenParameter(false);
    }

    protected NameValue getDpopBackendHeader() {
        return this.getDpopBackendParameter(true);
    }

    protected NameValue getDpopBackendQueryParameter() {
        return this.getDpopBackendParameter(false);
    }

    private NameValue getDpopBackendParameter(boolean header) {
        if (this.dpopBackendProof == null || this.policyNegoziazioneToken == null || !this.policyNegoziazioneToken.isDpop()) {
            return null;
        }
        String forwardDpopMode = this.policyNegoziazioneToken.getForwardDpopMode();
        NameValue n = this.getDpopBackendParameter(header, forwardDpopMode);
        if (n != null) {
            n.setValue(this.dpopBackendProof);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NameValue getDpopBackendParameter(boolean header, String forwardDpopMode) {
        NameValue n = null;
        if ("RFC9449_header".equals(forwardDpopMode) || forwardDpopMode == null || forwardDpopMode.isEmpty()) {
            if (!header) return null;
            n = new NameValue();
            n.setName("DPoP");
            return n;
        } else if ("CUSTOM_header".equals(forwardDpopMode)) {
            if (!header) return null;
            n = new NameValue();
            n.setName(this.policyNegoziazioneToken.getForwardDpopModeCustomHeader());
            return n;
        } else {
            if (!"CUSTOM_url".equals(forwardDpopMode)) return n;
            if (header) return null;
            n = new NameValue();
            n.setName(this.policyNegoziazioneToken.getForwardDpopModeCustomUrl());
        }
        return n;
    }

    protected void ensureTokenNegotiated(HttpRequestMethod httpMethod) throws ConnettoreException {
        if (this.cachedEsitoNegoziazioneToken != null) {
            return;
        }
        if (this.policyNegoziazioneToken == null) {
            return;
        }
        try {
            GestoreToken.validazioneConfigurazione(this.policyNegoziazioneToken);
            if (this.debug) {
                this.logger.debug("Negoziazione token '" + this.policyNegoziazioneToken.getName() + "' ...");
            }
            if (this.msgDiagnostico != null) {
                try {
                    this.msgDiagnostico.logPersonalizzato("negoziazioneToken.inCorso");
                }
                catch (Throwable t) {
                    this.logger.error("Emissione diagnostica 'negoziazioneToken.inCorso' fallita: " + t.getMessage(), t);
                }
            }
            EsitoNegoziazioneToken esitoNegoziazione = GestoreToken.endpointToken(this.debug, this.logger.getLogger(), this.policyNegoziazioneToken, this.busta, this.requestInfo, "ConsegnaContenutiApplicativi".equals(this.idModulo) ? TipoPdD.APPLICATIVA : TipoPdD.DELEGATA, this.idModulo, this.pa, this.pd, this.getPddContext(), this.getProtocolFactory());
            if (this.debug) {
                this.logger.debug("Negoziazione token '" + this.policyNegoziazioneToken.getName() + "' terminata");
            }
            if (esitoNegoziazione == null) {
                throw new ConnettoreException("Esito Negoziazione non ritornato ?");
            }
            if (!esitoNegoziazione.isValido()) {
                throw new ConnettoreException(esitoNegoziazione.getDetails(), esitoNegoziazione.getEccezioneProcessamento());
            }
            DateTimeFormatterWrapper sdf = DateUtils.getDefaultDateTimeFormatter((String)format);
            if (esitoNegoziazione.isInCache()) {
                if (esitoNegoziazione.getInformazioniNegoziazioneToken().getExpiresIn() != null) {
                    this.logger.debug("Presente in cache access_token '" + esitoNegoziazione.getToken() + "'; expire in (" + sdf.format(esitoNegoziazione.getInformazioniNegoziazioneToken().getExpiresIn()) + ")");
                } else {
                    this.logger.debug("Presente in cache access_token '" + esitoNegoziazione.getToken() + "'; no expire");
                }
                if (this.msgDiagnostico != null) {
                    try {
                        this.msgDiagnostico.logPersonalizzato("negoziazioneToken.inCache");
                    }
                    catch (Exception t) {
                        this.logger.error("Emissione diagnostica 'negoziazioneToken.inCache' fallita: " + t.getMessage(), t);
                    }
                }
            } else {
                if (esitoNegoziazione.getInformazioniNegoziazioneToken().getExpiresIn() != null) {
                    this.logger.debug("Recuperato access_token '" + esitoNegoziazione.getToken() + "'; expire in (" + sdf.format(esitoNegoziazione.getInformazioniNegoziazioneToken().getExpiresIn()) + ")");
                } else {
                    this.logger.debug("Recuperato access_token '" + esitoNegoziazione.getToken() + "'; no expire");
                }
                if (this.msgDiagnostico != null) {
                    try {
                        this.msgDiagnostico.logPersonalizzato("negoziazioneToken.completata");
                    }
                    catch (Exception t) {
                        this.logger.error("Emissione diagnostica 'negoziazioneToken.completata' fallita: " + t.getMessage(), t);
                    }
                }
            }
            if (this.modIValidazioneSemanticaProfiloSicurezza != null) {
                String jti = ModIUtils.readJti((String)esitoNegoziazione.getToken(), (Logger)this.logger.getLogger());
                if (jti != null && StringUtils.isNotEmpty((String)jti)) {
                    ModIUtils.replaceBustaIdWithJtiTokenId((ModIValidazioneSemanticaProfiloSicurezza)this.modIValidazioneSemanticaProfiloSicurezza, (String)jti);
                    if (this.msgDiagnostico != null) {
                        this.msgDiagnostico.updateKeywordIdMessaggioRichiesta(this.busta.getID());
                    }
                    if (this.getPddContext() != null) {
                        this.getPddContext().put(Costanti.MODI_JTI_REQUEST_ID, jti);
                    }
                }
                if (this.msgDiagnostico != null) {
                    try {
                        this.msgDiagnostico.logPersonalizzato("inoltroInCorso");
                    }
                    catch (Exception t) {
                        this.logger.error("Emissione diagnostica 'inoltroInCorso' fallita: " + t.getMessage(), t);
                    }
                }
            }
            this.cachedEsitoNegoziazioneToken = esitoNegoziazione;
            boolean dpopEnabled = this.policyNegoziazioneToken.isDpop();
            this.generateDPoP(dpopEnabled, httpMethod, esitoNegoziazione);
        }
        catch (Exception e) {
            if (this.getPddContext() != null) {
                this.getPddContext().addObject(Costanti.ERRORE_NEGOZIAZIONE_TOKEN, "true");
            }
            this.logger.error("Errore durante la negoziazione del token: " + e.getMessage(), e);
            throw new ConnettoreException("Errore durante la negoziazione del token: " + e.getMessage(), e);
        }
    }

    public void setModIValidazioneSemanticaProfiloSicurezza(ModIValidazioneSemanticaProfiloSicurezza modIValidazioneSemanticaProfiloSicurezza) {
        this.modIValidazioneSemanticaProfiloSicurezza = modIValidazioneSemanticaProfiloSicurezza;
    }

    private String readNameTokenParameter(boolean header) throws ConnettoreException {
        NameValue nv = this.getTokenParameterEngine(true, header);
        return nv != null ? nv.getName() : null;
    }

    private NameValue getTokenParameter(boolean header) throws ConnettoreException {
        return this.getTokenParameterEngine(false, header);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NameValue getTokenParameterEngine(boolean onlyName, boolean header) throws ConnettoreException {
        if (this.policyNegoziazioneToken == null) return null;
        try {
            String forwardMode = this.policyNegoziazioneToken.getForwardTokenMode();
            NameValue n = null;
            if ("RFC6750_header".equals(forwardMode)) {
                if (!header) return null;
                n = new NameValue();
                n.setName("Authorization");
                if (!onlyName) {
                    boolean dpopEnabled = this.policyNegoziazioneToken.isDpop();
                    n.setValue(dpopEnabled ? "DPoP " : "Bearer ");
                }
            } else if ("RFC6750_url".equals(forwardMode)) {
                if (header) return null;
                n = new NameValue();
                n.setName("access_token");
            } else if ("CUSTOM_header".equals(forwardMode)) {
                if (!header) return null;
                n = new NameValue();
                n.setName(this.policyNegoziazioneToken.getForwardTokenModeCustomHeader());
            } else if ("CUSTOM_url".equals(forwardMode)) {
                if (header) return null;
                n = new NameValue();
                n.setName(this.policyNegoziazioneToken.getForwardTokenModeCustomUrl());
            }
            if (onlyName) return n;
            if (this.cachedEsitoNegoziazioneToken == null) {
                throw new ConnettoreException("Token negotiation not performed yet");
            }
            EsitoNegoziazioneToken esitoNegoziazione = this.cachedEsitoNegoziazioneToken;
            if (n == null) return n;
            if (n.getValue() != null) {
                n.setValue(n.getValue() + esitoNegoziazione.getToken());
                return n;
            } else {
                n.setValue(esitoNegoziazione.getToken());
            }
            return n;
        }
        catch (Exception e) {
            if (this.getPddContext() == null) throw new ConnettoreException(e.getMessage(), e);
            this.getPddContext().addObject(Costanti.ERRORE_NEGOZIAZIONE_TOKEN, "true");
            throw new ConnettoreException(e.getMessage(), e);
        }
    }

    private void generateDPoP(boolean dpopEnabled, HttpRequestMethod httpMethod, EsitoNegoziazioneToken esitoNegoziazione) throws ConnettoreException {
        if (dpopEnabled && this.location != null) {
            try {
                String httpMethodStr = httpMethod != null ? httpMethod.name() : HttpRequestMethod.GET.name();
                String accessToken = esitoNegoziazione.getToken();
                DPoPParams dpopParams = new DPoPParams();
                dpopParams.setPolicyNegoziazioneToken(this.policyNegoziazioneToken);
                dpopParams.setHttpMethod(httpMethodStr);
                dpopParams.setHttpUri(this.location);
                dpopParams.setAccessToken(accessToken);
                dpopParams.setBusta(this.busta);
                dpopParams.setRequestInfo(this.requestInfo);
                dpopParams.setPddContext(this.getPddContext());
                dpopParams.setLog(this.logger.getLogger());
                this.generateDPoP(dpopParams, esitoNegoziazione);
            }
            catch (Exception dpopEx) {
                throw new ConnettoreException("Generazione DPoP backend proof fallita: " + dpopEx.getMessage(), dpopEx);
            }
        }
    }

    private void generateDPoP(DPoPParams dpopParams, EsitoNegoziazioneToken esitoNegoziazione) throws CoreException, TokenException, SecurityException, UtilsException {
        if (esitoNegoziazione != null && esitoNegoziazione.getInformazioniNegoziazioneToken() != null) {
            NegoziazioneTokenDynamicParameters dynamicParameters = esitoNegoziazione.getInformazioniNegoziazioneToken().getDynamicParameters();
            dpopParams.setDynamicParameters(dynamicParameters);
        }
        EsitoDPoPBackend esitoDPoP = GestoreToken.getDPoPBackendProof(dpopParams);
        this.dpopBackendProof = esitoDPoP.getDpopProof();
        if (esitoNegoziazione != null) {
            esitoNegoziazione.setDpopBackendInCache(esitoDPoP.isInCache());
        }
        if (esitoNegoziazione != null && esitoNegoziazione.getInformazioniNegoziazioneToken() != null) {
            boolean infoNormalizzate = this.openspcoopProperties.isGestioneRetrieveTokenDpopBackendSaveDpopInfoTransazioniRegistrazioneInformazioniNormalizzate();
            InformazioniJWTDpop dpopBackendInfo = new InformazioniJWTDpop(this.logger.getLogger(), this.dpopBackendProof, infoNormalizzate);
            esitoNegoziazione.getInformazioniNegoziazioneToken().setDpopBackend(dpopBackendInfo);
        }
        if (this.debug) {
            String cacheMsg = esitoDPoP.isInCache() ? " (in cache)" : "";
            this.logger.debug("DPoP backend proof generato" + cacheMsg + " per '" + this.location + "'");
        }
        if (this.msgDiagnostico != null) {
            try {
                String diagnosticKey = esitoDPoP.isInCache() ? "dpopBackend.inCache" : "dpopBackend.completato";
                this.msgDiagnostico.logPersonalizzato(diagnosticKey);
            }
            catch (Exception t) {
                this.logger.error("Emissione diagnostica DPoP backend fallita: " + t.getMessage(), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveResponseInCache() {
        block27: {
            Transaction transactionNullable = null;
            try {
                if (this.getPddContext() != null) {
                    Object oIdTransazione = this.getPddContext().getObject(Costanti.ID_TRANSAZIONE);
                    String idTransazione = null;
                    if (oIdTransazione != null && oIdTransazione instanceof String) {
                        idTransazione = (String)oIdTransazione;
                    }
                    transactionNullable = TransactionContext.getTransaction(idTransazione);
                }
            }
            catch (Throwable oIdTransazione) {
                // empty catch block
            }
            if (transactionNullable != null) {
                transactionNullable.getTempiElaborazione().startResponseCachingSaveInCache();
            }
            try {
                ResponseCachingConfigurazioneControl cacheControl;
                if (this.responseCachingConfig == null || !StatoFunzionalita.ABILITATO.equals((Object)this.responseCachingConfig.getStato()) || this.responseMsg == null) break block27;
                boolean saveInCache = true;
                int cacheTimeoutSeconds = this.responseCachingConfig.getCacheTimeoutSeconds();
                Long kbMax = this.responseCachingConfig.getMaxMessageSize();
                long byteMax = -1L;
                if (kbMax != null) {
                    byteMax = kbMax * 1024L;
                }
                Map trasportoRichiesta = null;
                if (this.requestMsg != null && this.requestMsg.getTransportRequestContext() != null && this.requestMsg.getTransportRequestContext().getHeaders() != null) {
                    trasportoRichiesta = this.requestMsg.getTransportRequestContext().getHeaders();
                }
                if ((cacheControl = this.responseCachingConfig.getControl()) == null) {
                    cacheControl = new ResponseCachingConfigurazioneControl();
                }
                if (cacheControl != null && cacheControl.isNoStore() && HttpUtilities.isDirectiveNoStore(trasportoRichiesta)) {
                    saveInCache = false;
                }
                if (saveInCache && this.responseCachingConfig.sizeRegolaList() > 0) {
                    int returnCode = -1;
                    try {
                        if (this.responseMsg.getTransportResponseContext() != null && this.responseMsg.getTransportResponseContext().getCodiceTrasporto() != null) {
                            returnCode = Integer.parseInt(this.responseMsg.getTransportResponseContext().getCodiceTrasporto());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    boolean isFault = this.responseMsg.isFault();
                    ResponseCachingConfigurazioneRegola regolaGeneraleIncludeFault = null;
                    saveInCache = false;
                    for (ResponseCachingConfigurazioneRegola regola : this.responseCachingConfig.getRegolaList()) {
                        if (returnCode > 0 && regola.getReturnCodeMin() != null && returnCode < regola.getReturnCodeMin() || returnCode > 0 && regola.getReturnCodeMax() != null && returnCode > regola.getReturnCodeMax() || isFault && !regola.isFault()) continue;
                        if (!isFault && regola.isFault()) {
                            if (regolaGeneraleIncludeFault != null) continue;
                            regolaGeneraleIncludeFault = regola;
                            continue;
                        }
                        saveInCache = true;
                        if (regola.getCacheTimeoutSeconds() == null) break;
                        cacheTimeoutSeconds = regola.getCacheTimeoutSeconds();
                        break;
                    }
                    if (!saveInCache && regolaGeneraleIncludeFault != null) {
                        saveInCache = true;
                        if (regolaGeneraleIncludeFault.getCacheTimeoutSeconds() != null) {
                            cacheTimeoutSeconds = regolaGeneraleIncludeFault.getCacheTimeoutSeconds();
                        }
                    }
                }
                if (saveInCache && kbMax != null && this.contentLength > 0L && this.contentLength > byteMax) {
                    this.logger.debug("Messaggio non salvato in cache, nonostante la configurazione lo richiesta poich\u00e8 la sua dimensione (" + this.contentLength + " bytes) supera la dimensione massima consentita (" + byteMax + " bytes)");
                    saveInCache = false;
                }
                if (saveInCache) {
                    ResponseCached responseCached = ResponseCached.toResponseCached(this.responseMsg, cacheTimeoutSeconds);
                    if (kbMax != null && this.contentLength <= 0L && responseCached.getMessageLength() > byteMax) {
                        this.logger.debug("Messaggio non salvato in cache, nonostante la configurazione lo richiesta poich\u00e8 la sua dimensione (" + responseCached.getMessageLength() + " bytes) supera la dimensione massima consentita (" + byteMax + " bytes)");
                        saveInCache = false;
                    }
                    if (saveInCache) {
                        GestoreCacheResponseCaching.getInstance().save(this.responseCachingDigest, responseCached);
                    }
                }
            }
            catch (Throwable e) {
                this.logger.error("Errore durante il salvataggio nella cache delle risposte: " + this.readExceptionMessageFromException(e), e);
            }
            finally {
                if (transactionNullable != null) {
                    transactionNullable.getTempiElaborazione().endResponseCachingSaveInCache();
                }
            }
        }
    }

    protected abstract boolean initializePreSend(ResponseCachingConfigurazione var1, ConnettoreMsg var2);

    protected abstract boolean send(ConnettoreMsg var1);

    @Override
    public boolean send(ResponseCachingConfigurazione responseCachingConfig, ConnettoreMsg request) {
        if (!this.initializePreSend(responseCachingConfig, request)) {
            return false;
        }
        if (this.responseAlready) {
            return true;
        }
        boolean returnEsitoSend = this.send(request);
        if (returnEsitoSend) {
            this.saveResponseInCache();
        }
        return returnEsitoSend;
    }

    @Override
    public String getErrore() {
        return this.errore;
    }

    @Override
    public int getCodiceTrasporto() {
        return this.codice;
    }

    @Override
    public Map<String, List<String>> getHeaderTrasporto() {
        if (this.propertiesTrasportoRisposta.size() <= 0) {
            return null;
        }
        return this.propertiesTrasportoRisposta;
    }

    @Override
    public OpenSPCoop2Message getResponse() {
        if (this.responseMsg != null) {
            if (this.getProtocolFactory() != null) {
                this.responseMsg.setProtocolName(this.getProtocolFactory().getProtocol());
            }
            if (this.getPddContext() != null) {
                this.responseMsg.setTransactionId(PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, this.getPddContext()));
            }
        }
        return this.responseMsg;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getLocation() throws ConnettoreException {
        return this.location;
    }

    @Override
    public Exception getEccezioneProcessamento() {
        return this.eccezioneProcessamento;
    }

    @Override
    public void disconnect() throws ConnettoreException {
        try {
            if (this.responseMsg != null && this.responseMsg.getNotifierInputStream() != null) {
                this.responseMsg.getNotifierInputStream().close();
            }
        }
        catch (Exception e) {
            throw new ConnettoreException("Chiusura connessione non riuscita: " + e.getMessage(), e);
        }
    }

    @Override
    public Date getCreationDate() throws ConnettoreException {
        return this.creationDate;
    }

    @Override
    public NotifierInputStreamParams getNotifierInputStreamParamsResponse() throws ConnettoreException {
        if (this.preInResponseContext != null) {
            return this.preInResponseContext.getNotifierInputStreamParams();
        }
        return null;
    }

    protected void postOutRequest() throws Exception {
        if (this.registerSendIntoContext && this.getPddContext() != null) {
            this.getPddContext().addObject(Costanti.RICHIESTA_INOLTRATA_BACKEND, "true");
        }
        if (this.msgDiagnostico != null && this.outRequestContext != null) {
            this.postOutRequestContext = new PostOutRequestContext(this.outRequestContext);
            this.postOutRequestContext.setCodiceTrasporto(this.getCodiceTrasporto());
            this.postOutRequestContext.setResponseHeaders(this.getHeaderTrasporto());
            try {
                GestoreHandlers.postOutRequest(this.postOutRequestContext, this.msgDiagnostico, OpenSPCoop2Logger.getLoggerOpenSPCoopCore());
            }
            catch (Exception e) {
                if (e instanceof HandlerException) {
                    HandlerException he = (HandlerException)e;
                    if (he.isEmettiDiagnostico()) {
                        this.msgDiagnostico.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                    } else {
                        OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error(e.getMessage(), (Throwable)e);
                    }
                } else {
                    this.msgDiagnostico.logErroreGenerico(e, "PostOutRequestHandler");
                }
                throw e;
            }
        }
    }

    protected void preInResponse() throws Exception {
        this.dataAccettazioneRisposta = DateManager.getDate();
        if (this.msgDiagnostico != null && this.outRequestContext != null) {
            PostOutRequestContext postContext = this.postOutRequestContext;
            if (postContext == null) {
                postContext = new PostOutRequestContext(this.outRequestContext);
                postContext.setCodiceTrasporto(this.getCodiceTrasporto());
                postContext.setResponseHeaders(this.getHeaderTrasporto());
            }
            this.preInResponseContext = new PreInResponseContext(postContext);
            try {
                GestoreHandlers.preInResponse(this.preInResponseContext, this.msgDiagnostico, OpenSPCoop2Logger.getLoggerOpenSPCoopCore());
            }
            catch (Exception e) {
                if (e instanceof HandlerException) {
                    HandlerException he = (HandlerException)e;
                    if (he.isEmettiDiagnostico()) {
                        this.msgDiagnostico.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                    } else {
                        OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error(e.getMessage(), (Throwable)e);
                    }
                } else {
                    this.msgDiagnostico.logErroreGenerico(e, "PreInResponseHandler");
                }
                throw e;
            }
        }
    }

    protected String readExceptionMessageFromException(Throwable e) {
        return ConnettoreBase.readConnectionExceptionMessageFromException(e);
    }

    public static String readConnectionExceptionMessageFromException(Throwable e) {
        IOException io;
        CertificateException ce;
        Throwable internal;
        SocketException s;
        if (e instanceof UnknownHostException) {
            return "unknown host '" + e.getMessage() + "'";
        }
        if (e instanceof SocketException && ConnettoreBase._isNotNullMessageException(s = (SocketException)e)) {
            return s.getMessage();
        }
        if (org.openspcoop2.utils.Utilities.existsInnerException((Throwable)e, SocketException.class) && ConnettoreBase._isNotNullMessageException(internal = org.openspcoop2.utils.Utilities.getInnerException((Throwable)e, SocketException.class))) {
            return ConnettoreBase._buildException(e, internal);
        }
        if (CertificateException.class.isInstance(e) && ConnettoreBase._isNotNullMessageException(ce = (CertificateException)e)) {
            return ce.getMessage();
        }
        if (org.openspcoop2.utils.Utilities.existsInnerInstanceException((Throwable)e, CertificateException.class)) {
            boolean last = true;
            Throwable internalNotYetValid = org.openspcoop2.utils.Utilities.getInnerInstanceException((Throwable)e, CertificateNotYetValidException.class, (boolean)last);
            if (internalNotYetValid != null && ConnettoreBase._isNotNullMessageException(internalNotYetValid)) {
                return ConnettoreBase._buildException(e, internalNotYetValid);
            }
            Throwable internalExpired = org.openspcoop2.utils.Utilities.getInnerInstanceException((Throwable)e, CertificateExpiredException.class, (boolean)last);
            if (internalExpired != null && ConnettoreBase._isNotNullMessageException(internalExpired)) {
                return ConnettoreBase._buildException(e, internalExpired);
            }
            if (ConnettoreBase._isNotNullMessageException(e)) {
                return e.getMessage();
            }
        }
        if ((e instanceof IOException || IOException.class.isInstance(e)) && ConnettoreBase._isNotNullMessageException(io = (IOException)e)) {
            return io.getMessage();
        }
        if (org.openspcoop2.utils.Utilities.existsInnerException((Throwable)e, IOException.class) && ConnettoreBase._isNotNullMessageException(internal = org.openspcoop2.utils.Utilities.getInnerException((Throwable)e, IOException.class))) {
            return ConnettoreBase._buildException(e, internal);
        }
        if (org.openspcoop2.utils.Utilities.existsInnerException((Throwable)e, (String)"org.apache.catalina.connector.ClientAbortException") && ConnettoreBase._isNotNullMessageException(internal = org.openspcoop2.utils.Utilities.getInnerException((Throwable)e, (String)"org.apache.catalina.connector.ClientAbortException"))) {
            return "ClientAbortException - " + ConnettoreBase._buildException(e, internal);
        }
        if (ConnettoreBase._isNotNullMessageException(e)) {
            return e.getMessage();
        }
        Throwable tNotEmpty = ParseExceptionUtils.getInnerNotEmptyMessageException((Throwable)e);
        if (tNotEmpty != null) {
            return tNotEmpty.getMessage();
        }
        return "ErrorOccurs - " + e.getMessage();
    }

    protected String buildException(Throwable original, Throwable internal) {
        return ConnettoreBase._buildException(original, internal);
    }

    private static String _buildException(Throwable original, Throwable internal) {
        if (ConnettoreBase._isNotNullMessageException(original)) {
            String internalMessage = internal.getMessage();
            String originalMessage = original.getMessage();
            if (originalMessage != null && !originalMessage.equals(internalMessage)) {
                return internalMessage + " (sourceException: " + originalMessage + ")";
            }
            return internal.getMessage();
        }
        return internal.getMessage();
    }

    protected boolean isNotNullMessageException(Throwable tmp) {
        return ConnettoreBase._isNotNullMessageException(tmp);
    }

    private static boolean _isNotNullMessageException(Throwable tmp) {
        return tmp.getMessage() != null && !"".equals(tmp.getMessage()) && !"null".equalsIgnoreCase(tmp.getMessage());
    }

    protected boolean isDumpBinarioRichiesta() {
        return this.debug || this.dumpRaw != null && this.dumpRaw.isActiveDumpDatabaseRichiesta();
    }

    protected boolean isDumpBinarioRisposta() {
        return this.debug || this.dumpRaw != null && this.dumpRaw.isActiveDumpDatabaseRisposta();
    }

    protected void emitDiagnosticStartDumpBinarioRichiestaUscita() {
        if (this.dumpRaw != null && this.dumpRaw.isActiveDumpDatabaseRichiesta()) {
            this.dumpRaw.emitDiagnosticStartDumpBinarioRichiestaUscita();
        }
    }

    protected void dumpBinarioRichiestaUscita(DumpByteArrayOutputStream bout, MessageType messageType, String contentTypeRichiesta, String location, Map<String, List<String>> trasporto) throws DumpException {
        if (this.debug) {
            String content = null;
            if (bout != null) {
                content = bout.toString();
                this.logger.info("Messaggio inviato (ContentType:" + contentTypeRichiesta + ") :\n" + content, false);
            } else {
                this.logger.info("Messaggio inviato senza contenuto nell'http-payload", false);
            }
        }
        if (this.dumpRaw != null && this.dumpRaw.isActiveDumpDatabaseRichiesta()) {
            this.infoConnettoreUscita = new InfoConnettoreUscita();
            this.infoConnettoreUscita.setLocation(location);
            this.infoConnettoreUscita.setHeaders(trasporto);
            this.dumpRaw.dumpRequest(bout, messageType, this.infoConnettoreUscita);
        }
    }

    protected void emitDiagnosticStartDumpBinarioRispostaIngresso() {
        if (this.dumpRaw != null && this.dumpRaw.isActiveDumpDatabaseRisposta()) {
            this.dumpRaw.emitDiagnosticStartDumpBinarioRispostaIngresso();
        }
    }

    protected void dumpBinarioRispostaIngresso(DumpByteArrayOutputStream raw, MessageType messageType, Map<String, List<String>> trasportoRisposta) throws DumpException {
        if (this.dumpRaw != null && this.dumpRaw.isActiveDumpDatabaseRisposta()) {
            this.dumpRaw.dumpResponse(raw, messageType, this.infoConnettoreUscita, trasportoRisposta);
        }
    }

    protected Map<String, Object> buildDynamicMap(ConnettoreMsg connettoreMsg) {
        if (this.dynamicMap == null) {
            this.dynamicMap = new HashMap<String, Object>();
        }
        DynamicInfo dInfo = new DynamicInfo(connettoreMsg, this.getPddContext());
        Logger log = null;
        if (this.logger != null) {
            log = this.logger.getLogger();
        }
        if (log == null) {
            log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        }
        DynamicUtils.fillDynamicMap(log, this.dynamicMap, dInfo);
        return this.dynamicMap;
    }

    protected String getDynamicProperty(String tipoConnettore, boolean required, String name, Map<String, Object> dynamicMap) throws ConnettoreException {
        String tmp = this.properties.get(name);
        if (tmp != null) {
            tmp = tmp.trim();
        }
        if (tmp == null || "".equals(tmp)) {
            if (required) {
                throw new ConnettoreException("Proprieta' '" + name + "' non fornita e richiesta da questo tipo di connettore [" + tipoConnettore + "]");
            }
            return null;
        }
        try {
            return DynamicUtils.convertDynamicPropertyValue(name, tmp, dynamicMap, this.getPddContext(), false);
        }
        catch (Exception e) {
            throw new ConnettoreException(e.getMessage(), e);
        }
    }

    protected boolean isBooleanProperty(String tipoConnettore, boolean defaultValue, String name) {
        String tmp = this.properties.get(name);
        if (tmp != null) {
            tmp = tmp.trim();
        }
        if (tmp == null || "".equals(tmp)) {
            return defaultValue;
        }
        return "true".equalsIgnoreCase(tmp) || CostantiConfigurazione.ABILITATO.getValue().equalsIgnoreCase(tmp);
    }

    protected Integer getIntegerProperty(String tipoConnettore, boolean required, String name) throws ConnettoreException {
        String tmp = this.properties.get(name);
        if (tmp != null) {
            tmp = tmp.trim();
        }
        if (tmp == null || "".equals(tmp)) {
            if (required) {
                throw new ConnettoreException("Proprieta' '" + name + "' non fornita e richiesta da questo tipo di connettore [" + tipoConnettore + "]");
            }
            return null;
        }
        try {
            return Integer.parseInt(tmp);
        }
        catch (Exception e) {
            throw new ConnettoreException("Proprieta' '" + name + "' contiene un valore non corretto: " + e.getMessage(), e);
        }
    }

    protected void forwardHttpRequestHeader() throws Exception {
        OpenSPCoop2MessageProperties forwardHeader = null;
        forwardHeader = ServiceBinding.REST.equals((Object)this.requestMsg.getServiceBinding()) ? this.requestMsg.getForwardTransportHeader(this.openspcoopProperties.getRESTServicesHeadersForwardConfig(true)) : this.requestMsg.getForwardTransportHeader(this.openspcoopProperties.getSOAPServicesHeadersForwardConfig(true));
        if (forwardHeader != null && forwardHeader.size() > 0) {
            if (this.debug) {
                this.logger.debug("Forward header di trasporto (size:" + forwardHeader.size() + ") ...");
            }
            if (this.propertiesTrasporto == null) {
                this.propertiesTrasporto = new HashMap<String, List<String>>();
            }
            Iterator keys = forwardHeader.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                List values = forwardHeader.getPropertyValues(key);
                if (values == null || values.isEmpty()) continue;
                ArrayList vs = new ArrayList(values);
                for (String value : vs) {
                    if (this.debug) {
                        this.logger.debug("Forward Transport Header [" + key + "]=[" + value + "]");
                    }
                    TransportUtils.addHeader(this.propertiesTrasporto, (String)key, (String)value);
                }
            }
        }
    }

    protected void clearRequestHeader() {
        this.headersImpostati.clear();
    }

    protected void setRequestHeader(String key, List<String> values) throws Exception {
    }

    protected void setRequestHeader(String key, String value, Map<String, List<String>> propertiesTrasportoDebug) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add(value);
        this.setRequestHeader(key, list, propertiesTrasportoDebug);
    }

    protected void setRequestHeader(String key, List<String> values, Map<String, List<String>> propertiesTrasportoDebug) throws Exception {
        if (!this.headersImpostati.containsKey(key)) {
            this.headersImpostati.put(key, values);
            this.setRequestHeader(key, values);
            if (propertiesTrasportoDebug != null) {
                propertiesTrasportoDebug.put(key, values);
            }
        } else {
            block10: {
                if (this.messaggioDumpUscita == null && this.openspcoopProperties.isTransazioniSaveDumpInUniqueTransaction() && this.getPddContext() != null && this.getPddContext().containsKey(Costanti.ID_TRANSAZIONE)) {
                    try {
                        Transaction tr = TransactionContext.getTransaction((String)this.getPddContext().getObject(Costanti.ID_TRANSAZIONE));
                        if (tr == null) break block10;
                        for (Messaggio messaggio : tr.getMessaggi()) {
                            if (!TipoMessaggio.RICHIESTA_USCITA.equals((Object)messaggio.getTipoMessaggio())) continue;
                            this.messaggioDumpUscita = messaggio;
                            break;
                        }
                    }
                    catch (TransactionNotExistsException e) {
                        this.logger.debug("Adeguamento dump http header non riuscito (token ): " + e.getMessage());
                    }
                    catch (Throwable e) {
                        this.logger.error("Adeguamento dump http header non riuscito: " + e.getMessage(), e);
                    }
                }
            }
            if (this.messaggioDumpUscita != null) {
                if (this.messaggioDumpUscita.getHeaders() == null) {
                    this.messaggioDumpUscita.setHeaders(new HashMap());
                }
                TransportUtils.removeRawObject((Map)this.messaggioDumpUscita.getHeaders(), (String)key);
                this.messaggioDumpUscita.getHeaders().put(key, this.headersImpostati.get(key));
            }
        }
    }

    protected void emitDiagnosticResponseRead(InputStream is) {
        if (is != null && this.msgDiagnostico != null && !this.emitDiagnosticResponseRead) {
            this.msgDiagnostico.logPersonalizzato("ricezioneRisposta.firstAccessRequestStream");
            this.emitDiagnosticResponseRead = true;
        }
    }
}

