/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.CountingInputStream;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.ParseExceptionUtils;
import org.openspcoop2.message.soap.AbstractOpenSPCoop2Message_soap_impl;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.soap.TunnelSoapUtils;
import org.openspcoop2.pdd.core.Utilities;
import org.openspcoop2.pdd.core.connettori.ConnettoreBase;
import org.openspcoop2.pdd.core.controllo_traffico.DimensioneMessaggiUtils;
import org.openspcoop2.pdd.core.controllo_traffico.LimitExceededNotifier;
import org.openspcoop2.pdd.core.controllo_traffico.ReadTimeoutConfigurationUtils;
import org.openspcoop2.pdd.core.controllo_traffico.ReadTimeoutContextParam;
import org.openspcoop2.pdd.core.controllo_traffico.SogliaReadTimeout;
import org.openspcoop2.pdd.core.controllo_traffico.TimeoutNotifier;
import org.openspcoop2.pdd.core.controllo_traffico.TimeoutNotifierType;
import org.openspcoop2.pdd.logger.DiagnosticInputStream;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.CopyStream;
import org.openspcoop2.utils.ILimitExceededNotifier;
import org.openspcoop2.utils.ITimeoutNotifier;
import org.openspcoop2.utils.LimitedInputStream;
import org.openspcoop2.utils.TimeoutInputStream;
import org.openspcoop2.utils.dch.MailcapActivationReader;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.transport.TransportResponseContext;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;

public abstract class ConnettoreBaseWithResponse
extends ConnettoreBase {
    protected InputStream isResponse = null;
    protected MessageType messageTypeResponse = null;
    protected String tipoRisposta = null;
    protected boolean checkContentType = true;
    protected NotifierInputStreamParams notifierInputStreamParams;
    protected boolean imbustamentoConAttachment;
    protected String mimeTypeAttachment;
    protected boolean acceptOnlyReturnCode_202_200 = true;
    private String contentTypeMessaggioOriginale_tunnelSoap = null;

    protected void normalizeInputStreamResponse(int timeout, boolean configurazioneGlobale) throws Exception {
        Object notifier;
        if (this.isResponse != null) {
            this.isResponse = org.openspcoop2.utils.Utilities.normalizeStream((InputStream)this.isResponse, (boolean)false);
        } else {
            this.logger.info("Stream di risposta (return-code:" + this.codice + ") is null", true);
        }
        if (this.isResponse != null && this.useLimitedInputStream && this.limitBytes != null && this.limitBytes.getSogliaKb() > 0L) {
            List l;
            notifier = new LimitExceededNotifier(this.getPddContext(), this.limitBytes, this.logger.getLogger());
            if (this.limitBytes.isUseContentLengthHeader() && (l = TransportUtils.getValues((Map)this.propertiesTrasportoRisposta, (String)"Content-Length")) != null && !l.isEmpty()) {
                DimensioneMessaggiUtils.verifyByContentLength(this.logger.getLogger(), l, this.limitBytes, (LimitExceededNotifier)notifier, (org.openspcoop2.utils.Map<Object>)this.getPddContext(), false);
            }
            long limitBytes = this.limitBytes.getSogliaKb() * 1024L;
            this.isResponse = new LimitedInputStream(this.isResponse, limitBytes, "Response ", (org.openspcoop2.utils.Map)this.getPddContext(), (ILimitExceededNotifier)notifier);
        }
        if (this.isResponse != null && this.useTimeoutInputStream && timeout > 0) {
            notifier = this.getTimeoutNotifier(timeout, configurazioneGlobale, TimeoutNotifierType.RECEIVE_RESPONSE);
            this.isResponse = new TimeoutInputStream(this.isResponse, timeout, "Response ", (org.openspcoop2.utils.Map)this.getPddContext(), (ITimeoutNotifier)notifier);
        }
        if (this.isResponse != null && this.useDiagnosticInputStream && this.msgDiagnostico != null) {
            String idModuloFunzionale = "ConsegnaContenutiApplicativi".equals(this.idModulo) ? "consegnaContenutiApplicativi." : "inoltroBuste.";
            this.isResponse = new DiagnosticInputStream(this.isResponse, idModuloFunzionale, "letturaPayloadRisposta", false, this.msgDiagnostico, this.logger != null && this.logger.getLogger() != null ? this.logger.getLogger() : OpenSPCoop2Logger.getLoggerOpenSPCoopCore(), (org.openspcoop2.utils.Map<Object>)this.getPddContext());
        }
    }

    protected TimeoutNotifier getTimeoutNotifier(int timeout, boolean configurazioneGlobale, TimeoutNotifierType type) throws DriverConfigurazioneException, ProtocolException {
        SogliaReadTimeout soglia = null;
        soglia = "ConsegnaContenutiApplicativi".equals(this.idModulo) || this.pa != null ? (this.pa != null ? ReadTimeoutConfigurationUtils.buildSogliaResponseTimeout(timeout, configurazioneGlobale, this.pa, this.nomeConnettoreAsincrono, this.policyTimeoutConfig, new ReadTimeoutContextParam(this.requestInfo, this.getProtocolFactory(), this.getPddContext(), this.state)) : ReadTimeoutConfigurationUtils.buildSogliaResponseTimeout(timeout, false, this.getProtocolFactory())) : (this.pd != null ? ReadTimeoutConfigurationUtils.buildSogliaResponseTimeout(timeout, configurazioneGlobale, this.pd, this.policyTimeoutConfig, new ReadTimeoutContextParam(this.requestInfo, this.getProtocolFactory(), this.getPddContext(), this.state)) : ReadTimeoutConfigurationUtils.buildSogliaResponseTimeout(timeout, true, this.getProtocolFactory()));
        boolean saveInContext = this.policyTimeoutConfig == null || this.policyTimeoutConfig.getAttributeAuthority() == null && this.policyTimeoutConfig.getAttributeAuthorityResponseJwt() == null;
        return new TimeoutNotifier(this.getPddContext(), this.getProtocolFactory(), soglia, type, this.logger.getLogger(), saveInContext);
    }

    public static boolean isReadTimeoutException(Exception e, String message) {
        return "Read timed out".equals(message) && e instanceof SocketTimeoutException;
    }

    public static boolean containsReadTimeoutException(Exception e, String message) {
        return message != null && message.contains("Read timed out") && (e instanceof SocketTimeoutException || org.openspcoop2.utils.Utilities.existsInnerException((Throwable)e, SocketTimeoutException.class));
    }

    protected void processReadTimeoutException(int timeout, boolean configurazioneGlobale, Exception e, String message) {
        block3: {
            try {
                if (timeout > 0 && ConnettoreBaseWithResponse.isReadTimeoutException(e, message)) {
                    TimeoutNotifier notifier = this.getTimeoutNotifier(timeout, configurazioneGlobale, TimeoutNotifierType.WAIT_RESPONSE);
                    notifier.notify(timeout);
                }
            }
            catch (Exception error) {
                if (this.logger == null) break block3;
                this.logger.error("Errore avvenuto durante la registrazione dell'evento di read timeout: " + error.getMessage(), error);
            }
        }
    }

    public static boolean isConnectionTimeoutException(Exception e, String message) {
        return "connect timed out".equals(message) && e instanceof SocketTimeoutException;
    }

    public static boolean containsConnectionTimeoutException(Exception e, String message) {
        return message != null && message.contains("connect timed out") && (e instanceof SocketTimeoutException || org.openspcoop2.utils.Utilities.existsInnerException((Throwable)e, SocketTimeoutException.class));
    }

    protected void processConnectionTimeoutException(int timeout, boolean configurazioneGlobale, Exception e, String message) {
        block3: {
            try {
                if (timeout > 0 && ConnettoreBaseWithResponse.isConnectionTimeoutException(e, message)) {
                    TimeoutNotifier notifier = this.getTimeoutNotifier(timeout, configurazioneGlobale, TimeoutNotifierType.CONNECTION);
                    notifier.notify(timeout);
                }
            }
            catch (Exception error) {
                if (this.logger == null) break block3;
                this.logger.error("Errore avvenuto durante la registrazione dell'evento di connection timeout: " + error.getMessage(), error);
            }
        }
    }

    protected void initCheckContentTypeConfiguration() {
        this.checkContentType = true;
        if (this.idModulo != null) {
            this.checkContentType = "ConsegnaContenutiApplicativi".equals(this.idModulo) ? this.openspcoopProperties.isControlloContentTypeAbilitatoRicezioneBuste() : this.openspcoopProperties.isControlloContentTypeAbilitatoRicezioneContenutiApplicativi();
        }
    }

    protected void initConfigurationAcceptOnlyReturnCode_202_200() {
        this.acceptOnlyReturnCode_202_200 = true;
        this.acceptOnlyReturnCode_202_200 = this.isRest ? false : ("ConsegnaContenutiApplicativi".equals(this.idModulo) ? this.openspcoopProperties.isAcceptOnlyReturnCode_200_202_consegnaContenutiApplicativi() : this.openspcoopProperties.isAcceptOnlyReturnCode_200_202_inoltroBuste());
    }

    protected boolean dumpResponse(Map<String, List<String>> trasporto) throws Exception {
        Exception exceptionCheck = null;
        try {
            if (this.isRest) {
                this.checkRestResponseMessageType();
            } else {
                this.checkSoapResponseMessageType();
            }
        }
        catch (Exception e) {
            exceptionCheck = e;
        }
        boolean returnValue = false;
        try {
            returnValue = this._dumpResponse(trasporto);
        }
        catch (Exception e) {
            if (exceptionCheck != null) {
                throw exceptionCheck;
            }
            throw e;
        }
        if (exceptionCheck != null) {
            throw exceptionCheck;
        }
        return returnValue;
    }

    private DumpByteArrayOutputStream readResponseForDump() throws Exception {
        DumpByteArrayOutputStream bout = null;
        try {
            bout = new DumpByteArrayOutputStream(this.dumpBinario_soglia, this.dumpBinario_repositoryFile, this.idTransazione, TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO.getValue());
            this.emitDiagnosticStartDumpBinarioRispostaIngresso();
            CopyStream.copy((InputStream)this.isResponse, (OutputStream)bout);
            this.isResponse.close();
        }
        finally {
            try {
                if (bout != null) {
                    bout.flush();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return bout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _dumpResponse(Map<String, List<String>> trasporto) throws Exception {
        if (this.isResponse != null) {
            this.emitDiagnosticResponseRead(this.isResponse);
            DumpByteArrayOutputStream bout = null;
            try {
                bout = this.readResponseForDump();
                if (this.debug) {
                    this.logger.info("Messaggio ricevuto (ContentType:" + this.tipoRisposta + ") :\n" + bout.toString(), false);
                }
                this.isResponse = bout.isSerializedOnFileSystem() ? new FileInputStream(bout.getSerializedFile()) : new ByteArrayInputStream(bout.toByteArray());
                this.dumpBinarioRispostaIngresso(bout, this.messageTypeResponse, trasporto);
            }
            finally {
                try {
                    if (bout != null) {
                        bout.clearResources();
                    }
                }
                catch (Throwable t) {
                    this.logger.error("Release resources failed: " + t.getMessage(), t);
                }
            }
        }
        if (this.debug) {
            if (this.tipoRisposta != null) {
                this.logger.info("Messaggio ricevuto (ContentType:" + this.tipoRisposta + ") senza contenuto nell'http-reply", false);
            } else {
                this.logger.info("Messaggio ricevuto senza contenuto nell'http-reply", false);
            }
        }
        this.emitDiagnosticStartDumpBinarioRispostaIngresso();
        this.dumpBinarioRispostaIngresso(null, null, trasporto);
        return true;
    }

    private void checkRestResponseMessageType() throws Exception {
        if (this.messageTypeResponse != null) {
            return;
        }
        String msgErrore = null;
        Exception exErrore = null;
        String contentTypeString = "N.D.";
        if (this.tipoRisposta != null && !"".equals(this.tipoRisposta)) {
            contentTypeString = this.tipoRisposta;
            try {
                ContentTypeUtilities.validateContentType((String)contentTypeString);
            }
            catch (Exception error) {
                exErrore = error;
                msgErrore = "Content-Type '" + contentTypeString + "' presente nella risposta non valido: " + error.getMessage();
            }
        }
        if (msgErrore == null) {
            try {
                this.messageTypeResponse = this.requestInfo.getBindingConfig().getResponseMessageType(this.requestMsg.getServiceBinding(), this.requestMsg.getTransportRequestContext(), this.tipoRisposta, this.codice > 0 ? Integer.valueOf(this.codice) : null);
                if (this.messageTypeResponse == null) {
                    String ctConosciuti = this.requestInfo.getBindingConfig().getContentTypesSupportedAsString(this.requestMsg.getServiceBinding(), MessageRole.RESPONSE, this.requestMsg.getTransportRequestContext());
                    if (this.tipoRisposta == null) {
                        throw new Exception("Header Content-Type non risulta definito nell'http reply e non esiste una configurazione che supporti tale casistica. Content-Type conosciuti: " + ctConosciuti);
                    }
                    throw new Exception("Header Content-Type definito nell'http reply non \u00e8 tra quelli conosciuti: " + ctConosciuti);
                }
            }
            catch (Exception e) {
                exErrore = e;
                msgErrore = "Non \u00e8 stato possibile comprendere come trattare il messaggio ricevuto (Content-Type: " + contentTypeString + "): " + e.getMessage();
            }
        }
        if (msgErrore != null) {
            if (this.checkContentType) {
                this.logger.error(msgErrore, exErrore);
                Exception e = new Exception(msgErrore);
                this.getPddContext().addObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO, true);
                this.getPddContext().addObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, ParseExceptionUtils.buildParseException((Throwable)e, (MessageRole)MessageRole.RESPONSE));
                throw e;
            }
            msgErrore = msgErrore + "; viene utilizzata forzatamente la tipologia " + MessageType.BINARY.name() + " come modalit\u00e0 di gestione del messaggio";
            this.logger.warn(msgErrore, exErrore);
            this.messageTypeResponse = MessageType.BINARY;
        }
    }

    protected boolean doRestResponse() throws Exception {
        block8: {
            OpenSPCoop2MessageParseResult pr;
            if (this.debug) {
                this.logger.debug("gestione REST in corso ...");
            }
            this.checkRestResponseMessageType();
            InputStream isParam = null;
            if (this.contentLength >= 0L) {
                isParam = this.isResponse;
                if (this.contentLength == 0L) {
                    isParam = null;
                }
            } else {
                isParam = this.isResponse;
            }
            TransportResponseContext responseContext = new TransportResponseContext(this.logger.getLogger());
            responseContext.setCodiceTrasporto("" + this.codice);
            responseContext.setContentLength(this.contentLength);
            responseContext.setHeaders(this.propertiesTrasportoRisposta);
            if (isParam != null) {
                this.emitDiagnosticResponseRead(isParam);
            }
            if ((pr = Utilities.getOpenspcoop2MessageFactory(this.logger.getLogger(), this.requestMsg, this.requestInfo, MessageRole.RESPONSE).createMessage(this.messageTypeResponse, responseContext, isParam, this.notifierInputStreamParams, this.openspcoopProperties.getAttachmentsProcessingMode())).getParseException() != null) {
                this.getPddContext().addObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, pr.getParseException());
            }
            try {
                this.responseMsg = pr.getMessage_throwParseException();
            }
            catch (Exception e) {
                boolean premature;
                this.responseMsg = null;
                boolean result2XX = this.codice >= 200 && this.codice <= 299;
                boolean bl = premature = org.openspcoop2.utils.Utilities.existsInnerMessageException((Throwable)e, (String)"Premature end of file", (boolean)true) && result2XX;
                if (premature) break block8;
                this.eccezioneProcessamento = e;
                this.errore = "Errore avvenuto durante il parsing della risposta: " + this.readExceptionMessageFromException(e);
                this.logger.error("Errore avvenuto durante il parsing della risposta: " + this.readExceptionMessageFromException(e), e);
                if (!result2XX) break block8;
                return false;
            }
        }
        return true;
    }

    private void checkSoapResponseMessageType() throws Exception {
        if (this.messageTypeResponse != null) {
            return;
        }
        this.contentTypeMessaggioOriginale_tunnelSoap = this.tipoRisposta;
        if (this.isResponse != null) {
            if (!this.sbustamentoSoap) {
                Object msgErrore = null;
                Exception exErrore = null;
                String contentTypeString = "N.D.";
                if (this.tipoRisposta != null && !"".equals(this.tipoRisposta)) {
                    contentTypeString = this.tipoRisposta;
                    try {
                        ContentTypeUtilities.validateContentType((String)contentTypeString);
                    }
                    catch (Exception error) {
                        exErrore = error;
                        msgErrore = "Content-Type '" + contentTypeString + "' presente nella risposta non valido: " + error.getMessage();
                    }
                }
                if (msgErrore == null) {
                    try {
                        if (this.tipoRisposta == null) {
                            msgErrore = "Header Content-Type non definito nell'http reply";
                        } else {
                            if (this.requestInfo == null) {
                                throw new Exception("BindingConfig is null");
                            }
                            if (this.requestInfo.getBindingConfig() == null) {
                                throw new Exception("BindingConfig is null");
                            }
                            if (this.requestMsg == null) {
                                throw new Exception("RequestMsg is null");
                            }
                            this.messageTypeResponse = this.requestInfo.getBindingConfig().getResponseMessageType(this.requestMsg.getServiceBinding(), this.requestMsg.getTransportRequestContext(), this.tipoRisposta, this.codice > 0 ? Integer.valueOf(this.codice) : null);
                        }
                        if (this.messageTypeResponse == null) {
                            String ctConosciuti = this.requestInfo.getBindingConfig().getContentTypesSupportedAsString(this.requestMsg.getServiceBinding(), MessageRole.RESPONSE, this.requestMsg.getTransportRequestContext());
                            if (this.tipoRisposta == null) {
                                throw new Exception("Header Content-Type non risulta definito nell'http reply e non esiste una configurazione che supporti tale casistica. Content-Type conosciuti: " + ctConosciuti);
                            }
                            throw new Exception("Header Content-Type definito nell'http reply non \u00e8 tra quelli conosciuti: " + ctConosciuti);
                        }
                        if (!this.requestMsg.getMessageType().equals((Object)this.messageTypeResponse)) {
                            msgErrore = "Header Content-Type definito nell'http reply associato ad un tipo (" + this.messageTypeResponse.name() + ") differente da quello associato al messaggio di richiesta (" + this.requestMsg.getMessageType().name() + ")";
                        }
                    }
                    catch (Exception e) {
                        exErrore = e;
                        msgErrore = "Non \u00e8 stato possibile comprendere come trattare il messaggio ricevuto (Content-Type: " + contentTypeString + "): " + e.getMessage();
                    }
                }
                if (msgErrore != null) {
                    if (this.checkContentType) {
                        Exception e = null;
                        if (exErrore != null) {
                            this.logger.error((String)msgErrore, exErrore);
                            e = new Exception((String)msgErrore, exErrore);
                        } else {
                            this.logger.error((String)msgErrore);
                            e = new Exception((String)msgErrore);
                        }
                        this.getPddContext().addObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO, true);
                        this.getPddContext().addObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, ParseExceptionUtils.buildParseException((Throwable)e, (MessageRole)MessageRole.RESPONSE));
                        throw e;
                    }
                    this.messageTypeResponse = MessageType.SOAP_11;
                    this.tipoRisposta = SoapUtils.getSoapContentTypeForMessageWithoutAttachments((MessageType)this.messageTypeResponse);
                    msgErrore = (String)msgErrore + "; per trattare il messaggio viene utilizzato forzatamente il content-type " + this.tipoRisposta + " e la tipologia " + MessageType.SOAP_11.name();
                    if (exErrore != null) {
                        this.logger.warn((String)msgErrore, exErrore);
                    } else {
                        this.logger.warn((String)msgErrore);
                    }
                }
            } else {
                this.messageTypeResponse = this.requestMsg.getMessageType();
                this.tipoRisposta = SoapUtils.getSoapContentTypeForMessageWithoutAttachments((MessageType)this.messageTypeResponse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected boolean doSoapResponse() throws Exception {
        tipoLetturaRisposta = null;
        if (this.debug) {
            this.logger.debug("gestione WS/SOAP in corso ...");
        }
        this.checkSoapResponseMessageType();
        if (this.isResponse != null) {
            responseContext = new TransportResponseContext(this.logger.getLogger());
            responseContext.setCodiceTrasporto("" + this.codice);
            responseContext.setContentLength(this.contentLength);
            responseContext.setHeaders(this.propertiesTrasportoRisposta);
            this.emitDiagnosticResponseRead(this.isResponse);
            try {
                if (!this.sbustamentoSoap) {
                    if (this.debug) {
                        this.logger.debug("Ricostruzione normale...");
                    }
                    tipoLetturaRisposta = "Parsing Risposta SOAP";
                    if (this.contentLength > 0L) {
                        pr = Utilities.getOpenspcoop2MessageFactory(this.logger.getLogger(), this.requestMsg, this.requestInfo, MessageRole.RESPONSE).createMessage(this.messageTypeResponse, responseContext, this.isResponse, this.notifierInputStreamParams, this.openspcoopProperties.getAttachmentsProcessingMode());
                        if (pr.getParseException() != null) {
                            this.getPddContext().addObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, pr.getParseException());
                        }
                        this.responseMsg = pr.getMessage_throwParseException();
                    } else if (this.contentLength == 0L) {
                        this.responseMsg = null;
                    } else {
                        try {
                            pr = Utilities.getOpenspcoop2MessageFactory(this.logger.getLogger(), this.requestMsg, this.requestInfo, MessageRole.RESPONSE).createMessage(this.messageTypeResponse, responseContext, this.isResponse, this.notifierInputStreamParams, this.openspcoopProperties.getAttachmentsProcessingMode());
                            if (pr.getParseException() != null) {
                                this.getPddContext().addObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, pr.getParseException());
                            }
                            this.responseMsg = pr.getMessage_throwParseException();
                        }
                        catch (Exception e) {
                            this.responseMsg = null;
                            result2XX = this.codice >= 200 && this.codice <= 299;
                            v0 = premature = org.openspcoop2.utils.Utilities.existsInnerMessageException((Throwable)e, (String)"Premature end of file", (boolean)true) != false && result2XX != false;
                            if (premature) ** GOTO lbl83
                            this.eccezioneProcessamento = e;
                            this.errore = "Errore avvenuto durante il parsing della risposta: " + this.readExceptionMessageFromException(e);
                            this.logger.error("Errore avvenuto durante il parsing della risposta: " + this.readExceptionMessageFromException(e), e);
                            if (!result2XX) ** GOTO lbl83
                            return false;
                        }
                    }
                } else {
                    isParam = null;
                    if (this.contentLength >= 0L) {
                        isParam = this.isResponse;
                        if (this.contentLength == 0L) {
                            isParam = null;
                        }
                    } else {
                        isParam = this.isResponse;
                    }
                    if (isParam != null) {
                        cis = null;
                        try {
                            cis = new CountingInputStream(isParam);
                            if (this.imbustamentoConAttachment) {
                                if (this.debug) {
                                    this.logger.debug("Imbustamento con attachments...");
                                }
                                tipoLetturaRisposta = "Costruzione messaggio SOAP per Tunnel con mimeType " + this.mimeTypeAttachment;
                                this.responseMsg = TunnelSoapUtils.imbustamentoMessaggioConAttachment((OpenSPCoop2MessageFactory)Utilities.getOpenspcoop2MessageFactory(this.logger.getLogger(), this.requestMsg, this.requestInfo, MessageRole.RESPONSE), (MessageType)this.messageTypeResponse, (MessageRole)MessageRole.RESPONSE, (InputStream)cis, (String)this.mimeTypeAttachment, (boolean)MailcapActivationReader.existsDataContentHandler((String)this.mimeTypeAttachment), (String)this.contentTypeMessaggioOriginale_tunnelSoap, (String)this.openspcoopProperties.getHeaderSoapActorIntegrazione());
                            } else {
                                if (this.debug) {
                                    this.logger.debug("Imbustamento messaggio...");
                                }
                                tipoLetturaRisposta = "Imbustamento messaggio in un messaggio SOAP";
                                msg = org.openspcoop2.utils.Utilities.getAsByteArray((InputStream)cis);
                                if (msg == null || msg.length <= 0) {
                                    throw new Exception("Contenuto messaggio da imbustare non presente");
                                }
                                this.isResponse.close();
                                this.isResponse = new ByteArrayInputStream(msg);
                                pr = Utilities.getOpenspcoop2MessageFactory(this.logger.getLogger(), this.requestMsg, this.requestInfo, MessageRole.RESPONSE).envelopingMessage(this.messageTypeResponse, this.tipoRisposta, this.soapAction, responseContext, this.isResponse, this.notifierInputStreamParams, this.openspcoopProperties.getAttachmentsProcessingMode(), true, this.openspcoopProperties.useSoapMessageReader(), this.openspcoopProperties.getSoapMessageReaderBufferThresholdKb());
                                if (pr.getParseException() != null) {
                                    this.getPddContext().addObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, pr.getParseException());
                                }
                                this.responseMsg = pr.getMessage_throwParseException();
                            }
                            if (this.responseMsg != null) {
                                this.responseMsg.updateIncomingMessageContentLength(cis.getByteCount());
                            }
                        }
                        finally {
                            try {
                                if (cis != null) {
                                    cis.close();
                                }
                            }
                            catch (Exception msg) {}
                        }
                    }
                }
                try {
                    if (this.responseMsg != null) {
                        if (this.responseMsg instanceof AbstractOpenSPCoop2Message_soap_impl) {
                            soap = (AbstractOpenSPCoop2Message_soap_impl)this.responseMsg;
                            if (!soap.hasContent()) {
                                this.responseMsg = null;
                            }
                        } else {
                            this.responseMsg.castAsSoap().getSOAPPart().getEnvelope();
                        }
                    }
                }
                catch (Exception e) {
                    this.responseMsg = null;
                    result2XX = this.codice >= 200 && this.codice <= 299;
                    v1 = premature = org.openspcoop2.utils.Utilities.existsInnerMessageException((Throwable)e, (String)"Premature end of file", (boolean)true) != false && result2XX != false;
                    if (!premature) {
                        this.eccezioneProcessamento = e;
                        this.errore = "Errore avvenuto durante il parsing della risposta: " + this.readExceptionMessageFromException(e);
                        this.logger.error("Errore avvenuto durante il parsing della risposta: " + this.readExceptionMessageFromException(e), e);
                        if (result2XX) {
                            return false;
                        }
                    }
                }
            }
            catch (Exception e) {
                this.eccezioneProcessamento = e;
                msgErrore = this.readExceptionMessageFromException(e);
                this.errore = "Errore avvenuto durante il processamento della risposta (" + (String)tipoLetturaRisposta + "): " + msgErrore;
                this.logger.error("Errore avvenuto durante il processamento della risposta (" + (String)tipoLetturaRisposta + "): " + msgErrore, e);
                return false;
            }
            if (this.debug) {
                this.logger.debug("Save messaggio...");
            }
            try {
                if (this.responseMsg != null && this.responseMsg.castAsSoap().hasAttachments() && this.responseMsg.castAsSoap().countAttachments() == 0) {
                    this.responseMsg.castAsSoap().getSOAPPart();
                }
            }
            catch (Exception e) {
                this.eccezioneProcessamento = e;
                this.errore = "Errore avvenuto durante il salvataggio della risposta: " + this.readExceptionMessageFromException(e);
                this.logger.error("Errore avvenuto durante il salvataggio della risposta: " + this.readExceptionMessageFromException(e), e);
                return false;
            }
        }
        return true;
    }
}

