/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.GestioneToken;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.constants.StatoFunzionalitaConWarning;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneGet;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.constants.CostantiConnettori;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.ConfigurazionePdDReader;
import org.openspcoop2.pdd.core.byok.BYOKUnwrapPolicyUtilities;
import org.openspcoop2.pdd.core.connettori.ConnettoreBase;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreHTTPSProperties;
import org.openspcoop2.pdd.core.dynamic.DynamicMapBuilderUtils;
import org.openspcoop2.pdd.core.token.PolicyGestioneToken;
import org.openspcoop2.pdd.core.token.PolicyNegoziazioneToken;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.token.attribute_authority.AttributeAuthorityUtilities;
import org.openspcoop2.pdd.core.token.attribute_authority.PolicyAttributeAuthority;
import org.openspcoop2.protocol.registry.CertificateUtils;
import org.openspcoop2.protocol.registry.RegistroServiziReader;
import org.openspcoop2.security.keystore.cache.GestoreOCSPResource;
import org.openspcoop2.utils.LoggerBuffer;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeystoreParams;
import org.openspcoop2.utils.certificate.ocsp.IOCSPResourceReader;
import org.openspcoop2.utils.certificate.ocsp.OCSPValidatorImpl;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.regexp.RegExpUtilities;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.transport.http.IBYOKUnwrapManager;
import org.openspcoop2.utils.transport.http.SSLConfig;
import org.openspcoop2.utils.transport.http.SSLUtilities;
import org.openspcoop2.utils.transport.http.WrappedLogSSLSocketFactory;
import org.slf4j.Logger;

public class ConnettoreCheck {
    public static final String POLICY_TIPO_ENDPOINT = "__POLICY_TIPO_ENDPOINT";
    public static final String POLICY_TIPO_ENDPOINT_DYNAMIC_DISCOVERY = "DynamicDiscovery";
    public static final String POLICY_TIPO_ENDPOINT_VALIDAZIONE_JWT = "ValidazioneJWT";
    public static final String POLICY_TIPO_ENDPOINT_INTROSPECTION = "Introspection";
    public static final String POLICY_TIPO_ENDPOINT_USERINFO = "UserInfo";

    public static boolean checkSupported(Connettore connettore) {
        return ConnettoreCheck.checkSupported(connettore.mappingIntoConnettoreConfigurazione());
    }

    public static boolean checkSupported(org.openspcoop2.core.config.Connettore connettore) {
        TipiConnettore tipo = null;
        try {
            tipo = TipiConnettore.valueOf((String)connettore.getTipo().toUpperCase());
            if (tipo != null) {
                switch (tipo) {
                    case HTTP: 
                    case HTTPS: 
                    case STATUS: {
                        return true;
                    }
                }
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void check(long idConnettore, boolean registro, Logger log) throws ConnettoreException {
        if (registro) {
            for (IDriverRegistroServiziGet iDriverRegistroServiziGet : RegistroServiziReader.getDriverRegistroServizi().values()) {
                if (!(iDriverRegistroServiziGet instanceof DriverRegistroServiziDB)) continue;
                try {
                    Connettore connettore = ((DriverRegistroServiziDB)iDriverRegistroServiziGet).getConnettore(idConnettore);
                    ConnettoreCheck.check(connettore, log);
                    return;
                }
                catch (Throwable e) {
                    throw new ConnettoreException(e.getMessage(), e);
                }
            }
        } else {
            IDriverConfigurazioneGet iDriverConfigurazioneGet = ConfigurazionePdDReader.getDriverConfigurazionePdD();
            if (iDriverConfigurazioneGet instanceof DriverConfigurazioneDB) {
                try {
                    org.openspcoop2.core.config.Connettore connettore = ((DriverConfigurazioneDB)iDriverConfigurazioneGet).getConnettore(idConnettore);
                    ConnettoreCheck.check(connettore, log);
                    return;
                }
                catch (Throwable e) {
                    throw new ConnettoreException(e.getMessage(), e);
                }
            }
        }
        throw new ConnettoreException("Connettore con id '" + idConnettore + "' non trovato");
    }

    public static void check(String nomeConnettore, boolean registro, Logger log) throws ConnettoreException {
        if (registro) {
            for (IDriverRegistroServiziGet iDriverRegistroServiziGet : RegistroServiziReader.getDriverRegistroServizi().values()) {
                if (!(iDriverRegistroServiziGet instanceof DriverRegistroServiziDB)) continue;
                try {
                    Connettore connettore = ((DriverRegistroServiziDB)iDriverRegistroServiziGet).getConnettore(nomeConnettore);
                    ConnettoreCheck.check(connettore, log);
                    return;
                }
                catch (Throwable e) {
                    throw new ConnettoreException(e.getMessage(), e);
                }
            }
        } else {
            IDriverConfigurazioneGet iDriverConfigurazioneGet = ConfigurazionePdDReader.getDriverConfigurazionePdD();
            if (iDriverConfigurazioneGet instanceof DriverConfigurazioneDB) {
                try {
                    org.openspcoop2.core.config.Connettore connettore = ((DriverConfigurazioneDB)iDriverConfigurazioneGet).getConnettore(nomeConnettore);
                    ConnettoreCheck.check(connettore, log);
                    return;
                }
                catch (Throwable e) {
                    throw new ConnettoreException(e.getMessage(), e);
                }
            }
        }
        throw new ConnettoreException("Connettore con nome '" + nomeConnettore + "' non trovato");
    }

    public static List<org.openspcoop2.core.config.Connettore> convertPolicyToConnettore(GenericProperties gp, Logger log) throws ConnettoreException {
        if ("gestionePolicyToken".equals(gp.getTipologia())) {
            return ConnettoreCheck.convertTokenPolicyValidazioneToConnettore(gp, log);
        }
        if ("retrievePolicyToken".equals(gp.getTipologia())) {
            return ConnettoreCheck.convertTokenPolicyNegoziazioneToConnettore(gp, log);
        }
        if ("attributeAuthority".equals(gp.getTipologia())) {
            return ConnettoreCheck.convertAttributeAuthorityToConnettore(gp, log);
        }
        throw new ConnettoreException("Tipologia '" + gp.getTipologia() + "' non gestita");
    }

    public static List<org.openspcoop2.core.config.Connettore> convertTokenPolicyValidazioneToConnettore(GenericProperties gp, Logger log) throws ConnettoreException {
        try {
            String userInfoEndpoint;
            String introspectionEndpoint;
            String validazioneJWTEndpoint;
            if (log != null) {
                // empty if block
            }
            List<org.openspcoop2.core.config.Connettore> lNull = null;
            GestioneToken gestione = new GestioneToken();
            gestione.setValidazione(StatoFunzionalitaConWarning.ABILITATO);
            gestione.setIntrospection(StatoFunzionalitaConWarning.ABILITATO);
            gestione.setUserInfo(StatoFunzionalitaConWarning.ABILITATO);
            PolicyGestioneToken policy = TokenUtilities.convertTo(gp, gestione);
            org.openspcoop2.core.config.Connettore connettoreDynamicDiscovery = null;
            org.openspcoop2.core.config.Connettore connettoreValidazioneJWT = null;
            org.openspcoop2.core.config.Connettore connettoreIntrospection = null;
            org.openspcoop2.core.config.Connettore connettoreUserInfo = null;
            String dynamicDiscoveryEndpoint = policy.getDynamicDiscoveryEndpoint();
            if (StringUtils.isNotEmpty((String)dynamicDiscoveryEndpoint)) {
                connettoreDynamicDiscovery = new org.openspcoop2.core.config.Connettore();
                ConnettoreCheck.addProperty(connettoreDynamicDiscovery, POLICY_TIPO_ENDPOINT, POLICY_TIPO_ENDPOINT_DYNAMIC_DISCOVERY);
                ConnettoreCheck.addProperty(connettoreDynamicDiscovery, "location", dynamicDiscoveryEndpoint);
            }
            String string = validazioneJWTEndpoint = policy.isValidazioneJWTLocationHttp() ? policy.getValidazioneJWTLocation() : null;
            if (StringUtils.isNotEmpty((String)validazioneJWTEndpoint)) {
                connettoreValidazioneJWT = new org.openspcoop2.core.config.Connettore();
                ConnettoreCheck.addProperty(connettoreValidazioneJWT, POLICY_TIPO_ENDPOINT, POLICY_TIPO_ENDPOINT_VALIDAZIONE_JWT);
                ConnettoreCheck.addProperty(connettoreValidazioneJWT, "location", validazioneJWTEndpoint);
            }
            if (StringUtils.isNotEmpty((String)(introspectionEndpoint = policy.getIntrospectionEndpoint()))) {
                connettoreIntrospection = new org.openspcoop2.core.config.Connettore();
                ConnettoreCheck.addProperty(connettoreIntrospection, POLICY_TIPO_ENDPOINT, POLICY_TIPO_ENDPOINT_INTROSPECTION);
                ConnettoreCheck.addProperty(connettoreIntrospection, "location", introspectionEndpoint);
                if (policy.isIntrospectionBasicAuthentication() && StringUtils.isNotEmpty((String)policy.getIntrospectionBasicAuthenticationUsername()) && policy.getIntrospectionBasicAuthenticationPassword() != null) {
                    ConnettoreCheck.addProperty(connettoreIntrospection, "user", policy.getIntrospectionBasicAuthenticationUsername());
                    ConnettoreCheck.addProperty(connettoreIntrospection, "password", policy.getIntrospectionBasicAuthenticationPassword());
                }
                if (policy.isIntrospectionBearerAuthentication() && StringUtils.isNotEmpty((String)policy.getIntrospectionBeareAuthenticationToken())) {
                    ConnettoreCheck.addProperty(connettoreIntrospection, "bearerToken", policy.getIntrospectionBeareAuthenticationToken());
                }
            }
            if (StringUtils.isNotEmpty((String)(userInfoEndpoint = policy.getUserInfoEndpoint()))) {
                connettoreUserInfo = new org.openspcoop2.core.config.Connettore();
                ConnettoreCheck.addProperty(connettoreUserInfo, POLICY_TIPO_ENDPOINT, POLICY_TIPO_ENDPOINT_USERINFO);
                ConnettoreCheck.addProperty(connettoreUserInfo, "location", userInfoEndpoint);
                if (policy.isUserInfoBasicAuthentication() && StringUtils.isNotEmpty((String)policy.getUserInfoBasicAuthenticationUsername()) && policy.getUserInfoBasicAuthenticationPassword() != null) {
                    ConnettoreCheck.addProperty(connettoreUserInfo, "user", policy.getUserInfoBasicAuthenticationUsername());
                    ConnettoreCheck.addProperty(connettoreUserInfo, "password", policy.getUserInfoBasicAuthenticationPassword());
                }
                if (policy.isUserInfoBearerAuthentication() && StringUtils.isNotEmpty((String)policy.getUserInfoBeareAuthenticationToken())) {
                    ConnettoreCheck.addProperty(connettoreUserInfo, "bearerToken", policy.getUserInfoBeareAuthenticationToken());
                }
            }
            if (connettoreDynamicDiscovery != null || connettoreValidazioneJWT != null || connettoreIntrospection != null || connettoreUserInfo != null) {
                boolean https;
                Properties endpointConfig;
                Map mapProperties;
                if (connettoreDynamicDiscovery != null) {
                    mapProperties = connettoreDynamicDiscovery.getProperties();
                    endpointConfig = policy.getProperties().get("endpointConfig");
                    if (endpointConfig != null && !endpointConfig.isEmpty()) {
                        ConnettoreCheck.putAll(endpointConfig, mapProperties);
                    }
                    connettoreDynamicDiscovery.setProperties(mapProperties);
                }
                if (connettoreValidazioneJWT != null) {
                    mapProperties = connettoreValidazioneJWT.getProperties();
                    endpointConfig = policy.getProperties().get("endpointConfig");
                    if (endpointConfig != null && !endpointConfig.isEmpty()) {
                        ConnettoreCheck.putAll(endpointConfig, mapProperties);
                    }
                    connettoreValidazioneJWT.setProperties(mapProperties);
                }
                if (connettoreIntrospection != null) {
                    mapProperties = connettoreIntrospection.getProperties();
                    endpointConfig = policy.getProperties().get("endpointConfig");
                    if (endpointConfig != null && !endpointConfig.isEmpty()) {
                        ConnettoreCheck.putAll(endpointConfig, mapProperties);
                    }
                    connettoreIntrospection.setProperties(mapProperties);
                }
                if (connettoreUserInfo != null) {
                    mapProperties = connettoreUserInfo.getProperties();
                    endpointConfig = policy.getProperties().get("endpointConfig");
                    if (endpointConfig != null && !endpointConfig.isEmpty()) {
                        ConnettoreCheck.putAll(endpointConfig, mapProperties);
                    }
                    connettoreUserInfo.setProperties(mapProperties);
                }
                if (https = policy.isEndpointHttps()) {
                    Map mapProperties2;
                    Properties sslConfig = policy.getProperties().get("sslConfig");
                    if (connettoreDynamicDiscovery != null) {
                        mapProperties2 = connettoreDynamicDiscovery.getProperties();
                        ConnettoreCheck.putAll(sslConfig, mapProperties2);
                        connettoreDynamicDiscovery.setProperties(mapProperties2);
                    }
                    if (connettoreValidazioneJWT != null) {
                        mapProperties2 = connettoreValidazioneJWT.getProperties();
                        ConnettoreCheck.putAll(sslConfig, mapProperties2);
                        connettoreValidazioneJWT.setProperties(mapProperties2);
                    }
                    if (connettoreIntrospection != null) {
                        mapProperties2 = connettoreIntrospection.getProperties();
                        ConnettoreCheck.putAll(sslConfig, mapProperties2);
                        boolean introspectionHttpsClient = policy.isIntrospectionHttpsAuthentication();
                        if (introspectionHttpsClient) {
                            Properties introspectionSslClientConfig = policy.getProperties().get("sslClientConfig");
                            ConnettoreCheck.putAll(introspectionSslClientConfig, mapProperties2);
                            ConnettoreCheck.injectSameKeystoreForHttpsClient(sslConfig, introspectionSslClientConfig, mapProperties2);
                        }
                        connettoreIntrospection.setProperties(mapProperties2);
                    }
                    if (connettoreUserInfo != null) {
                        mapProperties2 = connettoreUserInfo.getProperties();
                        ConnettoreCheck.putAll(sslConfig, mapProperties2);
                        boolean userInfoHttpsClient = policy.isUserInfoHttpsAuthentication();
                        if (userInfoHttpsClient) {
                            Properties userInfoSslClientConfig = policy.getProperties().get("sslClientConfig");
                            ConnettoreCheck.putAll(userInfoSslClientConfig, mapProperties2);
                            ConnettoreCheck.injectSameKeystoreForHttpsClient(sslConfig, userInfoSslClientConfig, mapProperties2);
                        }
                        connettoreUserInfo.setProperties(mapProperties2);
                    }
                }
                ArrayList<org.openspcoop2.core.config.Connettore> l = new ArrayList<org.openspcoop2.core.config.Connettore>();
                if (connettoreDynamicDiscovery != null) {
                    connettoreDynamicDiscovery.setTipo(https ? TipiConnettore.HTTPS.getNome() : TipiConnettore.HTTP.getNome());
                    l.add(connettoreDynamicDiscovery);
                }
                if (connettoreValidazioneJWT != null) {
                    connettoreValidazioneJWT.setTipo(https ? TipiConnettore.HTTPS.getNome() : TipiConnettore.HTTP.getNome());
                    l.add(connettoreValidazioneJWT);
                }
                if (connettoreIntrospection != null) {
                    connettoreIntrospection.setTipo(https ? TipiConnettore.HTTPS.getNome() : TipiConnettore.HTTP.getNome());
                    l.add(connettoreIntrospection);
                }
                if (connettoreUserInfo != null) {
                    connettoreUserInfo.setTipo(https ? TipiConnettore.HTTPS.getNome() : TipiConnettore.HTTP.getNome());
                    l.add(connettoreUserInfo);
                }
                return l;
            }
            return lNull;
        }
        catch (Exception t) {
            throw new ConnettoreException(t.getMessage(), t);
        }
    }

    public static List<org.openspcoop2.core.config.Connettore> convertTokenPolicyNegoziazioneToConnettore(GenericProperties gp, Logger log) throws ConnettoreException {
        try {
            PolicyNegoziazioneToken policy = TokenUtilities.convertTo(gp);
            org.openspcoop2.core.config.Connettore connettore = null;
            String endpoint = policy.getEndpoint();
            if (StringUtils.isNotEmpty((String)endpoint)) {
                boolean https;
                connettore = new org.openspcoop2.core.config.Connettore();
                ConnettoreCheck.addProperty(connettore, "location", endpoint);
                if (policy.isBasicAuthentication() && StringUtils.isNotEmpty((String)policy.getBasicAuthenticationUsername()) && policy.getBasicAuthenticationPassword() != null) {
                    ConnettoreCheck.addProperty(connettore, "user", policy.getBasicAuthenticationUsername());
                    ConnettoreCheck.addProperty(connettore, "password", policy.getBasicAuthenticationPassword());
                }
                if (policy.isBearerAuthentication() && StringUtils.isNotEmpty((String)policy.getBeareAuthenticationToken())) {
                    ConnettoreCheck.addProperty(connettore, "bearerToken", policy.getBeareAuthenticationToken());
                }
                Map mapProperties = connettore.getProperties();
                Properties endpointConfig = policy.getProperties().get("endpointConfig");
                if (endpointConfig != null && !endpointConfig.isEmpty()) {
                    ConnettoreCheck.putAll(endpointConfig, mapProperties);
                }
                if (https = policy.isEndpointHttps()) {
                    Properties sslConfig = policy.getProperties().get("sslConfig");
                    ConnettoreCheck.putAll(sslConfig, mapProperties);
                    boolean httpsClient = policy.isHttpsAuthentication();
                    if (httpsClient) {
                        Properties sslClientConfig = policy.getProperties().get("sslClientConfig");
                        ConnettoreCheck.putAll(sslClientConfig, mapProperties);
                        ConnettoreCheck.injectSameKeystoreForHttpsClient(sslConfig, sslClientConfig, mapProperties);
                    }
                    connettore.setProperties(mapProperties);
                }
                connettore.setTipo(https ? TipiConnettore.HTTPS.getNome() : TipiConnettore.HTTP.getNome());
                ArrayList<org.openspcoop2.core.config.Connettore> l = new ArrayList<org.openspcoop2.core.config.Connettore>();
                l.add(connettore);
                return l;
            }
            return null;
        }
        catch (Throwable t) {
            throw new ConnettoreException(t.getMessage(), t);
        }
    }

    public static List<org.openspcoop2.core.config.Connettore> convertAttributeAuthorityToConnettore(GenericProperties gp, Logger log) throws ConnettoreException {
        try {
            PolicyAttributeAuthority policy = AttributeAuthorityUtilities.convertTo(gp);
            org.openspcoop2.core.config.Connettore connettore = null;
            org.openspcoop2.core.config.Connettore connettoreJwtResponse = null;
            String endpoint = policy.getEndpoint();
            if (StringUtils.isNotEmpty((String)endpoint)) {
                boolean https;
                connettore = new org.openspcoop2.core.config.Connettore();
                ConnettoreCheck.addProperty(connettore, "location", endpoint);
                if (policy.isBasicAuthentication() && StringUtils.isNotEmpty((String)policy.getBasicAuthenticationUsername()) && policy.getBasicAuthenticationPassword() != null) {
                    ConnettoreCheck.addProperty(connettore, "user", policy.getBasicAuthenticationUsername());
                    ConnettoreCheck.addProperty(connettore, "password", policy.getBasicAuthenticationPassword());
                }
                if (policy.isBearerAuthentication() && StringUtils.isNotEmpty((String)policy.getBeareAuthenticationToken())) {
                    ConnettoreCheck.addProperty(connettore, "bearerToken", policy.getBeareAuthenticationToken());
                }
                Map mapProperties = connettore.getProperties();
                Properties endpointConfig = policy.getProperties().get("endpointConfig");
                if (endpointConfig != null && !endpointConfig.isEmpty()) {
                    ConnettoreCheck.putAll(endpointConfig, mapProperties);
                }
                if (https = policy.isEndpointHttps()) {
                    Properties sslConfig = policy.getProperties().get("sslConfig");
                    ConnettoreCheck.putAll(sslConfig, mapProperties);
                    boolean httpsClient = policy.isHttpsAuthentication();
                    if (httpsClient) {
                        Properties sslClientConfig = policy.getProperties().get("sslClientConfig");
                        ConnettoreCheck.putAll(sslClientConfig, mapProperties);
                        ConnettoreCheck.injectSameKeystoreForHttpsClient(sslConfig, sslClientConfig, mapProperties);
                    }
                    connettore.setProperties(mapProperties);
                }
                connettore.setTipo(https ? TipiConnettore.HTTPS.getNome() : TipiConnettore.HTTP.getNome());
            }
            String endpointJwtResponse = null;
            if (policy.isResponseJws() && policy.isResponseJwsLocationHttp()) {
                endpointJwtResponse = policy.getResponseJwsLocation();
            }
            if (StringUtils.isNotEmpty(endpointJwtResponse)) {
                boolean https;
                connettoreJwtResponse = new org.openspcoop2.core.config.Connettore();
                ConnettoreCheck.addProperty(connettoreJwtResponse, "location", endpointJwtResponse);
                Map mapProperties = connettoreJwtResponse.getProperties();
                Properties endpointConfig = policy.getProperties().get("endpointConfig");
                if (endpointConfig != null && !endpointConfig.isEmpty()) {
                    ConnettoreCheck.putAll(endpointConfig, mapProperties);
                }
                if (https = policy.isEndpointHttps()) {
                    Properties sslConfig = policy.getProperties().get("sslConfig");
                    ConnettoreCheck.putAll(sslConfig, mapProperties);
                    connettoreJwtResponse.setProperties(mapProperties);
                }
                connettoreJwtResponse.setTipo(https ? TipiConnettore.HTTPS.getNome() : TipiConnettore.HTTP.getNome());
            }
            if (connettore != null && connettoreJwtResponse != null) {
                ConnettoreCheck.addProperty(connettore, POLICY_TIPO_ENDPOINT, "Endpoint");
                ConnettoreCheck.addProperty(connettoreJwtResponse, POLICY_TIPO_ENDPOINT, "Risposta - TrustStore");
            }
            ArrayList<org.openspcoop2.core.config.Connettore> l = null;
            if (connettore != null || connettoreJwtResponse != null) {
                l = new ArrayList<org.openspcoop2.core.config.Connettore>();
                if (connettore != null) {
                    l.add(connettore);
                }
                if (connettoreJwtResponse != null) {
                    l.add(connettoreJwtResponse);
                }
            }
            return l;
        }
        catch (Throwable t) {
            throw new ConnettoreException(t.getMessage(), t);
        }
    }

    private static void injectSameKeystoreForHttpsClient(Properties sslConfig, Properties sslClientConfig, Map<String, String> mapProperties) {
        if (!sslClientConfig.containsKey("keyStoreLocation") && !sslClientConfig.containsKey("keyStorePassword")) {
            String trustStoreLocation = sslConfig.getProperty("trustStoreLocation");
            String trustStorePassword = sslConfig.getProperty("trustStorePassword");
            if (trustStoreLocation != null) {
                mapProperties.put("keyStoreLocation", trustStoreLocation);
                if (trustStorePassword != null) {
                    mapProperties.put("trustStorePassword", trustStorePassword);
                }
            }
        }
    }

    public static void checkTokenPolicyValidazione(String nome, Logger log) throws ConnettoreException {
        ConnettoreCheck.checkPolicy("gestionePolicyToken", nome, log, null);
    }

    public static void checkTokenPolicyValidazione(String nome, String tipoConnettore, Logger log) throws ConnettoreException {
        ConnettoreCheck.checkPolicy("gestionePolicyToken", nome, log, tipoConnettore);
    }

    public static void checkTokenPolicyValidazioneDynamicDiscovery(String nome, Logger log) throws ConnettoreException {
        ConnettoreCheck.checkPolicy("gestionePolicyToken", nome, log, POLICY_TIPO_ENDPOINT_DYNAMIC_DISCOVERY);
    }

    public static void checkTokenPolicyValidazioneValidazioneJWT(String nome, Logger log) throws ConnettoreException {
        ConnettoreCheck.checkPolicy("gestionePolicyToken", nome, log, POLICY_TIPO_ENDPOINT_VALIDAZIONE_JWT);
    }

    public static void checkTokenPolicyValidazioneIntrospection(String nome, Logger log) throws ConnettoreException {
        ConnettoreCheck.checkPolicy("gestionePolicyToken", nome, log, POLICY_TIPO_ENDPOINT_INTROSPECTION);
    }

    public static void checkTokenPolicyValidazioneUserInfo(String nome, Logger log) throws ConnettoreException {
        ConnettoreCheck.checkPolicy("gestionePolicyToken", nome, log, POLICY_TIPO_ENDPOINT_USERINFO);
    }

    public static void checkTokenPolicyNegoziazione(String nome, Logger log) throws ConnettoreException {
        ConnettoreCheck.checkPolicy("retrievePolicyToken", nome, log, null);
    }

    public static void checkAttributeAuthority(String nome, Logger log) throws ConnettoreException {
        ConnettoreCheck.checkPolicy("attributeAuthority", nome, log, null);
    }

    private static void checkPolicy(String tipologia, String nome, Logger log, String tipoConnettore) throws ConnettoreException {
        IDriverConfigurazioneGet iDriverConfigurazioneGet = ConfigurazionePdDReader.getDriverConfigurazionePdD();
        if (iDriverConfigurazioneGet instanceof DriverConfigurazioneDB) {
            try {
                GenericProperties gp = ((DriverConfigurazioneDB)iDriverConfigurazioneGet).getGenericProperties(tipologia, nome);
                List<org.openspcoop2.core.config.Connettore> l = ConnettoreCheck.convertPolicyToConnettore(gp, log);
                if (l != null && !l.isEmpty()) {
                    for (org.openspcoop2.core.config.Connettore connettore : l) {
                        String tipo;
                        if (tipoConnettore != null && !tipoConnettore.equalsIgnoreCase(tipo = ConnettoreCheck.getPropertyValue(connettore, POLICY_TIPO_ENDPOINT))) continue;
                        try {
                            ConnettoreCheck.check(connettore, log);
                        }
                        catch (Throwable e) {
                            throw new ConnettoreException(e.getMessage(), e);
                        }
                    }
                }
                return;
            }
            catch (Throwable e) {
                throw new ConnettoreException(e.getMessage(), e);
            }
        }
        throw new ConnettoreException("Configurazione con tipologia '" + tipologia + "' e nome '" + nome + "' non trovata");
    }

    public static org.openspcoop2.core.config.Connettore convertConfigProxyJvmToConnettore(Logger log) throws ConnettoreException {
        KeystoreParams truststoreParams;
        org.openspcoop2.core.config.Connettore connettore = null;
        String httpProxyHost = System.getProperty("http.proxyHost");
        String httpProxyPort = System.getProperty("http.proxyPort");
        if (httpProxyHost != null) {
            connettore = new org.openspcoop2.core.config.Connettore();
            String url = "http://" + httpProxyHost + ":" + (httpProxyPort != null ? httpProxyPort : "80");
            ConnettoreCheck.addProperty(connettore, "location", url);
        } else {
            String httpsProxyHost = System.getProperty("https.proxyHost");
            String httpsProxyPort = System.getProperty("https.proxyPort");
            if (httpsProxyHost != null) {
                connettore = new org.openspcoop2.core.config.Connettore();
                String url = "http://" + httpsProxyHost + ":" + (httpsProxyPort != null ? httpsProxyPort : "80");
                ConnettoreCheck.addProperty(connettore, "location", url);
            }
        }
        if (connettore != null && (truststoreParams = CertificateUtils.readTrustStoreParamsJVM()) != null) {
            ConnettoreCheck.addProperty(connettore, "trustStoreLocation", truststoreParams.getPath());
            ConnettoreCheck.addProperty(connettore, "trustStoreType", truststoreParams.getType());
            ConnettoreCheck.addProperty(connettore, "trustStorePassword", truststoreParams.getPassword());
        }
        if (connettore != null) {
            connettore.setTipo(TipiConnettore.HTTP.getNome());
        }
        return connettore;
    }

    public static void checkProxyJvm(Logger log) throws ConnettoreException {
        org.openspcoop2.core.config.Connettore connettore = ConnettoreCheck.convertConfigProxyJvmToConnettore(log);
        if (connettore != null) {
            try {
                ConnettoreCheck._checkHTTP(TipiConnettore.HTTP, connettore, log);
            }
            catch (Throwable e) {
                throw new ConnettoreException(e.getMessage(), e);
            }
        }
    }

    private static void addProperty(org.openspcoop2.core.config.Connettore connettore, String nome, String valore) {
        Property p = new Property();
        p.setNome(nome);
        p.setValore(valore);
        connettore.addProperty(p);
    }

    public static String getPropertyValue(org.openspcoop2.core.config.Connettore connettore, String nome) {
        if (connettore != null && connettore.sizePropertyList() > 0) {
            for (Property p : connettore.getPropertyList()) {
                if (!p.getNome().equals(nome)) continue;
                return p.getValore();
            }
        }
        return null;
    }

    public static void check(Connettore connettore, Logger log) throws ConnettoreException {
        ConnettoreCheck._check(connettore.mappingIntoConnettoreConfigurazione(), log);
    }

    public static void check(org.openspcoop2.core.config.Connettore connettore, Logger log) throws ConnettoreException {
        ConnettoreCheck._check(connettore, log);
    }

    private static void _check(org.openspcoop2.core.config.Connettore connettore, Logger log) throws ConnettoreException {
        if (!ConnettoreCheck.checkSupported(connettore)) {
            throw new ConnettoreException("Tipo '" + connettore.getTipo() + "' non supportato");
        }
        try {
            ConnettoreCheck._checkTokenPolicy(connettore, log);
        }
        catch (Throwable e) {
            throw new ConnettoreException(e.getMessage(), e);
        }
        TipiConnettore tipo = TipiConnettore.valueOf((String)connettore.getTipo().toUpperCase());
        switch (tipo) {
            case HTTP: 
            case HTTPS: {
                try {
                    ConnettoreCheck._checkHTTP(tipo, connettore, log);
                    break;
                }
                catch (Throwable e) {
                    throw new ConnettoreException(e.getMessage(), e);
                }
            }
        }
    }

    private static void _checkTokenPolicy(org.openspcoop2.core.config.Connettore connettore, Logger log) throws Exception {
        Map properties = connettore.getProperties();
        PolicyNegoziazioneToken policyNegoziazioneToken = null;
        if (properties != null && !properties.isEmpty()) {
            for (String propertyName : properties.keySet()) {
                String tokenPolicy;
                if (!"tokenPolicy".equals(propertyName) || (tokenPolicy = (String)properties.get(propertyName)) == null || "".equals(tokenPolicy)) continue;
                boolean forceNoCache = true;
                policyNegoziazioneToken = ConfigurazionePdDManager.getInstance().getPolicyNegoziazioneToken(forceNoCache, tokenPolicy, null);
            }
        }
        if (policyNegoziazioneToken != null) {
            String endpoint = policyNegoziazioneToken.getEndpoint();
            Properties endpointConfig = policyNegoziazioneToken.getProperties().get("endpointConfig");
            boolean https = policyNegoziazioneToken.isEndpointHttps();
            boolean httpsClient = false;
            Properties sslConfig = null;
            Properties sslClientConfig = null;
            if (https) {
                sslConfig = policyNegoziazioneToken.getProperties().get("sslConfig");
                httpsClient = policyNegoziazioneToken.isHttpsAuthentication();
                if (httpsClient) {
                    sslClientConfig = policyNegoziazioneToken.getProperties().get("sslClientConfig");
                }
            }
            boolean basic = policyNegoziazioneToken.isBasicAuthentication();
            String username = null;
            String password = null;
            if (basic) {
                username = policyNegoziazioneToken.getBasicAuthenticationUsername();
                password = policyNegoziazioneToken.getBasicAuthenticationPassword();
            }
            org.openspcoop2.core.config.Connettore connettoreTestPolicy = new org.openspcoop2.core.config.Connettore();
            HashMap<String, String> mapProperties = new HashMap<String, String>();
            mapProperties.put("location", endpoint);
            ConnettoreCheck.putAll(endpointConfig, mapProperties);
            if (https) {
                ConnettoreCheck.putAll(sslConfig, mapProperties);
                if (httpsClient) {
                    ConnettoreCheck.putAll(sslClientConfig, mapProperties);
                }
            }
            if (basic) {
                mapProperties.put("user", username);
                mapProperties.put("password", password);
            }
            connettoreTestPolicy.setProperties(mapProperties);
            try {
                ConnettoreCheck._checkHTTP(https ? TipiConnettore.HTTPS : TipiConnettore.HTTP, connettoreTestPolicy, log);
            }
            catch (Exception e) {
                String prefixConnettore = "[EndpointNegoziazioneToken: " + endpoint + "] ";
                if (endpointConfig.containsKey("proxyHostname")) {
                    String hostProxy = endpointConfig.getProperty("proxyHostname");
                    String portProxy = endpointConfig.getProperty("proxyPort");
                    prefixConnettore = prefixConnettore + " [via Proxy: " + hostProxy + ":" + portProxy + "] ";
                }
                throw new Exception(prefixConnettore + e.getMessage(), e);
            }
        }
    }

    public static void putAll(Properties config, Map<String, String> mapProperties) {
        if (config != null && !config.isEmpty()) {
            for (Object object : config.keySet()) {
                if (!(object instanceof String)) continue;
                String key = (String)object;
                mapProperties.put(key, config.getProperty(key));
            }
        }
    }

    private static void _checkHTTP(TipiConnettore tipoConnettore, org.openspcoop2.core.config.Connettore connettore, Logger log) throws ConnettoreException, UtilsException, MalformedURLException {
        String location;
        SSLConfig sslContextProperties = null;
        Map<String, Object> dynamicMap = null;
        Map properties = connettore.getProperties();
        if (TipiConnettore.HTTPS.equals((Object)tipoConnettore)) {
            sslContextProperties = ConnettoreHTTPSProperties.readProperties(properties);
            dynamicMap = DynamicMapBuilderUtils.buildDynamicMap(null, null, null, log);
            sslContextProperties.setDynamicMap(dynamicMap);
        }
        Proxy.Type proxyType = null;
        String proxyHostname = null;
        int proxyPort = -1;
        String proxyUsername = null;
        String proxyPassword = null;
        if (properties.get("proxyType") != null) {
            String tipo = ((String)properties.get("proxyType")).trim();
            if (CostantiConnettori.CONNETTORE_HTTP_PROXY_TYPE_VALUE_HTTP.equals(tipo)) {
                proxyType = Proxy.Type.HTTP;
            } else if (CostantiConnettori.CONNETTORE_HTTP_PROXY_TYPE_VALUE_HTTPS.equals(tipo)) {
                proxyType = Proxy.Type.HTTP;
            } else {
                throw new ConnettoreException("Proprieta' 'proxyType' non corretta. Impostato un tipo sconosciuto [" + tipo + "] (valori ammessi: " + CostantiConnettori.CONNETTORE_HTTP_PROXY_TYPE_VALUE_HTTP + "," + CostantiConnettori.CONNETTORE_HTTP_PROXY_TYPE_VALUE_HTTPS + ")");
            }
            proxyHostname = (String)properties.get("proxyHostname");
            if (proxyHostname == null) {
                throw new ConnettoreException("Proprieta' 'proxyHostname' non impostata, obbligatoria in presenza della propriet\u00e0 'proxyType'");
            }
            proxyHostname = proxyHostname.trim();
            String proxyPortTmp = (String)properties.get("proxyPort");
            if (proxyPortTmp == null) {
                throw new ConnettoreException("Proprieta' 'proxyPort' non impostata, obbligatoria in presenza della propriet\u00e0 'proxyType'");
            }
            proxyPortTmp = proxyPortTmp.trim();
            try {
                proxyPort = Integer.parseInt(proxyPortTmp);
            }
            catch (Exception e) {
                throw new ConnettoreException("Proprieta' 'proxyPort' non corretta: " + ConnettoreBase.readConnectionExceptionMessageFromException(e));
            }
            proxyUsername = (String)properties.get("proxyUsername");
            if (proxyUsername != null) {
                proxyUsername = proxyUsername.trim();
            }
            if ((proxyPassword = (String)properties.get("proxyPassword")) != null) {
                proxyPassword = proxyPassword.trim();
            } else if (proxyUsername != null) {
                throw new ConnettoreException("Proprieta' 'proxyPassword' non impostata, obbligatoria in presenza della propriet\u00e0 'proxyUsername'");
            }
        }
        boolean debug = false;
        if (properties.get("debug") != null) {
            String debugString = (String)properties.get("debug");
            try {
                debug = Boolean.valueOf(debugString);
            }
            catch (Exception e) {
                throw new ConnettoreException("Proprieta' 'debug' non corretta (" + debugString + "): " + ConnettoreBase.readConnectionExceptionMessageFromException(e));
            }
        }
        SSLContext sslContext = null;
        if (sslContextProperties != null) {
            String policyType;
            OCSPValidatorImpl ocspValidator = null;
            if (properties.get("trustStoreOCSPPolicy") != null && (policyType = (String)properties.get("trustStoreOCSPPolicy")) != null && StringUtils.isNotEmpty((String)policyType)) {
                GestoreOCSPResource ocspResourceReader = new GestoreOCSPResource(null);
                String crlInputConfig = (String)properties.get("trustStoreCRLs");
                LoggerBuffer lb = new LoggerBuffer();
                lb.setLogDebug(log);
                lb.setLogError(log);
                ocspValidator = new OCSPValidatorImpl(lb, crlInputConfig, policyType, (IOCSPResourceReader)ocspResourceReader);
            }
            IBYOKUnwrapManager byokManager = null;
            if (sslContextProperties.getKeyStoreLocation() != null) {
                try {
                    byokManager = BYOKUnwrapPolicyUtilities.getBYOKUnwrapManager(sslContextProperties.getKeyStoreBYOKPolicy(), dynamicMap);
                }
                catch (Exception e) {
                    throw new UtilsException(e.getMessage(), (Throwable)e);
                }
            }
            StringBuilder bfSSLConfig = new StringBuilder();
            sslContext = SSLUtilities.generateSSLContext((SSLConfig)sslContextProperties, ocspValidator, (IBYOKUnwrapManager)byokManager, (StringBuilder)bfSSLConfig);
        }
        if (ConnettoreCheck.locationDefinedByVariable(location = (String)properties.get("location"))) {
            return;
        }
        URL url = new URL(location);
        URLConnection connection = null;
        HttpURLConnection httpConn = null;
        boolean connect = false;
        try {
            String apiKey;
            String bearerToken;
            String clientCertificateConfigurated;
            SSLSocketFactory sslSocketFactory;
            HttpsURLConnection httpsConn;
            if (proxyType == null) {
                if (debug) {
                    ConnettoreCheck.logInfo(log, "Creazione connessione alla URL [" + location + "]...");
                }
                connection = url.openConnection();
            } else {
                if (debug) {
                    ConnettoreCheck.logInfo(log, "Creazione connessione alla URL [" + location + "] (via proxy " + proxyHostname + ":" + proxyPort + ") (username[" + proxyUsername + "] password[" + proxyPassword + "])...");
                }
                if (proxyUsername != null) {
                    // empty if block
                }
                Proxy proxy = new Proxy(proxyType, new InetSocketAddress(proxyHostname, proxyPort));
                connection = url.openConnection(proxy);
            }
            httpConn = (HttpURLConnection)connection;
            if (sslContextProperties != null) {
                httpsConn = (HttpsURLConnection)httpConn;
                sslSocketFactory = sslContext.getSocketFactory();
                if (debug) {
                    clientCertificateConfigurated = sslContextProperties.getKeyStoreLocation();
                    sslSocketFactory = new WrappedLogSSLSocketFactory(sslSocketFactory, log, "", clientCertificateConfigurated);
                }
                httpsConn.setSSLSocketFactory(sslSocketFactory);
                StringBuilder bfLog = new StringBuilder();
                HostnameVerifier hostnameVerifier = SSLUtilities.generateHostnameVerifier((SSLConfig)sslContextProperties, (StringBuilder)bfLog, (Logger)LoggerWrapperFactory.getLogger(ConnettoreCheck.class), (Loader)new Loader());
                if (hostnameVerifier != null) {
                    httpsConn.setHostnameVerifier(hostnameVerifier);
                }
            } else if (debug && httpConn instanceof HttpsURLConnection && (httpsConn = (HttpsURLConnection)httpConn).getSSLSocketFactory() != null) {
                sslSocketFactory = httpsConn.getSSLSocketFactory();
                clientCertificateConfigurated = SSLUtilities.getJvmHttpsClientCertificateConfigurated();
                sslSocketFactory = new WrappedLogSSLSocketFactory(sslSocketFactory, log, "", clientCertificateConfigurated);
                httpsConn.setSSLSocketFactory(sslSocketFactory);
            }
            httpConn.setInstanceFollowRedirects(false);
            if (proxyType != null && proxyUsername != null) {
                if (debug) {
                    ConnettoreCheck.logDebug(log, "Impostazione autenticazione per proxy (username[" + proxyUsername + "] password[" + proxyPassword + "]) ...");
                }
                if (proxyUsername != null && proxyPassword != null) {
                    String authentication = proxyUsername + ":" + proxyPassword;
                    authentication = "Basic " + Base64Utilities.encodeAsString((byte[])authentication.getBytes());
                    httpConn.setRequestProperty("Proxy-Authorization", authentication);
                }
            }
            int connectionTimeout = -1;
            int readConnectionTimeout = -1;
            if (properties.get("connectionTimeout") != null) {
                try {
                    connectionTimeout = Integer.parseInt((String)properties.get("connectionTimeout"));
                }
                catch (Exception clientCertificateConfigurated2) {
                    // empty catch block
                }
            }
            if (connectionTimeout == -1) {
                connectionTimeout = 10000;
            }
            if (properties.get("readConnectionTimeout") != null) {
                try {
                    readConnectionTimeout = Integer.parseInt((String)properties.get("readConnectionTimeout"));
                }
                catch (Exception clientCertificateConfigurated2) {
                    // empty catch block
                }
            }
            if (readConnectionTimeout == -1) {
                readConnectionTimeout = 120000;
            }
            if (debug) {
                ConnettoreCheck.logInfo(log, "Impostazione http timeout CT[" + connectionTimeout + "] RT[" + readConnectionTimeout + "]");
            }
            httpConn.setConnectTimeout(connectionTimeout);
            httpConn.setReadTimeout(readConnectionTimeout);
            String user = (String)properties.get("user");
            String password = (String)properties.get("password");
            if (user != null && password != null) {
                String authentication = user + ":" + password;
                authentication = "Basic " + Base64Utilities.encodeAsString((byte[])authentication.getBytes());
                httpConn.setRequestProperty("Authorization", authentication);
                if (debug) {
                    ConnettoreCheck.logInfo(log, "Impostazione autenticazione (username:" + user + " password:" + password + ") [" + authentication + "]");
                }
            }
            if ((bearerToken = (String)properties.get("bearerToken")) != null) {
                String authorizationHeader = "Bearer " + bearerToken;
                httpConn.setRequestProperty("Authorization", authorizationHeader);
                if (debug) {
                    ConnettoreCheck.logInfo(log, "Impostazione autenticazione bearer [" + authorizationHeader + "]");
                }
            }
            if ((apiKey = (String)properties.get("apiKey")) != null && StringUtils.isNotEmpty((String)apiKey)) {
                String appId;
                String apiKeyHeader = (String)properties.get("apiKeyHeader");
                if (apiKeyHeader == null || StringUtils.isEmpty((String)apiKeyHeader)) {
                    apiKeyHeader = "X-API-KEY";
                }
                httpConn.setRequestProperty(apiKeyHeader, apiKey);
                if (debug) {
                    ConnettoreCheck.logInfo(log, "Impostazione autenticazione api key [" + apiKeyHeader + "]=[" + apiKey + "]");
                }
                if ((appId = (String)properties.get("appId")) != null && StringUtils.isNotEmpty((String)appId)) {
                    String appIdHeader = (String)properties.get("appIdHeader");
                    if (appIdHeader == null || StringUtils.isEmpty((String)appIdHeader)) {
                        appIdHeader = "X-APP-ID";
                    }
                    httpConn.setRequestProperty(appIdHeader, appId);
                    if (debug) {
                        ConnettoreCheck.logInfo(log, "Impostazione autenticazione api key (app id) [" + appIdHeader + "]=[" + appId + "]");
                    }
                }
            }
            connect = true;
            if (debug) {
                ConnettoreCheck.logDebug(log, "Connessione in corso ...");
            }
            httpConn.connect();
            if (debug) {
                ConnettoreCheck.logDebug(log, "Connessione effettuata con successo");
            }
        }
        catch (Exception e) {
            String msgException = ConnettoreBase.readConnectionExceptionMessageFromException(e);
            throw new ConnettoreException(msgException, e);
        }
        finally {
            try {
                if (httpConn != null && connect) {
                    httpConn.disconnect();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean locationDefinedByVariable(String location) throws MalformedURLException {
        if (StringUtils.isNotEmpty((String)location) && RegExpUtilities.isUrlDefinedByVariable((String)location)) {
            boolean check = true;
            if (location.contains("://")) {
                int indexOf;
                if (!location.startsWith("://") && !location.endsWith("://") && (indexOf = location.indexOf("://")) > 0) {
                    String protocol = location.substring(0, indexOf);
                    if (protocol != null && RegExpUtilities.isDefinedByVariable((String)protocol)) {
                        check = false;
                    } else {
                        String other = location.substring(indexOf + "://".length(), location.length());
                        if (other.contains("/")) {
                            int indexOfHostname = other.indexOf("/");
                            if (indexOfHostname > 0) {
                                String hostname = other.substring(0, indexOfHostname);
                                check = hostname == null || !RegExpUtilities.isDefinedByVariable((String)hostname);
                            }
                        } else {
                            check = !RegExpUtilities.isDefinedByVariable((String)location);
                        }
                    }
                }
            } else {
                check = false;
            }
            if (!check) {
                return true;
            }
        }
        return false;
    }

    public static String getCertificati(long idConnettore, boolean registro) throws ConnettoreException {
        if (registro) {
            for (IDriverRegistroServiziGet iDriverRegistroServiziGet : RegistroServiziReader.getDriverRegistroServizi().values()) {
                if (!(iDriverRegistroServiziGet instanceof DriverRegistroServiziDB)) continue;
                try {
                    Connettore connettore = ((DriverRegistroServiziDB)iDriverRegistroServiziGet).getConnettore(idConnettore);
                    return ConnettoreCheck.getCertificati(connettore);
                }
                catch (Throwable e) {
                    throw new ConnettoreException(e.getMessage(), e);
                }
            }
        } else {
            IDriverConfigurazioneGet iDriverConfigurazioneGet = ConfigurazionePdDReader.getDriverConfigurazionePdD();
            if (iDriverConfigurazioneGet instanceof DriverConfigurazioneDB) {
                try {
                    org.openspcoop2.core.config.Connettore connettore = ((DriverConfigurazioneDB)iDriverConfigurazioneGet).getConnettore(idConnettore);
                    return ConnettoreCheck.getCertificati(connettore);
                }
                catch (Throwable e) {
                    throw new ConnettoreException(e.getMessage(), e);
                }
            }
        }
        throw new ConnettoreException("Connettore con id '" + idConnettore + "' non trovato");
    }

    public static String getCertificati(String nomeConnettore, boolean registro) throws ConnettoreException {
        if (registro) {
            for (IDriverRegistroServiziGet iDriverRegistroServiziGet : RegistroServiziReader.getDriverRegistroServizi().values()) {
                if (!(iDriverRegistroServiziGet instanceof DriverRegistroServiziDB)) continue;
                try {
                    Connettore connettore = ((DriverRegistroServiziDB)iDriverRegistroServiziGet).getConnettore(nomeConnettore);
                    return ConnettoreCheck.getCertificati(connettore);
                }
                catch (Throwable e) {
                    throw new ConnettoreException(e.getMessage(), e);
                }
            }
        } else {
            IDriverConfigurazioneGet iDriverConfigurazioneGet = ConfigurazionePdDReader.getDriverConfigurazionePdD();
            if (iDriverConfigurazioneGet instanceof DriverConfigurazioneDB) {
                try {
                    org.openspcoop2.core.config.Connettore connettore = ((DriverConfigurazioneDB)iDriverConfigurazioneGet).getConnettore(nomeConnettore);
                    return ConnettoreCheck.getCertificati(connettore);
                }
                catch (Throwable e) {
                    throw new ConnettoreException(e.getMessage(), e);
                }
            }
        }
        throw new ConnettoreException("Connettore con nome '" + nomeConnettore + "' non trovato");
    }

    public static String getCertificati(Connettore connettore) throws ConnettoreException {
        return ConnettoreCheck._getCertificati(connettore.mappingIntoConnettoreConfigurazione());
    }

    public static String getCertificati(org.openspcoop2.core.config.Connettore connettore) throws ConnettoreException {
        return ConnettoreCheck._getCertificati(connettore);
    }

    public static String getCertificatiTokenPolicyValidazione(String nome, Logger log) throws ConnettoreException {
        return ConnettoreCheck.getCertificatiPolicy("gestionePolicyToken", nome, log, null);
    }

    public static String getCertificatiTokenPolicyValidazione(String nome, String tipoConnettore, Logger log) throws ConnettoreException {
        return ConnettoreCheck.getCertificatiPolicy("gestionePolicyToken", nome, log, tipoConnettore);
    }

    public static String getCertificatiTokenPolicyValidazioneDynamicDiscovery(String nome, Logger log) throws ConnettoreException {
        return ConnettoreCheck.getCertificatiPolicy("gestionePolicyToken", nome, log, POLICY_TIPO_ENDPOINT_DYNAMIC_DISCOVERY);
    }

    public static String getCertificatiTokenPolicyValidazioneJwt(String nome, Logger log) throws ConnettoreException {
        return ConnettoreCheck.getCertificatiPolicy("gestionePolicyToken", nome, log, POLICY_TIPO_ENDPOINT_VALIDAZIONE_JWT);
    }

    public static String getCertificatiTokenPolicyValidazioneIntrospection(String nome, Logger log) throws ConnettoreException {
        return ConnettoreCheck.getCertificatiPolicy("gestionePolicyToken", nome, log, POLICY_TIPO_ENDPOINT_INTROSPECTION);
    }

    public static String getCertificatiTokenPolicyValidazioneUserInfo(String nome, Logger log) throws ConnettoreException {
        return ConnettoreCheck.getCertificatiPolicy("gestionePolicyToken", nome, log, POLICY_TIPO_ENDPOINT_USERINFO);
    }

    public static String getCertificatiTokenPolicyNegoziazione(String nome, Logger log) throws ConnettoreException {
        return ConnettoreCheck.getCertificatiPolicy("retrievePolicyToken", nome, log, null);
    }

    public static String getCertificatiAttributeAuthority(String nome, Logger log) throws ConnettoreException {
        return ConnettoreCheck.getCertificatiPolicy("attributeAuthority", nome, log, null);
    }

    private static String getCertificatiPolicy(String tipologia, String nome, Logger log, String tipoConnettore) throws ConnettoreException {
        block11: {
            IDriverConfigurazioneGet iDriverConfigurazioneGet = ConfigurazionePdDReader.getDriverConfigurazionePdD();
            if (iDriverConfigurazioneGet instanceof DriverConfigurazioneDB) {
                try {
                    GenericProperties gp = ((DriverConfigurazioneDB)iDriverConfigurazioneGet).getGenericProperties(tipologia, nome);
                    List<org.openspcoop2.core.config.Connettore> l = ConnettoreCheck.convertPolicyToConnettore(gp, log);
                    ArrayList<CallSite> hostPort = new ArrayList<CallSite>();
                    if (l == null || l.isEmpty()) break block11;
                    StringBuilder sb = new StringBuilder();
                    for (org.openspcoop2.core.config.Connettore connettore : l) {
                        String endpoint;
                        String tipo;
                        if (tipoConnettore != null && !tipoConnettore.equalsIgnoreCase(tipo = ConnettoreCheck.getPropertyValue(connettore, POLICY_TIPO_ENDPOINT))) continue;
                        if (l.size() > 1 && !hostPort.isEmpty() && (endpoint = ConnettoreCheck.getPropertyValue(connettore, "location")) != null) {
                            try {
                                String check;
                                URL url = new URL(endpoint);
                                int port = url.getPort();
                                if (port <= 0) {
                                    port = "https".equals(url.getProtocol()) ? 443 : 80;
                                }
                                if (hostPort.contains(check = url.getHost() + ":" + port)) continue;
                                hostPort.add((CallSite)((Object)check));
                            }
                            catch (Throwable url) {
                                // empty catch block
                            }
                        }
                        try {
                            String s = ConnettoreCheck._getCertificati(connettore);
                            sb.append(s);
                        }
                        catch (Throwable e) {
                            String tipo2 = null;
                            Object prefixConnettore = tipo2 != null ? "[" + tipo2 + "] " : "";
                            throw new ConnettoreException((String)prefixConnettore + e.getMessage(), e);
                        }
                    }
                    if (sb.length() > 0) {
                        return sb.toString();
                    }
                }
                catch (Throwable e) {
                    throw new ConnettoreException(e.getMessage(), e);
                }
            }
        }
        throw new ConnettoreException("Configurazione con tipologia '" + tipologia + "' e nome '" + nome + "' non trovata");
    }

    private static String _getCertificati(org.openspcoop2.core.config.Connettore connettore) throws ConnettoreException {
        try {
            String location;
            Map properties = connettore.getProperties();
            String string = location = properties != null ? (String)properties.get("location") : null;
            if (location == null || "".equals(location)) {
                throw new Exception("Il connettore non possiede un endpoint");
            }
            URL url = new URL(location);
            String host = url.getHost();
            if (host == null || "".equals(host)) {
                throw new Exception("L'endpoint '" + host + "' non contiene un host");
            }
            int port = url.getPort();
            if (port <= 0) {
                if ("https".equalsIgnoreCase(url.getProtocol())) {
                    port = 443;
                } else if ("http".equalsIgnoreCase(url.getProtocol())) {
                    port = 80;
                } else {
                    throw new Exception("L'endpoint '" + host + "' contiene un protocollo '" + url.getProtocol() + "' non supportato");
                }
            }
            return SSLUtilities.readPeerCertificates((String)host, (int)port);
        }
        catch (Throwable e) {
            throw new ConnettoreException(e.getMessage(), e);
        }
    }

    private static void logDebug(Logger log, String msg) {
        if (log != null) {
            log.debug(msg);
        }
    }

    private static void logInfo(Logger log, String msg) {
        if (log != null) {
            log.info(msg);
        }
    }
}

