/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.soap.SOAPBody;
import org.apache.commons.lang.StringUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultClientConnectionReuseStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.constants.TransferLengthModes;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2RestMessage;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.soap.TunnelSoapUtils;
import org.openspcoop2.pdd.core.connettori.ConnettoreBaseHTTP;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreLogger;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.connettori.ConnettoreUtils;
import org.openspcoop2.pdd.core.connettori.CustomHttpEntity;
import org.openspcoop2.utils.NameValue;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsMultiException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpBodyParameters;
import org.openspcoop2.utils.transport.http.RFC2047Encoding;
import org.openspcoop2.utils.transport.http.RFC2047Utilities;
import org.openspcoop2.utils.transport.http.SSLConfig;
import org.openspcoop2.utils.transport.http.SSLUtilities;
import org.openspcoop2.utils.transport.http.WrappedLogSSLSocketFactory;
import org.slf4j.Logger;

public class ConnettoreHTTPCORE
extends ConnettoreBaseHTTP {
    public static final String ENDPOINT_TYPE = "httpcore";
    private static boolean USE_POOL = true;
    private HttpEntity httpEntityResponse = null;
    private HttpClient httpClient = null;
    private HttpRequestBase httpRequest;
    private static Map<String, PoolingHttpClientConnectionManager> cmMap = new HashMap<String, PoolingHttpClientConnectionManager>();

    public ConnettoreHTTPCORE() {
        this.connettoreHttps = false;
    }

    public ConnettoreHTTPCORE(boolean https) {
        this.connettoreHttps = https;
    }

    private static synchronized void initialize(String key, SSLConnectionSocketFactory sslConnectionSocketFactory) {
        if (!cmMap.containsKey(key)) {
            PoolingHttpClientConnectionManager cm = null;
            if (sslConnectionSocketFactory != null) {
                Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslConnectionSocketFactory).build();
                cm = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            } else {
                cm = new PoolingHttpClientConnectionManager();
            }
            cm.setMaxTotal(200);
            cm.setDefaultMaxPerRoute(5);
            cmMap.put(key, cm);
        }
    }

    private HttpClient buildHttpClient(ConnectionKeepAliveStrategy keepAliveStrategy, SSLSocketFactory sslSocketFactory, boolean usePool) throws UtilsException {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        String key = "default";
        if (this.sslContextProperties != null) {
            key = this.sslContextProperties.toString();
        }
        SSLConnectionSocketFactory sslConnectionSocketFactory = null;
        if (!(this.sslContextProperties == null || usePool && cmMap.containsKey(key))) {
            if (this.debug) {
                String clientCertificateConfigurated = this.sslContextProperties.getKeyStoreLocation();
                sslSocketFactory = new WrappedLogSSLSocketFactory(sslSocketFactory, this.logger.getLogger(), this.logger.buildMsg(""), clientCertificateConfigurated);
            }
            StringBuilder bfLog = new StringBuilder();
            HostnameVerifier hostnameVerifier = SSLUtilities.generateHostnameVerifier((SSLConfig)this.sslContextProperties, (StringBuilder)bfLog, (Logger)this.logger.getLogger(), (Loader)this.loader);
            if (this.debug) {
                this.logger.debug(bfLog.toString());
            }
            if (hostnameVerifier == null) {
                hostnameVerifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
            }
            sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslSocketFactory, hostnameVerifier);
        }
        if (usePool) {
            if (!cmMap.containsKey(key)) {
                ConnettoreHTTPCORE.initialize(key, sslConnectionSocketFactory);
            }
            PoolingHttpClientConnectionManager cm = cmMap.get(key);
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)cm);
        } else if (sslConnectionSocketFactory != null) {
            httpClientBuilder.setSSLSocketFactory(sslConnectionSocketFactory);
        }
        DefaultClientConnectionReuseStrategy defaultClientConnectionReuseStrategy = new DefaultClientConnectionReuseStrategy();
        httpClientBuilder.setConnectionReuseStrategy((ConnectionReuseStrategy)defaultClientConnectionReuseStrategy);
        if (keepAliveStrategy != null) {
            httpClientBuilder.setKeepAliveStrategy(keepAliveStrategy);
        }
        return httpClientBuilder.build();
    }

    @Override
    protected boolean initializePreSend(ResponseCachingConfigurazione responseCachingConfig, ConnettoreMsg request) {
        return this.initialize(request, true, responseCachingConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean send(ConnettoreMsg request) {
        try {
            this.setSSLContext();
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.logger.error("[HTTPS error]" + this.readExceptionMessageFromException(e), e);
            this.errore = "[HTTPS error]" + this.readExceptionMessageFromException(e);
            return false;
        }
        int connectionTimeout = -1;
        boolean connectionTimeoutConfigurazioneGlobale = true;
        int readConnectionTimeout = -1;
        boolean readConnectionTimeoutConfigurazioneGlobale = true;
        try {
            HttpBodyParameters httpBody;
            String apiKey;
            NameValue dpopNv;
            if (this.debug) {
                this.logger.debug("Creazione URL...");
            }
            this.buildLocation();
            if (this.debug) {
                this.logger.debug("Creazione URL [" + this.location + "]...");
            }
            URL url = new URL(this.location);
            ConnectionKeepAliveStrategy keepAliveStrategy = null;
            HashMap<String, List<String>> propertiesTrasportoDebug = null;
            if (this.isDumpBinarioRichiesta()) {
                propertiesTrasportoDebug = new HashMap<String, List<String>>();
            }
            if (this.debug) {
                this.logger.info("Creazione connessione alla URL [" + this.location + "]...", false);
            }
            this.httpClient = this.buildHttpClient(keepAliveStrategy, this.buildSSLContextFactory(), USE_POOL);
            if (this.httpMethod == null) {
                throw new Exception("HttpRequestMethod non definito");
            }
            this.httpRequest = null;
            switch (this.httpMethod) {
                case GET: {
                    this.httpRequest = new HttpGet(url.toString());
                    break;
                }
                case DELETE: {
                    this.httpRequest = new HttpDelete(url.toString());
                    break;
                }
                case HEAD: {
                    this.httpRequest = new HttpHead(url.toString());
                    break;
                }
                case POST: {
                    this.httpRequest = new HttpPost(url.toString());
                    break;
                }
                case PUT: {
                    this.httpRequest = new HttpPost(url.toString());
                    break;
                }
                case OPTIONS: {
                    this.httpRequest = new HttpOptions(url.toString());
                    break;
                }
                case TRACE: {
                    this.httpRequest = new HttpTrace(url.toString());
                    break;
                }
                case PATCH: {
                    this.httpRequest = new HttpPatch(url.toString());
                    break;
                }
                default: {
                    this.httpRequest = new CustomHttpEntity(this.httpMethod, url.toString());
                }
            }
            if (this.httpMethod == null) {
                throw new Exception("HttpRequest non definito ?");
            }
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            OpenSPCoop2SoapMessage soapMessageRequest = null;
            MessageType requestMessageType = this.requestMsg.getMessageType();
            if (this.debug) {
                this.logger.debug("Tipologia Servizio: " + this.requestMsg.getServiceBinding());
            }
            if (this.isSoap) {
                soapMessageRequest = this.requestMsg.castAsSoap();
            }
            this.requestMsg.updateContentType();
            if (this.debug) {
                this.logger.debug("Impostazione content type...");
            }
            String contentTypeRichiesta = null;
            if (this.isSoap) {
                contentTypeRichiesta = this.sbustamentoSoap && soapMessageRequest.countAttachments() > 0 && TunnelSoapUtils.isTunnelOpenSPCoopSoap((OpenSPCoop2SoapMessage)soapMessageRequest) ? TunnelSoapUtils.getContentTypeTunnelOpenSPCoopSoap((SOAPBody)soapMessageRequest.getSOAPBody()) : this.requestMsg.getContentType();
                if (contentTypeRichiesta == null) {
                    throw new Exception("Content-Type del messaggio da spedire non definito");
                }
            } else {
                contentTypeRichiesta = this.requestMsg.getContentType();
            }
            if (this.debug) {
                this.logger.info("Impostazione http Content-Type [" + contentTypeRichiesta + "]", false);
            }
            if (contentTypeRichiesta != null) {
                this.setRequestHeader("Content-Type", contentTypeRichiesta, propertiesTrasportoDebug);
            }
            if (this.debug) {
                this.logger.debug("Impostazione transfer-length...");
            }
            boolean transferEncodingChunked = false;
            TransferLengthModes tlm = null;
            int chunkLength = -1;
            if ("ConsegnaContenutiApplicativi".equals(this.idModulo)) {
                tlm = this.openspcoopProperties.getTransferLengthModes_consegnaContenutiApplicativi();
                chunkLength = this.openspcoopProperties.getChunkLength_consegnaContenutiApplicativi();
            } else {
                tlm = this.openspcoopProperties.getTransferLengthModes_inoltroBuste();
                chunkLength = this.openspcoopProperties.getChunkLength_inoltroBuste();
            }
            transferEncodingChunked = TransferLengthModes.TRANSFER_ENCODING_CHUNKED.equals((Object)tlm);
            if (transferEncodingChunked) {
                // empty if block
            }
            if (this.debug) {
                this.logger.info("Impostazione transfer-length effettuata (chunkLength:" + chunkLength + "): " + tlm, false);
            }
            if (this.debug) {
                this.logger.debug("Impostazione timeout...");
            }
            if (this.properties.get("connectionTimeout") != null) {
                try {
                    connectionTimeout = Integer.parseInt((String)this.properties.get("connectionTimeout"));
                    connectionTimeoutConfigurazioneGlobale = this.properties.containsKey("connectionTimeoutGlobale");
                }
                catch (Exception e) {
                    this.logger.error("Parametro 'connectionTimeout' errato", e);
                }
            }
            if (connectionTimeout == -1) {
                connectionTimeout = 10000;
            }
            if (this.properties.get("readConnectionTimeout") != null) {
                try {
                    readConnectionTimeout = Integer.parseInt((String)this.properties.get("readConnectionTimeout"));
                    readConnectionTimeoutConfigurazioneGlobale = this.properties.containsKey("readConnectionTimeoutGlobale");
                }
                catch (Exception e) {
                    this.logger.error("Parametro 'readConnectionTimeout' errato", e);
                }
            }
            if (readConnectionTimeout == -1) {
                readConnectionTimeout = 120000;
            }
            if (this.debug) {
                this.logger.info("Impostazione http timeout CT[" + connectionTimeout + "] RT[" + readConnectionTimeout + "]", false);
            }
            requestConfigBuilder.setConnectionRequestTimeout(connectionTimeout);
            requestConfigBuilder.setConnectTimeout(connectionTimeout);
            requestConfigBuilder.setSocketTimeout(readConnectionTimeout);
            if (this.debug) {
                this.logger.debug("Impostazione autenticazione...");
            }
            String user = null;
            String password = null;
            if (this.credenziali != null) {
                user = this.credenziali.getUser();
                password = this.credenziali.getPassword();
            } else {
                user = (String)this.properties.get("user");
                password = (String)this.properties.get("password");
            }
            if (user != null && password != null) {
                String authentication = user + ":" + password;
                authentication = "Basic " + Base64Utilities.encodeAsString((byte[])authentication.getBytes());
                this.setRequestHeader("Authorization", authentication, propertiesTrasportoDebug);
                if (this.debug) {
                    this.logger.info("Impostazione autenticazione (username:" + user + " password:" + password + ") [" + authentication + "]", false);
                }
            }
            this.ensureTokenNegotiated(this.httpMethod);
            NameValue nv = this.getTokenHeader();
            if (nv != null) {
                if (this.requestMsg != null && this.requestMsg.getTransportRequestContext() != null) {
                    this.requestMsg.getTransportRequestContext().removeHeader(nv.getName());
                }
                this.setRequestHeader(nv.getName(), nv.getValue(), propertiesTrasportoDebug);
                if (this.debug) {
                    this.logger.info("Impostazione autenticazione token (header-name '" + nv.getName() + "' value '" + nv.getValue() + "')", false);
                }
            }
            if ((dpopNv = this.getDpopBackendHeader()) != null) {
                this.setRequestHeader(dpopNv.getName(), dpopNv.getValue(), propertiesTrasportoDebug);
                if (this.debug) {
                    this.logger.info("Impostazione DPoP backend (header-name '" + dpopNv.getName() + "' value '" + dpopNv.getValue() + "')", false);
                }
            }
            if ((apiKey = (String)this.properties.get("apiKey")) != null && StringUtils.isNotEmpty((String)apiKey)) {
                String appId;
                String apiKeyHeader = (String)this.properties.get("apiKeyHeader");
                if (apiKeyHeader == null || StringUtils.isEmpty((String)apiKeyHeader)) {
                    apiKeyHeader = "X-API-KEY";
                }
                this.setRequestHeader(apiKeyHeader, apiKey, propertiesTrasportoDebug);
                if (this.debug) {
                    this.logger.info("Impostazione autenticazione api key [" + apiKeyHeader + "]=[" + apiKey + "]", false);
                }
                if ((appId = (String)this.properties.get("appId")) != null && StringUtils.isNotEmpty((String)appId)) {
                    String appIdHeader = (String)this.properties.get("appIdHeader");
                    if (appIdHeader == null || StringUtils.isEmpty((String)appIdHeader)) {
                        appIdHeader = "X-APP-ID";
                    }
                    this.setRequestHeader(appIdHeader, appId, propertiesTrasportoDebug);
                    if (this.debug) {
                        this.logger.info("Impostazione autenticazione api key (app id) [" + appIdHeader + "]=[" + appId + "]", false);
                    }
                }
            }
            if (this.forwardProxy_headerName != null && this.forwardProxy_headerValue != null) {
                if (this.requestMsg != null && this.requestMsg.getTransportRequestContext() != null) {
                    this.requestMsg.getTransportRequestContext().removeHeader(this.forwardProxy_headerName);
                }
                this.setRequestHeader(this.forwardProxy_headerName, this.forwardProxy_headerValue, propertiesTrasportoDebug);
                if (this.debug) {
                    this.logger.info("Impostazione ForwardProxy (header-name '" + this.forwardProxy_headerName + "' value '" + this.forwardProxy_headerValue + "')", false);
                }
            }
            if (this.debug) {
                this.logger.debug("Impostazione header di trasporto...");
            }
            this.forwardHttpRequestHeader();
            if (this.propertiesTrasporto != null) {
                for (String key : this.propertiesTrasporto.keySet()) {
                    List values = (List)this.propertiesTrasporto.get(key);
                    if (this.debug && values != null && !values.isEmpty()) {
                        for (Object value : values) {
                            this.logger.info("Set Transport Header [" + key + "]=[" + (String)value + "]", false);
                        }
                    }
                    if (this.encodingRFC2047) {
                        ArrayList<String> valuesEncoded = new ArrayList<String>();
                        if (values != null && !values.isEmpty()) {
                            Object value;
                            value = values.iterator();
                            while (value.hasNext()) {
                                String value2 = (String)value.next();
                                if (!RFC2047Utilities.isAllCharactersInCharset((String)value2, (Charset)this.charsetRFC2047)) {
                                    String encoded = RFC2047Utilities.encode((String)new String(value2), (Charset)this.charsetRFC2047, (RFC2047Encoding)this.encodingAlgorithmRFC2047);
                                    if (this.debug) {
                                        this.logger.info("RFC2047 Encoded value in [" + encoded + "] (charset:" + this.charsetRFC2047 + " encoding-algorithm:" + this.encodingAlgorithmRFC2047 + ")", false);
                                    }
                                    valuesEncoded.add(encoded);
                                    continue;
                                }
                                valuesEncoded.add(value2);
                            }
                        }
                        this.setRequestHeader(this.validazioneHeaderRFC2047, key, valuesEncoded, this.logger, propertiesTrasportoDebug);
                        continue;
                    }
                    this.setRequestHeader(this.validazioneHeaderRFC2047, key, values, this.logger, propertiesTrasportoDebug);
                }
            }
            if (this.isSoap && !this.sbustamentoSoap) {
                if (this.debug) {
                    this.logger.debug("Impostazione soap action...");
                }
                boolean existsTransportProperties = false;
                if (TransportUtils.containsKey((Map)this.propertiesTrasporto, (String)"SOAPAction")) {
                    this.soapAction = TransportUtils.getFirstValue((Map)this.propertiesTrasporto, (String)"SOAPAction");
                    boolean bl = existsTransportProperties = this.soapAction != null;
                }
                if (!existsTransportProperties) {
                    this.soapAction = soapMessageRequest.getSoapAction();
                }
                if (this.soapAction == null) {
                    this.soapAction = "\"OpenSPCoop\"";
                }
                if (MessageType.SOAP_11.equals((Object)this.requestMsg.getMessageType()) && !existsTransportProperties) {
                    this.setRequestHeader("SOAPAction", this.soapAction, propertiesTrasportoDebug);
                }
                if (this.debug) {
                    this.logger.info("SOAP Action inviata [" + this.soapAction + "]", false);
                }
            }
            if ((httpBody = new HttpBodyParameters(this.httpMethod, contentTypeRichiesta)).isDoOutput()) {
                Object httpEntity;
                if (this.debug) {
                    this.logger.debug("Spedizione byte...");
                }
                boolean hasContentRestBuilded = false;
                boolean hasContentRest = false;
                OpenSPCoop2RestMessage restMessage = null;
                if (this.isRest) {
                    restMessage = this.requestMsg.castAsRest();
                    hasContentRest = restMessage.hasContent();
                    hasContentRestBuilded = restMessage.isContentBuilded();
                }
                if (this.isDumpBinarioRichiesta() || this.isSoap || hasContentRestBuilded) {
                    DumpByteArrayOutputStream bout = new DumpByteArrayOutputStream(this.dumpBinario_soglia, this.dumpBinario_repositoryFile, this.idTransazione, TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO.getValue());
                    try {
                        this.emitDiagnosticStartDumpBinarioRichiestaUscita();
                        if (this.isSoap && this.sbustamentoSoap) {
                            if (this.debug) {
                                this.logger.debug("Sbustamento...");
                            }
                            TunnelSoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)soapMessageRequest, (OutputStream)bout);
                        } else {
                            this.requestMsg.writeTo((OutputStream)bout, true);
                        }
                        bout.flush();
                        bout.close();
                        if (this.isDumpBinarioRichiesta()) {
                            this.dumpBinarioRichiestaUscita(bout, requestMessageType, contentTypeRichiesta, this.location, propertiesTrasportoDebug);
                        }
                        httpEntity = null;
                        httpEntity = bout.isSerializedOnFileSystem() ? new FileEntity(bout.getSerializedFile()) : new ByteArrayEntity(bout.toByteArray());
                        if (!(this.httpRequest instanceof HttpEntityEnclosingRequestBase)) throw new Exception("Tipo [" + this.httpRequest.getClass().getName() + "] non utilizzabile per una richiesta di tipo [" + this.httpMethod + "]");
                        ((HttpEntityEnclosingRequestBase)this.httpRequest).setEntity((HttpEntity)httpEntity);
                    }
                    finally {
                        try {
                            bout.clearResources();
                        }
                        catch (Throwable t) {
                            this.logger.error("Release resources failed: " + t.getMessage(), t);
                        }
                    }
                }
                if (hasContentRest) {
                    InputStream isRequest = this.requestMsg.castAsRest().getInputStream();
                    httpEntity = new InputStreamEntity(isRequest);
                    if (!(this.httpRequest instanceof HttpEntityEnclosingRequestBase)) throw new Exception("Tipo [" + this.httpRequest.getClass().getName() + "] non utilizzabile per una richiesta di tipo [" + this.httpMethod + "]");
                    ((HttpEntityEnclosingRequestBase)this.httpRequest).setEntity((HttpEntity)httpEntity);
                }
            } else if (this.isDumpBinarioRichiesta()) {
                this.emitDiagnosticStartDumpBinarioRichiestaUscita();
                this.dumpBinarioRichiestaUscita(null, null, null, this.location, propertiesTrasportoDebug);
            }
            this.httpRequest.setConfig(requestConfigBuilder.build());
            if (this.debug) {
                this.logger.debug("Spedizione byte...");
            }
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)this.httpRequest);
            this.dataRichiestaInoltrata = DateManager.getDate();
            this.httpEntityResponse = httpResponse.getEntity();
            if (this.debug) {
                this.logger.debug("Analisi risposta...");
            }
            Header[] hdrRisposta = httpResponse.getAllHeaders();
            HashMap mapHeaderHttpResponse = new HashMap();
            if (hdrRisposta != null) {
                for (int i = 0; i < hdrRisposta.length; ++i) {
                    String key = null;
                    String value = null;
                    if (hdrRisposta[i].getName() == null) {
                        if (this.debug) {
                            this.logger.debug("HTTP risposta [ReturnCode] [" + hdrRisposta[i].getValue() + "]...");
                        }
                        key = "ReturnCode";
                        value = hdrRisposta[i].getValue();
                    } else {
                        if (this.debug) {
                            this.logger.debug("HTTP risposta [" + hdrRisposta[i].getName() + "] [" + hdrRisposta[i].getValue() + "]...");
                        }
                        key = hdrRisposta[i].getName();
                        value = hdrRisposta[i].getValue();
                    }
                    TransportUtils.addHeader((Map)this.propertiesTrasportoRisposta, (String)key, (String)value);
                    ArrayList<String> list = null;
                    if (mapHeaderHttpResponse.containsKey(key)) {
                        list = (ArrayList<String>)mapHeaderHttpResponse.get(key);
                    }
                    if (list == null) {
                        list = new ArrayList<String>();
                        mapHeaderHttpResponse.put(key, list);
                    }
                    list.add(value);
                }
            }
            this.tipoRisposta = TransportUtils.getObjectAsString(mapHeaderHttpResponse, (String)"Content-Type");
            String contentLengthHdr = TransportUtils.getObjectAsString(mapHeaderHttpResponse, (String)"Content-Length");
            if (contentLengthHdr != null) {
                this.contentLength = Long.parseLong(contentLengthHdr);
            } else if (this.httpEntityResponse.getContentLength() > 0L) {
                this.contentLength = this.httpEntityResponse.getContentLength();
            }
            if (this.isSoap) {
                if ("true".equals(TransportUtils.getObjectAsString(mapHeaderHttpResponse, (String)this.openspcoopProperties.getTunnelSOAPKeyWord_headerTrasporto()))) {
                    this.imbustamentoConAttachment = true;
                }
                this.mimeTypeAttachment = TransportUtils.getObjectAsString(mapHeaderHttpResponse, (String)this.openspcoopProperties.getTunnelSOAPKeyWordMimeType_headerTrasporto());
                if (this.mimeTypeAttachment == null) {
                    this.mimeTypeAttachment = "application/openspcoop2";
                }
            }
            if (this.debug) {
                this.logger.debug("Analisi risposta input stream e risultato http...");
            }
            this.initConfigurationAcceptOnlyReturnCode_202_200();
            this.codice = httpResponse.getStatusLine().getStatusCode();
            this.resultHTTPMessage = httpResponse.getStatusLine().getReasonPhrase();
            if (this.codice < 300) {
                if (this.isSoap && this.acceptOnlyReturnCode_202_200 && this.codice != 200 && this.codice != 202) {
                    throw new Exception("Return code [" + this.codice + "] non consentito dal WS-I Basic Profile (http://www.ws-i.org/Profiles/BasicProfile-1.1-2004-08-24.html#HTTP_Success_Status_Codes)");
                }
                if (httpBody.isDoInput()) {
                    this.isResponse = this.httpEntityResponse.getContent();
                }
            } else {
                this.isResponse = this.httpEntityResponse.getContent();
            }
            this.postOutRequest();
            this.preInResponse();
            this.notifierInputStreamParams = null;
            if (this.preInResponseContext != null) {
                this.notifierInputStreamParams = this.preInResponseContext.getNotifierInputStreamParams();
            }
            this.normalizeInputStreamResponse(readConnectionTimeout, readConnectionTimeoutConfigurazioneGlobale);
            this.initCheckContentTypeConfiguration();
            if (this.isDumpBinarioRisposta() && !this.dumpResponse(this.propertiesTrasportoRisposta)) {
                return false;
            }
            if (this.isRest ? !this.doRestResponse() : !this.doSoapResponse()) {
                return false;
            }
            if (!this.debug) return true;
            this.logger.info("Gestione invio/risposta http effettuata con successo", false);
            return true;
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            String msgErrore = this.readExceptionMessageFromException(e);
            this.errore = this.generateErrorWithConnectorPrefix ? "Errore avvenuto durante la consegna HTTP: " + msgErrore : msgErrore;
            this.logger.error("Errore avvenuto durante la consegna HTTP: " + msgErrore, e);
            this.processConnectionTimeoutException(connectionTimeout, connectionTimeoutConfigurazioneGlobale, e, msgErrore);
            this.processReadTimeoutException(readConnectionTimeout, readConnectionTimeoutConfigurazioneGlobale, e, msgErrore);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void disconnect() throws ConnettoreException {
        ArrayList<Throwable> listExceptionChiusura = new ArrayList<Throwable>();
        try {
            if (this.isResponse != null) {
                if (this.debug && this.logger != null) {
                    this.logger.debug("Chiusura socket...");
                }
                this.isResponse.close();
            }
        }
        catch (Throwable t) {
            if (this.logger != null) {
                this.logger.debug("Chiusura socket fallita: " + t.getMessage(), t);
            }
            listExceptionChiusura.add(t);
        }
        try {
            if (this.httpEntityResponse != null) {
                if (this.debug && this.logger != null) {
                    this.logger.debug("Chiusura httpEntityResponse...");
                }
                EntityUtils.consume((HttpEntity)this.httpEntityResponse);
            }
            if (this.httpEntityResponse == null) {
                // empty if block
            }
        }
        catch (Throwable t) {
            if (this.logger != null) {
                this.logger.debug("Chiusura connessione fallita: " + t.getMessage(), t);
            }
            listExceptionChiusura.add(t);
        }
        try {
            super.disconnect();
        }
        catch (Throwable t) {
            if (this.logger != null) {
                this.logger.debug("Chiusura risorse fallita: " + t.getMessage(), t);
            }
            listExceptionChiusura.add(t);
        }
        if (listExceptionChiusura != null && !listExceptionChiusura.isEmpty()) {
            UtilsMultiException multiException = new UtilsMultiException(listExceptionChiusura.toArray(new Throwable[1]));
            throw new ConnettoreException("Chiusura connessione non riuscita: " + multiException.getMessage(), multiException);
        }
    }

    @Override
    public String getLocation() {
        if (this.location == null) {
            try {
                this.buildLocation();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.location != null) {
            String l = new String(this.location);
            return l;
        }
        return null;
    }

    private void buildLocation() throws ConnettoreException {
        NameValue dpopNv;
        this.location = TransportUtils.getObjectAsString((Map)this.properties, (String)"location");
        String nameTokenQueryParameter = this.getNameTokenQueryParameter();
        if (nameTokenQueryParameter != null && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)nameTokenQueryParameter) && this.requestMsg != null && this.requestMsg.getTransportRequestContext() != null) {
            this.requestMsg.getTransportRequestContext().removeParameter(nameTokenQueryParameter);
        }
        this.location = ConnettoreUtils.buildLocationWithURLBasedParameter(this.logger != null ? this.logger.getLogger() : null, this.requestMsg, ENDPOINT_TYPE, this.propertiesUrlBased, this.location, this.getProtocolFactory(), this.idModulo);
        this.updateLocation_forwardProxy(this.location);
        this.ensureTokenNegotiated(this.httpMethod);
        HashMap newPropertiesUrlBased = null;
        NameValue nv = this.getTokenQueryParameter();
        if (nv != null) {
            newPropertiesUrlBased = new HashMap();
            TransportUtils.setParameter(newPropertiesUrlBased, (String)nv.getName(), (String)nv.getValue());
        }
        if ((dpopNv = this.getDpopBackendQueryParameter()) != null) {
            if (newPropertiesUrlBased == null) {
                newPropertiesUrlBased = new HashMap();
            }
            TransportUtils.setParameter(newPropertiesUrlBased, (String)dpopNv.getName(), (String)dpopNv.getValue());
        }
        this.location = TransportUtils.buildUrlWithParameters(newPropertiesUrlBased, (String)this.location, this.logger != null ? this.logger.getLogger() : null);
    }

    private void setRequestHeader(boolean validazioneHeaderRFC2047, String key, List<String> values, ConnettoreLogger logger, Map<String, List<String>> propertiesTrasportoDebug) throws Exception {
        if (validazioneHeaderRFC2047) {
            try {
                RFC2047Utilities.validHeader((String)key, values);
                this.setRequestHeader(key, values, propertiesTrasportoDebug);
            }
            catch (UtilsException e) {
                logger.error(e.getMessage(), e);
            }
        } else {
            this.setRequestHeader(key, values, propertiesTrasportoDebug);
        }
    }

    @Override
    protected void setRequestHeader(String key, List<String> values) throws Exception {
        if (values != null && !values.isEmpty()) {
            for (String value : values) {
                this.httpRequest.addHeader(key, value);
            }
        }
    }
}

