/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.soap.SOAPBody;
import org.apache.commons.io.output.NullOutputStream;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.soap.TunnelSoapUtils;
import org.openspcoop2.pdd.core.Utilities;
import org.openspcoop2.pdd.core.connettori.ConnettoreBase;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreLogger;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.transport.TransportUtils;

public class ConnettoreNULL
extends ConnettoreBase {
    public static final String LOCATION = "govway://dev/null";

    @Override
    public String getProtocollo() {
        return "";
    }

    @Override
    protected boolean initializePreSend(ResponseCachingConfigurazione responseCachingConfig, ConnettoreMsg request) {
        return this.initialize(request, false, responseCachingConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean send(ConnettoreMsg request) {
        block46: {
            this.codice = 200;
            try {
                MessageType requestMessageType = this.requestMsg.getMessageType();
                OpenSPCoop2SoapMessage soapMessageRequest = null;
                if (this.debug) {
                    this.logger.debug("Tipologia Servizio: " + this.requestMsg.getServiceBinding());
                }
                if (this.isSoap) {
                    soapMessageRequest = this.requestMsg.castAsSoap();
                }
                HashMap<String, List<String>> propertiesTrasportoDebug = null;
                if (this.isDumpBinarioRichiesta()) {
                    propertiesTrasportoDebug = new HashMap<String, List<String>>();
                }
                String contentTypeRichiesta = null;
                if (this.debug) {
                    this.logger.debug("Impostazione content type...");
                }
                if (this.isSoap) {
                    contentTypeRichiesta = this.sbustamentoSoap && soapMessageRequest.countAttachments() > 0 && TunnelSoapUtils.isTunnelOpenSPCoopSoap((OpenSPCoop2SoapMessage)soapMessageRequest) ? TunnelSoapUtils.getContentTypeTunnelOpenSPCoopSoap((SOAPBody)soapMessageRequest.getSOAPBody()) : this.requestMsg.getContentType();
                    if (contentTypeRichiesta == null) {
                        throw new Exception("Content-Type del messaggio da spedire non definito");
                    }
                } else {
                    contentTypeRichiesta = this.requestMsg.getContentType();
                }
                if (this.debug) {
                    this.logger.info("Impostazione Content-Type [" + contentTypeRichiesta + "]", false);
                }
                if (contentTypeRichiesta != null) {
                    this.setRequestHeader("Content-Type", contentTypeRichiesta, this.logger, propertiesTrasportoDebug);
                }
                if (this.debug) {
                    this.logger.debug("Impostazione header di trasporto...");
                }
                this.forwardHttpRequestHeader();
                if (this.propertiesTrasporto != null) {
                    for (String key : this.propertiesTrasporto.keySet()) {
                        List values = (List)this.propertiesTrasporto.get(key);
                        if (this.debug && values != null && !values.isEmpty()) {
                            for (String value : values) {
                                this.logger.info("Set Transport Header [" + key + "]=[" + value + "]", false);
                            }
                        }
                        this.setRequestHeader(key, values, this.logger, propertiesTrasportoDebug);
                    }
                }
                if (this.isSoap && !this.sbustamentoSoap) {
                    if (this.debug) {
                        this.logger.debug("Impostazione soap action...");
                    }
                    boolean existsTransportProperties = false;
                    if (TransportUtils.containsKey((Map)this.propertiesTrasporto, (String)"SOAPAction")) {
                        this.soapAction = TransportUtils.getFirstValue((Map)this.propertiesTrasporto, (String)"SOAPAction");
                        boolean bl = existsTransportProperties = this.soapAction != null;
                    }
                    if (!existsTransportProperties) {
                        this.soapAction = soapMessageRequest.getSoapAction();
                    }
                    if (this.soapAction == null) {
                        this.soapAction = "\"OpenSPCoop\"";
                    }
                    if (MessageType.SOAP_11.equals((Object)this.requestMsg.getMessageType()) && !existsTransportProperties) {
                        this.setRequestHeader("SOAPAction", this.soapAction, propertiesTrasportoDebug);
                    }
                    if (this.debug) {
                        this.logger.info("SOAP Action inviata [" + this.soapAction + "]", false);
                    }
                }
                boolean consumeRequestMessage = true;
                if (this.debug) {
                    this.logger.debug("Serializzazione (consume-request-message:" + consumeRequestMessage + ")...");
                }
                if (this.isDumpBinarioRichiesta()) {
                    DumpByteArrayOutputStream bout = null;
                    boolean close = true;
                    try {
                        bout = new DumpByteArrayOutputStream(this.dumpBinario_soglia, this.dumpBinario_repositoryFile, this.idTransazione, TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO.getValue());
                        this.emitDiagnosticStartDumpBinarioRichiestaUscita();
                        if (this.isSoap && this.sbustamentoSoap) {
                            this.logger.debug("Sbustamento...");
                            TunnelSoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)soapMessageRequest, (OutputStream)bout);
                        } else {
                            this.requestMsg.writeTo((OutputStream)bout, consumeRequestMessage);
                        }
                        bout.flush();
                        bout.close();
                        close = false;
                        this.dataRichiestaInoltrata = DateManager.getDate();
                        this.dumpBinarioRichiestaUscita(bout, requestMessageType, contentTypeRichiesta, this.location, propertiesTrasportoDebug);
                        break block46;
                    }
                    finally {
                        try {
                            if (close && bout != null) {
                                bout.close();
                            }
                        }
                        catch (Throwable throwable) {}
                        try {
                            if (bout != null) {
                                bout.clearResources();
                            }
                        }
                        catch (Throwable t) {
                            this.logger.error("Release resources failed: " + t.getMessage(), t);
                        }
                    }
                }
                NullOutputStream nullOutputStream = NullOutputStream.INSTANCE;
                if (this.isSoap && this.sbustamentoSoap) {
                    this.logger.debug("Sbustamento...");
                    TunnelSoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)soapMessageRequest, (OutputStream)nullOutputStream);
                } else {
                    this.requestMsg.writeTo((OutputStream)nullOutputStream, consumeRequestMessage);
                }
                nullOutputStream.flush();
                nullOutputStream.close();
                this.dataRichiestaInoltrata = DateManager.getDate();
            }
            catch (Exception e) {
                this.eccezioneProcessamento = e;
                this.logger.error("Riscontrato errore durante la writeTo", e);
                this.errore = "Riscontrato errore durante la writeTo: " + this.readExceptionMessageFromException(e);
                return false;
            }
        }
        try {
            this.postOutRequest();
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.logger.error("Riscontrato errore durante la gestione PostOutRequestHandler", e);
            this.errore = "Riscontrato errore durante la gestione PostOutRequestHandler: " + this.readExceptionMessageFromException(e);
            return false;
        }
        try {
            OpenSPCoop2MessageFactory messageFactory = Utilities.getOpenspcoop2MessageFactory(this.logger.getLogger(), this.requestMsg, this.requestInfo, MessageRole.RESPONSE);
            this.responseMsg = messageFactory.createEmptyMessage(this.requestMsg.getMessageType(), MessageRole.RESPONSE);
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.logger.error("Riscontrato errore durante la generazione di un msg SoapVuoto", e);
            this.errore = "Riscontrato errore durante la generazione di un msg SoapVuoto: " + this.readExceptionMessageFromException(e);
            return false;
        }
        return true;
    }

    private void setRequestHeader(String key, String value, ConnettoreLogger logger, Map<String, List<String>> propertiesTrasportoDebug) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add(value);
        this.setRequestHeader(key, list, logger, propertiesTrasportoDebug);
    }

    private void setRequestHeader(String key, List<String> values, ConnettoreLogger logger, Map<String, List<String>> propertiesTrasportoDebug) throws Exception {
        if (this.debug && values != null && !values.isEmpty()) {
            for (String value : values) {
                this.logger.info("Set propriet\u00e0 trasporto [" + key + "]=[" + value + "]", false);
            }
        }
        this.setRequestHeader(key, values, propertiesTrasportoDebug);
    }

    @Override
    protected void setRequestHeader(String key, List<String> values) throws Exception {
    }

    @Override
    public String getLocation() throws ConnettoreException {
        return LOCATION;
    }
}

