/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.soap.SOAPBody;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.soap.TunnelSoapUtils;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.core.Utilities;
import org.openspcoop2.pdd.core.connettori.ConnettoreBaseWithResponse;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreLogger;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.protocol.engine.builder.Imbustamento;
import org.openspcoop2.protocol.engine.builder.Sbustamento;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.engine.validator.Validatore;
import org.openspcoop2.protocol.engine.validator.ValidazioneSintattica;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.BustaRawContent;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.ProtocolMessage;
import org.openspcoop2.protocol.sdk.Riscontro;
import org.openspcoop2.protocol.sdk.Trasmissione;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.constants.FaseImbustamento;
import org.openspcoop2.protocol.sdk.constants.FaseSbustamento;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.constants.TipoOraRegistrazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StatefulMessage;
import org.openspcoop2.protocol.sdk.validator.IValidatoreErrori;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazione;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazioneErrori;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.transport.TransportUtils;
import org.w3c.dom.Node;

public class ConnettoreNULLEcho
extends ConnettoreBaseWithResponse {
    public static final String LOCATION = "govway://echo";
    private DumpByteArrayOutputStream requestBout = null;

    @Override
    public String getProtocollo() {
        return "";
    }

    @Override
    protected boolean initializePreSend(ResponseCachingConfigurazione responseCachingConfig, ConnettoreMsg request) {
        return this.initialize(request, false, responseCachingConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean send(ConnettoreMsg request) {
        boolean generaTrasmissione = false;
        if (this.properties.get("generaTrasmissione") != null && "true".equalsIgnoreCase(((String)this.properties.get("generaTrasmissione")).trim())) {
            generaTrasmissione = true;
        }
        boolean generaTrasmissioneInvertita = false;
        if (this.properties.get("generaTrasmissioneInvertita") != null && "true".equalsIgnoreCase(((String)this.properties.get("generaTrasmissioneInvertita")).trim())) {
            generaTrasmissioneInvertita = true;
        }
        boolean generaTrasmissioneAndataRitorno = false;
        if (this.properties.get("generaTrasmissioneAndataRitorno") != null && "true".equalsIgnoreCase(((String)this.properties.get("generaTrasmissioneAndataRitorno")).trim())) {
            generaTrasmissioneAndataRitorno = true;
        }
        this.codice = 200;
        DBManager dbManager = DBManager.getInstance();
        Resource resource = null;
        StatefulMessage state = new StatefulMessage(null, this.logger.getLogger());
        ValidazioneSintattica validatoreSintattico = null;
        Validatore validatoreProtocollo = null;
        BustaRawContent headerProtocolloRisposta = null;
        String protocol = null;
        try {
            OpenSPCoop2MessageFactory messageFactory;
            OpenSPCoop2MessageParseResult pr;
            IProtocolFactory<?> protocolFactory = this.getProtocolFactory();
            IProtocolManager protocolManager = protocolFactory.createProtocolManager();
            protocol = protocolFactory.getProtocol();
            MessageType requestMessageType = this.requestMsg.getMessageType();
            OpenSPCoop2SoapMessage soapMessageRequest = null;
            if (this.debug) {
                this.logger.debug("Tipologia Servizio: " + this.requestMsg.getServiceBinding());
            }
            if (this.isSoap) {
                soapMessageRequest = this.requestMsg.castAsSoap();
            }
            HashMap<String, List<String>> propertiesTrasportoDebug = null;
            if (this.isDumpBinarioRichiesta()) {
                propertiesTrasportoDebug = new HashMap<String, List<String>>();
            }
            String contentTypeRichiesta = null;
            if (this.debug) {
                this.logger.debug("Impostazione content type...");
            }
            if (this.isSoap) {
                contentTypeRichiesta = this.sbustamentoSoap && soapMessageRequest.countAttachments() > 0 && TunnelSoapUtils.isTunnelOpenSPCoopSoap((OpenSPCoop2SoapMessage)soapMessageRequest) ? TunnelSoapUtils.getContentTypeTunnelOpenSPCoopSoap((SOAPBody)soapMessageRequest.getSOAPBody()) : this.requestMsg.getContentType();
                if (contentTypeRichiesta == null) {
                    throw new Exception("Content-Type del messaggio da spedire non definito");
                }
            } else {
                contentTypeRichiesta = this.requestMsg.getContentType();
            }
            if (this.debug) {
                this.logger.info("Impostazione Content-Type [" + contentTypeRichiesta + "]", false);
            }
            if (contentTypeRichiesta != null) {
                this.setRequestHeader("Content-Type", contentTypeRichiesta, this.logger, propertiesTrasportoDebug);
            }
            if (this.debug) {
                this.logger.debug("Impostazione timeout...");
            }
            int readConnectionTimeout = -1;
            boolean readConnectionTimeoutConfigurazioneGlobale = true;
            if (this.properties.get("readConnectionTimeout") != null) {
                try {
                    readConnectionTimeout = Integer.parseInt((String)this.properties.get("readConnectionTimeout"));
                    readConnectionTimeoutConfigurazioneGlobale = this.properties.containsKey("readConnectionTimeoutGlobale");
                }
                catch (Exception e) {
                    this.logger.error("Parametro readConnectionTimeout errato", e);
                }
            }
            if (readConnectionTimeout == -1) {
                readConnectionTimeout = 120000;
            }
            if (this.debug) {
                this.logger.info("Impostazione read timeout [" + readConnectionTimeout + "]", false);
            }
            if (this.debug) {
                this.logger.debug("Impostazione header di trasporto...");
            }
            this.forwardHttpRequestHeader();
            if (this.propertiesTrasporto != null) {
                for (String key : this.propertiesTrasporto.keySet()) {
                    List values = (List)this.propertiesTrasporto.get(key);
                    if (this.debug && values != null && !values.isEmpty()) {
                        for (String value : values) {
                            this.logger.info("Set Transport Header [" + key + "]=[" + value + "]", false);
                        }
                    }
                    this.setRequestHeader(key, values, this.logger, propertiesTrasportoDebug);
                }
            }
            if (this.isSoap && !this.sbustamentoSoap) {
                if (this.debug) {
                    this.logger.debug("Impostazione soap action...");
                }
                boolean existsTransportProperties = false;
                if (TransportUtils.containsKey((Map)this.propertiesTrasporto, (String)"SOAPAction")) {
                    this.soapAction = TransportUtils.getFirstValue((Map)this.propertiesTrasporto, (String)"SOAPAction");
                    boolean bl = existsTransportProperties = this.soapAction != null;
                }
                if (!existsTransportProperties) {
                    this.soapAction = soapMessageRequest.getSoapAction();
                }
                if (this.soapAction == null) {
                    this.soapAction = "\"OpenSPCoop\"";
                }
                if (MessageType.SOAP_11.equals((Object)this.requestMsg.getMessageType()) && !existsTransportProperties) {
                    this.setRequestHeader("SOAPAction", this.soapAction, propertiesTrasportoDebug);
                }
                if (this.debug) {
                    this.logger.info("SOAP Action inviata [" + this.soapAction + "]", false);
                }
            }
            boolean consumeRequestMessage = true;
            if (this.debug) {
                this.logger.debug("Serializzazione (consume-request-message:" + consumeRequestMessage + ")...");
            }
            if (this.isDumpBinarioRichiesta()) {
                this.requestBout = new DumpByteArrayOutputStream(this.dumpBinario_soglia, this.dumpBinario_repositoryFile, this.idTransazione, "NullEcho-" + TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO.getValue());
                this.emitDiagnosticStartDumpBinarioRichiestaUscita();
                if (this.isSoap && this.sbustamentoSoap) {
                    this.logger.debug("Sbustamento...");
                    TunnelSoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)soapMessageRequest, (OutputStream)this.requestBout);
                } else {
                    this.requestMsg.writeTo((OutputStream)this.requestBout, consumeRequestMessage);
                }
                this.requestBout.flush();
                this.requestBout.close();
                this.dataRichiestaInoltrata = DateManager.getDate();
                this.dumpBinarioRichiestaUscita(this.requestBout, requestMessageType, contentTypeRichiesta, this.location, propertiesTrasportoDebug);
            } else {
                this.requestBout = new DumpByteArrayOutputStream(this.dumpBinario_soglia, this.dumpBinario_repositoryFile, this.idTransazione, "NullEcho-" + TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO.getValue());
                if (this.isSoap && this.sbustamentoSoap) {
                    this.logger.debug("Sbustamento...");
                    TunnelSoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)soapMessageRequest, (OutputStream)this.requestBout);
                } else {
                    this.requestMsg.writeTo((OutputStream)this.requestBout, consumeRequestMessage);
                }
                this.requestBout.flush();
                this.requestBout.close();
                this.dataRichiestaInoltrata = DateManager.getDate();
            }
            this.postOutRequest();
            this.preInResponse();
            NotifierInputStreamParams notifierInputStreamParams = null;
            if (this.preInResponseContext != null) {
                notifierInputStreamParams = this.preInResponseContext.getNotifierInputStreamParams();
            }
            this.isResponse = this.requestBout.isSerializedOnFileSystem() ? new FileInputStream(this.requestBout.getSerializedFile()) : new ByteArrayInputStream(this.requestBout.toByteArray());
            this.normalizeInputStreamResponse(readConnectionTimeout, readConnectionTimeoutConfigurazioneGlobale);
            this.initCheckContentTypeConfiguration();
            this.messageTypeResponse = this.requestMsg.getMessageType();
            this.tipoRisposta = this.requestMsg.getContentType();
            if (this.isDumpBinarioRisposta()) {
                this.dumpResponse(this.propertiesTrasportoRisposta);
            }
            if (this.isResponse != null) {
                this.emitDiagnosticResponseRead(this.isResponse);
            }
            if ((pr = (messageFactory = Utilities.getOpenspcoop2MessageFactory(this.logger.getLogger(), this.requestMsg, this.requestInfo, MessageRole.RESPONSE)).createMessage(this.messageTypeResponse, MessageRole.RESPONSE, this.requestMsg.getContentType(), this.isResponse, notifierInputStreamParams, this.openspcoopProperties.getAttachmentsProcessingMode())).getParseException() != null) {
                this.getPddContext().addObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, pr.getParseException());
            }
            this.responseMsg = pr.getMessage_throwParseException();
            validatoreSintattico = new ValidazioneSintattica((Context)this.getPddContext(), (IState)state, this.responseMsg, this.openspcoopProperties.isReadQualifiedAttribute("standard"), protocolFactory);
            if (validatoreSintattico.verifyProtocolPresence(TipoPdD.APPLICATIVA, null, RuoloMessaggio.RISPOSTA) && !"sdi".equals(protocolFactory.getProtocol())) {
                OpenSPCoop2SoapMessage soapMessage;
                ProprietaValidazione property = new ProprietaValidazione();
                property.setValidazioneConSchema(false);
                property.setValidazioneProfiloCollaborazione(false);
                property.setValidazioneManifestAttachments(false);
                validatoreProtocollo = new Validatore(this.responseMsg, (Context)this.getPddContext(), property, null, this.openspcoopProperties.isReadQualifiedAttribute("standard"), protocolFactory);
                if (!validatoreProtocollo.validazioneSintattica()) {
                    throw new Exception("Busta non presente: " + validatoreProtocollo.getErrore().getDescrizione(protocolFactory));
                }
                Busta busta = validatoreProtocollo.getBusta();
                IValidatoreErrori validatoreErrori = protocolFactory.createValidatoreErrori((IState)state);
                ProprietaValidazioneErrori pValidazioneErrori = new ProprietaValidazioneErrori();
                pValidazioneErrori.setIgnoraEccezioniNonGravi(protocolManager.isIgnoraEccezioniNonGravi());
                boolean isBustaSPCoopErrore = validatoreErrori.isBustaErrore(busta, this.responseMsg, pValidazioneErrori);
                boolean gestioneManifest = false;
                Sbustamento sbustatore = new Sbustamento(protocolFactory, (IState)state);
                ProtocolMessage protocolMessage = sbustatore.sbustamento(this.responseMsg, (Context)this.getPddContext(), busta, RuoloMessaggio.RICHIESTA, gestioneManifest, this.openspcoopProperties.getProprietaManifestAttachments("standard"), FaseSbustamento.PRE_CONSEGNA_RICHIESTA, this.requestInfo);
                if (protocolMessage != null) {
                    headerProtocolloRisposta = protocolMessage.getBustaRawContent();
                    this.responseMsg = protocolMessage.getMessage();
                }
                if (!isBustaSPCoopErrore) {
                    Trasmissione t;
                    TipoOraRegistrazione tipoOraRegistrazione = this.openspcoopProperties.getTipoTempoBusta("standard");
                    Busta bustaRisposta = busta.invertiBusta(tipoOraRegistrazione, protocolFactory.createTraduttore().toString(tipoOraRegistrazione));
                    bustaRisposta.setProfiloDiCollaborazione(busta.getProfiloDiCollaborazione());
                    bustaRisposta.setServizio(busta.getServizio());
                    bustaRisposta.setVersioneServizio(busta.getVersioneServizio());
                    bustaRisposta.setTipoServizio(busta.getTipoServizio());
                    bustaRisposta.setAzione(busta.getAzione());
                    bustaRisposta.setInoltro(busta.getInoltro(), busta.getInoltroValue());
                    bustaRisposta.setConfermaRicezione(busta.isConfermaRicezione());
                    if (ProfiloDiCollaborazione.ONEWAY.equals((Object)busta.getProfiloDiCollaborazione()) && busta.isConfermaRicezione() && this.openspcoopProperties.isGestioneRiscontri("standard")) {
                        Riscontro r = new Riscontro();
                        r.setID(busta.getID());
                        r.setOraRegistrazione(DateManager.getDate());
                        r.setTipoOraRegistrazione(TipoOraRegistrazione.SINCRONIZZATO);
                        bustaRisposta.addRiscontro(r);
                    } else if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)busta.getProfiloDiCollaborazione()) && busta.getRiferimentoMessaggio() == null) {
                        bustaRisposta.setTipoServizioCorrelato("SPC");
                        bustaRisposta.setServizioCorrelato(busta.getServizio() + "Correlato");
                    } else if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)busta.getProfiloDiCollaborazione()) && busta.getRiferimentoMessaggio() == null) {
                        try {
                            resource = dbManager.getResource(this.openspcoopProperties.getIdentitaPortaDefault(protocolFactory.getProtocol(), this.requestInfo), "ConnettoreNullEcho", busta.getID());
                        }
                        catch (Exception e) {
                            throw new Exception("Risorsa non ottenibile", e);
                        }
                        if (resource == null) {
                            throw new Exception("Risorsa is null");
                        }
                        if (resource.getResource() == null) {
                            throw new Exception("Connessione is null");
                        }
                        Connection connectionDB = (Connection)resource.getResource();
                        state.setConnectionDB(connectionDB);
                        RepositoryBuste repositoryBuste = new RepositoryBuste((IState)state, true, protocolFactory);
                        repositoryBuste.registraBustaIntoInBox(busta, new ArrayList(), OpenSPCoop2Properties.getInstance().getRepositoryIntervalloScadenzaMessaggi());
                        Integrazione infoIntegrazione = new Integrazione();
                        infoIntegrazione.setIdModuloInAttesa(null);
                        repositoryBuste.aggiornaInfoIntegrazioneIntoInBox(busta.getID(), infoIntegrazione);
                        org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione((IState)state, protocolFactory);
                        profiloCollaborazione.asincronoSimmetrico_registraRichiestaRicevuta(busta.getID(), busta.getCollaborazione(), busta.getTipoServizioCorrelato(), busta.getServizioCorrelato(), busta.getVersioneServizioCorrelato(), true, this.openspcoopProperties.getRepositoryIntervalloScadenzaMessaggi());
                        try {
                            connectionDB.setAutoCommit(false);
                            state.executePreparedStatement();
                            connectionDB.commit();
                            connectionDB.setAutoCommit(true);
                        }
                        catch (Exception e) {
                            this.logger.error("Riscontrato errore durante la gestione transazione del DB per la richiesta: " + e.getMessage());
                            try {
                                connectionDB.rollback();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            state.closePreparedStatement();
                        }
                        finally {
                            try {
                                connectionDB.setAutoCommit(true);
                            }
                            catch (Exception e) {}
                        }
                    }
                    bustaRisposta.setRiferimentoMessaggio(busta.getID());
                    String dominio = null;
                    if (request.getConnectorProperties() != null) {
                        dominio = request.getConnectorProperties().get("identificativo-porta");
                    }
                    if (dominio == null) {
                        dominio = protocolFactory.createTraduttore().getIdentificativoPortaDefault(new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario()));
                    }
                    String idBustaRisposta = null;
                    Imbustamento imbustatore = new Imbustamento(this.logger.getLogger(), protocolFactory, (IState)state);
                    idBustaRisposta = imbustatore.buildID(new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario(), dominio), null, this.openspcoopProperties.getGestioneSerializableDBAttesaAttiva(), this.openspcoopProperties.getGestioneSerializableDBCheckInterval(), RuoloMessaggio.RISPOSTA);
                    bustaRisposta.setID(idBustaRisposta);
                    if (generaTrasmissioneAndataRitorno) {
                        t = new Trasmissione();
                        t.setTipoOrigine(busta.getTipoMittente());
                        t.setOrigine(busta.getMittente());
                        t.setIdentificativoPortaOrigine(busta.getIdentificativoPortaMittente());
                        t.setIndirizzoOrigine(busta.getIndirizzoMittente());
                        t.setTipoDestinazione(busta.getTipoDestinatario());
                        t.setDestinazione(busta.getDestinatario());
                        t.setIdentificativoPortaDestinazione(busta.getIdentificativoPortaDestinatario());
                        t.setIndirizzoDestinazione(busta.getIndirizzoDestinatario());
                        t.setOraRegistrazione(busta.getOraRegistrazione());
                        t.setTempo(busta.getTipoOraRegistrazione(), busta.getTipoOraRegistrazioneValue());
                        bustaRisposta.addTrasmissione(t);
                    }
                    if (generaTrasmissione || generaTrasmissioneInvertita || generaTrasmissioneAndataRitorno) {
                        t = new Trasmissione();
                        if (generaTrasmissione || generaTrasmissioneAndataRitorno) {
                            t.setTipoOrigine(bustaRisposta.getTipoMittente());
                            t.setOrigine(bustaRisposta.getMittente());
                            t.setIdentificativoPortaOrigine(bustaRisposta.getIdentificativoPortaMittente());
                            t.setIndirizzoOrigine(bustaRisposta.getIndirizzoMittente());
                            t.setTipoDestinazione(bustaRisposta.getTipoDestinatario());
                            t.setDestinazione(bustaRisposta.getDestinatario());
                            t.setIdentificativoPortaDestinazione(bustaRisposta.getIdentificativoPortaDestinatario());
                            t.setIndirizzoDestinazione(bustaRisposta.getIndirizzoDestinatario());
                        }
                        if (generaTrasmissioneInvertita) {
                            t.setTipoOrigine(bustaRisposta.getTipoDestinatario());
                            t.setOrigine(bustaRisposta.getDestinatario());
                            t.setIdentificativoPortaOrigine(bustaRisposta.getIdentificativoPortaDestinatario());
                            t.setIndirizzoOrigine(bustaRisposta.getIndirizzoDestinatario());
                            t.setTipoDestinazione(bustaRisposta.getTipoMittente());
                            t.setDestinazione(bustaRisposta.getMittente());
                            t.setIdentificativoPortaDestinazione(bustaRisposta.getIdentificativoPortaMittente());
                            t.setIndirizzoDestinazione(bustaRisposta.getIndirizzoMittente());
                        }
                        t.setOraRegistrazione(bustaRisposta.getOraRegistrazione());
                        t.setTempo(bustaRisposta.getTipoOraRegistrazione(), bustaRisposta.getTipoOraRegistrazioneValue());
                        bustaRisposta.addTrasmissione(t);
                    }
                    Integrazione integrazione = new Integrazione();
                    integrazione.setStateless(true);
                    ProtocolMessage protocolMessageRisposta = imbustatore.imbustamentoRisposta(this.responseMsg, (Context)this.getPddContext(), bustaRisposta, busta, integrazione, gestioneManifest, false, this.openspcoopProperties.getProprietaManifestAttachments("standard"), FaseImbustamento.PRIMA_SICUREZZA_MESSAGGIO);
                    if (protocolMessageRisposta != null && !protocolMessageRisposta.isPhaseUnsupported()) {
                        this.responseMsg = protocolMessageRisposta.getMessage();
                    }
                    if ((protocolMessageRisposta = imbustatore.imbustamentoRisposta(this.responseMsg, (Context)this.getPddContext(), bustaRisposta, busta, integrazione, gestioneManifest, false, this.openspcoopProperties.getProprietaManifestAttachments("standard"), FaseImbustamento.DOPO_SICUREZZA_MESSAGGIO)) != null && !protocolMessageRisposta.isPhaseUnsupported()) {
                        this.responseMsg = protocolMessageRisposta.getMessage();
                    }
                } else if (this.responseMsg instanceof OpenSPCoop2SoapMessage && (soapMessage = this.responseMsg.castAsSoap()).hasSOAPFault()) {
                    soapMessage.getSOAPBody().removeChild((Node)soapMessage.getSOAPBody().getFault());
                }
            }
            if (this.responseMsg != null) {
                this.contentLength = this.responseMsg.getIncomingMessageContentLength();
            }
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            String msgErrore = this.readExceptionMessageFromException(e);
            this.errore = this.generateErrorWithConnectorPrefix ? "Riscontrato errore durante l'echo del messaggio: " + msgErrore : msgErrore;
            this.logger.error("Riscontrato errore durante l'echo del messaggio: " + msgErrore, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (validatoreSintattico != null) {
                validatoreSintattico.setHeaderSOAP(null);
            }
            validatoreSintattico = null;
            if (validatoreProtocollo != null) {
                if (validatoreProtocollo.getValidatoreSintattico() != null) {
                    validatoreProtocollo.getValidatoreSintattico().setHeaderSOAP(null);
                }
                validatoreProtocollo.setValidatoreSintattico(null);
            }
            validatoreProtocollo = null;
            headerProtocolloRisposta = null;
            dbManager.releaseResource(this.openspcoopProperties.getIdentitaPortaDefault(protocol, this.requestInfo), "ConnettoreNullEcho", resource);
        }
        return true;
    }

    private void setRequestHeader(String key, String value, ConnettoreLogger logger, Map<String, List<String>> propertiesTrasportoDebug) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add(value);
        this.setRequestHeader(key, list, logger, propertiesTrasportoDebug);
    }

    private void setRequestHeader(String key, List<String> values, ConnettoreLogger logger, Map<String, List<String>> propertiesTrasportoDebug) throws Exception {
        if (this.debug && values != null && !values.isEmpty()) {
            for (String value : values) {
                this.logger.info("Set propriet\u00e0 trasporto [" + key + "]=[" + value + "]", false);
            }
        }
        this.setRequestHeader(key, values, propertiesTrasportoDebug);
    }

    @Override
    protected void setRequestHeader(String key, List<String> values) throws Exception {
        this.propertiesTrasportoRisposta.put(key, values);
    }

    @Override
    public String getLocation() throws ConnettoreException {
        return LOCATION;
    }

    @Override
    public void disconnect() throws ConnettoreException {
        try {
            if (this.requestBout != null) {
                this.requestBout.clearResources();
            }
        }
        catch (Throwable t) {
            this.logger.error("Release resources failed: " + t.getMessage(), t);
        }
    }
}

