/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.message.MessageUtils;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.core.Utilities;
import org.openspcoop2.pdd.core.connettori.ConnettoreBaseWithResponse;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreLogger;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.connettori.ConnettoreUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsMultiException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.transport.TransportResponseContext;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.RFC2047Encoding;
import org.openspcoop2.utils.transport.http.RFC2047Utilities;

public class ConnettoreSAAJ
extends ConnettoreBaseWithResponse {
    public static final String ENDPOINT_TYPE = "saaj";
    private SOAPConnection connection = null;
    private SOAPMessage soapRequestMessage = null;

    @Override
    public String getProtocollo() {
        return "HTTP";
    }

    @Override
    protected boolean initializePreSend(ResponseCachingConfigurazione responseCachingConfig, ConnettoreMsg request) {
        return this.initialize(request, true, responseCachingConfig);
    }

    @Override
    protected boolean send(ConnettoreMsg request) {
        if (this.properties.get("location") == null) {
            this.errore = "Proprieta' 'location' non fornita e richiesta da questo tipo di connettore [" + request.getTipoConnettore() + "]";
            return false;
        }
        return this.sendSAAJ();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean sendSAAJ() {
        connectionTimeout = -1;
        connectionTimeoutConfigurazioneGlobale = true;
        readConnectionTimeout = -1;
        readConnectionTimeoutConfigurazioneGlobale = true;
        try {
            if (this.debug) {
                this.logger.debug("Impostazione timeout...");
            }
            if (this.properties.get("connectionTimeout") != null) {
                try {
                    connectionTimeout = Integer.parseInt((String)this.properties.get("connectionTimeout"));
                    connectionTimeoutConfigurazioneGlobale = this.properties.containsKey("connectionTimeoutGlobale");
                }
                catch (Exception e) {
                    this.logger.error("Parametro 'connectionTimeout' errato", e);
                }
            }
            if (connectionTimeout == -1) {
                connectionTimeout = 10000;
            }
            if (this.properties.get("readConnectionTimeout") != null) {
                try {
                    readConnectionTimeout = Integer.parseInt((String)this.properties.get("readConnectionTimeout"));
                    readConnectionTimeoutConfigurazioneGlobale = this.properties.containsKey("readConnectionTimeoutGlobale");
                }
                catch (Exception e) {
                    this.logger.error("Parametro 'readConnectionTimeout' errato", e);
                }
            }
            if (readConnectionTimeout == -1) {
                readConnectionTimeout = 120000;
            }
            if (this.debug) {
                this.logger.info("Impostazione http timeout CT[" + connectionTimeout + "] RT[" + readConnectionTimeout + "]...", false);
            }
            if (!ServiceBinding.SOAP.equals((Object)this.requestMsg.getServiceBinding())) {
                throw new Exception("Connettore utilizzabile solamente in un contesto SOAP (trovato: " + this.requestMsg.getServiceBinding() + ")");
            }
            if (this.debug) {
                this.logger.debug("Check validita URL...");
            }
            this.location = (String)this.properties.get("location");
            this.location = ConnettoreUtils.buildLocationWithURLBasedParameter(this.logger != null ? this.logger.getLogger() : null, this.requestMsg, "saaj", this.propertiesUrlBased, this.location, this.getProtocolFactory(), this.idModulo);
            urlTest = new URL(this.location);
            connectionTest = urlTest.openConnection();
            httpConnTest = (HttpURLConnection)connectionTest;
            httpConnTest.setRequestMethod(HttpRequestMethod.POST.name());
            httpConnTest.setConnectTimeout(connectionTimeout);
            httpConnTest.setReadTimeout(readConnectionTimeout);
            httpConnTest.setDoOutput(true);
            outTest = httpConnTest.getOutputStream();
            outTest.close();
            httpConnTest.disconnect();
            requestMessageType = this.requestMsg.getMessageType();
            if (!ServiceBinding.SOAP.equals((Object)this.requestMsg.getServiceBinding())) {
                throw new Exception("Connettore utilizzabile solamente per tipologia di servizio SOAP");
            }
            soapRequestMessage = this.requestMsg.castAsSoap();
            this.soapRequestMessage = MessageUtils.getSOAPMessage((OpenSPCoop2SoapMessage)soapRequestMessage, (boolean)false, (String)this.idTransazione);
            propertiesTrasportoDebug = null;
            if (this.isDumpBinarioRichiesta()) {
                propertiesTrasportoDebug = new HashMap<String, List<String>>();
            }
            if (this.debug) {
                this.logger.debug("PrefixOptimization...");
            }
            prefixOptimization = "true";
            if (this.properties.get("prefix-optimization") != null) {
                if ("false".equalsIgnoreCase((String)this.properties.get("prefix-optimization"))) {
                    prefixOptimization = "false";
                }
                this.logger.info("Prefix Optimization = '" + prefixOptimization + "'", false);
            }
            if (this.debug) {
                this.logger.debug("Creazione connessione...");
            }
            messageFactory = Utilities.getOpenspcoop2MessageFactory(this.logger.getLogger(), this.requestMsg, this.requestInfo, MessageRole.NONE);
            soapConnFactory = messageFactory.getSOAPConnectionFactory();
            this.connection = soapConnFactory.createConnection();
            try {
                contentTypeRichiesta = null;
                if (this.debug) {
                    this.logger.debug("Impostazione content type...");
                }
                if (this.isSoap) {
                    contentTypeRichiesta = this.requestMsg.getContentType();
                    if (contentTypeRichiesta == null) {
                        throw new Exception("Content-Type del messaggio da spedire non definito");
                    }
                } else {
                    contentTypeRichiesta = this.requestMsg.getContentType();
                }
                if (this.debug) {
                    this.logger.info("Impostazione Content-Type [" + contentTypeRichiesta + "]", false);
                }
                if (contentTypeRichiesta != null) {
                    this.setRequestHeader("Content-Type", contentTypeRichiesta, propertiesTrasportoDebug);
                }
                if (this.debug) {
                    this.logger.debug("Impostazione autenticazione...");
                }
                user = null;
                password = null;
                if (this.credenziali != null) {
                    user = this.credenziali.getUser();
                    password = this.credenziali.getPassword();
                } else {
                    user = (String)this.properties.get("user");
                    password = (String)this.properties.get("password");
                }
                if (user != null && password != null) {
                    authentication = user + ":" + password;
                    authentication = "Basic " + Base64Utilities.encodeAsString((byte[])authentication.getBytes());
                    this.setRequestHeader("Authorization", authentication, propertiesTrasportoDebug);
                    if (this.debug) {
                        this.logger.info("Impostazione autenticazione (username:" + user + " password:" + password + ") [" + authentication + "]", false);
                    }
                }
                if (this.debug) {
                    this.logger.debug("Set timeout...");
                }
                if (this.debug) {
                    this.logger.debug("Impostazione header di trasporto...");
                }
                encodingRFC2047 = false;
                charsetRFC2047 = null;
                encodingAlgorithmRFC2047 = null;
                validazioneHeaderRFC2047 = false;
                if (this.idModulo != null) {
                    if ("ConsegnaContenutiApplicativi".equals(this.idModulo)) {
                        encodingRFC2047 = this.openspcoopProperties.isEnabledEncodingRFC2047HeaderValueConsegnaContenutiApplicativi();
                        charsetRFC2047 = this.openspcoopProperties.getCharsetEncodingRFC2047HeaderValueConsegnaContenutiApplicativi();
                        encodingAlgorithmRFC2047 = this.openspcoopProperties.getEncodingRFC2047HeaderValueConsegnaContenutiApplicativi();
                        validazioneHeaderRFC2047 = this.openspcoopProperties.isEnabledValidazioneRFC2047HeaderNameValueConsegnaContenutiApplicativi();
                    } else {
                        encodingRFC2047 = this.openspcoopProperties.isEnabledEncodingRFC2047HeaderValueInoltroBuste();
                        charsetRFC2047 = this.openspcoopProperties.getCharsetEncodingRFC2047HeaderValueInoltroBuste();
                        encodingAlgorithmRFC2047 = this.openspcoopProperties.getEncodingRFC2047HeaderValueInoltroBuste();
                        validazioneHeaderRFC2047 = this.openspcoopProperties.isEnabledValidazioneRFC2047HeaderNameValueInoltroBuste();
                    }
                    encodingRFC2047 = CostantiProprieta.isConnettoriHeaderValueEncodingRFC2047RequestEnabled(this.proprietaPorta, encodingRFC2047);
                    charsetRFC2047 = CostantiProprieta.getConnettoriHeaderValueEncodingRFC2047RequestCharset(this.proprietaPorta, charsetRFC2047);
                    encodingAlgorithmRFC2047 = CostantiProprieta.getConnettoriHeaderValueEncodingRFC2047RequestType(this.proprietaPorta, encodingAlgorithmRFC2047);
                    validazioneHeaderRFC2047 = CostantiProprieta.isConnettoriHeaderValidationRequestEnabled(this.proprietaPorta, validazioneHeaderRFC2047);
                }
                this.forwardHttpRequestHeader();
                if (this.propertiesTrasporto != null) {
                    for (String key : this.propertiesTrasporto.keySet()) {
                        if ("User-Agent".equalsIgnoreCase(key)) continue;
                        values = (List)this.propertiesTrasporto.get(key);
                        if (this.debug && values != null && !values.isEmpty()) {
                            for (String value : values) {
                                this.logger.info("Set Transport Header [" + key + "]=[" + value + "]", false);
                            }
                        }
                        if (encodingRFC2047) {
                            valuesEncoded = new ArrayList<String>();
                            if (values != null && !values.isEmpty()) {
                                for (String value : values) {
                                    if (!RFC2047Utilities.isAllCharactersInCharset((String)value, (Charset)charsetRFC2047)) {
                                        encoded = RFC2047Utilities.encode((String)new String(value), (Charset)charsetRFC2047, (RFC2047Encoding)encodingAlgorithmRFC2047);
                                        if (this.debug) {
                                            this.logger.info("RFC2047 Encoded value in [" + encoded + "] (charset:" + charsetRFC2047 + " encoding-algorithm:" + encodingAlgorithmRFC2047 + ")", false);
                                        }
                                        valuesEncoded.add(encoded);
                                        continue;
                                    }
                                    valuesEncoded.add(value);
                                }
                            }
                            this.setRequestHeader(validazioneHeaderRFC2047, key, valuesEncoded, this.logger, propertiesTrasportoDebug);
                            continue;
                        }
                        this.setRequestHeader(validazioneHeaderRFC2047, key, values, this.logger, propertiesTrasportoDebug);
                    }
                }
                if (this.isSoap && !this.sbustamentoSoap) {
                    if (this.debug) {
                        this.logger.debug("Impostazione soap action...");
                    }
                    existsTransportProperties = false;
                    if (TransportUtils.containsKey((Map)this.propertiesTrasporto, (String)"SOAPAction")) {
                        this.soapAction = TransportUtils.getFirstValue((Map)this.propertiesTrasporto, (String)"SOAPAction");
                        v0 = existsTransportProperties = this.soapAction != null;
                    }
                    if (!existsTransportProperties) {
                        this.soapAction = soapRequestMessage.getSoapAction();
                    }
                    if (this.soapAction == null) {
                        this.soapAction = "\"OpenSPCoop\"";
                    }
                    if (MessageType.SOAP_11.equals((Object)this.requestMsg.getMessageType()) && !existsTransportProperties) {
                        this.setRequestHeader("SOAPAction", this.soapAction, propertiesTrasportoDebug);
                    }
                    if (this.debug) {
                        this.logger.info("SOAP Action inviata [" + this.soapAction + "]", false);
                    }
                }
                if (this.isDumpBinarioRichiesta()) {
                    bout = new DumpByteArrayOutputStream(this.dumpBinario_soglia, this.dumpBinario_repositoryFile, this.idTransazione, TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO.getValue());
                    try {
                        this.emitDiagnosticStartDumpBinarioRichiestaUscita();
                        this.requestMsg.writeTo((OutputStream)bout, false);
                        bout.flush();
                        bout.close();
                        this.dumpBinarioRichiestaUscita(bout, requestMessageType, contentTypeRichiesta, this.location, propertiesTrasportoDebug);
                    }
                    finally {
                        try {
                            bout.clearResources();
                        }
                        catch (Throwable t) {
                            this.logger.error("Release resources failed: " + t.getMessage(), t);
                        }
                    }
                }
                if (this.debug) {
                    this.logger.debug("Send...");
                }
                soapMsg = this.connection.call(this.soapRequestMessage, (Object)this.location);
                this.dataRichiestaInoltrata = DateManager.getDate();
                this.responseMsg = messageFactory.createMessage(this.requestMsg.getMessageType(), MessageRole.RESPONSE, soapMsg);
                this.dataAccettazioneRisposta = DateManager.getDate();
            }
            catch (SOAPException sendError) {
                this.eccezioneProcessamento = sendError;
                errorMsg = this.readExceptionMessageFromException(sendError);
                this.connection.close();
                this.errore = "Errore avvenuto durante la consegna SOAP (lettura risposta): " + errorMsg;
                return false;
            }
            if (this.debug) {
                this.logger.debug("Check consistenza...");
            }
            soapResponse = null;
            if (this.responseMsg != null) {
                soapMessageResponse = this.responseMsg.castAsSoap();
                soapResponse = soapMessageResponse.getSOAPMessage();
                if (soapMessageResponse.getSOAPBody() != null && soapMessageResponse.hasSOAPFault() && soapMessageResponse.getSOAPBody().getFault().getFaultString().indexOf("Premature end of file") != -1) {
                    this.responseMsg = null;
                }
            }
            if (soapResponse != null && soapResponse.getMimeHeaders() != null) {
                if (this.propertiesTrasportoRisposta == null) {
                    this.propertiesTrasportoRisposta = new HashMap<K, V>();
                }
                it = soapResponse.getMimeHeaders().getAllHeaders();
                while (it.hasNext()) {
                    mh = (MimeHeader)it.next();
                    if (mh == null || mh.getName() == null || mh.getValue() == null) continue;
                    TransportUtils.addHeader((Map)this.propertiesTrasportoRisposta, (String)mh.getName(), (String)mh.getValue());
                    if ("content-length".equalsIgnoreCase(mh.getName())) {
                        try {
                            this.contentLength = Integer.parseInt(mh.getValue());
                        }
                        catch (Exception var18_29) {
                            // empty catch block
                        }
                    }
                    if (!"content-type".equalsIgnoreCase(mh.getName())) continue;
                    try {
                        this.tipoRisposta = mh.getValue();
                    }
                    catch (Exception var18_30) {}
                }
            }
            this.codice = 200;
            if (this.responseMsg != null && this.contentLength < 0L) {
                this.contentLength = this.responseMsg.getIncomingMessageContentLength();
            }
            if (this.responseMsg != null) {
                responseContext = new TransportResponseContext(this.logger.getLogger());
                responseContext.setCodiceTrasporto("" + this.codice);
                responseContext.setContentLength(this.contentLength);
                responseContext.setHeaders(this.propertiesTrasportoRisposta);
                this.responseMsg.setTransportResponseContext(responseContext);
                this.messageTypeResponse = this.requestMsg.getMessageType();
                if (this.tipoRisposta == null) {
                    this.tipoRisposta = this.requestMsg.getContentType();
                }
            }
            if (this.isDumpBinarioRisposta()) {
                if (this.responseMsg != null) {
                    bout = null;
                    try {
                        try {
                            bout = new DumpByteArrayOutputStream(this.dumpBinario_soglia, this.dumpBinario_repositoryFile, this.idTransazione, TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO.getValue());
                            this.emitDiagnosticStartDumpBinarioRispostaIngresso();
                            this.responseMsg.writeTo((OutputStream)bout, false);
                        }
                        finally {
                            try {
                                if (bout != null) {
                                    bout.flush();
                                }
                            }
                            catch (Throwable mh) {}
                            try {
                                if (bout != null) {
                                    bout.close();
                                }
                            }
                            catch (Throwable mh) {}
                        }
                        if (this.debug) {
                            this.logger.info("Messaggio ricevuto (ContentType:" + this.tipoRisposta + ") :\n" + bout.toString(), false);
                        }
                        this.dumpBinarioRispostaIngresso(bout, this.messageTypeResponse, this.propertiesTrasportoRisposta);
                        if (this.contentLength >= 0L) ** GOTO lbl272
                        this.contentLength = bout.size();
                    }
                    finally {
                        try {
                            if (bout != null) {
                                bout.clearResources();
                            }
                        }
                        catch (Throwable t) {
                            this.logger.error("Release resources failed: " + t.getMessage(), t);
                        }
                    }
                } else {
                    if (this.debug) {
                        if (this.tipoRisposta != null) {
                            this.logger.info("Messaggio ricevuto (ContentType:" + this.tipoRisposta + ") senza contenuto nell'http-reply", false);
                        } else {
                            this.logger.info("Messaggio ricevuto senza contenuto nell'http-reply", false);
                        }
                    }
                    this.emitDiagnosticStartDumpBinarioRispostaIngresso();
                    this.dumpBinarioRispostaIngresso(null, null, this.propertiesTrasportoRisposta);
                }
            }
lbl272:
            // 5 sources

            if (this.debug) {
                this.logger.info("Gestione invio/risposta http effettuata con successo", false);
            }
            this.postOutRequest();
            return true;
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            msgErrore = this.readExceptionMessageFromException(e);
            this.errore = this.generateErrorWithConnectorPrefix != false ? "Errore avvenuto durante la consegna SOAP: " + msgErrore : msgErrore;
            this.logger.error("Errore avvenuto durante la consegna SOAP: " + msgErrore, e);
            this.processConnectionTimeoutException(connectionTimeout, connectionTimeoutConfigurazioneGlobale, e, msgErrore);
            this.processReadTimeoutException(readConnectionTimeout, readConnectionTimeoutConfigurazioneGlobale, e, msgErrore);
            return false;
        }
    }

    @Override
    public void disconnect() throws ConnettoreException {
        ArrayList<Throwable> listExceptionChiusura = new ArrayList<Throwable>();
        try {
            if (this.connection != null) {
                if (this.debug && this.logger != null) {
                    this.logger.debug("Connection.close ...");
                }
                try {
                    this.connection.close();
                }
                catch (Throwable t) {
                    if (this.logger != null) {
                        this.logger.debug("Chiusura socket fallita: " + t.getMessage(), t);
                    }
                    listExceptionChiusura.add(t);
                }
            }
            try {
                super.disconnect();
            }
            catch (Throwable t) {
                if (this.logger != null) {
                    this.logger.debug("Chiusura risorse fallita: " + t.getMessage(), t);
                }
                listExceptionChiusura.add(t);
            }
        }
        catch (Exception e) {
            throw new ConnettoreException("Chiusura connessione non riuscita: " + e.getMessage(), e);
        }
        if (listExceptionChiusura != null && !listExceptionChiusura.isEmpty()) {
            UtilsMultiException multiException = new UtilsMultiException(listExceptionChiusura.toArray(new Throwable[1]));
            throw new ConnettoreException("Chiusura connessione non riuscita: " + multiException.getMessage(), multiException);
        }
    }

    private void setRequestHeader(boolean validazioneHeaderRFC2047, String key, List<String> values, ConnettoreLogger logger, Map<String, List<String>> propertiesTrasportoDebug) throws Exception {
        if (validazioneHeaderRFC2047) {
            try {
                RFC2047Utilities.validHeader((String)key, values);
                this.setRequestHeader(key, values, propertiesTrasportoDebug);
            }
            catch (UtilsException e) {
                logger.error(e.getMessage(), e);
            }
        } else {
            this.setRequestHeader(key, values, propertiesTrasportoDebug);
        }
    }

    @Override
    protected void setRequestHeader(String key, List<String> values) throws Exception {
        if (values != null && !values.isEmpty()) {
            for (String value : values) {
                this.soapRequestMessage.getMimeHeaders().addHeader(key, value);
            }
        }
    }
}

