/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import org.apache.commons.io.output.NullOutputStream;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.core.Utilities;
import org.openspcoop2.pdd.core.connettori.ConnettoreBase;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.connettori.ConnettoreUtils;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.builder.Imbustamento;
import org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StatefulMessage;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.random.RandomUtilities;

public class ConnettoreStresstest
extends ConnettoreBase {
    public static final String ENDPOINT_TYPE = "stresstest";
    public static final String LOCATION = "openspcoop2://stresstest";
    private static final String HEADER_APPLICATIVO = "<thdr:headerApplicativo xmlns:thdr=\"http://example.org/test\" tipo=\"TEST\" soapenv:actor=\"http://example.org/test/actor\">\n<identificativoDominio>ITALIA</identificativoDominio>\n<thdr:identificatore>RISP@SERIAL@</thdr:identificatore>\n</thdr:headerApplicativo>";
    private static final String SOAP_ENVELOPE_RISPOSTA = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" \txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Header>@HDR@</soapenv:Header>";
    private static final String SOAP_ENVELOPE_RISPOSTA_END = "<soapenv:Body><prova>test</prova></soapenv:Body></soapenv:Envelope>";
    private Resource resource = null;
    private DBManager dbManager = DBManager.getInstance();

    @Override
    public String getProtocollo() {
        return "HTTP";
    }

    @Override
    protected boolean initializePreSend(ResponseCachingConfigurazione responseCachingConfig, ConnettoreMsg request) {
        return this.initialize(request, false, responseCachingConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean send(ConnettoreMsg request) {
        boolean headerApplicativoRisposta = false;
        if (this.properties.get("addHeader") != null && "true".equalsIgnoreCase(((String)this.properties.get("addHeader")).trim())) {
            headerApplicativoRisposta = true;
        }
        this.codice = 200;
        try {
            NullOutputStream nullOutputStream = NullOutputStream.INSTANCE;
            this.requestMsg.writeTo((OutputStream)nullOutputStream, true);
            nullOutputStream.flush();
            nullOutputStream.close();
            this.dataRichiestaInoltrata = DateManager.getDate();
            this.postOutRequest();
            if (request.getConnectorProperties() != null) {
                String max = request.getConnectorProperties().get("sleepMax");
                String min = request.getConnectorProperties().get("sleepMin");
                if (max != null) {
                    int sleep;
                    int maxSleep = Integer.parseInt(max);
                    int minSleep = 0;
                    if (min != null) {
                        minSleep = Integer.parseInt(min);
                    }
                    if ((sleep = minSleep + RandomUtilities.getRandom().nextInt(maxSleep - minSleep)) > 1000) {
                        int count = sleep / 1000;
                        int resto = sleep % 1000;
                        this.logger.info("sleep " + sleep + "ms ...", false);
                        for (int i = 0; i < count; ++i) {
                            org.openspcoop2.utils.Utilities.sleep((long)1000L);
                        }
                        org.openspcoop2.utils.Utilities.sleep((long)resto);
                        this.logger.info("sleep " + sleep + "ms terminated", false);
                    } else {
                        this.logger.info("sleep " + sleep + "ms ...", false);
                        org.openspcoop2.utils.Utilities.sleep((long)sleep);
                        this.logger.info("sleep " + sleep + "ms terminated", false);
                    }
                } else {
                    String sleepConstant = request.getConnectorProperties().get("sleep");
                    if (sleepConstant != null) {
                        int millisecond = Integer.parseInt(sleepConstant);
                        if (millisecond > 1000) {
                            int count = millisecond / 1000;
                            int resto = millisecond % 1000;
                            this.logger.info("sleep " + millisecond + "ms ...", false);
                            for (int i = 0; i < count; ++i) {
                                org.openspcoop2.utils.Utilities.sleep((long)1000L);
                            }
                            org.openspcoop2.utils.Utilities.sleep((long)resto);
                            this.logger.info("sleep " + millisecond + "ms terminated", false);
                        } else {
                            this.logger.info("sleep " + millisecond + "ms ...", false);
                            org.openspcoop2.utils.Utilities.sleep((long)millisecond);
                            this.logger.info("sleep " + millisecond + "ms terminated", false);
                        }
                    }
                }
            }
            this.preInResponse();
            NotifierInputStreamParams notifierInputStreamParams = null;
            if (this.preInResponseContext != null) {
                notifierInputStreamParams = this.preInResponseContext.getNotifierInputStreamParams();
            }
            if (!(!org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ONEWAY.equals((Object)request.getBusta().getProfiloDiCollaborazione()) || request.getBusta().isConfermaRicezione() && this.openspcoopProperties.isGestioneRiscontri("standard"))) {
                boolean min = true;
                return min;
            }
            Object protocolHeader = this.buildProtocolHeader(request);
            if (headerApplicativoRisposta) {
                String hdrApplicativo = HEADER_APPLICATIVO.replace("@SERIAL@", "" + DateManager.getTimeMillis());
                protocolHeader = hdrApplicativo + "\n" + (String)protocolHeader;
            }
            String messaggio = SOAP_ENVELOPE_RISPOSTA.replace("@HDR@", (CharSequence)protocolHeader) + SOAP_ENVELOPE_RISPOSTA_END;
            byte[] messaggioArray = messaggio.getBytes();
            ByteArrayInputStream bin = new ByteArrayInputStream(messaggioArray);
            OpenSPCoop2MessageFactory messageFactory = Utilities.getOpenspcoop2MessageFactory(this.logger.getLogger(), this.requestMsg, this.requestInfo, MessageRole.RESPONSE);
            OpenSPCoop2MessageParseResult pr = messageFactory.createMessage(this.requestMsg.getMessageType(), MessageRole.RESPONSE, this.requestMsg.getContentType(), (InputStream)bin, notifierInputStreamParams, this.openspcoopProperties.getAttachmentsProcessingMode());
            if (pr.getParseException() != null) {
                this.getPddContext().addObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, pr.getParseException());
            }
            this.responseMsg = pr.getMessage_throwParseException();
            if (this.responseMsg != null) {
                this.contentLength = messaggioArray.length;
            }
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.logger.error("Riscontrato errore durante l'echo del msg soap", e);
            this.errore = "Riscontrato errore durante l'echo del msg soap:" + this.readExceptionMessageFromException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.dbManager.releaseResource(this.openspcoopProperties.getIdentitaPortaDefault(this.getProtocolFactory().getProtocol(), this.requestInfo), "ConnettoreStresstest", this.resource);
        }
        return true;
    }

    @Override
    public String getLocation() throws ConnettoreException {
        return ConnettoreUtils.buildLocationWithURLBasedParameter(this.logger != null ? this.logger.getLogger() : null, this.requestMsg, ENDPOINT_TYPE, this.propertiesUrlBased, LOCATION, this.getProtocolFactory(), this.idModulo);
    }

    private String buildProtocolHeader(ConnettoreMsg request) throws Exception {
        Busta bustaRichiesta = request.getBusta();
        if ("spcoop".equals(bustaRichiesta.getProtocollo())) {
            return this.buildSPCoopProtocolHeader(request);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildSPCoopProtocolHeader(ConnettoreMsg request) throws Exception {
        Busta bustaRichiesta = request.getBusta();
        StatefulMessage state = new StatefulMessage(null, this.logger.getLogger());
        Object id = this.getPddContext().getObject(Costanti.ID_TRANSAZIONE);
        String idTransazione = null;
        if (id != null) {
            idTransazione = (String)id;
        }
        StringBuilder protocolHeader = new StringBuilder();
        if (bustaRichiesta != null && bustaRichiesta.sizeListaEccezioni() == 0 && !"ConsegnaContenutiApplicativi".equals(request.getIdModulo())) {
            String idRiscontro = null;
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(bustaRichiesta.getProtocollo());
            ITraduttore traduttore = protocolFactory.createTraduttore();
            protocolHeader.append("<eGov_IT:Intestazione SOAP_ENV:actor=\"http://www.cnipa.it/eGov_it/portadominio\" SOAP_ENV:mustUnderstand=\"1\" xmlns:SOAP_ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:eGov_IT=\"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/\"><eGov_IT:IntestazioneMessaggio>");
            protocolHeader.append("<eGov_IT:Mittente><eGov_IT:IdentificativoParte tipo=\"" + traduttore.toProtocolOrganizationType(bustaRichiesta.getTipoDestinatario()) + "\">" + bustaRichiesta.getDestinatario() + "</eGov_IT:IdentificativoParte></eGov_IT:Mittente>");
            protocolHeader.append("<eGov_IT:Destinatario><eGov_IT:IdentificativoParte tipo=\"" + traduttore.toProtocolOrganizationType(bustaRichiesta.getTipoMittente()) + "\">" + bustaRichiesta.getMittente() + "</eGov_IT:IdentificativoParte></eGov_IT:Destinatario>");
            if (bustaRichiesta.getProfiloDiCollaborazione() != null) {
                if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ONEWAY.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) && bustaRichiesta.isConfermaRicezione() && this.openspcoopProperties.isGestioneRiscontri("standard")) {
                    protocolHeader.append("<eGov_IT:ProfiloCollaborazione>" + traduttore.toString(bustaRichiesta.getProfiloDiCollaborazione()) + "</eGov_IT:ProfiloCollaborazione>");
                    idRiscontro = bustaRichiesta.getID();
                } else if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) && bustaRichiesta.getRiferimentoMessaggio() == null) {
                    protocolHeader.append("<eGov_IT:ProfiloCollaborazione tipo=\"" + traduttore.toProtocolServiceType(bustaRichiesta.getTipoServizio()) + "\" servizioCorrelato=\"" + bustaRichiesta.getServizio() + "Correlato\" >" + traduttore.toString(bustaRichiesta.getProfiloDiCollaborazione()) + "</eGov_IT:ProfiloCollaborazione>");
                } else if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) && bustaRichiesta.getRiferimentoMessaggio() == null) {
                    try {
                        this.resource = this.dbManager.getResource(this.openspcoopProperties.getIdentitaPortaDefault(this.getProtocolFactory().getProtocol(), this.requestInfo), "ConnettoreStresstest", idTransazione);
                    }
                    catch (Exception e) {
                        throw new Exception("Risorsa non ottenibile", e);
                    }
                    if (this.resource == null) {
                        throw new Exception("Risorsa is null");
                    }
                    if (this.resource.getResource() == null) {
                        throw new Exception("Connessione is null");
                    }
                    Connection connectionDB = (Connection)this.resource.getResource();
                    state.setConnectionDB(connectionDB);
                    RepositoryBuste repositoryBuste = new RepositoryBuste((IState)state, true, this.getProtocolFactory());
                    repositoryBuste.registraBustaIntoInBox(bustaRichiesta, new ArrayList(), OpenSPCoop2Properties.getInstance().getRepositoryIntervalloScadenzaMessaggi());
                    Integrazione infoIntegrazione = new Integrazione();
                    infoIntegrazione.setIdModuloInAttesa(null);
                    repositoryBuste.aggiornaInfoIntegrazioneIntoInBox(bustaRichiesta.getID(), infoIntegrazione);
                    ProfiloDiCollaborazione profiloCollaborazione = new ProfiloDiCollaborazione((IState)state, this.getProtocolFactory());
                    profiloCollaborazione.asincronoSimmetrico_registraRichiestaRicevuta(bustaRichiesta.getID(), bustaRichiesta.getCollaborazione(), bustaRichiesta.getTipoServizioCorrelato(), bustaRichiesta.getServizioCorrelato(), bustaRichiesta.getVersioneServizioCorrelato(), true, this.openspcoopProperties.getRepositoryIntervalloScadenzaMessaggi());
                    try {
                        connectionDB.setAutoCommit(false);
                        state.executePreparedStatement();
                        connectionDB.commit();
                        connectionDB.setAutoCommit(true);
                    }
                    catch (Exception e) {
                        this.logger.error("Riscontrato errore durante la gestione transazione del DB per la richiesta: " + e.getMessage(), e);
                        try {
                            connectionDB.rollback();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        state.closePreparedStatement();
                    }
                    finally {
                        try {
                            connectionDB.setAutoCommit(true);
                        }
                        catch (Exception exception) {}
                    }
                    protocolHeader.append("<eGov_IT:ProfiloCollaborazione>" + traduttore.toString(bustaRichiesta.getProfiloDiCollaborazione()) + "</eGov_IT:ProfiloCollaborazione>");
                } else {
                    protocolHeader.append("<eGov_IT:ProfiloCollaborazione>" + traduttore.toString(bustaRichiesta.getProfiloDiCollaborazione()) + "</eGov_IT:ProfiloCollaborazione>");
                }
            }
            if (bustaRichiesta.getTipoServizio() != null && bustaRichiesta.getServizio() != null) {
                protocolHeader.append("<eGov_IT:Servizio tipo=\"" + traduttore.toProtocolServiceType(bustaRichiesta.getTipoServizio()) + "\">" + bustaRichiesta.getServizio() + "</eGov_IT:Servizio>");
            }
            if (bustaRichiesta.getAzione() != null) {
                protocolHeader.append("<eGov_IT:Azione>" + bustaRichiesta.getAzione() + "</eGov_IT:Azione>");
            }
            protocolHeader.append("<eGov_IT:Messaggio>");
            Object dominio = null;
            if (request.getConnectorProperties() != null) {
                dominio = request.getConnectorProperties().get("identificativo-porta");
            }
            if (dominio == null) {
                dominio = bustaRichiesta.getDestinatario() + "SPCoopIT";
            }
            String idBustaRisposta = null;
            Imbustamento imbustatore = new Imbustamento(this.logger.getLogger(), this.getProtocolFactory(), (IState)state);
            idBustaRisposta = imbustatore.buildID(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), (String)dominio), null, this.openspcoopProperties.getGestioneSerializableDBAttesaAttiva(), this.openspcoopProperties.getGestioneSerializableDBCheckInterval(), RuoloMessaggio.RISPOSTA);
            protocolHeader.append("<eGov_IT:Identificatore>" + idBustaRisposta + "</eGov_IT:Identificatore>");
            String oraS = traduttore.getDate_protocolFormat(bustaRichiesta.getOraRegistrazione());
            protocolHeader.append("<eGov_IT:OraRegistrazione tempo=\"" + traduttore.toString(bustaRichiesta.getTipoOraRegistrazione()) + "\">" + oraS + "</eGov_IT:OraRegistrazione>");
            protocolHeader.append("<eGov_IT:RiferimentoMessaggio>" + bustaRichiesta.getID() + "</eGov_IT:RiferimentoMessaggio>");
            protocolHeader.append("</eGov_IT:Messaggio>");
            protocolHeader.append("</eGov_IT:IntestazioneMessaggio>");
            if (idRiscontro != null) {
                protocolHeader.append("<eGov_IT:ListaRiscontri><eGov_IT:Riscontro><eGov_IT:Identificatore>" + idRiscontro + "</eGov_IT:Identificatore><eGov_IT:OraRegistrazione tempo=\"" + traduttore.toString(bustaRichiesta.getTipoOraRegistrazione()) + "\">" + oraS + "</eGov_IT:OraRegistrazione></eGov_IT:Riscontro> </eGov_IT:ListaRiscontri>");
            }
            protocolHeader.append("</eGov_IT:Intestazione>");
        }
        return protocolHeader.toString();
    }
}

