/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.InvocazioneCredenziali;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageProperties;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.rest.RestUtilities;
import org.openspcoop2.pdd.config.ForwardProxy;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.connettori.ConnettoreBase;
import org.openspcoop2.pdd.core.connettori.ConnettoreBaseHTTP;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreFILE;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.connettori.ConnettoreRicezioneBusteDirectVM;
import org.openspcoop2.pdd.core.connettori.ConnettoreRicezioneContenutiApplicativiDirectVM;
import org.openspcoop2.pdd.core.connettori.ConnettoreRicezioneContenutiApplicativiHTTPtoSOAPDirectVM;
import org.openspcoop2.pdd.core.connettori.IConnettore;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.core.token.PolicyNegoziazioneToken;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.utils.PorteNamingUtils;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.certificate.byok.BYOKManager;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;
import org.openspcoop2.utils.certificate.ocsp.OCSPManager;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.slf4j.Logger;

public class ConnettoreUtils {
    public static String formatLocation(HttpRequestMethod httpMethod, String location) {
        if (httpMethod != null) {
            return location + " http-method:" + httpMethod;
        }
        return location;
    }

    public static String getAndReplaceLocationWithBustaValues(IConnettore connector, ConnettoreMsg connettoreMsg, Busta busta, PdDContext pddContext, IProtocolFactory<?> protocolFactory, Logger log) throws ConnettoreException {
        boolean dynamicLocation = false;
        String location = null;
        if (TipiConnettore.NULL.getNome().equals(connettoreMsg.getTipoConnettore())) {
            location = "govway://dev/null";
        } else if (TipiConnettore.NULLECHO.getNome().equals(connettoreMsg.getTipoConnettore())) {
            location = "govway://echo";
        } else if (TipiConnettore.STATUS.getNome().equals(connettoreMsg.getTipoConnettore())) {
            location = "govway://status";
        } else if ("stresstest".equals(connettoreMsg.getTipoConnettore())) {
            location = "openspcoop2://stresstest";
        } else if (TipiConnettore.FILE.getNome().equals(connettoreMsg.getTipoConnettore())) {
            try {
                location = ((ConnettoreFILE)connector).buildLocation(connettoreMsg);
            }
            catch (Exception e) {
                log.error("Errore durante la costruzione della location: " + e.getMessage(), (Throwable)e);
                location = "N.D.";
            }
        } else if ("vmPA".equals(connettoreMsg.getTipoConnettore())) {
            try {
                ((ConnettoreRicezioneBusteDirectVM)connector).validate(connettoreMsg);
                ((ConnettoreRicezioneBusteDirectVM)connector).buildLocation(connettoreMsg.getConnectorProperties(), false);
                location = connector.getLocation();
                dynamicLocation = true;
            }
            catch (Exception e) {
                log.error("Errore durante la costruzione della location: " + e.getMessage(), (Throwable)e);
                location = "N.D.";
            }
        } else if ("vmPD".equals(connettoreMsg.getTipoConnettore())) {
            try {
                ((ConnettoreRicezioneContenutiApplicativiDirectVM)connector).validate(connettoreMsg);
                ((ConnettoreRicezioneContenutiApplicativiDirectVM)connector).buildLocation(connettoreMsg.getConnectorProperties(), false);
                location = connector.getLocation();
                dynamicLocation = true;
            }
            catch (Exception e) {
                log.error("Errore durante la costruzione della location: " + e.getMessage(), (Throwable)e);
                location = "N.D.";
            }
        } else if ("vmPDtoSOAP".equals(connettoreMsg.getTipoConnettore())) {
            try {
                ((ConnettoreRicezioneContenutiApplicativiHTTPtoSOAPDirectVM)connector).validate(connettoreMsg);
                ((ConnettoreRicezioneContenutiApplicativiHTTPtoSOAPDirectVM)connector).buildLocation(connettoreMsg.getConnectorProperties(), false);
                location = connector.getLocation();
                dynamicLocation = true;
            }
            catch (Exception e) {
                log.error("Errore durante la costruzione della location: " + e.getMessage(), (Throwable)e);
                location = "N.D.";
            }
        } else if (connettoreMsg.getConnectorProperties().get("location") != null) {
            location = connettoreMsg.getConnectorProperties().get("location");
            dynamicLocation = true;
        }
        if (location != null && !location.equals("")) {
            location = location.replace("#TipoServizio", busta.getTipoServizio());
            location = location.replace("#Servizio", busta.getServizio());
            if (busta.getAzione() != null) {
                location = location.replace("#Azione", busta.getAzione());
            }
            if (dynamicLocation) {
                try {
                    Map<String, Object> dynamicMap = ((ConnettoreBase)connector).buildDynamicMap(connettoreMsg);
                    location = DynamicUtils.convertDynamicPropertyValue("location", location, dynamicMap, pddContext, false);
                }
                catch (Exception e) {
                    log.error("Errore durante la costruzione della location (dynamic): " + e.getMessage(), (Throwable)e);
                }
            }
            connettoreMsg.getConnectorProperties().put("location", location);
        }
        return location;
    }

    public static String buildLocationWithURLBasedParameter(Logger log, OpenSPCoop2Message msg, String tipoConnettore, Map<String, List<String>> propertiesURLBased, String locationParam, IProtocolFactory<?> protocolFactory, String idModulo) throws ConnettoreException {
        if (TipiConnettore.HTTP.toString().equals(tipoConnettore) || TipiConnettore.HTTPS.toString().equals(tipoConnettore) || "httpcore".equals(tipoConnettore) || "saaj".equals(tipoConnettore) || "stresstest".equals(tipoConnettore)) {
            try {
                OpenSPCoop2MessageProperties forwardParameter = null;
                forwardParameter = ServiceBinding.REST.equals((Object)msg.getServiceBinding()) ? msg.getForwardUrlProperties(OpenSPCoop2Properties.getInstance().getRESTServicesUrlParametersForwardConfig()) : msg.getForwardUrlProperties(OpenSPCoop2Properties.getInstance().getSOAPServicesUrlParametersForwardConfig());
                Map<String, List<String>> p = propertiesURLBased;
                if (forwardParameter != null && forwardParameter.size() > 0) {
                    if (p == null) {
                        p = new HashMap<String, List<String>>();
                    }
                    Iterator keys = forwardParameter.getKeys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        List values = forwardParameter.getPropertyValues(key);
                        if (values == null || values.isEmpty()) continue;
                        if (p.containsKey(key)) {
                            p.remove(key);
                        }
                        p.put(key, values);
                    }
                }
                String location = locationParam;
                if (ServiceBinding.REST.equals((Object)msg.getServiceBinding())) {
                    String normalizedInterfaceName = ConnettoreUtils.normalizeInterfaceName(msg, idModulo, protocolFactory);
                    return RestUtilities.buildUrl((Logger)log, (String)location, p, (TransportRequestContext)msg.getTransportRequestContext(), (String)normalizedInterfaceName);
                }
                boolean encodeBaseLocation = true;
                return TransportUtils.buildUrlWithParameters(p, (String)location, (boolean)encodeBaseLocation, (Logger)OpenSPCoop2Logger.getLoggerOpenSPCoopCore());
            }
            catch (Exception e) {
                throw new ConnettoreException(e.getMessage(), e);
            }
        }
        return locationParam;
    }

    public static String normalizeInterfaceName(OpenSPCoop2Message msg, String idModulo, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        Object nomePortaInvocataObject = msg.getContextProperty(CostantiPdD.NOME_PORTA_INVOCATA);
        String nomePortaInvocata = null;
        if (nomePortaInvocataObject != null && nomePortaInvocataObject instanceof String) {
            nomePortaInvocata = (String)nomePortaInvocataObject;
        } else if (msg.getTransportRequestContext() != null && msg.getTransportRequestContext().getInterfaceName() != null) {
            nomePortaInvocata = msg.getTransportRequestContext().getInterfaceName();
        }
        String normalizedInterfaceName = null;
        if (nomePortaInvocata != null) {
            PorteNamingUtils namingUtils = new PorteNamingUtils(protocolFactory);
            normalizedInterfaceName = "ConsegnaContenutiApplicativi".equals(idModulo) ? namingUtils.normalizePA(nomePortaInvocata) : namingUtils.normalizePD(nomePortaInvocata);
        }
        return normalizedInterfaceName;
    }

    public static String limitLocation255Character(String location) {
        return TransportUtils.limitLocation255Character((String)location);
    }

    public static String addProxyInfoToLocationForHTTPConnector(String tipoConnettore, Map<String, String> properties, String location) {
        if ((TipiConnettore.HTTP.toString().equals(tipoConnettore) || TipiConnettore.HTTPS.toString().equals(tipoConnettore)) && properties.get("proxyType") != null) {
            String proxyHostname = properties.get("proxyHostname");
            String proxyPort = properties.get("proxyPort");
            return location + " [proxy: " + proxyHostname + ":" + proxyPort + "]";
        }
        return location;
    }

    public static String addGovWayProxyInfoToLocationForHTTPConnector(ForwardProxy forwardProxy, IConnettore connectorSender, String location) throws ConnettoreException {
        if (forwardProxy != null && connectorSender instanceof ConnettoreBaseHTTP) {
            ConnettoreBaseHTTP http = (ConnettoreBaseHTTP)connectorSender;
            http.updateForwardProxy(forwardProxy);
            if (http.updateLocation_forwardProxy(location)) {
                return http.getLocation();
            }
        }
        return location;
    }

    public static void printDatiConnettore(Connettore connettore, String labelTipoConnettore, String labelNomeConnettore, boolean connettoreStatic, StringBuilder sb, String separator, String newLine, boolean printIntestazione) {
        ConnettoreUtils.printDatiConnettore(connettore.mappingIntoConnettoreConfigurazione(), labelTipoConnettore, labelNomeConnettore, null, connettoreStatic, sb, separator, newLine, printIntestazione);
    }

    public static void printDatiConnettore(org.openspcoop2.core.config.Connettore connettore, String labelTipoConnettore, String labelNomeConnettore, ServizioApplicativo sa, boolean connettoreStatic, StringBuilder sb, String separator, String newLine, boolean printIntestazione) {
        String proxyHostname;
        String readConnectionTimeout;
        String connectionTimeout;
        String endpointV;
        TipiConnettore tipo;
        if (connettoreStatic) {
            return;
        }
        Boolean integrationManager = null;
        InvocazioneCredenziali invCredenziali = null;
        if (sa != null) {
            InvocazioneServizio is = sa.getInvocazioneServizio();
            integrationManager = is.getGetMessage() != null && StatoFunzionalita.ABILITATO.equals((Object)is.getGetMessage());
            invCredenziali = is.getCredenziali();
        }
        if ((tipo = TipiConnettore.toEnumFromName((String)connettore.getTipo())) == null) {
            tipo = TipiConnettore.CUSTOM;
        }
        if (printIntestazione) {
            sb.append(newLine);
            Object label = labelNomeConnettore != null ? " " + labelNomeConnettore : "";
            sb.append("- Connettore" + (String)label + " -");
        }
        Object tipoConnettore = labelTipoConnettore;
        if (TipiConnettore.DISABILITATO.equals((Object)tipo)) {
            if (integrationManager != null && integrationManager.booleanValue()) {
                tipoConnettore = "MessageBox";
            }
        } else if (integrationManager != null && integrationManager.booleanValue()) {
            tipoConnettore = (String)tipoConnettore + " + MessageBox";
        }
        sb.append(newLine);
        sb.append("Tipo");
        sb.append(separator);
        sb.append((String)tipoConnettore);
        Object labelEndpoint = "Endpoint";
        String endpoint = null;
        if (TipiConnettore.HTTP.getNome().equals(connettore.getTipo()) || TipiConnettore.HTTPS.getNome().equals(connettore.getTipo())) {
            endpoint = ConnettoreUtils.getProperty("location", connettore.getPropertyList());
        } else if (TipiConnettore.JMS.getNome().equals(connettore.getTipo())) {
            String tipoCoda = ConnettoreUtils.getProperty("tipo", connettore.getPropertyList());
            labelEndpoint = "Nome " + tipoCoda;
            endpoint = ConnettoreUtils.getProperty("location", connettore.getPropertyList());
        } else if (TipiConnettore.FILE.getNome().equals(connettore.getTipo())) {
            labelEndpoint = "OutputFile";
            endpoint = ConnettoreUtils.getProperty("outputFile", connettore.getPropertyList());
        } else if (!TipiConnettore.NULL.getNome().equals(connettore.getTipo()) && !TipiConnettore.NULLECHO.getNome().equals(connettore.getTipo()) && !TipiConnettore.STATUS.getNome().equals(connettore.getTipo()) && StringUtils.isNotEmpty((String)(endpointV = ConnettoreUtils.getProperty("location", connettore.getPropertyList())))) {
            endpoint = endpointV;
        }
        if (endpoint != null) {
            sb.append(newLine);
            sb.append((String)labelEndpoint);
            sb.append(separator);
            sb.append(endpoint);
        }
        if (sa != null && "server".equals(sa.getTipo())) {
            sb.append(newLine);
            sb.append("Applicativo Server");
            sb.append(separator);
            sb.append(sa.getNome());
        }
        if ((connectionTimeout = ConnettoreUtils.getProperty("connectionTimeout", connettore.getPropertyList())) != null) {
            try {
                long l = Long.valueOf(connectionTimeout);
                if (l > 0L) {
                    sb.append(newLine);
                    sb.append("Connection Timeout");
                    sb.append(separator);
                    sb.append(Utilities.convertSystemTimeIntoStringMillisecondi((long)l, (boolean)true, (boolean)false, (String)" ", (String)" ", (String)""));
                }
            }
            catch (Throwable l) {
                // empty catch block
            }
        }
        if ((readConnectionTimeout = ConnettoreUtils.getProperty("readConnectionTimeout", connettore.getPropertyList())) != null) {
            try {
                long l = Long.valueOf(readConnectionTimeout);
                if (l > 0L) {
                    sb.append(newLine);
                    sb.append("Read Timeout");
                    sb.append(separator);
                    sb.append(Utilities.convertSystemTimeIntoStringMillisecondi((long)l, (boolean)true, (boolean)false, (String)" ", (String)" ", (String)""));
                }
            }
            catch (Throwable l) {
                // empty catch block
            }
        }
        if (TipiConnettore.HTTP.getNome().equals(connettore.getTipo()) || TipiConnettore.HTTPS.getNome().equals(connettore.getTipo())) {
            String apiKey;
            String bearerToken;
            String token = ConnettoreUtils.getProperty("tokenPolicy", connettore.getPropertyList());
            if (token != null) {
                sb.append(newLine);
                sb.append("Autenticazione Token").append(" - ").append("Policy");
                sb.append(separator);
                sb.append(token);
            }
            String username = null;
            username = invCredenziali != null ? invCredenziali.getUser() : ConnettoreUtils.getProperty("user", connettore.getPropertyList());
            if (username != null) {
                sb.append(newLine);
                sb.append("Autenticazione Http").append(" - ").append("Utente");
                sb.append(separator);
                sb.append(username);
            }
            if ((bearerToken = ConnettoreUtils.getProperty("bearerToken", connettore.getPropertyList())) != null) {
                sb.append(newLine);
                sb.append("Autenticazione Bearer").append(" ").append("Token");
                sb.append(separator);
                sb.append(bearerToken);
            }
            if ((apiKey = ConnettoreUtils.getProperty("apiKey", connettore.getPropertyList())) != null && StringUtils.isNotEmpty((String)apiKey)) {
                String apiKeyHeader = ConnettoreUtils.getProperty("apiKeyHeader", connettore.getPropertyList());
                if (apiKeyHeader == null || StringUtils.isEmpty((String)apiKeyHeader)) {
                    apiKeyHeader = "X-API-KEY";
                }
                sb.append(newLine);
                sb.append("Autenticazione API Key").append(" '").append(apiKeyHeader).append("'");
                String appId = ConnettoreUtils.getProperty("appId", connettore.getPropertyList());
                if (appId != null && StringUtils.isNotEmpty((String)appId)) {
                    String appIdHeader = ConnettoreUtils.getProperty("appIdHeader", connettore.getPropertyList());
                    if (appIdHeader == null || StringUtils.isEmpty((String)appIdHeader)) {
                        appIdHeader = "X-APP-ID";
                    }
                    sb.append(newLine);
                    sb.append("App ID").append(" '").append(appIdHeader).append("'");
                    sb.append(separator);
                    sb.append(appId);
                }
            }
        }
        if (TipiConnettore.HTTPS.getNome().equals(connettore.getTipo())) {
            String keyLocation;
            boolean trustAllCerts = false;
            String trustAllCertsV = ConnettoreUtils.getProperty("trustAllCerts", connettore.getPropertyList());
            if ("true".equalsIgnoreCase(trustAllCertsV)) {
                trustAllCerts = true;
            }
            String trustLocation = ConnettoreUtils.getProperty("trustStoreLocation", connettore.getPropertyList());
            if (trustAllCerts || trustLocation != null) {
                String trustOCSP;
                String hostnameVerifier;
                String sslType = ConnettoreUtils.getProperty("sslType", connettore.getPropertyList());
                if (sslType != null) {
                    sb.append(newLine);
                    sb.append("Autenticazione Https");
                    sb.append(separator);
                    sb.append(sslType);
                }
                if ((hostnameVerifier = ConnettoreUtils.getProperty("hostnameVerifier", connettore.getPropertyList())) != null) {
                    sb.append(newLine);
                    sb.append("Verifica Hostname");
                    sb.append(separator);
                    sb.append(hostnameVerifier);
                }
                sb.append(newLine);
                sb.append("Auth Server - TrustStore");
                sb.append(separator);
                if (trustAllCerts) {
                    sb.append("Trust all certificates");
                } else {
                    String trustType = ConnettoreUtils.getProperty("trustStoreType", connettore.getPropertyList());
                    boolean hsm = HSMUtils.isKeystoreHSM((String)trustType);
                    if (hsm) {
                        trustLocation = "HSM";
                    }
                    sb.append("(").append(trustType).append(") ").append(trustLocation);
                }
                String trustCRL = ConnettoreUtils.getProperty("trustStoreCRLs", connettore.getPropertyList());
                if (trustCRL != null) {
                    sb.append(newLine);
                    sb.append("Auth Server - CRLs");
                    sb.append(separator);
                    sb.append(trustCRL);
                }
                if ((trustOCSP = ConnettoreUtils.getProperty("trustStoreOCSPPolicy", connettore.getPropertyList())) != null) {
                    sb.append(newLine);
                    sb.append("Auth Server - OCSP Policy");
                    sb.append(separator);
                    try {
                        String label = OCSPManager.getInstance().getOCSPConfig(trustOCSP).getLabel();
                        sb.append(label != null && StringUtils.isNotEmpty((String)label) ? label : trustOCSP);
                    }
                    catch (Throwable t) {
                        sb.append(trustOCSP);
                    }
                }
            }
            if ((keyLocation = ConnettoreUtils.getProperty("keyStoreLocation", connettore.getPropertyList())) != null) {
                String keyBYOK;
                sb.append(newLine);
                sb.append("Auth Client - KeyStore");
                sb.append(separator);
                String keyType = ConnettoreUtils.getProperty("keyStoreType", connettore.getPropertyList());
                boolean hsm = HSMUtils.isKeystoreHSM((String)keyType);
                if (hsm) {
                    keyLocation = "HSM";
                }
                sb.append("(").append(keyType).append(") ").append(keyLocation);
                String keyAlias = ConnettoreUtils.getProperty("keyAlias", connettore.getPropertyList());
                if (keyAlias != null) {
                    sb.append(newLine);
                    sb.append("Auth Client - Key Alias");
                    sb.append(separator);
                    sb.append(keyAlias);
                }
                if ((keyBYOK = ConnettoreUtils.getProperty("keyStoreBYOKPolicy", connettore.getPropertyList())) != null) {
                    sb.append(newLine);
                    sb.append("Auth Client - BYOK Policy");
                    sb.append(separator);
                    try {
                        String label = BYOKManager.getInstance().getKMSConfigByType(keyBYOK).getLabel();
                        sb.append(label != null && StringUtils.isNotEmpty((String)label) ? label : keyBYOK);
                    }
                    catch (Exception t) {
                        sb.append(keyBYOK);
                    }
                }
            }
        }
        if ((TipiConnettore.HTTP.getNome().equals(connettore.getTipo()) || TipiConnettore.HTTPS.getNome().equals(connettore.getTipo())) && (proxyHostname = ConnettoreUtils.getProperty("proxyHostname", connettore.getPropertyList())) != null) {
            sb.append(newLine);
            sb.append("Proxy");
            sb.append(separator);
            String proxyPort = ConnettoreUtils.getProperty("proxyPort", connettore.getPropertyList());
            if (proxyPort != null) {
                sb.append(proxyHostname).append(":").append(proxyPort);
            }
        }
        if (TipiConnettore.JMS.getNome().equals(connettore.getTipo())) {
            String username = null;
            username = invCredenziali != null ? invCredenziali.getUser() : ConnettoreUtils.getProperty("user", connettore.getPropertyList());
            if (username != null) {
                sb.append(newLine);
                sb.append("Utente");
                sb.append(separator);
                sb.append(username);
            }
        }
        if (TipiConnettore.FILE.getNome().equals(connettore.getTipo())) {
            String f = ConnettoreUtils.getProperty("outputFileHeaders", connettore.getPropertyList());
            if (f != null) {
                sb.append(newLine);
                sb.append("OutputFile (Header)");
                sb.append(separator);
                sb.append(f);
            }
            if ((f = ConnettoreUtils.getProperty("inputFile", connettore.getPropertyList())) != null) {
                sb.append(newLine);
                sb.append("InputFile");
                sb.append(separator);
                sb.append(f);
            }
            if ((f = ConnettoreUtils.getProperty("inputFileHeaders", connettore.getPropertyList())) != null) {
                sb.append(newLine);
                sb.append("InputFile (Header)");
                sb.append(separator);
                sb.append(f);
            }
        }
    }

    public static String getEndpointConnettore(Connettore connettore, boolean connettoreStatic) {
        return ConnettoreUtils.getEndpointConnettore(connettore.mappingIntoConnettoreConfigurazione(), connettoreStatic);
    }

    public static String getEndpointConnettore(org.openspcoop2.core.config.Connettore connettore, boolean connettoreStatic) {
        if (connettoreStatic) {
            return null;
        }
        TipiConnettore tipo = TipiConnettore.toEnumFromName((String)connettore.getTipo());
        if (tipo == null) {
            tipo = TipiConnettore.CUSTOM;
        }
        String endpoint = null;
        if (TipiConnettore.HTTP.getNome().equals(connettore.getTipo()) || TipiConnettore.HTTPS.getNome().equals(connettore.getTipo())) {
            endpoint = ConnettoreUtils.getProperty("location", connettore.getPropertyList());
        } else if (TipiConnettore.JMS.getNome().equals(connettore.getTipo())) {
            endpoint = ConnettoreUtils.getProperty("location", connettore.getPropertyList());
        } else if (TipiConnettore.FILE.getNome().equals(connettore.getTipo())) {
            endpoint = ConnettoreUtils.getProperty("outputFile", connettore.getPropertyList());
        } else if (TipiConnettore.NULL.getNome().equals(connettore.getTipo())) {
            endpoint = "govway://dev/null";
        } else if (TipiConnettore.NULLECHO.getNome().equals(connettore.getTipo())) {
            endpoint = "govway://echo";
        } else if (TipiConnettore.STATUS.getNome().equals(connettore.getTipo())) {
            endpoint = "govway://status";
        } else {
            String endpointV = ConnettoreUtils.getProperty("location", connettore.getPropertyList());
            if (StringUtils.isNotEmpty((String)endpointV)) {
                endpoint = endpointV;
            }
        }
        return endpoint;
    }

    public static String getNegoziazioneTokenPolicyConnettore(Connettore connettore) {
        return ConnettoreUtils.getNegoziazioneTokenPolicyConnettore(connettore.mappingIntoConnettoreConfigurazione());
    }

    public static String getNegoziazioneTokenPolicyConnettore(org.openspcoop2.core.config.Connettore connettore) {
        return ConnettoreUtils.getProperty("tokenPolicy", connettore.getPropertyList());
    }

    public static String getNegoziazioneTokenEndpoint(GenericProperties gp, Logger log) {
        PolicyNegoziazioneToken policy = null;
        try {
            policy = TokenUtilities.convertTo(gp);
            return policy.getEndpoint();
        }
        catch (Exception e) {
            log.error("Errore durante il reperimento dell'endpoint della policy '" + gp.getNome() + "': " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String getProperty(String nome, List<Property> list) {
        if (list != null && list.size() > 0) {
            for (Property property : list) {
                if (!property.getNome().equals(nome)) continue;
                return property.getValore();
            }
        }
        return null;
    }

    public static String getNomeConnettori(Context context) {
        List l;
        String s;
        Object oConnettori;
        String connettoriMultipli = null;
        if (context.containsKey(Costanti.CONSEGNA_MULTIPLA_CONNETTORI_BY_ID) && (oConnettori = context.getObject(Costanti.CONSEGNA_MULTIPLA_CONNETTORI_BY_ID)) instanceof List && (s = ConnettoreUtils.getNomeConnettori(l = (List)oConnettori)) != null && s.length() > 0) {
            return s;
        }
        return connettoriMultipli;
    }

    private static String getNomeConnettori(List<?> l) {
        if (!l.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Object object : l) {
                if (!(object instanceof String)) continue;
                String s = (String)object;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(s);
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
        }
        return null;
    }
}

