/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPFault;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.GestioneErrore;
import org.openspcoop2.core.config.GestioneErroreCodiceTrasporto;
import org.openspcoop2.core.config.GestioneErroreSoapFault;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2RestJsonMessage;
import org.openspcoop2.message.OpenSPCoop2RestXmlMessage;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.pdd.core.GestoreMessaggiException;
import org.openspcoop2.pdd.core.connettori.IConnettore;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.MessaggiFaultErroreCooperazione;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.properties.PropertiesUtilities;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.rest.problem.JsonDeserializer;
import org.openspcoop2.utils.rest.problem.ProblemRFC7807;
import org.openspcoop2.utils.rest.problem.XmlDeserializer;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public class GestoreErroreConnettore {
    private boolean riconsegna;
    private Timestamp dataRispedizione;
    private String errore;
    private SOAPFault fault;
    private ProblemRFC7807 problem;
    private static Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
    private static final String ERRORE_APPLICATIVO_SOAP_FAULT = "errore applicativo SoapFault";
    private static final String INTERVALLO_RISPEDIZIONE_NON_IMPOSTATO = "Intervallo di rispedizione non impostato: ";
    private static final String SERIALIZZAZIONE_SOAP_FAULT_NON_RIUSCITA = "Serializzazione SOAPFault non riuscita: ";
    private static final String VERIFICA_ESPRESSIONE_REGOLARE_PREFIX = "Verifica espressione regolare '";
    private static final String FALLITA_SUFFIX = "' fallita: ";
    private static Semaphore semaphore = new Semaphore("GestoreErroreConnettore");
    private static HashMap<String, GestioneErrore> gestioneErroreDefaultComponenteIntegrazioneMap = new HashMap();
    private static HashMap<String, GestioneErrore> gestioneErroreDefaultComponenteCooperazioneMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GestioneErrore getGestioneErroreDefaultComponenteIntegrazione(IProtocolFactory<?> protocolFactory, ServiceBinding serviceBinding) {
        String key = protocolFactory.getProtocol() + "_" + serviceBinding;
        if (gestioneErroreDefaultComponenteIntegrazioneMap.containsKey(key)) {
            return gestioneErroreDefaultComponenteIntegrazioneMap.get(key);
        }
        SemaphoreLock lock = semaphore.acquireThrowRuntime("getGestioneErroreDefaultComponenteIntegrazione");
        try {
            if (gestioneErroreDefaultComponenteIntegrazioneMap.containsKey(key)) {
                GestioneErrore gestioneErrore = gestioneErroreDefaultComponenteIntegrazioneMap.get(key);
                return gestioneErrore;
            }
            GestioneErrore gestione = new GestioneErrore();
            gestione.setComportamento(CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG);
            GestioneErroreCodiceTrasporto codiceTrasporto = new GestioneErroreCodiceTrasporto();
            codiceTrasporto.setComportamento(CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG);
            codiceTrasporto.setValoreMinimo(Integer.valueOf(200));
            codiceTrasporto.setValoreMassimo(Integer.valueOf(299));
            boolean isSuccessfulHttpRedirectStatusCode = false;
            try {
                isSuccessfulHttpRedirectStatusCode = protocolFactory.createProtocolManager().isSuccessfulHttpRedirectStatusCode(serviceBinding);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            if (isSuccessfulHttpRedirectStatusCode) {
                codiceTrasporto.setValoreMassimo(Integer.valueOf(399));
            }
            gestione.addCodiceTrasporto(codiceTrasporto);
            GestioneErroreSoapFault faultAccetta = new GestioneErroreSoapFault();
            faultAccetta.setComportamento(CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG);
            gestione.addSoapFault(faultAccetta);
            gestioneErroreDefaultComponenteIntegrazioneMap.put(key, gestione);
            GestioneErrore gestioneErrore = gestione;
            return gestioneErrore;
        }
        finally {
            semaphore.release(lock, "getGestioneErroreDefaultComponenteIntegrazione");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GestioneErrore getGestioneErroreDefaultComponenteCooperazione(IProtocolFactory<?> protocolFactory, ServiceBinding serviceBinding) {
        String key = protocolFactory.getProtocol() + "_" + serviceBinding;
        if (gestioneErroreDefaultComponenteCooperazioneMap.containsKey(key)) {
            return gestioneErroreDefaultComponenteCooperazioneMap.get(key);
        }
        SemaphoreLock lock = semaphore.acquireThrowRuntime("getGestioneErroreDefaultComponenteCooperazione");
        try {
            if (gestioneErroreDefaultComponenteCooperazioneMap.containsKey(key)) {
                GestioneErrore gestioneErrore = gestioneErroreDefaultComponenteCooperazioneMap.get(key);
                return gestioneErrore;
            }
            GestioneErrore gestione = new GestioneErrore();
            gestione.setComportamento(CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG);
            GestioneErroreCodiceTrasporto codiceTrasporto = new GestioneErroreCodiceTrasporto();
            codiceTrasporto.setComportamento(CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG);
            codiceTrasporto.setValoreMinimo(Integer.valueOf(200));
            boolean isSuccessfulHttpRedirectStatusCode = false;
            try {
                isSuccessfulHttpRedirectStatusCode = protocolFactory.createProtocolManager().isSuccessfulHttpRedirectStatusCode(serviceBinding);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            if (isSuccessfulHttpRedirectStatusCode) {
                codiceTrasporto.setValoreMassimo(Integer.valueOf(399));
            } else {
                codiceTrasporto.setValoreMassimo(Integer.valueOf(299));
            }
            gestione.addCodiceTrasporto(codiceTrasporto);
            ITraduttore trasl = null;
            try {
                trasl = protocolFactory.createTraduttore();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            if (trasl != null) {
                GestioneErroreSoapFault faultClient = new GestioneErroreSoapFault();
                faultClient.setFaultCode("Client");
                faultClient.setFaultString(trasl.toString(MessaggiFaultErroreCooperazione.FAULT_STRING_VALIDAZIONE));
                faultClient.setComportamento(CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG);
                gestione.addSoapFault(faultClient);
                GestioneErroreSoapFault faultServer = new GestioneErroreSoapFault();
                faultServer.setFaultCode("Server");
                faultServer.setFaultString(trasl.toString(MessaggiFaultErroreCooperazione.FAULT_STRING_PROCESSAMENTO));
                faultServer.setComportamento(CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG);
                gestione.addSoapFault(faultServer);
            }
            gestioneErroreDefaultComponenteCooperazioneMap.put(key, gestione);
            GestioneErrore gestioneErrore = gestione;
            return gestioneErrore;
        }
        finally {
            semaphore.release(lock, "getGestioneErroreDefaultComponenteCooperazione");
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean verificaConsegna(GestioneErrore gestioneErrore, String msgErroreConnettore, Exception eccezioneErroreConnettore, IConnettore connectorSender) throws GestoreMessaggiException, UtilsException {
        if (eccezioneErroreConnettore != null) {
            // empty if block
        }
        codiceTrasporto = connectorSender.getCodiceTrasporto();
        messageResponse = connectorSender.getResponse();
        protocolloConnettore = connectorSender.getProtocollo();
        now = DateManager.getDate();
        this.dataRispedizione = new Timestamp(now.getTime());
        if (msgErroreConnettore != null) {
            this.errore = msgErroreConnettore;
            if (CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG.equals((Object)gestioneErrore.getComportamento())) {
                this.riconsegna = true;
                if (gestioneErrore.getCadenzaRispedizione() != null) {
                    try {
                        cadenzaRispedizione = Integer.parseInt(gestioneErrore.getCadenzaRispedizione());
                        this.dataRispedizione = new Timestamp(now.getTime() + (long)(cadenzaRispedizione * 60 * 1000));
                    }
                    catch (Exception e) {
                        GestoreErroreConnettore.log.error("Intervallo di rispedizione non impostato: " + e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                this.riconsegna = false;
            }
            return false;
        }
        bodyConFault = null;
        messageType = null;
        if (messageResponse instanceof OpenSPCoop2SoapMessage) {
            try {
                messageType = messageResponse.getMessageType();
                if (messageResponse.castAsSoap().hasSOAPFault()) {
                    bodyConFault = messageResponse.castAsSoap().getSOAPBody();
                }
            }
            catch (Exception e) {
                throw new GestoreMessaggiException(e.getMessage(), e);
            }
        }
        if (bodyConFault != null) {
            this.fault = bodyConFault.getFault();
            for (i = 0; i < gestioneErrore.sizeSoapFaultList(); ++i) {
                gestore = gestioneErrore.getSoapFault(i);
                match = true;
                if (gestore.getFaultCode() != null) {
                    codice = null;
                    namespaceCodice = null;
                    if (this.fault.getFaultCodeAsQName() != null) {
                        codice = this.fault.getFaultCodeAsQName().getLocalPart();
                        namespaceCodice = this.fault.getFaultCodeAsQName().getNamespaceURI();
                    } else {
                        codice = this.fault.getFaultCode();
                    }
                    if (namespaceCodice != null) {
                        // empty if block
                    }
                    subCodiceSoap12 = new ArrayList<String>();
                    subCodiceNamespaceSoap12 = new ArrayList<String>();
                    if (MessageType.SOAP_12.equals((Object)messageType) && this.fault.getFaultSubcodes() != null) {
                        it = this.fault.getFaultSubcodes();
                        while (it.hasNext()) {
                            qName = (QName)it.next();
                            if (qName.getLocalPart() == null) continue;
                            subCodiceSoap12.add(qName.getLocalPart());
                            subCodiceNamespaceSoap12.add(qName.getNamespaceURI() != null ? qName.getNamespaceURI() : "");
                        }
                    }
                    if (!gestore.getFaultCode().equalsIgnoreCase(codice)) {
                        matchRegExpr = false;
                        try {
                            matchRegExpr = RegularExpressionEngine.isMatch((String)codice, (String)gestore.getFaultCode());
                        }
                        catch (RegExpNotFoundException qName) {
                        }
                        catch (Exception e) {
                            GestoreErroreConnettore.log.error("Verifica espressione regolare '" + gestore.getFaultCode() + "' per fault code '" + codice + "' fallita: " + e.getMessage(), (Throwable)e);
                        }
                        if (!matchRegExpr) {
                            matchSoap12 = false;
                            if (!subCodiceSoap12.isEmpty()) {
                                for (String code12 : subCodiceSoap12) {
                                    if (gestore.getFaultCode().equalsIgnoreCase(code12)) {
                                        matchSoap12 = true;
                                        break;
                                    }
                                    matchRegExprSoap12 = false;
                                    try {
                                        matchRegExprSoap12 = RegularExpressionEngine.isMatch((String)code12, (String)gestore.getFaultCode());
                                    }
                                    catch (RegExpNotFoundException var24_96) {
                                    }
                                    catch (Exception e) {
                                        GestoreErroreConnettore.log.error("Verifica espressione regolare '" + gestore.getFaultCode() + "' per fault subcode 1.2 '" + code12 + "' fallita: " + e.getMessage(), (Throwable)e);
                                    }
                                    if (!matchRegExprSoap12) continue;
                                    matchSoap12 = true;
                                    break;
                                }
                            }
                            if (!matchSoap12) {
                                match = false;
                            }
                        }
                    }
                }
                if (gestore.getFaultActor() != null) {
                    actor = this.fault.getFaultActor();
                    if (!gestore.getFaultActor().equalsIgnoreCase(actor)) {
                        matchRegExpr = false;
                        try {
                            matchRegExpr = RegularExpressionEngine.isMatch((String)actor, (String)gestore.getFaultActor());
                        }
                        catch (RegExpNotFoundException subCodiceSoap12) {
                        }
                        catch (Exception e) {
                            GestoreErroreConnettore.log.error("Verifica espressione regolare '" + gestore.getFaultActor() + "' per fault actor '" + actor + "' fallita: " + e.getMessage(), (Throwable)e);
                        }
                        if (!matchRegExpr) {
                            match = false;
                        }
                    }
                }
                if (!(gestore.getFaultString() == null || (faultString = this.fault.getFaultString()) != null && (faultString.contains(gestore.getFaultString()) || faultString.contains(gestore.getFaultString().toLowerCase()) || faultString.contains(gestore.getFaultString().toUpperCase())))) {
                    matchRegExpr = false;
                    try {
                        matchRegExpr = RegularExpressionEngine.isMatch((String)faultString, (String)gestore.getFaultString());
                    }
                    catch (RegExpNotFoundException e) {
                    }
                    catch (Exception e) {
                        GestoreErroreConnettore.log.error("Verifica espressione regolare '" + gestore.getFaultString() + "' per fault string '" + faultString + "' fallita: " + e.getMessage(), (Throwable)e);
                    }
                    if (!matchRegExpr) {
                        match = false;
                    }
                }
                if (!match) continue;
                if (CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG.equals((Object)gestore.getComportamento())) {
                    try {
                        this.errore = "errore applicativo, " + SoapUtils.safe_toString((OpenSPCoop2MessageFactory)messageResponse.getFactory(), (SOAPFault)this.fault, (Logger)GestoreErroreConnettore.log);
                    }
                    catch (Exception e) {
                        this.errore = "errore applicativo SoapFault";
                        GestoreErroreConnettore.log.error("Serializzazione SOAPFault non riuscita: " + e.getMessage(), (Throwable)e);
                    }
                    this.riconsegna = true;
                    if (gestore.getCadenzaRispedizione() != null) {
                        try {
                            cadenzaRispedizione = Integer.parseInt(gestore.getCadenzaRispedizione());
                            this.dataRispedizione = new Timestamp(now.getTime() + (long)(cadenzaRispedizione * 60 * 1000));
                        }
                        catch (Exception e) {
                            GestoreErroreConnettore.log.error("Intervallo di rispedizione non impostato (soap fault): " + e.getMessage(), (Throwable)e);
                        }
                    } else if (gestioneErrore.getCadenzaRispedizione() != null) {
                        try {
                            cadenzaRispedizione = Integer.parseInt(gestioneErrore.getCadenzaRispedizione());
                            this.dataRispedizione = new Timestamp(now.getTime() + (long)(cadenzaRispedizione * 60 * 1000));
                        }
                        catch (Exception e) {
                            GestoreErroreConnettore.log.error("Intervallo di rispedizione non impostato: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    return false;
                }
                this.riconsegna = false;
                return true;
            }
        }
        problemReceived = null;
        if (messageResponse != null) {
            if (messageResponse instanceof OpenSPCoop2RestJsonMessage) {
                try {
                    msg = messageResponse.castAsRestJson();
                    if (!msg.hasContent() || !msg.isProblemDetailsForHttpApis_RFC7807()) ** GOTO lbl157
                    problemReceived = this.parseJsonProblemRFC7807(msg);
                }
                catch (Exception e) {
                    throw new GestoreMessaggiException(e.getMessage(), e);
                }
            } else if (messageResponse instanceof OpenSPCoop2RestXmlMessage) {
                try {
                    msg = messageResponse.castAsRestXml();
                    if (msg.hasContent() && msg.isProblemDetailsForHttpApis_RFC7807()) {
                        problemReceived = this.parseXmlProblemRFC7807((OpenSPCoop2RestXmlMessage)msg);
                    }
                }
                catch (Exception e) {
                    throw new GestoreMessaggiException(e.getMessage(), e);
                }
            }
        }
lbl157:
        // 7 sources

        if (problemReceived != null) {
            this.problem = problemReceived;
            for (i = 0; i < gestioneErrore.sizeSoapFaultList(); ++i) {
                gestore = gestioneErrore.getSoapFault(i);
                match = true;
                if (gestore.getFaultCode() != null) {
                    codice = "" + problemReceived.getStatus();
                    if (!gestore.getFaultCode().equalsIgnoreCase(codice)) {
                        matchRegExpr = false;
                        try {
                            matchRegExpr = RegularExpressionEngine.isMatch((String)codice, (String)gestore.getFaultCode());
                        }
                        catch (RegExpNotFoundException subCodiceNamespaceSoap12) {
                        }
                        catch (Exception e) {
                            GestoreErroreConnettore.log.error("Verifica espressione regolare '" + gestore.getFaultCode() + "' per problem status '" + codice + "' fallita: " + e.getMessage(), (Throwable)e);
                        }
                        if (!matchRegExpr) {
                            match = false;
                        }
                    }
                }
                if (gestore.getFaultActor() != null) {
                    actor = problemReceived.getType();
                    if (!gestore.getFaultActor().equalsIgnoreCase(actor)) {
                        matchRegExpr = false;
                        try {
                            matchRegExpr = RegularExpressionEngine.isMatch((String)actor, (String)gestore.getFaultActor());
                        }
                        catch (RegExpNotFoundException e) {
                        }
                        catch (Exception e) {
                            GestoreErroreConnettore.log.error("Verifica espressione regolare '" + gestore.getFaultActor() + "' per problem type '" + actor + "' fallita: " + e.getMessage(), (Throwable)e);
                        }
                        if (!matchRegExpr) {
                            match = false;
                        }
                    }
                }
                if (gestore.getFaultString() != null && (properties = PropertiesUtilities.convertTextToProperties((String)gestore.getFaultString())) != null && properties.size() > 0) {
                    en = properties.keys();
                    while (en.hasMoreElements()) {
                        key = (String)en.nextElement();
                        value = properties.getProperty(key);
                        if ("type".equals(key)) {
                            if (problemReceived.getType() == null || "".equals(problemReceived.getType())) {
                                match = false;
                                break;
                            }
                            if (problemReceived.getType().equalsIgnoreCase(value)) continue;
                            matchRegExpr = false;
                            try {
                                matchRegExpr = RegularExpressionEngine.isMatch((String)problemReceived.getType(), (String)value);
                            }
                            catch (RegExpNotFoundException var21_79) {
                            }
                            catch (Exception e) {
                                GestoreErroreConnettore.log.error("Verifica espressione regolare '" + value + "' per problem type '" + problemReceived.getType() + "' fallita: " + e.getMessage(), (Throwable)e);
                            }
                            if (matchRegExpr) continue;
                            match = false;
                            break;
                        }
                        if ("title".equals(key)) {
                            if (problemReceived.getTitle() == null || "".equals(problemReceived.getTitle())) {
                                match = false;
                                break;
                            }
                            if (problemReceived.getTitle().equalsIgnoreCase(value)) continue;
                            matchRegExpr = false;
                            try {
                                matchRegExpr = RegularExpressionEngine.isMatch((String)problemReceived.getTitle(), (String)value);
                            }
                            catch (RegExpNotFoundException e) {
                            }
                            catch (Exception e) {
                                GestoreErroreConnettore.log.error("Verifica espressione regolare '" + value + "' per problem title '" + problemReceived.getTitle() + "' fallita: " + e.getMessage(), (Throwable)e);
                            }
                            if (matchRegExpr) continue;
                            match = false;
                            break;
                        }
                        if ("status".equals(key)) {
                            if (problemReceived.getStatus() == null) {
                                match = false;
                                break;
                            }
                            if (problemReceived.getStatus().toString().equalsIgnoreCase(value)) continue;
                            matchRegExpr = false;
                            try {
                                matchRegExpr = RegularExpressionEngine.isMatch((String)problemReceived.getStatus().toString(), (String)value);
                            }
                            catch (RegExpNotFoundException e) {
                            }
                            catch (Exception e) {
                                GestoreErroreConnettore.log.error("Verifica espressione regolare '" + value + "' per problem status '" + problemReceived.getStatus().toString() + "' fallita: " + e.getMessage(), (Throwable)e);
                            }
                            if (matchRegExpr) continue;
                            match = false;
                            break;
                        }
                        if ("detail".equals(key)) {
                            if (problemReceived.getDetail() == null || "".equals(problemReceived.getDetail())) {
                                match = false;
                                break;
                            }
                            if (problemReceived.getDetail().equalsIgnoreCase(value)) continue;
                            matchRegExpr = false;
                            try {
                                matchRegExpr = RegularExpressionEngine.isMatch((String)problemReceived.getDetail(), (String)value);
                            }
                            catch (RegExpNotFoundException e) {
                            }
                            catch (Exception e) {
                                GestoreErroreConnettore.log.error("Verifica espressione regolare '" + value + "' per problem detail '" + problemReceived.getDetail() + "' fallita: " + e.getMessage(), (Throwable)e);
                            }
                            if (matchRegExpr) continue;
                            match = false;
                            break;
                        }
                        if ("instance".equals(key)) {
                            if (problemReceived.getInstance() == null || "".equals(problemReceived.getInstance())) {
                                match = false;
                                break;
                            }
                            if (problemReceived.getInstance().equalsIgnoreCase(value)) continue;
                            matchRegExpr = false;
                            try {
                                matchRegExpr = RegularExpressionEngine.isMatch((String)problemReceived.getInstance(), (String)value);
                            }
                            catch (RegExpNotFoundException e) {
                            }
                            catch (Exception e) {
                                GestoreErroreConnettore.log.error("Verifica espressione regolare '" + value + "' per problem instance '" + problemReceived.getInstance() + "' fallita: " + e.getMessage(), (Throwable)e);
                            }
                            if (matchRegExpr) continue;
                            match = false;
                            break;
                        }
                        if (problemReceived.getCustom() == null || problemReceived.getCustom().isEmpty() || !problemReceived.getCustom().containsKey(key)) {
                            match = false;
                            break;
                        }
                        valoreClaim = problemReceived.getCustom().get(key);
                        if (valoreClaim == null) {
                            match = false;
                            break;
                        }
                        v = valoreClaim.toString();
                        if (v.equalsIgnoreCase(value)) continue;
                        matchRegExpr = false;
                        try {
                            matchRegExpr = RegularExpressionEngine.isMatch((String)v, (String)value);
                        }
                        catch (RegExpNotFoundException matchRegExprSoap12) {
                        }
                        catch (Exception e) {
                            GestoreErroreConnettore.log.error("Verifica espressione regolare '" + value + "' per problem '" + key + "' '" + v + "' fallita: " + e.getMessage(), (Throwable)e);
                        }
                        if (matchRegExpr) continue;
                        match = false;
                        break;
                    }
                }
                if (!match) continue;
                if (CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG.equals((Object)gestore.getComportamento())) {
                    try {
                        this.errore = "errore applicativo, " + problemReceived.getRaw();
                    }
                    catch (Exception e) {
                        this.errore = "errore applicativo (Problem Detail RFC 7807)";
                        GestoreErroreConnettore.log.error("Serializzazione Problem Detail RFC 7807 non riuscita: " + e.getMessage(), (Throwable)e);
                    }
                    this.riconsegna = true;
                    if (gestore.getCadenzaRispedizione() != null) {
                        try {
                            cadenzaRispedizione = Integer.parseInt(gestore.getCadenzaRispedizione());
                            this.dataRispedizione = new Timestamp(now.getTime() + (long)(cadenzaRispedizione * 60 * 1000));
                        }
                        catch (Exception e) {
                            GestoreErroreConnettore.log.error("Intervallo di rispedizione non impostato (problem detail): " + e.getMessage(), (Throwable)e);
                        }
                    } else if (gestioneErrore.getCadenzaRispedizione() != null) {
                        try {
                            cadenzaRispedizione = Integer.parseInt(gestioneErrore.getCadenzaRispedizione());
                            this.dataRispedizione = new Timestamp(now.getTime() + (long)(cadenzaRispedizione * 60 * 1000));
                        }
                        catch (Exception e) {
                            GestoreErroreConnettore.log.error("Intervallo di rispedizione non impostato: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    return false;
                }
                this.riconsegna = false;
                return true;
            }
        }
        for (i = 0; i < gestioneErrore.sizeCodiceTrasportoList(); ++i) {
            gestore = gestioneErrore.getCodiceTrasporto(i);
            valoreMinimo = -9223372036854775808L;
            valoreMassimo = 0x7FFFFFFFFFFFFFFFL;
            if (gestore.getValoreMinimo() != null) {
                valoreMinimo = gestore.getValoreMinimo().longValue();
            }
            if (gestore.getValoreMassimo() != null) {
                valoreMassimo = gestore.getValoreMassimo().longValue();
            }
            if (codiceTrasporto < valoreMinimo || codiceTrasporto > valoreMassimo) continue;
            if (CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG.equals((Object)gestore.getComportamento())) {
                this.errore = "errore " + GestoreErroreConnettore.formatProtocolloConnettore(protocolloConnettore) + codiceTrasporto;
                if (this.fault != null) {
                    try {
                        this.errore = this.errore + " (" + SoapUtils.safe_toString((OpenSPCoop2MessageFactory)messageResponse.getFactory(), (SOAPFault)this.fault, (Logger)GestoreErroreConnettore.log) + ")";
                    }
                    catch (Exception e) {
                        this.errore = "errore applicativo SoapFault";
                        GestoreErroreConnettore.log.error("Serializzazione SOAPFault non riuscita: " + e.getMessage(), (Throwable)e);
                    }
                }
                this.riconsegna = true;
                if (gestore.getCadenzaRispedizione() != null) {
                    try {
                        cadenzaRispedizione = Integer.parseInt(gestore.getCadenzaRispedizione());
                        this.dataRispedizione = new Timestamp(now.getTime() + (long)(cadenzaRispedizione * 60 * 1000));
                    }
                    catch (Exception e) {
                        GestoreErroreConnettore.log.error("Intervallo di rispedizione non impostato (codice di trasporto): " + e.getMessage(), (Throwable)e);
                    }
                } else if (gestioneErrore.getCadenzaRispedizione() != null) {
                    try {
                        cadenzaRispedizione = Integer.parseInt(gestioneErrore.getCadenzaRispedizione());
                        this.dataRispedizione = new Timestamp(now.getTime() + (long)(cadenzaRispedizione * 60 * 1000));
                    }
                    catch (Exception e) {
                        GestoreErroreConnettore.log.error("Intervallo di rispedizione non impostato: " + e.getMessage(), (Throwable)e);
                    }
                }
                return false;
            }
            this.riconsegna = false;
            return true;
        }
        if (CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG.equals((Object)gestioneErrore.getComportamento())) {
            this.errore = "errore " + GestoreErroreConnettore.formatProtocolloConnettore(protocolloConnettore) + codiceTrasporto;
            if (this.fault != null) {
                try {
                    this.errore = this.errore + " (" + SoapUtils.safe_toString((OpenSPCoop2MessageFactory)messageResponse.getFactory(), (SOAPFault)this.fault, (Logger)GestoreErroreConnettore.log) + ")";
                }
                catch (Exception e) {
                    this.errore = "errore applicativo SoapFault";
                    GestoreErroreConnettore.log.error("Serializzazione SOAPFault non riuscita: " + e.getMessage(), (Throwable)e);
                }
            }
            this.riconsegna = true;
            if (gestioneErrore.getCadenzaRispedizione() != null) {
                try {
                    cadenzaRispedizione = Integer.parseInt(gestioneErrore.getCadenzaRispedizione());
                    this.dataRispedizione = new Timestamp(now.getTime() + (long)(cadenzaRispedizione * 60 * 1000));
                }
                catch (Exception e) {
                    GestoreErroreConnettore.log.error("Intervallo di rispedizione non impostato: " + e.getMessage(), (Throwable)e);
                }
            }
            return false;
        }
        this.riconsegna = false;
        return true;
    }

    private ProblemRFC7807 parseJsonProblemRFC7807(OpenSPCoop2RestJsonMessage msg) throws MessageException, MessageNotSupportedException {
        try {
            JsonDeserializer deserializer = new JsonDeserializer();
            return deserializer.fromString((String)msg.getContent(), false);
        }
        catch (Exception e) {
            log.error("Parsing problem details (RFC7807) JSON:[" + (String)msg.getContent() + "] fallita: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private ProblemRFC7807 parseXmlProblemRFC7807(OpenSPCoop2RestXmlMessage msg) throws MessageException, MessageNotSupportedException {
        XmlDeserializer deserializer = new XmlDeserializer();
        try {
            return deserializer.fromNode((Node)msg.getContent(), false);
        }
        catch (Exception e) {
            log.error("Parsing problem details (RFC7807) XML[" + msg.getContent() + "] fallita: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getErrore() {
        return this.errore;
    }

    public boolean isRiconsegna() {
        return this.riconsegna;
    }

    public Timestamp getDataRispedizione() {
        return this.dataRispedizione;
    }

    public SOAPFault getFault() {
        return this.fault;
    }

    public ProblemRFC7807 getProblem() {
        return this.problem;
    }

    public static String formatProtocolloConnettore(String protocollo) {
        if (protocollo == null || StringUtils.isEmpty((String)protocollo)) {
            return "";
        }
        return protocollo + " ";
    }
}

