/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico;

import java.util.List;
import org.openspcoop2.pdd.core.controllo_traffico.LimitExceededNotifier;
import org.openspcoop2.pdd.core.controllo_traffico.SogliaDimensioneMessaggio;
import org.openspcoop2.utils.ILimitExceededNotifier;
import org.openspcoop2.utils.LimitExceededIOException;
import org.openspcoop2.utils.LimitedInputStreamEngine;
import org.openspcoop2.utils.Map;
import org.slf4j.Logger;

public class DimensioneMessaggiUtils {
    public static final boolean REQUEST = true;
    public static final boolean RESPONSE = false;
    private static final String PREFIX_RILEVATO_HEADER_CONTENT_LENGTH = "Rilevato header Content-Length ";

    private DimensioneMessaggiUtils() {
    }

    public static void verifyByContentLength(Logger log, List<String> l, SogliaDimensioneMessaggio requestLimitSize, LimitExceededNotifier notifier, Map<Object> ctx, boolean request) throws LimitExceededIOException {
        if (l != null && !l.isEmpty()) {
            long limitBytes;
            long size = DimensioneMessaggiUtils.readContentLength(log, l, requestLimitSize);
            if (l.size() > 1) {
                String msgWarn = "Rilevato header Content-Length  multiplo " + l + "; viene usato il valore pi\u00f9 grande '" + size + "'";
                log.warn(msgWarn);
            }
            if (size > (limitBytes = requestLimitSize.getSogliaKb() * 1024L)) {
                LimitedInputStreamEngine.contentLenghtLimitExceeded((String)(request ? "Request " : "Response "), ctx, (ILimitExceededNotifier)notifier, (long)limitBytes);
            }
        }
    }

    private static long readContentLength(Logger log, List<String> l, SogliaDimensioneMessaggio requestLimitSize) {
        long size = -1L;
        Object error = null;
        Exception exp = null;
        for (String hdr : l) {
            long lX = -1L;
            try {
                lX = Long.parseLong(hdr);
                if (lX < 0L) {
                    error = "Rilevato header Content-Length con un valore negativo '" + hdr + "'";
                    lX = Long.MAX_VALUE;
                } else if (lX == 0L && !requestLimitSize.isUseContentLengthHeaderAcceptZeroValue()) {
                    error = "Rilevato header Content-Length con valore 0";
                    lX = Long.MAX_VALUE;
                }
            }
            catch (Exception e) {
                error = "Rilevato header Content-Length con valore malformato '" + hdr + "': " + e.getMessage();
                exp = e;
                lX = Long.MAX_VALUE;
            }
            if (lX > size) {
                size = lX;
            }
            if (error == null) continue;
            break;
        }
        return DimensioneMessaggiUtils.parseReadResultContentLength(log, size, error, exp);
    }

    private static long parseReadResultContentLength(Logger log, long size, String error, Exception exp) {
        if (size < 0L) {
            error = "Calcolo dimensione content lenght fallita? Rilevata dimensione minore di zero";
            size = Long.MAX_VALUE;
        }
        if (error != null) {
            if (exp != null) {
                log.error(error, (Throwable)exp);
            } else {
                log.error(error);
            }
        }
        return size;
    }
}

