/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico;

import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.controllo_traffico.constants.TipoErrore;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.controllo_traffico.CategoriaEventoControlloTraffico;
import org.openspcoop2.pdd.core.controllo_traffico.CostantiControlloTraffico;
import org.openspcoop2.pdd.core.controllo_traffico.GeneratoreMessaggiErrore;
import org.openspcoop2.pdd.core.controllo_traffico.NotificatoreEventi;
import org.openspcoop2.pdd.core.controllo_traffico.StatoTraffico;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.slf4j.Logger;

public class GestoreControlloTraffico {
    private static GestoreControlloTraffico staticInstance = null;
    private AtomicLong activeThreads = new AtomicLong(0L);
    private boolean erroreGenerico;
    private Long maxThreads = null;
    private Integer threshold = null;

    public static synchronized void initialize(boolean erroreGenerico) {
        if (staticInstance == null) {
            staticInstance = new GestoreControlloTraffico(erroreGenerico);
        }
    }

    public static GestoreControlloTraffico getInstance() throws CoreException {
        if (staticInstance == null) {
            Class<GestoreControlloTraffico> clazz = GestoreControlloTraffico.class;
            synchronized (GestoreControlloTraffico.class) {
                throw new CoreException("GestorePolicyAttive non inizializzato");
            }
        }
        return staticInstance;
    }

    private GestoreControlloTraffico(boolean erroreGenerico) {
        this.erroreGenerico = erroreGenerico;
    }

    public StatoTraffico getStatoControlloTraffico() {
        long currentActiveThreads = this.activeThreads.get();
        StatoTraffico stato = new StatoTraffico();
        stato.setActiveThreads(currentActiveThreads);
        stato.setPddCongestionata(this.isPddCongestionata(currentActiveThreads));
        return stato;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThread(ServiceBinding serviceBinding, Long maxThreadsObj, Integer thresholdObj, Boolean warningOnly, PdDContext pddContext, MsgDiagnostico msgDiag, TipoErrore tipoErrore, boolean includiDescrizioneErrore, Logger log) throws ProtocolException, HandlerException, CoreException, UtilsException, DriverConfigurazioneException {
        Date dataEventoPddCongestionata;
        String descriptionEventoPddCongestionata;
        boolean emettiEventoPddCongestionata;
        boolean emettiDiagnosticoMaxThreadRaggiunto;
        block27: {
            CategoriaEventoControlloTraffico evento;
            emettiDiagnosticoMaxThreadRaggiunto = false;
            boolean emettiEventoMaxThreadsViolated = false;
            String descriptionEventoMaxThreadsViolated = null;
            Date dataEventoMaxThreadsViolated = null;
            emettiEventoPddCongestionata = false;
            descriptionEventoPddCongestionata = null;
            dataEventoPddCongestionata = null;
            try {
                long maxThreadsPrimitive = maxThreadsObj;
                int thresholdPrimitive = thresholdObj != null ? thresholdObj : 0;
                long activeThreadsSyncBeforeIncrement = -1L;
                boolean errorSync = false;
                boolean pddCongestionataSync = false;
                long currentActiveThreads = this.activeThreads.incrementAndGet();
                if (pddContext != null) {
                    pddContext.addObject(CostantiControlloTraffico.PDD_CONTEXT_MAX_REQUEST_THREAD_INCREMENT_ESEGUITO, true);
                }
                if (currentActiveThreads > maxThreadsPrimitive) {
                    errorSync = true;
                    if (!warningOnly.booleanValue()) {
                        this.activeThreads.decrementAndGet();
                        if (pddContext != null) {
                            pddContext.addObject(CostantiControlloTraffico.PDD_CONTEXT_MAX_REQUEST_THREAD_INCREMENT_ESEGUITO, false);
                        }
                    }
                }
                if ((!errorSync || warningOnly.booleanValue()) && thresholdObj != null) {
                    boolean prePddCongestionata = this.isPddCongestionata(maxThreadsPrimitive, thresholdPrimitive, currentActiveThreads - 1L);
                    boolean curPddCongestionata = this.isPddCongestionata(maxThreadsPrimitive, thresholdPrimitive, currentActiveThreads);
                    if (!prePddCongestionata && curPddCongestionata) {
                        emettiEventoPddCongestionata = true;
                        dataEventoPddCongestionata = DateManager.getDate();
                    }
                }
                HandlerException he = null;
                if (errorSync) {
                    emettiDiagnosticoMaxThreadRaggiunto = true;
                    msgDiag.addKeyword("@CT_ACTIVE_THREADS@", "" + activeThreadsSyncBeforeIncrement);
                    if (pddContext != null) {
                        pddContext.addObject(GeneratoreMessaggiErrore.PDD_CONTEXT_ACTIVE_THREADS, activeThreadsSyncBeforeIncrement);
                    }
                    msgDiag.addKeyword("@CT_MAX_THREADS_THRESHOLD@", "" + maxThreadsPrimitive);
                    emettiEventoMaxThreadsViolated = true;
                    descriptionEventoMaxThreadsViolated = "Superato il numero di richieste complessive (" + maxThreadsPrimitive + ") gestibili dalla PdD";
                    dataEventoMaxThreadsViolated = DateManager.getDate();
                    if (pddContext != null) {
                        GeneratoreMessaggiErrore.addPddContextInfoControlloTrafficoMaxThreadsViolated(pddContext, warningOnly);
                    }
                    String msgDiagnostico = null;
                    if (warningOnly.booleanValue()) {
                        msgDiag.getMessaggio_replaceKeywords("controlloTraffico.maxRequestsViolatedWarningOnly");
                    } else {
                        msgDiag.getMessaggio_replaceKeywords("controlloTraffico.maxRequestsViolated");
                    }
                    he = GeneratoreMessaggiErrore.getMaxThreadsViolated(msgDiagnostico, this.erroreGenerico, pddContext);
                    he.setEmettiDiagnostico(false);
                    GeneratoreMessaggiErrore.configureHandlerExceptionByTipoErrore(serviceBinding, he, tipoErrore, includiDescrizioneErrore, log);
                    if (!warningOnly.booleanValue()) {
                        throw he;
                    }
                }
                long activeThreadsSyncAfterIncrement = activeThreadsSyncBeforeIncrement + 1L;
                msgDiag.addKeyword("@CT_ACTIVE_THREADS@", "" + activeThreadsSyncAfterIncrement);
                if (thresholdObj != null) {
                    if (pddContext != null) {
                        pddContext.addObject(CostantiControlloTraffico.PDD_CONTEXT_PDD_CONGESTIONATA, pddCongestionataSync);
                    }
                    if (emettiEventoPddCongestionata) {
                        descriptionEventoPddCongestionata = this.buildDescription(maxThreadsPrimitive, thresholdPrimitive, msgDiag);
                    }
                }
                if (he != null) {
                    throw he;
                }
                if (!emettiEventoMaxThreadsViolated) break block27;
                evento = null;
                evento = warningOnly != false ? CategoriaEventoControlloTraffico.LIMITE_GLOBALE_RICHIESTE_SIMULTANEE_WARNING_ONLY : CategoriaEventoControlloTraffico.LIMITE_GLOBALE_RICHIESTE_SIMULTANEE;
            }
            catch (Throwable throwable) {
                if (emettiEventoMaxThreadsViolated) {
                    CategoriaEventoControlloTraffico evento2 = null;
                    evento2 = warningOnly != false ? CategoriaEventoControlloTraffico.LIMITE_GLOBALE_RICHIESTE_SIMULTANEE_WARNING_ONLY : CategoriaEventoControlloTraffico.LIMITE_GLOBALE_RICHIESTE_SIMULTANEE;
                    NotificatoreEventi.getInstance().log(evento2, dataEventoMaxThreadsViolated, descriptionEventoMaxThreadsViolated);
                }
                if (emettiDiagnosticoMaxThreadRaggiunto) {
                    if (warningOnly.booleanValue()) {
                        msgDiag.logPersonalizzato("controlloTraffico.maxRequestsViolatedWarningOnly");
                    } else {
                        msgDiag.logPersonalizzato("controlloTraffico.maxRequestsViolated");
                    }
                }
                if (emettiEventoPddCongestionata) {
                    NotificatoreEventi.getInstance().log(CategoriaEventoControlloTraffico.CONGESTIONE_PORTA_DOMINIO, dataEventoPddCongestionata, descriptionEventoPddCongestionata);
                }
                throw throwable;
            }
            NotificatoreEventi.getInstance().log(evento, dataEventoMaxThreadsViolated, descriptionEventoMaxThreadsViolated);
        }
        if (emettiDiagnosticoMaxThreadRaggiunto) {
            if (warningOnly.booleanValue()) {
                msgDiag.logPersonalizzato("controlloTraffico.maxRequestsViolatedWarningOnly");
            } else {
                msgDiag.logPersonalizzato("controlloTraffico.maxRequestsViolated");
            }
        }
        if (emettiEventoPddCongestionata) {
            NotificatoreEventi.getInstance().log(CategoriaEventoControlloTraffico.CONGESTIONE_PORTA_DOMINIO, dataEventoPddCongestionata, descriptionEventoPddCongestionata);
        }
    }

    public void removeThread(Context context) {
        Boolean incrementEseguito = null;
        if (context != null) {
            incrementEseguito = (Boolean)context.getObject(CostantiControlloTraffico.PDD_CONTEXT_MAX_REQUEST_THREAD_INCREMENT_ESEGUITO);
        }
        if (incrementEseguito != null && incrementEseguito.booleanValue()) {
            this.activeThreads.decrementAndGet();
            context.addObject(CostantiControlloTraffico.PDD_CONTEXT_MAX_REQUEST_THREAD_INCREMENT_ESEGUITO, (Object)false);
        }
    }

    public long sizeActiveThreads() {
        return this.activeThreads.get();
    }

    public Boolean isPortaDominioCongestionata(Long maxThreadsObj, Integer thresholdObj) {
        return this.isPddCongestionata(maxThreadsObj, thresholdObj, this.activeThreads.get());
    }

    private boolean isPddCongestionata(long activeThreads) {
        return this.isPddCongestionata(this.maxThreads, this.threshold, activeThreads);
    }

    private boolean isPddCongestionata(Long maxThreads, Integer threshold, long activeThreads) {
        double dThreshold;
        this.maxThreads = maxThreads;
        this.threshold = threshold;
        if (threshold == null || maxThreads == null) {
            return false;
        }
        double dActiveT = maxThreads.longValue();
        double t = dActiveT / 100.0;
        double tt = t * (dThreshold = (double)threshold.intValue());
        int numeroThreadSoglia = (int)tt;
        return activeThreads > (long)numeroThreadSoglia;
    }

    private String buildDescription(long maxThreads, int threshold, MsgDiagnostico msgDiag) {
        StringBuilder bf = new StringBuilder();
        msgDiag.addKeyword("@CT_MAX_THREADS_THRESHOLD@", "" + maxThreads);
        msgDiag.addKeyword("@CT_THRESHOLD@", "" + threshold);
        bf.append(msgDiag.getMessaggio_replaceKeywords("all.", "controlloTraffico.pddCongestionata"));
        return bf.toString();
    }
}

