/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.activation.FileDataSource;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.controllo_traffico.utils.PolicyUtilities;
import org.openspcoop2.core.eventi.Evento;
import org.openspcoop2.core.eventi.constants.CodiceEventoControlloTraffico;
import org.openspcoop2.core.eventi.constants.TipoEvento;
import org.openspcoop2.core.eventi.constants.TipoSeverita;
import org.openspcoop2.core.eventi.utils.SeveritaConverter;
import org.openspcoop2.core.eventi.utils.serializer.JaxbDeserializer;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.controllo_traffico.CategoriaEventoControlloTraffico;
import org.openspcoop2.pdd.core.controllo_traffico.ConfigurazioneGatewayControlloTraffico;
import org.openspcoop2.pdd.core.controllo_traffico.DatabaseDatiEventoGenerico;
import org.openspcoop2.pdd.core.controllo_traffico.DatiEventoGenerico;
import org.openspcoop2.pdd.core.controllo_traffico.INotify;
import org.openspcoop2.pdd.core.eventi.GestoreEventi;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.io.ZipUtilities;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.slf4j.Logger;

public class NotificatoreEventi {
    private static NotificatoreEventi staticInstance = null;
    private GestoreEventi gestoreEventi;
    private static final Semaphore lock = new Semaphore("NotificatoreEventi");
    private DatiEventoGenerico inMemoryLastMaxRequests = new DatiEventoGenerico();
    private DatiEventoGenerico inMemoryLastMaxRequestsWarningOnly = new DatiEventoGenerico();
    private DatiEventoGenerico inMemoryLastPddCongestionata = new DatiEventoGenerico();
    private Map<String, DatiEventoGenerico> inMemoryLastPolicyGlobaliViolated = new HashMap<String, DatiEventoGenerico>();
    private Map<String, DatiEventoGenerico> inMemoryLastPolicyGlobaliViolatedWarningOnly = new HashMap<String, DatiEventoGenerico>();
    private Map<String, DatiEventoGenerico> inMemoryLastPolicyAPIViolated = new HashMap<String, DatiEventoGenerico>();
    private Map<String, DatiEventoGenerico> inMemoryLastPolicyAPIViolatedWarningOnly = new HashMap<String, DatiEventoGenerico>();
    private Map<String, DatiEventoGenerico> inMemoryLastTimeoutConnessione = new HashMap<String, DatiEventoGenerico>();
    private Map<String, DatiEventoGenerico> inMemoryLastTimeoutRichiesta = new HashMap<String, DatiEventoGenerico>();
    private Map<String, DatiEventoGenerico> inMemoryLastTimeoutRisposta = new HashMap<String, DatiEventoGenerico>();
    private DatabaseDatiEventoGenerico dbLastMaxRequests = new DatabaseDatiEventoGenerico();
    private DatabaseDatiEventoGenerico dbLastMaxRequestsWarningOnly = new DatabaseDatiEventoGenerico();
    private DatabaseDatiEventoGenerico dbLastPddCongestionata = new DatabaseDatiEventoGenerico();
    private Map<String, DatabaseDatiEventoGenerico> dbLastPolicyGlobaliViolated = new HashMap<String, DatabaseDatiEventoGenerico>();
    private Map<String, DatabaseDatiEventoGenerico> dbLastPolicyGlobaliViolatedWarningOnly = new HashMap<String, DatabaseDatiEventoGenerico>();
    private Map<String, DatabaseDatiEventoGenerico> dbLastPolicyAPIViolated = new HashMap<String, DatabaseDatiEventoGenerico>();
    private Map<String, DatabaseDatiEventoGenerico> dbLastPolicyAPIViolatedWarningOnly = new HashMap<String, DatabaseDatiEventoGenerico>();
    private Map<String, DatabaseDatiEventoGenerico> dbLastTimeoutConnessione = new HashMap<String, DatabaseDatiEventoGenerico>();
    private Map<String, DatabaseDatiEventoGenerico> dbLastTimeoutRichiesta = new HashMap<String, DatabaseDatiEventoGenerico>();
    private Map<String, DatabaseDatiEventoGenerico> dbLastTimeoutRisposta = new HashMap<String, DatabaseDatiEventoGenerico>();
    private static final String ID_POLICY_NON_FORNITA = "IdPolicy non fornita";
    private static final String SUFFIX_IN_CORSO_PARENTESI_QUADRE = "] ...";
    private static final String SUFFIX_IN_CORSO = ") ...";
    private static final String SUFFIX_WARNING_ONLY_IN_CORSO = ") (warning-only) ...";
    private static final String SUFFIX_TERMINATA = ") terminata";
    private static final String SUFFIX_WARNING_ONLY_TERMINATA = ") (warning-only) terminata";
    private static final String EVERY = " every:";
    private static final String SEPARATOR = "=================================================================================";
    private static final String ZIP_IN_MEMORY = "memory";
    private static final String ZIP_DB = "db";
    private static final String ZIP_LAST_MAX_REQUESTS = "lastMaxRequests.xml";
    private static final String ZIP_LAST_MAX_REQUESTS_WARNING_ONLY = "lastMaxRequests_warningOnly.xml";
    private static final String ZIP_LAST_PDD_CONGESTIONATA = "lastPddCongestionata.xml";
    private static final String ZIP_POLICY_GLOBALE = "policyGlobale";
    private static final String ZIP_POLICY_GLOBALE_WARNING_ONLY = "policyGlobale_warningOnly";
    private static final String ZIP_POLICY_API = "policyAPI";
    private static final String ZIP_POLICY_API_WARNING_ONLY = "policyAPI_warningOnly";
    private static final String ZIP_EVENTO_TIMEOUT_CONNESSIONE = "connectionTimeout";
    private static final String ZIP_EVENTO_TIMEOUT_RICHIESTA = "requestReadTimeout";
    private static final String ZIP_EVENTO_TIMEOUT_RISPOSTA = "readTimeout";

    private static synchronized void initialize() throws DriverConfigurazioneException {
        if (staticInstance == null) {
            staticInstance = new NotificatoreEventi();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NotificatoreEventi getInstance() throws DriverConfigurazioneException {
        if (staticInstance != null) return staticInstance;
        Class<NotificatoreEventi> clazz = NotificatoreEventi.class;
        synchronized (NotificatoreEventi.class) {
            NotificatoreEventi.initialize();
            // ** MonitorExit[var0] (shouldn't be in output)
            return staticInstance;
        }
    }

    private NotificatoreEventi() throws DriverConfigurazioneException {
        this.gestoreEventi = GestoreEventi.getInstance();
    }

    public void log(CategoriaEventoControlloTraffico evento, Date date, String descrizione) throws CoreException, UtilsException {
        this.log(evento, null, null, date, descrizione);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(CategoriaEventoControlloTraffico evento, String idPolicy, String configurazione, Date date, String descrizione) throws CoreException, UtilsException {
        if (evento == null) {
            throw new CoreException("Evento non definito");
        }
        switch (evento) {
            case LIMITE_GLOBALE_RICHIESTE_SIMULTANEE: {
                SemaphoreLock slock = lock.acquire("log_" + evento.name());
                try {
                    if (!this.inMemoryLastMaxRequests.datiConsumatiThread) break;
                    this.inMemoryLastMaxRequests.data = date == null ? DateManager.getDate() : date;
                    this.inMemoryLastMaxRequests.descrizione = descrizione;
                    this.inMemoryLastMaxRequests.configurazione = configurazione;
                    this.inMemoryLastMaxRequests.datiConsumatiThread = false;
                    break;
                }
                finally {
                    lock.release(slock, "log_" + evento.name());
                }
            }
            case LIMITE_GLOBALE_RICHIESTE_SIMULTANEE_WARNING_ONLY: {
                SemaphoreLock slock = lock.acquire("log_" + evento.name());
                try {
                    if (!this.inMemoryLastMaxRequestsWarningOnly.datiConsumatiThread) break;
                    this.inMemoryLastMaxRequestsWarningOnly.data = date == null ? DateManager.getDate() : date;
                    this.inMemoryLastMaxRequestsWarningOnly.descrizione = descrizione;
                    this.inMemoryLastMaxRequestsWarningOnly.configurazione = configurazione;
                    this.inMemoryLastMaxRequestsWarningOnly.datiConsumatiThread = false;
                    break;
                }
                finally {
                    lock.release(slock, "log_" + evento.name());
                }
            }
            case CONGESTIONE_PORTA_DOMINIO: {
                SemaphoreLock slock = lock.acquire("log_" + evento.name());
                try {
                    if (!this.inMemoryLastPddCongestionata.datiConsumatiThread) break;
                    this.inMemoryLastPddCongestionata.data = date == null ? DateManager.getDate() : date;
                    this.inMemoryLastPddCongestionata.descrizione = descrizione;
                    this.inMemoryLastPddCongestionata.configurazione = configurazione;
                    this.inMemoryLastPddCongestionata.datiConsumatiThread = false;
                    break;
                }
                finally {
                    lock.release(slock, "log_" + evento.name());
                }
            }
            case POLICY_GLOBALE: {
                if (idPolicy == null) {
                    throw new CoreException(ID_POLICY_NON_FORNITA);
                }
                SemaphoreLock slock = lock.acquire("log_" + evento.name());
                try {
                    if (!this.inMemoryLastPolicyGlobaliViolated.containsKey(idPolicy)) {
                        this.inMemoryLastPolicyGlobaliViolated.put(idPolicy, new DatiEventoGenerico());
                    }
                    if (!this.dbLastPolicyGlobaliViolated.containsKey(idPolicy)) {
                        this.dbLastPolicyGlobaliViolated.put(idPolicy, new DatabaseDatiEventoGenerico());
                    }
                    DatiEventoGenerico inMemoryLastPolicyGlobaleViolatedPolicy = this.inMemoryLastPolicyGlobaliViolated.get(idPolicy);
                    if (!inMemoryLastPolicyGlobaleViolatedPolicy.datiConsumatiThread) break;
                    inMemoryLastPolicyGlobaleViolatedPolicy.data = date == null ? DateManager.getDate() : date;
                    inMemoryLastPolicyGlobaleViolatedPolicy.descrizione = descrizione;
                    inMemoryLastPolicyGlobaleViolatedPolicy.configurazione = configurazione;
                    inMemoryLastPolicyGlobaleViolatedPolicy.datiConsumatiThread = false;
                    break;
                }
                finally {
                    lock.release(slock, "log_" + evento.name());
                }
            }
            case POLICY_GLOBALE_WARNING_ONLY: {
                if (idPolicy == null) {
                    throw new CoreException(ID_POLICY_NON_FORNITA);
                }
                SemaphoreLock slock = lock.acquire("log_" + evento.name());
                try {
                    if (!this.inMemoryLastPolicyGlobaliViolatedWarningOnly.containsKey(idPolicy)) {
                        this.inMemoryLastPolicyGlobaliViolatedWarningOnly.put(idPolicy, new DatiEventoGenerico());
                    }
                    if (!this.dbLastPolicyGlobaliViolatedWarningOnly.containsKey(idPolicy)) {
                        this.dbLastPolicyGlobaliViolatedWarningOnly.put(idPolicy, new DatabaseDatiEventoGenerico());
                    }
                    DatiEventoGenerico inMemoryLastPolicyGlobaleViolatedWarningOnlyPolicy = this.inMemoryLastPolicyGlobaliViolatedWarningOnly.get(idPolicy);
                    if (!inMemoryLastPolicyGlobaleViolatedWarningOnlyPolicy.datiConsumatiThread) break;
                    inMemoryLastPolicyGlobaleViolatedWarningOnlyPolicy.data = date == null ? DateManager.getDate() : date;
                    inMemoryLastPolicyGlobaleViolatedWarningOnlyPolicy.descrizione = descrizione;
                    inMemoryLastPolicyGlobaleViolatedWarningOnlyPolicy.configurazione = configurazione;
                    inMemoryLastPolicyGlobaleViolatedWarningOnlyPolicy.datiConsumatiThread = false;
                    break;
                }
                finally {
                    lock.release(slock, "log_" + evento.name());
                }
            }
            case POLICY_API: {
                if (idPolicy == null) {
                    throw new CoreException(ID_POLICY_NON_FORNITA);
                }
                SemaphoreLock slock = lock.acquire("log_" + evento.name());
                try {
                    if (!this.inMemoryLastPolicyAPIViolated.containsKey(idPolicy)) {
                        this.inMemoryLastPolicyAPIViolated.put(idPolicy, new DatiEventoGenerico());
                    }
                    if (!this.dbLastPolicyAPIViolated.containsKey(idPolicy)) {
                        this.dbLastPolicyAPIViolated.put(idPolicy, new DatabaseDatiEventoGenerico());
                    }
                    DatiEventoGenerico inMemoryLastPolicyAPIViolatedPolicy = this.inMemoryLastPolicyAPIViolated.get(idPolicy);
                    if (!inMemoryLastPolicyAPIViolatedPolicy.datiConsumatiThread) break;
                    inMemoryLastPolicyAPIViolatedPolicy.data = date == null ? DateManager.getDate() : date;
                    inMemoryLastPolicyAPIViolatedPolicy.descrizione = descrizione;
                    inMemoryLastPolicyAPIViolatedPolicy.configurazione = configurazione;
                    inMemoryLastPolicyAPIViolatedPolicy.datiConsumatiThread = false;
                    break;
                }
                finally {
                    lock.release(slock, "log_" + evento.name());
                }
            }
            case POLICY_API_WARNING_ONLY: {
                if (idPolicy == null) {
                    throw new CoreException(ID_POLICY_NON_FORNITA);
                }
                SemaphoreLock slock = lock.acquire("log_" + evento.name());
                try {
                    if (!this.inMemoryLastPolicyAPIViolatedWarningOnly.containsKey(idPolicy)) {
                        this.inMemoryLastPolicyAPIViolatedWarningOnly.put(idPolicy, new DatiEventoGenerico());
                    }
                    if (!this.dbLastPolicyAPIViolatedWarningOnly.containsKey(idPolicy)) {
                        this.dbLastPolicyAPIViolatedWarningOnly.put(idPolicy, new DatabaseDatiEventoGenerico());
                    }
                    DatiEventoGenerico inMemoryLastPolicyAPIViolatedWarningOnlyPolicy = this.inMemoryLastPolicyAPIViolatedWarningOnly.get(idPolicy);
                    if (!inMemoryLastPolicyAPIViolatedWarningOnlyPolicy.datiConsumatiThread) break;
                    inMemoryLastPolicyAPIViolatedWarningOnlyPolicy.data = date == null ? DateManager.getDate() : date;
                    inMemoryLastPolicyAPIViolatedWarningOnlyPolicy.descrizione = descrizione;
                    inMemoryLastPolicyAPIViolatedWarningOnlyPolicy.configurazione = configurazione;
                    inMemoryLastPolicyAPIViolatedWarningOnlyPolicy.datiConsumatiThread = false;
                    break;
                }
                finally {
                    lock.release(slock, "log_" + evento.name());
                }
            }
            case TIMEOUT_CONNESSIONE: {
                if (idPolicy == null) {
                    throw new CoreException(ID_POLICY_NON_FORNITA);
                }
                SemaphoreLock slock = lock.acquire("log_" + evento.name());
                try {
                    if (!this.inMemoryLastTimeoutConnessione.containsKey(idPolicy)) {
                        this.inMemoryLastTimeoutConnessione.put(idPolicy, new DatiEventoGenerico());
                    }
                    if (!this.dbLastTimeoutConnessione.containsKey(idPolicy)) {
                        this.dbLastTimeoutConnessione.put(idPolicy, new DatabaseDatiEventoGenerico());
                    }
                    DatiEventoGenerico inMemoryLastTimeoutConnessioneRead = this.inMemoryLastTimeoutConnessione.get(idPolicy);
                    if (!inMemoryLastTimeoutConnessioneRead.datiConsumatiThread) break;
                    inMemoryLastTimeoutConnessioneRead.data = date == null ? DateManager.getDate() : date;
                    inMemoryLastTimeoutConnessioneRead.descrizione = descrizione;
                    inMemoryLastTimeoutConnessioneRead.configurazione = configurazione;
                    inMemoryLastTimeoutConnessioneRead.datiConsumatiThread = false;
                    break;
                }
                finally {
                    lock.release(slock, "log_" + evento.name());
                }
            }
            case TIMEOUT_RICHIESTA: {
                if (idPolicy == null) {
                    throw new CoreException(ID_POLICY_NON_FORNITA);
                }
                SemaphoreLock slock = lock.acquire("log_" + evento.name());
                try {
                    if (!this.inMemoryLastTimeoutRichiesta.containsKey(idPolicy)) {
                        this.inMemoryLastTimeoutRichiesta.put(idPolicy, new DatiEventoGenerico());
                    }
                    if (!this.dbLastTimeoutRichiesta.containsKey(idPolicy)) {
                        this.dbLastTimeoutRichiesta.put(idPolicy, new DatabaseDatiEventoGenerico());
                    }
                    DatiEventoGenerico inMemoryLastTimeoutRichiestaRead = this.inMemoryLastTimeoutRichiesta.get(idPolicy);
                    if (!inMemoryLastTimeoutRichiestaRead.datiConsumatiThread) break;
                    inMemoryLastTimeoutRichiestaRead.data = date == null ? DateManager.getDate() : date;
                    inMemoryLastTimeoutRichiestaRead.descrizione = descrizione;
                    inMemoryLastTimeoutRichiestaRead.configurazione = configurazione;
                    inMemoryLastTimeoutRichiestaRead.datiConsumatiThread = false;
                    break;
                }
                finally {
                    lock.release(slock, "log_" + evento.name());
                }
            }
            case TIMEOUT_RISPOSTA: {
                if (idPolicy == null) {
                    throw new CoreException(ID_POLICY_NON_FORNITA);
                }
                SemaphoreLock slock = lock.acquire("log_" + evento.name());
                try {
                    if (!this.inMemoryLastTimeoutRisposta.containsKey(idPolicy)) {
                        this.inMemoryLastTimeoutRisposta.put(idPolicy, new DatiEventoGenerico());
                    }
                    if (!this.dbLastTimeoutRisposta.containsKey(idPolicy)) {
                        this.dbLastTimeoutRisposta.put(idPolicy, new DatabaseDatiEventoGenerico());
                    }
                    DatiEventoGenerico inMemoryLastTimeoutRispostaRead = this.inMemoryLastTimeoutRisposta.get(idPolicy);
                    if (!inMemoryLastTimeoutRispostaRead.datiConsumatiThread) break;
                    inMemoryLastTimeoutRispostaRead.data = date == null ? DateManager.getDate() : date;
                    inMemoryLastTimeoutRispostaRead.descrizione = descrizione;
                    inMemoryLastTimeoutRispostaRead.configurazione = configurazione;
                    inMemoryLastTimeoutRispostaRead.datiConsumatiThread = false;
                    break;
                }
                finally {
                    lock.release(slock, "log_" + evento.name());
                }
            }
            default: {
                throw new CoreException("Tipo di evento [" + evento.name() + "] non gestito con questo metodo");
            }
        }
    }

    private static void logInfo(Logger log, boolean debug, String msg) {
        if (debug) {
            log.info(msg);
        }
    }

    private static void logDebug(Logger log, boolean debug, String msg) {
        if (debug) {
            log.debug(msg);
        }
    }

    private static String getSuffixDate(SimpleDateFormat df, Date newInterval, int secondi) {
        return "[next-interval: " + df.format(newInterval) + "] [Prossimo Controllo previsto tra " + secondi + " secondi: " + df.format(new Date(DateManager.getTimeMillis() + (long)(secondi * 1000))) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date process(Logger log, int secondi, Date lastInterval, Connection connection, boolean debug) throws UtilsException {
        String idPolicy;
        SimpleDateFormat df = DateUtils.getSimpleDateFormatMs();
        NotificatoreEventi.logInfo(log, debug, SEPARATOR);
        NotificatoreEventi.logInfo(log, debug, "Analisi memoria per generazione eventi in corso [interval: " + df.format(lastInterval) + SUFFIX_IN_CORSO_PARENTESI_QUADRE);
        DatiEventoGenerico localInMemoryLastMaxRequests = null;
        DatiEventoGenerico localInMemoryLastMaxRequestsWarningOnly = null;
        DatiEventoGenerico localInMemoryLastPddCongestionata = null;
        HashMap<String, DatiEventoGenerico> localInMemoryLastPolicyGlobaliViolated = new HashMap<String, DatiEventoGenerico>();
        HashMap<String, DatiEventoGenerico> localInMemoryLastPolicyGlobaliViolatedWarningOnly = new HashMap<String, DatiEventoGenerico>();
        HashMap<String, DatiEventoGenerico> localInMemoryLastPolicyAPIViolated = new HashMap<String, DatiEventoGenerico>();
        HashMap<String, DatiEventoGenerico> localInMemoryLastPolicyAPIViolatedWarningOnly = new HashMap<String, DatiEventoGenerico>();
        Date newInterval = null;
        SemaphoreLock slock = lock.acquire("process");
        try {
            localInMemoryLastMaxRequests = this.inMemoryLastMaxRequests.readAndConsume();
            localInMemoryLastMaxRequestsWarningOnly = this.inMemoryLastMaxRequestsWarningOnly.readAndConsume();
            localInMemoryLastPddCongestionata = this.inMemoryLastPddCongestionata.readAndConsume();
            if (this.inMemoryLastPolicyGlobaliViolated != null && this.inMemoryLastPolicyGlobaliViolated.size() > 0) {
                for (Map.Entry<String, DatiEventoGenerico> entry : this.inMemoryLastPolicyGlobaliViolated.entrySet()) {
                    localInMemoryLastPolicyGlobaliViolated.put(entry.getKey(), entry.getValue().readAndConsume());
                }
            }
            if (this.inMemoryLastPolicyGlobaliViolatedWarningOnly != null && this.inMemoryLastPolicyGlobaliViolatedWarningOnly.size() > 0) {
                for (Map.Entry<String, DatiEventoGenerico> entry : this.inMemoryLastPolicyGlobaliViolatedWarningOnly.entrySet()) {
                    localInMemoryLastPolicyGlobaliViolatedWarningOnly.put(entry.getKey(), entry.getValue().readAndConsume());
                }
            }
            if (this.inMemoryLastPolicyAPIViolated != null && this.inMemoryLastPolicyAPIViolated.size() > 0) {
                for (Map.Entry<String, DatiEventoGenerico> entry : this.inMemoryLastPolicyAPIViolated.entrySet()) {
                    localInMemoryLastPolicyAPIViolated.put(entry.getKey(), entry.getValue().readAndConsume());
                }
            }
            if (this.inMemoryLastPolicyAPIViolatedWarningOnly != null && this.inMemoryLastPolicyAPIViolatedWarningOnly.size() > 0) {
                for (Map.Entry<String, DatiEventoGenerico> entry : this.inMemoryLastPolicyAPIViolatedWarningOnly.entrySet()) {
                    localInMemoryLastPolicyAPIViolatedWarningOnly.put(entry.getKey(), entry.getValue().readAndConsume());
                }
            }
            newInterval = DateManager.getDate();
        }
        finally {
            lock.release(slock, "process");
        }
        DatabaseDatiEventoGenerico localDbLastMaxRequests = null;
        DatabaseDatiEventoGenerico localDbLastMaxRequestsWarningOnly = null;
        DatabaseDatiEventoGenerico localDbLastPddCongestionata = null;
        Map<String, DatabaseDatiEventoGenerico> localDbLastPolicyGlobaliViolated = null;
        Map<String, DatabaseDatiEventoGenerico> localDbLastPolicyGlobaliViolatedWarningOnly = null;
        Map<String, DatabaseDatiEventoGenerico> localDbLastPolicyAPIViolated = null;
        Map<String, DatabaseDatiEventoGenerico> localDbLastPolicyAPIViolatedWarningOnly = null;
        localDbLastMaxRequests = this.dbLastMaxRequests;
        localDbLastMaxRequestsWarningOnly = this.dbLastMaxRequestsWarningOnly;
        localDbLastPddCongestionata = this.dbLastPddCongestionata;
        localDbLastPolicyGlobaliViolated = this.dbLastPolicyGlobaliViolated;
        localDbLastPolicyGlobaliViolatedWarningOnly = this.dbLastPolicyGlobaliViolatedWarningOnly;
        localDbLastPolicyAPIViolated = this.dbLastPolicyAPIViolated;
        localDbLastPolicyAPIViolatedWarningOnly = this.dbLastPolicyAPIViolatedWarningOnly;
        NotificatoreEventi.logDebug(log, debug, "1. Analisi violazioni numero massimo richieste simultanee ...");
        NotificatoreEventi.processSingleEvent(log, localInMemoryLastMaxRequests, localDbLastMaxRequests, this.dbLastMaxRequests, TipoEvento.CONTROLLO_TRAFFICO_NUMERO_MASSIMO_RICHIESTE_SIMULTANEE, CodiceEventoControlloTraffico.VIOLAZIONE, CodiceEventoControlloTraffico.VIOLAZIONE_RISOLTA, lastInterval, connection, this.gestoreEventi, null, debug);
        NotificatoreEventi.logDebug(log, debug, "1. Analisi violazioni numero massimo richieste simultanee terminata");
        NotificatoreEventi.logDebug(log, debug, "2. Analisi violazioni numero massimo richieste simultanee (warning-only) ...");
        NotificatoreEventi.processSingleEvent(log, localInMemoryLastMaxRequestsWarningOnly, localDbLastMaxRequestsWarningOnly, this.dbLastMaxRequestsWarningOnly, TipoEvento.CONTROLLO_TRAFFICO_NUMERO_MASSIMO_RICHIESTE_SIMULTANEE, CodiceEventoControlloTraffico.VIOLAZIONE_WARNING_ONLY, CodiceEventoControlloTraffico.VIOLAZIONE_RISOLTA_WARNING_ONLY, lastInterval, connection, this.gestoreEventi, null, debug);
        NotificatoreEventi.logDebug(log, debug, "2. Analisi violazioni numero massimo richieste simultanee (warning-only) terminata");
        NotificatoreEventi.logDebug(log, debug, "3. Analisi controllo della congestione ...");
        NotificatoreEventi.processSingleEvent(log, localInMemoryLastPddCongestionata, localDbLastPddCongestionata, this.dbLastPddCongestionata, TipoEvento.CONTROLLO_TRAFFICO_SOGLIA_CONGESTIONE, CodiceEventoControlloTraffico.VIOLAZIONE, CodiceEventoControlloTraffico.VIOLAZIONE_RISOLTA, lastInterval, connection, this.gestoreEventi, null, debug);
        NotificatoreEventi.logDebug(log, debug, "3. Analisi controllo della congestione terminata");
        NotificatoreEventi.logDebug(log, debug, "4. Analisi policy globali violate (size:" + localInMemoryLastPolicyGlobaliViolated.size() + SUFFIX_IN_CORSO);
        if (!localInMemoryLastPolicyGlobaliViolated.isEmpty()) {
            for (Map.Entry entry : localInMemoryLastPolicyGlobaliViolated.entrySet()) {
                idPolicy = (String)entry.getKey();
                NotificatoreEventi.processSingleEvent(log, (DatiEventoGenerico)localInMemoryLastPolicyGlobaliViolated.get(idPolicy), localDbLastPolicyGlobaliViolated.get(idPolicy), this.dbLastPolicyGlobaliViolated.get(idPolicy), TipoEvento.RATE_LIMITING_POLICY_GLOBALE, CodiceEventoControlloTraffico.VIOLAZIONE, CodiceEventoControlloTraffico.VIOLAZIONE_RISOLTA, lastInterval, connection, this.gestoreEventi, idPolicy, debug);
            }
        }
        NotificatoreEventi.logDebug(log, debug, "4. Analisi policy globali violate (size:" + localInMemoryLastPolicyGlobaliViolated.size() + SUFFIX_TERMINATA);
        NotificatoreEventi.logDebug(log, debug, "5. Analisi policy globali violate (size:" + localInMemoryLastPolicyGlobaliViolatedWarningOnly.size() + SUFFIX_WARNING_ONLY_IN_CORSO);
        if (!localInMemoryLastPolicyGlobaliViolatedWarningOnly.isEmpty()) {
            for (Map.Entry entry : localInMemoryLastPolicyGlobaliViolatedWarningOnly.entrySet()) {
                idPolicy = (String)entry.getKey();
                NotificatoreEventi.processSingleEvent(log, (DatiEventoGenerico)localInMemoryLastPolicyGlobaliViolatedWarningOnly.get(idPolicy), localDbLastPolicyGlobaliViolatedWarningOnly.get(idPolicy), this.dbLastPolicyGlobaliViolatedWarningOnly.get(idPolicy), TipoEvento.RATE_LIMITING_POLICY_GLOBALE, CodiceEventoControlloTraffico.VIOLAZIONE_WARNING_ONLY, CodiceEventoControlloTraffico.VIOLAZIONE_RISOLTA_WARNING_ONLY, lastInterval, connection, this.gestoreEventi, idPolicy, debug);
            }
        }
        NotificatoreEventi.logDebug(log, debug, "5. Analisi policy globali violate (size:" + localInMemoryLastPolicyGlobaliViolatedWarningOnly.size() + SUFFIX_WARNING_ONLY_TERMINATA);
        NotificatoreEventi.logDebug(log, debug, "6. Analisi policy API violate (size:" + localInMemoryLastPolicyAPIViolated.size() + SUFFIX_IN_CORSO);
        if (!localInMemoryLastPolicyAPIViolated.isEmpty()) {
            for (Map.Entry entry : localInMemoryLastPolicyAPIViolated.entrySet()) {
                idPolicy = (String)entry.getKey();
                NotificatoreEventi.processSingleEvent(log, (DatiEventoGenerico)localInMemoryLastPolicyAPIViolated.get(idPolicy), localDbLastPolicyAPIViolated.get(idPolicy), this.dbLastPolicyAPIViolated.get(idPolicy), TipoEvento.RATE_LIMITING_POLICY_API, CodiceEventoControlloTraffico.VIOLAZIONE, CodiceEventoControlloTraffico.VIOLAZIONE_RISOLTA, lastInterval, connection, this.gestoreEventi, idPolicy, debug);
            }
        }
        NotificatoreEventi.logDebug(log, debug, "6. Analisi policy API violate (size:" + localInMemoryLastPolicyAPIViolated.size() + SUFFIX_TERMINATA);
        NotificatoreEventi.logDebug(log, debug, "7. Analisi policy API violate (size:" + localInMemoryLastPolicyAPIViolatedWarningOnly.size() + SUFFIX_WARNING_ONLY_IN_CORSO);
        if (!localInMemoryLastPolicyAPIViolatedWarningOnly.isEmpty()) {
            for (Map.Entry entry : localInMemoryLastPolicyAPIViolatedWarningOnly.entrySet()) {
                idPolicy = (String)entry.getKey();
                NotificatoreEventi.processSingleEvent(log, (DatiEventoGenerico)localInMemoryLastPolicyAPIViolatedWarningOnly.get(idPolicy), localDbLastPolicyAPIViolatedWarningOnly.get(idPolicy), this.dbLastPolicyAPIViolatedWarningOnly.get(idPolicy), TipoEvento.RATE_LIMITING_POLICY_API, CodiceEventoControlloTraffico.VIOLAZIONE_WARNING_ONLY, CodiceEventoControlloTraffico.VIOLAZIONE_RISOLTA_WARNING_ONLY, lastInterval, connection, this.gestoreEventi, idPolicy, debug);
            }
        }
        NotificatoreEventi.logDebug(log, debug, "7. Analisi policy API violate (size:" + localInMemoryLastPolicyAPIViolatedWarningOnly.size() + SUFFIX_WARNING_ONLY_TERMINATA);
        NotificatoreEventi.logInfo(log, debug, "Analisi memoria per generazione eventi terminata " + NotificatoreEventi.getSuffixDate(df, newInterval, secondi));
        return newInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date processConnectionTimeout(Logger log, int secondi, Date lastInterval, Connection connection, boolean debug) throws UtilsException {
        SimpleDateFormat df = DateUtils.getSimpleDateFormatMs();
        NotificatoreEventi.logInfo(log, debug, SEPARATOR);
        NotificatoreEventi.logInfo(log, debug, "Analisi memoria per generazione eventi in corso 'ConnectionTimeout' [interval: " + df.format(lastInterval) + SUFFIX_IN_CORSO_PARENTESI_QUADRE);
        HashMap<String, DatiEventoGenerico> localInMemoryLastTimeoutConnessione = new HashMap<String, DatiEventoGenerico>();
        Date newInterval = null;
        SemaphoreLock slock = lock.acquire("processConnectionTimeout");
        try {
            if (this.inMemoryLastTimeoutConnessione != null && this.inMemoryLastTimeoutConnessione.size() > 0) {
                for (Map.Entry<String, DatiEventoGenerico> entry : this.inMemoryLastTimeoutConnessione.entrySet()) {
                    localInMemoryLastTimeoutConnessione.put(entry.getKey(), entry.getValue().readAndConsume());
                }
            }
            newInterval = DateManager.getDate();
        }
        finally {
            lock.release(slock, "processConnectionTimeout");
        }
        Map<String, DatabaseDatiEventoGenerico> localDbLastTimeoutConnessione = null;
        localDbLastTimeoutConnessione = this.dbLastTimeoutConnessione;
        NotificatoreEventi.logDebug(log, debug, "8. Analisi eventi di Timeout durante la connessione (size:" + localInMemoryLastTimeoutConnessione.size() + SUFFIX_IN_CORSO);
        if (!localInMemoryLastTimeoutConnessione.isEmpty()) {
            for (Map.Entry entry : localInMemoryLastTimeoutConnessione.entrySet()) {
                String idPolicy = (String)entry.getKey();
                NotificatoreEventi.processSingleEvent(log, (DatiEventoGenerico)localInMemoryLastTimeoutConnessione.get(idPolicy), localDbLastTimeoutConnessione.get(idPolicy), this.dbLastTimeoutConnessione.get(idPolicy), TipoEvento.CONTROLLO_TRAFFICO_CONNECTION_TIMEOUT, CodiceEventoControlloTraffico.VIOLAZIONE, CodiceEventoControlloTraffico.VIOLAZIONE_RISOLTA, lastInterval, connection, this.gestoreEventi, idPolicy, debug);
            }
        }
        NotificatoreEventi.logDebug(log, debug, "8. Analisi eventi di Timeout durante la connessione (size:" + localInMemoryLastTimeoutConnessione.size() + SUFFIX_TERMINATA);
        NotificatoreEventi.logInfo(log, debug, "Analisi memoria per generazione eventi terminata 'ConnectionTimeout' " + NotificatoreEventi.getSuffixDate(df, newInterval, secondi));
        return newInterval;
    }

    public void emitProcessConnectionTimeoutSkip(Logger log, boolean debug, int offsetConnectionTimeoutEveryXTimes, int checkConnectionTimeoutEveryXTimes) {
        NotificatoreEventi.logDebug(log, debug, "8. Analisi eventi di Timeout durante la connessione non abilitata in questa iterazione (offset: " + offsetConnectionTimeoutEveryXTimes + EVERY + checkConnectionTimeoutEveryXTimes + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date processRequestReadTimeout(Logger log, int secondi, Date lastInterval, Connection connection, boolean debug) throws UtilsException {
        SimpleDateFormat df = DateUtils.getSimpleDateFormatMs();
        NotificatoreEventi.logInfo(log, debug, SEPARATOR);
        NotificatoreEventi.logInfo(log, debug, "Analisi memoria per generazione eventi in corso 'RequestReadTimeout' [interval: " + df.format(lastInterval) + SUFFIX_IN_CORSO_PARENTESI_QUADRE);
        HashMap<String, DatiEventoGenerico> localInMemoryLastTimeoutRichiesta = new HashMap<String, DatiEventoGenerico>();
        Date newInterval = null;
        SemaphoreLock slock = lock.acquire("processRequestReadTimeout");
        try {
            if (this.inMemoryLastTimeoutRichiesta != null && this.inMemoryLastTimeoutRichiesta.size() > 0) {
                for (Map.Entry<String, DatiEventoGenerico> entry : this.inMemoryLastTimeoutRichiesta.entrySet()) {
                    localInMemoryLastTimeoutRichiesta.put(entry.getKey(), entry.getValue().readAndConsume());
                }
            }
            newInterval = DateManager.getDate();
        }
        finally {
            lock.release(slock, "processRequestReadTimeout");
        }
        Map<String, DatabaseDatiEventoGenerico> localDbLastTimeoutRichiesta = null;
        localDbLastTimeoutRichiesta = this.dbLastTimeoutRichiesta;
        NotificatoreEventi.logDebug(log, debug, "9. Analisi eventi di Timeout durante la ricezione della richiesta (size:" + localInMemoryLastTimeoutRichiesta.size() + SUFFIX_IN_CORSO);
        if (!localInMemoryLastTimeoutRichiesta.isEmpty()) {
            for (Map.Entry entry : localInMemoryLastTimeoutRichiesta.entrySet()) {
                String idPolicy = (String)entry.getKey();
                NotificatoreEventi.processSingleEvent(log, (DatiEventoGenerico)localInMemoryLastTimeoutRichiesta.get(idPolicy), localDbLastTimeoutRichiesta.get(idPolicy), this.dbLastTimeoutRichiesta.get(idPolicy), TipoEvento.CONTROLLO_TRAFFICO_REQUEST_READ_TIMEOUT, CodiceEventoControlloTraffico.VIOLAZIONE, CodiceEventoControlloTraffico.VIOLAZIONE_RISOLTA, lastInterval, connection, this.gestoreEventi, idPolicy, debug);
            }
        }
        NotificatoreEventi.logDebug(log, debug, "9. Analisi eventi di Timeout durante la ricezione della richiesta (size:" + localInMemoryLastTimeoutRichiesta.size() + SUFFIX_TERMINATA);
        NotificatoreEventi.logInfo(log, debug, "Analisi memoria per generazione eventi terminata 'RequestReadTimeout' " + NotificatoreEventi.getSuffixDate(df, newInterval, secondi));
        return newInterval;
    }

    public void emitProcessRequestReadTimeoutSkip(Logger log, boolean debug, int offsetRequestReadTimeoutEveryXTimes, int checkRequestReadTimeoutEveryXTimes) {
        NotificatoreEventi.logDebug(log, debug, "9. Analisi eventi di Timeout durante la ricezione della richiesta non abilitata in questa iterazione (offset: " + offsetRequestReadTimeoutEveryXTimes + EVERY + checkRequestReadTimeoutEveryXTimes + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date processReadTimeout(Logger log, int secondi, Date lastInterval, Connection connection, boolean debug) throws UtilsException {
        SimpleDateFormat df = DateUtils.getSimpleDateFormatMs();
        NotificatoreEventi.logInfo(log, debug, SEPARATOR);
        NotificatoreEventi.logInfo(log, debug, "Analisi memoria per generazione eventi in corso 'ReadTimeout' [interval: " + df.format(lastInterval) + SUFFIX_IN_CORSO_PARENTESI_QUADRE);
        HashMap<String, DatiEventoGenerico> localInMemoryLastTimeoutRisposta = new HashMap<String, DatiEventoGenerico>();
        Date newInterval = null;
        SemaphoreLock slock = lock.acquire("processReadTimeout");
        try {
            if (this.inMemoryLastTimeoutRisposta != null && this.inMemoryLastTimeoutRisposta.size() > 0) {
                for (Map.Entry<String, DatiEventoGenerico> entry : this.inMemoryLastTimeoutRisposta.entrySet()) {
                    localInMemoryLastTimeoutRisposta.put(entry.getKey(), entry.getValue().readAndConsume());
                }
            }
            newInterval = DateManager.getDate();
        }
        finally {
            lock.release(slock, "processReadTimeout");
        }
        Map<String, DatabaseDatiEventoGenerico> localDbLastTimeoutRisposta = null;
        localDbLastTimeoutRisposta = this.dbLastTimeoutRisposta;
        NotificatoreEventi.logDebug(log, debug, "10. Analisi eventi di Timeout durante la ricezione della risposta (size:" + localInMemoryLastTimeoutRisposta.size() + SUFFIX_IN_CORSO);
        if (!localInMemoryLastTimeoutRisposta.isEmpty()) {
            for (Map.Entry entry : localInMemoryLastTimeoutRisposta.entrySet()) {
                String idPolicy = (String)entry.getKey();
                NotificatoreEventi.processSingleEvent(log, (DatiEventoGenerico)localInMemoryLastTimeoutRisposta.get(idPolicy), localDbLastTimeoutRisposta.get(idPolicy), this.dbLastTimeoutRisposta.get(idPolicy), TipoEvento.CONTROLLO_TRAFFICO_READ_TIMEOUT, CodiceEventoControlloTraffico.VIOLAZIONE, CodiceEventoControlloTraffico.VIOLAZIONE_RISOLTA, lastInterval, connection, this.gestoreEventi, idPolicy, debug);
            }
        }
        NotificatoreEventi.logDebug(log, debug, "10. Analisi eventi di Timeout durante la ricezione della risposta (size:" + localInMemoryLastTimeoutRisposta.size() + SUFFIX_TERMINATA);
        NotificatoreEventi.logInfo(log, debug, "Analisi memoria per generazione eventi terminata 'ReadTimeout' " + NotificatoreEventi.getSuffixDate(df, newInterval, secondi));
        return newInterval;
    }

    public void emitProcessReadTimeoutSkip(Logger log, boolean debug, int offsetReadTimeoutEveryXTimes, int checkReadTimeoutEveryXTimes) {
        NotificatoreEventi.logDebug(log, debug, "10. Analisi eventi di Timeout durante la ricezione della risposta non abilitata in questa iterazione (offset: " + offsetReadTimeoutEveryXTimes + EVERY + checkReadTimeoutEveryXTimes + ")");
    }

    private static void processSingleEvent(Logger log, DatiEventoGenerico localInMemory, DatabaseDatiEventoGenerico localDb, DatabaseDatiEventoGenerico thisDb, TipoEvento tipoEvento, CodiceEventoControlloTraffico eventoViolazione, CodiceEventoControlloTraffico eventoViolazioneRisolta, Date lastInterval, Connection connection, GestoreEventi gestoreEventi, String idPolicy, boolean debug) throws UtilsException {
        boolean esisteTHultimoIntervallo = false;
        if (localInMemory != null && localInMemory.data != null && localInMemory.data.after(lastInterval)) {
            esisteTHultimoIntervallo = true;
        }
        if (localDb != null && localDb.data != null) {
            NotificatoreEventi.logDebug(log, debug, "\tTH_ultimoIntervallo: " + esisteTHultimoIntervallo + " DB_last:" + (localDb != null) + " DB_last.codiceEvento:" + localDb.codiceEvento.name());
        } else {
            NotificatoreEventi.logDebug(log, debug, "\tTH_ultimoIntervallo: " + esisteTHultimoIntervallo);
        }
        if (esisteTHultimoIntervallo) {
            if (localDb != null && localDb.data != null) {
                if (eventoViolazioneRisolta.equals((Object)localDb.codiceEvento)) {
                    CodiceEventoControlloTraffico codice = eventoViolazione;
                    Evento evento = NotificatoreEventi.buildEvento(tipoEvento, codice, idPolicy, localInMemory.descrizione, localInMemory.configurazione, localInMemory.data);
                    NotificatoreEventi.logEvento(gestoreEventi, connection, evento, log, debug);
                    thisDb.data = evento.getOraRegistrazione();
                    thisDb.codiceEvento = codice;
                    if (idPolicy != null) {
                        NotificatoreEventi.logDebug(log, debug, NotificatoreEventi.getProcessSingleEventMessage(tipoEvento, codice, idPolicy));
                    } else {
                        NotificatoreEventi.logDebug(log, debug, NotificatoreEventi.getProcessSingleEventMessage(tipoEvento, codice));
                    }
                }
            } else {
                CodiceEventoControlloTraffico codice = eventoViolazione;
                Evento evento = NotificatoreEventi.buildEvento(tipoEvento, codice, idPolicy, localInMemory.descrizione, localInMemory.configurazione, localInMemory.data);
                NotificatoreEventi.logEvento(gestoreEventi, connection, evento, log, debug);
                thisDb.data = evento.getOraRegistrazione();
                thisDb.codiceEvento = codice;
                if (idPolicy != null) {
                    NotificatoreEventi.logDebug(log, debug, NotificatoreEventi.getProcessSingleEventMessage(tipoEvento, codice, idPolicy));
                } else {
                    NotificatoreEventi.logDebug(log, debug, NotificatoreEventi.getProcessSingleEventMessage(tipoEvento, codice));
                }
            }
        } else if (localDb != null && localDb.data != null && eventoViolazione.equals((Object)localDb.codiceEvento)) {
            CodiceEventoControlloTraffico codice = eventoViolazioneRisolta;
            Evento evento = NotificatoreEventi.buildEvento(tipoEvento, codice, idPolicy, localDb.descrizione, localInMemory != null && localInMemory.configurazione != null ? localInMemory.configurazione : localDb.configurazione, DateManager.getDate());
            NotificatoreEventi.logEvento(gestoreEventi, connection, evento, log, debug);
            thisDb.data = evento.getOraRegistrazione();
            thisDb.codiceEvento = codice;
            if (idPolicy != null) {
                NotificatoreEventi.logDebug(log, debug, NotificatoreEventi.getProcessSingleEventMessage(tipoEvento, codice, idPolicy));
            } else {
                NotificatoreEventi.logDebug(log, debug, NotificatoreEventi.getProcessSingleEventMessage(tipoEvento, codice));
            }
        }
    }

    private static String getProcessSingleEventMessage(TipoEvento tipoEvento, CodiceEventoControlloTraffico codice, String idPolicy) {
        return "\tEmetto Evento tipo[" + tipoEvento + "] codice[" + codice + "_" + idPolicy + "]";
    }

    private static String getProcessSingleEventMessage(TipoEvento tipoEvento, CodiceEventoControlloTraffico codice) {
        return "\tEmetto Evento tipo[" + tipoEvento + "] codice[" + codice + "]";
    }

    private static Evento buildEvento(TipoEvento tipoEvento, CodiceEventoControlloTraffico codice, String idPolicy, String descrizione, String configurazione, Date data) throws UtilsException {
        Evento evento = new Evento();
        evento.setTipo(tipoEvento.getValue());
        evento.setCodice(codice.getValue());
        if (idPolicy != null) {
            evento.setIdConfigurazione(idPolicy);
        }
        evento.setDescrizione(descrizione);
        evento.setConfigurazione(configurazione);
        evento.setOraRegistrazione(data);
        block0 : switch (tipoEvento) {
            case CONTROLLO_TRAFFICO_NUMERO_MASSIMO_RICHIESTE_SIMULTANEE: {
                switch (codice) {
                    case VIOLAZIONE: {
                        evento.setSeverita(SeveritaConverter.toIntValue((TipoSeverita)TipoSeverita.ERROR));
                        break block0;
                    }
                    case VIOLAZIONE_RISOLTA: {
                        evento.setSeverita(SeveritaConverter.toIntValue((TipoSeverita)TipoSeverita.INFO));
                        break block0;
                    }
                    case VIOLAZIONE_WARNING_ONLY: {
                        evento.setSeverita(SeveritaConverter.toIntValue((TipoSeverita)TipoSeverita.WARN));
                        break block0;
                    }
                    case VIOLAZIONE_RISOLTA_WARNING_ONLY: {
                        evento.setSeverita(SeveritaConverter.toIntValue((TipoSeverita)TipoSeverita.INFO));
                        break block0;
                    }
                }
                break;
            }
            case CONTROLLO_TRAFFICO_SOGLIA_CONGESTIONE: {
                switch (codice) {
                    case VIOLAZIONE: {
                        evento.setSeverita(SeveritaConverter.toIntValue((TipoSeverita)TipoSeverita.WARN));
                        break block0;
                    }
                    case VIOLAZIONE_RISOLTA: {
                        evento.setSeverita(SeveritaConverter.toIntValue((TipoSeverita)TipoSeverita.INFO));
                        break block0;
                    }
                }
                break;
            }
            case RATE_LIMITING_POLICY_GLOBALE: 
            case RATE_LIMITING_POLICY_API: {
                switch (codice) {
                    case VIOLAZIONE: {
                        evento.setSeverita(SeveritaConverter.toIntValue((TipoSeverita)TipoSeverita.ERROR));
                        break;
                    }
                    case VIOLAZIONE_RISOLTA: {
                        evento.setSeverita(SeveritaConverter.toIntValue((TipoSeverita)TipoSeverita.INFO));
                        break;
                    }
                    case VIOLAZIONE_WARNING_ONLY: {
                        evento.setSeverita(SeveritaConverter.toIntValue((TipoSeverita)TipoSeverita.WARN));
                        break;
                    }
                    case VIOLAZIONE_RISOLTA_WARNING_ONLY: {
                        evento.setSeverita(SeveritaConverter.toIntValue((TipoSeverita)TipoSeverita.INFO));
                    }
                }
                break;
            }
            case CONTROLLO_TRAFFICO_CONNECTION_TIMEOUT: 
            case CONTROLLO_TRAFFICO_REQUEST_READ_TIMEOUT: 
            case CONTROLLO_TRAFFICO_READ_TIMEOUT: {
                switch (codice) {
                    case VIOLAZIONE: {
                        evento.setSeverita(SeveritaConverter.toIntValue((TipoSeverita)TipoSeverita.ERROR));
                        break block0;
                    }
                    case VIOLAZIONE_RISOLTA: {
                        evento.setSeverita(SeveritaConverter.toIntValue((TipoSeverita)TipoSeverita.INFO));
                        break block0;
                    }
                }
                break;
            }
        }
        evento.setClusterId(OpenSPCoop2Properties.getInstance().getClusterId(false));
        return evento;
    }

    private static void logEvento(GestoreEventi gestoreEventi, Connection connection, Evento evento, Logger log, boolean debug) throws UtilsException {
        INotify notifier;
        ConfigurazioneGatewayControlloTraffico config;
        String configurazione = evento.getConfigurazione();
        if (PolicyUtilities.isConfigurazioneEventoPerPolicy((String)configurazione)) {
            evento.setConfigurazione(null);
        }
        try {
            gestoreEventi.log(evento, connection);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
        if (properties.isControlloTrafficoEnabled() && (config = properties.getConfigurazioneControlloTraffico()).isNotifierEnabled() && (notifier = config.getNotifier()).isNotifichePassiveAttive()) {
            TipoEvento tipoEvento = TipoEvento.toEnumConstant((String)evento.getTipo());
            CodiceEventoControlloTraffico codiceEvento = CodiceEventoControlloTraffico.toEnumConstant((String)evento.getCodice());
            switch (tipoEvento) {
                case CONTROLLO_TRAFFICO_NUMERO_MASSIMO_RICHIESTE_SIMULTANEE: 
                case CONTROLLO_TRAFFICO_SOGLIA_CONGESTIONE: {
                    notifier.updateStatoRilevamentoCongestione(log, debug, tipoEvento, codiceEvento, evento.getDescrizione());
                    break;
                }
                case RATE_LIMITING_POLICY_GLOBALE: 
                case RATE_LIMITING_POLICY_API: {
                    notifier.updateStatoRilevamentoViolazionePolicy(log, debug, tipoEvento, codiceEvento, evento.getIdConfigurazione(), configurazione);
                    break;
                }
                case CONTROLLO_TRAFFICO_REQUEST_READ_TIMEOUT: {
                    notifier.updateStatoRilevamentoRequestReadTimeout(log, debug, tipoEvento, codiceEvento, evento.getIdConfigurazione(), configurazione);
                    break;
                }
                case CONTROLLO_TRAFFICO_READ_TIMEOUT: {
                    notifier.updateStatoRilevamentoReadTimeout(log, debug, tipoEvento, codiceEvento, evento.getIdConfigurazione(), configurazione);
                    break;
                }
            }
        }
    }

    public void serialize(File file) throws UtilsException {
        try (FileOutputStream out = new FileOutputStream(file, false);){
            this.serialize(out);
            out.flush();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    public void serialize(OutputStream out) throws UtilsException {
        try (ZipOutputStream zipOut = new ZipOutputStream(out);){
            DatabaseDatiEventoGenerico evento;
            String idPolicy;
            String dbPolicyDir;
            DatiEventoGenerico evento2;
            String idPolicy2;
            String inMemoryPolicyDir;
            int index;
            Object rootPackageDir = "";
            rootPackageDir = "openspcoop" + File.separatorChar;
            String inMemoryDir = (String)rootPackageDir + ZIP_IN_MEMORY + File.separatorChar;
            if (this.inMemoryLastMaxRequests != null) {
                zipOut.putNextEntry(new ZipEntry(inMemoryDir + ZIP_LAST_MAX_REQUESTS));
                this.convertToDatiEventoGenericoSerializabled(this.inMemoryLastMaxRequests, "inMemory_lastMaxRequests").writeTo((OutputStream)zipOut, WriteToSerializerType.XML_JAXB);
            }
            if (this.inMemoryLastMaxRequestsWarningOnly != null) {
                zipOut.putNextEntry(new ZipEntry(inMemoryDir + ZIP_LAST_MAX_REQUESTS_WARNING_ONLY));
                this.convertToDatiEventoGenericoSerializabled(this.inMemoryLastMaxRequestsWarningOnly, "inMemory_lastMaxRequests_warningOnly").writeTo((OutputStream)zipOut, WriteToSerializerType.XML_JAXB);
            }
            if (this.inMemoryLastPddCongestionata != null) {
                zipOut.putNextEntry(new ZipEntry(inMemoryDir + ZIP_LAST_PDD_CONGESTIONATA));
                this.convertToDatiEventoGenericoSerializabled(this.inMemoryLastPddCongestionata, "inMemory_lastPddCongestionata").writeTo((OutputStream)zipOut, WriteToSerializerType.XML_JAXB);
            }
            if (this.inMemoryLastPolicyGlobaliViolated != null && this.inMemoryLastPolicyGlobaliViolated.size() > 0) {
                index = 1;
                inMemoryPolicyDir = inMemoryDir + ZIP_POLICY_GLOBALE + File.separatorChar;
                for (Map.Entry<String, DatiEventoGenerico> entry : this.inMemoryLastPolicyGlobaliViolated.entrySet()) {
                    idPolicy2 = entry.getKey();
                    evento2 = this.inMemoryLastPolicyGlobaliViolated.get(idPolicy2);
                    zipOut.putNextEntry(new ZipEntry(inMemoryPolicyDir + "policyGlobale_" + index + ".xml"));
                    this.convertToDatiEventoGenericoSerializabled(evento2, idPolicy2).writeTo((OutputStream)zipOut, WriteToSerializerType.XML_JAXB);
                    ++index;
                }
            }
            if (this.inMemoryLastPolicyGlobaliViolatedWarningOnly != null && this.inMemoryLastPolicyGlobaliViolatedWarningOnly.size() > 0) {
                index = 1;
                inMemoryPolicyDir = inMemoryDir + ZIP_POLICY_GLOBALE_WARNING_ONLY + File.separatorChar;
                for (Map.Entry<String, DatiEventoGenerico> entry : this.inMemoryLastPolicyGlobaliViolatedWarningOnly.entrySet()) {
                    idPolicy2 = entry.getKey();
                    evento2 = this.inMemoryLastPolicyGlobaliViolatedWarningOnly.get(idPolicy2);
                    zipOut.putNextEntry(new ZipEntry(inMemoryPolicyDir + "policyGlobale_warningOnly_" + index + ".xml"));
                    this.convertToDatiEventoGenericoSerializabled(evento2, idPolicy2).writeTo((OutputStream)zipOut, WriteToSerializerType.XML_JAXB);
                    ++index;
                }
            }
            if (this.inMemoryLastPolicyAPIViolated != null && this.inMemoryLastPolicyAPIViolated.size() > 0) {
                index = 1;
                inMemoryPolicyDir = inMemoryDir + ZIP_POLICY_API + File.separatorChar;
                for (Map.Entry<String, DatiEventoGenerico> entry : this.inMemoryLastPolicyAPIViolated.entrySet()) {
                    idPolicy2 = entry.getKey();
                    evento2 = this.inMemoryLastPolicyAPIViolated.get(idPolicy2);
                    zipOut.putNextEntry(new ZipEntry(inMemoryPolicyDir + "policyAPI_" + index + ".xml"));
                    this.convertToDatiEventoGenericoSerializabled(evento2, idPolicy2).writeTo((OutputStream)zipOut, WriteToSerializerType.XML_JAXB);
                    ++index;
                }
            }
            if (this.inMemoryLastPolicyAPIViolatedWarningOnly != null && this.inMemoryLastPolicyAPIViolatedWarningOnly.size() > 0) {
                index = 1;
                inMemoryPolicyDir = inMemoryDir + ZIP_POLICY_API_WARNING_ONLY + File.separatorChar;
                for (Map.Entry<String, DatiEventoGenerico> entry : this.inMemoryLastPolicyAPIViolatedWarningOnly.entrySet()) {
                    idPolicy2 = entry.getKey();
                    evento2 = this.inMemoryLastPolicyAPIViolatedWarningOnly.get(idPolicy2);
                    zipOut.putNextEntry(new ZipEntry(inMemoryPolicyDir + "policyAPI_warningOnly_" + index + ".xml"));
                    this.convertToDatiEventoGenericoSerializabled(evento2, idPolicy2).writeTo((OutputStream)zipOut, WriteToSerializerType.XML_JAXB);
                    ++index;
                }
            }
            if (this.inMemoryLastTimeoutConnessione != null && this.inMemoryLastTimeoutConnessione.size() > 0) {
                index = 1;
                inMemoryPolicyDir = inMemoryDir + ZIP_EVENTO_TIMEOUT_CONNESSIONE + File.separatorChar;
                for (Map.Entry<String, DatiEventoGenerico> entry : this.inMemoryLastTimeoutConnessione.entrySet()) {
                    idPolicy2 = entry.getKey();
                    evento2 = this.inMemoryLastTimeoutConnessione.get(idPolicy2);
                    zipOut.putNextEntry(new ZipEntry(inMemoryPolicyDir + "connectionTimeout_" + index + ".xml"));
                    this.convertToDatiEventoGenericoSerializabled(evento2, idPolicy2).writeTo((OutputStream)zipOut, WriteToSerializerType.XML_JAXB);
                    ++index;
                }
            }
            if (this.inMemoryLastTimeoutRichiesta != null && this.inMemoryLastTimeoutRichiesta.size() > 0) {
                index = 1;
                inMemoryPolicyDir = inMemoryDir + ZIP_EVENTO_TIMEOUT_RICHIESTA + File.separatorChar;
                for (Map.Entry<String, DatiEventoGenerico> entry : this.inMemoryLastTimeoutRichiesta.entrySet()) {
                    idPolicy2 = entry.getKey();
                    evento2 = this.inMemoryLastTimeoutRichiesta.get(idPolicy2);
                    zipOut.putNextEntry(new ZipEntry(inMemoryPolicyDir + "requestReadTimeout_" + index + ".xml"));
                    this.convertToDatiEventoGenericoSerializabled(evento2, idPolicy2).writeTo((OutputStream)zipOut, WriteToSerializerType.XML_JAXB);
                    ++index;
                }
            }
            if (this.inMemoryLastTimeoutRisposta != null && this.inMemoryLastTimeoutRisposta.size() > 0) {
                index = 1;
                inMemoryPolicyDir = inMemoryDir + ZIP_EVENTO_TIMEOUT_RISPOSTA + File.separatorChar;
                for (Map.Entry<String, DatiEventoGenerico> entry : this.inMemoryLastTimeoutRisposta.entrySet()) {
                    idPolicy2 = entry.getKey();
                    evento2 = this.inMemoryLastTimeoutRisposta.get(idPolicy2);
                    zipOut.putNextEntry(new ZipEntry(inMemoryPolicyDir + "readTimeout_" + index + ".xml"));
                    this.convertToDatiEventoGenericoSerializabled(evento2, idPolicy2).writeTo((OutputStream)zipOut, WriteToSerializerType.XML_JAXB);
                    ++index;
                }
            }
            String dbDir = (String)rootPackageDir + ZIP_DB + File.separatorChar;
            if (this.dbLastMaxRequests != null) {
                zipOut.putNextEntry(new ZipEntry(dbDir + ZIP_LAST_MAX_REQUESTS));
                this.convertDBToDatiEventoGenericoSerializabled(this.dbLastMaxRequests, "db_lastMaxRequests").writeTo((OutputStream)zipOut, WriteToSerializerType.XML_JAXB);
            }
            if (this.dbLastMaxRequestsWarningOnly != null) {
                zipOut.putNextEntry(new ZipEntry(dbDir + ZIP_LAST_MAX_REQUESTS_WARNING_ONLY));
                this.convertDBToDatiEventoGenericoSerializabled(this.dbLastMaxRequestsWarningOnly, "db_lastMaxRequests_warningOnly").writeTo((OutputStream)zipOut, WriteToSerializerType.XML_JAXB);
            }
            if (this.dbLastPddCongestionata != null) {
                zipOut.putNextEntry(new ZipEntry(dbDir + ZIP_LAST_PDD_CONGESTIONATA));
                this.convertDBToDatiEventoGenericoSerializabled(this.dbLastPddCongestionata, "db_lastPddCongestionata").writeTo((OutputStream)zipOut, WriteToSerializerType.XML_JAXB);
            }
            if (this.dbLastPolicyGlobaliViolated != null && this.dbLastPolicyGlobaliViolated.size() > 0) {
                int index2 = 1;
                dbPolicyDir = dbDir + ZIP_POLICY_GLOBALE + File.separatorChar;
                for (Map.Entry<String, DatabaseDatiEventoGenerico> entry : this.dbLastPolicyGlobaliViolated.entrySet()) {
                    idPolicy = entry.getKey();
                    evento = this.dbLastPolicyGlobaliViolated.get(idPolicy);
                    zipOut.putNextEntry(new ZipEntry(dbPolicyDir + "policyGlobale_" + index2 + ".xml"));
                    this.convertDBToDatiEventoGenericoSerializabled(evento, idPolicy).writeTo((OutputStream)zipOut, WriteToSerializerType.XML_JAXB);
                    ++index2;
                }
            }
            if (this.dbLastPolicyGlobaliViolatedWarningOnly != null && this.dbLastPolicyGlobaliViolatedWarningOnly.size() > 0) {
                int index3 = 1;
                dbPolicyDir = dbDir + ZIP_POLICY_GLOBALE_WARNING_ONLY + File.separatorChar;
                for (Map.Entry<String, DatabaseDatiEventoGenerico> entry : this.dbLastPolicyGlobaliViolatedWarningOnly.entrySet()) {
                    idPolicy = entry.getKey();
                    evento = this.dbLastPolicyGlobaliViolatedWarningOnly.get(idPolicy);
                    zipOut.putNextEntry(new ZipEntry(dbPolicyDir + "policyGlobale_warningOnly_" + index3 + ".xml"));
                    this.convertDBToDatiEventoGenericoSerializabled(evento, idPolicy).writeTo((OutputStream)zipOut, WriteToSerializerType.XML_JAXB);
                    ++index3;
                }
            }
            if (this.dbLastPolicyAPIViolated != null && this.dbLastPolicyAPIViolated.size() > 0) {
                int index4 = 1;
                dbPolicyDir = dbDir + ZIP_POLICY_API + File.separatorChar;
                for (Map.Entry<String, DatabaseDatiEventoGenerico> entry : this.dbLastPolicyAPIViolated.entrySet()) {
                    idPolicy = entry.getKey();
                    evento = this.dbLastPolicyAPIViolated.get(idPolicy);
                    zipOut.putNextEntry(new ZipEntry(dbPolicyDir + "policyAPI_" + index4 + ".xml"));
                    this.convertDBToDatiEventoGenericoSerializabled(evento, idPolicy).writeTo((OutputStream)zipOut, WriteToSerializerType.XML_JAXB);
                    ++index4;
                }
            }
            if (this.dbLastPolicyAPIViolatedWarningOnly != null && this.dbLastPolicyAPIViolatedWarningOnly.size() > 0) {
                int index5 = 1;
                dbPolicyDir = dbDir + ZIP_POLICY_API_WARNING_ONLY + File.separatorChar;
                for (Map.Entry<String, DatabaseDatiEventoGenerico> entry : this.dbLastPolicyAPIViolatedWarningOnly.entrySet()) {
                    idPolicy = entry.getKey();
                    evento = this.dbLastPolicyAPIViolatedWarningOnly.get(idPolicy);
                    zipOut.putNextEntry(new ZipEntry(dbPolicyDir + "policyAPI_warningOnly_" + index5 + ".xml"));
                    this.convertDBToDatiEventoGenericoSerializabled(evento, idPolicy).writeTo((OutputStream)zipOut, WriteToSerializerType.XML_JAXB);
                    ++index5;
                }
            }
            if (this.dbLastTimeoutConnessione != null && this.dbLastTimeoutConnessione.size() > 0) {
                int index6 = 1;
                dbPolicyDir = dbDir + ZIP_EVENTO_TIMEOUT_CONNESSIONE + File.separatorChar;
                for (Map.Entry<String, DatabaseDatiEventoGenerico> entry : this.dbLastTimeoutConnessione.entrySet()) {
                    idPolicy = entry.getKey();
                    evento = this.dbLastTimeoutConnessione.get(idPolicy);
                    zipOut.putNextEntry(new ZipEntry(dbPolicyDir + "connectionTimeout_" + index6 + ".xml"));
                    this.convertDBToDatiEventoGenericoSerializabled(evento, idPolicy).writeTo((OutputStream)zipOut, WriteToSerializerType.XML_JAXB);
                    ++index6;
                }
            }
            if (this.dbLastTimeoutRichiesta != null && this.dbLastTimeoutRichiesta.size() > 0) {
                int index7 = 1;
                dbPolicyDir = dbDir + ZIP_EVENTO_TIMEOUT_RICHIESTA + File.separatorChar;
                for (Map.Entry<String, DatabaseDatiEventoGenerico> entry : this.dbLastTimeoutRichiesta.entrySet()) {
                    idPolicy = entry.getKey();
                    evento = this.dbLastTimeoutRichiesta.get(idPolicy);
                    zipOut.putNextEntry(new ZipEntry(dbPolicyDir + "requestReadTimeout_" + index7 + ".xml"));
                    this.convertDBToDatiEventoGenericoSerializabled(evento, idPolicy).writeTo((OutputStream)zipOut, WriteToSerializerType.XML_JAXB);
                    ++index7;
                }
            }
            if (this.dbLastTimeoutRisposta != null && this.dbLastTimeoutRisposta.size() > 0) {
                int index8 = 1;
                dbPolicyDir = dbDir + ZIP_EVENTO_TIMEOUT_RISPOSTA + File.separatorChar;
                for (Map.Entry<String, DatabaseDatiEventoGenerico> entry : this.dbLastTimeoutRisposta.entrySet()) {
                    idPolicy = entry.getKey();
                    evento = this.dbLastTimeoutRisposta.get(idPolicy);
                    zipOut.putNextEntry(new ZipEntry(dbPolicyDir + "readTimeout_" + index8 + ".xml"));
                    this.convertDBToDatiEventoGenericoSerializabled(evento, idPolicy).writeTo((OutputStream)zipOut, WriteToSerializerType.XML_JAXB);
                    ++index8;
                }
            }
            zipOut.flush();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    private org.openspcoop2.core.eventi.DatiEventoGenerico convertToDatiEventoGenericoSerializabled(DatiEventoGenerico eventoGenerico, String id) {
        org.openspcoop2.core.eventi.DatiEventoGenerico e = new org.openspcoop2.core.eventi.DatiEventoGenerico();
        e.setIdEvento(id);
        e.setData(eventoGenerico.data);
        e.setDatiConsumatiThread(eventoGenerico.datiConsumatiThread);
        e.setDescrizione(eventoGenerico.descrizione);
        return e;
    }

    private org.openspcoop2.core.eventi.DatiEventoGenerico convertDBToDatiEventoGenericoSerializabled(DatabaseDatiEventoGenerico eventoGenerico, String id) {
        org.openspcoop2.core.eventi.DatiEventoGenerico e = this.convertToDatiEventoGenericoSerializabled(eventoGenerico, id);
        if (eventoGenerico.codiceEvento != null) {
            e.setCodiceEvento(eventoGenerico.codiceEvento.getValue());
        }
        return e;
    }

    @Deprecated
    public void initialize(InputStream in) throws UtilsException {
        if (in == null) {
            return;
        }
        File f = null;
        String entryName = null;
        try {
            byte[] bytesIn = Utilities.getAsByteArray((InputStream)in);
            in.close();
            in = null;
            if (bytesIn == null || bytesIn.length <= 0) {
                return;
            }
            f = FileSystemUtilities.createTempFile((String)"controlloTraffico", (String)".tmp");
            FileSystemUtilities.writeFile((File)f, (byte[])bytesIn);
        }
        catch (Exception e) {
            try {
                if (f != null) {
                    Files.delete(f.toPath());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UtilsException("[" + entryName + "] " + e.getMessage(), (Throwable)e);
        }
        try (ZipFile zipFile = new ZipFile(f);){
            String rootPackageDir = "openspcoop" + File.separatorChar;
            String rootDir = null;
            JaxbDeserializer deserializer = new JaxbDeserializer();
            Iterator it = ZipUtilities.entries((ZipFile)zipFile, (boolean)true);
            while (it.hasNext()) {
                ZipEntry zipEntry = (ZipEntry)it.next();
                entryName = ZipUtilities.operativeSystemConversion((String)zipEntry.getName());
                if (rootDir == null) {
                    rootDir = ZipUtilities.getRootDir((String)entryName);
                }
                if (zipEntry.isDirectory()) continue;
                FileDataSource fds = new FileDataSource(entryName);
                String nome = fds.getName();
                String tipo = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                tipo = tipo.toUpperCase();
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                try {
                    org.openspcoop2.core.eventi.DatiEventoGenerico eventoGenericoSerialized;
                    byte[] content = Utilities.getAsByteArray((InputStream)inputStream);
                    boolean inMemory = false;
                    String prefix = null;
                    if (entryName.startsWith(rootPackageDir + ZIP_IN_MEMORY)) {
                        inMemory = true;
                        prefix = rootPackageDir + ZIP_IN_MEMORY + File.separatorChar;
                    } else if (entryName.startsWith(rootPackageDir + ZIP_DB)) {
                        inMemory = false;
                        prefix = rootPackageDir + ZIP_DB + File.separatorChar;
                    } else {
                        throw new UtilsException("Entry [" + entryName + "] sconosciuta (Tipologia)");
                    }
                    if (entryName.equals(prefix + ZIP_LAST_MAX_REQUESTS)) {
                        eventoGenericoSerialized = deserializer.readDatiEventoGenerico(content);
                        if (inMemory) {
                            this.inMemoryLastMaxRequests = this.convertToDatiEventoGenerico(eventoGenericoSerialized);
                            continue;
                        }
                        this.dbLastMaxRequests = this.convertDBToDatiEventoGenerico(eventoGenericoSerialized);
                        continue;
                    }
                    if (entryName.equals(prefix + ZIP_LAST_MAX_REQUESTS_WARNING_ONLY)) {
                        eventoGenericoSerialized = deserializer.readDatiEventoGenerico(content);
                        if (inMemory) {
                            this.inMemoryLastMaxRequestsWarningOnly = this.convertToDatiEventoGenerico(eventoGenericoSerialized);
                            continue;
                        }
                        this.dbLastMaxRequestsWarningOnly = this.convertDBToDatiEventoGenerico(eventoGenericoSerialized);
                        continue;
                    }
                    if (entryName.equals(prefix + ZIP_LAST_PDD_CONGESTIONATA)) {
                        eventoGenericoSerialized = deserializer.readDatiEventoGenerico(content);
                        if (inMemory) {
                            this.inMemoryLastPddCongestionata = this.convertToDatiEventoGenerico(eventoGenericoSerialized);
                            continue;
                        }
                        this.dbLastPddCongestionata = this.convertDBToDatiEventoGenerico(eventoGenericoSerialized);
                        continue;
                    }
                    if (entryName.startsWith(prefix + ZIP_POLICY_GLOBALE)) {
                        eventoGenericoSerialized = deserializer.readDatiEventoGenerico(content);
                        if (inMemory) {
                            this.inMemoryLastPolicyGlobaliViolated.put(eventoGenericoSerialized.getIdEvento(), this.convertToDatiEventoGenerico(eventoGenericoSerialized));
                            continue;
                        }
                        this.dbLastPolicyGlobaliViolated.put(eventoGenericoSerialized.getIdEvento(), this.convertDBToDatiEventoGenerico(eventoGenericoSerialized));
                        continue;
                    }
                    if (entryName.startsWith(prefix + ZIP_POLICY_GLOBALE_WARNING_ONLY)) {
                        eventoGenericoSerialized = deserializer.readDatiEventoGenerico(content);
                        if (inMemory) {
                            this.inMemoryLastPolicyGlobaliViolatedWarningOnly.put(eventoGenericoSerialized.getIdEvento(), this.convertToDatiEventoGenerico(eventoGenericoSerialized));
                            continue;
                        }
                        this.dbLastPolicyGlobaliViolatedWarningOnly.put(eventoGenericoSerialized.getIdEvento(), this.convertDBToDatiEventoGenerico(eventoGenericoSerialized));
                        continue;
                    }
                    if (entryName.startsWith(prefix + ZIP_POLICY_API)) {
                        eventoGenericoSerialized = deserializer.readDatiEventoGenerico(content);
                        if (inMemory) {
                            this.inMemoryLastPolicyAPIViolated.put(eventoGenericoSerialized.getIdEvento(), this.convertToDatiEventoGenerico(eventoGenericoSerialized));
                            continue;
                        }
                        this.dbLastPolicyAPIViolated.put(eventoGenericoSerialized.getIdEvento(), this.convertDBToDatiEventoGenerico(eventoGenericoSerialized));
                        continue;
                    }
                    if (entryName.startsWith(prefix + ZIP_POLICY_API_WARNING_ONLY)) {
                        eventoGenericoSerialized = deserializer.readDatiEventoGenerico(content);
                        if (inMemory) {
                            this.inMemoryLastPolicyAPIViolatedWarningOnly.put(eventoGenericoSerialized.getIdEvento(), this.convertToDatiEventoGenerico(eventoGenericoSerialized));
                            continue;
                        }
                        this.dbLastPolicyAPIViolatedWarningOnly.put(eventoGenericoSerialized.getIdEvento(), this.convertDBToDatiEventoGenerico(eventoGenericoSerialized));
                        continue;
                    }
                    if (entryName.startsWith(prefix + ZIP_EVENTO_TIMEOUT_CONNESSIONE)) {
                        eventoGenericoSerialized = deserializer.readDatiEventoGenerico(content);
                        if (inMemory) {
                            this.inMemoryLastTimeoutConnessione.put(eventoGenericoSerialized.getIdEvento(), this.convertToDatiEventoGenerico(eventoGenericoSerialized));
                            continue;
                        }
                        this.dbLastTimeoutConnessione.put(eventoGenericoSerialized.getIdEvento(), this.convertDBToDatiEventoGenerico(eventoGenericoSerialized));
                        continue;
                    }
                    if (entryName.startsWith(prefix + ZIP_EVENTO_TIMEOUT_RICHIESTA)) {
                        eventoGenericoSerialized = deserializer.readDatiEventoGenerico(content);
                        if (inMemory) {
                            this.inMemoryLastTimeoutRichiesta.put(eventoGenericoSerialized.getIdEvento(), this.convertToDatiEventoGenerico(eventoGenericoSerialized));
                            continue;
                        }
                        this.dbLastTimeoutRichiesta.put(eventoGenericoSerialized.getIdEvento(), this.convertDBToDatiEventoGenerico(eventoGenericoSerialized));
                        continue;
                    }
                    if (entryName.startsWith(prefix + ZIP_EVENTO_TIMEOUT_RISPOSTA)) {
                        eventoGenericoSerialized = deserializer.readDatiEventoGenerico(content);
                        if (inMemory) {
                            this.inMemoryLastTimeoutRisposta.put(eventoGenericoSerialized.getIdEvento(), this.convertToDatiEventoGenerico(eventoGenericoSerialized));
                            continue;
                        }
                        this.dbLastTimeoutRisposta.put(eventoGenericoSerialized.getIdEvento(), this.convertDBToDatiEventoGenerico(eventoGenericoSerialized));
                        continue;
                    }
                    throw new UtilsException("Entry [" + entryName + "] sconosciuta");
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            throw new UtilsException("[" + entryName + "] " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (f != null) {
                    Files.delete(f.toPath());
                }
            }
            catch (Exception exception) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private DatiEventoGenerico convertToDatiEventoGenerico(org.openspcoop2.core.eventi.DatiEventoGenerico eventoGenericoSerialized) {
        DatiEventoGenerico e = new DatiEventoGenerico();
        e.data = eventoGenericoSerialized.getData();
        e.datiConsumatiThread = eventoGenericoSerialized.isDatiConsumatiThread();
        e.descrizione = eventoGenericoSerialized.getDescrizione();
        return e;
    }

    private DatabaseDatiEventoGenerico convertDBToDatiEventoGenerico(org.openspcoop2.core.eventi.DatiEventoGenerico eventoGenericoSerialized) {
        DatabaseDatiEventoGenerico e = new DatabaseDatiEventoGenerico();
        e.data = eventoGenericoSerialized.getData();
        e.datiConsumatiThread = eventoGenericoSerialized.isDatiConsumatiThread();
        e.descrizione = eventoGenericoSerialized.getDescrizione();
        if (eventoGenericoSerialized.getCodiceEvento() != null) {
            e.codiceEvento = CodiceEventoControlloTraffico.toEnumConstant((String)eventoGenericoSerialized.getCodiceEvento());
        }
        return e;
    }
}

