/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico;

import org.openspcoop2.core.eventi.constants.TipoEvento;
import org.openspcoop2.pdd.core.controllo_traffico.CategoriaEventoControlloTraffico;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;

public enum TimeoutNotifierType {
    CONNECTION,
    REQUEST,
    WAIT_RESPONSE,
    RECEIVE_RESPONSE;


    public static CategoriaEventoControlloTraffico toCategoriaEventoControlloTraffico(TimeoutNotifierType type) {
        if (type != null) {
            switch (type) {
                case CONNECTION: {
                    return CategoriaEventoControlloTraffico.TIMEOUT_CONNESSIONE;
                }
                case REQUEST: {
                    return CategoriaEventoControlloTraffico.TIMEOUT_RICHIESTA;
                }
                case WAIT_RESPONSE: 
                case RECEIVE_RESPONSE: {
                    return CategoriaEventoControlloTraffico.TIMEOUT_RISPOSTA;
                }
            }
        }
        return CategoriaEventoControlloTraffico.TIMEOUT_RISPOSTA;
    }

    public static TipoEvento toTipoEvento(TimeoutNotifierType type) {
        if (type != null) {
            switch (type) {
                case CONNECTION: {
                    return TipoEvento.CONTROLLO_TRAFFICO_CONNECTION_TIMEOUT;
                }
                case REQUEST: {
                    return TipoEvento.CONTROLLO_TRAFFICO_REQUEST_READ_TIMEOUT;
                }
                case WAIT_RESPONSE: 
                case RECEIVE_RESPONSE: {
                    return TipoEvento.CONTROLLO_TRAFFICO_READ_TIMEOUT;
                }
            }
        }
        return TipoEvento.CONTROLLO_TRAFFICO_READ_TIMEOUT;
    }

    public static EsitoTransazioneName toEsitoTransazioneName(TimeoutNotifierType type) {
        if (type != null) {
            switch (type) {
                case CONNECTION: {
                    return EsitoTransazioneName.ERRORE_CONNECTION_TIMEOUT;
                }
                case REQUEST: {
                    return EsitoTransazioneName.ERRORE_REQUEST_TIMEOUT;
                }
                case WAIT_RESPONSE: 
                case RECEIVE_RESPONSE: {
                    return EsitoTransazioneName.ERRORE_RESPONSE_TIMEOUT;
                }
            }
        }
        return EsitoTransazioneName.ERRORE_RESPONSE_TIMEOUT;
    }
}

