/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.handler;

import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.controllo_traffico.ConfigurazioneGenerale;
import org.openspcoop2.core.controllo_traffico.constants.TipoErrore;
import org.openspcoop2.core.eventi.constants.CodiceEventoControlloTraffico;
import org.openspcoop2.core.eventi.constants.TipoEvento;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.controllo_traffico.CostantiControlloTraffico;
import org.openspcoop2.pdd.core.controllo_traffico.GeneratoreMessaggiErrore;
import org.openspcoop2.pdd.core.controllo_traffico.GestoreControlloTraffico;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.PreInRequestContext;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.connector.messages.ConnectorInMessage;
import org.openspcoop2.utils.transport.Credential;
import org.slf4j.Logger;

public class PreInRequestHandlerGestioneControlloTraffico {
    public void process(PreInRequestContext context) throws HandlerException {
        ConfigurazioneGenerale configurazioneGenerale = null;
        GestoreControlloTraffico gestore = null;
        Boolean maxThreadsEnabled = false;
        Boolean maxThreadsWarningOnly = false;
        Long maxThreads = null;
        Integer threshold = null;
        TipoErrore tipoErrore = TipoErrore.FAULT;
        boolean includiDescrizioneErrore = true;
        Logger logControlloTraffico = null;
        ServiceBinding serviceBinding = ServiceBinding.REST;
        try {
            OpenSPCoop2Properties propertiesReader = OpenSPCoop2Properties.getInstance();
            logControlloTraffico = OpenSPCoop2Logger.getLoggerOpenSPCoopControlloTraffico(propertiesReader.isControlloTrafficoDebug());
            ConfigurazionePdDManager configPdDManager = ConfigurazionePdDManager.getInstance();
            if (configPdDManager == null) {
                throw new CoreException("configPdDManager is null");
            }
            configurazioneGenerale = configPdDManager.getConfigurazioneControlloTraffico(context != null ? context.getRequestInfo() : null);
            if (configurazioneGenerale.getControlloTraffico() == null) {
                throw new CoreException("Impostazione maxThreads non corretta?? ControlloTraffico is null");
            }
            if (context != null && context.getTipoPorta() != null && context.getRequestInfo() != null) {
                if (TipoPdD.DELEGATA.equals((Object)context.getTipoPorta())) {
                    if (context.getRequestInfo().getIntegrationServiceBinding() != null) {
                        serviceBinding = context.getRequestInfo().getIntegrationServiceBinding();
                    }
                } else if (context.getRequestInfo().getProtocolServiceBinding() != null) {
                    serviceBinding = context.getRequestInfo().getProtocolServiceBinding();
                }
            }
            maxThreadsEnabled = configurazioneGenerale.getControlloTraffico().isControlloMaxThreadsEnabled();
            maxThreadsWarningOnly = configurazioneGenerale.getControlloTraffico().isControlloMaxThreadsWarningOnly();
            if (maxThreadsEnabled != null && maxThreadsEnabled.booleanValue()) {
                maxThreads = configurazioneGenerale.getControlloTraffico().getControlloMaxThreadsSoglia();
                if (maxThreads == null || maxThreads <= 0L) {
                    throw new CoreException("Impostazione maxThreads non corretta?? [" + maxThreads + "]");
                }
                if (configurazioneGenerale.getControlloTraffico() != null && configurazioneGenerale.getControlloTraffico().isControlloCongestioneEnabled()) {
                    threshold = configurazioneGenerale.getControlloTraffico().getControlloCongestioneThreshold();
                }
                if (configurazioneGenerale.getControlloTraffico() != null) {
                    TipoErrore tipoErrorTmp;
                    if (configurazioneGenerale.getControlloTraffico().getControlloMaxThreadsTipoErrore() != null && (tipoErrorTmp = TipoErrore.toEnumConstant((String)configurazioneGenerale.getControlloTraffico().getControlloMaxThreadsTipoErrore())) != null) {
                        tipoErrore = tipoErrorTmp;
                    }
                    includiDescrizioneErrore = configurazioneGenerale.getControlloTraffico().isControlloMaxThreadsTipoErroreIncludiDescrizione();
                }
                gestore = GestoreControlloTraffico.getInstance();
            }
        }
        catch (Exception e) {
            throw new HandlerException("Configurazione non disponibile: " + e.getMessage(), e);
        }
        MsgDiagnostico msgDiag = this.buildMsgDiagnostico(context);
        try {
            if (maxThreadsEnabled != null && maxThreadsEnabled.booleanValue()) {
                context.getPddContext().addObject(GeneratoreMessaggiErrore.PDD_CONTEXT_MAX_THREADS_THRESHOLD, maxThreads);
                if (threshold != null) {
                    context.getPddContext().addObject(GeneratoreMessaggiErrore.PDD_CONTEXT_CONTROLLO_TRAFFICO_THRESHOLD, threshold);
                }
                gestore.addThread(serviceBinding, maxThreads, threshold, maxThreadsWarningOnly, context.getPddContext(), msgDiag, tipoErrore, includiDescrizioneErrore, logControlloTraffico);
                context.getPddContext().addObject(CostantiControlloTraffico.PDD_CONTEXT_MAX_REQUEST_THREAD_REGISTRATO, true);
            }
        }
        catch (Exception e) {
            if (maxThreadsWarningOnly != null && maxThreadsWarningOnly.booleanValue()) {
                context.getPddContext().addObject(CostantiControlloTraffico.PDD_CONTEXT_MAX_REQUEST_THREAD_REGISTRATO, true);
                context.getPddContext().addObject(CostantiControlloTraffico.PDD_CONTEXT_MAX_REQUEST_VIOLATED_EVENTO, TipoEvento.CONTROLLO_TRAFFICO_NUMERO_MASSIMO_RICHIESTE_SIMULTANEE.getValue() + "_" + CodiceEventoControlloTraffico.VIOLAZIONE_WARNING_ONLY.getValue());
            }
            try {
                GestoreControlloTraffico.getInstance().removeThread(context.getPddContext());
            }
            catch (Exception tipoErrorTmp) {
                // empty catch block
            }
            context.getPddContext().addObject(CostantiControlloTraffico.PDD_CONTEXT_MAX_REQUEST_THREAD_REGISTRATO, false);
            context.getPddContext().addObject(CostantiControlloTraffico.PDD_CONTEXT_MAX_REQUEST_VIOLATED_EVENTO, TipoEvento.CONTROLLO_TRAFFICO_NUMERO_MASSIMO_RICHIESTE_SIMULTANEE.getValue() + "_" + CodiceEventoControlloTraffico.VIOLAZIONE.getValue());
            ConnectorInMessage req = null;
            try {
                req = (ConnectorInMessage)context.getTransportContext().get("SERVLET_REQUEST");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (req != null) {
                try {
                    Object urlInvocazione = req.getURLProtocolContext().getUrlInvocazione_formBased();
                    if (urlInvocazione != null) {
                        if (req.getURLProtocolContext().getFunction() != null) {
                            urlInvocazione = "[" + req.getURLProtocolContext().getFunction() + "] " + (String)urlInvocazione;
                        }
                        context.getPddContext().addObject(CostantiControlloTraffico.PDD_CONTEXT_MAX_REQUEST_VIOLATED_URL_INVOCAZIONE, urlInvocazione);
                    }
                }
                catch (Exception urlInvocazione) {
                    // empty catch block
                }
                try {
                    Credential credenziali = req.getCredential();
                    String credenzialiFornite = "";
                    if (credenziali != null) {
                        credenzialiFornite = credenziali.toString();
                        context.getPddContext().addObject(CostantiControlloTraffico.PDD_CONTEXT_MAX_REQUEST_VIOLATED_CREDENZIALI, credenzialiFornite);
                    }
                }
                catch (Exception credenziali) {
                    // empty catch block
                }
            }
            if (e instanceof HandlerException) {
                throw (HandlerException)e;
            }
            try {
                logControlloTraffico.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception eLog) {
                context.getLogCore().error(e.getMessage(), (Throwable)e);
            }
            GeneratoreMessaggiErrore.addPddContextInfoControlloTrafficoGenericError(context.getPddContext());
            throw GeneratoreMessaggiErrore.getErroreProcessamento(e, context.getPddContext());
        }
    }

    private MsgDiagnostico buildMsgDiagnostico(PreInRequestContext context) throws HandlerException {
        try {
            String nomePorta = null;
            if (context.getRequestInfo() != null && context.getRequestInfo().getProtocolContext() != null) {
                nomePorta = context.getRequestInfo().getProtocolContext().getInterfaceName();
            }
            MsgDiagnostico msgDiag = MsgDiagnostico.newInstance(context.getTipoPorta(), context.getIdModulo(), nomePorta, context.getRequestInfo());
            msgDiag.setPddContext(context.getPddContext(), context.getProtocolFactory());
            if (TipoPdD.DELEGATA.equals((Object)context.getTipoPorta())) {
                msgDiag.setPrefixMsgPersonalizzati("ricezioneContenutiApplicativi.");
            } else {
                msgDiag.setPrefixMsgPersonalizzati("ricezioneBuste.");
            }
            return msgDiag;
        }
        catch (Exception e) {
            throw new HandlerException("Generazione Messaggio Diagnostico non riuscita: " + e.getMessage(), e);
        }
    }
}

