/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicyFiltro;
import org.openspcoop2.core.controllo_traffico.beans.DatiTransazione;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicy;
import org.openspcoop2.core.controllo_traffico.beans.RisultatoStatistico;
import org.openspcoop2.core.controllo_traffico.beans.RisultatoStato;
import org.openspcoop2.core.controllo_traffico.constants.TipoBanda;
import org.openspcoop2.core.controllo_traffico.constants.TipoFinestra;
import org.openspcoop2.core.controllo_traffico.constants.TipoLatenza;
import org.openspcoop2.core.controllo_traffico.constants.TipoPeriodoStatistico;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsa;
import org.openspcoop2.core.controllo_traffico.utils.PolicyUtilities;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.core.cache.CacheEntry;
import org.openspcoop2.pdd.core.controllo_traffico.ConfigurazioneGatewayControlloTraffico;
import org.openspcoop2.pdd.core.controllo_traffico.INotify;
import org.openspcoop2.pdd.core.controllo_traffico.policy.DatiStatisticiDAOManager;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.cache.CacheAlgorithm;
import org.openspcoop2.utils.cache.CacheResponse;
import org.openspcoop2.utils.cache.CacheType;
import org.openspcoop2.utils.date.DateUtils;
import org.slf4j.Logger;

public class GestoreCacheControlloTraffico {
    private static final String CONTROLLO_TRAFFICO_CACHE_NAME = "controlloTraffico";
    private static Cache cache = null;
    private static final Semaphore lockNumeroEsiti = new Semaphore("GestoreCacheControlloTraffico-NumeroEsiti");
    private static final Semaphore lockNumeroRichieste = new Semaphore("GestoreCacheControlloTraffico-NumeroRichieste");
    private static final Semaphore lockOccupazioneBanda = new Semaphore("GestoreCacheControlloTraffico-OccupazioneBanda");
    private static final Semaphore lockLatenza = new Semaphore("GestoreCacheControlloTraffico-Latenza");
    private static final Semaphore lockStato = new Semaphore("GestoreCacheControlloTraffico-Stato");
    private static GestoreCacheControlloTraffico staticInstance = null;
    private DatiStatisticiDAOManager datiStatisticiReader = DatiStatisticiDAOManager.getInstance();
    private INotify datiNotifierReader = null;
    private Logger log;
    private boolean debug;
    private ConfigurazioneGatewayControlloTraffico configurazioneControlloTraffico;

    public static boolean isCacheAbilitata() throws Exception {
        return cache != null;
    }

    public static void resetCache() throws Exception {
        try {
            if (cache != null) {
                cache.clear();
            }
        }
        catch (Exception e) {
            throw new Exception("Reset della cache per i dati sul controllo del traffico non riuscita: " + e.getMessage(), e);
        }
    }

    public static String printStatsCache(String separator) throws Exception {
        try {
            if (cache != null) {
                try {
                    return cache.printStats(separator);
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage(), e);
                }
            }
            throw new Exception("Cache non abilitata");
        }
        catch (Exception e) {
            throw new Exception("Visualizzazione Statistiche riguardante la cache per i dati sul controllo del traffico non riuscita: " + e.getMessage(), e);
        }
    }

    public static void abilitaCache() throws Exception {
        try {
            if (cache != null) {
                throw new Exception("Cache gia' abilitata");
            }
            GestoreCacheControlloTraffico._abilitaCache();
        }
        catch (Exception e) {
            throw new Exception("Abilitazione cache per i dati sul controllo del traffico non riuscita: " + e.getMessage(), e);
        }
    }

    private static synchronized void _abilitaCache() throws Exception {
        try {
            if (cache == null) {
                cache = new Cache(CacheType.JCS, CONTROLLO_TRAFFICO_CACHE_NAME);
                cache.build();
            }
        }
        catch (Exception e) {
            throw new Exception("Abilitazione cache per i dati sul controllo del traffico non riuscita: " + e.getMessage(), e);
        }
    }

    public static void abilitaCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond, Logger log) throws Exception {
        try {
            if (cache != null) {
                throw new Exception("Cache gia' abilitata");
            }
            int dimensione = -1;
            if (dimensioneCache != null) {
                dimensione = dimensioneCache.intValue();
            }
            GestoreCacheControlloTraffico.initCache(CacheType.JCS, dimensione, algoritmoCacheLRU, itemIdleTime, itemLifeSecond, log);
        }
        catch (Exception e) {
            throw new Exception("Abilitazione cache per i dati sul controllo del traffico non riuscita: " + e.getMessage(), e);
        }
    }

    public static void disabilitaCache() throws Exception {
        try {
            if (cache == null) {
                throw new Exception("Cache gia' disabilitata");
            }
            GestoreCacheControlloTraffico._disabilitaCache();
        }
        catch (Exception e) {
            throw new Exception("Disabilitazione cache per i dati sul controllo del traffico non riuscita: " + e.getMessage(), e);
        }
    }

    private static synchronized void _disabilitaCache() throws Exception {
        try {
            if (cache != null) {
                cache.clear();
                cache = null;
            }
        }
        catch (Exception e) {
            throw new Exception("Disabilitazione cache per i dati sul controllo del traffico non riuscita: " + e.getMessage(), e);
        }
    }

    public static String listKeysCache(String separator) throws Exception {
        try {
            if (cache != null) {
                try {
                    return cache.printKeys(separator);
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage(), e);
                }
            }
            throw new Exception("Cache non abilitata");
        }
        catch (Exception e) {
            throw new Exception("Visualizzazione chiavi presenti nella cache per i dati sul controllo del traffico non riuscita: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getObjectCache(String key) throws Exception {
        if (cache == null) throw new Exception("Cache non abilitata");
        try {
            Object o = cache.get(key);
            if (o == null) return "oggetto con chiave [" + key + "] non presente";
            return o.toString();
        }
        catch (Exception e) {
            try {
                throw new Exception(e.getMessage(), e);
            }
            catch (Exception e2) {
                throw new Exception("Visualizzazione oggetto presente nella cache per i dati sul controllo del traffico non riuscita: " + e2.getMessage(), e2);
            }
        }
    }

    public static void removeObjectCache(String key) throws Exception {
        block5: {
            try {
                if (cache != null) {
                    try {
                        cache.remove(key);
                        break block5;
                    }
                    catch (Exception e) {
                        throw new Exception(e.getMessage(), e);
                    }
                }
                throw new Exception("Cache non abilitata");
            }
            catch (Exception e) {
                throw new Exception("Rimozione oggetto presente nella cache per i dati sul controllo del traffico non riuscita: " + e.getMessage(), e);
            }
        }
    }

    public static void initializeCache(CacheType cacheType, Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond, Logger log) throws Exception {
        int dimensione = -1;
        if (dimensioneCache != null) {
            dimensione = dimensioneCache.intValue();
        }
        GestoreCacheControlloTraffico.initCache(cacheType, dimensione, algoritmoCacheLRU, itemIdleTime, itemLifeSecond, log);
    }

    private static void initCache(CacheType cacheType, Integer dimensioneCache, boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond, Logger alog) throws Exception {
        Object msg;
        cache = new Cache(cacheType, CONTROLLO_TRAFFICO_CACHE_NAME);
        if (dimensioneCache != null && dimensioneCache > 0) {
            try {
                msg = "Dimensione della cache (ControlloTraffico) impostata al valore: " + dimensioneCache;
                alog.info((String)msg);
                cache.setCacheSize(dimensioneCache.intValue());
            }
            catch (Exception error) {
                String msg2 = "Parametro errato per la dimensione della cache (ControlloTraffico): " + error.getMessage();
                alog.error(msg2);
                throw new Exception(msg2, error);
            }
        }
        msg = "Algoritmo di cache (ControlloTraffico) impostato al valore: LRU";
        if (!algoritmoCacheLRU) {
            msg = "Algoritmo di cache (ControlloTraffico) impostato al valore: MRU";
        }
        alog.info((String)msg);
        if (!algoritmoCacheLRU) {
            cache.setCacheAlgoritm(CacheAlgorithm.MRU);
        } else {
            cache.setCacheAlgoritm(CacheAlgorithm.LRU);
        }
        if (itemIdleTime != null && itemIdleTime > 0L) {
            try {
                msg = "Attributo 'IdleTime' (ControlloTraffico) impostato al valore: " + itemIdleTime;
                alog.info((String)msg);
                cache.setItemIdleTime(itemIdleTime.longValue());
            }
            catch (Exception error) {
                msg = "Parametro errato per l'attributo 'IdleTime' (ControlloTraffico): " + error.getMessage();
                alog.error((String)msg);
                throw new Exception((String)msg, error);
            }
        }
        long longItemLife = -1L;
        if (itemLifeSecond != null && itemLifeSecond > 0L) {
            longItemLife = itemLifeSecond;
        }
        try {
            msg = "Attributo 'MaxLifeSecond' (ControlloTraffico) impostato al valore: " + longItemLife;
            alog.info((String)msg);
            cache.setItemLifeTime(longItemLife);
        }
        catch (Exception error) {
            msg = "Parametro errato per l'attributo 'MaxLifeSecond' (ControlloTraffico): " + error.getMessage();
            alog.error((String)msg);
            throw new Exception((String)msg, error);
        }
        cache.build();
    }

    @Deprecated
    public static void disableSyncronizedGet() throws UtilsException {
        if (cache == null) {
            throw new UtilsException("Cache disabled");
        }
        cache.disableSyncronizedGet();
    }

    @Deprecated
    public static boolean isDisableSyncronizedGet() throws UtilsException {
        if (cache == null) {
            throw new UtilsException("Cache disabled");
        }
        return cache.isDisableSyncronizedGet();
    }

    public static synchronized void initialize(ConfigurazioneGatewayControlloTraffico configurazioneControlloTraffico) throws CoreException {
        if (staticInstance == null) {
            staticInstance = new GestoreCacheControlloTraffico(configurazioneControlloTraffico);
        }
    }

    public static GestoreCacheControlloTraffico getInstance() throws CoreException {
        if (staticInstance == null) {
            Class<GestoreCacheControlloTraffico> clazz = GestoreCacheControlloTraffico.class;
            synchronized (GestoreCacheControlloTraffico.class) {
                throw new CoreException("GestoreCacheControlloTraffico non inizializzato");
            }
        }
        return staticInstance;
    }

    private GestoreCacheControlloTraffico(ConfigurazioneGatewayControlloTraffico configurazioneControlloTraffico) throws CoreException {
        if (configurazioneControlloTraffico.isNotifierEnabled()) {
            this.datiNotifierReader = configurazioneControlloTraffico.getNotifier();
        }
        this.configurazioneControlloTraffico = configurazioneControlloTraffico;
        this.debug = this.configurazioneControlloTraffico.isDebug();
        this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopControlloTraffico(this.debug);
    }

    public RisultatoStatistico readNumeroEsiti(TipoPeriodoStatistico tipoPeriodo, Integer periodLength, Date endDate, List<Integer> esiti, IDServizio servizio, IDSoggetto mittente, List<String> ignoreOperations, DatiTransazione datiTransazione, IState state, Integer lifetimeSecond) throws Exception {
        SimpleDateFormat dateformat;
        switch (tipoPeriodo) {
            case ORARIO: {
                dateformat = DateUtils.getSimpleDateFormatHour();
                break;
            }
            case GIORNALIERO: {
                dateformat = DateUtils.getSimpleDateFormatDay();
                break;
            }
            case SETTIMANALE: {
                dateformat = DateUtils.getSimpleDateFormatDay();
                break;
            }
            case MENSILE: {
                dateformat = DateUtils.getSimpleDateFormatDay();
                break;
            }
            default: {
                dateformat = DateUtils.getSimpleDateFormatDay();
            }
        }
        StringBuilder bfKey = new StringBuilder(servizio.toString());
        if (ignoreOperations != null) {
            Collections.sort(ignoreOperations);
            bfKey.append("~" + ignoreOperations);
        }
        bfKey.append((String)(mittente == null ? "" : " " + mittente));
        bfKey.append((String)(esiti == null ? "" : " " + String.join((CharSequence)",", esiti.stream().map(Object::toString).collect(Collectors.toList()))));
        bfKey.append(" [").append(dateformat.format(endDate));
        bfKey.append("-").append(periodLength).append(" ").append(tipoPeriodo).append("]");
        String key = bfKey.toString();
        RisultatoStatistico risultato = null;
        risultato = cache != null ? this.readNumeroEsiti(key, tipoPeriodo, periodLength, endDate, esiti, servizio, mittente, ignoreOperations, datiTransazione, state, lifetimeSecond) : this.datiStatisticiReader.readNumeroEsiti(key, tipoPeriodo, periodLength, endDate, esiti, servizio, mittente, ignoreOperations, datiTransazione, state);
        return risultato;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RisultatoStatistico readNumeroEsiti(String keyCache, TipoPeriodoStatistico tipoPeriodo, Integer periodLength, Date endDate, List<Integer> esiti, IDServizio servizio, IDSoggetto mittente, List<String> ignoreOperations, DatiTransazione datiTransazione, IState state, Integer lifetimeSecond) throws Exception {
        RisultatoStatistico obj = null;
        try {
            CacheResponse response;
            if (keyCache == null) {
                throw new Exception("KeyCache non definita");
            }
            if (cache != null && (response = (CacheResponse)cache.get(keyCache)) != null) {
                if (response.getObject() != null) {
                    this.log.debug("Oggetto (tipo:{}) con chiave [{}] valore[{}] in cache.", new Object[]{response.getObject().getClass().getName(), keyCache, response.getObject()});
                    CacheEntry entry = (CacheEntry)response.getObject();
                    if (entry.isValid()) {
                        return (RisultatoStatistico)entry.getObject();
                    }
                } else {
                    if (response.getException() != null) {
                        this.log.debug("Eccezione (tipo:{}) con chiave [{}]", (Object)response.getException().getClass().getName().concat(keyCache), (Object)keyCache);
                        throw (Exception)response.getException();
                    }
                    this.log.error("In cache non e' presente ne un oggetto ne un'eccezione.");
                }
            }
            String idTransazione = datiTransazione != null ? datiTransazione.getIdTransazione() : null;
            SemaphoreLock lock = lockNumeroEsiti.acquire("readNumeroEsitiInCache", idTransazione);
            try {
                CacheResponse response2;
                if (cache != null && (response2 = (CacheResponse)cache.get(keyCache)) != null) {
                    if (response2.getObject() != null) {
                        this.log.debug("Oggetto (tipo:{}) con chiave [{}] valore[{}] in cache.", new Object[]{response2.getObject().getClass().getName(), keyCache, response2.getObject()});
                        CacheEntry entry = (CacheEntry)response2.getObject();
                        if (entry.isValid()) {
                            RisultatoStatistico risultatoStatistico = (RisultatoStatistico)entry.getObject();
                            return risultatoStatistico;
                        }
                    } else {
                        if (response2.getException() != null) {
                            this.log.debug("Eccezione (tipo:{}) con chiave [{}] in cache.", (Object)response2.getException().getClass().getName(), (Object)keyCache);
                            throw (Exception)response2.getException();
                        }
                        this.log.error("In cache non e' presente ne un oggetto ne un'eccezione.");
                    }
                }
                this.log.debug("oggetto con chiave [{}] non in cache, effettuo ricerca...", (Object)keyCache);
                obj = this.datiStatisticiReader.readNumeroEsiti(keyCache, tipoPeriodo, periodLength, endDate, esiti, servizio, mittente, ignoreOperations, datiTransazione, state);
                if (cache == null) return obj;
                if (obj == null) throw new Exception("Ricerca ha ritornato un valore null");
                this.log.debug("Aggiungo oggetto con chiave [{}] valore[{}] in cache", (Object)keyCache, (Object)obj);
                try {
                    CacheResponse responseCache = new CacheResponse();
                    responseCache.setObject(new CacheEntry<RisultatoStatistico>(obj, (long)lifetimeSecond.intValue() * 1000L));
                    cache.put(keyCache, responseCache);
                    return obj;
                }
                catch (UtilsException e) {
                    this.log.error("Errore durante l'inserimento in cache con chiave [{}] valore[{}]: {}", new Object[]{keyCache, obj, e.getMessage()});
                    return obj;
                }
            }
            finally {
                lockNumeroEsiti.release(lock, "readNumeroEsitiInCache", idTransazione);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new Exception("NumeroEsiti, Algoritmo di Cache fallito: " + e.getMessage(), e);
        }
    }

    public RisultatoStatistico readNumeroRichieste(TipoRisorsa tipoRisorsa, Date leftInterval, Date rightInterval, TipoFinestra tipoFinestra, TipoPeriodoStatistico tipoPeriodo, DatiTransazione datiTransazione, IDUnivocoGroupByPolicy groupByPolicy, AttivazionePolicyFiltro filtro, IState state, RequestInfo requestInfo, IProtocolFactory<?> protocolFactory) throws Exception {
        SimpleDateFormat dateformat = DateUtils.getSimpleDateFormatMs();
        TipoPdD tipoPdDTransazioneInCorso = datiTransazione.getTipoPdD();
        StringBuilder bfKey = new StringBuilder(tipoRisorsa.getValue() + " ");
        bfKey.append(tipoFinestra.getValue());
        bfKey.append(" ").append(tipoPeriodo.getValue());
        bfKey.append(" ").append(tipoPdDTransazioneInCorso.getTipo());
        bfKey.append(" [").append(dateformat.format(leftInterval)).append("]");
        bfKey.append("-[").append(dateformat.format(rightInterval)).append("]");
        bfKey.append(" GroupBy ");
        bfKey.append(groupByPolicy.toString());
        if (filtro != null && filtro.isEnabled()) {
            bfKey.append(" Filtro ");
            bfKey.append(PolicyUtilities.toStringFilter((AttivazionePolicyFiltro)filtro));
        }
        String key = bfKey.toString();
        RisultatoStatistico risultato = null;
        risultato = cache != null ? this.readNumeroRichiesteInCache(key, tipoRisorsa, tipoFinestra, tipoPeriodo, leftInterval, rightInterval, datiTransazione, groupByPolicy, filtro, state, requestInfo, protocolFactory) : this.datiStatisticiReader.readNumeroRichieste(key, tipoRisorsa, tipoFinestra, tipoPeriodo, leftInterval, rightInterval, datiTransazione, groupByPolicy, filtro, state, requestInfo, protocolFactory);
        return risultato;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RisultatoStatistico readNumeroRichiesteInCache(String keyCache, TipoRisorsa tipoRisorsa, TipoFinestra tipoFinestra, TipoPeriodoStatistico tipoPeriodo, Date leftInterval, Date rightInterval, DatiTransazione datiTransazione, IDUnivocoGroupByPolicy groupByPolicy, AttivazionePolicyFiltro filtro, IState state, RequestInfo requestInfo, IProtocolFactory<?> protocolFactory) throws Exception {
        RisultatoStatistico obj = null;
        try {
            CacheResponse response;
            if (keyCache == null) {
                throw new Exception("KeyCache non definita");
            }
            if (cache != null && (response = (CacheResponse)cache.get(keyCache)) != null) {
                if (response.getObject() != null) {
                    this.log.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] valore[" + response.getObject() + "] in cache.");
                    return (RisultatoStatistico)response.getObject();
                }
                if (response.getException() != null) {
                    this.log.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] in cache.");
                    throw (Exception)response.getException();
                }
                this.log.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            String idTransazione = datiTransazione != null ? datiTransazione.getIdTransazione() : null;
            SemaphoreLock lock = lockNumeroRichieste.acquire("readNumeroRichiesteInCache", idTransazione);
            try {
                CacheResponse response2;
                if (cache != null && (response2 = (CacheResponse)cache.get(keyCache)) != null) {
                    if (response2.getObject() != null) {
                        this.log.debug("Oggetto (tipo:" + response2.getObject().getClass().getName() + ") con chiave [" + keyCache + "] valore[" + response2.getObject() + "] in cache.");
                        RisultatoStatistico risultatoStatistico = (RisultatoStatistico)response2.getObject();
                        return risultatoStatistico;
                    }
                    if (response2.getException() != null) {
                        this.log.debug("Eccezione (tipo:" + response2.getException().getClass().getName() + ") con chiave [" + keyCache + "] in cache.");
                        throw (Exception)response2.getException();
                    }
                    this.log.error("In cache non e' presente ne un oggetto ne un'eccezione.");
                }
                this.log.debug("oggetto con chiave [" + keyCache + "] non in cache, effettuo ricerca...");
                obj = this.datiStatisticiReader.readNumeroRichieste(keyCache, tipoRisorsa, tipoFinestra, tipoPeriodo, leftInterval, rightInterval, datiTransazione, groupByPolicy, filtro, state, requestInfo, protocolFactory);
                if (cache == null) return obj;
                if (obj == null) throw new Exception("Ricerca ha ritornato un valore null");
                this.log.debug("Aggiungo oggetto con chiave [" + keyCache + "] valore[" + obj + "] in cache");
                try {
                    CacheResponse responseCache = new CacheResponse();
                    responseCache.setObject((Serializable)obj);
                    cache.put(keyCache, responseCache);
                    return obj;
                }
                catch (UtilsException e) {
                    this.log.error("Errore durante l'inserimento in cache con chiave [" + keyCache + "] valore[" + obj + "]: " + e.getMessage());
                    return obj;
                }
            }
            finally {
                lockNumeroRichieste.release(lock, "readNumeroRichiesteInCache", idTransazione);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new Exception("NumeroRichieste, Algoritmo di Cache fallito: " + e.getMessage(), e);
        }
    }

    public RisultatoStatistico readOccupazioneBanda(TipoRisorsa tipoRisorsa, Date leftInterval, Date rightInterval, TipoFinestra tipoFinestra, TipoPeriodoStatistico tipoPeriodo, TipoBanda tipoBanda, DatiTransazione datiTransazione, IDUnivocoGroupByPolicy groupByPolicy, AttivazionePolicyFiltro filtro, IState state, RequestInfo requestInfo, IProtocolFactory<?> protocolFactory) throws Exception {
        SimpleDateFormat dateformat = DateUtils.getSimpleDateFormatMs();
        TipoPdD tipoPdDTransazioneInCorso = datiTransazione.getTipoPdD();
        StringBuilder bfKey = new StringBuilder(tipoRisorsa.getValue() + " ");
        bfKey.append(tipoFinestra.getValue());
        bfKey.append(" ").append(tipoPeriodo.getValue());
        bfKey.append(" ").append(tipoBanda.getValue());
        bfKey.append(" ").append(tipoPdDTransazioneInCorso.getTipo());
        bfKey.append(" [").append(dateformat.format(leftInterval)).append("]");
        bfKey.append("-[").append(dateformat.format(rightInterval)).append("]");
        bfKey.append(" GroupBy ");
        bfKey.append(groupByPolicy.toString());
        if (filtro != null && filtro.isEnabled()) {
            bfKey.append(" Filtro ");
            bfKey.append(PolicyUtilities.toStringFilter((AttivazionePolicyFiltro)filtro));
        }
        String key = bfKey.toString();
        RisultatoStatistico risultato = null;
        risultato = cache != null ? this.readOccupazioneBandaInCache(key, tipoRisorsa, tipoFinestra, tipoPeriodo, leftInterval, rightInterval, tipoBanda, datiTransazione, groupByPolicy, filtro, state, requestInfo, protocolFactory) : this.datiStatisticiReader.readOccupazioneBanda(key, tipoRisorsa, tipoFinestra, tipoPeriodo, leftInterval, rightInterval, tipoBanda, datiTransazione, groupByPolicy, filtro, state, requestInfo, protocolFactory);
        return risultato;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RisultatoStatistico readOccupazioneBandaInCache(String keyCache, TipoRisorsa tipoRisorsa, TipoFinestra tipoFinestra, TipoPeriodoStatistico tipoPeriodo, Date leftInterval, Date rightInterval, TipoBanda tipoBanda, DatiTransazione datiTransazione, IDUnivocoGroupByPolicy groupByPolicy, AttivazionePolicyFiltro filtro, IState state, RequestInfo requestInfo, IProtocolFactory<?> protocolFactory) throws Exception {
        RisultatoStatistico obj = null;
        try {
            CacheResponse response;
            if (keyCache == null) {
                throw new Exception("KeyCache non definita");
            }
            if (cache != null && (response = (CacheResponse)cache.get(keyCache)) != null) {
                if (response.getObject() != null) {
                    this.log.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] valore[" + response.getObject() + "] in cache.");
                    return (RisultatoStatistico)response.getObject();
                }
                if (response.getException() != null) {
                    this.log.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] in cache.");
                    throw (Exception)response.getException();
                }
                this.log.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            String idTransazione = datiTransazione != null ? datiTransazione.getIdTransazione() : null;
            SemaphoreLock lock = lockOccupazioneBanda.acquire("readOccupazioneBandaInCache", idTransazione);
            try {
                CacheResponse response2;
                if (cache != null && (response2 = (CacheResponse)cache.get(keyCache)) != null) {
                    if (response2.getObject() != null) {
                        this.log.debug("Oggetto (tipo:" + response2.getObject().getClass().getName() + ") con chiave [" + keyCache + "] valore[" + response2.getObject() + "] in cache.");
                        RisultatoStatistico risultatoStatistico = (RisultatoStatistico)response2.getObject();
                        return risultatoStatistico;
                    }
                    if (response2.getException() != null) {
                        this.log.debug("Eccezione (tipo:" + response2.getException().getClass().getName() + ") con chiave [" + keyCache + "] in cache.");
                        throw (Exception)response2.getException();
                    }
                    this.log.error("In cache non e' presente ne un oggetto ne un'eccezione.");
                }
                this.log.debug("oggetto con chiave [" + keyCache + "] non in cache, effettuo ricerca...");
                obj = this.datiStatisticiReader.readOccupazioneBanda(keyCache, tipoRisorsa, tipoFinestra, tipoPeriodo, leftInterval, rightInterval, tipoBanda, datiTransazione, groupByPolicy, filtro, state, requestInfo, protocolFactory);
                if (cache == null) return obj;
                if (obj == null) throw new Exception("Ricerca ha ritornato un valore null");
                this.log.debug("Aggiungo oggetto con chiave [" + keyCache + "] valore[" + obj + "] in cache");
                try {
                    CacheResponse responseCache = new CacheResponse();
                    responseCache.setObject((Serializable)obj);
                    cache.put(keyCache, responseCache);
                    return obj;
                }
                catch (UtilsException e) {
                    this.log.error("Errore durante l'inserimento in cache con chiave [" + keyCache + "] valore[" + obj + "]: " + e.getMessage());
                    return obj;
                }
            }
            finally {
                lockOccupazioneBanda.release(lock, "readOccupazioneBandaInCache", idTransazione);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new Exception("OccupazioneBanda, Algoritmo di Cache fallito: " + e.getMessage(), e);
        }
    }

    public RisultatoStatistico readLatenza(TipoRisorsa tipoRisorsa, Date leftInterval, Date rightInterval, TipoFinestra tipoFinestra, TipoPeriodoStatistico tipoPeriodo, TipoLatenza tipoLatenza, DatiTransazione datiTransazione, IDUnivocoGroupByPolicy groupByPolicy, AttivazionePolicyFiltro filtro, IState state, RequestInfo requestInfo, IProtocolFactory<?> protocolFactory) throws Exception {
        SimpleDateFormat dateformat = DateUtils.getSimpleDateFormatMs();
        TipoPdD tipoPdDTransazioneInCorso = datiTransazione.getTipoPdD();
        StringBuilder bfKey = null;
        bfKey = new StringBuilder(tipoRisorsa.getValue() + " ");
        bfKey.append(tipoFinestra.getValue());
        bfKey.append(" ").append(tipoPeriodo.getValue());
        bfKey.append(" ").append(tipoLatenza.getValue());
        bfKey.append(" ").append(tipoPdDTransazioneInCorso.getTipo());
        bfKey.append(" [").append(dateformat.format(leftInterval)).append("]");
        bfKey.append("-[").append(dateformat.format(rightInterval)).append("]");
        bfKey.append(" GroupBy ");
        bfKey.append(groupByPolicy.toString());
        if (filtro != null && filtro.isEnabled()) {
            bfKey.append(" Filtro ");
            bfKey.append(PolicyUtilities.toStringFilter((AttivazionePolicyFiltro)filtro));
        }
        String key = bfKey.toString();
        RisultatoStatistico risultato = null;
        risultato = cache != null ? this.readLatenzaInCache(key, tipoRisorsa, tipoFinestra, tipoPeriodo, leftInterval, rightInterval, tipoLatenza, datiTransazione, groupByPolicy, filtro, state, requestInfo, protocolFactory) : this.datiStatisticiReader.readLatenza(key, tipoRisorsa, tipoFinestra, tipoPeriodo, leftInterval, rightInterval, tipoLatenza, datiTransazione, groupByPolicy, filtro, state, requestInfo, protocolFactory);
        return risultato;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RisultatoStatistico readLatenzaInCache(String keyCache, TipoRisorsa tipoRisorsa, TipoFinestra tipoFinestra, TipoPeriodoStatistico tipoPeriodo, Date leftInterval, Date rightInterval, TipoLatenza tipoLatenza, DatiTransazione datiTransazione, IDUnivocoGroupByPolicy groupByPolicy, AttivazionePolicyFiltro filtro, IState state, RequestInfo requestInfo, IProtocolFactory<?> protocolFactory) throws Exception {
        RisultatoStatistico obj = null;
        try {
            CacheResponse response;
            if (keyCache == null) {
                throw new Exception("KeyCache non definita");
            }
            if (cache != null && (response = (CacheResponse)cache.get(keyCache)) != null) {
                if (response.getObject() != null) {
                    this.log.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] valore[" + response.getObject() + "] in cache.");
                    return (RisultatoStatistico)response.getObject();
                }
                if (response.getException() != null) {
                    this.log.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] in cache.");
                    throw (Exception)response.getException();
                }
                this.log.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            String idTransazione = datiTransazione != null ? datiTransazione.getIdTransazione() : null;
            SemaphoreLock lock = lockLatenza.acquire("readLatenzaInCache", idTransazione);
            try {
                CacheResponse response2;
                if (cache != null && (response2 = (CacheResponse)cache.get(keyCache)) != null) {
                    if (response2.getObject() != null) {
                        this.log.debug("Oggetto (tipo:" + response2.getObject().getClass().getName() + ") con chiave [" + keyCache + "] valore[" + response2.getObject() + "] in cache.");
                        RisultatoStatistico risultatoStatistico = (RisultatoStatistico)response2.getObject();
                        return risultatoStatistico;
                    }
                    if (response2.getException() != null) {
                        this.log.debug("Eccezione (tipo:" + response2.getException().getClass().getName() + ") con chiave [" + keyCache + "] in cache.");
                        throw (Exception)response2.getException();
                    }
                    this.log.error("In cache non e' presente ne un oggetto ne un'eccezione.");
                }
                this.log.debug("oggetto con chiave [" + keyCache + "] non in cache, effettuo ricerca...");
                obj = this.datiStatisticiReader.readLatenza(keyCache, tipoRisorsa, tipoFinestra, tipoPeriodo, leftInterval, rightInterval, tipoLatenza, datiTransazione, groupByPolicy, filtro, state, requestInfo, protocolFactory);
                if (cache == null) return obj;
                if (obj == null) throw new Exception("Ricerca ha ritornato un valore null");
                this.log.debug("Aggiungo oggetto con chiave [" + keyCache + "] valore[" + obj + "] in cache");
                try {
                    CacheResponse responseCache = new CacheResponse();
                    responseCache.setObject((Serializable)obj);
                    cache.put(keyCache, responseCache);
                    return obj;
                }
                catch (UtilsException e) {
                    this.log.error("Errore durante l'inserimento in cache con chiave [" + keyCache + "] valore[" + obj + "]: " + e.getMessage());
                    return obj;
                }
            }
            finally {
                lockLatenza.release(lock, "readLatenzaInCache", idTransazione);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new Exception("Latenza, Algoritmo di Cache fallito: " + e.getMessage(), e);
        }
    }

    public RisultatoStato getStato(DatiTransazione datiTransazione, IState state, String nomeAllarme) throws Exception {
        StringBuilder bfKey = new StringBuilder("Stato ");
        bfKey.append(nomeAllarme);
        String key = bfKey.toString();
        if (cache != null) {
            return this.getStatoInCache(key, datiTransazione, state, nomeAllarme);
        }
        return this.datiNotifierReader.getStato(this.log, datiTransazione, state, nomeAllarme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RisultatoStato getStatoInCache(String keyCache, DatiTransazione datiTransazione, IState state, String nomeAllarme) throws Exception {
        RisultatoStato obj = null;
        try {
            CacheResponse response;
            if (keyCache == null) {
                throw new Exception("KeyCache non definita");
            }
            if (cache != null && (response = (CacheResponse)cache.get(keyCache)) != null) {
                if (response.getObject() != null) {
                    this.log.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] valore[" + response.getObject() + "] in cache.");
                    return (RisultatoStato)response.getObject();
                }
                if (response.getException() != null) {
                    this.log.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] in cache.");
                    throw (Exception)response.getException();
                }
                this.log.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            String idTransazione = datiTransazione != null ? datiTransazione.getIdTransazione() : null;
            SemaphoreLock lock = lockStato.acquire("getStatoInCache", idTransazione);
            try {
                CacheResponse response2;
                if (cache != null && (response2 = (CacheResponse)cache.get(keyCache)) != null) {
                    if (response2.getObject() != null) {
                        this.log.debug("Oggetto (tipo:" + response2.getObject().getClass().getName() + ") con chiave [" + keyCache + "] valore[" + response2.getObject() + "] in cache.");
                        RisultatoStato risultatoStato = (RisultatoStato)response2.getObject();
                        return risultatoStato;
                    }
                    if (response2.getException() != null) {
                        this.log.debug("Eccezione (tipo:" + response2.getException().getClass().getName() + ") con chiave [" + keyCache + "] in cache.");
                        throw (Exception)response2.getException();
                    }
                    this.log.error("In cache non e' presente ne un oggetto ne un'eccezione.");
                }
                this.log.debug("oggetto con chiave [" + keyCache + "] non in cache, effettuo ricerca...");
                obj = this.datiNotifierReader.getStato(this.log, datiTransazione, state, nomeAllarme);
                if (cache == null) return obj;
                if (obj == null) throw new Exception("Ricerca ha ritornato un valore null");
                this.log.debug("Aggiungo oggetto con chiave [" + keyCache + "] valore[" + obj + "] in cache");
                try {
                    CacheResponse responseCache = new CacheResponse();
                    responseCache.setObject((Serializable)obj);
                    cache.put(keyCache, responseCache);
                    return obj;
                }
                catch (UtilsException e) {
                    this.log.error("Errore durante l'inserimento in cache con chiave [" + keyCache + "] valore[" + obj + "]: " + e.getMessage());
                    return obj;
                }
            }
            finally {
                lockStato.release(lock, "getStatoInCache", idTransazione);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new Exception("Stato, Algoritmo di Cache fallito: " + e.getMessage(), e);
        }
    }
}

