/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicyRaggruppamento;
import org.openspcoop2.core.controllo_traffico.beans.ActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.DatiCollezionati;
import org.openspcoop2.core.controllo_traffico.beans.DatiTransazione;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicy;
import org.openspcoop2.core.controllo_traffico.beans.RisultatoStatistico;
import org.openspcoop2.core.controllo_traffico.beans.RisultatoStato;
import org.openspcoop2.core.controllo_traffico.beans.UniqueIdentifierUtilities;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.controllo_traffico.constants.TipoApplicabilita;
import org.openspcoop2.core.controllo_traffico.constants.TipoControlloPeriodo;
import org.openspcoop2.core.controllo_traffico.constants.TipoFinestra;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsa;
import org.openspcoop2.core.controllo_traffico.driver.IGestorePolicyAttive;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;
import org.openspcoop2.core.controllo_traffico.utils.PolicyUtilities;
import org.openspcoop2.core.eventi.constants.CodiceEventoControlloTraffico;
import org.openspcoop2.core.eventi.constants.TipoEvento;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.controllo_traffico.CategoriaEventoControlloTraffico;
import org.openspcoop2.pdd.core.controllo_traffico.ConfigurazioneGatewayControlloTraffico;
import org.openspcoop2.pdd.core.controllo_traffico.DatiTempiRisposta;
import org.openspcoop2.pdd.core.controllo_traffico.GeneratoreMessaggiErrore;
import org.openspcoop2.pdd.core.controllo_traffico.NotificatoreEventi;
import org.openspcoop2.pdd.core.controllo_traffico.RisultatoVerificaPolicy;
import org.openspcoop2.pdd.core.controllo_traffico.policy.GestoreCacheControlloTraffico;
import org.openspcoop2.pdd.core.controllo_traffico.policy.PolicyDateUtils;
import org.openspcoop2.pdd.core.controllo_traffico.policy.PolicyDati;
import org.openspcoop2.pdd.core.controllo_traffico.policy.config.PolicyConfiguration;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.GestorePolicyAttive;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.utils.PorteNamingUtils;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.date.DateManager;
import org.slf4j.Logger;

public class PolicyVerifier {
    private static List<String> listClusterNodes = null;

    private PolicyVerifier() {
    }

    public static List<String> getListClusterNodes() {
        return listClusterNodes;
    }

    public static void setListClusterNodes(List<String> listClusterNodes) {
        PolicyVerifier.listClusterNodes = listClusterNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RisultatoVerificaPolicy verifica(ConfigurazionePdDManager configPdDManager, IProtocolFactory<?> protocolFactory, IGestorePolicyAttive gestorePolicyAttive, PolicyConfiguration policyConfiguration, Logger logCC, ActivePolicy activePolicy, IDUnivocoGroupByPolicy datiGroupBy, PdDContext pddContext, MsgDiagnostico msgDiag, Transaction tr, DatiTransazione datiTransazione, boolean isPddCongestionata, DatiTempiRisposta tempiRisposta, List<Boolean> pddContextPolicyApplicabile, List<Boolean> pddContextPolicyViolata, IState state) throws Exception {
        RisultatoVerificaPolicy risultatoVerificaPolicy;
        String descriptionPolicyViolated;
        Date dataEventoPolicyViolated;
        boolean violazionePolicyWarningOnly;
        boolean violazionePolicy;
        boolean policyGlobale;
        boolean policyAPI;
        RequestInfo requestInfo;
        block157: {
            String descrizioneStatoAllarmeRilevato;
            String descrizioneDegradoPrestazionaleRilevato;
            Date now;
            GestoreCacheControlloTraffico gestoreCacheControlloTraffico;
            RisultatoVerificaPolicy risultatoVerificaPolicy2;
            DatiCollezionati datiCollezionatiReaded;
            block155: {
                Object datiCollezionatiUpdated;
                block156: {
                    requestInfo = null;
                    if (tr != null) {
                        requestInfo = tr.getRequestInfo();
                    }
                    policyAPI = activePolicy.getInstanceConfiguration().getFiltro() != null && activePolicy.getInstanceConfiguration().getFiltro().getNomePorta() != null && !"".equals(activePolicy.getInstanceConfiguration().getFiltro().getNomePorta());
                    boolean bl = policyGlobale = !policyAPI;
                    if (pddContext != null && policyConfiguration != null) {
                        PolicyDateUtils.setGestorePolicyConfigDateIntoContext((Map<Object>)pddContext, policyConfiguration.getGestorePolicyConfigDate());
                    }
                    datiCollezionatiReaded = gestorePolicyAttive.getActiveThreadsPolicy(activePolicy, datiTransazione, (Object)state).registerStartRequest(logCC, datiTransazione.getIdTransazione(), datiGroupBy, (Map)pddContext);
                    Date check = new Date(DateManager.getTimeMillis() - 60000L);
                    if (datiCollezionatiReaded.getCreationDate().after(check)) {
                        String uniqueIdMap = null;
                        for (PolicyGroupByActiveThreadsType tipo : GestorePolicyAttive.getTipiGestoriAttivi()) {
                            if (tipo.equals((Object)gestorePolicyAttive.getType())) continue;
                            if (uniqueIdMap == null) {
                                uniqueIdMap = UniqueIdentifierUtilities.getUniqueId((AttivazionePolicy)activePolicy.getInstanceConfiguration());
                            }
                            GestorePolicyAttive.getInstance(tipo).removeActiveThreadsPolicyUnsafe(uniqueIdMap);
                        }
                    }
                    risultatoVerificaPolicy2 = new RisultatoVerificaPolicy();
                    risultatoVerificaPolicy2.setRisorsa(activePolicy.getTipoRisorsaPolicy());
                    risultatoVerificaPolicy2.setSimultanee(activePolicy.getConfigurazionePolicy().isSimultanee());
                    risultatoVerificaPolicy2.setWarningOnly(activePolicy.getInstanceConfiguration().isWarningOnly());
                    if (TipoApplicabilita.CONDIZIONALE.equals((Object)activePolicy.getConfigurazionePolicy().getTipoApplicabilita())) {
                        risultatoVerificaPolicy2.setApplicabilitaCongestione(activePolicy.getConfigurazionePolicy().isApplicabilitaConCongestione());
                        risultatoVerificaPolicy2.setApplicabilitaDegradoPrestazionale(activePolicy.getConfigurazionePolicy().isApplicabilitaDegradoPrestazionale());
                        risultatoVerificaPolicy2.setApplicabilitaStatoAllarme(activePolicy.getConfigurazionePolicy().isApplicabilitaStatoAllarme());
                    }
                    gestoreCacheControlloTraffico = GestoreCacheControlloTraffico.getInstance();
                    violazionePolicy = false;
                    violazionePolicyWarningOnly = false;
                    dataEventoPolicyViolated = null;
                    descriptionPolicyViolated = null;
                    try {
                        now = datiCollezionatiReaded.getCloneDate();
                        boolean printDati = false;
                        String toStringRaggruppamentoSenzaDatiIstanza = PolicyUtilities.toStringGroupBy((AttivazionePolicyRaggruppamento)activePolicy.getInstanceConfiguration().getGroupBy(), (IDUnivocoGroupByPolicy)datiGroupBy, (boolean)printDati);
                        msgDiag.addKeyword("@CT_DATI_IDENTIFICATIVI_GRUPPO@", toStringRaggruppamentoSenzaDatiIstanza);
                        boolean isApplicabile = true;
                        Object descrizioneNonApplicabile = null;
                        if (risultatoVerificaPolicy2.isApplicabilitaCongestione() && !isPddCongestionata) {
                            isApplicabile = false;
                            Object oThreshold = pddContext.getObject(GeneratoreMessaggiErrore.PDD_CONTEXT_CONTROLLO_TRAFFICO_THRESHOLD);
                            descrizioneNonApplicabile = oThreshold != null ? msgDiag.getMessaggio_replaceKeywords("all.", "controlloTraffico.policy.applicabilita.nonCongestionato") : msgDiag.getMessaggio_replaceKeywords("all.", "controlloTraffico.policy.applicabilita.controlloCongestioneDisabilitato");
                        }
                        descrizioneDegradoPrestazionaleRilevato = null;
                        if (isApplicabile && risultatoVerificaPolicy2.isApplicabilitaDegradoPrestazionale()) {
                            Date leftDate = null;
                            Date rightDate = null;
                            if (TipoFinestra.CORRENTE.equals((Object)activePolicy.getConfigurazionePolicy().getDegradoAvgTimeFinestraOsservazione())) {
                                leftDate = datiCollezionatiReaded.getDegradoPrestazionaleLeftDateWindowCurrentInterval();
                                rightDate = datiCollezionatiReaded.getDegradoPrestazionaleRightDateWindowCurrentInterval();
                            } else if (TipoFinestra.PRECEDENTE.equals((Object)activePolicy.getConfigurazionePolicy().getDegradoAvgTimeFinestraOsservazione())) {
                                leftDate = datiCollezionatiReaded.getDegradoPrestazionaleLeftDateWindowPrecedentInterval();
                                rightDate = datiCollezionatiReaded.getDegradoPrestazionaleRightDateWindowPrecedentInterval();
                            } else if (TipoFinestra.SCORREVOLE.equals((Object)activePolicy.getConfigurazionePolicy().getDegradoAvgTimeFinestraOsservazione())) {
                                leftDate = datiCollezionatiReaded.getDegradoPrestazionaleLeftDateWindowSlidingInterval(now);
                                rightDate = datiCollezionatiReaded.getDegradoPrestazionaleRightDateWindowSlidingInterval(now);
                            }
                            Date checkDate = null;
                            long valoreAttuale = 0L;
                            if (TipoControlloPeriodo.REALTIME.equals((Object)activePolicy.getConfigurazionePolicy().getDegradoAvgTimeModalitaControllo())) {
                                checkDate = now;
                                if (TipoFinestra.CORRENTE.equals((Object)activePolicy.getConfigurazionePolicy().getDegradoAvgTimeFinestraOsservazione())) {
                                    if (datiCollezionatiReaded.getPolicyDegradoPrestazionaleAvgValue() != null) {
                                        valoreAttuale = datiCollezionatiReaded.getPolicyDegradoPrestazionaleAvgValue().longValue();
                                    }
                                } else if (datiCollezionatiReaded.getOldPolicyDegradoPrestazionaleAvgValue() != null) {
                                    valoreAttuale = datiCollezionatiReaded.getOldPolicyDegradoPrestazionaleAvgValue().longValue();
                                }
                            } else {
                                RisultatoStatistico risultatoStatistico = gestoreCacheControlloTraffico.readLatenza(TipoRisorsa.TEMPO_MEDIO_RISPOSTA, leftDate, rightDate, activePolicy.getConfigurazionePolicy().getDegradoAvgTimeFinestraOsservazione(), activePolicy.getConfigurazionePolicy().getDegradoAvgTimeTipoIntervalloOsservazioneStatistico(), activePolicy.getConfigurazionePolicy().getDegradoAvgTimeTipoLatenza(), datiTransazione, datiGroupBy, activePolicy.getInstanceConfiguration().getFiltro(), state, requestInfo, protocolFactory);
                                valoreAttuale = risultatoStatistico.getRisultato();
                                checkDate = risultatoStatistico.getDateCheck();
                            }
                            msgDiag.addKeyword("@CT_TIPOLOGIA_TEMPO_MEDIO@", "Latenza " + activePolicy.getConfigurazionePolicy().getDegradoAvgTimeTipoLatenza().getValue());
                            msgDiag.addKeyword("@CT_AVG_TIME_RILEVATO@", "" + valoreAttuale);
                            msgDiag.addKeyword("@CT_DEGRADO_SOGLIA@", "" + tempiRisposta.getAvgResponseTime());
                            msgDiag.addKeyword("@CT_INTERVALLO_TEMPORALE@", PolicyDateUtils.toStringIntervalloTemporale(activePolicy.getConfigurazionePolicy().getDegradoAvgTimeFinestraOsservazione(), leftDate, rightDate, checkDate, TipoControlloPeriodo.STATISTIC.equals((Object)activePolicy.getConfigurazionePolicy().getDegradoAvgTimeModalitaControllo())));
                            if (valoreAttuale <= (long)tempiRisposta.getAvgResponseTime().intValue()) {
                                isApplicabile = false;
                                descrizioneNonApplicabile = msgDiag.getMessaggio_replaceKeywords("all.", "controlloTraffico.policy.applicabilita.degradoPrestazionale.nonRilevato");
                            } else {
                                descrizioneDegradoPrestazionaleRilevato = msgDiag.getMessaggio_replaceKeywords("all.", "controlloTraffico.policy.applicabilita.degradoPrestazionale.rilevato");
                            }
                        }
                        descrizioneStatoAllarmeRilevato = null;
                        if (isApplicabile && risultatoVerificaPolicy2.isApplicabilitaStatoAllarme()) {
                            if (!((ConfigurazioneGatewayControlloTraffico)activePolicy.getConfigurazioneControlloTraffico()).isNotifierEnabled()) {
                                throw new CoreException("Modulo Allarmi non abilitato. La Policy deve essere applicata condizionalmente allo stato di un allarme");
                            }
                            RisultatoStato statoAttuale = null;
                            String nomeAllarme = activePolicy.getConfigurazionePolicy().getAllarmeNome();
                            msgDiag.addKeyword("@CT_NOME_ALLARME@", nomeAllarme);
                            Integer statoIndicato = activePolicy.getConfigurazionePolicy().getAllarmeStato();
                            boolean notStato = activePolicy.getConfigurazionePolicy().isAllarmeNotStato();
                            try {
                                statoAttuale = gestoreCacheControlloTraffico.getStato(datiTransazione, state, nomeAllarme);
                            }
                            catch (Exception e) {
                                isApplicabile = false;
                                descrizioneNonApplicabile = "Recupero stato dell'allarme [" + nomeAllarme + "] non riuscito: " + e.getMessage();
                            }
                            if (statoAttuale != null) {
                                msgDiag.addKeyword("@CT_STATO_ALLARME@", PolicyUtilities.toString((RisultatoStato)statoAttuale));
                                boolean match = false;
                                if (notStato) {
                                    match = statoAttuale.getStato().intValue() != statoIndicato.intValue();
                                    msgDiag.addKeyword("@CT_STATO_ALLARME_ATTESO@", "stato differente da '" + PolicyUtilities.toString((Integer)statoIndicato) + "'");
                                } else {
                                    match = statoAttuale.getStato().intValue() == statoIndicato.intValue();
                                    msgDiag.addKeyword("@CT_STATO_ALLARME_ATTESO@", "stato uguale a '" + PolicyUtilities.toString((Integer)statoIndicato) + "'");
                                }
                                if (!match) {
                                    isApplicabile = false;
                                    descrizioneNonApplicabile = msgDiag.getMessaggio_replaceKeywords("all.", "controlloTraffico.policy.applicabilita.statoAllarme.nonRilevato");
                                } else {
                                    descrizioneStatoAllarmeRilevato = msgDiag.getMessaggio_replaceKeywords("all.", "controlloTraffico.policy.applicabilita.statoAllarme.rilevato");
                                }
                            }
                        }
                        if (isApplicabile || !activePolicy.getConfigurazioneControlloTraffico().isElaborazioneRealtime_incrementaSoloPolicyApplicabile()) {
                            datiCollezionatiUpdated = gestorePolicyAttive.getActiveThreadsPolicy(activePolicy, datiTransazione, (Object)state).updateDatiStartRequestApplicabile(logCC, datiTransazione.getIdTransazione(), datiGroupBy, (Map)pddContext);
                            if (datiCollezionatiUpdated != null) {
                                datiCollezionatiReaded = datiCollezionatiUpdated;
                                now = datiCollezionatiReaded.getCloneDate();
                            }
                            pddContextPolicyApplicabile.add(true);
                        } else {
                            pddContextPolicyApplicabile.add(false);
                        }
                        if (isApplicabile) break block155;
                        risultatoVerificaPolicy2.setNonApplicabile(true);
                        risultatoVerificaPolicy2.setDescrizione((String)descrizioneNonApplicabile);
                        pddContextPolicyViolata.add(false);
                        datiCollezionatiUpdated = risultatoVerificaPolicy2;
                        if (pddContext == null) break block156;
                    }
                    catch (Throwable throwable) {
                        CategoriaEventoControlloTraffico tipoEvento;
                        if (pddContext != null) {
                            PolicyDateUtils.removeGestorePolicyConfigDateIntoContext((Map<Object>)pddContext);
                        }
                        String idPolicyConGruppo = null;
                        String configurazione = null;
                        if (violazionePolicy || violazionePolicyWarningOnly) {
                            String idAPI = null;
                            if (policyAPI) {
                                idAPI = PolicyVerifier.getIdAPI(activePolicy, protocolFactory, configPdDManager, requestInfo);
                            }
                            idPolicyConGruppo = PolicyUtilities.buildIdConfigurazioneEventoPerPolicy((ActivePolicy)activePolicy, (IDUnivocoGroupByPolicy)datiGroupBy, idAPI);
                            configurazione = PolicyUtilities.buildConfigurazioneEventoPerPolicy((ActivePolicy)activePolicy, (boolean)policyGlobale);
                        }
                        if (violazionePolicy) {
                            tipoEvento = null;
                            tipoEvento = policyGlobale ? CategoriaEventoControlloTraffico.POLICY_GLOBALE : CategoriaEventoControlloTraffico.POLICY_API;
                            NotificatoreEventi.getInstance().log(tipoEvento, idPolicyConGruppo, configurazione, dataEventoPolicyViolated, descriptionPolicyViolated);
                        }
                        if (violazionePolicyWarningOnly) {
                            tipoEvento = null;
                            tipoEvento = policyGlobale ? CategoriaEventoControlloTraffico.POLICY_GLOBALE_WARNING_ONLY : CategoriaEventoControlloTraffico.POLICY_API_WARNING_ONLY;
                            NotificatoreEventi.getInstance().log(tipoEvento, idPolicyConGruppo, configurazione, dataEventoPolicyViolated, descriptionPolicyViolated);
                        }
                        throw throwable;
                    }
                    PolicyDateUtils.removeGestorePolicyConfigDateIntoContext((Map<Object>)pddContext);
                }
                String idPolicyConGruppo = null;
                String configurazione = null;
                if (violazionePolicy || violazionePolicyWarningOnly) {
                    String idAPI = null;
                    if (policyAPI) {
                        idAPI = PolicyVerifier.getIdAPI(activePolicy, protocolFactory, configPdDManager, requestInfo);
                    }
                    idPolicyConGruppo = PolicyUtilities.buildIdConfigurazioneEventoPerPolicy((ActivePolicy)activePolicy, (IDUnivocoGroupByPolicy)datiGroupBy, idAPI);
                    configurazione = PolicyUtilities.buildConfigurazioneEventoPerPolicy((ActivePolicy)activePolicy, (boolean)policyGlobale);
                }
                if (violazionePolicy) {
                    CategoriaEventoControlloTraffico tipoEvento = null;
                    tipoEvento = policyGlobale ? CategoriaEventoControlloTraffico.POLICY_GLOBALE : CategoriaEventoControlloTraffico.POLICY_API;
                    NotificatoreEventi.getInstance().log(tipoEvento, idPolicyConGruppo, configurazione, dataEventoPolicyViolated, descriptionPolicyViolated);
                }
                if (violazionePolicyWarningOnly) {
                    CategoriaEventoControlloTraffico tipoEvento = null;
                    tipoEvento = policyGlobale ? CategoriaEventoControlloTraffico.POLICY_GLOBALE_WARNING_ONLY : CategoriaEventoControlloTraffico.POLICY_API_WARNING_ONLY;
                    NotificatoreEventi.getInstance().log(tipoEvento, idPolicyConGruppo, configurazione, dataEventoPolicyViolated, descriptionPolicyViolated);
                }
                return datiCollezionatiUpdated;
            }
            long valoreSoglia = activePolicy.getConfigurazionePolicy().getValore();
            if (activePolicy.getInstanceConfiguration().isRidefinisci()) {
                valoreSoglia = activePolicy.getInstanceConfiguration().getValore();
            }
            boolean gestioneClusterSupportata = false;
            long valoreSogliaComplessivoCluster = -1L;
            if (activePolicy.getConfigurazionePolicy().isSimultanee() || TipoControlloPeriodo.REALTIME.equals((Object)activePolicy.getConfigurazionePolicy().getModalitaControllo())) {
                switch (activePolicy.getTipoRisorsaPolicy()) {
                    case DIMENSIONE_MASSIMA_MESSAGGIO: {
                        break;
                    }
                    case NUMERO_RICHIESTE: 
                    case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: 
                    case NUMERO_RICHIESTE_FALLITE: 
                    case NUMERO_FAULT_APPLICATIVI: 
                    case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: 
                    case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: {
                        gestioneClusterSupportata = true;
                        break;
                    }
                    case OCCUPAZIONE_BANDA: {
                        gestioneClusterSupportata = false;
                        break;
                    }
                    case TEMPO_COMPLESSIVO_RISPOSTA: {
                        gestioneClusterSupportata = false;
                        break;
                    }
                    case TEMPO_MEDIO_RISPOSTA: {
                        gestioneClusterSupportata = false;
                    }
                }
                if (!PolicyGroupByActiveThreadsType.LOCAL_DIVIDED_BY_NODES.equals((Object)policyConfiguration.getType())) {
                    gestioneClusterSupportata = false;
                }
                if (gestioneClusterSupportata && PolicyGroupByActiveThreadsType.LOCAL_DIVIDED_BY_NODES.equals((Object)policyConfiguration.getType()) && listClusterNodes != null && !listClusterNodes.isEmpty() && listClusterNodes.size() > 1) {
                    if (!policyConfiguration.isLOCAL_DIVIDED_BY_NODES_limit_normalizedQuota()) {
                        risultatoVerificaPolicy2.setMaxValueBeforeNormalizing(valoreSoglia);
                    }
                    risultatoVerificaPolicy2.setRemainingZeroValue(policyConfiguration.isLOCAL_DIVIDED_BY_NODES_remaining_zeroValue());
                    long resto = -1L;
                    if (!policyConfiguration.isLOCAL_DIVIDED_BY_NODES_limit_roundingDown()) {
                        resto = valoreSoglia % (long)listClusterNodes.size();
                    }
                    valoreSoglia /= (long)listClusterNodes.size();
                    if (policyConfiguration.isLOCAL_DIVIDED_BY_NODES_limit_roundingDown()) {
                        if (valoreSoglia <= 0L) {
                            valoreSoglia = 1L;
                        }
                    } else if (resto > 0L) {
                        ++valoreSoglia;
                    }
                    valoreSogliaComplessivoCluster = valoreSoglia * (long)listClusterNodes.size();
                } else {
                    gestioneClusterSupportata = false;
                }
            }
            msgDiag.addKeyword("@CT_SOGLIA@", "" + valoreSoglia);
            boolean rilevataViolazione = false;
            switch (activePolicy.getTipoRisorsaPolicy()) {
                case DIMENSIONE_MASSIMA_MESSAGGIO: {
                    break;
                }
                case NUMERO_RICHIESTE: 
                case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: 
                case NUMERO_RICHIESTE_FALLITE: 
                case NUMERO_FAULT_APPLICATIVI: 
                case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: 
                case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: {
                    if (activePolicy.getConfigurazionePolicy().isSimultanee()) {
                        long valoreAttuale = datiCollezionatiReaded.getActiveRequestCounter();
                        if (gestioneClusterSupportata) {
                            risultatoVerificaPolicy2.setActualValue(valoreAttuale * (long)listClusterNodes.size());
                            risultatoVerificaPolicy2.setMaxValue(valoreSogliaComplessivoCluster);
                        } else {
                            risultatoVerificaPolicy2.setActualValue(valoreAttuale);
                            risultatoVerificaPolicy2.setMaxValue(valoreSoglia);
                        }
                        if (datiCollezionatiReaded.getRightDateWindowCurrentInterval() != null) {
                            risultatoVerificaPolicy2.setMsBeforeResetCounters(datiCollezionatiReaded.getRightDateWindowCurrentInterval().getTime() - DateManager.getTimeMillis());
                        }
                        if (valoreAttuale <= valoreSoglia) break;
                        rilevataViolazione = true;
                        risultatoVerificaPolicy2.setDescrizione(msgDiag.getMessaggio_replaceKeywords("all.", "controlloTraffico.policy.violata.risorsaNumeroRichieste.simultaneo"));
                        break;
                    }
                    Date leftDate = null;
                    Date rightDate = null;
                    if (TipoFinestra.CORRENTE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione())) {
                        leftDate = datiCollezionatiReaded.getLeftDateWindowCurrentInterval();
                        rightDate = datiCollezionatiReaded.getRightDateWindowCurrentInterval();
                    } else if (TipoFinestra.PRECEDENTE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione())) {
                        leftDate = datiCollezionatiReaded.getLeftDateWindowPrecedentInterval();
                        rightDate = datiCollezionatiReaded.getRightDateWindowPrecedentInterval();
                    } else if (TipoFinestra.SCORREVOLE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione())) {
                        leftDate = datiCollezionatiReaded.getLeftDateWindowSlidingInterval(now);
                        rightDate = datiCollezionatiReaded.getRightDateWindowSlidingInterval(now);
                    }
                    Date checkDate = null;
                    long valoreAttuale = 0L;
                    if (TipoControlloPeriodo.REALTIME.equals((Object)activePolicy.getConfigurazionePolicy().getModalitaControllo())) {
                        checkDate = now;
                        if (TipoFinestra.CORRENTE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione())) {
                            if (datiCollezionatiReaded.getPolicyRequestCounter() != null) {
                                valoreAttuale = datiCollezionatiReaded.getPolicyRequestCounter();
                                switch (activePolicy.getTipoRisorsaPolicy()) {
                                    case NUMERO_RICHIESTE: {
                                        break;
                                    }
                                    case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: 
                                    case NUMERO_RICHIESTE_FALLITE: 
                                    case NUMERO_FAULT_APPLICATIVI: 
                                    case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: 
                                    case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: {
                                        ++valoreAttuale;
                                        break;
                                    }
                                    default: {
                                        break;
                                    }
                                }
                            }
                        } else if (datiCollezionatiReaded.getOldPolicyRequestCounter() != null) {
                            valoreAttuale = datiCollezionatiReaded.getOldPolicyRequestCounter();
                        }
                    } else {
                        RisultatoStatistico risultatoStatistico = gestoreCacheControlloTraffico.readNumeroRichieste(activePolicy.getTipoRisorsaPolicy(), leftDate, rightDate, activePolicy.getConfigurazionePolicy().getFinestraOsservazione(), activePolicy.getConfigurazionePolicy().getTipoIntervalloOsservazioneStatistico(), datiTransazione, datiGroupBy, activePolicy.getInstanceConfiguration().getFiltro(), state, requestInfo, protocolFactory);
                        valoreAttuale = risultatoStatistico.getRisultato();
                        checkDate = risultatoStatistico.getDateCheck();
                    }
                    if (gestioneClusterSupportata) {
                        risultatoVerificaPolicy2.setActualValue(valoreAttuale * (long)listClusterNodes.size());
                        risultatoVerificaPolicy2.setMaxValue(valoreSogliaComplessivoCluster);
                    } else {
                        risultatoVerificaPolicy2.setActualValue(valoreAttuale);
                        risultatoVerificaPolicy2.setMaxValue(valoreSoglia);
                    }
                    if (TipoFinestra.CORRENTE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione()) || TipoFinestra.SCORREVOLE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione())) {
                        if (rightDate != null) {
                            risultatoVerificaPolicy2.setMsBeforeResetCounters(rightDate.getTime() - DateManager.getTimeMillis());
                        }
                        if (leftDate != null && rightDate != null) {
                            risultatoVerificaPolicy2.setMsWindow(rightDate.getTime() + 1L - leftDate.getTime());
                        }
                    }
                    if (valoreAttuale <= valoreSoglia) break;
                    rilevataViolazione = true;
                    msgDiag.addKeyword("@CT_RILEVATO@", "" + valoreAttuale);
                    msgDiag.addKeyword("@CT_INTERVALLO_TEMPORALE@", PolicyDateUtils.toStringIntervalloTemporale(activePolicy.getConfigurazionePolicy().getFinestraOsservazione(), leftDate, rightDate, checkDate, TipoControlloPeriodo.STATISTIC.equals((Object)activePolicy.getConfigurazionePolicy().getModalitaControllo())));
                    String codeDiagnostico = null;
                    switch (activePolicy.getTipoRisorsaPolicy()) {
                        case NUMERO_RICHIESTE: {
                            codeDiagnostico = "controlloTraffico.policy.violata.risorsaNumeroRichieste";
                            break;
                        }
                        case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: {
                            codeDiagnostico = "controlloTraffico.policy.violata.risorsaNumeroRichiesteCompletateConSuccesso";
                            break;
                        }
                        case NUMERO_RICHIESTE_FALLITE: {
                            codeDiagnostico = "controlloTraffico.policy.violata.risorsaNumeroRichiesteFallite";
                            break;
                        }
                        case NUMERO_FAULT_APPLICATIVI: {
                            codeDiagnostico = "controlloTraffico.policy.violata.risorsaNumeroFaultApplicativi";
                            break;
                        }
                        case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: {
                            codeDiagnostico = "controlloTraffico.policy.violata.risorsaNumeroRichiesteFalliteOFaultApplicativi";
                            break;
                        }
                        case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: {
                            codeDiagnostico = "controlloTraffico.policy.violata.risorsaNumeroRichiesteCompletateConSuccessoOFaultApplicativi";
                            break;
                        }
                    }
                    risultatoVerificaPolicy2.setDescrizione(msgDiag.getMessaggio_replaceKeywords("all.", codeDiagnostico));
                    break;
                }
                case OCCUPAZIONE_BANDA: {
                    Date leftDate = null;
                    Date rightDate = null;
                    if (TipoFinestra.CORRENTE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione())) {
                        leftDate = datiCollezionatiReaded.getLeftDateWindowCurrentInterval();
                        rightDate = datiCollezionatiReaded.getRightDateWindowCurrentInterval();
                    } else if (TipoFinestra.PRECEDENTE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione())) {
                        leftDate = datiCollezionatiReaded.getLeftDateWindowPrecedentInterval();
                        rightDate = datiCollezionatiReaded.getRightDateWindowPrecedentInterval();
                    } else if (TipoFinestra.SCORREVOLE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione())) {
                        leftDate = datiCollezionatiReaded.getLeftDateWindowSlidingInterval(now);
                        rightDate = datiCollezionatiReaded.getRightDateWindowSlidingInterval(now);
                    }
                    Date checkDate = null;
                    long valoreAttuale = 0L;
                    if (TipoControlloPeriodo.REALTIME.equals((Object)activePolicy.getConfigurazionePolicy().getModalitaControllo())) {
                        checkDate = now;
                        if (TipoFinestra.CORRENTE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione())) {
                            if (datiCollezionatiReaded.getPolicyCounter() != null) {
                                valoreAttuale = datiCollezionatiReaded.getPolicyCounter();
                            }
                        } else if (datiCollezionatiReaded.getOldPolicyCounter() != null) {
                            valoreAttuale = datiCollezionatiReaded.getOldPolicyCounter();
                        }
                    } else {
                        RisultatoStatistico risultatoStatistico = gestoreCacheControlloTraffico.readOccupazioneBanda(activePolicy.getTipoRisorsaPolicy(), leftDate, rightDate, activePolicy.getConfigurazionePolicy().getFinestraOsservazione(), activePolicy.getConfigurazionePolicy().getTipoIntervalloOsservazioneStatistico(), activePolicy.getConfigurazionePolicy().getValoreTipoBanda(), datiTransazione, datiGroupBy, activePolicy.getInstanceConfiguration().getFiltro(), state, requestInfo, protocolFactory);
                        valoreAttuale = risultatoStatistico.getRisultato();
                        checkDate = risultatoStatistico.getDateCheck();
                    }
                    long kb = DatiCollezionati.translateToKb((long)valoreAttuale);
                    risultatoVerificaPolicy2.setActualValue(kb);
                    risultatoVerificaPolicy2.setMaxValue(valoreSoglia);
                    if (TipoFinestra.CORRENTE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione()) || TipoFinestra.SCORREVOLE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione())) {
                        if (rightDate != null) {
                            risultatoVerificaPolicy2.setMsBeforeResetCounters(rightDate.getTime() - DateManager.getTimeMillis());
                        }
                        if (leftDate != null && rightDate != null) {
                            risultatoVerificaPolicy2.setMsWindow(rightDate.getTime() + 1L - leftDate.getTime());
                        }
                    }
                    if (kb <= valoreSoglia) break;
                    rilevataViolazione = true;
                    msgDiag.addKeyword("@CT_RILEVATO@", "" + kb);
                    msgDiag.addKeyword("@CT_INTERVALLO_TEMPORALE@", PolicyDateUtils.toStringIntervalloTemporale(activePolicy.getConfigurazionePolicy().getFinestraOsservazione(), leftDate, rightDate, checkDate, TipoControlloPeriodo.STATISTIC.equals((Object)activePolicy.getConfigurazionePolicy().getModalitaControllo())));
                    risultatoVerificaPolicy2.setDescrizione(msgDiag.getMessaggio_replaceKeywords("all.", "controlloTraffico.policy.violata.risorsaOccupazioneBanda"));
                    break;
                }
                case TEMPO_COMPLESSIVO_RISPOSTA: {
                    Date leftDate = null;
                    Date rightDate = null;
                    if (TipoFinestra.CORRENTE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione())) {
                        leftDate = datiCollezionatiReaded.getLeftDateWindowCurrentInterval();
                        rightDate = datiCollezionatiReaded.getRightDateWindowCurrentInterval();
                    } else if (TipoFinestra.PRECEDENTE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione())) {
                        leftDate = datiCollezionatiReaded.getLeftDateWindowPrecedentInterval();
                        rightDate = datiCollezionatiReaded.getRightDateWindowPrecedentInterval();
                    } else if (TipoFinestra.SCORREVOLE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione())) {
                        leftDate = datiCollezionatiReaded.getLeftDateWindowSlidingInterval(now);
                        rightDate = datiCollezionatiReaded.getRightDateWindowSlidingInterval(now);
                    }
                    Date checkDate = null;
                    long valoreAttuale = 0L;
                    if (TipoControlloPeriodo.REALTIME.equals((Object)activePolicy.getConfigurazionePolicy().getModalitaControllo())) {
                        checkDate = now;
                        if (TipoFinestra.CORRENTE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione())) {
                            if (datiCollezionatiReaded.getPolicyCounter() != null) {
                                valoreAttuale = datiCollezionatiReaded.getPolicyCounter();
                            }
                        } else if (datiCollezionatiReaded.getOldPolicyCounter() != null) {
                            valoreAttuale = datiCollezionatiReaded.getOldPolicyCounter();
                        }
                    } else {
                        throw new CoreException("Risorsa non utilizzabile con campionamento statistico");
                    }
                    long secondi = DatiCollezionati.translateToSeconds((long)valoreAttuale);
                    risultatoVerificaPolicy2.setActualValue(secondi);
                    risultatoVerificaPolicy2.setMaxValue(valoreSoglia);
                    if (TipoFinestra.CORRENTE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione()) || TipoFinestra.SCORREVOLE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione())) {
                        if (rightDate != null) {
                            risultatoVerificaPolicy2.setMsBeforeResetCounters(rightDate.getTime() - DateManager.getTimeMillis());
                        }
                        if (leftDate != null && rightDate != null) {
                            risultatoVerificaPolicy2.setMsWindow(rightDate.getTime() + 1L - leftDate.getTime());
                        }
                    }
                    if (secondi <= valoreSoglia) break;
                    rilevataViolazione = true;
                    msgDiag.addKeyword("@CT_RILEVATO@", "" + secondi);
                    msgDiag.addKeyword("@CT_INTERVALLO_TEMPORALE@", PolicyDateUtils.toStringIntervalloTemporale(activePolicy.getConfigurazionePolicy().getFinestraOsservazione(), leftDate, rightDate, checkDate, TipoControlloPeriodo.STATISTIC.equals((Object)activePolicy.getConfigurazionePolicy().getModalitaControllo())));
                    risultatoVerificaPolicy2.setDescrizione(msgDiag.getMessaggio_replaceKeywords("all.", "controlloTraffico.policy.violata.risorsaTempoComplessivo"));
                    break;
                }
                case TEMPO_MEDIO_RISPOSTA: {
                    Date leftDate = null;
                    Date rightDate = null;
                    if (TipoFinestra.CORRENTE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione())) {
                        leftDate = datiCollezionatiReaded.getLeftDateWindowCurrentInterval();
                        rightDate = datiCollezionatiReaded.getRightDateWindowCurrentInterval();
                    } else if (TipoFinestra.PRECEDENTE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione())) {
                        leftDate = datiCollezionatiReaded.getLeftDateWindowPrecedentInterval();
                        rightDate = datiCollezionatiReaded.getRightDateWindowPrecedentInterval();
                    } else if (TipoFinestra.SCORREVOLE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione())) {
                        leftDate = datiCollezionatiReaded.getLeftDateWindowSlidingInterval(now);
                        rightDate = datiCollezionatiReaded.getRightDateWindowSlidingInterval(now);
                    }
                    Date checkDate = null;
                    long valoreAttuale = 0L;
                    if (TipoControlloPeriodo.REALTIME.equals((Object)activePolicy.getConfigurazionePolicy().getModalitaControllo())) {
                        checkDate = now;
                        if (TipoFinestra.CORRENTE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione())) {
                            if (datiCollezionatiReaded.getPolicyAvgValue() != null) {
                                valoreAttuale = datiCollezionatiReaded.getPolicyAvgValue().longValue();
                            }
                        } else if (datiCollezionatiReaded.getOldPolicyAvgValue() != null) {
                            valoreAttuale = datiCollezionatiReaded.getOldPolicyAvgValue().longValue();
                        }
                    } else {
                        RisultatoStatistico risultatoStatistico = gestoreCacheControlloTraffico.readLatenza(activePolicy.getTipoRisorsaPolicy(), leftDate, rightDate, activePolicy.getConfigurazionePolicy().getFinestraOsservazione(), activePolicy.getConfigurazionePolicy().getTipoIntervalloOsservazioneStatistico(), activePolicy.getConfigurazionePolicy().getValoreTipoLatenza(), datiTransazione, datiGroupBy, activePolicy.getInstanceConfiguration().getFiltro(), state, requestInfo, protocolFactory);
                        valoreAttuale = risultatoStatistico.getRisultato();
                        checkDate = risultatoStatistico.getDateCheck();
                    }
                    risultatoVerificaPolicy2.setActualValue(valoreAttuale);
                    risultatoVerificaPolicy2.setMaxValue(valoreSoglia);
                    if (TipoFinestra.CORRENTE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione()) || TipoFinestra.SCORREVOLE.equals((Object)activePolicy.getConfigurazionePolicy().getFinestraOsservazione())) {
                        if (rightDate != null) {
                            risultatoVerificaPolicy2.setMsBeforeResetCounters(rightDate.getTime() - DateManager.getTimeMillis());
                        }
                        if (leftDate != null && rightDate != null) {
                            risultatoVerificaPolicy2.setMsWindow(rightDate.getTime() + 1L - leftDate.getTime());
                        }
                    }
                    if (valoreAttuale <= valoreSoglia) break;
                    rilevataViolazione = true;
                    msgDiag.addKeyword("@CT_TIPOLOGIA_TEMPO_MEDIO@", "Latenza " + activePolicy.getConfigurazionePolicy().getValoreTipoLatenza().getValue());
                    msgDiag.addKeyword("@CT_AVG_TIME_RILEVATO@", "" + valoreAttuale);
                    msgDiag.addKeyword("@CT_INTERVALLO_TEMPORALE@", PolicyDateUtils.toStringIntervalloTemporale(activePolicy.getConfigurazionePolicy().getFinestraOsservazione(), leftDate, rightDate, checkDate, TipoControlloPeriodo.STATISTIC.equals((Object)activePolicy.getConfigurazionePolicy().getModalitaControllo())));
                    risultatoVerificaPolicy2.setDescrizione(msgDiag.getMessaggio_replaceKeywords("all.", "controlloTraffico.policy.violata.risorsaTempoMedio"));
                }
            }
            if (rilevataViolazione) {
                String separatore;
                TipoEvento tipoEvento = null;
                tipoEvento = policyGlobale ? TipoEvento.RATE_LIMITING_POLICY_GLOBALE : TipoEvento.RATE_LIMITING_POLICY_API;
                if (risultatoVerificaPolicy2.isWarningOnly()) {
                    violazionePolicyWarningOnly = true;
                    tr.addEventoGestione(tipoEvento.getValue() + "_" + CodiceEventoControlloTraffico.VIOLAZIONE_WARNING_ONLY.getValue() + "_" + PolicyUtilities.getNomeActivePolicy((String)activePolicy.getInstanceConfiguration().getAlias(), (String)activePolicy.getInstanceConfiguration().getIdActivePolicy()));
                } else {
                    violazionePolicy = true;
                    tr.addEventoGestione(tipoEvento.getValue() + "_" + CodiceEventoControlloTraffico.VIOLAZIONE.getValue() + "_" + PolicyUtilities.getNomeActivePolicy((String)activePolicy.getInstanceConfiguration().getAlias(), (String)activePolicy.getInstanceConfiguration().getIdActivePolicy()));
                }
                dataEventoPolicyViolated = DateManager.getDate();
                if (descrizioneDegradoPrestazionaleRilevato != null) {
                    separatore = "\n";
                    if (!risultatoVerificaPolicy2.getDescrizione().endsWith(".")) {
                        separatore = ".\n";
                    }
                    risultatoVerificaPolicy2.setDescrizione(risultatoVerificaPolicy2.getDescrizione() + separatore + descrizioneDegradoPrestazionaleRilevato);
                }
                if (descrizioneStatoAllarmeRilevato != null) {
                    separatore = "\n";
                    if (!risultatoVerificaPolicy2.getDescrizione().endsWith(".")) {
                        separatore = ".\n";
                    }
                    risultatoVerificaPolicy2.setDescrizione(risultatoVerificaPolicy2.getDescrizione() + separatore + descrizioneStatoAllarmeRilevato);
                }
            }
            risultatoVerificaPolicy2.setViolata(rilevataViolazione);
            pddContextPolicyViolata.add(rilevataViolazione);
            risultatoVerificaPolicy = risultatoVerificaPolicy2;
            if (pddContext == null) break block157;
            PolicyDateUtils.removeGestorePolicyConfigDateIntoContext((Map<Object>)pddContext);
        }
        String idPolicyConGruppo = null;
        String configurazione = null;
        if (violazionePolicy || violazionePolicyWarningOnly) {
            String idAPI = null;
            if (policyAPI) {
                idAPI = PolicyVerifier.getIdAPI(activePolicy, protocolFactory, configPdDManager, requestInfo);
            }
            idPolicyConGruppo = PolicyUtilities.buildIdConfigurazioneEventoPerPolicy((ActivePolicy)activePolicy, (IDUnivocoGroupByPolicy)datiGroupBy, idAPI);
            configurazione = PolicyUtilities.buildConfigurazioneEventoPerPolicy((ActivePolicy)activePolicy, (boolean)policyGlobale);
        }
        if (violazionePolicy) {
            CategoriaEventoControlloTraffico tipoEvento = null;
            tipoEvento = policyGlobale ? CategoriaEventoControlloTraffico.POLICY_GLOBALE : CategoriaEventoControlloTraffico.POLICY_API;
            NotificatoreEventi.getInstance().log(tipoEvento, idPolicyConGruppo, configurazione, dataEventoPolicyViolated, descriptionPolicyViolated);
        }
        if (violazionePolicyWarningOnly) {
            CategoriaEventoControlloTraffico tipoEvento = null;
            tipoEvento = policyGlobale ? CategoriaEventoControlloTraffico.POLICY_GLOBALE_WARNING_ONLY : CategoriaEventoControlloTraffico.POLICY_API_WARNING_ONLY;
            NotificatoreEventi.getInstance().log(tipoEvento, idPolicyConGruppo, configurazione, dataEventoPolicyViolated, descriptionPolicyViolated);
        }
        return risultatoVerificaPolicy;
    }

    public static String getIdAPI(ActivePolicy activePolicy, IProtocolFactory<?> protocolFactory, ConfigurazionePdDManager configPdDManager, RequestInfo requestInfo) throws ProtocolException, DriverConfigurazioneException {
        AttivazionePolicy attivazionePolicy = activePolicy.getInstanceConfiguration();
        return PolicyVerifier.getIdAPI(attivazionePolicy, protocolFactory, configPdDManager, requestInfo);
    }

    public static String getIdAPI(AttivazionePolicy attivazionePolicy, IProtocolFactory<?> protocolFactory, ConfigurazionePdDManager configPdDManager, RequestInfo requestInfo) throws ProtocolException, DriverConfigurazioneException {
        PorteNamingUtils namingUtils = new PorteNamingUtils(protocolFactory);
        String api = null;
        if (attivazionePolicy.getFiltro() != null && attivazionePolicy.getFiltro().getNomePorta() != null && StringUtils.isNotEmpty((String)attivazionePolicy.getFiltro().getNomePorta()) && attivazionePolicy.getFiltro().getRuoloPorta() != null) {
            String nomePorta = attivazionePolicy.getFiltro().getNomePorta();
            if (RuoloPolicy.DELEGATA.equals((Object)attivazionePolicy.getFiltro().getRuoloPorta())) {
                api = PolicyVerifier.getIdAPIFruizione(nomePorta, configPdDManager, requestInfo, namingUtils);
            } else if (RuoloPolicy.APPLICATIVA.equals((Object)attivazionePolicy.getFiltro().getRuoloPorta())) {
                api = PolicyVerifier.getIdAPIErogazione(nomePorta, configPdDManager, requestInfo, namingUtils);
            }
        }
        return api;
    }

    public static PolicyDati getIdAPIFruizione(String nomePorta, ConfigurazionePdDManager configPdDManager, RequestInfo requestInfo, IProtocolFactory<?> protocolFactory) throws DriverConfigurazioneException, ProtocolException {
        PorteNamingUtils namingUtils = new PorteNamingUtils(protocolFactory);
        PolicyDati dati = PolicyVerifier.getIdAPIFruizioneEngine(nomePorta, configPdDManager, requestInfo, namingUtils);
        if (protocolFactory != null) {
            dati.setProfilo(protocolFactory.getProtocol());
        }
        return dati;
    }

    public static String getIdAPIFruizione(String nomePorta, ConfigurazionePdDManager configPdDManager, RequestInfo requestInfo, PorteNamingUtils namingUtils) throws DriverConfigurazioneException, ProtocolException {
        return PolicyVerifier.getIdAPIFruizioneEngine(nomePorta, configPdDManager, requestInfo, namingUtils).getIdentificativo();
    }

    private static PolicyDati getIdAPIFruizioneEngine(String nomePorta, ConfigurazionePdDManager configPdDManager, RequestInfo requestInfo, PorteNamingUtils namingUtils) throws DriverConfigurazioneException, ProtocolException {
        PolicyDati policyDati = new PolicyDati();
        policyDati.setRuoloPorta(RuoloPolicy.DELEGATA);
        policyDati.setNomePorta(nomePorta);
        Object api = null;
        IDPortaDelegata idPD = new IDPortaDelegata();
        idPD.setNome(nomePorta);
        PortaDelegata pd = configPdDManager.getPortaDelegataSafeMethod(idPD, requestInfo);
        if (pd != null) {
            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValuesWithoutCheck(pd.getServizio().getTipo(), pd.getServizio().getNome(), pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome(), pd.getServizio().getVersione().intValue());
            policyDati.setIdServizio(idServizio);
            IDSoggetto idFruitore = new IDSoggetto(pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario());
            policyDati.setIdFruitore(idFruitore);
            List<MappingFruizionePortaDelegata> list = configPdDManager.getMappingFruizionePortaDelegataList(idFruitore, idServizio, requestInfo);
            if (list.size() <= 1) {
                api = namingUtils.normalizePD(nomePorta);
            } else {
                String gruppo = null;
                for (MappingFruizionePortaDelegata mapping : list) {
                    if (mapping.isDefault()) {
                        api = namingUtils.normalizePD(mapping.getIdPortaDelegata().getNome());
                    }
                    if (!nomePorta.equals(mapping.getIdPortaDelegata().getNome())) continue;
                    gruppo = mapping.getDescrizione();
                }
                api = (String)api + " (gruppo '" + gruppo + "') ";
                policyDati.setGruppo(gruppo);
            }
        }
        policyDati.setIdentificativo((String)api);
        return policyDati;
    }

    public static PolicyDati getIdAPIErogazione(String nomePorta, ConfigurazionePdDManager configPdDManager, RequestInfo requestInfo, IProtocolFactory<?> protocolFactory) throws DriverConfigurazioneException, ProtocolException {
        PorteNamingUtils namingUtils = new PorteNamingUtils(protocolFactory);
        PolicyDati dati = PolicyVerifier.getIdAPIErogazioneEngine(nomePorta, configPdDManager, requestInfo, namingUtils);
        if (protocolFactory != null) {
            dati.setProfilo(protocolFactory.getProtocol());
        }
        return dati;
    }

    public static String getIdAPIErogazione(String nomePorta, ConfigurazionePdDManager configPdDManager, RequestInfo requestInfo, PorteNamingUtils namingUtils) throws DriverConfigurazioneException, ProtocolException {
        return PolicyVerifier.getIdAPIErogazioneEngine(nomePorta, configPdDManager, requestInfo, namingUtils).getIdentificativo();
    }

    private static PolicyDati getIdAPIErogazioneEngine(String nomePorta, ConfigurazionePdDManager configPdDManager, RequestInfo requestInfo, PorteNamingUtils namingUtils) throws DriverConfigurazioneException, ProtocolException {
        PolicyDati policyDati = new PolicyDati();
        policyDati.setRuoloPorta(RuoloPolicy.APPLICATIVA);
        policyDati.setNomePorta(nomePorta);
        Object api = null;
        IDPortaApplicativa idPA = new IDPortaApplicativa();
        idPA.setNome(nomePorta);
        PortaApplicativa pa = configPdDManager.getPortaApplicativaSafeMethod(idPA, requestInfo);
        if (pa != null) {
            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValuesWithoutCheck(pa.getServizio().getTipo(), pa.getServizio().getNome(), pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario(), pa.getServizio().getVersione().intValue());
            policyDati.setIdServizio(idServizio);
            List<MappingErogazionePortaApplicativa> list = configPdDManager.getMappingErogazionePortaApplicativaList(idServizio, requestInfo);
            if (list.size() <= 1) {
                api = namingUtils.normalizePA(nomePorta);
            } else {
                String gruppo = null;
                for (MappingErogazionePortaApplicativa mapping : list) {
                    if (mapping.isDefault()) {
                        api = namingUtils.normalizePA(mapping.getIdPortaApplicativa().getNome());
                    }
                    if (!nomePorta.equals(mapping.getIdPortaApplicativa().getNome())) continue;
                    gruppo = mapping.getDescrizione();
                }
                api = (String)api + " (gruppo '" + gruppo + "') ";
                policyDati.setGruppo(gruppo);
            }
        }
        policyDati.setIdentificativo((String)api);
        return policyDati;
    }
}

