/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver;

import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.utils.date.DateManager;

public class ActiveRequestDistributedIntervalManager {
    private ActiveRequestDistributedIntervalManager() {
    }

    public static int getIntervalloSecondi() {
        return OpenSPCoop2Properties.getInstance().getControlloTrafficoGestorePolicyInMemoryRichiesteSimultaneeIntervalloSecondi();
    }

    public static boolean isIntervalloAbilitato() {
        return ActiveRequestDistributedIntervalManager.getIntervalloSecondi() > 0;
    }

    public static Long calcolaIntervalloCorrente(int intervalloSecondi) {
        if (intervalloSecondi <= 0) {
            return null;
        }
        long now = DateManager.getTimeMillis();
        long intervalMillis = (long)intervalloSecondi * 1000L;
        return now / intervalMillis * intervalMillis;
    }

    public static boolean isIntervalloCambiato(int intervalloSecondi, long dataIntervalloMemorizzato) {
        if (intervalloSecondi <= 0 || dataIntervalloMemorizzato <= 0L) {
            return false;
        }
        Long intervalloCorrente = ActiveRequestDistributedIntervalManager.calcolaIntervalloCorrente(intervalloSecondi);
        return intervalloCorrente != null && intervalloCorrente > dataIntervalloMemorizzato;
    }
}

