/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.controllo_traffico.constants.Costanti;
import org.openspcoop2.core.controllo_traffico.driver.IGestorePolicyAttive;
import org.openspcoop2.core.controllo_traffico.driver.PolicyException;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.GestorePolicyAttiveInMemory;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.GestorePolicyAttiveWS;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.TipoGestorePolicy;
import org.slf4j.Logger;

public class GestorePolicyAttive {
    private static Map<PolicyGroupByActiveThreadsType, IGestorePolicyAttive> staticMapInstance = null;
    private static Map<PolicyGroupByActiveThreadsType, String> staticPolicyRateLimitingImage = null;
    private static Map<PolicyGroupByActiveThreadsType, String> staticPolicyRateLimitingEventiImage = null;
    private static TipoGestorePolicy tipo;
    private static String urlService;
    private static Logger logStartup;
    private static Logger log;

    private static synchronized void initialize(boolean isStartupGovWay, PolicyGroupByActiveThreadsType type) throws PolicyException {
        if (!staticMapInstance.containsKey(type)) {
            logStartup.info("Inizializzazione Gestore Policy '" + type + "' ...");
            log.info("Inizializzazione Gestore Policy '" + type + "' ...");
            Object gestore = null;
            if (TipoGestorePolicy.IN_MEMORY.equals((Object)tipo)) {
                gestore = new GestorePolicyAttiveInMemory();
                gestore.initialize(log, isStartupGovWay, type, new Object[0]);
            } else if (TipoGestorePolicy.WS.equals((Object)tipo)) {
                gestore = new GestorePolicyAttiveWS();
                gestore.initialize(log, isStartupGovWay, type, new Object[]{urlService});
            } else {
                throw new PolicyException("Tipo GestorePolicyAttive [" + tipo + "] non supportato");
            }
            staticMapInstance.put(type, (IGestorePolicyAttive)gestore);
            staticPolicyRateLimitingImage.put(type, Costanti.getControlloTrafficoImage((String)type.name()));
            staticPolicyRateLimitingEventiImage.put(type, Costanti.getControlloTrafficoEventiImage((String)type.name()));
            logStartup.info("Inizializzazione Gestore Policy '" + type + "' effettuata con successo");
            log.info("Inizializzazione Gestore Policy '" + type + "' effettuata con successo");
        }
    }

    public static synchronized void initialize(Logger logStartup, Logger log, TipoGestorePolicy tipo, String urlService, List<PolicyGroupByActiveThreadsType> inMemoryTypes) throws Exception {
        if (staticMapInstance == null) {
            if (inMemoryTypes == null || inMemoryTypes.isEmpty()) {
                throw new Exception("Almeno un tipo di gestore deve essere definito");
            }
            staticMapInstance = new HashMap<PolicyGroupByActiveThreadsType, IGestorePolicyAttive>();
            staticPolicyRateLimitingImage = new HashMap<PolicyGroupByActiveThreadsType, String>();
            staticPolicyRateLimitingEventiImage = new HashMap<PolicyGroupByActiveThreadsType, String>();
            GestorePolicyAttive.logStartup = logStartup;
            GestorePolicyAttive.log = log;
            GestorePolicyAttive.tipo = tipo;
            GestorePolicyAttive.urlService = urlService;
            for (PolicyGroupByActiveThreadsType type : inMemoryTypes) {
                GestorePolicyAttive.initialize(true, type);
            }
        }
    }

    public static List<PolicyGroupByActiveThreadsType> getTipiGestoriAttivi() throws PolicyException {
        if (staticMapInstance == null) {
            throw new PolicyException("GestorePolicyAttive non inizializzato");
        }
        ArrayList<PolicyGroupByActiveThreadsType> l = new ArrayList<PolicyGroupByActiveThreadsType>();
        l.addAll(staticMapInstance.keySet());
        return l;
    }

    public static boolean isAttivo(PolicyGroupByActiveThreadsType type) {
        if (staticMapInstance == null) {
            return false;
        }
        return staticMapInstance.containsKey(type);
    }

    public static IGestorePolicyAttive getInstance(PolicyGroupByActiveThreadsType type) throws PolicyException {
        if (staticMapInstance == null) {
            throw new PolicyException("GestorePolicyAttive non inizializzato");
        }
        IGestorePolicyAttive gestore = staticMapInstance.get(type);
        if (gestore == null) {
            GestorePolicyAttive.initialize(false, type);
            gestore = staticMapInstance.get(type);
        }
        if (gestore == null) {
            throw new PolicyException("GestorePolicyAttive '" + type + "' non inizializzato ??");
        }
        return gestore;
    }

    public static String getControlloTrafficoImage(PolicyGroupByActiveThreadsType type) throws PolicyException {
        if (staticPolicyRateLimitingImage == null) {
            throw new PolicyException("GestorePolicyAttive non inizializzato");
        }
        if (!staticPolicyRateLimitingImage.containsKey(type)) {
            throw new PolicyException("GestorePolicyAttive non inizializzato per il tipo '" + type + "'");
        }
        return staticPolicyRateLimitingImage.get(type);
    }

    public static String getControlloTrafficoEventiImage(PolicyGroupByActiveThreadsType type) throws PolicyException {
        if (staticPolicyRateLimitingEventiImage == null) {
            throw new PolicyException("GestorePolicyAttive non inizializzato");
        }
        if (!staticPolicyRateLimitingEventiImage.containsKey(type)) {
            throw new PolicyException("GestorePolicyAttive non inizializzato per il tipo '" + type + "'");
        }
        return staticPolicyRateLimitingEventiImage.get(type);
    }
}

