/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.beans.ActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.ConfigurazioneControlloTraffico;
import org.openspcoop2.core.controllo_traffico.beans.DatiTransazione;
import org.openspcoop2.core.controllo_traffico.beans.UniqueIdentifierUtilities;
import org.openspcoop2.core.controllo_traffico.driver.IGestorePolicyAttive;
import org.openspcoop2.core.controllo_traffico.driver.IPolicyGroupByActiveThreads;
import org.openspcoop2.core.controllo_traffico.driver.PolicyException;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;
import org.openspcoop2.core.controllo_traffico.driver.PolicyNotFoundException;
import org.openspcoop2.core.controllo_traffico.driver.PolicyShutdownException;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.PolicyGroupByActiveThreadsWS;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.slf4j.Logger;

public class GestorePolicyAttiveWS
implements IGestorePolicyAttive {
    private static final String IMPL_DESCR = "Implementazione WS IGestorePolicyAttive";
    private Logger log;
    private PolicyGroupByActiveThreadsType type;
    private String uriService;

    public static String getImplDescr() {
        return IMPL_DESCR;
    }

    public void initialize(Logger log, boolean isStartupGovWay, PolicyGroupByActiveThreadsType type, Object ... params) throws PolicyException {
        this.log = log;
        this.type = type;
        if (this.type == null) {
            this.type = PolicyGroupByActiveThreadsType.LOCAL;
        }
        if (params.length <= 0) {
            throw new PolicyException("URI Service not found");
        }
        if (params[0] == null || !(params[0] instanceof String)) {
            throw new PolicyException("URI Service not found (" + params[0] + ")");
        }
        this.uriService = ((String)params[0]).trim();
        if (!this.uriService.endsWith("/")) {
            this.uriService = this.uriService + "/";
        }
    }

    public PolicyGroupByActiveThreadsType getType() {
        return this.type;
    }

    public IPolicyGroupByActiveThreads getActiveThreadsPolicy(ActivePolicy activePolicy, DatiTransazione datiTransazione, Object state) throws PolicyShutdownException, PolicyException {
        try {
            String activeId = UniqueIdentifierUtilities.getUniqueId((AttivazionePolicy)activePolicy.getInstanceConfiguration());
            HashMap p = new HashMap();
            TransportUtils.setHeader(p, (String)"activeId", (String)activeId);
            String url = TransportUtils.buildUrlWithParameters(p, (String)(this.uriService + "registerPolicy"), (Logger)this.log);
            this.log.debug("[GestorePolicyAttiveWS.getActiveThreadsPolicy(ActivePolicy)] invoke (" + url + ") ...");
            HttpResponse response = HttpUtilities.getHTTPResponse((String)url);
            this.log.debug("[GestorePolicyAttiveWS.getActiveThreadsPolicy(ActivePolicy)] invoked with code [" + response.getResultHTTPOperation() + "]");
            if (response.getResultHTTPOperation() != 200) {
                throw new Exception("[httpCode:" + response.getResultHTTPOperation() + "] " + new String(response.getContent()));
            }
            PolicyGroupByActiveThreadsWS group = new PolicyGroupByActiveThreadsWS(this.uriService, activeId, this.log);
            return group;
        }
        catch (Exception e) {
            this.log.error("getActiveThreadsPolicy(ActivePolicy) error: " + e.getMessage(), (Throwable)e);
            throw new PolicyException(e.getMessage(), (Throwable)e);
        }
    }

    public IPolicyGroupByActiveThreads getActiveThreadsPolicy(String activeId) throws PolicyShutdownException, PolicyException, PolicyNotFoundException {
        try {
            HashMap p = new HashMap();
            TransportUtils.setHeader(p, (String)"activeId", (String)activeId);
            String url = TransportUtils.buildUrlWithParameters(p, (String)(this.uriService + "getPolicy"), (Logger)this.log);
            this.log.debug("[GestorePolicyAttiveWS.getActiveThreadsPolicy] invoke (" + url + ") ...");
            HttpResponse response = HttpUtilities.getHTTPResponse((String)url);
            this.log.debug("[GestorePolicyAttiveWS.getActiveThreadsPolicy] invoked with code [" + response.getResultHTTPOperation() + "]");
            if (response.getResultHTTPOperation() != 200) {
                throw new Exception("[httpCode:" + response.getResultHTTPOperation() + "] " + new String(response.getContent()));
            }
            PolicyGroupByActiveThreadsWS group = new PolicyGroupByActiveThreadsWS(this.uriService, activeId, this.log);
            return group;
        }
        catch (Exception e) {
            this.log.error("getActiveThreadsPolicy(id) error: " + e.getMessage(), (Throwable)e);
            throw new PolicyException(e.getMessage(), (Throwable)e);
        }
    }

    public long sizeActivePolicyThreads(boolean sum) throws PolicyShutdownException, PolicyException {
        try {
            HashMap p = new HashMap();
            TransportUtils.setHeader(p, (String)"sum", (String)("" + sum));
            String url = TransportUtils.buildUrlWithParameters(p, (String)(this.uriService + "sizeActiveThreadsPolicy"), (Logger)this.log);
            this.log.debug("[GestorePolicyAttiveWS.sizeActivePolicyThreads] invoke (" + url + ") ...");
            HttpResponse response = HttpUtilities.getHTTPResponse((String)url);
            this.log.debug("[GestorePolicyAttiveWS.sizeActivePolicyThreads] invoked with code [" + response.getResultHTTPOperation() + "]");
            if (response.getResultHTTPOperation() != 200) {
                throw new Exception("[httpCode:" + response.getResultHTTPOperation() + "] " + new String(response.getContent()));
            }
            return Long.parseLong(new String(response.getContent()));
        }
        catch (Exception e) {
            this.log.error("sizeActivePolicyThreads error: " + e.getMessage(), (Throwable)e);
            throw new PolicyException(e.getMessage(), (Throwable)e);
        }
    }

    public String printKeysPolicy(String separator) throws PolicyShutdownException, PolicyException {
        try {
            HashMap p = new HashMap();
            TransportUtils.setHeader(p, (String)"separator", (String)separator);
            String url = TransportUtils.buildUrlWithParameters(p, (String)(this.uriService + "printKeysPolicy"), (Logger)this.log);
            this.log.debug("[GestorePolicyAttiveWS.printKeysPolicy] invoke (" + url + ") ...");
            HttpResponse response = HttpUtilities.getHTTPResponse((String)url);
            this.log.debug("[GestorePolicyAttiveWS.printKeysPolicy] invoked with code [" + response.getResultHTTPOperation() + "]");
            if (response.getResultHTTPOperation() != 200) {
                throw new Exception("[httpCode:" + response.getResultHTTPOperation() + "] " + new String(response.getContent()));
            }
            return new String(response.getContent());
        }
        catch (Exception e) {
            this.log.error("printKeysPolicy error: " + e.getMessage(), (Throwable)e);
            throw new PolicyException(e.getMessage(), (Throwable)e);
        }
    }

    public String printInfoPolicy(String id, String separatorGroups) throws PolicyShutdownException, PolicyException, PolicyNotFoundException {
        try {
            HashMap p = new HashMap();
            TransportUtils.setHeader(p, (String)"activeId", (String)id);
            TransportUtils.setHeader(p, (String)"separator", (String)separatorGroups);
            String url = TransportUtils.buildUrlWithParameters(p, (String)(this.uriService + "printInfoPolicy"), (Logger)this.log);
            this.log.debug("[GestorePolicyAttiveWS.printInfoPolicy] invoke (" + url + ") ...");
            HttpResponse response = HttpUtilities.getHTTPResponse((String)url);
            this.log.debug("[GestorePolicyAttiveWS.printInfoPolicy] invoked with code [" + response.getResultHTTPOperation() + "]");
            if (response.getResultHTTPOperation() != 200) {
                throw new Exception("[httpCode:" + response.getResultHTTPOperation() + "] " + new String(response.getContent()));
            }
            return new String(response.getContent());
        }
        catch (Exception e) {
            this.log.error("printInfoPolicy error: " + e.getMessage(), (Throwable)e);
            throw new PolicyException(e.getMessage(), (Throwable)e);
        }
    }

    public void removeActiveThreadsPolicy(String idActivePolicy) throws PolicyShutdownException, PolicyException {
        try {
            HashMap p = new HashMap();
            TransportUtils.setHeader(p, (String)"activeId", (String)idActivePolicy);
            String url = TransportUtils.buildUrlWithParameters(p, (String)(this.uriService + "removeActiveThreadsPolicy"), (Logger)this.log);
            this.log.debug("[GestorePolicyAttiveWS.removeActiveThreadsPolicy] invoke (" + url + ") ...");
            HttpResponse response = HttpUtilities.getHTTPResponse((String)url);
            this.log.debug("[GestorePolicyAttiveWS.removeActiveThreadsPolicy] invoked with code [" + response.getResultHTTPOperation() + "]");
            if (response.getResultHTTPOperation() != 200) {
                throw new Exception("[httpCode:" + response.getResultHTTPOperation() + "] " + new String(response.getContent()));
            }
        }
        catch (Exception e) {
            this.log.error("removeActiveThreadsPolicy error: " + e.getMessage(), (Throwable)e);
            throw new PolicyException(e.getMessage(), (Throwable)e);
        }
    }

    public void removeActiveThreadsPolicyUnsafe(String idActivePolicy) throws PolicyShutdownException, PolicyException {
        try {
            HashMap p = new HashMap();
            TransportUtils.setHeader(p, (String)"activeId", (String)idActivePolicy);
            String url = TransportUtils.buildUrlWithParameters(p, (String)(this.uriService + "removeActiveThreadsPolicyUnsafe"), (Logger)this.log);
            this.log.debug("[GestorePolicyAttiveWS.removeActiveThreadsPolicyUnsafe] invoke (" + url + ") ...");
            HttpResponse response = HttpUtilities.getHTTPResponse((String)url);
            this.log.debug("[GestorePolicyAttiveWS.removeActiveThreadsPolicyUnsafe] invoked with code [" + response.getResultHTTPOperation() + "]");
            if (response.getResultHTTPOperation() != 200) {
                throw new Exception("[httpCode:" + response.getResultHTTPOperation() + "] " + new String(response.getContent()));
            }
        }
        catch (Exception e) {
            this.log.error("removeActiveThreadsPolicyUnsafe error: " + e.getMessage(), (Throwable)e);
            throw new PolicyException(e.getMessage(), (Throwable)e);
        }
    }

    public void removeAllActiveThreadsPolicy() throws PolicyShutdownException, PolicyException {
        try {
            HashMap p = new HashMap();
            String url = TransportUtils.buildUrlWithParameters(p, (String)(this.uriService + "removeAllActiveThreadsPolicy"), (Logger)this.log);
            this.log.debug("[GestorePolicyAttiveWS.removeAllActiveThreadsPolicy] invoke (" + url + ") ...");
            HttpResponse response = HttpUtilities.getHTTPResponse((String)url);
            this.log.debug("[GestorePolicyAttiveWS.removeAllActiveThreadsPolicy] invoked with code [" + response.getResultHTTPOperation() + "]");
            if (response.getResultHTTPOperation() != 200) {
                throw new Exception("[httpCode:" + response.getResultHTTPOperation() + "] " + new String(response.getContent()));
            }
        }
        catch (Exception e) {
            this.log.error("removeAllActiveThreadsPolicy error: " + e.getMessage(), (Throwable)e);
            throw new PolicyException(e.getMessage(), (Throwable)e);
        }
    }

    public void resetCountersActiveThreadsPolicy(String idActivePolicy) throws PolicyShutdownException, PolicyException {
        try {
            HashMap p = new HashMap();
            TransportUtils.setHeader(p, (String)"activeId", (String)idActivePolicy);
            String url = TransportUtils.buildUrlWithParameters(p, (String)(this.uriService + "resetCountersActiveThreadsPolicy"), (Logger)this.log);
            this.log.debug("[GestorePolicyAttiveWS.resetCountersActiveThreadsPolicy] invoke (" + url + ") ...");
            HttpResponse response = HttpUtilities.getHTTPResponse((String)url);
            this.log.debug("[GestorePolicyAttiveWS.resetCountersActiveThreadsPolicy] invoked with code [" + response.getResultHTTPOperation() + "]");
            if (response.getResultHTTPOperation() != 200) {
                throw new Exception("[httpCode:" + response.getResultHTTPOperation() + "] " + new String(response.getContent()));
            }
        }
        catch (Exception e) {
            this.log.error("resetCountersActiveThreadsPolicy error: " + e.getMessage(), (Throwable)e);
            throw new PolicyException(e.getMessage(), (Throwable)e);
        }
    }

    public void resetCountersAllActiveThreadsPolicy() throws PolicyShutdownException, PolicyException {
        try {
            HashMap p = new HashMap();
            String url = TransportUtils.buildUrlWithParameters(p, (String)(this.uriService + "resetCountersAllActiveThreadsPolicy"), (Logger)this.log);
            this.log.debug("[GestorePolicyAttiveWS.resetCountersAllActiveThreadsPolicy] invoke (" + url + ") ...");
            HttpResponse response = HttpUtilities.getHTTPResponse((String)url);
            this.log.debug("[GestorePolicyAttiveWS.resetCountersAllActiveThreadsPolicy] invoked with code [" + response.getResultHTTPOperation() + "]");
            if (response.getResultHTTPOperation() != 200) {
                throw new Exception("[httpCode:" + response.getResultHTTPOperation() + "] " + new String(response.getContent()));
            }
        }
        catch (Exception e) {
            this.log.error("resetCountersAllActiveThreadsPolicy error: " + e.getMessage(), (Throwable)e);
            throw new PolicyException(e.getMessage(), (Throwable)e);
        }
    }

    public void serialize(OutputStream out) throws PolicyException {
    }

    public void initialize(InputStream in, ConfigurazioneControlloTraffico configurazioneControlloTraffico) throws PolicyException {
    }

    public void cleanOldActiveThreadsPolicy() throws PolicyException {
    }
}

