/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.controllo_traffico.beans.ActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.DatiCollezionati;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicy;
import org.openspcoop2.core.controllo_traffico.beans.MisurazioniTransazione;
import org.openspcoop2.core.controllo_traffico.beans.UniqueIdentifierUtilities;
import org.openspcoop2.core.controllo_traffico.driver.IPolicyGroupByActiveThreadsInMemory;
import org.openspcoop2.core.controllo_traffico.driver.PolicyException;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;
import org.openspcoop2.core.controllo_traffico.driver.PolicyNotFoundException;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.core.controllo_traffico.policy.PolicyDateUtils;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.OperationType;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.PolicyConnessioneRuntime;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.UpdateResult;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.serialization.JavaDeserializer;
import org.openspcoop2.utils.serialization.JavaSerializer;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.slf4j.Logger;

public class PolicyGroupByActiveThreadsDB
implements Serializable,
IPolicyGroupByActiveThreadsInMemory {
    private static final long serialVersionUID = 1L;
    private static final String CT_MAP_TABLE = "ct_map";
    private static final String CT_MAP_COLUMN_KEY = "map_key";
    private static final String CT_MAP_COLUMN_UPDATE_TIME = "map_update_time";
    private static final String CT_MAP_COLUMN_VALUE = "map_value";
    private static Random _rnd = null;
    private volatile boolean mapExists = false;
    private ActivePolicy activePolicy;
    private PolicyGroupByActiveThreadsType tipoGestore;
    private String uniqueIdMap_idActivePolicy;
    private Date uniqueIdMap_updateTime;
    private IState state;
    private IDSoggetto dominio;
    private String idTransazione;
    private transient OpenSPCoop2Properties _op2Properties;
    private String tipoDatabase;
    private IJDBCAdapter jdbcAdapter;
    private transient JavaSerializer _javaSerializer = null;
    private transient JavaDeserializer _javaDeserializer = null;
    private Logger log;
    private Logger logSql;
    private boolean debug;
    private boolean transactionMode = true;
    private long attesaAttivaJDBC;
    private int checkIntervalloJDBC;
    private transient Semaphore _lock_checkMap = null;

    private static synchronized void initRandom() {
        if (_rnd == null) {
            _rnd = new SecureRandom();
        }
    }

    public static Random getRandom() {
        if (_rnd == null) {
            PolicyGroupByActiveThreadsDB.initRandom();
        }
        return _rnd;
    }

    public PolicyGroupByActiveThreadsDB(ActivePolicy activePolicy, PolicyGroupByActiveThreadsType tipoGestore, String uniqueIdMap, IState state, IDSoggetto dominio, String idTransazione) throws PolicyException {
        this.activePolicy = activePolicy;
        this.tipoGestore = tipoGestore;
        this.uniqueIdMap_idActivePolicy = UniqueIdentifierUtilities.extractIdActivePolicy((String)uniqueIdMap);
        try {
            this.uniqueIdMap_updateTime = UniqueIdentifierUtilities.extractUpdateTimeActivePolicy((String)uniqueIdMap);
        }
        catch (Exception e) {
            throw new PolicyException(e.getMessage(), (Throwable)e);
        }
        this.state = state;
        this.dominio = dominio;
        this.idTransazione = idTransazione;
        this._op2Properties = OpenSPCoop2Properties.getInstance();
        this.tipoDatabase = this._op2Properties.getDatabaseType();
        try {
            this.jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)this.tipoDatabase);
        }
        catch (Exception e) {
            throw new PolicyException("[createJDBCAdapter] " + e.getMessage(), (Throwable)e);
        }
        this._javaSerializer = new JavaSerializer();
        this._javaDeserializer = new JavaDeserializer();
        this.debug = this._op2Properties.isControlloTrafficoDebug();
        this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopControlloTraffico(this.debug);
        this.logSql = OpenSPCoop2Logger.getLoggerOpenSPCoopControlloTrafficoSql(this.debug);
        this.transactionMode = this._op2Properties.isControlloTrafficoGestorePolicyInMemoryDatabaseUseTransaction();
        this.attesaAttivaJDBC = this._op2Properties.getControlloTrafficoGestorePolicyInMemoryDatabaseSerializableDBAttesaAttiva();
        this.checkIntervalloJDBC = this._op2Properties.getControlloTrafficoGestorePolicyInMemoryDatabaseSerializableDBCheckInterval();
    }

    private synchronized void initJavaSerializer() {
        if (this._javaSerializer == null) {
            this._javaSerializer = new JavaSerializer();
        }
    }

    public JavaSerializer getJavaSerializer() {
        if (this._javaSerializer == null) {
            this.initJavaSerializer();
        }
        return this._javaSerializer;
    }

    private synchronized void initJavaDeserializer() {
        if (this._javaDeserializer == null) {
            this._javaDeserializer = new JavaDeserializer();
        }
    }

    public JavaDeserializer getJavaDeserializer() {
        if (this._javaDeserializer == null) {
            this.initJavaDeserializer();
        }
        return this._javaDeserializer;
    }

    private synchronized void initOpenSPCoop2Properties() {
        if (this._op2Properties == null) {
            this._op2Properties = OpenSPCoop2Properties.getInstance();
        }
    }

    public OpenSPCoop2Properties getOpenSPCoop2Properties() {
        if (this._op2Properties == null) {
            this.initOpenSPCoop2Properties();
        }
        return this._op2Properties;
    }

    public ActivePolicy getActivePolicy() {
        return this.activePolicy;
    }

    public Map<IDUnivocoGroupByPolicy, DatiCollezionati> getMapActiveThreads() {
        PolicyConnessioneRuntime resource = null;
        try {
            resource = this.getConnessione(this.state, this.dominio, "getMapActiveThreads", this.idTransazione, null);
            Map<IDUnivocoGroupByPolicy, DatiCollezionati> map = this._getMapActiveThreads(resource.con);
            return map;
        }
        catch (Throwable e) {
            this.log.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (resource != null) {
                this.releaseConnessione(resource, this.dominio, "getMapActiveThreads", null);
            }
        }
    }

    public void initMap(Map<IDUnivocoGroupByPolicy, DatiCollezionati> map) {
    }

    public void resetCounters() {
        PolicyConnessioneRuntime resource = null;
        try {
            resource = this.getConnessione(this.state, this.dominio, "resetCounters", this.idTransazione, null);
            this._resetCounters(resource.con);
        }
        catch (Throwable e) {
            this.log.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (resource != null) {
                this.releaseConnessione(resource, this.dominio, "resetCounters", null);
            }
        }
    }

    public void remove() throws UtilsException {
        PolicyConnessioneRuntime resource = null;
        try {
            resource = this.getConnessione(this.state, this.dominio, "remove", this.idTransazione, null);
            this._remove(resource.con);
        }
        catch (Throwable e) {
            this.log.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (resource != null) {
                this.releaseConnessione(resource, this.dominio, "remove", null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatiCollezionati registerStartRequest(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, org.openspcoop2.utils.Map<Object> ctx) throws PolicyException {
        PolicyConnessioneRuntime resource = null;
        DatiCollezionati datiCollezionatiReaded = null;
        try {
            resource = this.getConnessione(this.state, this.dominio, "registerStartRequest", idTransazione, ctx);
            this.checkMap(resource.con);
            datiCollezionatiReaded = this._registerStartRequest(resource.con, log, idTransazione, datiGroupBy, ctx);
        }
        finally {
            if (resource != null) {
                this.releaseConnessione(resource, this.dominio, "registerStartRequest", ctx);
            }
        }
        return datiCollezionatiReaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatiCollezionati updateDatiStartRequestApplicabile(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, org.openspcoop2.utils.Map<Object> ctx) throws PolicyException, PolicyNotFoundException {
        PolicyConnessioneRuntime resource = null;
        DatiCollezionati datiCollezionatiReaded = null;
        try {
            resource = this.getConnessione(this.state, this.dominio, "updateDatiStartRequestApplicabile", idTransazione, ctx);
            datiCollezionatiReaded = this._updateDatiStartRequestApplicabile(resource.con, log, idTransazione, datiGroupBy, ctx);
        }
        finally {
            if (resource != null) {
                this.releaseConnessione(resource, this.dominio, "updateDatiStartRequestApplicabile", ctx);
            }
        }
        return datiCollezionatiReaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStopRequest(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, org.openspcoop2.utils.Map<Object> ctx, MisurazioniTransazione dati, boolean isApplicabile, boolean isViolata) throws PolicyException, PolicyNotFoundException {
        PolicyConnessioneRuntime resource = null;
        try {
            resource = this.getConnessione(this.state, this.dominio, "registerStopRequest", idTransazione, ctx);
            this._registerStopRequest(resource.con, log, idTransazione, datiGroupBy, ctx, dati, isApplicabile, isViolata);
        }
        finally {
            if (resource != null) {
                this.releaseConnessione(resource, this.dominio, "registerStopRequest", ctx);
            }
        }
    }

    public long getActiveThreads() {
        return this.getActiveThreads(null);
    }

    public long getActiveThreads(IDUnivocoGroupByPolicy filtro) {
        PolicyConnessioneRuntime resource = null;
        try {
            resource = this.getConnessione(this.state, this.dominio, "getActiveThreads", this.idTransazione, null);
            long l = this._getActiveThreads(resource.con, filtro);
            return l;
        }
        catch (Throwable e) {
            this.log.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (resource != null) {
                this.releaseConnessione(resource, this.dominio, "getActiveThreads", null);
            }
        }
    }

    public String printInfos(Logger log, String separatorGroups) throws UtilsException {
        PolicyConnessioneRuntime resource = null;
        try {
            resource = this.getConnessione(this.state, this.dominio, "printInfos", this.idTransazione, null);
            String string = this._printInfos(resource.con, log, separatorGroups);
            return string;
        }
        catch (Throwable e) {
            this.log.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (resource != null) {
                this.releaseConnessione(resource, this.dominio, "printInfos", null);
            }
        }
    }

    private PolicyConnessioneRuntime getConnessione(IState state, IDSoggetto dominio, String funzione, String idTransazione, org.openspcoop2.utils.Map<Object> ctx) throws PolicyException {
        DBManager dbManager = null;
        Resource r = null;
        String modulo = null;
        try {
            StateMessage s;
            Connection con = null;
            if (state != null && state instanceof StateMessage && (s = (StateMessage)state).getConnectionDB() != null && !s.getConnectionDB().isClosed() && (con = s.getConnectionDB()) != null) {
                PolicyConnessioneRuntime cr = new PolicyConnessioneRuntime();
                cr.con = con;
                return cr;
            }
            if (dominio == null) {
                String protocolName = null;
                if (ctx != null && ctx.containsKey(Costanti.PROTOCOL_NAME)) {
                    protocolName = (String)ctx.getObject(Costanti.PROTOCOL_NAME);
                }
                RequestInfo requestInfo = null;
                if (ctx != null && ctx.containsKey(Costanti.REQUEST_INFO)) {
                    requestInfo = (RequestInfo)ctx.getObject(Costanti.REQUEST_INFO);
                }
                dominio = OpenSPCoop2Properties.getInstance().getIdentitaPortaDefault(protocolName, requestInfo);
            }
            modulo = "RateLimitingActiveThreadsDB." + funzione;
            dbManager = DBManager.getInstance();
            r = dbManager.getResource(dominio, modulo, idTransazione);
            if (r == null) {
                throw new Exception("Risorsa al database non disponibile");
            }
            con = (Connection)r.getResource();
            if (con == null) {
                throw new Exception("Connessione non disponibile");
            }
            PolicyConnessioneRuntime cr = new PolicyConnessioneRuntime();
            cr.con = con;
            cr.r = r;
            return cr;
        }
        catch (Throwable e) {
            if (r != null) {
                try {
                    dbManager.releaseResource(dominio, modulo, r);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw new PolicyException(e.getMessage(), e);
        }
    }

    private void releaseConnessione(PolicyConnessioneRuntime p, IDSoggetto dominio, String funzione, org.openspcoop2.utils.Map<Object> ctx) {
        if (p.r != null) {
            if (dominio == null) {
                String protocolName = null;
                if (ctx != null && ctx.containsKey(Costanti.PROTOCOL_NAME)) {
                    protocolName = (String)ctx.getObject(Costanti.PROTOCOL_NAME);
                }
                RequestInfo requestInfo = null;
                if (ctx != null && ctx.containsKey(Costanti.REQUEST_INFO)) {
                    requestInfo = (RequestInfo)ctx.getObject(Costanti.REQUEST_INFO);
                }
                dominio = OpenSPCoop2Properties.getInstance().getIdentitaPortaDefault(protocolName, requestInfo);
            }
            DBManager.getInstance().releaseResource(dominio, "RateLimitingActiveThreadsDB." + funzione, p.r);
        }
    }

    private synchronized void initLockCheckMap() {
        if (this._lock_checkMap == null) {
            this._lock_checkMap = new Semaphore("PolicyGroupByActiveThreadsDB_checkMap");
        }
    }

    public Semaphore getLockCheckMap() {
        if (this._lock_checkMap == null) {
            this.initLockCheckMap();
        }
        return this._lock_checkMap;
    }

    private void checkMap(Connection con) throws PolicyException {
        if (!this.mapExists) {
            this._checkMap(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _checkMap(Connection con) throws PolicyException {
        block53: {
            SemaphoreLock lock = this.getLockCheckMap().acquireThrowRuntime("checkMap");
            try {
                if (this.mapExists) break block53;
                PreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    ISQLQueryObject sqlGet = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                    sqlGet.addSelectField(CT_MAP_COLUMN_KEY);
                    sqlGet.addFromTable(CT_MAP_TABLE);
                    sqlGet.setANDLogicOperator(true);
                    sqlGet.addWhereCondition("map_key=?");
                    String query = sqlGet.createSQLQuery();
                    if (this.debug) {
                        this.logSql.debug("[checkMap" + this.idTransazione + "] execute " + DBUtils.formatSQLString((String)query, (Object[])new Object[]{this.uniqueIdMap_idActivePolicy}));
                    }
                    pstmt = con.prepareStatement(query);
                    pstmt.setString(1, this.uniqueIdMap_idActivePolicy);
                    rs = pstmt.executeQuery();
                    if (rs == null) {
                        pstmt.close();
                        throw new UtilsException("CheckMap failed: ResultSet is null?");
                    }
                    boolean exist = rs.next();
                    if (this.debug) {
                        this.logSql.debug("[checkMap" + this.idTransazione + "] executed (result:" + exist + ") " + DBUtils.formatSQLString((String)query, (Object[])new Object[]{this.uniqueIdMap_idActivePolicy}));
                    }
                    rs.close();
                    pstmt.close();
                    if (!exist) {
                        try {
                            if (con.isClosed()) {
                                throw new UtilsException("Connessione risulta gi\u00e0 chiusa");
                            }
                        }
                        catch (Exception e) {
                            throw new UtilsException("CheckMap failed: connection closed; " + e.getMessage(), (Throwable)e);
                        }
                        boolean originalConnectionAutocommit = false;
                        boolean autoCommitModificato = false;
                        try {
                            originalConnectionAutocommit = con.getAutoCommit();
                        }
                        catch (Exception e) {
                            throw new UtilsException("CheckMap failed: autocommit mode disabled; " + e.getMessage(), (Throwable)e);
                        }
                        if (!originalConnectionAutocommit) {
                            throw new UtilsException("CheckMap failed: autocommit mode disabled; non e' possibile fornire una connessione con autocommit disabilitato poiche' l'utility ha necessita' di effettuare operazioni di commit/rollback)");
                        }
                        int originalConnectionTransactionIsolation = -1;
                        boolean transactionIsolationModificato = false;
                        try {
                            originalConnectionTransactionIsolation = con.getTransactionIsolation();
                        }
                        catch (Exception e) {
                            throw new UtilsException("Lettura livello di isolamento transazione della Connessione non riuscito: " + e.getMessage(), (Throwable)e);
                        }
                        try {
                            try {
                                try {
                                    con.rollback();
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                JDBCUtilities.setTransactionIsolationSerializable((String)this.tipoDatabase, (Connection)con);
                                transactionIsolationModificato = true;
                                if (originalConnectionAutocommit) {
                                    con.setAutoCommit(false);
                                    autoCommitModificato = true;
                                }
                            }
                            catch (Exception er) {
                                throw new UtilsException("CheckMap failed: setting connection error; " + er.getMessage(), (Throwable)er);
                            }
                            long scadenzaWhile = DateManager.getTimeMillis() + this.attesaAttivaJDBC;
                            boolean transactionInsertFinished = false;
                            int iteration = 0;
                            while (!transactionInsertFinished && DateManager.getTimeMillis() < scadenzaWhile) {
                                try {
                                    sqlGet = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                                    sqlGet.addSelectField(CT_MAP_COLUMN_KEY);
                                    sqlGet.addFromTable(CT_MAP_TABLE);
                                    sqlGet.setANDLogicOperator(true);
                                    sqlGet.addWhereCondition("map_key=?");
                                    sqlGet.setSelectForUpdate(true);
                                    query = sqlGet.createSQLQuery();
                                    if (this.debug) {
                                        this.logSql.debug("[checkMap" + this.idTransazione + "] (forUpdate) execute " + DBUtils.formatSQLString((String)query, (Object[])new Object[]{this.uniqueIdMap_idActivePolicy}));
                                    }
                                    pstmt = con.prepareStatement(query);
                                    pstmt.setString(1, this.uniqueIdMap_idActivePolicy);
                                    rs = pstmt.executeQuery();
                                    if (rs == null) {
                                        pstmt.close();
                                        throw new UtilsException("CheckMap failed: ResultSet is null?");
                                    }
                                    exist = rs.next();
                                    if (this.debug) {
                                        this.logSql.debug("[checkMap" + this.idTransazione + "] (forUpdate) executed (result:" + exist + ") " + DBUtils.formatSQLString((String)query, (Object[])new Object[]{this.uniqueIdMap_idActivePolicy}));
                                    }
                                    rs.close();
                                    pstmt.close();
                                    if (!exist) {
                                        HashMap mapActiveThreads = new HashMap();
                                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                                        this.getJavaSerializer().writeObject(mapActiveThreads, (OutputStream)bout);
                                        bout.flush();
                                        bout.close();
                                        StringBuilder queryInsert = new StringBuilder();
                                        ISQLQueryObject sqlInsert = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                                        sqlInsert.addInsertTable(CT_MAP_TABLE);
                                        sqlInsert.addInsertField(CT_MAP_COLUMN_KEY, "?");
                                        sqlInsert.addInsertField(CT_MAP_COLUMN_UPDATE_TIME, "?");
                                        sqlInsert.addInsertField(CT_MAP_COLUMN_VALUE, "?");
                                        queryInsert.append(sqlInsert.createSQLInsert());
                                        if (this.debug) {
                                            this.logSql.debug("[checkMap" + this.idTransazione + "] execute " + DBUtils.formatSQLString((String)queryInsert.toString(), (Object[])new Object[]{this.uniqueIdMap_idActivePolicy, DateUtils.getSimpleDateFormatMs().format(this.uniqueIdMap_updateTime), "blob-size:" + bout.size()}));
                                        }
                                        pstmt = con.prepareStatement(queryInsert.toString());
                                        pstmt.setString(1, this.uniqueIdMap_idActivePolicy);
                                        Timestamp t = new Timestamp(this.uniqueIdMap_updateTime.getTime());
                                        pstmt.setTimestamp(2, t);
                                        this.jdbcAdapter.setBinaryData(pstmt, 3, bout.toByteArray());
                                        int rows = pstmt.executeUpdate();
                                        pstmt.close();
                                        if (this.debug) {
                                            this.logSql.debug("[checkMap" + this.idTransazione + "] executed (rows:" + rows + ") " + DBUtils.formatSQLString((String)queryInsert.toString(), (Object[])new Object[]{this.uniqueIdMap_idActivePolicy, DateUtils.getSimpleDateFormatMs().format(this.uniqueIdMap_updateTime), "blob-size:" + bout.size()}));
                                        }
                                    }
                                    con.commit();
                                    transactionInsertFinished = true;
                                }
                                catch (Throwable e) {
                                    if (this.debug) {
                                        this.logSql.debug("Transaction error: " + e.getMessage(), e);
                                    }
                                    try {
                                        if (rs != null) {
                                            rs.close();
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    try {
                                        if (pstmt != null) {
                                            pstmt.close();
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    try {
                                        con.rollback();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (!transactionInsertFinished) {
                                    try {
                                        int sleep = PolicyGroupByActiveThreadsDB.getRandom().nextInt(this.checkIntervalloJDBC);
                                        Utilities.sleep((long)sleep);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                ++iteration;
                            }
                            if (!transactionInsertFinished) {
                                throw new Exception("Check non riuscito dopo '" + iteration + "' tentativi");
                            }
                            break block53;
                        }
                        finally {
                            block54: {
                                try {
                                    if (transactionIsolationModificato) {
                                        con.setTransactionIsolation(originalConnectionTransactionIsolation);
                                    }
                                    if (autoCommitModificato) {
                                        con.setAutoCommit(originalConnectionAutocommit);
                                    }
                                }
                                catch (Exception er) {
                                    if (this.log == null) break block54;
                                    this.log.error("CheckMap failed: unsetting connection error; " + er.getMessage(), (Throwable)er);
                                }
                            }
                        }
                    }
                    this.mapExists = true;
                }
                catch (Throwable e) {
                    throw new PolicyException(e.getMessage(), e);
                }
            }
            finally {
                this.getLockCheckMap().release(lock, "checkMap");
            }
        }
    }

    private Map<IDUnivocoGroupByPolicy, DatiCollezionati> _getMapActiveThreads(Connection con) {
        try {
            return this._updateMap((Connection)con, (OperationType)OperationType.getMapActiveThreads, (Logger)this.log, (String)this.idTransazione, null, null, null, (boolean)false, (boolean)false, null, null).map;
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void _initMap(Connection con, Map<IDUnivocoGroupByPolicy, DatiCollezionati> map) {
        try {
            if (map != null && map.size() > 0) {
                this._updateMap(con, OperationType.initMap, this.log, this.idTransazione, null, null, null, false, false, null, map);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private DatiCollezionati _registerStartRequest(Connection con, Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, org.openspcoop2.utils.Map<Object> ctx) throws PolicyException {
        try {
            return this._updateMap((Connection)con, (OperationType)OperationType.registerStartRequest, (Logger)log, (String)idTransazione, (IDUnivocoGroupByPolicy)datiGroupBy, ctx, null, (boolean)false, (boolean)false, null, null).datiCollezionatiReaded;
        }
        catch (PolicyNotFoundException e) {
            throw new PolicyException(e.getMessage(), (Throwable)e);
        }
    }

    private DatiCollezionati _updateDatiStartRequestApplicabile(Connection con, Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, org.openspcoop2.utils.Map<Object> ctx) throws PolicyException, PolicyNotFoundException {
        return this._updateMap((Connection)con, (OperationType)OperationType.updateDatiStartRequestApplicabile, (Logger)log, (String)idTransazione, (IDUnivocoGroupByPolicy)datiGroupBy, ctx, null, (boolean)false, (boolean)false, null, null).datiCollezionatiReaded;
    }

    private void _registerStopRequest(Connection con, Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, org.openspcoop2.utils.Map<Object> ctx, MisurazioniTransazione dati, boolean isApplicabile, boolean isViolata) throws PolicyException, PolicyNotFoundException {
        this._updateMap(con, OperationType.registerStopRequest, log, idTransazione, datiGroupBy, ctx, dati, isApplicabile, isViolata, null, null);
    }

    private void _resetCounters(Connection con) {
        try {
            this._updateMap(con, OperationType.resetCounters, this.log, this.idTransazione, null, null, null, false, false, null, null);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void _remove(Connection con) {
        try {
            this._updateMap(con, OperationType.remove, this.log, this.idTransazione, null, null, null, false, false, null, null);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private long _getActiveThreads(Connection con, IDUnivocoGroupByPolicy filtro) {
        try {
            return this._updateMap((Connection)con, (OperationType)OperationType.getActiveThreads, (Logger)this.log, (String)this.idTransazione, (IDUnivocoGroupByPolicy)filtro, null, null, (boolean)false, (boolean)false, null, null).counter;
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private String _printInfos(Connection con, Logger log, String separatorGroups) throws UtilsException {
        try {
            return this._updateMap((Connection)con, (OperationType)OperationType.printInfos, (Logger)log, (String)this.idTransazione, null, null, null, (boolean)false, (boolean)false, (String)separatorGroups, null).info;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateResult _updateMap(Connection con, OperationType opType, Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, org.openspcoop2.utils.Map<Object> ctx, MisurazioniTransazione dati, boolean isApplicabile, boolean isViolata, String separatorGroups, Map<IDUnivocoGroupByPolicy, DatiCollezionati> map) throws PolicyException, PolicyNotFoundException {
        UpdateResult updateResult = new UpdateResult();
        try {
            if (con.isClosed()) {
                throw new UtilsException("Connessione risulta gi\u00e0 chiusa");
            }
        }
        catch (Exception e) {
            throw new PolicyException("CheckMap failed: connection closed; " + e.getMessage(), (Throwable)e);
        }
        boolean originalConnectionAutocommit = false;
        boolean autoCommitModificato = false;
        try {
            originalConnectionAutocommit = con.getAutoCommit();
        }
        catch (Exception e) {
            throw new PolicyException("CheckMap failed: autocommit mode disabled; " + e.getMessage(), (Throwable)e);
        }
        if (!originalConnectionAutocommit) {
            throw new PolicyException("CheckMap failed: autocommit mode disabled; non e' possibile fornire una connessione con autocommit disabilitato poiche' l'utility ha necessita' di effettuare operazioni di commit/rollback)");
        }
        try {
            if (this.transactionMode) {
                try {
                    try {
                        con.rollback();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (originalConnectionAutocommit) {
                        con.setAutoCommit(false);
                        autoCommitModificato = true;
                    }
                }
                catch (Exception er) {
                    throw new PolicyException("CheckMap failed: setting connection error; " + er.getMessage(), (Throwable)er);
                }
            }
            long scadenzaWhile = DateManager.getTimeMillis() + this.attesaAttivaJDBC;
            boolean transactionUpdateFinished = false;
            int iteration = 0;
            PolicyNotFoundException policyNotFoundException = null;
            PolicyException policyException = null;
            while (!transactionUpdateFinished && DateManager.getTimeMillis() < scadenzaWhile) {
                try {
                    boolean deleteMap;
                    block131: {
                        PreparedStatement preparedStatement;
                        ISQLQueryObject sqlGet = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                        sqlGet.addSelectField(CT_MAP_COLUMN_VALUE);
                        sqlGet.addSelectField(CT_MAP_COLUMN_UPDATE_TIME);
                        sqlGet.addFromTable(CT_MAP_TABLE);
                        sqlGet.setANDLogicOperator(true);
                        sqlGet.addWhereCondition("map_key=?");
                        if (this.transactionMode) {
                            sqlGet.setSelectForUpdate(true);
                        }
                        ResultSet rsMap = null;
                        Map<Object, Object> mapActiveThreads = null;
                        boolean updateDate = false;
                        String query = sqlGet.createSQLQuery();
                        if (this.debug) {
                            this.logSql.debug("[updateMap" + this.idTransazione + "] (forUpdate) execute " + DBUtils.formatSQLString((String)query, (Object[])new Object[]{this.uniqueIdMap_idActivePolicy}));
                        }
                        try (PreparedStatement pstmtMap = con.prepareStatement(query);){
                            pstmtMap.setString(1, this.uniqueIdMap_idActivePolicy);
                            try {
                                rsMap = pstmtMap.executeQuery();
                                if (rsMap == null) {
                                    throw new UtilsException("CheckMap failed: ResultSet is null?");
                                }
                                boolean exist = rsMap.next();
                                if (this.debug) {
                                    this.logSql.debug("[updateMap" + this.idTransazione + "] (forUpdate) executed (result:" + exist + ") " + DBUtils.formatSQLString((String)query, (Object[])new Object[]{this.uniqueIdMap_idActivePolicy}));
                                }
                                if (!exist) {
                                    if (!(OperationType.getMapActiveThreads.equals((Object)opType) || OperationType.resetCounters.equals((Object)opType) || OperationType.remove.equals((Object)opType) || OperationType.getActiveThreads.equals((Object)opType) || OperationType.printInfos.equals((Object)opType))) {
                                        throw new Exception("Map with id '" + this.uniqueIdMap_idActivePolicy + "' not found ?");
                                    }
                                } else {
                                    Timestamp tCheck = rsMap.getTimestamp(CT_MAP_COLUMN_UPDATE_TIME);
                                    if (this.uniqueIdMap_updateTime.equals(tCheck)) {
                                        try (InputStream is = this.jdbcAdapter.getBinaryStream(rsMap, CT_MAP_COLUMN_VALUE);){
                                            mapActiveThreads = (Map)this.getJavaDeserializer().readObject(is, Map.class);
                                        }
                                    } else {
                                        mapActiveThreads = new HashMap<IDUnivocoGroupByPolicy, DatiCollezionati>();
                                        updateDate = true;
                                    }
                                    if (!(mapActiveThreads != null || OperationType.getMapActiveThreads.equals((Object)opType) || OperationType.resetCounters.equals((Object)opType) || OperationType.getActiveThreads.equals((Object)opType) || OperationType.printInfos.equals((Object)opType))) {
                                        throw new Exception("Map with id '" + this.uniqueIdMap_idActivePolicy + "' null ?");
                                    }
                                }
                            }
                            finally {
                                try {
                                    if (rsMap != null) {
                                        rsMap.close();
                                    }
                                }
                                catch (Throwable exist) {}
                            }
                        }
                        DatiCollezionati datiCollezionati = null;
                        deleteMap = false;
                        boolean updateMap = false;
                        switch (opType) {
                            case getMapActiveThreads: {
                                updateResult.map = mapActiveThreads;
                                break;
                            }
                            case initMap: {
                                if (map == null || map.size() <= 0) break;
                                if (mapActiveThreads == null) {
                                    throw new Exception("Map with id '" + this.uniqueIdMap_idActivePolicy + "' null ?");
                                }
                                mapActiveThreads.putAll(map);
                                updateMap = true;
                                break;
                            }
                            case registerStartRequest: {
                                if (mapActiveThreads == null) {
                                    throw new Exception("Map with id '" + this.uniqueIdMap_idActivePolicy + "' null ?");
                                }
                                try {
                                    if (mapActiveThreads.containsKey(datiGroupBy)) {
                                        datiCollezionati = (DatiCollezionati)mapActiveThreads.get(datiGroupBy);
                                    } else {
                                        Date gestorePolicyConfigDate = PolicyDateUtils.readGestorePolicyConfigDateIntoContext(ctx);
                                        datiCollezionati = new DatiCollezionati(this.activePolicy.getInstanceConfiguration().getUpdateTime(), gestorePolicyConfigDate);
                                        mapActiveThreads.put(datiGroupBy, datiCollezionati);
                                    }
                                    datiCollezionati.registerStartRequest(log, this.activePolicy, ctx);
                                    updateMap = true;
                                    updateResult.datiCollezionatiReaded = datiCollezionati.newInstance();
                                }
                                catch (Exception e) {
                                    policyException = new PolicyException(e.getMessage(), (Throwable)e);
                                    transactionUpdateFinished = true;
                                }
                                break;
                            }
                            case updateDatiStartRequestApplicabile: {
                                if (mapActiveThreads == null) {
                                    throw new Exception("Map with id '" + this.uniqueIdMap_idActivePolicy + "' null ?");
                                }
                                try {
                                    if (!mapActiveThreads.containsKey(datiGroupBy)) {
                                        policyNotFoundException = new PolicyNotFoundException("Non sono presenti alcun threads registrati per la richiesta con dati identificativi [" + datiGroupBy.toString() + "]");
                                        transactionUpdateFinished = true;
                                        break;
                                    }
                                    datiCollezionati = (DatiCollezionati)mapActiveThreads.get(datiGroupBy);
                                    boolean updated = datiCollezionati.updateDatiStartRequestApplicabile(log, this.activePolicy, ctx);
                                    if (!updated) break;
                                    updateMap = true;
                                    updateResult.datiCollezionatiReaded = datiCollezionati.newInstance();
                                }
                                catch (Exception e) {
                                    policyException = new PolicyException(e.getMessage(), (Throwable)e);
                                    transactionUpdateFinished = true;
                                }
                                break;
                            }
                            case registerStopRequest: {
                                if (mapActiveThreads == null) {
                                    throw new Exception("Map with id '" + this.uniqueIdMap_idActivePolicy + "' null ?");
                                }
                                try {
                                    if (!mapActiveThreads.containsKey(datiGroupBy)) {
                                        policyNotFoundException = new PolicyNotFoundException("Non sono presenti alcun threads registrati per la richiesta con dati identificativi [" + datiGroupBy.toString() + "]");
                                        transactionUpdateFinished = true;
                                        break;
                                    }
                                    datiCollezionati = (DatiCollezionati)mapActiveThreads.get(datiGroupBy);
                                    datiCollezionati.registerEndRequest(log, this.activePolicy, ctx, dati);
                                    if (isApplicabile) {
                                        EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)dati.getProtocollo());
                                        List list = esitiProperties.getEsitiCodeOk_senzaFaultApplicativo();
                                        List esitiCodeKo_senzaFaultApplicativo = esitiProperties.getEsitiCodeKo_senzaFaultApplicativo();
                                        List list2 = esitiProperties.getEsitiCodeFaultApplicativo();
                                        datiCollezionati.updateDatiEndRequestApplicabile(log, this.activePolicy, ctx, dati, list, esitiCodeKo_senzaFaultApplicativo, list2, isViolata);
                                    }
                                    updateMap = true;
                                }
                                catch (Exception e) {
                                    policyException = new PolicyException(e.getMessage(), (Throwable)e);
                                    transactionUpdateFinished = true;
                                }
                                break;
                            }
                            case resetCounters: {
                                if (mapActiveThreads == null || mapActiveThreads.size() <= 0) break;
                                for (DatiCollezionati datiCollezionati2 : mapActiveThreads.values()) {
                                    datiCollezionati2.resetCounters();
                                }
                                updateMap = true;
                                break;
                            }
                            case remove: {
                                if (mapActiveThreads == null) break;
                                deleteMap = true;
                                break;
                            }
                            case getActiveThreads: {
                                try {
                                    long counter = 0L;
                                    if (mapActiveThreads != null && !mapActiveThreads.isEmpty()) {
                                        for (IDUnivocoGroupByPolicy iDUnivocoGroupByPolicy : mapActiveThreads.keySet()) {
                                            IDUnivocoGroupByPolicy idAstype;
                                            if (datiGroupBy != null && !(idAstype = iDUnivocoGroupByPolicy).match((Object)datiGroupBy)) continue;
                                            counter += ((DatiCollezionati)mapActiveThreads.get(iDUnivocoGroupByPolicy)).getActiveRequestCounter().longValue();
                                        }
                                    }
                                    updateResult.counter = counter;
                                }
                                catch (Exception e) {
                                    policyException = new PolicyException(e.getMessage(), (Throwable)e);
                                    transactionUpdateFinished = true;
                                }
                                break;
                            }
                            case printInfos: {
                                StringBuilder bf = new StringBuilder();
                                if (mapActiveThreads != null && !mapActiveThreads.isEmpty()) {
                                    for (IDUnivocoGroupByPolicy check : mapActiveThreads.keySet()) {
                                        bf.append(separatorGroups);
                                        bf.append("\n");
                                        bf.append("Sincronizzazione").append(" ").append(this.tipoGestore.toLabel());
                                        bf.append("\n");
                                        bf.append("Criterio di Collezionamento dei Dati\n");
                                        bf.append(check.toString(true));
                                        bf.append("\n");
                                        ((DatiCollezionati)mapActiveThreads.get(check)).checkDate(log, this.activePolicy);
                                        bf.append(((DatiCollezionati)mapActiveThreads.get(check)).toString());
                                        bf.append("\n");
                                    }
                                }
                                if (bf.length() <= 0) {
                                    bf.append("Nessuna informazione disponibile");
                                    updateResult.info = bf.toString();
                                    break;
                                }
                                updateResult.info = bf.toString() + separatorGroups;
                            }
                        }
                        if (!updateMap) break block131;
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        this.getJavaSerializer().writeObject(mapActiveThreads, (OutputStream)bout);
                        bout.flush();
                        bout.close();
                        ISQLQueryObject iSQLQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                        iSQLQueryObject.addUpdateTable(CT_MAP_TABLE);
                        if (updateDate) {
                            iSQLQueryObject.addUpdateField(CT_MAP_COLUMN_UPDATE_TIME, "?");
                        }
                        iSQLQueryObject.addUpdateField(CT_MAP_COLUMN_VALUE, "?");
                        iSQLQueryObject.setANDLogicOperator(true);
                        iSQLQueryObject.addWhereCondition("map_key=?");
                        String queryUpdate = iSQLQueryObject.createSQLUpdate();
                        if (this.debug) {
                            if (updateDate) {
                                this.logSql.debug("[updateMap" + this.idTransazione + "] execute " + DBUtils.formatSQLString((String)queryUpdate, (Object[])new Object[]{DateUtils.getSimpleDateFormatMs().format(this.uniqueIdMap_updateTime), "blob-size:" + bout.size(), this.uniqueIdMap_idActivePolicy}));
                            } else {
                                this.logSql.debug("[updateMap" + this.idTransazione + "] execute " + DBUtils.formatSQLString((String)queryUpdate, (Object[])new Object[]{"blob-size:" + bout.size(), this.uniqueIdMap_idActivePolicy}));
                            }
                        }
                        Statement statement = null;
                        int rows = -1;
                        try {
                            preparedStatement = con.prepareStatement(queryUpdate);
                            int index = 1;
                            if (updateDate) {
                                Timestamp t = new Timestamp(this.uniqueIdMap_updateTime.getTime());
                                preparedStatement.setTimestamp(index++, t);
                            }
                            this.jdbcAdapter.setBinaryData(preparedStatement, index++, bout.toByteArray());
                            preparedStatement.setString(index++, this.uniqueIdMap_idActivePolicy);
                            rows = preparedStatement.executeUpdate();
                        }
                        catch (Throwable throwable) {
                            try {
                                if (statement != null) {
                                    statement.close();
                                }
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                        }
                        catch (Throwable throwable) {}
                        if (this.debug) {
                            if (updateDate) {
                                this.logSql.debug("[updateMap" + this.idTransazione + "] executed (rows:" + rows + ") " + DBUtils.formatSQLString((String)queryUpdate, (Object[])new Object[]{DateUtils.getSimpleDateFormatMs().format(this.uniqueIdMap_updateTime), "blob-size:" + bout.size(), this.uniqueIdMap_idActivePolicy}));
                            } else {
                                this.logSql.debug("[updateMap" + this.idTransazione + "] executed (rows:" + rows + ") " + DBUtils.formatSQLString((String)queryUpdate, (Object[])new Object[]{"blob-size:" + bout.size(), this.uniqueIdMap_idActivePolicy}));
                            }
                        }
                    }
                    if (deleteMap) {
                        int n;
                        ISQLQueryObject sqlDelete = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                        sqlDelete.addDeleteTable(CT_MAP_TABLE);
                        sqlDelete.setANDLogicOperator(true);
                        sqlDelete.addWhereCondition("map_key=?");
                        String string = sqlDelete.createSQLDelete();
                        if (this.debug) {
                            this.logSql.debug("[deleteMap" + this.idTransazione + "] execute " + DBUtils.formatSQLString((String)string, (Object[])new Object[]{this.uniqueIdMap_idActivePolicy}));
                        }
                        PreparedStatement pstmtDeleteMap = null;
                        int n2 = -1;
                        try {
                            pstmtDeleteMap = con.prepareStatement(string);
                            int index = 1;
                            pstmtDeleteMap.setString(index++, this.uniqueIdMap_idActivePolicy);
                            n = pstmtDeleteMap.executeUpdate();
                        }
                        finally {
                            try {
                                if (pstmtDeleteMap != null) {
                                    pstmtDeleteMap.close();
                                }
                            }
                            catch (Throwable throwable) {}
                        }
                        if (this.debug) {
                            this.logSql.debug("[updateMap" + this.idTransazione + "] executed (rows:" + n + ") " + DBUtils.formatSQLString((String)string, (Object[])new Object[]{this.uniqueIdMap_idActivePolicy}));
                        }
                    }
                    if (this.transactionMode) {
                        con.commit();
                    }
                    transactionUpdateFinished = true;
                }
                catch (Throwable e) {
                    if (this.transactionMode) {
                        try {
                            con.rollback();
                        }
                        catch (Exception exception) {}
                    }
                    throw new PolicyException("Operazione non riuscita: " + e.getMessage(), e);
                }
                if (!transactionUpdateFinished) {
                    if (this.transactionMode) {
                        try {
                            int sleep = PolicyGroupByActiveThreadsDB.getRandom().nextInt(this.checkIntervalloJDBC);
                            Utilities.sleep((long)sleep);
                        }
                        catch (Exception exception) {}
                    } else {
                        throw new PolicyException("Operazione non riuscita");
                    }
                }
                ++iteration;
                if (policyNotFoundException != null) {
                    throw policyNotFoundException;
                }
                if (policyException == null) continue;
                throw policyException;
            }
            if (!transactionUpdateFinished) {
                throw new PolicyException("Operazione non riuscita dopo '" + iteration + "' tentativi");
            }
        }
        finally {
            block130: {
                if (this.transactionMode) {
                    try {
                        if (autoCommitModificato) {
                            con.setAutoCommit(originalConnectionAutocommit);
                        }
                    }
                    catch (Exception er) {
                        if (this.log == null) break block130;
                        this.log.error("CheckMap failed: unsetting connection error; " + er.getMessage(), (Throwable)er);
                    }
                }
            }
        }
        return updateResult;
    }
}

