/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast;

import com.fasterxml.jackson.databind.JsonNode;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryYamlConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.YamlConfigBuilder;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.controllo_traffico.driver.PolicyException;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.json.JsonPathExpressionEngine;
import org.openspcoop2.utils.json.JsonPathNotFoundException;
import org.openspcoop2.utils.json.YAMLUtils;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.slf4j.Logger;

public class HazelcastManager {
    private static final String GOVWAY_INSTANCE_PORT = "GOVWAY_INSTANCE_PORT";
    private static final String ATOMIC_LONG_REGISTRY_MAP_NAME = "govway-atomiclong-registry";
    private static Map<PolicyGroupByActiveThreadsType, HazelcastInstance> staticMapInstance = null;
    private static Map<PolicyGroupByActiveThreadsType, String> staticMapConfig = null;
    private static String groupId;
    private static YAMLUtils yamlUtils;
    private static JsonPathExpressionEngine engine;
    private static JsonNode sharedConfigNode;
    private static File shareConfigFile;
    private static Logger logStartup;
    private static Logger log;
    private static final String PREFIX_CLUSTER_ID = "(cluster-id";
    private static final String PREFIX_HAZELCAST_INSTANCE_FOR_TYPE = "Hazelcast instance for type ";

    private HazelcastManager() {
    }

    public static synchronized void initialize(Logger logStartup, Logger log, Map<PolicyGroupByActiveThreadsType, String> config, String groupId, File shareConfigFile) throws FileNotFoundException, UtilsException, PolicyException {
        if (staticMapInstance == null) {
            System.setProperty("hazelcast.shutdownhook.enabled", "false");
            System.setProperty("hazelcast.logging.type", "log4j2");
            staticMapInstance = new HashMap<PolicyGroupByActiveThreadsType, HazelcastInstance>();
            staticMapConfig = new HashMap<PolicyGroupByActiveThreadsType, String>();
            HazelcastManager.groupId = groupId;
            HazelcastManager.logStartup = logStartup;
            HazelcastManager.log = log;
            if (shareConfigFile != null) {
                HazelcastManager.shareConfigFile = shareConfigFile;
                yamlUtils = YAMLUtils.getInstance();
                engine = new JsonPathExpressionEngine();
                String sharedContentBytes = FileSystemUtilities.readFile((File)shareConfigFile);
                try {
                    sharedConfigNode = yamlUtils.getAsNode(sharedContentBytes.getBytes());
                }
                catch (Throwable t) {
                    throw new PolicyException("Configuration '" + shareConfigFile.getAbsolutePath() + "' is not valid yaml config: " + t.getMessage() + "\n" + sharedContentBytes, t);
                }
                Config sharedConfig = null;
                try (ByteArrayInputStream bin = new ByteArrayInputStream(sharedContentBytes.getBytes());){
                    YamlConfigBuilder builder = new YamlConfigBuilder((InputStream)bin);
                    sharedConfig = builder.build();
                }
                catch (Throwable t) {
                    throw new PolicyException("Configuration '" + shareConfigFile.getAbsolutePath() + "' is not valid yaml config (YamlConfigBuilder): " + t.getMessage() + "\n" + sharedContentBytes, t);
                }
                if (sharedConfig != null && sharedConfig.getClusterName() != null && StringUtils.isNotEmpty((String)sharedConfig.getClusterName())) {
                    HazelcastManager.groupId = sharedConfig.getClusterName();
                }
            }
            if (config != null && !config.isEmpty()) {
                for (PolicyGroupByActiveThreadsType type : config.keySet()) {
                    File hazelcastConfigFile;
                    String pathConfig = config.get(type);
                    String content = null;
                    if (pathConfig != null && (hazelcastConfigFile = new File(pathConfig)).exists()) {
                        if (!hazelcastConfigFile.canRead()) {
                            throw new PolicyException("Hazelcast (type:" + type + ") file config [" + hazelcastConfigFile.getAbsolutePath() + "] cannot read");
                        }
                        content = FileSystemUtilities.readFile((File)hazelcastConfigFile);
                    }
                    if (content == null) {
                        String name = "";
                        switch (type) {
                            case HAZELCAST_MAP: {
                                name = "govway.hazelcast-map.yaml";
                                break;
                            }
                            case HAZELCAST_NEAR_CACHE: {
                                name = "govway.hazelcast-near-cache.yaml";
                                break;
                            }
                            case HAZELCAST_NEAR_CACHE_UNSAFE_SYNC_MAP: {
                                name = "govway.hazelcast-near-cache-unsafe-sync-map.yaml";
                                break;
                            }
                            case HAZELCAST_NEAR_CACHE_UNSAFE_ASYNC_MAP: {
                                name = "govway.hazelcast-near-cache-unsafe-async-map.yaml";
                                break;
                            }
                            case HAZELCAST_LOCAL_CACHE: {
                                name = "govway.hazelcast-local-cache.yaml";
                                break;
                            }
                            case HAZELCAST_REPLICATED_MAP: {
                                name = "govway.hazelcast-replicated-map.yaml";
                                break;
                            }
                            case HAZELCAST_ATOMIC_LONG: {
                                name = "govway.hazelcast-atomic-long-counters.yaml";
                                break;
                            }
                            case HAZELCAST_ATOMIC_LONG_ASYNC: {
                                name = "govway.hazelcast-atomic-long-async-counters.yaml";
                                break;
                            }
                            case HAZELCAST_PNCOUNTER: {
                                name = "govway.hazelcast-pn-counters.yaml";
                                break;
                            }
                            default: {
                                throw new PolicyException("Hazelcast type '" + type + "' unsupported");
                            }
                        }
                        content = Utilities.getAsString((InputStream)HazelcastManager.class.getResourceAsStream("/" + name), (String)Charset.UTF_8.getValue());
                    }
                    if (content == null) {
                        throw new PolicyException("Hazelcast (type:" + type + ") config undefined");
                    }
                    staticMapConfig.put(type, content);
                }
            }
        }
    }

    public static List<PolicyGroupByActiveThreadsType> getTipiGestoriHazelcastAttivi() throws PolicyException {
        if (staticMapInstance == null) {
            throw new PolicyException("Nessun gestore Hazelcast inizializzato");
        }
        ArrayList<PolicyGroupByActiveThreadsType> l = new ArrayList<PolicyGroupByActiveThreadsType>();
        l.addAll(staticMapInstance.keySet());
        return l;
    }

    public static boolean isAttivo(PolicyGroupByActiveThreadsType type) {
        if (staticMapInstance == null) {
            return false;
        }
        return staticMapInstance.containsKey(type);
    }

    public static HazelcastInstance getInstance(PolicyGroupByActiveThreadsType type) throws PolicyException {
        if (staticMapInstance == null) {
            throw new PolicyException("Nessun gestore Hazelcast inizializzato");
        }
        HazelcastInstance gestore = staticMapInstance.get(type);
        if (gestore == null) {
            HazelcastManager.initialize(type);
            gestore = staticMapInstance.get(type);
        }
        if (gestore == null) {
            throw new PolicyException("Gestore Hazelcast '" + type + "' non inizializzato ??");
        }
        return gestore;
    }

    private static synchronized void initialize(PolicyGroupByActiveThreadsType type) throws PolicyException {
        if (!staticMapInstance.containsKey(type)) {
            HazelcastManager.info("Inizializzazione Gestore Hazelcast '" + type + "' ...");
            staticMapInstance.put(type, HazelcastManager.newInstance(type));
            HazelcastManager.info("Inizializzazione Gestore Hazelcast '" + type + "' effettuata con successo");
        }
    }

    private static synchronized HazelcastInstance newInstance(PolicyGroupByActiveThreadsType type) throws PolicyException {
        String content = staticMapConfig.get(type);
        if (content == null) {
            throw new PolicyException("Hazelcast config undefined for type '" + type + "'");
        }
        String groupId = null;
        switch (type) {
            case HAZELCAST_MAP: {
                groupId = HazelcastManager.groupId + "-map";
                break;
            }
            case HAZELCAST_NEAR_CACHE: {
                groupId = HazelcastManager.groupId + "-near-cache";
                break;
            }
            case HAZELCAST_NEAR_CACHE_UNSAFE_SYNC_MAP: {
                groupId = HazelcastManager.groupId + "-near-cache-unsafe-sync-map";
                break;
            }
            case HAZELCAST_NEAR_CACHE_UNSAFE_ASYNC_MAP: {
                groupId = HazelcastManager.groupId + "-near-cache-unsafe-async-map";
                break;
            }
            case HAZELCAST_LOCAL_CACHE: {
                groupId = HazelcastManager.groupId + "-local-cache";
                break;
            }
            case HAZELCAST_REPLICATED_MAP: {
                groupId = HazelcastManager.groupId + "-replicated-map";
                break;
            }
            case HAZELCAST_PNCOUNTER: {
                groupId = HazelcastManager.groupId + "-pncounter";
                break;
            }
            case HAZELCAST_ATOMIC_LONG: {
                groupId = HazelcastManager.groupId + "-atomic-long";
                break;
            }
            case HAZELCAST_ATOMIC_LONG_ASYNC: {
                groupId = HazelcastManager.groupId + "-atomic-long-async";
                break;
            }
            default: {
                throw new PolicyException("Hazelcast type '" + type + "' unsupported");
            }
        }
        content = content.replace("cluster-name:", "cluster-name: " + groupId + "\n#cluster-name:");
        HazelcastManager.debug("Inizializzo hazelcast con la seguente configurazione (cluster-id" + groupId + "): " + content);
        InMemoryYamlConfig hazelcastConfig = new InMemoryYamlConfig(content);
        hazelcastConfig.setClusterName(groupId);
        HazelcastManager.setNetwork(hazelcastConfig, content, groupId);
        HazelcastInstance hazelcast = Hazelcast.newHazelcastInstance((Config)hazelcastConfig);
        if (hazelcast == null) {
            throw new PolicyException("Hazelcast init failed");
        }
        return hazelcast;
    }

    private static void setNetwork(InMemoryYamlConfig hazelcastConfig, String hazelcastConfigContent, String groupId) throws PolicyException {
        Config sharedConfig = null;
        if (shareConfigFile != null) {
            try (FileInputStream fin = new FileInputStream(shareConfigFile);){
                YamlConfigBuilder builder = new YamlConfigBuilder((InputStream)fin);
                sharedConfig = builder.build();
            }
            catch (Throwable t) {
                throw new PolicyException("Configuration '" + shareConfigFile.getAbsolutePath() + "' is not valid yaml config (YamlConfigBuilder): " + t.getMessage(), t);
            }
        }
        if (sharedConfig != null && sharedConfig.getNetworkConfig() != null) {
            boolean definedInstance;
            boolean definedShared;
            boolean definedInstance2;
            NetworkConfig ncShared = sharedConfig.getNetworkConfig();
            NetworkConfig ncInstance = hazelcastConfig.getNetworkConfig();
            Integer portHazelcastConfigInstance = null;
            if (ncInstance == null) {
                ncInstance = new NetworkConfig();
                hazelcastConfig.setNetworkConfig(ncInstance);
            } else {
                portHazelcastConfigInstance = hazelcastConfig.getNetworkConfig().getPort();
            }
            JsonNode instanceNode = null;
            try {
                instanceNode = yamlUtils.getAsNode(hazelcastConfigContent);
            }
            catch (Throwable t) {
                throw new PolicyException("Configuration '" + groupId + "' is not valid yaml config:\n" + hazelcastConfigContent);
            }
            if (ncShared.getPublicAddress() != null && !(definedInstance2 = HazelcastManager.isDefined("public-address", yamlUtils, engine, instanceNode))) {
                ncInstance.setPublicAddress(ncShared.getPublicAddress());
                HazelcastManager.debug(PREFIX_CLUSTER_ID + groupId + ") override public-address: " + ncInstance.getPublicAddress());
            }
            if ((ncShared.getOutboundPorts() != null && !ncShared.getOutboundPorts().isEmpty() || ncShared.getOutboundPortDefinitions() != null && !ncShared.getOutboundPortDefinitions().isEmpty()) && !(definedInstance2 = HazelcastManager.isDefined("outbound-ports", yamlUtils, engine, instanceNode))) {
                if (ncShared.getOutboundPorts() != null && !ncShared.getOutboundPorts().isEmpty()) {
                    ncInstance.setOutboundPorts(ncShared.getOutboundPorts());
                    HazelcastManager.debug(PREFIX_CLUSTER_ID + groupId + ") override outbound-ports: " + ncInstance.getOutboundPorts());
                }
                if (ncShared.getOutboundPortDefinitions() != null && !ncShared.getOutboundPortDefinitions().isEmpty()) {
                    ncInstance.setOutboundPortDefinitions(ncShared.getOutboundPortDefinitions());
                    HazelcastManager.debug(PREFIX_CLUSTER_ID + groupId + ") override outbound-ports (definitions): " + ncInstance.getOutboundPortDefinitions());
                }
            }
            if ((definedShared = HazelcastManager.isDefined("reuse-address", yamlUtils, engine, sharedConfigNode)) && !(definedInstance = HazelcastManager.isDefined("reuse-address", yamlUtils, engine, instanceNode))) {
                ncInstance.setReuseAddress(ncShared.isReuseAddress());
                HazelcastManager.debug(PREFIX_CLUSTER_ID + groupId + ") override reuse-address: " + ncInstance.isReuseAddress());
            }
            if (ncShared.getJoin() != null && !(definedInstance = HazelcastManager.isDefined("join", yamlUtils, engine, instanceNode))) {
                ncInstance.setJoin(ncShared.getJoin());
                if (ncInstance.getJoin().getTcpIpConfig() != null) {
                    if (ncShared.getJoin().getTcpIpConfig().getConnectionTimeoutSeconds() > 0) {
                        ncInstance.getJoin().getTcpIpConfig().setConnectionTimeoutSeconds(ncShared.getJoin().getTcpIpConfig().getConnectionTimeoutSeconds());
                    }
                    if (portHazelcastConfigInstance != null && portHazelcastConfigInstance > 0 && ncInstance.getJoin().getTcpIpConfig().getMembers() != null && !ncInstance.getJoin().getTcpIpConfig().getMembers().isEmpty()) {
                        ArrayList<String> newList = new ArrayList<String>();
                        for (String member : ncInstance.getJoin().getTcpIpConfig().getMembers()) {
                            try {
                                if (member.contains(GOVWAY_INSTANCE_PORT)) {
                                    newList.add(member.replace(GOVWAY_INSTANCE_PORT, "" + portHazelcastConfigInstance));
                                    continue;
                                }
                                if (member.contains(GOVWAY_INSTANCE_PORT.toLowerCase())) {
                                    newList.add(member.replace(GOVWAY_INSTANCE_PORT.toLowerCase(), "" + portHazelcastConfigInstance));
                                    continue;
                                }
                                newList.add(member);
                            }
                            catch (Throwable t) {
                                HazelcastManager.error(PREFIX_CLUSTER_ID + groupId + ") tpcip analisi member '" + member + "' fallita: " + t.getMessage(), t);
                            }
                        }
                        ncInstance.getJoin().getTcpIpConfig().setMembers(newList);
                    }
                }
                HazelcastManager.debug(PREFIX_CLUSTER_ID + groupId + ") override join: " + ncInstance.getJoin());
            }
            if (ncShared.getInterfaces() != null && ncShared.getInterfaces().isEnabled() && !(definedInstance = HazelcastManager.isDefined("interfaces", yamlUtils, engine, instanceNode))) {
                ncInstance.setInterfaces(ncShared.getInterfaces());
                HazelcastManager.debug(PREFIX_CLUSTER_ID + groupId + ") override interfaces: " + ncInstance.getInterfaces());
            }
            if (ncShared.getIcmpFailureDetectorConfig() != null && ncShared.getIcmpFailureDetectorConfig().isEnabled() && !(definedInstance = HazelcastManager.isDefined("failure-detector", yamlUtils, engine, instanceNode))) {
                ncInstance.setIcmpFailureDetectorConfig(ncShared.getIcmpFailureDetectorConfig());
                HazelcastManager.debug(PREFIX_CLUSTER_ID + groupId + ") override failure-detector icmp: " + ncInstance.getIcmpFailureDetectorConfig());
            }
            if (ncShared.getMemberAddressProviderConfig() != null && ncShared.getMemberAddressProviderConfig().isEnabled() && !(definedInstance = HazelcastManager.isDefined("member-address-provider", yamlUtils, engine, instanceNode))) {
                ncInstance.setMemberAddressProviderConfig(ncShared.getMemberAddressProviderConfig());
                HazelcastManager.debug(PREFIX_CLUSTER_ID + groupId + ") override member-address-provider: " + ncInstance.getMemberAddressProviderConfig());
            }
            if (ncShared.getMemcacheProtocolConfig() != null && ncShared.getMemcacheProtocolConfig().isEnabled() && !(definedInstance = HazelcastManager.isDefined("memcache-protocol", yamlUtils, engine, instanceNode))) {
                ncInstance.setMemcacheProtocolConfig(ncShared.getMemcacheProtocolConfig());
                HazelcastManager.debug(PREFIX_CLUSTER_ID + groupId + ") override memcache-protocol: " + ncInstance.getMemcacheProtocolConfig());
            }
            if (ncShared.getRestApiConfig() != null && ncShared.getRestApiConfig().isEnabled() && !(definedInstance = HazelcastManager.isDefined("rest-api", yamlUtils, engine, instanceNode))) {
                ncInstance.setRestApiConfig(ncShared.getRestApiConfig());
                HazelcastManager.debug(PREFIX_CLUSTER_ID + groupId + ") override rest-api: " + ncInstance.getRestApiConfig());
            }
            if (ncShared.getSocketInterceptorConfig() != null && ncShared.getSocketInterceptorConfig().getClassName() != null && !(definedInstance = HazelcastManager.isDefined("socket-interceptor", yamlUtils, engine, instanceNode))) {
                ncInstance.setSocketInterceptorConfig(ncShared.getSocketInterceptorConfig());
                HazelcastManager.debug(PREFIX_CLUSTER_ID + groupId + ") override socket-interceptor: " + ncInstance.getSocketInterceptorConfig());
            }
            if (ncShared.getSSLConfig() != null && ncShared.getSSLConfig().isEnabled() && !(definedInstance = HazelcastManager.isDefined("ssl", yamlUtils, engine, instanceNode))) {
                ncInstance.setSSLConfig(ncShared.getSSLConfig());
                HazelcastManager.debug(PREFIX_CLUSTER_ID + groupId + ") override ssl: " + ncInstance.getSSLConfig());
            }
        }
    }

    private static boolean isDefined(String pattern, YAMLUtils yamlUtils, JsonPathExpressionEngine engine, JsonNode node) throws PolicyException {
        if (yamlUtils != null) {
            // empty if block
        }
        String prefixPattern = "$.hazelcast.network.";
        try {
            JsonNode result = engine.getJsonNodeMatchPattern(node, prefixPattern + pattern);
            return result != null;
        }
        catch (JsonPathNotFoundException notFound) {
            return false;
        }
        catch (Throwable t) {
            throw new PolicyException(t.getMessage(), t);
        }
    }

    private static void debug(String msg) {
        if (log != null) {
            log.debug(msg);
        }
        if (logStartup != null) {
            logStartup.debug(msg);
        }
    }

    private static void info(String msg) {
        if (log != null) {
            log.info(msg);
        }
        if (logStartup != null) {
            logStartup.info(msg);
        }
    }

    private static void error(String msg, Throwable e) {
        if (log != null) {
            log.error(msg, e);
        }
        if (logStartup != null) {
            logStartup.error(msg, e);
        }
    }

    public static int cleanupOrphanedProxies(long thresholdMs) {
        int removed = 0;
        if (staticMapInstance == null || staticMapInstance.isEmpty()) {
            return removed;
        }
        Logger logControlloTraffico = OpenSPCoop2Logger.getLoggerOpenSPCoopControlloTraffico(true);
        long now = DateManager.getTimeMillis();
        long threshold = now - thresholdMs;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        if (logControlloTraffico != null) {
            String msg = "Cleanup orphaned proxies: threshold=" + sdf.format(new Date(threshold)) + " (" + thresholdMs / 3600000L + " hours ago)";
            logControlloTraffico.info(msg);
        }
        PolicyGroupByActiveThreadsType[] counterTypes = new PolicyGroupByActiveThreadsType[]{PolicyGroupByActiveThreadsType.HAZELCAST_PNCOUNTER, PolicyGroupByActiveThreadsType.HAZELCAST_ATOMIC_LONG, PolicyGroupByActiveThreadsType.HAZELCAST_ATOMIC_LONG_ASYNC};
        boolean atomicLongRegistryEnabled = OpenSPCoop2Properties.getInstance().isControlloTrafficoGestorePolicyInMemoryHazelcastAtomicLongRegistryEnabled();
        boolean activePoliciesCountLogEnabled = OpenSPCoop2Properties.getInstance().isControlloTrafficoGestorePolicyInMemoryHazelcastActivePoliciesCountLogEnabled();
        for (PolicyGroupByActiveThreadsType type : counterTypes) {
            HazelcastInstance hazelcast = staticMapInstance.get(type);
            if (hazelcast == null) continue;
            if (!hazelcast.getLifecycleService().isRunning()) {
                if (logControlloTraffico == null) continue;
                String msg = PREFIX_HAZELCAST_INSTANCE_FOR_TYPE + type + " is not active, skipping cleanup";
                logControlloTraffico.debug(msg);
                continue;
            }
            if ((type == PolicyGroupByActiveThreadsType.HAZELCAST_ATOMIC_LONG || type == PolicyGroupByActiveThreadsType.HAZELCAST_ATOMIC_LONG_ASYNC) && atomicLongRegistryEnabled) {
                removed += HazelcastManager.cleanupOrphanedAtomicLongCounters(type, thresholdMs, logControlloTraffico, sdf, activePoliciesCountLogEnabled);
                continue;
            }
            try {
                String name;
                Collection objects = hazelcast.getDistributedObjects();
                int countWithInterval = 0;
                int countWithoutInterval = 0;
                int countRecent = 0;
                int removedForType = 0;
                int removedWithoutInterval = 0;
                long oldestInterval = Long.MAX_VALUE;
                long newestIntervalRemoved = Long.MIN_VALUE;
                long newestInterval = Long.MIN_VALUE;
                ArrayList<String> activePolicyIds = new ArrayList<String>();
                ArrayList<DistributedObject> objectsWithoutInterval = new ArrayList<DistributedObject>();
                boolean isPNCounter = type == PolicyGroupByActiveThreadsType.HAZELCAST_PNCOUNTER;
                for (DistributedObject obj : objects) {
                    name = obj.getName();
                    if (name == null || ATOMIC_LONG_REGISTRY_MAP_NAME.equals(name)) continue;
                    int intervalIndex = name.indexOf("-i-");
                    if (intervalIndex < 0) {
                        ++countWithoutInterval;
                        objectsWithoutInterval.add(obj);
                        continue;
                    }
                    ++countWithInterval;
                    int timestampStart = intervalIndex + 3;
                    int timestampEnd = name.indexOf("-c-", timestampStart);
                    if (timestampEnd < 0) {
                        timestampEnd = name.length();
                    }
                    String timestampStr = name.substring(timestampStart, timestampEnd);
                    try {
                        long timestamp = Long.parseLong(timestampStr);
                        if (timestamp < oldestInterval) {
                            oldestInterval = timestamp;
                        }
                        if (timestamp > newestInterval) {
                            newestInterval = timestamp;
                        }
                        if (timestamp < threshold) {
                            try {
                                obj.destroy();
                                ++removed;
                                ++removedForType;
                                if (logControlloTraffico != null) {
                                    String msg = "Destroyed orphaned proxy: " + name + " (intervalDate=" + sdf.format(new Date(timestamp)) + ")";
                                    logControlloTraffico.debug(msg);
                                }
                                if (timestamp <= newestIntervalRemoved) continue;
                                newestIntervalRemoved = timestamp;
                            }
                            catch (Throwable t) {
                                if (logControlloTraffico == null) continue;
                                String msg = "Error destroying orphaned proxy " + name + ": " + t.getMessage();
                                logControlloTraffico.error(msg, t);
                            }
                            continue;
                        }
                        ++countRecent;
                        String policyId = HazelcastManager.extractPolicyId(name, isPNCounter);
                        if (policyId == null || activePolicyIds.contains(policyId)) continue;
                        activePolicyIds.add(policyId);
                    }
                    catch (NumberFormatException nfe) {
                        if (logControlloTraffico == null) continue;
                        String msg = "Cannot parse timestamp from proxy name: " + name;
                        logControlloTraffico.debug(msg);
                    }
                }
                for (DistributedObject obj : objectsWithoutInterval) {
                    name = obj.getName();
                    String policyId = HazelcastManager.extractPolicyId(name, isPNCounter);
                    if (policyId == null || activePolicyIds.contains(policyId)) continue;
                    try {
                        obj.destroy();
                        ++removed;
                        ++removedWithoutInterval;
                        if (logControlloTraffico == null) continue;
                        String msg = "Destroyed orphaned counter without interval: " + name + " (policy no longer active)";
                        logControlloTraffico.debug(msg);
                    }
                    catch (Throwable t) {
                        if (logControlloTraffico == null) continue;
                        String msg = "Error destroying orphaned counter without interval " + name + ": " + t.getMessage();
                        logControlloTraffico.error(msg, t);
                    }
                }
                StringBuilder sb = new StringBuilder();
                int finalWithInterval = countWithInterval - removedForType;
                int finalWithoutInterval = countWithoutInterval - removedWithoutInterval;
                int total = finalWithInterval + finalWithoutInterval;
                sb.append("Type ").append(type).append(": total=").append(total);
                sb.append(", withInterval=").append(finalWithInterval);
                sb.append(", withoutInterval=").append(finalWithoutInterval);
                sb.append(", recent=").append(countRecent);
                sb.append(", removedWithInterval=").append(removedForType);
                if (removedWithoutInterval > 0) {
                    sb.append(", removedWithoutInterval=").append(removedWithoutInterval);
                }
                if (countWithInterval > 0 && oldestInterval != Long.MAX_VALUE) {
                    sb.append(", oldest=").append(sdf.format(new Date(oldestInterval)));
                }
                if (countWithInterval > 0 && newestInterval != Long.MIN_VALUE) {
                    sb.append(", newest=").append(sdf.format(new Date(newestInterval)));
                }
                if (countWithInterval > 0 && newestIntervalRemoved != Long.MIN_VALUE) {
                    sb.append(", newest-removed=").append(sdf.format(new Date(newestIntervalRemoved)));
                }
                if (activePoliciesCountLogEnabled) {
                    sb.append(", activePolicies=").append(activePolicyIds.size());
                }
                if (logControlloTraffico != null) {
                    String msg = sb.toString();
                    logControlloTraffico.info(msg);
                }
                if (type != PolicyGroupByActiveThreadsType.HAZELCAST_PNCOUNTER || !atomicLongRegistryEnabled) continue;
                removed += HazelcastManager.cleanupAndLogAtomicLongRegistryForPNCounter(type, activePolicyIds, thresholdMs, logControlloTraffico, sdf);
            }
            catch (Throwable t) {
                if (logControlloTraffico == null) continue;
                String msg = "Error during cleanup of orphaned proxies for type " + type + ": " + t.getMessage();
                logControlloTraffico.error(msg, t);
            }
        }
        if (logControlloTraffico != null) {
            String msg = "Cleanup orphaned proxies finished: removed " + removed + " proxies";
            logControlloTraffico.info(msg);
        }
        return removed;
    }

    public static void registerAtomicLongCounter(PolicyGroupByActiveThreadsType type, String counterName) {
        block4: {
            if (staticMapInstance == null || counterName == null) {
                return;
            }
            HazelcastInstance hazelcast = staticMapInstance.get(type);
            if (hazelcast == null) {
                return;
            }
            try {
                IMap registry = hazelcast.getMap(ATOMIC_LONG_REGISTRY_MAP_NAME);
                registry.put((Object)counterName, (Object)DateManager.getTimeMillis());
            }
            catch (Throwable t) {
                if (log == null) break block4;
                log.debug("Error registering AtomicLong counter '" + counterName + "': " + t.getMessage(), t);
            }
        }
    }

    public static void unregisterAtomicLongCounter(PolicyGroupByActiveThreadsType type, String counterName) {
        block4: {
            if (staticMapInstance == null || counterName == null) {
                return;
            }
            HazelcastInstance hazelcast = staticMapInstance.get(type);
            if (hazelcast == null) {
                return;
            }
            try {
                IMap registry = hazelcast.getMap(ATOMIC_LONG_REGISTRY_MAP_NAME);
                registry.remove((Object)counterName);
            }
            catch (Throwable t) {
                if (log == null) break block4;
                log.debug("Error unregistering AtomicLong counter '" + counterName + "': " + t.getMessage(), t);
            }
        }
    }

    private static int cleanupOrphanedAtomicLongCounters(PolicyGroupByActiveThreadsType type, long thresholdMs, Logger logControlloTraffico, SimpleDateFormat sdf, boolean activePoliciesCountLogEnabled) {
        int removed;
        block26: {
            removed = 0;
            HazelcastInstance hazelcast = staticMapInstance.get(type);
            if (hazelcast == null) {
                return removed;
            }
            if (!hazelcast.getLifecycleService().isRunning()) {
                if (logControlloTraffico != null) {
                    String msg = PREFIX_HAZELCAST_INSTANCE_FOR_TYPE + type + " is not active, skipping AtomicLong cleanup";
                    logControlloTraffico.debug(msg);
                }
                return removed;
            }
            long now = DateManager.getTimeMillis();
            long threshold = now - thresholdMs;
            try {
                String name;
                IMap registry = hazelcast.getMap(ATOMIC_LONG_REGISTRY_MAP_NAME);
                int countWithInterval = 0;
                int countWithoutInterval = 0;
                int countRecent = 0;
                int removedForType = 0;
                int removedWithoutInterval = 0;
                int skippedRecent = 0;
                long oldestInterval = Long.MAX_VALUE;
                long newestIntervalRemoved = Long.MIN_VALUE;
                long newestInterval = Long.MIN_VALUE;
                long registrationThreshold = now - thresholdMs;
                ArrayList<String> activePolicyIds = new ArrayList<String>();
                ArrayList<Map.Entry> countersWithoutInterval = new ArrayList<Map.Entry>();
                for (Map.Entry entry : registry.entrySet()) {
                    name = (String)entry.getKey();
                    if (name == null) continue;
                    int intervalIndex = name.indexOf("-i-");
                    if (intervalIndex < 0) {
                        ++countWithoutInterval;
                        countersWithoutInterval.add(entry);
                        continue;
                    }
                    ++countWithInterval;
                    int timestampStart = intervalIndex + 3;
                    int timestampEnd = name.indexOf("-c-", timestampStart);
                    if (timestampEnd < 0) {
                        timestampEnd = name.length();
                    }
                    String timestampStr = name.substring(timestampStart, timestampEnd);
                    try {
                        long timestamp = Long.parseLong(timestampStr);
                        if (timestamp < oldestInterval) {
                            oldestInterval = timestamp;
                        }
                        if (timestamp > newestInterval) {
                            newestInterval = timestamp;
                        }
                        if (timestamp < threshold) {
                            try {
                                hazelcast.getCPSubsystem().getAtomicLong(name).destroy();
                                registry.remove((Object)name);
                                ++removed;
                                ++removedForType;
                                if (logControlloTraffico != null) {
                                    String msg = "Destroyed orphaned AtomicLong counter: " + name + " (intervalDate=" + sdf.format(new Date(timestamp)) + ")";
                                    logControlloTraffico.debug(msg);
                                }
                                if (timestamp <= newestIntervalRemoved) continue;
                                newestIntervalRemoved = timestamp;
                            }
                            catch (Throwable t) {
                                if (logControlloTraffico == null) continue;
                                String msg = "Error destroying orphaned AtomicLong counter " + name + ": " + t.getMessage();
                                logControlloTraffico.error(msg, t);
                            }
                            continue;
                        }
                        ++countRecent;
                        String policyId = HazelcastManager.extractPolicyId(name, false);
                        if (policyId == null || activePolicyIds.contains(policyId)) continue;
                        activePolicyIds.add(policyId);
                    }
                    catch (NumberFormatException nfe) {
                        if (logControlloTraffico == null) continue;
                        String msg = "Cannot parse timestamp from counter name: " + name;
                        logControlloTraffico.debug(msg);
                    }
                }
                for (Map.Entry entry : countersWithoutInterval) {
                    String msg;
                    name = (String)entry.getKey();
                    Long registrationTime = (Long)entry.getValue();
                    String policyId = HazelcastManager.extractPolicyId(name, false);
                    if (policyId == null || activePolicyIds.contains(policyId)) continue;
                    if (registrationTime != null && registrationTime > registrationThreshold) {
                        ++skippedRecent;
                        if (logControlloTraffico == null) continue;
                        msg = "Skipping recently registered AtomicLong counter: " + name + " (registered=" + sdf.format(new Date(registrationTime)) + ")";
                        logControlloTraffico.debug(msg);
                        continue;
                    }
                    try {
                        hazelcast.getCPSubsystem().getAtomicLong(name).destroy();
                        registry.remove((Object)name);
                        ++removed;
                        ++removedWithoutInterval;
                        if (logControlloTraffico == null) continue;
                        msg = "Destroyed orphaned AtomicLong counter (no active policy): " + name;
                        logControlloTraffico.debug(msg);
                    }
                    catch (Throwable t) {
                        if (logControlloTraffico == null) continue;
                        String msg2 = "Error destroying orphaned AtomicLong counter " + name + ": " + t.getMessage();
                        logControlloTraffico.error(msg2, t);
                    }
                }
                StringBuilder sb = new StringBuilder();
                int finalWithInterval = countWithInterval - removedForType;
                int finalWithoutInterval = countWithoutInterval - removedWithoutInterval;
                int total = finalWithInterval + finalWithoutInterval;
                sb.append("Type ").append(type).append(" (via registry): total=").append(total);
                sb.append(", withInterval=").append(finalWithInterval);
                sb.append(", withoutInterval=").append(finalWithoutInterval);
                sb.append(", recent=").append(countRecent);
                sb.append(", removedWithInterval=").append(removedForType);
                sb.append(", removedWithoutInterval=").append(removedWithoutInterval);
                if (skippedRecent > 0) {
                    sb.append(", skippedRecent=").append(skippedRecent);
                }
                if (countWithInterval > 0 && oldestInterval != Long.MAX_VALUE) {
                    sb.append(", oldest=").append(sdf.format(new Date(oldestInterval)));
                }
                if (countWithInterval > 0 && newestInterval != Long.MIN_VALUE) {
                    sb.append(", newest=").append(sdf.format(new Date(newestInterval)));
                }
                if (countWithInterval > 0 && newestIntervalRemoved != Long.MIN_VALUE) {
                    sb.append(", newest-removed=").append(sdf.format(new Date(newestIntervalRemoved)));
                }
                if (activePoliciesCountLogEnabled) {
                    sb.append(", activePolicies=").append(activePolicyIds.size());
                }
                if (logControlloTraffico != null) {
                    String msg = sb.toString();
                    logControlloTraffico.info(msg);
                }
            }
            catch (Throwable t) {
                if (logControlloTraffico == null) break block26;
                String msg = "Error during cleanup of orphaned AtomicLong counters for type " + type + ": " + t.getMessage();
                logControlloTraffico.error(msg, t);
            }
        }
        return removed;
    }

    private static String extractPolicyId(String counterName, boolean isPNCounter) {
        if (counterName == null) {
            return null;
        }
        String name = counterName;
        if (isPNCounter) {
            int doubleHyphenIndex;
            String prefix = "pncounter-";
            if (name.startsWith(prefix)) {
                name = name.substring(prefix.length());
            }
            if ((doubleHyphenIndex = name.indexOf("--")) > 0) {
                return name.substring(0, doubleHyphenIndex);
            }
        } else {
            String alPrefix = "al-";
            String pnAlPrefix = "pn_al-";
            if (name.startsWith(alPrefix)) {
                name = name.substring(alPrefix.length());
            } else if (name.startsWith(pnAlPrefix)) {
                name = name.substring(pnAlPrefix.length());
            }
            for (int i = 0; i < name.length() - 1; ++i) {
                if (name.charAt(i) != '-' || !Character.isLetter(name.charAt(i + 1))) continue;
                return name.substring(0, i);
            }
        }
        return null;
    }

    private static int cleanupAndLogAtomicLongRegistryForPNCounter(PolicyGroupByActiveThreadsType type, List<String> activePolicyIds, long thresholdMs, Logger logControlloTraffico, SimpleDateFormat sdf) {
        int removed;
        block17: {
            removed = 0;
            if (staticMapInstance == null) {
                return removed;
            }
            HazelcastInstance hazelcast = staticMapInstance.get(type);
            if (hazelcast == null) {
                return removed;
            }
            if (!hazelcast.getLifecycleService().isRunning()) {
                if (logControlloTraffico != null) {
                    String msg = PREFIX_HAZELCAST_INSTANCE_FOR_TYPE + type + " is not active, skipping AtomicLong dates cleanup";
                    logControlloTraffico.debug(msg);
                }
                return removed;
            }
            try {
                IMap registry = hazelcast.getMap(ATOMIC_LONG_REGISTRY_MAP_NAME);
                if (registry != null && !registry.isEmpty()) {
                    int countWithInterval = 0;
                    int countWithoutInterval = 0;
                    int removedWithInterval = 0;
                    int removedWithoutInterval = 0;
                    int skippedRecent = 0;
                    long now = DateManager.getTimeMillis();
                    long registrationThreshold = now - thresholdMs;
                    ArrayList counterNames = new ArrayList(registry.keySet());
                    for (String name : counterNames) {
                        String msg;
                        if (name == null) continue;
                        String policyId = HazelcastManager.extractPolicyId(name, false);
                        boolean hasInterval = name.contains("-i-");
                        if (hasInterval) {
                            ++countWithInterval;
                        } else {
                            ++countWithoutInterval;
                        }
                        if (policyId == null || activePolicyIds.contains(policyId)) continue;
                        Long registrationTime = (Long)registry.get((Object)name);
                        if (registrationTime != null && registrationTime > registrationThreshold) {
                            ++skippedRecent;
                            if (logControlloTraffico == null) continue;
                            msg = "Skipping recently registered AtomicLong date counter: " + name + " (registered=" + sdf.format(new Date(registrationTime)) + ")";
                            logControlloTraffico.debug(msg);
                            continue;
                        }
                        try {
                            hazelcast.getCPSubsystem().getAtomicLong(name).destroy();
                            registry.remove((Object)name);
                            ++removed;
                            if (hasInterval) {
                                ++removedWithInterval;
                            } else {
                                ++removedWithoutInterval;
                            }
                            if (logControlloTraffico == null) continue;
                            msg = "Destroyed orphaned AtomicLong date counter: " + name + " (policy no longer active)";
                            logControlloTraffico.debug(msg);
                        }
                        catch (Throwable t) {
                            if (logControlloTraffico == null) continue;
                            String msg2 = "Error destroying orphaned AtomicLong date counter " + name + ": " + t.getMessage();
                            logControlloTraffico.error(msg2, t);
                        }
                    }
                    if (logControlloTraffico != null) {
                        int finalWithInterval = countWithInterval - removedWithInterval;
                        int finalWithoutInterval = countWithoutInterval - removedWithoutInterval;
                        int total = finalWithInterval + finalWithoutInterval;
                        StringBuilder sb = new StringBuilder();
                        sb.append("Type ").append(type).append(" (AtomicLong dates via registry): total=").append(total);
                        sb.append(", withInterval=").append(finalWithInterval);
                        sb.append(", withoutInterval=").append(finalWithoutInterval);
                        sb.append(", removed=").append(removedWithInterval + removedWithoutInterval);
                        if (skippedRecent > 0) {
                            sb.append(", skippedRecent=").append(skippedRecent);
                        }
                        logControlloTraffico.info(sb.toString());
                    }
                }
            }
            catch (Throwable t) {
                if (logControlloTraffico == null) break block17;
                logControlloTraffico.debug("Error during cleanup of AtomicLong dates registry for " + type + ": " + t.getMessage(), t);
            }
        }
        return removed;
    }

    public static synchronized void close() {
        if (staticMapInstance != null && !staticMapInstance.isEmpty()) {
            for (PolicyGroupByActiveThreadsType type : staticMapInstance.keySet()) {
                HazelcastInstance hazelcast = staticMapInstance.get(type);
                try {
                    hazelcast.shutdown();
                }
                catch (Throwable t) {
                    log.debug("Hazelcast '" + type + "' shutdown failed: " + t.getMessage(), t);
                }
            }
        }
    }

    static {
        yamlUtils = null;
        engine = null;
    }
}

