/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.counters;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.controllo_traffico.beans.ActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.DatiCollezionati;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicyMapId;
import org.openspcoop2.core.controllo_traffico.beans.IDatiCollezionatiDistributed;
import org.openspcoop2.core.controllo_traffico.constants.TipoControlloPeriodo;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.ActiveRequestDistributedIntervalManager;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.counters.DatoAtomicLong;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.slf4j.Logger;

public class DatiCollezionatiDistributedAtomicLong
extends DatiCollezionati
implements IDatiCollezionatiDistributed {
    private static final long serialVersionUID = 1L;
    public static final String COUNTER_PREFIX = "al-";
    private final transient Semaphore lock = new Semaphore("DatiCollezionatiDistributedAtomicLong");
    protected final transient PolicyGroupByActiveThreadsType policyType;
    private final transient HazelcastInstance hazelcast;
    private final IDUnivocoGroupByPolicyMapId groupByPolicyMapId;
    private final int groupByPolicyMapIdHashCode;
    protected final transient DatoAtomicLong distributedUpdatePolicyDate;
    protected final transient DatoAtomicLong distributedPolicyDate;
    protected transient DatoAtomicLong distributedPolicyRequestCounter;
    protected transient DatoAtomicLong distributedPolicyCounter;
    protected final transient DatoAtomicLong distributedPolicyDegradoPrestazionaleDate;
    protected transient DatoAtomicLong distributedPolicyDegradoPrestazionaleRequestCounter;
    protected transient DatoAtomicLong distributedPolicyDegradoPrestazionaleCounter;
    protected final transient boolean distribuitedActiveRequestCounterPolicyRichiesteSimultanee;
    protected transient DatoAtomicLong distributedActiveRequestCounterForStats;
    protected transient DatoAtomicLong distributedActiveRequestCounterForCheck;
    protected final transient int richiesteSimultaneeIntervalloSecondi;
    protected final transient DatoAtomicLong distributedActiveRequestCounterDate;
    protected transient DatoAtomicLong distributedPolicyDenyRequestCounter;
    private transient List<DatoAtomicLong> cestinoPolicyCounters = new ArrayList<DatoAtomicLong>();
    private transient List<DatoAtomicLong> cestinoPolicyCountersDegradoPrestazionale = new ArrayList<DatoAtomicLong>();
    private transient List<DatoAtomicLong> cestinoActiveRequestCounters = new ArrayList<DatoAtomicLong>();
    private boolean initialized = false;

    public DatiCollezionatiDistributedAtomicLong(Logger log, Date updatePolicyDate, Date gestorePolicyConfigDate, HazelcastInstance hazelcast, IDUnivocoGroupByPolicyMapId groupByPolicyMapId, ActivePolicy activePolicy, PolicyGroupByActiveThreadsType policyType) {
        super(updatePolicyDate, gestorePolicyConfigDate);
        this.policyType = policyType;
        this.hazelcast = hazelcast;
        this.groupByPolicyMapId = groupByPolicyMapId;
        this.groupByPolicyMapIdHashCode = this.groupByPolicyMapId.hashCode();
        this.initDatiIniziali(activePolicy);
        this.checkDate(log, activePolicy);
        this.distributedPolicyDate = this.initPolicyDate();
        this.distributedUpdatePolicyDate = this.initUpdatePolicyDate();
        this.distributedPolicyDegradoPrestazionaleDate = this.initPolicyDegradoPrestazionaleDate();
        this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee = activePolicy.getConfigurazionePolicy().isSimultanee() && TipoControlloPeriodo.REALTIME.equals((Object)activePolicy.getConfigurazionePolicy().getModalitaControllo());
        this.richiesteSimultaneeIntervalloSecondi = ActiveRequestDistributedIntervalManager.getIntervalloSecondi();
        this.distributedActiveRequestCounterDate = this.initActiveRequestCounterDate();
        if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
            this.distributedActiveRequestCounterForCheck = this.initActiveRequestCounters(this.getActiveRequestCounterIntervalDate());
            this.distributedActiveRequestCounterForStats = null;
        } else {
            this.distributedActiveRequestCounterForStats = this.initActiveRequestCounters(this.getActiveRequestCounterIntervalDate());
        }
        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            this.initPolicyCounters(super.getPolicyDate().getTime());
        }
        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue()) {
            this.initPolicyCountersDegradoPrestazionale(super.getPolicyDegradoPrestazionaleDate().getTime());
        }
        if (this.policyRealtime != null && this.policyRealtime.booleanValue() && updatePolicyDate != null && this.distributedUpdatePolicyDate != null && this.distributedUpdatePolicyDate.get() < updatePolicyDate.getTime()) {
            this.resetCounters(updatePolicyDate);
        }
        this.initialized = true;
    }

    public DatiCollezionatiDistributedAtomicLong(Logger log, DatiCollezionati dati, HazelcastInstance hazelcast, IDUnivocoGroupByPolicyMapId groupByPolicyMapId, ActivePolicy activePolicy, PolicyGroupByActiveThreadsType policyType) {
        super(dati.getUpdatePolicyDate(), dati.getGestorePolicyConfigDate());
        if (log != null) {
            // empty if block
        }
        dati.setValuesIn((DatiCollezionati)this, false);
        this.policyType = policyType;
        this.hazelcast = hazelcast;
        this.groupByPolicyMapId = groupByPolicyMapId;
        this.groupByPolicyMapIdHashCode = this.groupByPolicyMapId.hashCode();
        this.distributedPolicyDate = this.initPolicyDate();
        this.distributedUpdatePolicyDate = this.initUpdatePolicyDate();
        this.distributedPolicyDegradoPrestazionaleDate = this.initPolicyDegradoPrestazionaleDate();
        this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee = activePolicy.getConfigurazionePolicy().isSimultanee() && TipoControlloPeriodo.REALTIME.equals((Object)activePolicy.getConfigurazionePolicy().getModalitaControllo());
        this.richiesteSimultaneeIntervalloSecondi = ActiveRequestDistributedIntervalManager.getIntervalloSecondi();
        this.distributedActiveRequestCounterDate = this.initActiveRequestCounterDate();
        if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
            this.distributedActiveRequestCounterForCheck = this.initActiveRequestCounters(this.getActiveRequestCounterIntervalDate());
            this.distributedActiveRequestCounterForStats = null;
        } else {
            this.distributedActiveRequestCounterForStats = this.initActiveRequestCounters(this.getActiveRequestCounterIntervalDate());
        }
        if (super.getPolicyDate() != null) {
            Long polDate;
            if (this.distributedPolicyDate != null && this.distributedPolicyDate.compareAndSet(0L, super.getPolicyDate().getTime())) {
                Long getActiveRequestCounter;
                Long getPolicyCounter;
                Long getPolicyDenyRequestCounter;
                polDate = super.getPolicyDate().getTime();
                this.initPolicyCounters(polDate);
                Long getPolicyRequestCounter = super.getPolicyRequestCounter(true);
                if (getPolicyRequestCounter != null) {
                    this.distributedPolicyRequestCounter.addAndGet(getPolicyRequestCounter);
                }
                if ((getPolicyDenyRequestCounter = super.getPolicyDenyRequestCounter(true)) != null) {
                    this.distributedPolicyDenyRequestCounter.set(getPolicyDenyRequestCounter);
                }
                if (!(this.tipoRisorsa != null && this.isRisorsaContaNumeroRichieste(this.tipoRisorsa) || (getPolicyCounter = super.getPolicyCounter(true)) == null)) {
                    this.distributedPolicyCounter.addAndGet(getPolicyCounter);
                }
                if ((getActiveRequestCounter = super.getActiveRequestCounter(true)) != null && getActiveRequestCounter != 0L) {
                    if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
                        this.distributedActiveRequestCounterForCheck.set(getActiveRequestCounter);
                    } else if (this.distributedActiveRequestCounterForStats != null) {
                        this.distributedActiveRequestCounterForStats.set(getActiveRequestCounter);
                    }
                }
            } else {
                polDate = this.distributedPolicyDate != null ? Long.valueOf(this.distributedPolicyDate.get()) : null;
                this.initPolicyCounters(polDate);
            }
        }
        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue() && super.getPolicyDegradoPrestazionaleDate() != null) {
            Long degradoPrestazionaleTime;
            if (this.distributedPolicyDegradoPrestazionaleDate != null && this.distributedPolicyDegradoPrestazionaleDate.compareAndSet(0L, super.getPolicyDegradoPrestazionaleDate().getTime())) {
                Long getPolicyDegradoPrestazionaleCounter;
                degradoPrestazionaleTime = super.getPolicyDegradoPrestazionaleDate().getTime();
                this.initPolicyCountersDegradoPrestazionale(degradoPrestazionaleTime);
                Long getPolicyDegradoPrestazionaleRequestCounter = super.getPolicyDegradoPrestazionaleRequestCounter(true);
                if (getPolicyDegradoPrestazionaleRequestCounter != null) {
                    this.distributedPolicyDegradoPrestazionaleRequestCounter.addAndGet(getPolicyDegradoPrestazionaleRequestCounter);
                }
                if ((getPolicyDegradoPrestazionaleCounter = super.getPolicyDegradoPrestazionaleCounter(true)) != null) {
                    this.distributedPolicyDegradoPrestazionaleCounter.addAndGet(getPolicyDegradoPrestazionaleCounter);
                }
            } else {
                degradoPrestazionaleTime = this.distributedPolicyDegradoPrestazionaleDate != null ? Long.valueOf(this.distributedPolicyDegradoPrestazionaleDate.get()) : null;
                this.initPolicyCountersDegradoPrestazionale(degradoPrestazionaleTime);
            }
        }
        this.initialized = true;
    }

    private DatoAtomicLong initPolicyDate() {
        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            return new DatoAtomicLong(this.hazelcast, COUNTER_PREFIX + this.groupByPolicyMapIdHashCode + "-policyDate-c" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L), this.policyType);
        }
        return null;
    }

    private DatoAtomicLong initUpdatePolicyDate() {
        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            return new DatoAtomicLong(this.hazelcast, COUNTER_PREFIX + this.groupByPolicyMapIdHashCode + "-updatePolicyDate-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L), this.policyType);
        }
        return null;
    }

    private DatoAtomicLong initPolicyDegradoPrestazionaleDate() {
        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue()) {
            return new DatoAtomicLong(this.hazelcast, COUNTER_PREFIX + this.groupByPolicyMapIdHashCode + "-policyDegradoPrestazionaleDate-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L), this.policyType);
        }
        return null;
    }

    private DatoAtomicLong initActiveRequestCounterDate() {
        if (this.richiesteSimultaneeIntervalloSecondi > 0) {
            return new DatoAtomicLong(this.hazelcast, COUNTER_PREFIX + this.groupByPolicyMapIdHashCode + "-policyDate-cactiveRequest" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L), this.policyType);
        }
        return null;
    }

    protected Long getActiveRequestCounterIntervalDate() {
        if (this.richiesteSimultaneeIntervalloSecondi <= 0) {
            return null;
        }
        long intervalStart = ActiveRequestDistributedIntervalManager.calcolaIntervalloCorrente(this.richiesteSimultaneeIntervalloSecondi);
        if (this.distributedActiveRequestCounterDate != null) {
            long distributedDate = this.distributedActiveRequestCounterDate.get();
            if (distributedDate == 0L) {
                this.distributedActiveRequestCounterDate.compareAndSet(0L, intervalStart);
                return intervalStart;
            }
            if (distributedDate < intervalStart) {
                if (this.distributedActiveRequestCounterDate.compareAndSet(distributedDate, intervalStart)) {
                    return intervalStart;
                }
                return this.distributedActiveRequestCounterDate.get();
            }
            return distributedDate;
        }
        return intervalStart;
    }

    protected String getPolicyIdForContext() {
        return String.valueOf(this.groupByPolicyMapIdHashCode);
    }

    private DatoAtomicLong initActiveRequestCounters(Long intervalDate) {
        if (intervalDate != null && intervalDate > 0L) {
            return new DatoAtomicLong(this.hazelcast, COUNTER_PREFIX + this.groupByPolicyMapIdHashCode + "-activeRequestCounter-i-" + intervalDate + "-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L), this.policyType);
        }
        return new DatoAtomicLong(this.hazelcast, COUNTER_PREFIX + this.groupByPolicyMapIdHashCode + "-activeRequestCounter-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L), this.policyType);
    }

    private void initPolicyCounters(Long policyDate) {
        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            this.distributedPolicyRequestCounter = new DatoAtomicLong(this.hazelcast, COUNTER_PREFIX + this.groupByPolicyMapIdHashCode + "-policyRequestCounter-i-" + policyDate + "-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L), this.policyType);
            this.distributedPolicyDenyRequestCounter = new DatoAtomicLong(this.hazelcast, COUNTER_PREFIX + this.groupByPolicyMapIdHashCode + "-policyDenyRequestCounter-i-" + policyDate + "-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L), this.policyType);
            if (this.tipoRisorsa == null || !this.isRisorsaContaNumeroRichieste(this.tipoRisorsa)) {
                this.distributedPolicyCounter = new DatoAtomicLong(this.hazelcast, COUNTER_PREFIX + this.groupByPolicyMapIdHashCode + "-policyCounter-i-" + policyDate + "-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L), this.policyType);
            }
        }
    }

    private void initPolicyCountersDegradoPrestazionale(Long policyDate) {
        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue()) {
            this.distributedPolicyDegradoPrestazionaleCounter = new DatoAtomicLong(this.hazelcast, COUNTER_PREFIX + this.groupByPolicyMapIdHashCode + "-policyDegradoPrestazionaleCounter-i-" + policyDate + "-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L), this.policyType);
            this.distributedPolicyDegradoPrestazionaleRequestCounter = new DatoAtomicLong(this.hazelcast, COUNTER_PREFIX + this.groupByPolicyMapIdHashCode + "-policyDegradoPrestazionaleRequestCounter-i-" + policyDate + "-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L), this.policyType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void resetPolicyCounterForDate(Date date) {
        if (this.initialized) {
            SemaphoreLock slock = this.lock.acquireThrowRuntime("resetPolicyCounterForDate");
            try {
                long actualSuper;
                long policyDate = date.getTime();
                long actual = this.distributedPolicyDate.get();
                long l = actualSuper = this.policyDate != null ? this.policyDate.getTime() : -1L;
                if (actualSuper != policyDate && actual < policyDate && this.distributedPolicyDate.compareAndSet(actual, policyDate)) {
                    if (!this.cestinoPolicyCounters.isEmpty()) {
                        for (DatoAtomicLong iAtomicLong : this.cestinoPolicyCounters) {
                            iAtomicLong.destroy();
                        }
                        this.cestinoPolicyCounters.clear();
                    }
                    if (this.distributedPolicyRequestCounter != null || this.distributedPolicyDenyRequestCounter != null || this.distributedPolicyCounter != null) {
                        if (this.distributedPolicyRequestCounter != null) {
                            this.cestinoPolicyCounters.add(this.distributedPolicyRequestCounter);
                        }
                        if (this.distributedPolicyDenyRequestCounter != null) {
                            this.cestinoPolicyCounters.add(this.distributedPolicyDenyRequestCounter);
                        }
                        if (this.distributedPolicyCounter != null) {
                            this.cestinoPolicyCounters.add(this.distributedPolicyCounter);
                        }
                    }
                }
                if (actualSuper == policyDate) return;
                this.initPolicyCounters(policyDate);
                super.resetPolicyCounterForDate(date);
                return;
            }
            finally {
                this.lock.release(slock, "resetPolicyCounterForDate");
            }
        } else {
            super.resetPolicyCounterForDate(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void resetPolicyCounterForDateDegradoPrestazionale(Date date) {
        if (this.initialized) {
            SemaphoreLock slock = this.lock.acquireThrowRuntime("resetPolicyCounterForDateDegradoPrestazionale");
            try {
                long actualSuper;
                long policyDate = date.getTime();
                long actual = this.distributedPolicyDegradoPrestazionaleDate.get();
                long l = actualSuper = this.policyDegradoPrestazionaleDate != null ? this.policyDegradoPrestazionaleDate.getTime() : -1L;
                if (actualSuper != policyDate && actual < policyDate && this.distributedPolicyDegradoPrestazionaleDate.compareAndSet(actual, policyDate)) {
                    if (!this.cestinoPolicyCountersDegradoPrestazionale.isEmpty()) {
                        for (DatoAtomicLong iAtomicLong : this.cestinoPolicyCountersDegradoPrestazionale) {
                            iAtomicLong.destroy();
                        }
                        this.cestinoPolicyCountersDegradoPrestazionale.clear();
                    }
                    if (this.distributedPolicyRequestCounter != null || this.distributedPolicyDenyRequestCounter != null || this.distributedPolicyCounter != null) {
                        if (this.distributedPolicyDegradoPrestazionaleCounter != null) {
                            this.cestinoPolicyCountersDegradoPrestazionale.add(this.distributedPolicyDegradoPrestazionaleCounter);
                        }
                        if (this.distributedPolicyDegradoPrestazionaleRequestCounter != null) {
                            this.cestinoPolicyCountersDegradoPrestazionale.add(this.distributedPolicyDegradoPrestazionaleRequestCounter);
                        }
                    }
                }
                if (actualSuper == policyDate) return;
                this.initPolicyCountersDegradoPrestazionale(policyDate);
                super.resetPolicyCounterForDateDegradoPrestazionale(date);
                return;
            }
            finally {
                this.lock.release(slock, "resetPolicyCounterForDateDegradoPrestazionale");
            }
        } else {
            super.resetPolicyCounterForDateDegradoPrestazionale(date);
        }
    }

    public void resetCounters(Date updatePolicyDate) {
        super.resetCounters(updatePolicyDate);
        if (updatePolicyDate != null) {
            this.distributedUpdatePolicyDate.set(updatePolicyDate.getTime());
        }
        if (this.distributedPolicyDenyRequestCounter != null) {
            this.distributedPolicyDenyRequestCounter.set(0L);
        }
        if (this.distributedPolicyRequestCounter != null) {
            this.distributedPolicyRequestCounter.set(0L);
        }
        if (this.distributedPolicyCounter != null) {
            this.distributedPolicyCounter.set(0L);
        }
        if (this.distributedPolicyDegradoPrestazionaleRequestCounter != null) {
            this.distributedPolicyDegradoPrestazionaleRequestCounter.set(0L);
        }
        if (this.distributedPolicyDegradoPrestazionaleCounter != null) {
            this.distributedPolicyDegradoPrestazionaleCounter.set(0L);
        }
    }

    protected void internalRegisterStartRequestIncrementActiveRequestCounter(DatiCollezionati datiCollezionatiPerPolicyVerifier, Map<Object> ctx) {
        if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
            if (this.richiesteSimultaneeIntervalloSecondi > 0) {
                this.checkActiveRequestCounterIntervalChangeForCheck();
            }
            this.activeRequestCounter = datiCollezionatiPerPolicyVerifier != null ? Long.valueOf(datiCollezionatiPerPolicyVerifier.setAndGetActiveRequestCounter(this.distributedActiveRequestCounterForCheck.incrementAndGet())) : Long.valueOf(this.distributedActiveRequestCounterForCheck.incrementAndGet());
            this.saveIntervalDateInContext(ctx);
        } else {
            if (this.richiesteSimultaneeIntervalloSecondi > 0) {
                this.checkActiveRequestCounterIntervalChangeForStats();
            }
            this.distributedActiveRequestCounterForStats.incrementAndGetAsync();
            this.saveIntervalDateInContext(ctx);
        }
    }

    private void saveIntervalDateInContext(Map<Object> ctx) {
        if (ctx != null && this.richiesteSimultaneeIntervalloSecondi > 0) {
            Long intervalDate = this.getActiveRequestCounterIntervalDate();
            this.saveActiveRequestCounterIntervalDateInContext(ctx, intervalDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkActiveRequestCounterIntervalChangeForCheck() {
        if (this.distributedActiveRequestCounterDate == null || this.distributedActiveRequestCounterForCheck == null) {
            return;
        }
        long distributedDate = this.distributedActiveRequestCounterDate.get();
        if (!ActiveRequestDistributedIntervalManager.isIntervalloCambiato(this.richiesteSimultaneeIntervalloSecondi, distributedDate)) {
            return;
        }
        long currentIntervalStart = ActiveRequestDistributedIntervalManager.calcolaIntervalloCorrente(this.richiesteSimultaneeIntervalloSecondi);
        SemaphoreLock slock = this.lock.acquireThrowRuntime("checkActiveRequestCounterIntervalChangeForCheck");
        try {
            distributedDate = this.distributedActiveRequestCounterDate.get();
            if (ActiveRequestDistributedIntervalManager.isIntervalloCambiato(this.richiesteSimultaneeIntervalloSecondi, distributedDate)) {
                if (this.distributedActiveRequestCounterDate.compareAndSet(distributedDate, currentIntervalStart)) {
                    if (!this.cestinoActiveRequestCounters.isEmpty()) {
                        for (DatoAtomicLong counter : this.cestinoActiveRequestCounters) {
                            counter.destroy();
                        }
                        this.cestinoActiveRequestCounters.clear();
                    }
                    this.cestinoActiveRequestCounters.add(this.distributedActiveRequestCounterForCheck);
                    this.distributedActiveRequestCounterForCheck = this.initActiveRequestCounters(currentIntervalStart);
                } else {
                    Long newDate = this.distributedActiveRequestCounterDate.get();
                    this.distributedActiveRequestCounterForCheck = this.initActiveRequestCounters(newDate);
                }
            }
        }
        finally {
            this.lock.release(slock, "checkActiveRequestCounterIntervalChangeForCheck");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkActiveRequestCounterIntervalChangeForStats() {
        if (this.distributedActiveRequestCounterDate == null || this.distributedActiveRequestCounterForStats == null) {
            return;
        }
        long distributedDate = this.distributedActiveRequestCounterDate.get();
        if (!ActiveRequestDistributedIntervalManager.isIntervalloCambiato(this.richiesteSimultaneeIntervalloSecondi, distributedDate)) {
            return;
        }
        long currentIntervalStart = ActiveRequestDistributedIntervalManager.calcolaIntervalloCorrente(this.richiesteSimultaneeIntervalloSecondi);
        SemaphoreLock slock = this.lock.acquireThrowRuntime("checkActiveRequestCounterIntervalChangeForStats");
        try {
            distributedDate = this.distributedActiveRequestCounterDate.get();
            if (ActiveRequestDistributedIntervalManager.isIntervalloCambiato(this.richiesteSimultaneeIntervalloSecondi, distributedDate)) {
                if (this.distributedActiveRequestCounterDate.compareAndSet(distributedDate, currentIntervalStart)) {
                    if (!this.cestinoActiveRequestCounters.isEmpty()) {
                        for (DatoAtomicLong counter : this.cestinoActiveRequestCounters) {
                            counter.destroy();
                        }
                        this.cestinoActiveRequestCounters.clear();
                    }
                    this.cestinoActiveRequestCounters.add(this.distributedActiveRequestCounterForStats);
                    this.distributedActiveRequestCounterForStats = this.initActiveRequestCounters(currentIntervalStart);
                } else {
                    Long newDate = this.distributedActiveRequestCounterDate.get();
                    this.distributedActiveRequestCounterForStats = this.initActiveRequestCounters(newDate);
                }
            }
        }
        finally {
            this.lock.release(slock, "checkActiveRequestCounterIntervalChangeForStats");
        }
    }

    protected void internalUpdateDatiStartRequestApplicabileIncrementRequestCounter(DatiCollezionati datiCollezionatiPerPolicyVerifier) {
        this.policyRequestCounter = datiCollezionatiPerPolicyVerifier != null ? datiCollezionatiPerPolicyVerifier.setAndGetPolicyRequestCounter(Long.valueOf(this.distributedPolicyRequestCounter.incrementAndGet())) : Long.valueOf(this.distributedPolicyRequestCounter.incrementAndGet());
    }

    protected void internalRegisterEndRequestDecrementActiveRequestCounter() {
        if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
            if (this.distributedActiveRequestCounterForCheck.get() > 0L) {
                this.activeRequestCounter = this.distributedActiveRequestCounterForCheck.decrementAndGet();
            }
        } else if (this.distributedActiveRequestCounterForStats.get() > 0L) {
            this.distributedActiveRequestCounterForStats.decrementAndGetAsync();
        }
    }

    protected void internalRegisterEndRequestIncrementDegradoPrestazionaleRequestCounter() {
        this.policyDegradoPrestazionaleRequestCounter = this.distributedPolicyDegradoPrestazionaleRequestCounter.incrementAndGet();
    }

    protected void internalRegisterEndRequestIncrementDegradoPrestazionaleCounter(long latenza) {
        this.policyDegradoPrestazionaleCounter = this.distributedPolicyDegradoPrestazionaleCounter.addAndGet(latenza);
    }

    protected void internalUpdateDatiEndRequestApplicabileIncrementRequestCounter() {
        this.policyRequestCounter = this.distributedPolicyRequestCounter.incrementAndGet();
    }

    protected void internalUpdateDatiEndRequestApplicabileDecrementRequestCounter() {
        this.policyRequestCounter = this.distributedPolicyRequestCounter.decrementAndGet();
    }

    protected void internalUpdateDatiEndRequestApplicabileIncrementDenyRequestCounter() {
        this.distributedPolicyDenyRequestCounter.incrementAndGetAsync();
    }

    protected void internalUpdateDatiEndRequestApplicabileIncrementCounter(long v) {
        this.policyCounter = this.distributedPolicyCounter.addAndGet(v);
    }

    public void destroyDatiDistribuiti() {
        if (this.distributedPolicyDate != null) {
            this.distributedPolicyDate.destroy();
        }
        if (this.distributedUpdatePolicyDate != null) {
            this.distributedUpdatePolicyDate.destroy();
        }
        if (this.distributedPolicyRequestCounter != null) {
            this.distributedPolicyRequestCounter.destroy();
        }
        if (this.distributedPolicyCounter != null) {
            this.distributedPolicyCounter.destroy();
        }
        if (this.distributedPolicyDegradoPrestazionaleDate != null) {
            this.distributedPolicyDegradoPrestazionaleDate.destroy();
        }
        if (this.distributedPolicyDegradoPrestazionaleRequestCounter != null) {
            this.distributedPolicyDegradoPrestazionaleRequestCounter.destroy();
        }
        if (this.distributedPolicyDegradoPrestazionaleCounter != null) {
            this.distributedPolicyDegradoPrestazionaleCounter.destroy();
        }
        if (this.distributedActiveRequestCounterForStats != null) {
            this.distributedActiveRequestCounterForStats.destroy();
        }
        if (this.distributedActiveRequestCounterForCheck != null) {
            this.distributedActiveRequestCounterForCheck.destroy();
        }
        if (this.distributedActiveRequestCounterDate != null) {
            this.distributedActiveRequestCounterDate.destroy();
        }
        if (this.cestinoActiveRequestCounters != null && !this.cestinoActiveRequestCounters.isEmpty()) {
            for (DatoAtomicLong counter : this.cestinoActiveRequestCounters) {
                counter.destroy();
            }
            this.cestinoActiveRequestCounters.clear();
        }
        if (this.cestinoPolicyCounters != null && !this.cestinoPolicyCounters.isEmpty()) {
            for (DatoAtomicLong counter : this.cestinoPolicyCounters) {
                counter.destroy();
            }
            this.cestinoPolicyCounters.clear();
        }
        if (this.cestinoPolicyCountersDegradoPrestazionale != null && !this.cestinoPolicyCountersDegradoPrestazionale.isEmpty()) {
            for (DatoAtomicLong counter : this.cestinoPolicyCountersDegradoPrestazionale) {
                counter.destroy();
            }
            this.cestinoPolicyCountersDegradoPrestazionale.clear();
        }
        if (this.distributedPolicyDenyRequestCounter != null) {
            this.distributedPolicyDenyRequestCounter.destroy();
        }
    }

    public Long getActiveRequestCounter(boolean readRemoteInfo) {
        if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
            if (readRemoteInfo) {
                try {
                    return this.distributedActiveRequestCounterForCheck.get();
                }
                catch (DistributedObjectDestroyedException e) {
                    return this.activeRequestCounter;
                }
            }
            return this.activeRequestCounter;
        }
        try {
            return this.distributedActiveRequestCounterForStats.get();
        }
        catch (DistributedObjectDestroyedException e) {
            return 0L;
        }
    }

    public Long getPolicyDenyRequestCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyDenyRequestCounter != null) {
                try {
                    return this.distributedPolicyDenyRequestCounter.get();
                }
                catch (DistributedObjectDestroyedException e) {
                    return super.getPolicyDenyRequestCounter(false);
                }
            }
            return null;
        }
        return super.getPolicyDenyRequestCounter(readRemoteInfo);
    }

    public Long getPolicyRequestCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyRequestCounter != null) {
                try {
                    return this.distributedPolicyRequestCounter.get();
                }
                catch (DistributedObjectDestroyedException e) {
                    return super.getPolicyRequestCounter(false);
                }
            }
            return null;
        }
        return super.getPolicyRequestCounter(readRemoteInfo);
    }

    public Long getPolicyCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyCounter != null) {
                try {
                    return this.distributedPolicyCounter.get();
                }
                catch (DistributedObjectDestroyedException e) {
                    return super.getPolicyCounter(false);
                }
            }
            return null;
        }
        return super.getPolicyCounter(readRemoteInfo);
    }

    public Long getPolicyDegradoPrestazionaleRequestCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyDegradoPrestazionaleRequestCounter != null) {
                try {
                    return this.distributedPolicyDegradoPrestazionaleRequestCounter.get();
                }
                catch (DistributedObjectDestroyedException e) {
                    return super.getPolicyDegradoPrestazionaleRequestCounter(false);
                }
            }
            return null;
        }
        return super.getPolicyDegradoPrestazionaleRequestCounter(readRemoteInfo);
    }

    public Long getPolicyDegradoPrestazionaleCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyDegradoPrestazionaleCounter != null) {
                try {
                    return this.distributedPolicyDegradoPrestazionaleCounter.get();
                }
                catch (DistributedObjectDestroyedException e) {
                    return super.getPolicyDegradoPrestazionaleCounter(false);
                }
            }
            return null;
        }
        return super.getPolicyDegradoPrestazionaleCounter(readRemoteInfo);
    }
}

