/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.counters;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.crdt.pncounter.PNCounter;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.counters.PNCounterOperation;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.counters.PNCounterResponse;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.Utilities;
import org.slf4j.Logger;

public class DatoPNCounter {
    private HazelcastInstance hazelcast;
    private String name;
    private PNCounter counter;
    private int failover = -1;
    private int failoverCheckEveryMs = -1;
    private Logger logControlloTraffico;

    public DatoPNCounter(HazelcastInstance hazelcast, String name) {
        this.hazelcast = hazelcast;
        this.name = name;
        this.initCounter();
        OpenSPCoop2Properties op2Props = OpenSPCoop2Properties.getInstance();
        this.failover = op2Props.getHazelcastCPSubsystemDistributedObjectDestroyedExceptionFailover();
        this.failoverCheckEveryMs = op2Props.getHazelcastCPSubsystemDistributedObjectDestroyedExceptionFailoverCheckEveryMs();
        this.logControlloTraffico = OpenSPCoop2Logger.getLoggerOpenSPCoopControlloTraffico(op2Props.isControlloTrafficoDebug());
    }

    private void initCounter() {
        this.counter = this.hazelcast.getPNCounter(this.name);
    }

    public String getName() {
        return this.name;
    }

    public long get() {
        PNCounterResponse r = this.process(PNCounterOperation.GET, -1L, -1L);
        return r != null ? r.valueL : -1L;
    }

    public long addAndGet(long value) {
        PNCounterResponse r = this.process(PNCounterOperation.ADD_AND_GET, value, -1L);
        return r != null ? r.valueL : -1L;
    }

    public long incrementAndGet() {
        PNCounterResponse r = this.process(PNCounterOperation.INCREMENT_AND_GET, -1L, -1L);
        return r != null ? r.valueL : -1L;
    }

    public long decrementAndGet() {
        PNCounterResponse r = this.process(PNCounterOperation.DECREMENT_AND_GET, -1L, -1L);
        return r != null ? r.valueL : -1L;
    }

    public long subtractAndGet(long value) {
        PNCounterResponse r = this.process(PNCounterOperation.SUBTRACT_AND_GET, value, -1L);
        return r != null ? r.valueL : -1L;
    }

    public void destroy() {
        this.process(PNCounterOperation.DESTROY, -1L, -1L);
    }

    private PNCounterResponse process(PNCounterOperation op, long arg1, long arg2) {
        String prefix = "[Hazelcast-PNCounter-" + this.name + " operation:" + op + "] ";
        if (this.failover > 0) {
            return this.processFailOver(prefix, op, arg1, arg2);
        }
        return this.operation(prefix, op, arg1, arg2);
    }

    private PNCounterResponse processFailOver(String prefix, PNCounterOperation op, long arg1, long arg2) {
        boolean success = false;
        DistributedObjectDestroyedException eFinal = null;
        PNCounterResponse v = null;
        for (int i = 0; i < this.failover; ++i) {
            try {
                if (i > 0 && this.failoverCheckEveryMs > 0) {
                    Utilities.sleep((long)this.failoverCheckEveryMs);
                    this.initCounter();
                }
                v = this.operation(prefix, op, arg1, arg2);
                success = true;
                break;
            }
            catch (DistributedObjectDestroyedException e) {
                eFinal = e;
                if (i == 0) {
                    this.logControlloTraffico.error(prefix + "rilevato contatore distrutto (verr\u00e0 riprovata la creazione): " + e.getMessage(), (Throwable)e);
                    continue;
                }
                this.logControlloTraffico.error(prefix + "il tenativo i=" + i + " di ricreare il contatore \u00e8 fallito: " + e.getMessage(), (Throwable)e);
                continue;
            }
        }
        if (!success) {
            this.throwDistributedObjectDestroyedException(prefix, eFinal);
        }
        return v;
    }

    private void throwDistributedObjectDestroyedException(String prefix, DistributedObjectDestroyedException eFinal) {
        String msg = prefix + "tutti i tentativi di ricreare il contatore sono falliti";
        this.logControlloTraffico.error(msg);
        if (eFinal != null) {
            throw eFinal;
        }
        throw new DistributedObjectDestroyedException("tutti i tentativi di ricreare il contatore sono falliti");
    }

    private PNCounterResponse operation(String prefix, PNCounterOperation op, long arg1, long arg2) {
        switch (op) {
            case GET: {
                return new PNCounterResponse(this.counter.get());
            }
            case ADD_AND_GET: {
                return new PNCounterResponse(this.counter.addAndGet(arg1));
            }
            case INCREMENT_AND_GET: {
                return new PNCounterResponse(this.counter.incrementAndGet());
            }
            case DECREMENT_AND_GET: {
                return new PNCounterResponse(this.counter.decrementAndGet());
            }
            case SUBTRACT_AND_GET: {
                return new PNCounterResponse(this.counter.subtractAndGet(arg1));
            }
            case DESTROY: {
                try {
                    this.counter.destroy();
                }
                catch (Throwable e) {
                    this.logControlloTraffico.error(prefix + "destroy non riuscito: " + e.getMessage(), e);
                    throw e;
                }
                return null;
            }
        }
        return null;
    }
}

