/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver.redisson.counters;

import java.io.Serializable;
import org.openspcoop2.core.controllo_traffico.ConfigurazionePolicy;
import org.openspcoop2.core.controllo_traffico.beans.ActivePolicy;
import org.openspcoop2.core.controllo_traffico.constants.TipoControlloPeriodo;
import org.openspcoop2.core.controllo_traffico.constants.TipoPeriodoRealtime;
import org.openspcoop2.core.controllo_traffico.constants.TipoPeriodoStatistico;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;

public class RedisTTLConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long DEFAULT_TTL_SECONDS = 300L;
    public static final long MIN_TTL_SECONDS = 60L;
    public static final long MAX_TTL_SECONDS = 604800L;
    public static final int DEFAULT_INTERVAL_MULTIPLIER = 2;
    private boolean enabled;
    private long ttlSeconds;
    private boolean renewTTLOnWrite;

    public RedisTTLConfig() {
        OpenSPCoop2Properties props = OpenSPCoop2Properties.getInstance();
        this.enabled = props.isControlloTrafficoGestorePolicyInMemoryRedisTTLEnabled();
        this.ttlSeconds = props.getControlloTrafficoGestorePolicyInMemoryRedisTTLDefaultSeconds();
        this.renewTTLOnWrite = props.isControlloTrafficoGestorePolicyInMemoryRedisTTLRenewOnWriteWithoutInterval();
    }

    public RedisTTLConfig(boolean enabled, long ttlSeconds, boolean renewTTLOnWrite) {
        this.enabled = enabled;
        this.ttlSeconds = ttlSeconds;
        this.renewTTLOnWrite = renewTTLOnWrite;
    }

    public RedisTTLConfig(ActivePolicy activePolicy) {
        OpenSPCoop2Properties props = OpenSPCoop2Properties.getInstance();
        this.enabled = props.isControlloTrafficoGestorePolicyInMemoryRedisTTLEnabled();
        if (this.enabled && activePolicy != null) {
            TTLCalculationResult result = this.calculateTTLFromPolicy(activePolicy, props);
            this.ttlSeconds = result.ttlSeconds;
            this.renewTTLOnWrite = result.renewOnWrite;
        } else {
            this.ttlSeconds = props.getControlloTrafficoGestorePolicyInMemoryRedisTTLDefaultSeconds();
            this.renewTTLOnWrite = props.isControlloTrafficoGestorePolicyInMemoryRedisTTLRenewOnWriteWithoutInterval();
        }
    }

    private TTLCalculationResult calculateTTLFromPolicy(ActivePolicy activePolicy, OpenSPCoop2Properties props) {
        boolean ttlTroncato;
        if (activePolicy == null || activePolicy.getConfigurazionePolicy() == null) {
            return new TTLCalculationResult(props.getControlloTrafficoGestorePolicyInMemoryRedisTTLDefaultSeconds(), props.isControlloTrafficoGestorePolicyInMemoryRedisTTLRenewOnWriteWithoutInterval());
        }
        ConfigurazionePolicy config = activePolicy.getConfigurazionePolicy();
        if (config.isSimultanee()) {
            return new TTLCalculationResult(props.getControlloTrafficoGestorePolicyInMemoryRedisTTLDefaultSeconds(), props.isControlloTrafficoGestorePolicyInMemoryRedisTTLRenewOnWriteWithoutInterval());
        }
        long intervalloSeconds = this.calculateIntervalSeconds(config);
        if (intervalloSeconds <= 0L) {
            return new TTLCalculationResult(props.getControlloTrafficoGestorePolicyInMemoryRedisTTLDefaultSeconds(), props.isControlloTrafficoGestorePolicyInMemoryRedisTTLRenewOnWriteWithoutInterval());
        }
        int multiplier = props.getControlloTrafficoGestorePolicyInMemoryRedisTTLIntervalMultiplier();
        long ttlCalcolato = intervalloSeconds * (long)multiplier;
        long minTTL = props.getControlloTrafficoGestorePolicyInMemoryRedisTTLMinSeconds();
        long maxTTL = props.getControlloTrafficoGestorePolicyInMemoryRedisTTLMaxSeconds();
        long ttlFinale = Math.max(ttlCalcolato, minTTL);
        boolean bl = ttlTroncato = ttlFinale > maxTTL;
        if (ttlTroncato) {
            ttlFinale = maxTTL;
        }
        boolean renewOnWrite = ttlTroncato ? props.isControlloTrafficoGestorePolicyInMemoryRedisTTLRenewOnWriteWithoutInterval() : props.isControlloTrafficoGestorePolicyInMemoryRedisTTLRenewOnWriteIntervalBased();
        return new TTLCalculationResult(ttlFinale, renewOnWrite);
    }

    private long calculateIntervalSeconds(ConfigurazionePolicy config) {
        Integer intervallo = config.getIntervalloOsservazione();
        if (intervallo == null || intervallo <= 0) {
            return 0L;
        }
        long intervalloSeconds = 0L;
        if (TipoControlloPeriodo.REALTIME.equals((Object)config.getModalitaControllo())) {
            intervalloSeconds = this.calculateRealtimeIntervalSeconds(config, intervallo);
        } else if (TipoControlloPeriodo.STATISTIC.equals((Object)config.getModalitaControllo())) {
            intervalloSeconds = this.calculateStatisticIntervalSeconds(config, intervallo);
        }
        return intervalloSeconds;
    }

    private long calculateRealtimeIntervalSeconds(ConfigurazionePolicy config, int intervallo) {
        TipoPeriodoRealtime tipo = config.getTipoIntervalloOsservazioneRealtime();
        if (tipo == null) {
            return 0L;
        }
        switch (tipo) {
            case SECONDI: {
                return intervallo;
            }
            case MINUTI: {
                return (long)intervallo * 60L;
            }
            case ORARIO: {
                return (long)intervallo * 3600L;
            }
            case GIORNALIERO: {
                return (long)intervallo * 86400L;
            }
        }
        return 0L;
    }

    private long calculateStatisticIntervalSeconds(ConfigurazionePolicy config, int intervallo) {
        TipoPeriodoStatistico tipo = config.getTipoIntervalloOsservazioneStatistico();
        if (tipo == null) {
            return 0L;
        }
        switch (tipo) {
            case ORARIO: {
                return (long)intervallo * 3600L;
            }
            case GIORNALIERO: {
                return (long)intervallo * 86400L;
            }
            case SETTIMANALE: {
                return (long)intervallo * 604800L;
            }
            case MENSILE: {
                return (long)intervallo * 2592000L;
            }
        }
        return 0L;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public long getTtlSeconds() {
        return this.ttlSeconds;
    }

    public void setTtlSeconds(long ttlSeconds) {
        this.ttlSeconds = ttlSeconds;
    }

    public boolean isRenewTTLOnWrite() {
        return this.renewTTLOnWrite;
    }

    public void setRenewTTLOnWrite(boolean renewTTLOnWrite) {
        this.renewTTLOnWrite = renewTTLOnWrite;
    }

    public static RedisTTLConfig disabled() {
        return new RedisTTLConfig(false, -1L, false);
    }

    public static RedisTTLConfig withTTL(long ttlSeconds) {
        return new RedisTTLConfig(true, ttlSeconds, true);
    }

    public static RedisTTLConfig fromPolicy(ActivePolicy activePolicy) {
        return new RedisTTLConfig(activePolicy);
    }

    public static RedisTTLConfig forCountersWithoutInterval() {
        OpenSPCoop2Properties props = OpenSPCoop2Properties.getInstance();
        return new RedisTTLConfig(props.isControlloTrafficoGestorePolicyInMemoryRedisTTLEnabled(), props.getControlloTrafficoGestorePolicyInMemoryRedisTTLDefaultSeconds(), props.isControlloTrafficoGestorePolicyInMemoryRedisTTLRenewOnWriteWithoutInterval());
    }

    public String toString() {
        return "RedisTTLConfig [enabled=" + this.enabled + ", ttlSeconds=" + this.ttlSeconds + ", renewTTLOnWrite=" + this.renewTTLOnWrite + "]";
    }

    private static class TTLCalculationResult {
        long ttlSeconds;
        boolean renewOnWrite;

        TTLCalculationResult(long ttlSeconds, boolean renewOnWrite) {
            this.ttlSeconds = ttlSeconds;
            this.renewOnWrite = renewOnWrite;
        }
    }
}

