/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.credenziali;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.transport.Credential;
import org.openspcoop2.utils.transport.http.HttpServletCredential;
import org.slf4j.Logger;

public class Credenziali
extends HttpServletCredential
implements Serializable {
    public static final boolean SHOW_BASIC_PASSWORD = true;
    public static final boolean SHOW_ISSUER = true;
    public static final boolean SHOW_DIGEST_CLIENT_CERT = true;
    public static final boolean SHOW_SERIAL_NUMBER_CLIENT_CERT = true;
    private static final long serialVersionUID = 1L;

    public Credenziali() {
    }

    public Credenziali(Credential credentials) {
        if (credentials != null) {
            this.principal = credentials.getPrincipalObject();
            this.principalName = credentials.getPrincipal();
            this.subject = credentials.getSubject();
            this.issuer = credentials.getIssuer();
            this.certificate = credentials.getCertificate();
            this.username = credentials.getUsername();
            this.password = credentials.getPassword();
            this.bearerToken = credentials.getBearerToken();
        }
    }

    public Credenziali(HttpServletRequest req) {
        super(req, null);
    }

    public Credenziali(HttpServletRequest req, Logger log) {
        super(req, log);
    }

    public boolean equals(Object c) {
        if (c == null) {
            return false;
        }
        if (this.getClass() != c.getClass()) {
            return false;
        }
        return this.toString().equals(((Credenziali)c).toString());
    }

    public int hashCode() {
        String s = this.toString();
        return s != null ? s.hashCode() : 0;
    }

    public String toString() {
        return this.toString(false, false, false, false);
    }

    public String toString(boolean showBasicPassword, boolean showIssuer, boolean showDigestClientCert, boolean showSerialNumberClientCert) {
        return this.toString(showBasicPassword, showIssuer, showDigestClientCert, showSerialNumberClientCert, "( ", " ) ", ", ");
    }

    public String toString(boolean showBasicPassword, boolean showIssuer, boolean showDigestClientCert, boolean showSerialNumberClientCert, String start, String end, String separator) {
        Object credenzialiFornite = "";
        if (this.getUsername() != null || this.getSubject() != null || this.getPassword() != null || this.getPrincipal() != null) {
            Object label;
            credenzialiFornite = start;
            boolean printPrincipal = true;
            if (this.getUsername() != null) {
                label = "BasicUsername";
                if (this.getPrincipal() != null && this.getPrincipal().equals(this.getUsername())) {
                    label = (String)label + "/Principal";
                    printPrincipal = false;
                }
                credenzialiFornite = this.getPassword() == null ? (String)credenzialiFornite + (String)label + " '" + this.getUsername() + "'" + separator + "BasicPassword undefined" : ("".equals(this.getPassword()) ? (String)credenzialiFornite + (String)label + " '" + this.getUsername() + "'" + separator + "BasicPassword empty" : (showBasicPassword ? (String)credenzialiFornite + (String)label + " '" + this.getUsername() + "'" + separator + "BasicPassword '" + this.getPassword() + "'" : (String)credenzialiFornite + (String)label + " '" + this.getUsername() + "'"));
            }
            if (this.getSubject() != null) {
                label = "SSL-Subject";
                if (this.getPrincipal() != null && this.getPrincipal().equals(this.getSubject())) {
                    label = (String)label + "/Principal";
                    printPrincipal = false;
                }
                if (this.getUsername() != null) {
                    label = separator + (String)label;
                }
                credenzialiFornite = (String)credenzialiFornite + (String)label + " '" + this.getSubject() + "'";
                if (showIssuer && this.getIssuer() != null) {
                    label = separator + "SSL-Issuer";
                    credenzialiFornite = (String)credenzialiFornite + (String)label + " '" + this.getIssuer() + "'";
                }
                if (showDigestClientCert && this.getCertificate() != null && this.getCertificate().getCertificate() != null) {
                    String digest = null;
                    try {
                        digest = this.getCertificate().getCertificate().digestBase64Encoded();
                        label = separator + "SSL-ClientCert-Digest";
                        credenzialiFornite = (String)credenzialiFornite + (String)label + " '" + digest + "'";
                    }
                    catch (Exception e) {
                        LoggerWrapperFactory.getLogger(Credenziali.class).error("Errore Digest Certificato: " + e.getMessage(), (Throwable)e);
                    }
                }
                if (showSerialNumberClientCert && this.getCertificate() != null && this.getCertificate().getCertificate() != null) {
                    label = separator + "SSL-ClientCert-SerialNumber";
                    credenzialiFornite = (String)credenzialiFornite + (String)label + " '" + this.getCertificate().getCertificate().getSerialNumber() + "'";
                }
            }
            if (this.getPrincipal() != null && printPrincipal) {
                label = "Principal";
                if (this.getUsername() != null || this.getSubject() != null) {
                    label = separator + (String)label;
                }
                credenzialiFornite = (String)credenzialiFornite + (String)label + " '" + this.getPrincipal() + "'";
            }
            credenzialiFornite = (String)credenzialiFornite + end;
        }
        return credenzialiFornite;
    }
}

