/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.credenziali.engine;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.credenziali.GestoreCredenzialiException;
import org.openspcoop2.pdd.core.credenziali.engine.ModalitaAutenticazioneGestoreCredenziali;
import org.openspcoop2.pdd.core.credenziali.engine.TipoAutenticazioneGestoreCredenziali;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.certificate.KeystoreType;

public class GestoreCredenzialiConfigurazione {
    private static Map<String, GestoreCredenzialiConfigurazione> configurazione = new HashMap<String, GestoreCredenzialiConfigurazione>();
    private static Semaphore semaphore = new Semaphore("GestoreCredenzialiConfigurazione");
    private boolean enabled;
    private String nome;
    private String realm;
    private String authType;
    private TipoAutenticazioneGestoreCredenziali tipoAutenticazioneCanale = null;
    private String autenticazioneCanaleBasicUsername = null;
    private String autenticazioneCanaleBasicPassword = null;
    private String autenticazioneCanaleSslSubject = null;
    private String autenticazioneCanalePrincipal = null;
    private ModalitaAutenticazioneGestoreCredenziali modalitaAutenticazioneCanale = null;
    private String modalitaAutenticazioneCanaleAtLeastOneErrorDescription = null;
    private String headerBasicUsername;
    private String headerBasicPassword;
    private String headerSslSubject;
    private String headerSslIssuer;
    private String headerSslCertificate;
    private boolean headerSslCertificateUrlDecode;
    private boolean headerSslCertificateBase64Decode;
    private boolean headerSslCertificateHexDecode;
    private boolean headerSslCertificateUrlDecodeOrBase64Decode;
    private boolean headerSslCertificateUrlDecodeOrBase64DecodeOrHexDecode;
    private boolean headerSslCertificateEnrichBeginEnd;
    private boolean headerSslCertificateReplaceCharacters;
    private String headerSslCertificateReplaceCharactersSource;
    private String headerSslCertificateReplaceCharactersDest;
    private String headerSslCertificateTrustStorePath;
    private String headerSslCertificateTrustStorePassword;
    private String headerSslCertificateTrustStoreType;
    private boolean headerSslCertificateTrustStoreCheckValid = true;
    private String headerSslCertificateCrlX509;
    private String headerSslCertificateOcspPolicy;
    private String headerSslCertificateNoneOption;
    private boolean headerSslCertificateIgnoreEmpty = true;
    private String headerPrincipal;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initConfigurazione(boolean fruizione, IDSoggetto idSoggetto) throws GestoreCredenzialiException {
        String key = GestoreCredenzialiConfigurazione.getKey(fruizione, idSoggetto);
        if (!configurazione.containsKey(key)) {
            SemaphoreLock lock = null;
            try {
                lock = semaphore.acquire("initConfig");
            }
            catch (Exception e) {
                throw new GestoreCredenzialiException(e.getMessage(), e);
            }
            try {
                GestoreCredenzialiConfigurazione instance = new GestoreCredenzialiConfigurazione(fruizione, idSoggetto);
                configurazione.put(key, instance);
            }
            finally {
                semaphore.release(lock, "initConfig");
            }
        }
    }

    public static GestoreCredenzialiConfigurazione getConfigurazione(boolean fruizione, IDSoggetto idSoggetto) throws GestoreCredenzialiException {
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        boolean abilitatoGlobalmente = false;
        abilitatoGlobalmente = fruizione ? op2Properties.isGestoreCredenzialiPortaDelegataEnabled() : op2Properties.isGestoreCredenzialiPortaApplicativaEnabled();
        if (!abilitatoGlobalmente) {
            return null;
        }
        String key = GestoreCredenzialiConfigurazione.getKey(fruizione, idSoggetto);
        if (!configurazione.containsKey(key)) {
            GestoreCredenzialiConfigurazione.initConfigurazione(fruizione, idSoggetto);
        }
        return configurazione.get(key);
    }

    private static String getKey(boolean fruizione, IDSoggetto idSoggetto) {
        return (fruizione ? "fruizione_" : "erogazione_") + (idSoggetto != null ? idSoggetto.toString() : "-undefined-");
    }

    private String getProprietaPrefix(String prefix) {
        return "Propriet\u00e0 '" + prefix;
    }

    private String getMessaggioModalitaNonConfigurataCompletamente() {
        return "modalita non configurata completamente; la modalit\u00e0 '" + this.modalitaAutenticazioneCanale + "' ";
    }

    public GestoreCredenzialiConfigurazione(boolean fruizione, IDSoggetto idSoggetto) throws GestoreCredenzialiException {
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        Properties p = null;
        String prefix = null;
        if (fruizione) {
            p = op2Properties.getGestoreCredenzialiPortaDelegataProperties();
            prefix = "org.openspcoop2.pdd.services.pd.gestoreCredenziali.";
        } else {
            p = op2Properties.getGestoreCredenzialiPortaApplicativaProperties();
            prefix = "org.openspcoop2.pdd.services.pa.gestoreCredenziali.";
        }
        String protocollo = null;
        try {
            if (idSoggetto != null) {
                protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(idSoggetto.getTipo());
            }
        }
        catch (Exception e) {
            throw new GestoreCredenzialiException(e.getMessage(), e);
        }
        String enabledS = this.getProperty(p, "enabled", protocollo, idSoggetto);
        if (enabledS != null) {
            enabledS = enabledS.trim();
            this.enabled = Boolean.parseBoolean(enabledS);
        } else {
            this.enabled = false;
        }
        if (!this.enabled) {
            return;
        }
        this.nome = this.getProperty(p, "nome", protocollo, idSoggetto);
        if (this.nome == null) {
            throw new GestoreCredenzialiException(this.getProprietaPrefix(prefix) + "nome non impostata");
        }
        this.realm = this.getProperty(p, "wwwAuthenticate.realm", protocollo, idSoggetto);
        this.authType = this.getProperty(p, "wwwAuthenticate.authType", protocollo, idSoggetto);
        if (this.realm != null && this.authType == null || this.realm == null && this.authType != null) {
            throw new GestoreCredenzialiException("L'abilitazione del wwwAuthenticate sul gestore delle credenziali richiede che sia definito sia un nome da associare al realm (trovato " + prefix + "wwwAuthenticate.realm=" + this.realm + ") che il tipo di autenticazione (trovato " + prefix + "wwwAuthenticate.authType=" + this.authType + ")");
        }
        String authCanaleS = this.getProperty(p, "autenticazioneCanale", protocollo, idSoggetto);
        if (authCanaleS == null) {
            throw new GestoreCredenzialiException(this.getProprietaPrefix(prefix) + "autenticazioneCanale non impostata");
        }
        this.tipoAutenticazioneCanale = TipoAutenticazioneGestoreCredenziali.toEnumConstant(authCanaleS);
        if (this.tipoAutenticazioneCanale == null) {
            throw new GestoreCredenzialiException(this.getProprietaPrefix(prefix) + "autenticazioneCanale impostata non correttamente, valore indicato (" + authCanaleS + ") non gestito");
        }
        switch (this.tipoAutenticazioneCanale) {
            case NONE: {
                break;
            }
            case BASIC: {
                this.autenticazioneCanaleBasicUsername = this.getProperty(p, "autenticazioneCanale.basic.username", protocollo, idSoggetto);
                if (this.autenticazioneCanaleBasicUsername == null) {
                    throw new GestoreCredenzialiException(this.getProprietaPrefix(prefix) + "autenticazioneCanale.basic.username non impostata");
                }
                this.autenticazioneCanaleBasicPassword = this.getProperty(p, "autenticazioneCanale.basic.password", protocollo, idSoggetto);
                if (this.autenticazioneCanaleBasicPassword != null) break;
                throw new GestoreCredenzialiException(this.getProprietaPrefix(prefix) + "autenticazioneCanale.basic.password non impostata");
            }
            case SSL: {
                this.autenticazioneCanaleSslSubject = this.getProperty(p, "autenticazioneCanale.ssl.subject", protocollo, idSoggetto);
                if (this.autenticazioneCanaleSslSubject != null) break;
                throw new GestoreCredenzialiException(this.getProprietaPrefix(prefix) + "autenticazioneCanale.ssl.subject non impostata");
            }
            case PRINCIPAL: {
                this.autenticazioneCanalePrincipal = this.getProperty(p, "autenticazioneCanale.principal", protocollo, idSoggetto);
                if (this.autenticazioneCanalePrincipal != null) break;
                throw new GestoreCredenzialiException(this.getProprietaPrefix(prefix) + "autenticazioneCanale.principal non impostata");
            }
        }
        this.headerBasicUsername = this.getProperty(p, "header.basic.username", protocollo, idSoggetto);
        this.headerBasicPassword = this.getProperty(p, "header.basic.password", protocollo, idSoggetto);
        this.headerSslSubject = this.getProperty(p, "header.ssl.subject", protocollo, idSoggetto);
        this.headerSslIssuer = this.getProperty(p, "header.ssl.issuer", protocollo, idSoggetto);
        this.headerSslCertificate = this.getProperty(p, "header.ssl.certificate", protocollo, idSoggetto);
        if (this.headerSslCertificate != null) {
            String v;
            String t;
            String pValue = this.getProperty(p, "header.ssl.certificate.url_decode", protocollo, idSoggetto);
            if (pValue != null) {
                pValue = pValue.trim();
                this.headerSslCertificateUrlDecode = Boolean.parseBoolean(pValue);
            } else {
                this.headerSslCertificateUrlDecode = true;
            }
            pValue = this.getProperty(p, "header.ssl.certificate.base64_decode", protocollo, idSoggetto);
            if (pValue != null) {
                pValue = pValue.trim();
                this.headerSslCertificateBase64Decode = Boolean.parseBoolean(pValue);
            } else {
                this.headerSslCertificateBase64Decode = true;
            }
            pValue = this.getProperty(p, "header.ssl.certificate.hex_decode", protocollo, idSoggetto);
            if (pValue != null) {
                pValue = pValue.trim();
                this.headerSslCertificateHexDecode = Boolean.parseBoolean(pValue);
            } else {
                this.headerSslCertificateHexDecode = false;
            }
            pValue = this.getProperty(p, "header.ssl.certificate.url_decode_or_base64_decode", protocollo, idSoggetto);
            if (pValue != null) {
                pValue = pValue.trim();
                this.headerSslCertificateUrlDecodeOrBase64Decode = Boolean.parseBoolean(pValue);
            } else {
                this.headerSslCertificateUrlDecodeOrBase64Decode = false;
            }
            pValue = this.getProperty(p, "header.ssl.certificate.url_decode_or_base64_decode_or_hex_decode", protocollo, idSoggetto);
            if (pValue != null) {
                pValue = pValue.trim();
                this.headerSslCertificateUrlDecodeOrBase64DecodeOrHexDecode = Boolean.parseBoolean(pValue);
            } else {
                this.headerSslCertificateUrlDecodeOrBase64DecodeOrHexDecode = true;
            }
            pValue = this.getProperty(p, "header.ssl.certificate.enrich_BEGIN_END", protocollo, idSoggetto);
            if (pValue != null) {
                pValue = pValue.trim();
                this.headerSslCertificateEnrichBeginEnd = Boolean.parseBoolean(pValue);
            } else {
                this.headerSslCertificateEnrichBeginEnd = false;
            }
            pValue = this.getProperty(p, "header.ssl.certificate.replaceCharacters", protocollo, idSoggetto);
            if (pValue != null) {
                pValue = pValue.trim();
                this.headerSslCertificateReplaceCharacters = Boolean.parseBoolean(pValue);
            } else {
                this.headerSslCertificateReplaceCharacters = false;
            }
            if (this.headerSslCertificateReplaceCharacters) {
                this.headerSslCertificateReplaceCharactersSource = this.getProperty(p, "header.ssl.certificate.replaceCharacters.source", protocollo, idSoggetto);
                if (this.headerSslCertificateReplaceCharactersSource != null) {
                    if (StringUtils.isNotEmpty((String)this.headerSslCertificateReplaceCharactersSource)) {
                        if ("\\t".equals(this.headerSslCertificateReplaceCharactersSource)) {
                            this.headerSslCertificateReplaceCharactersSource = "\t";
                        } else if ("\\r".equals(this.headerSslCertificateReplaceCharactersSource)) {
                            this.headerSslCertificateReplaceCharactersSource = "\r";
                        } else if ("\\n".equals(this.headerSslCertificateReplaceCharactersSource)) {
                            this.headerSslCertificateReplaceCharactersSource = "\n";
                        } else if ("\\r\\n".equals(this.headerSslCertificateReplaceCharactersSource)) {
                            this.headerSslCertificateReplaceCharactersSource = "\r\n";
                        } else if ("\\s".equals(this.headerSslCertificateReplaceCharactersSource)) {
                            this.headerSslCertificateReplaceCharactersSource = " ";
                        }
                    } else {
                        this.headerSslCertificateReplaceCharactersSource = null;
                    }
                }
                this.headerSslCertificateReplaceCharactersDest = this.getProperty(p, "header.ssl.certificate.replaceCharacters.dest", protocollo, idSoggetto);
                if (this.headerSslCertificateReplaceCharactersDest != null) {
                    if (StringUtils.isNotEmpty((String)this.headerSslCertificateReplaceCharactersDest)) {
                        if ("\\t".equals(this.headerSslCertificateReplaceCharactersDest)) {
                            this.headerSslCertificateReplaceCharactersDest = "\t";
                        }
                        if ("\\r".equals(this.headerSslCertificateReplaceCharactersDest)) {
                            this.headerSslCertificateReplaceCharactersDest = "\r";
                        } else if ("\\n".equals(this.headerSslCertificateReplaceCharactersDest)) {
                            this.headerSslCertificateReplaceCharactersDest = "\n";
                        } else if ("\\r\\n".equals(this.headerSslCertificateReplaceCharactersDest)) {
                            this.headerSslCertificateReplaceCharactersDest = "\r\n";
                        } else if ("\\s".equals(this.headerSslCertificateReplaceCharactersDest)) {
                            this.headerSslCertificateReplaceCharactersDest = " ";
                        }
                    } else {
                        this.headerSslCertificateReplaceCharactersDest = null;
                    }
                }
            }
            if ((t = this.getProperty(p, "header.ssl.certificate.truststore.path", protocollo, idSoggetto)) != null && StringUtils.isNotEmpty((String)t)) {
                File fTrustStore = new File(t);
                if (!fTrustStore.exists()) {
                    throw new GestoreCredenzialiException("Il truststore dei certificati ssl indicato [" + fTrustStore.getAbsolutePath() + "] non esiste");
                }
                if (!fTrustStore.canRead()) {
                    throw new GestoreCredenzialiException("Il truststore dei certificati ssl indicato [" + fTrustStore.getAbsolutePath() + "] non \u00e8 accessibile in lettura");
                }
                String password = this.getProperty(p, "header.ssl.certificate.truststore.password", protocollo, idSoggetto);
                if (password == null) {
                    throw new GestoreCredenzialiException("Non \u00e8 stata indicata una password per il truststore dei certificati ssl indicato [" + fTrustStore.getAbsolutePath() + "]");
                }
                this.headerSslCertificateTrustStorePath = fTrustStore.getAbsolutePath();
                this.headerSslCertificateTrustStorePassword = password;
                String type = this.getProperty(p, "header.ssl.certificate.truststore.type", protocollo, idSoggetto);
                this.headerSslCertificateTrustStoreType = type == null ? KeystoreType.JKS.getNome() : type;
            }
            if (this.headerSslCertificateTrustStorePath != null) {
                String ocspPolicy;
                String crls;
                v = this.getProperty(p, "header.ssl.certificate.truststore.validityCheck", protocollo, idSoggetto);
                if (v != null && StringUtils.isNotEmpty((String)v)) {
                    try {
                        this.headerSslCertificateTrustStoreCheckValid = Boolean.valueOf(v);
                    }
                    catch (Exception e) {
                        throw new GestoreCredenzialiException("Errore durante la lettura della propriet\u00e0 'header.ssl.certificate.truststore.validityCheck' (valore: " + v + "): " + e.getMessage(), e);
                    }
                }
                if ((crls = this.getProperty(p, "header.ssl.certificate.truststore.crls", protocollo, idSoggetto)) != null && StringUtils.isNotEmpty((String)crls)) {
                    this.headerSslCertificateCrlX509 = crls;
                }
                if ((ocspPolicy = this.getProperty(p, "header.ssl.certificate.truststore.ocspPolicy", protocollo, idSoggetto)) != null && StringUtils.isNotEmpty((String)ocspPolicy)) {
                    this.headerSslCertificateOcspPolicy = ocspPolicy;
                }
            }
            if ((pValue = this.getProperty(p, "header.ssl.certificate.none", protocollo, idSoggetto)) != null) {
                this.headerSslCertificateNoneOption = pValue = pValue.trim();
            }
            if ((v = this.getProperty(p, "header.ssl.certificate.ignoreEmpty", protocollo, idSoggetto)) != null && StringUtils.isNotEmpty((String)v)) {
                try {
                    this.headerSslCertificateIgnoreEmpty = Boolean.valueOf(v);
                }
                catch (Exception e) {
                    throw new GestoreCredenzialiException("Errore durante la lettura della propriet\u00e0 'header.ssl.certificate.ignoreEmpty' (valore: " + v + "): " + e.getMessage(), e);
                }
            }
        }
        this.headerPrincipal = this.getProperty(p, "header.principal", protocollo, idSoggetto);
        if (this.headerBasicUsername == null && this.headerSslSubject == null && this.headerSslCertificate == null && this.headerPrincipal == null) {
            throw new GestoreCredenzialiException("L'abilitazione del gestore delle credenziali (" + prefix + "*) richiede almeno la definizione di un header su cui vengono fornite le credenziali");
        }
        if (this.headerBasicUsername != null && this.headerBasicPassword == null) {
            throw new GestoreCredenzialiException("L'abilitazione del gestore delle credenziali (" + prefix + "*) richiede la definizione di un header su cui viene indicata la password, se viene definito un header per l'username");
        }
        String modalitaCanaleS = this.getProperty(p, "modalita", protocollo, idSoggetto);
        if (modalitaCanaleS == null) {
            throw new GestoreCredenzialiException(this.getProprietaPrefix(prefix) + "modalita non impostata");
        }
        this.modalitaAutenticazioneCanale = ModalitaAutenticazioneGestoreCredenziali.toEnumConstant(modalitaCanaleS);
        if (this.modalitaAutenticazioneCanale == null) {
            throw new GestoreCredenzialiException(this.getProprietaPrefix(prefix) + "modalita impostata non correttamente, valore indicato (" + modalitaCanaleS + ") non gestito");
        }
        switch (this.modalitaAutenticazioneCanale) {
            case NONE: {
                break;
            }
            case AT_LEAST_ONE: {
                this.modalitaAutenticazioneCanaleAtLeastOneErrorDescription = this.getProperty(p, "modalita.atLeastOne.error_description.notFound", protocollo, idSoggetto);
                break;
            }
            case BASIC: {
                if (this.headerBasicUsername != null && this.headerBasicPassword != null) break;
                throw new GestoreCredenzialiException(this.getProprietaPrefix(prefix) + this.getMessaggioModalitaNonConfigurataCompletamente() + "richiede la definizione degli header http dove far veicolare le credenziali basic");
            }
            case SSL: {
                if (this.headerSslSubject != null || this.headerSslCertificate != null) break;
                throw new GestoreCredenzialiException(this.getProprietaPrefix(prefix) + this.getMessaggioModalitaNonConfigurataCompletamente() + "richiede la definizione di almeno un header http dove far veicolare le credenziali ssl");
            }
            case PRINCIPAL: {
                if (this.headerPrincipal != null) break;
                throw new GestoreCredenzialiException(this.getProprietaPrefix(prefix) + this.getMessaggioModalitaNonConfigurataCompletamente() + "richiede la definizione dell'header http dove far veicolare le credenziali principal");
            }
        }
    }

    private String getProperty(Properties p, String key, String protocollo, IDSoggetto idSoggetto) {
        String key1 = null;
        String key2 = null;
        String key3 = null;
        String key4 = null;
        String key5 = null;
        String keyOriginale = key;
        if (protocollo != null && idSoggetto != null) {
            key1 = protocollo + "-" + idSoggetto.getTipo() + "-" + idSoggetto.getNome() + "." + key;
            key3 = protocollo + "-" + idSoggetto.getNome() + "." + key;
        }
        if (idSoggetto != null) {
            key2 = idSoggetto.getTipo() + "-" + idSoggetto.getNome() + "." + key;
            key4 = idSoggetto.getNome() + "." + key;
        }
        if (protocollo != null) {
            key5 = protocollo + "." + key;
        }
        String value = null;
        if (key1 != null && (value = p.getProperty(key1)) != null) {
            if (!StringUtils.isEmpty((String)value.trim())) {
                return value.trim();
            }
            return null;
        }
        if (key2 != null && (value = p.getProperty(key2)) != null) {
            if (!StringUtils.isEmpty((String)value.trim())) {
                return value.trim();
            }
            return null;
        }
        if (key3 != null && (value = p.getProperty(key3)) != null) {
            if (!StringUtils.isEmpty((String)value.trim())) {
                return value.trim();
            }
            return null;
        }
        if (key4 != null && (value = p.getProperty(key4)) != null) {
            if (!StringUtils.isEmpty((String)value.trim())) {
                return value.trim();
            }
            return null;
        }
        if (key5 != null && (value = p.getProperty(key5)) != null) {
            if (!StringUtils.isEmpty((String)value.trim())) {
                return value.trim();
            }
            return null;
        }
        value = p.getProperty(keyOriginale);
        if (value != null && !StringUtils.isEmpty((String)value.trim())) {
            return value.trim();
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getNome() {
        return this.nome;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getAuthType() {
        return this.authType;
    }

    public TipoAutenticazioneGestoreCredenziali getTipoAutenticazioneCanale() {
        return this.tipoAutenticazioneCanale;
    }

    public String getAutenticazioneCanaleBasicUsername() {
        return this.autenticazioneCanaleBasicUsername;
    }

    public String getAutenticazioneCanaleBasicPassword() {
        return this.autenticazioneCanaleBasicPassword;
    }

    public String getAutenticazioneCanaleSslSubject() {
        return this.autenticazioneCanaleSslSubject;
    }

    public String getAutenticazioneCanalePrincipal() {
        return this.autenticazioneCanalePrincipal;
    }

    public ModalitaAutenticazioneGestoreCredenziali getModalitaAutenticazioneCanale() {
        return this.modalitaAutenticazioneCanale;
    }

    public String getModalitaAutenticazioneCanaleAtLeastOneErrorDescription() {
        return this.modalitaAutenticazioneCanaleAtLeastOneErrorDescription;
    }

    public String getHeaderBasicUsername() {
        return this.headerBasicUsername;
    }

    public String getHeaderBasicPassword() {
        return this.headerBasicPassword;
    }

    public String getHeaderSslSubject() {
        return this.headerSslSubject;
    }

    public String getHeaderSslIssuer() {
        return this.headerSslIssuer;
    }

    public String getHeaderSslCertificate() {
        return this.headerSslCertificate;
    }

    public boolean isHeaderSslCertificateUrlDecode() {
        return this.headerSslCertificateUrlDecode;
    }

    public boolean isHeaderSslCertificateBase64Decode() {
        return this.headerSslCertificateBase64Decode;
    }

    public boolean isHeaderSslCertificateHexDecode() {
        return this.headerSslCertificateHexDecode;
    }

    public boolean isHeaderSslCertificateUrlDecodeOrBase64Decode() {
        return this.headerSslCertificateUrlDecodeOrBase64Decode;
    }

    public boolean isHeaderSslCertificateUrlDecodeOrBase64DecodeOrHexDecode() {
        return this.headerSslCertificateUrlDecodeOrBase64DecodeOrHexDecode;
    }

    public boolean isHeaderSslCertificateEnrichBeginEnd() {
        return this.headerSslCertificateEnrichBeginEnd;
    }

    public boolean isHeaderSslCertificateReplaceCharacters() {
        return this.headerSslCertificateReplaceCharacters;
    }

    public String getHeaderSslCertificateReplaceCharactersSource() {
        return this.headerSslCertificateReplaceCharactersSource;
    }

    public String getHeaderSslCertificateReplaceCharactersDest() {
        return this.headerSslCertificateReplaceCharactersDest;
    }

    public String getHeaderSslCertificateTrustStorePath() {
        return this.headerSslCertificateTrustStorePath;
    }

    public String getHeaderSslCertificateTrustStoreType() {
        return this.headerSslCertificateTrustStoreType;
    }

    public String getHeaderSslCertificateTrustStorePassword() {
        return this.headerSslCertificateTrustStorePassword;
    }

    public boolean isHeaderSslCertificateTrustStoreCheckValid() {
        return this.headerSslCertificateTrustStoreCheckValid;
    }

    public String getHeaderSslCertificateCrlX509() {
        return this.headerSslCertificateCrlX509;
    }

    public String getHeaderSslCertificateOcspPolicy() {
        return this.headerSslCertificateOcspPolicy;
    }

    public String getHeaderSslCertificateNoneOption() {
        return this.headerSslCertificateNoneOption;
    }

    public boolean isHeaderSslCertificateIgnoreEmpty() {
        return this.headerSslCertificateIgnoreEmpty;
    }

    public String getHeaderPrincipal() {
        return this.headerPrincipal;
    }
}

