/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.credenziali.engine;

import java.security.cert.CertStore;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.constants.TipoAutenticazionePrincipal;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.utils.WWWAuthenticateErrorCode;
import org.openspcoop2.message.utils.WWWAuthenticateGenerator;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.autenticazione.WWWAuthenticateConfig;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop2.pdd.core.credenziali.Credenziali;
import org.openspcoop2.pdd.core.credenziali.GestoreCredenzialiConfigurationException;
import org.openspcoop2.pdd.core.credenziali.GestoreCredenzialiException;
import org.openspcoop2.pdd.core.credenziali.engine.GestoreCredenzialiConfigurazione;
import org.openspcoop2.pdd.core.credenziali.engine.ModalitaAutenticazioneGestoreCredenziali;
import org.openspcoop2.pdd.core.credenziali.engine.TipoAutenticazioneGestoreCredenziali;
import org.openspcoop2.pdd.core.keystore.GestoreKeystoreCaching;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.engine.SecurityTokenUtilities;
import org.openspcoop2.protocol.sdk.ChannelSecurityToken;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.SecurityToken;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.keystore.cache.GestoreOCSPResource;
import org.openspcoop2.security.keystore.cache.GestoreOCSPValidator;
import org.openspcoop2.utils.LoggerBuffer;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.CertificateDecodeConfig;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.openspcoop2.utils.certificate.ocsp.IOCSPResourceReader;
import org.openspcoop2.utils.transport.TransportUtils;
import org.slf4j.Logger;

public class GestoreCredenzialiEngine {
    private static final String KEYWORD_GATEWAY_CREDENZIALI = "@@GatewayCredenziali@@";
    private String identita = null;
    private boolean portaApplicativa = false;
    private Context context;
    private RequestInfo requestInfo;
    private static final String NESSUN_TIPO_CREDENZIALI_TRASPORTO = "nessun tipo di credenziali (basic/ssl/principal) riscontrate nel trasporto";
    private static final String CREDENZIALI_PRESENTI_TRASPORTO = "credenziali presenti nel trasporto ";

    public static String getDBValuePrefixGatewayCredenziali(String identitaGateway, String credenzialiFornite) {
        return KEYWORD_GATEWAY_CREDENZIALI + identitaGateway + "@@" + credenzialiFornite;
    }

    public static boolean containsPrefixGatewayCredenziali(String value) {
        return value.startsWith(KEYWORD_GATEWAY_CREDENZIALI);
    }

    public static String erasePrefixGatewayCredenziali(String value) {
        if (value.startsWith(KEYWORD_GATEWAY_CREDENZIALI)) {
            String s = value.substring(KEYWORD_GATEWAY_CREDENZIALI.length());
            if (s.contains("@@")) {
                s = s.substring(s.indexOf("@@") + 2);
            }
            return s;
        }
        return value;
    }

    public static String readIdentitaGatewayCredenziali(String value) {
        if (value.startsWith(KEYWORD_GATEWAY_CREDENZIALI)) {
            String s = value.substring(KEYWORD_GATEWAY_CREDENZIALI.length());
            if (s.contains("@@")) {
                return s.substring(0, s.indexOf("@@"));
            }
            return null;
        }
        return null;
    }

    public GestoreCredenzialiEngine(boolean portaApplicativa, Context context) {
        this.portaApplicativa = portaApplicativa;
        this.context = context;
        if (this.context != null && this.context.containsKey(Costanti.REQUEST_INFO)) {
            this.requestInfo = (RequestInfo)this.context.get(Costanti.REQUEST_INFO);
        }
    }

    private String getPrefixMessaggioAutenticazioneFallita(String auth) {
        return "Autenticazione " + auth + " del Gestore delle Credenziali '" + this.identita + "' fallita, ";
    }

    private String getConfigurazioneNonValidaPrefix(ModalitaAutenticazioneGestoreCredenziali modalita) {
        return "Configurazione del Gestore delle Credenziali non valida, con la modalit\u00e0 '" + modalita.getValore() + "' ";
    }

    private String getConfigurazioneNonValidaHeaderNonDefiniti(ModalitaAutenticazioneGestoreCredenziali modalita, String auth) {
        return this.getConfigurazioneNonValidaPrefix(modalita) + "devono essere definiti gli header http su cui veicolare le credenziali " + auth;
    }

    private String getConfigurazioneNonValidaHeaderNonDefinito(ModalitaAutenticazioneGestoreCredenziali modalita, String auth) {
        return this.getConfigurazioneNonValidaPrefix(modalita) + "deve essere definito un header http su cui veicolare le credenziali " + auth;
    }

    private String getConfigurazioneNonValidaAlmenoHeaderDefinito(ModalitaAutenticazioneGestoreCredenziali modalita, String auth) {
        return this.getConfigurazioneNonValidaPrefix(modalita) + "deve essere definito almeno un header http su cui veicolare le credenziali " + auth;
    }

    private String getMessaggioHeaderHttpNonPresente(String headerName) {
        return "Header HTTP '" + headerName + "' non presente";
    }

    private String getSuffixNonValido(Exception e) {
        return " non valido: " + e.getMessage();
    }

    private String getMessaggioCertificatoPresenteHeaderNonValido(String headerName, Exception t) {
        return "Certificato presente nell'header '" + headerName + "' non valido: " + t.getMessage();
    }

    public Credenziali elaborazioneCredenziali(IDSoggetto idSoggetto, InfoConnettoreIngresso infoConnettoreIngresso, OpenSPCoop2Message messaggio) throws GestoreCredenzialiException, GestoreCredenzialiConfigurationException {
        boolean verificaIdentitaPrincipal;
        String authType;
        String realm;
        GestoreCredenzialiConfigurazione configurazione;
        Credenziali credenzialiTrasporto;
        Map headerTrasporto;
        block101: {
            boolean enabled;
            if (messaggio != null) {
                // empty if block
            }
            headerTrasporto = infoConnettoreIngresso.getUrlProtocolContext().getHeaders();
            credenzialiTrasporto = infoConnettoreIngresso.getCredenziali();
            configurazione = GestoreCredenzialiConfigurazione.getConfigurazione(!this.portaApplicativa, idSoggetto);
            boolean bl = enabled = configurazione != null && configurazione.isEnabled();
            if (!enabled) {
                return credenzialiTrasporto;
            }
            this.identita = configurazione.getNome();
            realm = configurazione.getRealm();
            authType = configurazione.getAuthType();
            TipoAutenticazioneGestoreCredenziali autenticazioneGateway = configurazione.getTipoAutenticazioneCanale();
            if (autenticazioneGateway == null) {
                throw new GestoreCredenzialiException("Tipo di autenticazione per il gestore delle credenziali non definito");
            }
            if (TipoAutenticazioneGestoreCredenziali.BASIC.equals(autenticazioneGateway)) {
                String usernameGateway = configurazione.getAutenticazioneCanaleBasicUsername();
                String passwordGateway = configurazione.getAutenticazioneCanaleBasicPassword();
                if (usernameGateway == null) {
                    throw new GestoreCredenzialiException("Richiesta autenticazione basic del gestore delle credenziali, ma username non definito");
                }
                if (passwordGateway == null) {
                    throw new GestoreCredenzialiException("Richiesta autenticazione basic del gestore delle credenziali, ma password non definito");
                }
                if (credenzialiTrasporto.getUsername() == null || credenzialiTrasporto.getPassword() == null) {
                    throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWProxyAuthBasic(authType, realm, true), this.getPrefixMessaggioAutenticazioneFallita(autenticazioneGateway.getValore()) + "nessun tipo di credenziali basic riscontrata nel trasporto");
                }
                if (!usernameGateway.equals(credenzialiTrasporto.getUsername()) || !passwordGateway.equals(credenzialiTrasporto.getPassword())) {
                    String credenzialiPresenti = credenzialiTrasporto.toString();
                    if (credenzialiPresenti == null || credenzialiPresenti.equals("")) {
                        throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_INVALID_CREDENTIALS, GestoreCredenzialiEngine.buildWWWProxyAuthBasic(authType, realm, false), this.getPrefixMessaggioAutenticazioneFallita(autenticazioneGateway.getValore()) + NESSUN_TIPO_CREDENZIALI_TRASPORTO);
                    }
                    throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_INVALID_CREDENTIALS, GestoreCredenzialiEngine.buildWWWProxyAuthBasic(authType, realm, false), this.getPrefixMessaggioAutenticazioneFallita(autenticazioneGateway.getValore()) + CREDENZIALI_PRESENTI_TRASPORTO + credenzialiPresenti);
                }
            } else {
                if (TipoAutenticazioneGestoreCredenziali.SSL.equals(autenticazioneGateway)) {
                    String subjectGateway = configurazione.getAutenticazioneCanaleSslSubject();
                    if (subjectGateway == null) {
                        throw new GestoreCredenzialiException("Richiesta autenticazione ssl del gestore delle credenziali, ma subject non definito");
                    }
                    try {
                        CertificateUtils.validaPrincipal((String)subjectGateway, (PrincipalType)PrincipalType.SUBJECT);
                    }
                    catch (Exception e) {
                        throw new GestoreCredenzialiException("Richiesta autenticazione ssl del gestore delle credenziali, ma subject fornito [" + subjectGateway + "] non valido: " + e.getMessage());
                    }
                    if (credenzialiTrasporto.getSubject() == null) {
                        throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWProxyAuthSSL(authType, realm, true), this.getPrefixMessaggioAutenticazioneFallita(autenticazioneGateway.getValore()) + "nessun tipo di credenziali ssl riscontrata nel trasporto");
                    }
                    try {
                        if (!CertificateUtils.sslVerify((String)subjectGateway, (String)credenzialiTrasporto.getSubject(), (PrincipalType)PrincipalType.SUBJECT, (Logger)OpenSPCoop2Logger.getLoggerOpenSPCoopCore())) {
                            String credenzialiPresenti = credenzialiTrasporto.toString();
                            if (credenzialiPresenti == null || credenzialiPresenti.equals("")) {
                                throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_INVALID_CREDENTIALS, GestoreCredenzialiEngine.buildWWWProxyAuthSSL(authType, realm, false), this.getPrefixMessaggioAutenticazioneFallita(autenticazioneGateway.getValore()) + NESSUN_TIPO_CREDENZIALI_TRASPORTO);
                            }
                            throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_INVALID_CREDENTIALS, GestoreCredenzialiEngine.buildWWWProxyAuthSSL(authType, realm, false), this.getPrefixMessaggioAutenticazioneFallita(autenticazioneGateway.getValore()) + CREDENZIALI_PRESENTI_TRASPORTO + credenzialiPresenti);
                        }
                        break block101;
                    }
                    catch (GestoreCredenzialiConfigurationException ge) {
                        throw ge;
                    }
                    catch (Exception e) {
                        throw new GestoreCredenzialiException("Richiesta autenticazione ssl del gateway gestore delle credenziali; errore durante la verifica: " + e.getMessage());
                    }
                }
                if (TipoAutenticazioneGestoreCredenziali.PRINCIPAL.equals(autenticazioneGateway)) {
                    String principalGateway = configurazione.getAutenticazioneCanalePrincipal();
                    if (principalGateway == null) {
                        throw new GestoreCredenzialiException("Richiesta autenticazione principal del gestore delle credenziali, ma principal non definito");
                    }
                    if (credenzialiTrasporto.getPrincipal() == null) {
                        throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWProxyAuthPrincipal(authType, realm, true), this.getPrefixMessaggioAutenticazioneFallita(autenticazioneGateway.getValore()) + "nessun tipo di credenziale principal riscontrata nel trasporto");
                    }
                    if (!principalGateway.equals(credenzialiTrasporto.getPrincipal())) {
                        String credenzialiPresenti = credenzialiTrasporto.toString();
                        if (credenzialiPresenti == null || credenzialiPresenti.equals("")) {
                            throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_INVALID_CREDENTIALS, GestoreCredenzialiEngine.buildWWWProxyAuthPrincipal(authType, realm, false), this.getPrefixMessaggioAutenticazioneFallita(autenticazioneGateway.getValore()) + NESSUN_TIPO_CREDENZIALI_TRASPORTO);
                        }
                        throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_INVALID_CREDENTIALS, GestoreCredenzialiEngine.buildWWWProxyAuthPrincipal(authType, realm, false), this.getPrefixMessaggioAutenticazioneFallita(autenticazioneGateway.getValore()) + CREDENZIALI_PRESENTI_TRASPORTO + credenzialiPresenti);
                    }
                }
            }
        }
        ModalitaAutenticazioneGestoreCredenziali modalita = configurazione.getModalitaAutenticazioneCanale();
        String modalitaAtLeastOneErrorDescription = null;
        if (ModalitaAutenticazioneGestoreCredenziali.AT_LEAST_ONE.equals(modalita)) {
            modalitaAtLeastOneErrorDescription = configurazione.getModalitaAutenticazioneCanaleAtLeastOneErrorDescription();
        }
        Credenziali c = new Credenziali();
        String headerNameBasicUsername = configurazione.getHeaderBasicUsername();
        String headerNameBasicPassword = configurazione.getHeaderBasicPassword();
        boolean verificaIdentitaBasic = headerNameBasicUsername != null && headerNameBasicPassword != null;
        String headerNameSSLSubject = configurazione.getHeaderSslSubject();
        String headerNameSSLIssuer = configurazione.getHeaderSslIssuer();
        String headerNameSSLCertificate = configurazione.getHeaderSslCertificate();
        KeyStore trustStoreCertificatiX509 = null;
        if (configurazione.getHeaderSslCertificateTrustStorePath() != null) {
            try {
                trustStoreCertificatiX509 = GestoreKeystoreCaching.getMerlinTruststore(this.requestInfo, configurazione.getHeaderSslCertificateTrustStorePath(), configurazione.getHeaderSslCertificateTrustStoreType(), configurazione.getHeaderSslCertificateTrustStorePassword()).getTrustStore();
            }
            catch (Exception e) {
                throw new GestoreCredenzialiException("Richiesta autenticazione ssl del gateway gestore delle credenziali; errore durante la lettura del truststore indicato (" + configurazione.getHeaderSslCertificateTrustStorePath() + "): " + e.getMessage());
            }
        }
        boolean trustStoreCertificatiX509CheckValid = configurazione.isHeaderSslCertificateTrustStoreCheckValid();
        CertStore trustStoreCertificatiX509Crls = null;
        GestoreOCSPValidator ocspValidator = null;
        if (trustStoreCertificatiX509 != null) {
            boolean crlByOcsp = false;
            if (configurazione.getHeaderSslCertificateOcspPolicy() != null) {
                GestoreOCSPValidator gOcspValidator;
                LoggerBuffer lb = new LoggerBuffer();
                lb.setLogDebug(OpenSPCoop2Logger.getLoggerOpenSPCoopCore());
                lb.setLogError(OpenSPCoop2Logger.getLoggerOpenSPCoopCore());
                GestoreOCSPResource ocspResourceReader = new GestoreOCSPResource(this.requestInfo);
                try {
                    ocspValidator = new GestoreOCSPValidator(this.requestInfo, lb, trustStoreCertificatiX509, configurazione.getHeaderSslCertificateCrlX509(), configurazione.getHeaderSslCertificateOcspPolicy(), (IOCSPResourceReader)ocspResourceReader);
                }
                catch (Exception e) {
                    throw new GestoreCredenzialiException("Richiesta autenticazione ssl del gateway gestore delle credenziali; errore durante l'inizializzazione del gestore della policy OCSP (" + configurazione.getHeaderSslCertificateOcspPolicy() + "): " + e.getMessage());
                }
                if (ocspValidator != null && (gOcspValidator = ocspValidator).getOcspConfig() != null) {
                    crlByOcsp = gOcspValidator.getOcspConfig().isCrl();
                }
            }
            if (configurazione.getHeaderSslCertificateCrlX509() != null && !crlByOcsp) {
                try {
                    trustStoreCertificatiX509Crls = GestoreKeystoreCaching.getCRLCertstore(this.requestInfo, configurazione.getHeaderSslCertificateCrlX509()).getCertStore();
                }
                catch (Exception e) {
                    throw new GestoreCredenzialiException("Richiesta autenticazione ssl del gateway gestore delle credenziali; errore durante la lettura delle CRLs (" + configurazione.getHeaderSslCertificateCrlX509() + "): " + e.getMessage());
                }
            }
        }
        boolean sslCertificateUrlDecode = false;
        boolean sslCertificateBase64Decode = false;
        boolean sslCertificateHexDecode = false;
        boolean sslCertificateUrlDecodeOrBase64Decode = false;
        boolean sslCertificateUrlDecodeOrBase64DecodeOrHexDecode = false;
        boolean sslCertificateEnrichBeginEnd = false;
        boolean sslCertificateReplace = false;
        String sslCertificateReplaceSource = null;
        String sslCertificateReplaceDest = null;
        String sslCertificateNoneOption = null;
        boolean sslCertificateIgnoreEmpty = false;
        if (headerNameSSLCertificate != null) {
            sslCertificateUrlDecode = configurazione.isHeaderSslCertificateUrlDecode();
            sslCertificateBase64Decode = configurazione.isHeaderSslCertificateBase64Decode();
            sslCertificateHexDecode = configurazione.isHeaderSslCertificateHexDecode();
            sslCertificateUrlDecodeOrBase64Decode = configurazione.isHeaderSslCertificateUrlDecodeOrBase64Decode();
            sslCertificateUrlDecodeOrBase64DecodeOrHexDecode = configurazione.isHeaderSslCertificateUrlDecodeOrBase64DecodeOrHexDecode();
            sslCertificateEnrichBeginEnd = configurazione.isHeaderSslCertificateEnrichBeginEnd();
            sslCertificateReplace = configurazione.isHeaderSslCertificateReplaceCharacters();
            if (sslCertificateReplace) {
                sslCertificateReplaceSource = configurazione.getHeaderSslCertificateReplaceCharactersSource();
                sslCertificateReplaceDest = configurazione.getHeaderSslCertificateReplaceCharactersDest();
            }
            sslCertificateNoneOption = configurazione.getHeaderSslCertificateNoneOption();
            sslCertificateIgnoreEmpty = configurazione.isHeaderSslCertificateIgnoreEmpty();
        }
        boolean verificaIdentitaSSL = headerNameSSLSubject != null || headerNameSSLCertificate != null;
        String headerNamePrincipal = configurazione.getHeaderPrincipal();
        boolean bl = verificaIdentitaPrincipal = headerNamePrincipal != null;
        if (!(verificaIdentitaBasic || verificaIdentitaSSL || verificaIdentitaPrincipal)) {
            return credenzialiTrasporto;
        }
        boolean existsHeaderBasicUsername = false;
        boolean existsHeaderBasicPassword = false;
        if (verificaIdentitaBasic) {
            existsHeaderBasicUsername = this.existsHeader(headerTrasporto, headerNameBasicUsername);
            existsHeaderBasicPassword = this.existsHeader(headerTrasporto, headerNameBasicPassword);
        }
        boolean existsHeaderSslSubject = false;
        boolean existsHeaderSslIssuer = false;
        boolean existsHeaderSslCertificate = false;
        if (verificaIdentitaSSL) {
            existsHeaderSslSubject = this.existsHeader(headerTrasporto, headerNameSSLSubject);
            existsHeaderSslIssuer = this.existsHeader(headerTrasporto, headerNameSSLIssuer);
            existsHeaderSslCertificate = this.existsHeader(headerTrasporto, headerNameSSLCertificate);
        }
        boolean existsHeaderPrincipal = false;
        if (verificaIdentitaPrincipal) {
            existsHeaderPrincipal = this.existsHeader(headerTrasporto, headerNamePrincipal);
        }
        switch (modalita) {
            case NONE: {
                if (existsHeaderBasicUsername && existsHeaderBasicPassword || existsHeaderSslSubject || existsHeaderSslCertificate || existsHeaderPrincipal) break;
                return credenzialiTrasporto;
            }
            case AT_LEAST_ONE: {
                if (existsHeaderBasicUsername && existsHeaderBasicPassword || existsHeaderSslSubject || existsHeaderSslCertificate || existsHeaderPrincipal) break;
                StringBuilder sb = new StringBuilder();
                if (headerNameBasicUsername != null) {
                    sb.append(headerNameBasicUsername);
                }
                if (headerNameSSLSubject != null) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(headerNameSSLSubject);
                }
                if (headerNameSSLCertificate != null) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(headerNameSSLCertificate);
                }
                if (headerNamePrincipal != null) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(headerNamePrincipal);
                }
                throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_FORWARDED_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWProxyAuthAtleastOne(authType, realm, modalitaAtLeastOneErrorDescription), "Non sono presenti Header HTTP che veicolano credenziali (header non rilevati: " + sb.toString() + ")");
            }
            case BASIC: {
                if (!verificaIdentitaBasic) {
                    throw new GestoreCredenzialiException(this.getConfigurazioneNonValidaHeaderNonDefiniti(modalita, modalita.getValore()));
                }
                if (!existsHeaderBasicUsername) {
                    throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_FORWARDED_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWAuthBasic(), this.getMessaggioHeaderHttpNonPresente(headerNameBasicUsername));
                }
                if (existsHeaderBasicPassword) break;
                throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_FORWARDED_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWAuthBasic(), this.getMessaggioHeaderHttpNonPresente(headerNameBasicPassword));
            }
            case SSL: {
                if (!verificaIdentitaSSL) {
                    throw new GestoreCredenzialiException(this.getConfigurazioneNonValidaAlmenoHeaderDefinito(modalita, modalita.getValore()));
                }
                if (headerNameSSLSubject != null && headerNameSSLCertificate != null) {
                    if (existsHeaderSslSubject || existsHeaderSslCertificate) break;
                    throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_FORWARDED_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWAuthSSL(), "Header HTTP '" + headerNameSSLSubject + "' o '" + headerNameSSLCertificate + "' non presente");
                }
                if (headerNameSSLSubject != null) {
                    if (existsHeaderSslSubject) break;
                    throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_FORWARDED_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWAuthSSL(), this.getMessaggioHeaderHttpNonPresente(headerNameSSLSubject));
                }
                if (existsHeaderSslCertificate) break;
                throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_FORWARDED_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWAuthSSL(), this.getMessaggioHeaderHttpNonPresente(headerNameSSLCertificate));
            }
            case PRINCIPAL: {
                if (!verificaIdentitaPrincipal) {
                    throw new GestoreCredenzialiException(this.getConfigurazioneNonValidaHeaderNonDefinito(modalita, modalita.getValore()));
                }
                if (existsHeaderPrincipal) break;
                throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_FORWARDED_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWAuthPrincipal(), this.getMessaggioHeaderHttpNonPresente(headerNamePrincipal));
            }
        }
        if (verificaIdentitaBasic && existsHeaderBasicUsername && existsHeaderBasicPassword) {
            String username = this.getProperty(headerTrasporto, headerNameBasicUsername);
            String password = this.getProperty(headerTrasporto, headerNameBasicPassword);
            if (username == null || "".equals(username)) {
                throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_FORWARDED_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWAuthBasic(), "Username value non fornito nell'header del trasporto " + headerNameBasicUsername);
            }
            if (password == null || "".equals(password)) {
                throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_FORWARDED_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWAuthBasic(), "Password value non fornito nell'header del trasporto " + headerNameBasicPassword);
            }
            c.setUsername(username);
            c.setPassword(password);
        }
        if (verificaIdentitaSSL) {
            if (existsHeaderSslSubject) {
                String subject = this.getProperty(headerTrasporto, headerNameSSLSubject);
                if (subject == null || "".equals(subject)) {
                    throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_FORWARDED_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWAuthSSL(), "Subject value non fornito nell'header del trasporto " + headerNameSSLSubject);
                }
                try {
                    CertificateUtils.formatPrincipal((String)subject, (PrincipalType)PrincipalType.SUBJECT);
                }
                catch (Exception e) {
                    throw new GestoreCredenzialiException("Subject value fornito nell'header del trasporto " + headerNameSSLSubject + this.getSuffixNonValido(e), e);
                }
                c.setSubject(subject);
            }
            if (existsHeaderSslIssuer) {
                String issuer = this.getProperty(headerTrasporto, headerNameSSLIssuer);
                if (issuer == null || "".equals(issuer)) {
                    throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_FORWARDED_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWAuthSSL(), "Issuer value non fornito nell'header del trasporto " + headerNameSSLIssuer);
                }
                try {
                    CertificateUtils.formatPrincipal((String)issuer, (PrincipalType)PrincipalType.ISSUER);
                }
                catch (Exception e) {
                    throw new GestoreCredenzialiException("Issuer value fornito nell'header del trasporto " + headerNameSSLIssuer + this.getSuffixNonValido(e), e);
                }
                c.setIssuer(issuer);
            }
            if (existsHeaderSslCertificate) {
                String certificate = this.getProperty(headerTrasporto, headerNameSSLCertificate);
                if (certificate != null && (sslCertificateNoneOption != null && sslCertificateNoneOption.equals(certificate) || StringUtils.isEmpty((String)certificate) && sslCertificateIgnoreEmpty)) {
                    c.setCertificate(null);
                    c.setSubject(null);
                    c.setIssuer(null);
                    SecurityToken securityToken = SecurityTokenUtilities.readSecurityToken((Context)this.context);
                    if (securityToken != null) {
                        securityToken.setChannel(null);
                    }
                } else {
                    if (certificate == null || "".equals(certificate)) {
                        throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_FORWARDED_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWAuthSSL(), "Certificate non fornito nell'header del trasporto " + headerNameSSLCertificate);
                    }
                    CertificateDecodeConfig config = new CertificateDecodeConfig();
                    config.setUrlDecode(sslCertificateUrlDecode);
                    config.setBase64Decode(sslCertificateBase64Decode);
                    config.setHexDecode(sslCertificateHexDecode);
                    config.setUrlDecodeOrBase64Decode(sslCertificateUrlDecodeOrBase64Decode);
                    config.setUrlDecodeOrBase64DecodeOrHexDecode(sslCertificateUrlDecodeOrBase64DecodeOrHexDecode);
                    config.setEnrichPEMBeginEnd(sslCertificateEnrichBeginEnd);
                    config.setReplace(sslCertificateReplace);
                    if (sslCertificateReplace) {
                        if (sslCertificateReplaceSource != null && !StringUtils.isEmpty((String)sslCertificateReplaceSource)) {
                            config.setReplaceSource(sslCertificateReplaceSource);
                        }
                        if (sslCertificateReplaceDest != null && !StringUtils.isEmpty((String)sslCertificateReplaceDest)) {
                            config.setReplaceDest(sslCertificateReplaceDest);
                        }
                    }
                    Certificate cer = null;
                    try {
                        cer = CertificateUtils.readCertificate((CertificateDecodeConfig)config, (String)certificate);
                        c.setCertificate(cer);
                        String subject = c.getCertificate().getCertificate().getSubject().toString();
                        String issuer = c.getCertificate().getCertificate().getIssuer().toString();
                        c.setSubject(subject);
                        c.setIssuer(issuer);
                    }
                    catch (Exception e) {
                        throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_FORWARDED_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWAuthSSL(), "Certificate fornito nell'header del trasporto " + headerNameSSLCertificate + this.getSuffixNonValido(e), e);
                    }
                    if (cer != null && trustStoreCertificatiX509 != null) {
                        if (!cer.getCertificate().isVerified(trustStoreCertificatiX509, true)) {
                            throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_FORWARDED_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWAuthSSL(), "Certificato presente nell'header '" + headerNameSSLCertificate + "' non \u00e8 verificabile rispetto alle CA conosciute");
                        }
                        if (trustStoreCertificatiX509Crls != null) {
                            try {
                                cer.getCertificate().checkValid(trustStoreCertificatiX509Crls, trustStoreCertificatiX509);
                            }
                            catch (Exception t) {
                                throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_FORWARDED_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWAuthSSL(), this.getMessaggioCertificatoPresenteHeaderNonValido(headerNameSSLCertificate, t));
                            }
                        }
                        if (trustStoreCertificatiX509CheckValid) {
                            try {
                                cer.getCertificate().checkValid();
                            }
                            catch (Exception t) {
                                throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_FORWARDED_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWAuthSSL(), this.getMessaggioCertificatoPresenteHeaderNonValido(headerNameSSLCertificate, t));
                            }
                        }
                        if (ocspValidator != null) {
                            try {
                                ocspValidator.valid(cer.getCertificate().getCertificate());
                            }
                            catch (Exception t) {
                                throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_FORWARDED_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWAuthSSL(), this.getMessaggioCertificatoPresenteHeaderNonValido(headerNameSSLCertificate, t));
                            }
                        }
                    }
                    try {
                        if (cer != null && this.context != null) {
                            SecurityToken securityToken = SecurityTokenUtilities.newSecurityToken((Context)this.context);
                            ChannelSecurityToken channelSecurityToken = new ChannelSecurityToken();
                            channelSecurityToken.setCertificate(cer.getCertificate());
                            securityToken.setChannel(channelSecurityToken);
                        }
                    }
                    catch (Exception e) {
                        throw new GestoreCredenzialiException("Costruzione SecurityToken non riuscita: " + e.getMessage(), e);
                    }
                }
            }
        }
        if (verificaIdentitaPrincipal && existsHeaderPrincipal) {
            String principal = this.getProperty(headerTrasporto, headerNamePrincipal);
            if (principal == null || "".equals(principal)) {
                throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_FORWARDED_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWAuthPrincipal(), "Principal value non fornito nell'header del trasporto " + headerNamePrincipal);
            }
            c.setPrincipal(principal);
        }
        return c;
    }

    public String getIdentitaGestoreCredenziali() {
        return this.identita;
    }

    private boolean existsHeader(Map<String, List<String>> properties, String name) {
        if (properties != null) {
            return TransportUtils.containsKey(properties, (String)name);
        }
        return false;
    }

    private String getProperty(Map<String, List<String>> properties, String name) {
        if (properties != null) {
            return TransportUtils.getFirstValue(properties, (String)name);
        }
        return null;
    }

    public static String buildWWWProxyAuthBasic(String authType, String realm, boolean missing) {
        if (realm == null || "".equals(realm) || authType == null || "".equals(authType)) {
            return null;
        }
        WWWAuthenticateConfig configGW = OpenSPCoop2Properties.getInstance().getRealmAutenticazioneBasicWWWAuthenticateConfig();
        WWWAuthenticateConfig proxy = configGW != null ? (WWWAuthenticateConfig)configGW.clone() : new WWWAuthenticateConfig();
        proxy.setRealm(realm);
        proxy.setAuthType(authType);
        return missing ? proxy.buildWWWAuthenticateHeaderValue_notFound() : proxy.buildWWWAuthenticateHeaderValue_invalid();
    }

    public static String buildWWWProxyAuthSSL(String authType, String realm, boolean missing) {
        if (realm == null || "".equals(realm) || authType == null || "".equals(authType)) {
            return null;
        }
        WWWAuthenticateConfig configGW = OpenSPCoop2Properties.getInstance().getRealmAutenticazioneHttpsWWWAuthenticateConfig();
        WWWAuthenticateConfig proxy = configGW != null ? (WWWAuthenticateConfig)configGW.clone() : new WWWAuthenticateConfig();
        proxy.setRealm(realm);
        proxy.setAuthType(authType);
        return missing ? proxy.buildWWWAuthenticateHeaderValue_notFound() : proxy.buildWWWAuthenticateHeaderValue_invalid();
    }

    public static String buildWWWProxyAuthPrincipal(String authType, String realm, boolean missing) {
        if (realm == null || "".equals(realm) || authType == null || "".equals(authType)) {
            return null;
        }
        WWWAuthenticateConfig configGW = OpenSPCoop2Properties.getInstance().getRealmAutenticazionePrincipalWWWAuthenticateConfig(TipoAutenticazionePrincipal.CONTAINER);
        WWWAuthenticateConfig proxy = configGW != null ? (WWWAuthenticateConfig)configGW.clone() : new WWWAuthenticateConfig();
        proxy.setRealm(realm);
        proxy.setAuthType(authType);
        return missing ? proxy.buildWWWAuthenticateHeaderValue_notFound() : proxy.buildWWWAuthenticateHeaderValue_invalid();
    }

    public static String buildWWWProxyAuthAtleastOne(String authType, String realm, String errorDescription) {
        if (realm == null || "".equals(realm) || authType == null || "".equals(authType)) {
            return null;
        }
        if (errorDescription != null && !"".equals(errorDescription)) {
            return WWWAuthenticateGenerator.buildCustomHeaderValue((String)authType, (String)realm, (WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_request, (String)errorDescription);
        }
        WWWAuthenticateErrorCode errorCode = null;
        return WWWAuthenticateGenerator.buildCustomHeaderValue((String)authType, (String)realm, errorCode, null);
    }

    public static String buildWWWAuthBasic() {
        WWWAuthenticateConfig config = OpenSPCoop2Properties.getInstance().getRealmAutenticazioneBasicWWWAuthenticateConfig();
        if (config != null) {
            return config.buildWWWAuthenticateHeaderValue_notFound();
        }
        return null;
    }

    public static String buildWWWAuthSSL() {
        WWWAuthenticateConfig config = OpenSPCoop2Properties.getInstance().getRealmAutenticazioneHttpsWWWAuthenticateConfig();
        if (config != null) {
            return config.buildWWWAuthenticateHeaderValue_notFound();
        }
        return null;
    }

    public static String buildWWWAuthPrincipal() {
        WWWAuthenticateConfig config = OpenSPCoop2Properties.getInstance().getRealmAutenticazionePrincipalWWWAuthenticateConfig(TipoAutenticazionePrincipal.CONTAINER);
        if (config != null) {
            return config.buildWWWAuthenticateHeaderValue_notFound();
        }
        return null;
    }
}

