/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.dynamic;

import java.util.Iterator;
import java.util.List;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.openspcoop2.core.commons.CoreRuntimeException;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.xml.XPathExpressionEngine;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.dynamic.ContentReader;
import org.openspcoop2.pdd.core.dynamic.DynamicException;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.openspcoop2.utils.xml.XPathReturnType;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public class ContentExtractor
extends ContentReader {
    public ContentExtractor(OpenSPCoop2Message message, Context pddContext, Logger log) {
        super(message, pddContext, log);
    }

    public void addTransportHeader(String name, String value) {
        if (this.message != null) {
            this.message.forceTransportHeader(name, value);
        }
    }

    public void addTransportHeader(String name, List<String> values) {
        if (this.message != null) {
            this.message.forceTransportHeader(name, values);
        }
    }

    public void removeTransportHeader(String name) {
        if (this.message != null) {
            if (this.message.getTransportRequestContext() != null) {
                this.message.getTransportRequestContext().removeHeader(name);
            } else if (this.message.getTransportResponseContext() != null) {
                this.message.getTransportResponseContext().removeHeader(name);
            }
        }
    }

    public void addUrlProperty(String name, String value) {
        if (this.message != null) {
            this.message.forceUrlProperty(name, value);
        }
    }

    public void addUrlProperty(String name, List<String> values) {
        if (this.message != null) {
            this.message.forceUrlProperty(name, values);
        }
    }

    public void removeUrlProperty(String name) {
        if (this.message != null && this.message.getTransportRequestContext() != null) {
            this.message.getTransportRequestContext().removeParameter(name);
        }
    }

    public void setMustUnderstand(boolean value) throws DynamicException {
        this.setMustUnderstand(value, null, null);
    }

    public void setMustUnderstand(boolean value, String localName, String namespace) throws DynamicException {
        if (this.message != null && ServiceBinding.SOAP.equals((Object)this.message.getServiceBinding())) {
            try {
                Iterator nodes;
                OpenSPCoop2SoapMessage soapMsg = this.message.castAsSoap();
                SOAPHeader header = soapMsg.getSOAPHeader();
                if (header != null && (nodes = header.getChildElements()) != null) {
                    while (nodes.hasNext()) {
                        Node n = (Node)nodes.next();
                        this.setMustUnderstandEngine(n, value, localName, namespace);
                    }
                }
            }
            catch (Exception t) {
                throw new DynamicException(t.getMessage(), t);
            }
        }
    }

    private void setMustUnderstandEngine(Node n, boolean value, String localName, String namespace) {
        if (n instanceof SOAPHeaderElement) {
            SOAPHeaderElement hdrE = (SOAPHeaderElement)n;
            boolean setValue = true;
            if (localName != null && !localName.equals(hdrE.getLocalName())) {
                setValue = false;
            }
            if (setValue && namespace != null && !namespace.equals(hdrE.getNamespaceURI())) {
                setValue = false;
            }
            if (setValue) {
                hdrE.setMustUnderstand(value);
            }
        }
    }

    public void setActor(String value) throws DynamicException {
        this.setActor(value, null, null);
    }

    public void setActor(String value, String localName, String namespace) throws DynamicException {
        if (this.message != null && ServiceBinding.SOAP.equals((Object)this.message.getServiceBinding())) {
            try {
                Iterator nodes;
                OpenSPCoop2SoapMessage soapMsg = this.message.castAsSoap();
                SOAPHeader header = soapMsg.getSOAPHeader();
                if (header != null && (nodes = header.getChildElements()) != null) {
                    while (nodes.hasNext()) {
                        Node n = (Node)nodes.next();
                        this.setActorEngine(n, value, localName, namespace);
                    }
                }
            }
            catch (Exception t) {
                throw new DynamicException(t.getMessage(), t);
            }
        }
    }

    private void setActorEngine(Node n, String value, String localName, String namespace) {
        if (n instanceof SOAPHeaderElement) {
            SOAPHeaderElement hdrE = (SOAPHeaderElement)n;
            boolean setValue = true;
            if (localName != null && !localName.equals(hdrE.getLocalName())) {
                setValue = false;
            }
            if (setValue && namespace != null && !namespace.equals(hdrE.getNamespaceURI())) {
                setValue = false;
            }
            if (setValue) {
                hdrE.setActor(value);
            }
        }
    }

    public void setRole(String value) throws DynamicException {
        this.setRole(value, null, null);
    }

    public void setRole(String value, String localName, String namespace) throws DynamicException {
        if (this.message != null && ServiceBinding.SOAP.equals((Object)this.message.getServiceBinding())) {
            try {
                Iterator nodes;
                OpenSPCoop2SoapMessage soapMsg = this.message.castAsSoap();
                SOAPHeader header = soapMsg.getSOAPHeader();
                if (header != null && (nodes = header.getChildElements()) != null) {
                    while (nodes.hasNext()) {
                        Node n = (Node)nodes.next();
                        this.setRoleEngine(n, value, localName, namespace);
                    }
                }
            }
            catch (Exception t) {
                throw new DynamicException(t.getMessage(), t);
            }
        }
    }

    private void setRoleEngine(Node n, String value, String localName, String namespace) throws SOAPException {
        if (n instanceof SOAPHeaderElement) {
            SOAPHeaderElement hdrE = (SOAPHeaderElement)n;
            boolean setValue = true;
            if (localName != null && !localName.equals(hdrE.getLocalName())) {
                setValue = false;
            }
            if (setValue && namespace != null && !namespace.equals(hdrE.getNamespaceURI())) {
                setValue = false;
            }
            if (setValue) {
                hdrE.setRole(value);
            }
        }
    }

    public void disableExceptionIfFoundMoreSecurityHeader() {
        if (this.message != null && ServiceBinding.SOAP.equals((Object)this.message.getServiceBinding())) {
            try {
                this.message.castAsSoap().setThrowExceptionIfFoundMoreSecurityHeader(false);
            }
            catch (Exception t) {
                throw new CoreRuntimeException(t.getMessage(), (Throwable)t);
            }
        }
    }

    public void addSoapHeader(String xml) throws DynamicException {
        this.addSoapHeader(xml.getBytes());
    }

    public void addSoapHeader(byte[] xml) throws DynamicException {
        if (this.message != null && ServiceBinding.SOAP.equals((Object)this.message.getServiceBinding())) {
            try {
                OpenSPCoop2SoapMessage soapMsg = this.message.castAsSoap();
                SOAPHeader header = soapMsg.getSOAPHeader();
                if (header == null) {
                    header = soapMsg.getSOAPPart().getEnvelope().addHeader();
                }
                SOAPElement soapElement = soapMsg.createSOAPElement(xml);
                header.addChildElement(soapElement);
            }
            catch (Exception t) {
                throw new DynamicException(t.getMessage(), t);
            }
        }
    }

    public void setSoapBody(String xml) throws DynamicException {
        this.setSoapBody(xml.getBytes());
    }

    public void setSoapBody(byte[] xml) throws DynamicException {
        if (this.message != null && ServiceBinding.SOAP.equals((Object)this.message.getServiceBinding())) {
            try {
                OpenSPCoop2SoapMessage soapMsg = this.message.castAsSoap();
                SOAPElement soapElement = soapMsg.createSOAPElement(xml);
                soapMsg.getSOAPBody().removeContents();
                soapMsg.getSOAPBody().addChildElement(soapElement);
            }
            catch (Exception t) {
                throw new DynamicException(t.getMessage(), t);
            }
        }
    }

    public void addSoapBody(String xml, String xpath) throws DynamicException {
        this.addSoapBody(xml.getBytes(), xpath);
    }

    public void addSoapBody(byte[] xml, String xpath) throws DynamicException {
        if (this.message != null && ServiceBinding.SOAP.equals((Object)this.message.getServiceBinding())) {
            try {
                OpenSPCoop2SoapMessage soapMsg = this.message.castAsSoap();
                SOAPBody body = soapMsg.getSOAPBody();
                XPathExpressionEngine xpathEngine = new XPathExpressionEngine(this.message.getFactory());
                DynamicNamespaceContext dnc = new DynamicNamespaceContext();
                dnc.findPrefixNamespace((Node)body);
                Node n = (Node)xpathEngine.getMatchPattern((SOAPElement)body, dnc, xpath, XPathReturnType.NODE);
                SOAPElement soapElement = soapMsg.createSOAPElement(xml);
                if (n instanceof SOAPElement) {
                    SOAPElement s = (SOAPElement)n;
                    s.addChildElement(soapElement);
                } else {
                    Node nImported = body.getOwnerDocument().importNode((Node)soapElement, true);
                    n.appendChild(nImported);
                }
            }
            catch (Exception t) {
                throw new DynamicException(t.getMessage(), t);
            }
        }
    }

    public void addSWAStartParameterIfNotPresentBeforeSend() {
        CostantiPdD.addSWAStartParameterIfNotPresent(this.message);
    }

    public void addSWAStartParameterIfNotPresent() throws DynamicException {
        try {
            SoapUtils.addSWAStartParameterIfNotPresent((OpenSPCoop2Message)this.message);
        }
        catch (Exception t) {
            throw new DynamicException(t.getMessage(), t);
        }
    }

    public void addSWAStartParameterIfNotPresent(boolean addOnlyIfExistsContentIdRootPart) throws DynamicException {
        try {
            SoapUtils.addSWAStartParameterIfNotPresent((OpenSPCoop2Message)this.message, (boolean)addOnlyIfExistsContentIdRootPart);
        }
        catch (Exception t) {
            throw new DynamicException(t.getMessage(), t);
        }
    }

    public void addSWAStartParameterIfNotPresent(boolean addOnlyIfExistsContentIdRootPart, boolean forceAddStartParameter) throws DynamicException {
        try {
            SoapUtils.addSWAStartParameterIfNotPresent((OpenSPCoop2Message)this.message, (boolean)addOnlyIfExistsContentIdRootPart, (boolean)forceAddStartParameter);
        }
        catch (Exception t) {
            throw new DynamicException(t.getMessage(), t);
        }
    }

    public void prettyFormatJsonContent() throws DynamicException {
        if (!this.isRestJson()) {
            throw new DynamicException("Funzionalit\u00e0 richiede un messaggio JSON");
        }
        try {
            this.message.castAsRestJson().prettyFormatContent();
        }
        catch (Exception e) {
            throw new DynamicException("Operazione fallita: " + e.getMessage(), e);
        }
    }

    public void addSimpleJsonElement(String name, Object value) throws DynamicException {
        if (!this.isRestJson()) {
            throw new DynamicException("Funzionalit\u00e0 richiede un messaggio JSON");
        }
        try {
            this.message.castAsRestJson().addSimpleElement(name, value);
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public void addSimpleJsonElement(String jsonPath, String name, Object value) throws DynamicException {
        if (!this.isRestJson()) {
            throw new DynamicException("Funzionalit\u00e0 richiede un messaggio JSON");
        }
        try {
            this.message.castAsRestJson().addSimpleElement(jsonPath, name, value);
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public void addObjectJsonElement(String name, Object value) throws DynamicException {
        if (!this.isRestJson()) {
            throw new DynamicException("Funzionalit\u00e0 richiede un messaggio JSON");
        }
        try {
            this.message.castAsRestJson().addObjectElement(name, value);
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public void addObjectJsonElement(String jsonPath, String name, Object value) throws DynamicException {
        if (!this.isRestJson()) {
            throw new DynamicException("Funzionalit\u00e0 richiede un messaggio JSON");
        }
        try {
            this.message.castAsRestJson().addObjectElement(jsonPath, name, value);
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public void addArrayJsonElement(String name, Object value) throws DynamicException {
        if (!this.isRestJson()) {
            throw new DynamicException("Funzionalit\u00e0 richiede un messaggio JSON");
        }
        try {
            this.message.castAsRestJson().addArrayElement(name, value);
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public void addArrayJsonElement(String jsonPath, String name, Object value) throws DynamicException {
        if (!this.isRestJson()) {
            throw new DynamicException("Funzionalit\u00e0 richiede un messaggio JSON");
        }
        try {
            this.message.castAsRestJson().addArrayElement(jsonPath, name, value);
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public void removeJsonField(String name) throws DynamicException {
        if (!this.isRestJson()) {
            throw new DynamicException("Funzionalit\u00e0 richiede un messaggio JSON");
        }
        try {
            this.message.castAsRestJson().removeElement(name);
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public void removeJsonField(String jsonPath, String name) throws DynamicException {
        if (!this.isRestJson()) {
            throw new DynamicException("Funzionalit\u00e0 richiede un messaggio JSON");
        }
        try {
            this.message.castAsRestJson().removeElement(jsonPath, name);
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public void addXmlElement(String name, String value) throws DynamicException {
        if (!this.isRestXml()) {
            throw new DynamicException("Funzionalit\u00e0 richiede un messaggio XML");
        }
        try {
            this.message.castAsRestXml().addElement(name, value);
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public void addXmlElement(String name, String namespace, String value) throws DynamicException {
        if (!this.isRestXml()) {
            throw new DynamicException("Funzionalit\u00e0 richiede un messaggio XML");
        }
        try {
            this.message.castAsRestXml().addElement(name, namespace, value);
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public void addXmlElementIn(String pattern, String name, String value) throws DynamicException {
        if (!this.isRestXml()) {
            throw new DynamicException("Funzionalit\u00e0 richiede un messaggio XML");
        }
        try {
            this.message.castAsRestXml().addElementIn(pattern, name, value);
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public void addXmlElementIn(String pattern, String name, String namespace, String value) throws DynamicException {
        if (!this.isRestXml()) {
            throw new DynamicException("Funzionalit\u00e0 richiede un messaggio XML");
        }
        try {
            this.message.castAsRestXml().addElementIn(pattern, name, namespace, value);
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public void removeXmlElement(String name) throws DynamicException {
        if (!this.isRestXml()) {
            throw new DynamicException("Funzionalit\u00e0 richiede un messaggio XML");
        }
        try {
            this.message.castAsRestXml().removeElement(name);
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public void removeXmlElement(String name, String namespace) throws DynamicException {
        if (!this.isRestXml()) {
            throw new DynamicException("Funzionalit\u00e0 richiede un messaggio XML");
        }
        try {
            this.message.castAsRestXml().removeElement(name, namespace);
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public void removeXmlElementIn(String pattern, String name) throws DynamicException {
        if (!this.isRestXml()) {
            throw new DynamicException("Funzionalit\u00e0 richiede un messaggio XML");
        }
        try {
            this.message.castAsRestXml().removeElementIn(pattern, name);
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public void removeXmlElementIn(String pattern, String name, String namespace) throws DynamicException {
        if (!this.isRestXml()) {
            throw new DynamicException("Funzionalit\u00e0 richiede un messaggio XML");
        }
        try {
            this.message.castAsRestXml().removeElementIn(pattern, name, namespace);
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }
}

