/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.dynamic;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.soap.SOAPEnvelope;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2RestMessage;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.rest.DumpRestMessageUtils;
import org.openspcoop2.message.soap.DumpSoapMessageUtils;
import org.openspcoop2.message.soap.TunnelSoapUtils;
import org.openspcoop2.message.soap.reader.OpenSPCoop2MessageSoapStreamReader;
import org.openspcoop2.message.utils.DumpMessaggio;
import org.openspcoop2.message.utils.DumpMessaggioConfig;
import org.openspcoop2.pdd.core.GestoreCorrelazioneApplicativa;
import org.openspcoop2.pdd.core.dynamic.DynamicException;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.utils.digest.DigestEncoding;
import org.openspcoop2.utils.digest.DigestUtils;
import org.slf4j.Logger;

public class ContentReader {
    protected static final String FUNZIONALITA_RICHIEDE_SOAP = "Funzionalit\u00e0 utilizzabile solamente con service binding soap";
    protected static final String FUNZIONALITA_RICHIEDE_JSON = "Funzionalit\u00e0 richiede un messaggio JSON";
    protected static final String FUNZIONALITA_RICHIEDE_XML = "Funzionalit\u00e0 richiede un messaggio XML";
    protected Logger log;
    protected OpenSPCoop2Message message;
    protected Context pddContext;
    private DumpMessaggio dumpMessaggio = null;
    private Boolean dumpMessaggioInit = null;

    public ContentReader(OpenSPCoop2Message message, Context pddContext, Logger log) {
        this.message = message;
        this.pddContext = pddContext;
        this.log = log;
    }

    public String getApplicationMessageId() {
        boolean request;
        boolean bl = request = this.message == null || this.message.getMessageRole() == null || MessageRole.NONE.equals((Object)this.message.getMessageRole()) || MessageRole.REQUEST.equals((Object)this.message.getMessageRole());
        if (request) {
            if (this.pddContext != null && this.pddContext.containsKey(GestoreCorrelazioneApplicativa.CONTEXT_CORRELAZIONE_APPLICATIVA_RICHIESTA)) {
                return (String)this.pddContext.get(GestoreCorrelazioneApplicativa.CONTEXT_CORRELAZIONE_APPLICATIVA_RICHIESTA);
            }
        } else if (this.pddContext != null && this.pddContext.containsKey(GestoreCorrelazioneApplicativa.CONTEXT_CORRELAZIONE_APPLICATIVA_RISPOSTA)) {
            return (String)this.pddContext.get(GestoreCorrelazioneApplicativa.CONTEXT_CORRELAZIONE_APPLICATIVA_RISPOSTA);
        }
        return null;
    }

    public OpenSPCoop2Message getMessage() {
        return this.message;
    }

    public boolean isSoap() {
        if (this.message == null) {
            return false;
        }
        return ServiceBinding.SOAP.equals((Object)this.message.getServiceBinding());
    }

    public boolean isSoap11() {
        if (this.message == null || this.message.getMessageType() == null) {
            return false;
        }
        return MessageType.SOAP_11.equals((Object)this.message.getMessageType());
    }

    public boolean isSoap12() {
        if (this.message == null || this.message.getMessageType() == null) {
            return false;
        }
        return MessageType.SOAP_12.equals((Object)this.message.getMessageType());
    }

    public boolean isRest() {
        if (this.message == null) {
            return false;
        }
        return ServiceBinding.REST.equals((Object)this.message.getServiceBinding());
    }

    public boolean isRestXml() {
        if (this.message == null || this.message.getMessageType() == null) {
            return false;
        }
        return MessageType.XML.equals((Object)this.message.getMessageType());
    }

    public boolean isRestJson() {
        if (this.message == null || this.message.getMessageType() == null) {
            return false;
        }
        return MessageType.JSON.equals((Object)this.message.getMessageType());
    }

    public boolean isRestMultipart() {
        if (this.message == null || this.message.getMessageType() == null) {
            return false;
        }
        return MessageType.MIME_MULTIPART.equals((Object)this.message.getMessageType());
    }

    public boolean isRestBinary() {
        if (this.message == null || this.message.getMessageType() == null) {
            return false;
        }
        return MessageType.BINARY.equals((Object)this.message.getMessageType());
    }

    public boolean isHasContent() throws DynamicException {
        return this.hasContent();
    }

    public boolean hasContent() throws DynamicException {
        try {
            if (this.message == null) {
                return false;
            }
            if (ServiceBinding.SOAP.equals((Object)this.message.getServiceBinding())) {
                return this.message.castAsSoap().getSOAPPart() != null && this.message.castAsSoap().getSOAPPart().getEnvelope() != null;
            }
            return this.message.castAsRest().hasContent();
        }
        catch (Exception t) {
            throw new DynamicException(t.getMessage(), t);
        }
    }

    public byte[] getContent() throws DynamicException {
        byte[] content = null;
        if (!this.hasContent()) {
            content = null;
        } else {
            try {
                if (ServiceBinding.SOAP.equals((Object)this.message.getServiceBinding())) {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    this.message.castAsSoap().writeTo((OutputStream)bout, false);
                    bout.flush();
                    bout.close();
                    content = bout.toByteArray();
                } else {
                    content = this.message.castAsRest().getContentAsString().getBytes();
                }
            }
            catch (Exception t) {
                throw new DynamicException(t.getMessage(), t);
            }
        }
        return content;
    }

    public String getContentAsString() throws DynamicException {
        if (!this.hasContent()) {
            return null;
        }
        try {
            if (ServiceBinding.SOAP.equals((Object)this.message.getServiceBinding())) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                this.message.castAsSoap().writeTo((OutputStream)bout, false);
                bout.flush();
                bout.close();
                return bout.toString();
            }
            return this.message.castAsRest().getContentAsString();
        }
        catch (Exception t) {
            throw new DynamicException(t.getMessage(), t);
        }
    }

    public String getContentBase64Digest(String algorithm) throws DynamicException {
        return this.getContentDigest(algorithm, DigestEncoding.BASE64, false);
    }

    public String getContentBase64Digest(String algorithm, String rfc3230) throws DynamicException {
        boolean v = false;
        try {
            v = Boolean.valueOf(rfc3230);
        }
        catch (Exception e) {
            throw new DynamicException(this.buildUncorrectBooleaValueMessage(rfc3230, e), e);
        }
        return this.getContentBase64Digest(algorithm, v);
    }

    public String getContentBase64Digest(String algorithm, boolean rfc3230) throws DynamicException {
        return this.getContentDigest(algorithm, DigestEncoding.BASE64, rfc3230);
    }

    public String getContentHexDigest(String algorithm) throws DynamicException {
        return this.getContentDigest(algorithm, DigestEncoding.HEX, false);
    }

    public String getContentHexDigest(String algorithm, String rfc3230) throws DynamicException {
        boolean v = false;
        try {
            v = Boolean.valueOf(rfc3230);
        }
        catch (Exception e) {
            throw new DynamicException(this.buildUncorrectBooleaValueMessage(rfc3230, e), e);
        }
        return this.getContentHexDigest(algorithm, v);
    }

    public String getContentHexDigest(String algorithm, boolean rfc3230) throws DynamicException {
        return this.getContentDigest(algorithm, DigestEncoding.HEX, rfc3230);
    }

    public String getContentDigest(String algorithm, String digestEncodingParam) throws DynamicException {
        return this.getContentDigest(algorithm, digestEncodingParam, false);
    }

    public String getContentDigest(String algorithm, DigestEncoding digestEncoding) throws DynamicException {
        return this.getContentDigest(algorithm, digestEncoding, false);
    }

    public String getContentDigest(String algorithm, String digestEncodingParam, String rfc3230) throws DynamicException {
        boolean v = false;
        try {
            v = Boolean.valueOf(rfc3230);
        }
        catch (Exception e) {
            throw new DynamicException(this.buildUncorrectBooleaValueMessage(rfc3230, e), e);
        }
        return this.getContentDigest(algorithm, digestEncodingParam, v);
    }

    public String getContentDigest(String algorithm, String digestEncodingParam, boolean rfc3230) throws DynamicException {
        DigestEncoding digestEncoding = null;
        try {
            digestEncoding = DigestEncoding.valueOf((String)digestEncodingParam);
        }
        catch (Exception t) {
            throw new DynamicException("DigestEncoding '" + digestEncodingParam + "' unsupported");
        }
        return this.getContentDigest(algorithm, digestEncoding, rfc3230);
    }

    public String getContentDigest(String algorithm, DigestEncoding digestEncoding, String rfc3230) throws DynamicException {
        boolean v = false;
        try {
            v = Boolean.valueOf(rfc3230);
        }
        catch (Exception e) {
            throw new DynamicException(this.buildUncorrectBooleaValueMessage(rfc3230, e), e);
        }
        return this.getContentDigest(algorithm, digestEncoding, v);
    }

    public String getContentDigest(String algorithm, DigestEncoding digestEncoding, boolean rfc3230) throws DynamicException {
        byte[] content = this.getContent();
        if (content == null) {
            throw new DynamicException("Content null");
        }
        try {
            return DigestUtils.getDigestValue((byte[])content, (String)algorithm, (DigestEncoding)digestEncoding, (boolean)rfc3230);
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public byte[] getContentSoapBody() throws DynamicException {
        byte[] content = null;
        if (!this.hasContent()) {
            content = null;
        } else {
            try {
                if (ServiceBinding.SOAP.equals((Object)this.message.getServiceBinding())) {
                    if (this.message.castAsSoap().getSOAPPart() == null || this.message.castAsSoap().getSOAPPart().getEnvelope() == null) {
                        throw new DynamicException("Messaggio senza una busta SOAP");
                    }
                } else {
                    throw new DynamicException(FUNZIONALITA_RICHIEDE_SOAP);
                }
                content = TunnelSoapUtils.sbustamentoSOAPEnvelope((OpenSPCoop2MessageFactory)this.message.getFactory(), (SOAPEnvelope)this.message.castAsSoap().getSOAPPart().getEnvelope(), (boolean)false);
            }
            catch (Exception t) {
                throw new DynamicException(t.getMessage(), t);
            }
        }
        return content;
    }

    public String getContentSoapBodyBase64Digest(String algorithm) throws DynamicException {
        return this.getContentSoapBodyDigest(algorithm, DigestEncoding.BASE64, false);
    }

    public String getContentSoapBodyBase64Digest(String algorithm, String rfc3230) throws DynamicException {
        boolean v = false;
        try {
            v = Boolean.valueOf(rfc3230);
        }
        catch (Exception e) {
            throw new DynamicException(this.buildUncorrectBooleaValueMessage(rfc3230, e), e);
        }
        return this.getContentSoapBodyBase64Digest(algorithm, v);
    }

    public String getContentSoapBodyBase64Digest(String algorithm, boolean rfc3230) throws DynamicException {
        return this.getContentSoapBodyDigest(algorithm, DigestEncoding.BASE64, rfc3230);
    }

    public String getContentSoapBodyHexDigest(String algorithm) throws DynamicException {
        return this.getContentSoapBodyDigest(algorithm, DigestEncoding.HEX, false);
    }

    public String getContentSoapBodyHexDigest(String algorithm, String rfc3230) throws DynamicException {
        boolean v = false;
        try {
            v = Boolean.valueOf(rfc3230);
        }
        catch (Exception e) {
            throw new DynamicException(this.buildUncorrectBooleaValueMessage(rfc3230, e), e);
        }
        return this.getContentSoapBodyHexDigest(algorithm, v);
    }

    public String getContentSoapBodyHexDigest(String algorithm, boolean rfc3230) throws DynamicException {
        return this.getContentSoapBodyDigest(algorithm, DigestEncoding.HEX, rfc3230);
    }

    public String getContentSoapBodyDigest(String algorithm, String digestEncodingParam) throws DynamicException {
        return this.getContentSoapBodyDigest(algorithm, digestEncodingParam, false);
    }

    public String getContentSoapBodyDigest(String algorithm, DigestEncoding digestEncoding) throws DynamicException {
        return this.getContentSoapBodyDigest(algorithm, digestEncoding, false);
    }

    public String getContentSoapBodyDigest(String algorithm, String digestEncodingParam, String rfc3230) throws DynamicException {
        boolean v = false;
        try {
            v = Boolean.valueOf(rfc3230);
        }
        catch (Exception e) {
            throw new DynamicException(this.buildUncorrectBooleaValueMessage(rfc3230, e), e);
        }
        return this.getContentSoapBodyDigest(algorithm, digestEncodingParam, v);
    }

    public String getContentSoapBodyDigest(String algorithm, String digestEncodingParam, boolean rfc3230) throws DynamicException {
        DigestEncoding digestEncoding = null;
        try {
            digestEncoding = DigestEncoding.valueOf((String)digestEncodingParam);
        }
        catch (Exception t) {
            throw new DynamicException("DigestEncoding '" + digestEncodingParam + "' unsupported");
        }
        return this.getContentSoapBodyDigest(algorithm, digestEncoding, rfc3230);
    }

    public String getContentSoapBodyDigest(String algorithm, DigestEncoding digestEncoding, String rfc3230) throws DynamicException {
        boolean v = false;
        try {
            v = Boolean.valueOf(rfc3230);
        }
        catch (Exception e) {
            throw new DynamicException(this.buildUncorrectBooleaValueMessage(rfc3230, e), e);
        }
        return this.getContentSoapBodyDigest(algorithm, digestEncoding, v);
    }

    public String getContentSoapBodyDigest(String algorithm, DigestEncoding digestEncoding, boolean rfc3230) throws DynamicException {
        byte[] content = this.getContentSoapBody();
        if (content == null) {
            throw new DynamicException("Content null");
        }
        try {
            return DigestUtils.getDigestValue((byte[])content, (String)algorithm, (DigestEncoding)digestEncoding, (boolean)rfc3230);
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    private String buildUncorrectBooleaValueMessage(String rfc3230, Exception e) {
        return "Uncorrect boolean value '" + rfc3230 + "': " + e.getMessage();
    }

    public boolean isSoapFault() throws DynamicException {
        try {
            if (ServiceBinding.SOAP.equals((Object)this.message.getServiceBinding())) {
                return this.message.castAsSoap().hasSOAPFault();
            }
            throw new DynamicException(FUNZIONALITA_RICHIEDE_SOAP);
        }
        catch (Exception t) {
            throw new DynamicException(t.getMessage(), t);
        }
    }

    public boolean isSoapBodyEmpty() throws DynamicException {
        try {
            if (ServiceBinding.SOAP.equals((Object)this.message.getServiceBinding())) {
                return this.message.castAsSoap().isSOAPBodyEmpty();
            }
            throw new DynamicException(FUNZIONALITA_RICHIEDE_SOAP);
        }
        catch (Exception t) {
            throw new DynamicException(t.getMessage(), t);
        }
    }

    public boolean isSoapWithAttachments() throws DynamicException {
        try {
            if (ServiceBinding.SOAP.equals((Object)this.message.getServiceBinding())) {
                return this.message.castAsSoap().hasAttachments();
            }
            throw new DynamicException(FUNZIONALITA_RICHIEDE_SOAP);
        }
        catch (Exception t) {
            throw new DynamicException(t.getMessage(), t);
        }
    }

    public OpenSPCoop2MessageSoapStreamReader getSoapReader() throws DynamicException {
        try {
            if (ServiceBinding.SOAP.equals((Object)this.message.getServiceBinding())) {
                return this.message.castAsSoap().getSoapReader();
            }
            throw new DynamicException(FUNZIONALITA_RICHIEDE_SOAP);
        }
        catch (Exception t) {
            throw new DynamicException(t.getMessage(), t);
        }
    }

    public DumpMessaggio getPart() throws DynamicException {
        return this.dumpMessage();
    }

    public DumpMessaggio getDumpMessage() throws DynamicException {
        return this.dumpMessage();
    }

    public DumpMessaggio dumpMessage() throws DynamicException {
        if (this.dumpMessaggioInit == null) {
            this.initDump();
        }
        return this.dumpMessaggio;
    }

    private synchronized void initDump() throws DynamicException {
        if (this.dumpMessaggioInit == null) {
            try {
                if (this.hasContent()) {
                    DumpMessaggioConfig config = new DumpMessaggioConfig();
                    config.setDumpAttachments(true);
                    config.setDumpBody(true);
                    config.setDumpHeaders(false);
                    config.setDumpMultipartHeaders(true);
                    this.dumpMessaggio = ServiceBinding.SOAP.equals((Object)this.message.getServiceBinding()) ? DumpSoapMessageUtils.dumpMessage((OpenSPCoop2SoapMessage)this.message.castAsSoap(), (DumpMessaggioConfig)config, (boolean)true) : DumpRestMessageUtils.dumpMessage((OpenSPCoop2RestMessage)this.message.castAsRest(), (DumpMessaggioConfig)config, (boolean)true);
                }
            }
            catch (Exception t) {
                throw new DynamicException(t.getMessage(), t);
            }
            this.dumpMessaggioInit = true;
        }
    }
}

