/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.eventi;

import java.sql.Connection;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryException;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.eventi.Evento;
import org.openspcoop2.core.eventi.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.eventi.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.pdd.config.DBTransazioniManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.core.eventi.EventiUtilities;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.date.DateManager;
import org.slf4j.Logger;

public class GestoreEventi {
    private static GestoreEventi staticInstance = null;
    private DAOFactory daoFactory = null;
    private ServiceManagerProperties daoFactoryServiceManagerProperties = null;
    private Logger daoFactoryLogger = null;
    private OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
    private boolean debug;
    private static final String ID_MODULO = "GestoreEventi";

    private static synchronized void initialize() throws DriverConfigurazioneException {
        if (staticInstance == null) {
            staticInstance = new GestoreEventi();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GestoreEventi getInstance() throws DriverConfigurazioneException {
        if (staticInstance != null) return staticInstance;
        Class<GestoreEventi> clazz = GestoreEventi.class;
        synchronized (GestoreEventi.class) {
            GestoreEventi.initialize();
            // ** MonitorExit[var0] (shouldn't be in output)
            return staticInstance;
        }
    }

    private GestoreEventi() throws DriverConfigurazioneException {
        try {
            this.debug = this.properties.isEventiDebug();
            DAOFactoryProperties daoFactoryProperties = null;
            this.daoFactoryLogger = OpenSPCoop2Logger.getLoggerOpenSPCoopEventi(this.debug);
            this.daoFactory = DAOFactory.getInstance((Logger)this.daoFactoryLogger);
            daoFactoryProperties = DAOFactoryProperties.getInstance((Logger)this.daoFactoryLogger);
            this.daoFactoryServiceManagerProperties = daoFactoryProperties.getServiceManagerProperties((IProjectInfo)ProjectInfo.getInstance());
            this.daoFactoryServiceManagerProperties.setShowSql(this.debug);
            this.daoFactoryServiceManagerProperties.setDatabaseType(DBTransazioniManager.getInstance().getTipoDatabase());
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void log(Evento evento) throws Exception {
        this.log(evento, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Evento evento, boolean shutdownInCorso) throws Exception {
        if (evento.getOraRegistrazione() == null) {
            evento.setOraRegistrazione(DateManager.getDate());
        }
        boolean logError = true;
        if (shutdownInCorso) {
            logError = false;
        }
        DBTransazioniManager dbManager = null;
        Resource r = null;
        String modulo = "GestoreEventi." + evento.getTipo() + "." + evento.getCodice();
        try {
            dbManager = DBTransazioniManager.getInstance();
            r = dbManager.getResource(this.properties.getIdentitaPortaDefaultWithoutProtocol(), modulo, evento.getIdTransazione(), logError);
            if (r == null) {
                throw new DriverConfigurazioneException("Risorsa al database non disponibile");
            }
            Connection con = (Connection)r.getResource();
            if (con == null) {
                throw new DriverConfigurazioneException("Connessione non disponibile");
            }
            this.log(evento, con);
        }
        finally {
            try {
                if (r != null) {
                    dbManager.releaseResource(this.properties.getIdentitaPortaDefaultWithoutProtocol(), modulo, r, logError);
                }
            }
            catch (Exception exception) {}
        }
    }

    public void log(Evento evento, Connection connection) throws DriverConfigurazioneException, DAOFactoryException, ServiceException, NotImplementedException {
        if (evento.getOraRegistrazione() == null) {
            evento.setOraRegistrazione(DateManager.getDate());
        }
        if (connection == null) {
            throw new DriverConfigurazioneException("Connessione non fornita");
        }
        JDBCServiceManager jdbcServiceManager = (JDBCServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), connection, this.daoFactoryServiceManagerProperties, this.daoFactoryLogger);
        jdbcServiceManager.getEventoService().create((Object)evento);
        String msg = "CREATO EVENTO: " + EventiUtilities.toString(evento);
        this.daoFactoryLogger.info(msg);
    }
}

