/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.handlers.notifier;

import java.util.List;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.handlers.notifier.INotifierCallback;
import org.openspcoop2.pdd.core.handlers.notifier.NotifierBufferState;
import org.openspcoop2.pdd.core.handlers.notifier.NotifierResult;
import org.openspcoop2.pdd.core.handlers.notifier.NotifierType;
import org.openspcoop2.utils.io.notifier.NotifierInputStream;
import org.openspcoop2.utils.io.notifier.StreamingHandler;
import org.openspcoop2.utils.resources.Loader;

public class NotifierUtilities {
    private static INotifierCallback notifierCallback = null;
    private static boolean notifierCallbackInitialized = false;

    private static synchronized void initNotifierCallback() throws Exception {
        if (notifierCallback == null) {
            OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
            if (properties.isNotifierInputStreamEnabled()) {
                String notifierInputStreamCallback = properties.getNotifierInputStreamCallback();
                ClassNameProperties classNameProperties = ClassNameProperties.getInstance();
                notifierCallback = (INotifierCallback)Loader.getInstance().newInstance(classNameProperties.getNotifierCallback(notifierInputStreamCallback));
            }
            notifierCallbackInitialized = true;
        }
    }

    private static INotifierCallback getNotifierCallback() throws Exception {
        if (!notifierCallbackInitialized) {
            NotifierUtilities.initNotifierCallback();
        }
        return notifierCallback;
    }

    public static void updateNotifierState(OpenSPCoop2Message message, NotifierType notifierType, Object context) throws Exception {
        if (message != null && message.getNotifierInputStream() != null) {
            NotifierInputStream nis = message.getNotifierInputStream();
            INotifierCallback notifierCallback = NotifierUtilities.getNotifierCallback();
            if (notifierCallback != null) {
                List<StreamingHandler> streamingHandlers;
                NotifierResult notifierResult = notifierCallback.notify(notifierType, context);
                if (nis.isBufferEnabled() && (streamingHandlers = notifierResult.getStreamingHandlers()) != null) {
                    for (StreamingHandler streamingHandler : streamingHandlers) {
                        nis.addStreamingHandler(streamingHandler);
                    }
                }
                if (nis.isBufferEnabled()) {
                    NotifierBufferState nuovoStatoBuffer = notifierResult.getBufferState();
                    if (NotifierBufferState.DISABLE_AND_RELEASE_BUFFER_READED.equals((Object)nuovoStatoBuffer)) {
                        if (nis.isBufferEnabled()) {
                            nis.setOFFBuffering(true);
                        }
                    } else if (NotifierBufferState.DISABLE.equals((Object)nuovoStatoBuffer) && nis.isBufferEnabled()) {
                        nis.setOFFBuffering(false);
                    }
                }
            }
        }
    }
}

