/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.handlers.transazioni;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2RestMessage;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.InResponseContext;
import org.openspcoop2.pdd.core.handlers.transazioni.FirstPositionHandler;
import org.openspcoop2.pdd.core.transazioni.InResponseStatefulObject;
import org.openspcoop2.pdd.core.transazioni.RepositoryGestioneStateful;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.core.transazioni.TransactionDeletedException;
import org.openspcoop2.pdd.core.transazioni.TransactionNotExistsException;
import org.openspcoop2.pdd.core.transazioni.TransactionStatefulNotSupportedException;
import org.openspcoop2.pdd.logger.DumpUtility;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public class InResponseHandler
extends FirstPositionHandler
implements org.openspcoop2.pdd.core.handlers.InResponseHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void invoke(InResponseContext context) throws HandlerException {
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        if (!op2Properties.isTransazioniEnabled()) {
            return;
        }
        String idTransazione = null;
        if (context != null && context.getPddContext() != null) {
            idTransazione = (String)context.getPddContext().getObject(Costanti.ID_TRANSAZIONE);
        }
        String fault = null;
        String formatoFault = null;
        try {
            if (context != null && context.getMessaggio() != null) {
                byte[] content;
                Logger log;
                ByteArrayOutputStream bout;
                if (ServiceBinding.SOAP.equals((Object)context.getMessaggio().getServiceBinding())) {
                    OpenSPCoop2SoapMessage soapMsg = context.getMessaggio().castAsSoap();
                    if (soapMsg.hasSOAPFault()) {
                        bout = new ByteArrayOutputStream();
                        bout.write(context.getMessaggio().getAsByte((Node)soapMsg.getSOAPPart().getEnvelope(), false));
                        bout.flush();
                        bout.close();
                        log = OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioni(op2Properties.isTransazioniDebug());
                        if (op2Properties.isTransazioniFaultPrettyPrint()) {
                            content = bout.toByteArray();
                            fault = DumpUtility.toString(MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)soapMsg.getFactory()).newDocument(content), log, context.getMessaggio());
                        } else {
                            fault = bout.toString();
                        }
                        formatoFault = soapMsg.getMessageType().name();
                    }
                } else {
                    OpenSPCoop2RestMessage restMsg = context.getMessaggio().castAsRest();
                    if (restMsg.isProblemDetailsForHttpApis_RFC7807() || MessageRole.FAULT.equals((Object)restMsg.getMessageRole())) {
                        switch (restMsg.getMessageType()) {
                            case XML: {
                                bout = new ByteArrayOutputStream();
                                restMsg.writeTo((OutputStream)bout, false);
                                bout.flush();
                                bout.close();
                                log = OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioni(op2Properties.isTransazioniDebug());
                                if (op2Properties.isTransazioniFaultPrettyPrint()) {
                                    content = bout.toByteArray();
                                    fault = DumpUtility.toString(MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)restMsg.getFactory()).newDocument(content), log, context.getMessaggio());
                                } else {
                                    fault = bout.toString();
                                }
                                formatoFault = restMsg.getMessageType().name();
                                break;
                            }
                            case JSON: {
                                bout = new ByteArrayOutputStream();
                                restMsg.writeTo((OutputStream)bout, false);
                                bout.flush();
                                bout.close();
                                if (op2Properties.isTransazioniFaultPrettyPrint()) {
                                    JSONUtils jsonUtils = JSONUtils.getInstance((boolean)true);
                                    byte[] content2 = bout.toByteArray();
                                    JsonNode jsonNode = jsonUtils.getAsNode(content2);
                                    fault = jsonUtils.toString(jsonNode);
                                } else {
                                    fault = bout.toString();
                                }
                                formatoFault = restMsg.getMessageType().name();
                                break;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new HandlerException("Errore durante il dump del soap fault", e);
        }
        if (context != null && context.getTransazioneApplicativoServer() != null) {
            try {
                context.getTransazioneApplicativoServer().setDataAccettazioneRisposta(context.getDataAccettazioneRisposta());
                Date dataIngressoRisposta = context.getDataElaborazioneMessaggio();
                if (context.getDataTerminataInvocazioneConnettore() != null) {
                    dataIngressoRisposta = context.getDataTerminataInvocazioneConnettore();
                }
                context.getTransazioneApplicativoServer().setDataIngressoRisposta(dataIngressoRisposta);
                if (context.getDataPrimaInvocazioneConnettore() != null) {
                    context.getTransazioneApplicativoServer().setDataUscitaRichiesta(context.getDataPrimaInvocazioneConnettore());
                }
                if (context.getDataRichiestaInoltrata() != null) {
                    context.getTransazioneApplicativoServer().setDataUscitaRichiestaStream(context.getDataRichiestaInoltrata());
                }
                context.getTransazioneApplicativoServer().setCodiceRisposta("" + context.getReturnCode());
                context.getTransazioneApplicativoServer().setUltimoErrore(context.getErroreConsegna());
                if (context.getConnettore() != null) {
                    context.getTransazioneApplicativoServer().setLocationConnettore(context.getConnettore().getLocation());
                }
                if (fault == null) return;
                context.getTransazioneApplicativoServer().setFault(fault);
                context.getTransazioneApplicativoServer().setFormatoFault(formatoFault);
                return;
            }
            catch (Exception e) {
                throw new HandlerException("Errore durante il processamento delle informazioni relative alla consegna per l'applicativo '" + context.getTransazioneApplicativoServer().getServizioApplicativoErogatore() + "': " + e.getMessage(), e);
            }
        }
        boolean gestioneStateful = false;
        Transaction tr = null;
        try {
            tr = TransactionContext.getTransaction(idTransazione);
        }
        catch (TransactionNotExistsException e) {
            gestioneStateful = true;
        }
        try {
            InResponseStatefulObject sObject;
            block78: {
                Date dataIngressoRisposta;
                Date dataAccettazioneRisposta;
                Date dataRichiestaInoltrata;
                sObject = null;
                if (tr == null && gestioneStateful) {
                    sObject = new InResponseStatefulObject();
                    dataRichiestaInoltrata = context.getDataRichiestaInoltrata();
                    sObject.setDataRichiestaInoltrata(dataRichiestaInoltrata);
                    dataAccettazioneRisposta = context.getDataAccettazioneRisposta();
                    sObject.setDataAccettazioneRisposta(dataAccettazioneRisposta);
                    dataIngressoRisposta = context.getDataElaborazioneMessaggio();
                    if (context.getDataTerminataInvocazioneConnettore() != null) {
                        dataIngressoRisposta = context.getDataTerminataInvocazioneConnettore();
                    }
                    sObject.setDataIngressoRisposta(dataIngressoRisposta);
                    if (context.getDataPrimaInvocazioneConnettore() != null) {
                        sObject.setDataUscitaRichiesta(context.getDataPrimaInvocazioneConnettore());
                    }
                    sObject.setReturnCode("" + context.getReturnCode());
                    if (context.getConnettore() != null) {
                        sObject.setLocation(context.getConnettore().getLocation());
                    }
                    if (fault != null) {
                        if (TipoPdD.APPLICATIVA.equals((Object)context.getTipoPorta())) {
                            sObject.setFaultIntegrazione(fault);
                            sObject.setFormatoFaultIntegrazione(formatoFault);
                        } else {
                            sObject.setFaultCooperazione(fault);
                            sObject.setFormatoFaultCooperazione(formatoFault);
                        }
                    }
                } else {
                    if (tr == null) {
                        throw new HandlerException("Transaction is null");
                    }
                    if (context == null) {
                        throw new HandlerException("Context is null");
                    }
                    dataRichiestaInoltrata = context.getDataRichiestaInoltrata();
                    try {
                        tr.setDataRichiestaInoltrata(dataRichiestaInoltrata);
                    }
                    catch (TransactionDeletedException e) {
                        if (sObject == null) {
                            sObject = new InResponseStatefulObject();
                        }
                        sObject.setDataRichiestaInoltrata(dataRichiestaInoltrata);
                    }
                    dataAccettazioneRisposta = context.getDataAccettazioneRisposta();
                    try {
                        tr.setDataAccettazioneRisposta(dataAccettazioneRisposta);
                    }
                    catch (TransactionDeletedException e) {
                        if (sObject == null) {
                            sObject = new InResponseStatefulObject();
                        }
                        sObject.setDataAccettazioneRisposta(dataAccettazioneRisposta);
                    }
                    dataIngressoRisposta = context.getDataElaborazioneMessaggio();
                    if (context.getDataTerminataInvocazioneConnettore() != null) {
                        dataIngressoRisposta = context.getDataTerminataInvocazioneConnettore();
                    }
                    try {
                        tr.setDataIngressoRisposta(dataIngressoRisposta);
                    }
                    catch (TransactionDeletedException e) {
                        if (sObject == null) {
                            sObject = new InResponseStatefulObject();
                        }
                        sObject.setDataIngressoRisposta(dataIngressoRisposta);
                    }
                    if (context.getDataPrimaInvocazioneConnettore() != null) {
                        try {
                            tr.setDataUscitaRichiesta(context.getDataPrimaInvocazioneConnettore());
                        }
                        catch (TransactionDeletedException e) {
                            if (sObject == null) {
                                sObject = new InResponseStatefulObject();
                            }
                            sObject.setDataUscitaRichiesta(context.getDataPrimaInvocazioneConnettore());
                        }
                    }
                    try {
                        if (context != null) {
                            tr.setCodiceTrasportoRichiesta("" + context.getReturnCode());
                        }
                    }
                    catch (TransactionDeletedException e) {
                        if (sObject == null) {
                            sObject = new InResponseStatefulObject();
                        }
                        sObject.setReturnCode("" + context.getReturnCode());
                    }
                    try {
                        String connettoreRequestUrl = null;
                        String connettoreRequestMethod = null;
                        if (context.getPddContext() != null) {
                            if (context.getPddContext().containsKey(CostantiPdD.CONNETTORE_REQUEST_URL)) {
                                connettoreRequestUrl = (String)context.getPddContext().getObject(CostantiPdD.CONNETTORE_REQUEST_URL);
                            }
                            if (context.getPddContext().containsKey(CostantiPdD.CONNETTORE_REQUEST_METHOD)) {
                                Object o = context.getPddContext().getObject(CostantiPdD.CONNETTORE_REQUEST_METHOD);
                                if (o instanceof String) {
                                    connettoreRequestMethod = (String)o;
                                } else if (o instanceof HttpRequestMethod) {
                                    HttpRequestMethod oConnettoreRequestMethod = (HttpRequestMethod)o;
                                    connettoreRequestMethod = oConnettoreRequestMethod.name();
                                }
                            }
                        }
                        if (!StringUtils.isEmpty(connettoreRequestUrl) && !StringUtils.isEmpty(connettoreRequestMethod)) {
                            Object prefix = "";
                            if ("govway://responseCaching".equals(context.getConnettore().getLocation())) {
                                prefix = context.getConnettore().getLocation() + "\n";
                            }
                            tr.setLocation((String)prefix + CostantiPdD.getConnettoreRequest(connettoreRequestUrl, connettoreRequestMethod));
                        } else if (context != null && context.getConnettore() != null) {
                            tr.setLocation(context.getConnettore().getLocation());
                        }
                    }
                    catch (TransactionDeletedException e) {
                        if (sObject == null) {
                            sObject = new InResponseStatefulObject();
                        }
                        sObject.setLocation(context.getConnettore().getLocation());
                    }
                    try {
                        if (fault != null) {
                            if (TipoPdD.APPLICATIVA.equals((Object)context.getTipoPorta())) {
                                tr.setFaultIntegrazione(fault);
                                tr.setFormatoFaultIntegrazione(formatoFault);
                            } else {
                                tr.setFaultCooperazione(fault);
                                tr.setFormatoFaultCooperazione(formatoFault);
                            }
                        }
                    }
                    catch (TransactionDeletedException e) {
                        if (fault == null) break block78;
                        if (sObject == null) {
                            sObject = new InResponseStatefulObject();
                        }
                        if (TipoPdD.APPLICATIVA.equals((Object)context.getTipoPorta())) {
                            sObject.setFaultIntegrazione(fault);
                            sObject.setFormatoFaultIntegrazione(formatoFault);
                        }
                        sObject.setFaultCooperazione(fault);
                        sObject.setFormatoFaultCooperazione(formatoFault);
                    }
                }
            }
            if (sObject == null) return;
            RepositoryGestioneStateful.addInResponseStatefulObject(context.getProtocolFactory().getProtocol(), idTransazione, sObject);
            return;
        }
        catch (TransactionStatefulNotSupportedException e) {
            throw new HandlerException("Errore durante il processamento dell'handler: " + e.getMessage(), e);
        }
    }
}

