/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.integrazione;

import java.util.ArrayList;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.pdd.core.integrazione.GruppoIntegrazione;

public enum TipoIntegrazione {
    DISABILITATO("none", "Disabilitato", null),
    TRASPORTO_EXT("trasportoExt", "Abilitato verso dominio interno e esterno", GruppoIntegrazione.HTTP),
    TRASPORTO("trasporto", "Abilitato solo verso dominio interno", GruppoIntegrazione.HTTP),
    URL_EXT("urlBasedExt", "Abilitato verso dominio interno e esterno", GruppoIntegrazione.URL),
    URL("urlBased", "Abilitato solo verso dominio interno", GruppoIntegrazione.URL),
    SOAP_EXT("soapExt", "Abilitato verso dominio interno e esterno", GruppoIntegrazione.SOAP),
    SOAP("soap", "Abilitato solo verso dominio interno", GruppoIntegrazione.SOAP),
    WSA_EXT("wsaExt", "Abilitato verso dominio interno e esterno", GruppoIntegrazione.WSA),
    WSA("wsa", "Abilitato solo verso dominio interno", GruppoIntegrazione.WSA),
    TEMPLATE("template", "Abilitato su richiesta e risposta", GruppoIntegrazione.TEMPLATE),
    TEMPLATE_REQUEST("template-request", "Abilitato solo sulla richiesta", GruppoIntegrazione.TEMPLATE),
    TEMPLATE_RESPONSE("template-response", "Abilitato solo sulla risposta", GruppoIntegrazione.TEMPLATE),
    AUTENTICAZIONE("autenticazione", "Abilitato su richiesta e risposta", GruppoIntegrazione.AUTENTICAZIONE),
    OPENSPCOOP2_TRASPORTO_EXT("openspcoop2-trasportoExt", "Abilitato verso dominio interno e esterno senza prefisso 'X-'", GruppoIntegrazione.BACKWARD_COMPATIBILITY_OPENSPCOOP2_HTTP),
    OPENSPCOOP2_TRASPORTO("openspcoop2-trasporto", "Abilitato solo verso dominio interno senza prefisso 'X-'", GruppoIntegrazione.BACKWARD_COMPATIBILITY_OPENSPCOOP2_HTTP),
    OPENSPCOOP2_X_TRASPORTO_EXT("openspcoop2-x-trasportoExt", "Abilitato verso dominio interno e esterno con prefisso 'X-'", GruppoIntegrazione.BACKWARD_COMPATIBILITY_OPENSPCOOP2_HTTP),
    OPENSPCOOP2_X_TRASPORTO("openspcoop2-x-trasporto", "Abilitato solo verso dominio interno con prefisso 'X-'", GruppoIntegrazione.BACKWARD_COMPATIBILITY_OPENSPCOOP2_HTTP),
    OPENSPCOOP1_TRASPORTO_EXT("openspcoop1-trasportoExt", "Abilitato verso dominio interno e esterno senza prefisso 'X-'", GruppoIntegrazione.BACKWARD_COMPATIBILITY_OPENSPCOOP1_HTTP),
    OPENSPCOOP1_TRASPORTO("openspcoop1-trasporto", "Abilitato solo verso dominio interno senza prefisso 'X-'", GruppoIntegrazione.BACKWARD_COMPATIBILITY_OPENSPCOOP1_HTTP),
    OPENSPCOOP1_X_TRASPORTO_EXT("openspcoop1-x-trasportoExt", "Abilitato verso dominio interno e esterno con prefisso 'X-'", GruppoIntegrazione.BACKWARD_COMPATIBILITY_OPENSPCOOP1_HTTP),
    OPENSPCOOP1_X_TRASPORTO("openspcoop1-x-trasporto", "Abilitato solo verso dominio interno con prefisso 'X-'", GruppoIntegrazione.BACKWARD_COMPATIBILITY_OPENSPCOOP1_HTTP),
    OPENSPCOOP2_URL_EXT("openspcoop2-urlBasedExt", "Abilitato verso dominio interno e esterno", GruppoIntegrazione.BACKWARD_COMPATIBILITY_OPENSPCOOP2_URL),
    OPENSPCOOP2_URL("openspcoop2-urlBased", "Abilitato solo verso dominio interno", GruppoIntegrazione.BACKWARD_COMPATIBILITY_OPENSPCOOP2_URL),
    OPENSPCOOP1_URL_EXT("openspcoop1-urlBasedExt", "Abilitato verso dominio interno e esterno", GruppoIntegrazione.BACKWARD_COMPATIBILITY_OPENSPCOOP1_URL),
    OPENSPCOOP1_URL("openspcoop1-urlBased", "Abilitato solo verso dominio interno", GruppoIntegrazione.BACKWARD_COMPATIBILITY_OPENSPCOOP1_URL),
    OPENSPCOOP2_SOAP_EXT("openspcoop2-soapExt", "Abilitato verso dominio interno e esterno", GruppoIntegrazione.BACKWARD_COMPATIBILITY_OPENSPCOOP2_SOAP),
    OPENSPCOOP2_SOAP("openspcoop2-soap", "Abilitato solo verso dominio interno", GruppoIntegrazione.BACKWARD_COMPATIBILITY_OPENSPCOOP2_SOAP),
    OPENSPCOOP1_SOAP_EXT("openspcoop1-soapExt", "Abilitato verso dominio interno e esterno", GruppoIntegrazione.BACKWARD_COMPATIBILITY_OPENSPCOOP1_SOAP),
    OPENSPCOOP1_SOAP("openspcoop1-soap", "Abilitato solo verso dominio interno", GruppoIntegrazione.BACKWARD_COMPATIBILITY_OPENSPCOOP1_SOAP);

    private String value;
    private String label;
    private GruppoIntegrazione group;

    public String getValue() {
        return this.value;
    }

    public String getLabel() {
        return this.label;
    }

    public GruppoIntegrazione getGroup() {
        return this.group;
    }

    private TipoIntegrazione(String value, String label, GruppoIntegrazione group) {
        this.value = value;
        this.label = label;
        this.group = group;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(GruppoIntegrazione object) {
        if (object == null) {
            return false;
        }
        if (object.getValue() == null) {
            return false;
        }
        return object.getValue().equals(this.getValue());
    }

    public boolean equals(String object) {
        if (object == null) {
            return false;
        }
        return object.equals(this.getValue());
    }

    public static String[] toValues() {
        String[] res = new String[TipoIntegrazione.values().length];
        int i = 0;
        for (TipoIntegrazione tmp : TipoIntegrazione.values()) {
            res[i] = tmp.getValue();
            ++i;
        }
        return res;
    }

    public static String[] toLabels() {
        String[] res = new String[TipoIntegrazione.values().length];
        int i = 0;
        for (TipoIntegrazione tmp : TipoIntegrazione.values()) {
            res[i] = tmp.getLabel();
            ++i;
        }
        return res;
    }

    public static String[] toValues(GruppoIntegrazione gruppo) {
        ArrayList<String> list = new ArrayList<String>();
        for (TipoIntegrazione tmp : TipoIntegrazione.values()) {
            if (gruppo == null ? tmp.getGroup() != null : !gruppo.equals((Object)tmp.getGroup())) continue;
            list.add(tmp.getValue());
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] toLabels(GruppoIntegrazione gruppo) {
        ArrayList<String> list = new ArrayList<String>();
        for (TipoIntegrazione tmp : TipoIntegrazione.values()) {
            if (gruppo == null ? tmp.getGroup() != null : !gruppo.equals((Object)tmp.getGroup())) continue;
            list.add(tmp.getLabel());
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public static boolean contains(String value) {
        return TipoIntegrazione.toEnumConstant(value) != null;
    }

    public static TipoIntegrazione toEnumConstant(String value) {
        try {
            return TipoIntegrazione.toEnumConstant(value, false);
        }
        catch (NotFoundException notFound) {
            return null;
        }
    }

    public static TipoIntegrazione toEnumConstant(String value, boolean throwNotFoundException) throws NotFoundException {
        TipoIntegrazione res = null;
        for (TipoIntegrazione tmp : TipoIntegrazione.values()) {
            if (!tmp.getValue().equals(value)) continue;
            res = tmp;
            break;
        }
        if (res == null && throwNotFoundException) {
            throw new NotFoundException("Enum with value [" + value + "] not found");
        }
        return res;
    }
}

