/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.integrazione;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageProperties;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.xml.ValidatoreXSD;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneBusta;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpConstants;
import org.openspcoop2.utils.xml.XSDResourceResolver;
import org.slf4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSResourceResolver;

public class UtilitiesIntegrazione {
    private static final boolean PORTA_DELEGATA = true;
    private static final boolean PORTA_APPLICATIVA = false;
    private static final boolean REQUEST = true;
    private static final boolean RESPONSE = false;
    private static UtilitiesIntegrazione utilitiesIntegrazionePDRequest = null;
    private static UtilitiesIntegrazione utilitiesIntegrazionePDResponse = null;
    private static UtilitiesIntegrazione utilitiesIntegrazionePARequest = null;
    private static UtilitiesIntegrazione utilitiesIntegrazionePAResponse = null;
    private List<MapKey<String>> keywordsIntegrazione = null;
    private Map<MapKey<String>, String> keyValueIntegrazioneTrasporto = null;
    private Map<MapKey<String>, Boolean> keySetEnabled_HeaderIntegrazioneTrasporto = null;
    private Map<MapKey<String>, Boolean> keyReadEnabled_HeaderIntegrazioneTrasporto = null;
    private Map<MapKey<String>, String> keyValueIntegrazioneUrlBased = null;
    private Map<MapKey<String>, Boolean> keySetEnabled_HeaderIntegrazioneUrlBased = null;
    private Map<MapKey<String>, Boolean> keyReadEnabled_HeaderIntegrazioneUrlBased = null;
    private Map<MapKey<String>, String> keyValueIntegrazioneSoap = null;
    private Map<MapKey<String>, Boolean> keySetEnabled_HeaderIntegrazioneSoap = null;
    private Map<MapKey<String>, Boolean> keyReadEnabled_HeaderIntegrazioneSoap = null;
    private OpenSPCoop2Properties openspcoopProperties = null;
    private Map<String, ValidatoreXSD> validatoreXSD_soap11_map = new HashMap<String, ValidatoreXSD>();
    private Map<String, ValidatoreXSD> validatoreXSD_soap12_map = new HashMap<String, ValidatoreXSD>();
    private boolean portaDelegata;
    private boolean request;
    private Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UtilitiesIntegrazione getInstancePDRequest(Logger log) {
        if (utilitiesIntegrazionePDRequest != null) return utilitiesIntegrazionePDRequest;
        Class<UtilitiesIntegrazione> clazz = UtilitiesIntegrazione.class;
        synchronized (UtilitiesIntegrazione.class) {
            UtilitiesIntegrazione.initialize(log, true, true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return utilitiesIntegrazionePDRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UtilitiesIntegrazione getInstancePDResponse(Logger log) {
        if (utilitiesIntegrazionePDResponse != null) return utilitiesIntegrazionePDResponse;
        Class<UtilitiesIntegrazione> clazz = UtilitiesIntegrazione.class;
        synchronized (UtilitiesIntegrazione.class) {
            UtilitiesIntegrazione.initialize(log, true, false);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return utilitiesIntegrazionePDResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UtilitiesIntegrazione getInstancePARequest(Logger log) {
        if (utilitiesIntegrazionePARequest != null) return utilitiesIntegrazionePARequest;
        Class<UtilitiesIntegrazione> clazz = UtilitiesIntegrazione.class;
        synchronized (UtilitiesIntegrazione.class) {
            UtilitiesIntegrazione.initialize(log, false, true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return utilitiesIntegrazionePARequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UtilitiesIntegrazione getInstancePAResponse(Logger log) {
        if (utilitiesIntegrazionePAResponse != null) return utilitiesIntegrazionePAResponse;
        Class<UtilitiesIntegrazione> clazz = UtilitiesIntegrazione.class;
        synchronized (UtilitiesIntegrazione.class) {
            UtilitiesIntegrazione.initialize(log, false, false);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return utilitiesIntegrazionePAResponse;
        }
    }

    private static synchronized void initialize(Logger log, boolean portaDelegata, boolean request) {
        if (portaDelegata) {
            if (request) {
                if (utilitiesIntegrazionePDRequest == null) {
                    utilitiesIntegrazionePDRequest = new UtilitiesIntegrazione(log, portaDelegata, request);
                }
            } else if (utilitiesIntegrazionePDResponse == null) {
                utilitiesIntegrazionePDResponse = new UtilitiesIntegrazione(log, portaDelegata, request);
            }
        } else if (request) {
            if (utilitiesIntegrazionePARequest == null) {
                utilitiesIntegrazionePARequest = new UtilitiesIntegrazione(log, portaDelegata, request);
            }
        } else if (utilitiesIntegrazionePAResponse == null) {
            utilitiesIntegrazionePAResponse = new UtilitiesIntegrazione(log, portaDelegata, request);
        }
    }

    private UtilitiesIntegrazione(Logger log, boolean portaDelegata, boolean request) {
        this.log = log;
        this.openspcoopProperties = OpenSPCoop2Properties.getInstance();
        this.portaDelegata = portaDelegata;
        this.request = request;
        this.keywordsIntegrazione = this.openspcoopProperties.getKeywordsIntegrazione();
        this.keyValueIntegrazioneTrasporto = this.openspcoopProperties.getKeyValue_HeaderIntegrazioneTrasporto();
        try {
            if (portaDelegata) {
                this.keySetEnabled_HeaderIntegrazioneTrasporto = this.openspcoopProperties.getKeyPDSetEnabled_HeaderIntegrazioneTrasporto(request);
                this.keyReadEnabled_HeaderIntegrazioneTrasporto = this.openspcoopProperties.getKeyPDReadEnabled_HeaderIntegrazioneTrasporto();
            } else {
                this.keySetEnabled_HeaderIntegrazioneTrasporto = this.openspcoopProperties.getKeyPASetEnabled_HeaderIntegrazioneTrasporto(request);
                this.keyReadEnabled_HeaderIntegrazioneTrasporto = this.openspcoopProperties.getKeyPAReadEnabled_HeaderIntegrazioneTrasporto();
            }
        }
        catch (Exception e) {
            log.error("Integrazione, errore durante la lettura del file di configurazione: " + e.getMessage(), (Throwable)e);
        }
        this.keyValueIntegrazioneUrlBased = this.openspcoopProperties.getKeyValue_HeaderIntegrazioneUrlBased();
        try {
            if (portaDelegata) {
                this.keySetEnabled_HeaderIntegrazioneUrlBased = this.openspcoopProperties.getKeyPDSetEnabled_HeaderIntegrazioneUrlBased();
                this.keyReadEnabled_HeaderIntegrazioneUrlBased = this.openspcoopProperties.getKeyPDReadEnabled_HeaderIntegrazioneUrlBased();
            } else {
                this.keySetEnabled_HeaderIntegrazioneUrlBased = this.openspcoopProperties.getKeyPASetEnabled_HeaderIntegrazioneUrlBased();
                this.keyReadEnabled_HeaderIntegrazioneUrlBased = this.openspcoopProperties.getKeyPAReadEnabled_HeaderIntegrazioneUrlBased();
            }
        }
        catch (Exception e) {
            log.error("Integrazione, errore durante la lettura del file di configurazione: " + e.getMessage(), (Throwable)e);
        }
        this.keyValueIntegrazioneSoap = this.openspcoopProperties.getKeyValue_HeaderIntegrazioneSoap();
        try {
            if (portaDelegata) {
                this.keySetEnabled_HeaderIntegrazioneSoap = this.openspcoopProperties.getKeyPDSetEnabled_HeaderIntegrazioneSoap(request);
                this.keyReadEnabled_HeaderIntegrazioneSoap = this.openspcoopProperties.getKeyPDReadEnabled_HeaderIntegrazioneSoap();
            } else {
                this.keySetEnabled_HeaderIntegrazioneSoap = this.openspcoopProperties.getKeyPASetEnabled_HeaderIntegrazioneSoap(request);
                this.keyReadEnabled_HeaderIntegrazioneSoap = this.openspcoopProperties.getKeyPAReadEnabled_HeaderIntegrazioneSoap();
            }
        }
        catch (Exception e) {
            log.error("Integrazione, errore durante la lettura del file di configurazione: " + e.getMessage(), (Throwable)e);
        }
    }

    private synchronized void initValidatoreXSD(OpenSPCoop2MessageFactory messageFactory) {
        String key = messageFactory.getClass().getName();
        if (!this.validatoreXSD_soap11_map.containsKey(key)) {
            try {
                XSDResourceResolver xsdResourceResolver_soap11 = new XSDResourceResolver();
                xsdResourceResolver_soap11.addResource("soapEnvelope.xsd", UtilitiesIntegrazione.class.getResourceAsStream("/soapEnvelope.xsd"));
                this.validatoreXSD_soap11_map.put(key, new ValidatoreXSD(messageFactory, this.log, (LSResourceResolver)xsdResourceResolver_soap11, UtilitiesIntegrazione.class.getResourceAsStream("/integrazione_soap11.xsd")));
            }
            catch (Exception e) {
                this.log.error("Integrazione.xsd, errore durante la costruzione del validatore xsd per Soap11: " + e.getMessage(), (Throwable)e);
            }
        }
        if (!this.validatoreXSD_soap12_map.containsKey(key)) {
            try {
                XSDResourceResolver xsdResourceResolver_soap12 = new XSDResourceResolver();
                xsdResourceResolver_soap12.addResource("soapEnvelope12.xsd", UtilitiesIntegrazione.class.getResourceAsStream("/soapEnvelope12.xsd"));
                xsdResourceResolver_soap12.addResource("xml.xsd", UtilitiesIntegrazione.class.getResourceAsStream("/xml.xsd"));
                this.validatoreXSD_soap12_map.put(key, new ValidatoreXSD(messageFactory, this.log, (LSResourceResolver)xsdResourceResolver_soap12, UtilitiesIntegrazione.class.getResourceAsStream("/integrazione_soap12.xsd")));
            }
            catch (Exception e) {
                this.log.error("Integrazione.xsd, errore durante la costruzione del validatore xsd per Soap12: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void checkInitValidatoreXSD(OpenSPCoop2MessageFactory messageFactory) {
        String key = messageFactory.getClass().getName();
        if (!this.validatoreXSD_soap11_map.containsKey(key)) {
            this.initValidatoreXSD(messageFactory);
        }
        if (!this.validatoreXSD_soap12_map.containsKey(key)) {
            this.initValidatoreXSD(messageFactory);
        }
    }

    private ValidatoreXSD getValidatoreXSD(boolean soap12, OpenSPCoop2MessageFactory messageFactory) {
        this.checkInitValidatoreXSD(messageFactory);
        String key = messageFactory.getClass().getName();
        if (soap12) {
            return this.validatoreXSD_soap12_map.get(key);
        }
        return this.validatoreXSD_soap11_map.get(key);
    }

    public void readTransportProperties(Map<String, List<String>> prop, HeaderIntegrazione integrazione) throws HeaderIntegrazioneException {
        try {
            if (prop != null && integrazione != null) {
                block4: for (String key : prop.keySet()) {
                    if (key == null) continue;
                    for (MapKey<String> keywordIntegrazione : this.keywordsIntegrazione) {
                        if (!key.equalsIgnoreCase(this.keyValueIntegrazioneTrasporto.get(keywordIntegrazione))) continue;
                        if (!this.keyReadEnabled_HeaderIntegrazioneTrasporto.get(keywordIntegrazione).booleanValue()) continue block4;
                        if (CostantiPdD.HEADER_INTEGRAZIONE_TIPO_MITTENTE.equals(keywordIntegrazione)) {
                            integrazione.getBusta().setTipoMittente(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_MITTENTE.equals(keywordIntegrazione)) {
                            integrazione.getBusta().setMittente(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_TIPO_DESTINATARIO.equals(keywordIntegrazione)) {
                            integrazione.getBusta().setTipoDestinatario(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_DESTINATARIO.equals(keywordIntegrazione)) {
                            integrazione.getBusta().setDestinatario(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_TIPO_SERVIZIO.equals(keywordIntegrazione)) {
                            integrazione.getBusta().setTipoServizio(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO.equals(keywordIntegrazione)) {
                            integrazione.getBusta().setServizio(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_VERSIONE_SERVIZIO.equals(keywordIntegrazione)) {
                            String v = TransportUtils.getFirstValue(prop, (String)key);
                            try {
                                if (v == null) continue block4;
                                integrazione.getBusta().setVersioneServizio(Integer.parseInt(v));
                                continue block4;
                            }
                            catch (Exception e) {
                                throw new Exception("Formato versione [" + v + "] non corretto: " + e.getMessage(), e);
                            }
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_AZIONE.equals(keywordIntegrazione)) {
                            integrazione.getBusta().setAzione(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_ID_MESSAGGIO.equals(keywordIntegrazione)) {
                            integrazione.getBusta().setID(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_RIFERIMENTO_MESSAGGIO.equals(keywordIntegrazione)) {
                            integrazione.getBusta().setRiferimentoMessaggio(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_COLLABORAZIONE.equals(keywordIntegrazione)) {
                            integrazione.getBusta().setIdCollaborazione(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_ID_APPLICATIVO.equals(keywordIntegrazione)) {
                            integrazione.setIdApplicativo(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO_APPLICATIVO.equals(keywordIntegrazione)) {
                            integrazione.setServizioApplicativo(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_TIPO_MITTENTE_TOKEN.equals(keywordIntegrazione)) {
                            integrazione.setTipoSoggettoProprietarioApplicativoToken(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_MITTENTE_TOKEN.equals(keywordIntegrazione)) {
                            integrazione.setNomeSoggettoProprietarioApplicativoToken(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO_APPLICATIVO_TOKEN.equals(keywordIntegrazione)) {
                            integrazione.setServizioApplicativoToken(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (!CostantiPdD.HEADER_INTEGRAZIONE_ID_TRANSAZIONE.equals(keywordIntegrazione)) continue block4;
                        integrazione.setIdTransazione(TransportUtils.getFirstValue(prop, (String)key));
                        continue block4;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, lettura dell'header non riuscita: " + e.getMessage(), e);
        }
    }

    public void readUrlProperties(Map<String, List<String>> prop, HeaderIntegrazione integrazione) throws HeaderIntegrazioneException {
        try {
            if (prop != null && integrazione != null) {
                block4: for (String key : prop.keySet()) {
                    if (key == null) continue;
                    for (MapKey<String> keywordIntegrazione : this.keywordsIntegrazione) {
                        if (!key.equalsIgnoreCase(this.keyValueIntegrazioneUrlBased.get(keywordIntegrazione))) continue;
                        if (!this.keyReadEnabled_HeaderIntegrazioneUrlBased.get(keywordIntegrazione).booleanValue()) continue block4;
                        if (CostantiPdD.HEADER_INTEGRAZIONE_TIPO_MITTENTE.equals(keywordIntegrazione)) {
                            integrazione.getBusta().setTipoMittente(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_MITTENTE.equals(keywordIntegrazione)) {
                            integrazione.getBusta().setMittente(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_TIPO_DESTINATARIO.equals(keywordIntegrazione)) {
                            integrazione.getBusta().setTipoDestinatario(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_DESTINATARIO.equals(keywordIntegrazione)) {
                            integrazione.getBusta().setDestinatario(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_TIPO_SERVIZIO.equals(keywordIntegrazione)) {
                            integrazione.getBusta().setTipoServizio(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO.equals(keywordIntegrazione)) {
                            integrazione.getBusta().setServizio(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_VERSIONE_SERVIZIO.equals(keywordIntegrazione)) {
                            String v = TransportUtils.getFirstValue(prop, (String)key);
                            try {
                                if (v == null) continue block4;
                                integrazione.getBusta().setVersioneServizio(Integer.parseInt(v));
                                continue block4;
                            }
                            catch (Exception e) {
                                throw new Exception("Formato versione [" + v + "] non corretto: " + e.getMessage(), e);
                            }
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_AZIONE.equals(keywordIntegrazione)) {
                            integrazione.getBusta().setAzione(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_ID_MESSAGGIO.equals(keywordIntegrazione)) {
                            integrazione.getBusta().setID(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_RIFERIMENTO_MESSAGGIO.equals(keywordIntegrazione)) {
                            integrazione.getBusta().setRiferimentoMessaggio(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_COLLABORAZIONE.equals(keywordIntegrazione)) {
                            integrazione.getBusta().setIdCollaborazione(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_ID_APPLICATIVO.equals(keywordIntegrazione)) {
                            integrazione.setIdApplicativo(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO_APPLICATIVO.equals(keywordIntegrazione)) {
                            integrazione.setServizioApplicativo(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_TIPO_MITTENTE_TOKEN.equals(keywordIntegrazione)) {
                            integrazione.setTipoSoggettoProprietarioApplicativoToken(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_MITTENTE_TOKEN.equals(keywordIntegrazione)) {
                            integrazione.setNomeSoggettoProprietarioApplicativoToken(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO_APPLICATIVO_TOKEN.equals(keywordIntegrazione)) {
                            integrazione.setServizioApplicativoToken(TransportUtils.getFirstValue(prop, (String)key));
                            continue block4;
                        }
                        if (!CostantiPdD.HEADER_INTEGRAZIONE_ID_TRANSAZIONE.equals(keywordIntegrazione)) continue block4;
                        integrazione.setIdTransazione(TransportUtils.getFirstValue(prop, (String)key));
                        continue block4;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, lettura dell'header non riuscita: " + e.getMessage(), e);
        }
    }

    public void setUrlProperties(HeaderIntegrazione integrazione, Map<String, List<String>> properties, Map<String, String> protocolInfos) throws HeaderIntegrazioneException {
        try {
            if (properties != null && integrazione != null) {
                if (integrazione.getBusta() != null) {
                    if (integrazione.getBusta().getTipoMittente() != null && this.keySetEnabled_HeaderIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_MITTENTE).booleanValue()) {
                        TransportUtils.setParameter(properties, (String)this.keyValueIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_MITTENTE), (String)integrazione.getBusta().getTipoMittente());
                    }
                    if (integrazione.getBusta().getMittente() != null && this.keySetEnabled_HeaderIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_MITTENTE).booleanValue()) {
                        TransportUtils.setParameter(properties, (String)this.keyValueIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_MITTENTE), (String)integrazione.getBusta().getMittente());
                    }
                    if (integrazione.getBusta().getTipoDestinatario() != null && this.keySetEnabled_HeaderIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_DESTINATARIO).booleanValue()) {
                        TransportUtils.setParameter(properties, (String)this.keyValueIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_DESTINATARIO), (String)integrazione.getBusta().getTipoDestinatario());
                    }
                    if (integrazione.getBusta().getDestinatario() != null && this.keySetEnabled_HeaderIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_DESTINATARIO).booleanValue()) {
                        TransportUtils.setParameter(properties, (String)this.keyValueIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_DESTINATARIO), (String)integrazione.getBusta().getDestinatario());
                    }
                    if (integrazione.getBusta().getTipoServizio() != null && this.keySetEnabled_HeaderIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_SERVIZIO).booleanValue()) {
                        TransportUtils.setParameter(properties, (String)this.keyValueIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_SERVIZIO), (String)integrazione.getBusta().getTipoServizio());
                    }
                    if (integrazione.getBusta().getServizio() != null && this.keySetEnabled_HeaderIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO).booleanValue()) {
                        TransportUtils.setParameter(properties, (String)this.keyValueIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO), (String)integrazione.getBusta().getServizio());
                    }
                    if (integrazione.getBusta().getVersioneServizio() != null && this.keySetEnabled_HeaderIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_VERSIONE_SERVIZIO).booleanValue()) {
                        TransportUtils.setParameter(properties, (String)this.keyValueIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_VERSIONE_SERVIZIO), (String)("" + integrazione.getBusta().getVersioneServizio()));
                    }
                    if (integrazione.getBusta().getAzione() != null && this.keySetEnabled_HeaderIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_AZIONE).booleanValue()) {
                        TransportUtils.setParameter(properties, (String)this.keyValueIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_AZIONE), (String)integrazione.getBusta().getAzione());
                    }
                    if (integrazione.getBusta().getID() != null && this.keySetEnabled_HeaderIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_MESSAGGIO).booleanValue()) {
                        TransportUtils.setParameter(properties, (String)this.keyValueIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_MESSAGGIO), (String)integrazione.getBusta().getID());
                    }
                    if (integrazione.getBusta().getRiferimentoMessaggio() != null && this.keySetEnabled_HeaderIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_RIFERIMENTO_MESSAGGIO).booleanValue()) {
                        TransportUtils.setParameter(properties, (String)this.keyValueIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_RIFERIMENTO_MESSAGGIO), (String)integrazione.getBusta().getRiferimentoMessaggio());
                    }
                    if (integrazione.getBusta().getIdCollaborazione() != null && this.keySetEnabled_HeaderIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_COLLABORAZIONE).booleanValue()) {
                        TransportUtils.setParameter(properties, (String)this.keyValueIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_COLLABORAZIONE), (String)integrazione.getBusta().getIdCollaborazione());
                    }
                }
                if (integrazione.getIdApplicativo() != null && this.keySetEnabled_HeaderIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_APPLICATIVO).booleanValue()) {
                    TransportUtils.setParameter(properties, (String)this.keyValueIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_APPLICATIVO), (String)integrazione.getIdApplicativo());
                }
                if (integrazione.getServizioApplicativo() != null && this.keySetEnabled_HeaderIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO_APPLICATIVO).booleanValue()) {
                    TransportUtils.setParameter(properties, (String)this.keyValueIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO_APPLICATIVO), (String)integrazione.getServizioApplicativo());
                }
                if (integrazione.getTipoSoggettoProprietarioApplicativoToken() != null && this.keySetEnabled_HeaderIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_MITTENTE_TOKEN).booleanValue()) {
                    TransportUtils.setParameter(properties, (String)this.keyValueIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_MITTENTE_TOKEN), (String)integrazione.getTipoSoggettoProprietarioApplicativoToken());
                }
                if (integrazione.getNomeSoggettoProprietarioApplicativoToken() != null && this.keySetEnabled_HeaderIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_MITTENTE_TOKEN).booleanValue()) {
                    TransportUtils.setParameter(properties, (String)this.keyValueIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_MITTENTE_TOKEN), (String)integrazione.getNomeSoggettoProprietarioApplicativoToken());
                }
                if (integrazione.getServizioApplicativoToken() != null && this.keySetEnabled_HeaderIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO_APPLICATIVO_TOKEN).booleanValue()) {
                    TransportUtils.setParameter(properties, (String)this.keyValueIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO_APPLICATIVO_TOKEN), (String)integrazione.getServizioApplicativoToken());
                }
                if (integrazione.getIdTransazione() != null && this.keySetEnabled_HeaderIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_TRANSAZIONE).booleanValue()) {
                    TransportUtils.setParameter(properties, (String)this.keyValueIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_TRANSAZIONE), (String)integrazione.getIdTransazione());
                }
            }
            if (properties != null) {
                if (this.keySetEnabled_HeaderIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_INFO).booleanValue()) {
                    TransportUtils.setParameter(properties, (String)"version", (String)this.openspcoopProperties.getHttpServer());
                    if (this.openspcoopProperties.getHttpXPdDDetails() != null && !"".equals(this.openspcoopProperties.getHttpXPdDDetails())) {
                        TransportUtils.setParameter(properties, (String)"version_info", (String)this.openspcoopProperties.getHttpXPdDDetails());
                    }
                }
                if (this.keySetEnabled_HeaderIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_PROTOCOL_INFO).booleanValue() && protocolInfos != null && protocolInfos.size() > 0) {
                    String prefixProtocolInfo = this.keyValueIntegrazioneUrlBased.get(CostantiPdD.HEADER_INTEGRAZIONE_PROTOCOL_INFO);
                    for (String name : protocolInfos.keySet()) {
                        String value = protocolInfos.get(name);
                        String nameWithPrefix = prefixProtocolInfo != null ? prefixProtocolInfo.trim() + name : name;
                        TransportUtils.setParameter(properties, (String)nameWithPrefix, (String)value);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, creazione delle proprieta' dell'header non riuscita: " + e.getMessage(), e);
        }
    }

    public void setSecurityHeaders(ServiceBinding serviceBinding, RequestInfo requestInfo, Map<String, List<String>> properties, OpenSPCoop2MessageProperties forwardHeader) throws HeaderIntegrazioneException {
        try {
            List proprieta = null;
            if (requestInfo != null && requestInfo.getProtocolContext() != null && requestInfo.getProtocolContext().getInterfaceName() != null) {
                if (this.portaDelegata) {
                    IDPortaDelegata idPD = new IDPortaDelegata();
                    idPD.setNome(requestInfo.getProtocolContext().getInterfaceName());
                    PortaDelegata pd = ConfigurazionePdDManager.getInstance(null).getPortaDelegataSafeMethod(idPD, requestInfo);
                    if (pd != null) {
                        proprieta = pd.getProprietaList();
                    }
                } else {
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setNome(requestInfo.getProtocolContext().getInterfaceName());
                    PortaApplicativa pa = ConfigurazionePdDManager.getInstance(null).getPortaApplicativaSafeMethod(idPA, requestInfo);
                    if (pa != null) {
                        proprieta = pa.getProprietaList();
                    }
                }
            }
            boolean enabled = false;
            enabled = this.portaDelegata ? (ServiceBinding.REST.equals((Object)serviceBinding) ? this.openspcoopProperties.isRESTServices_inoltroBuste_response_securityHeaders() : this.openspcoopProperties.isSOAPServices_inoltroBuste_response_securityHeaders()) : (ServiceBinding.REST.equals((Object)serviceBinding) ? this.openspcoopProperties.isRESTServices_consegnaContenutiApplicativi_response_securityHeaders() : this.openspcoopProperties.isSOAPServices_consegnaContenutiApplicativi_response_securityHeaders());
            enabled = CostantiProprieta.isSecurityHeadersEnabled(proprieta, enabled);
            if (enabled) {
                Properties pDefault = null;
                pDefault = this.portaDelegata ? (ServiceBinding.REST.equals((Object)serviceBinding) ? this.openspcoopProperties.getRESTServices_inoltroBuste_response_securityHeaders() : this.openspcoopProperties.getSOAPServices_inoltroBuste_response_securityHeaders()) : (ServiceBinding.REST.equals((Object)serviceBinding) ? this.openspcoopProperties.getRESTServices_consegnaContenutiApplicativi_response_securityHeaders() : this.openspcoopProperties.getSOAPServices_consegnaContenutiApplicativi_response_securityHeaders());
                Map<String, String> securityHeaders = CostantiProprieta.getSecurityHeaders(proprieta, pDefault);
                if (securityHeaders != null && !securityHeaders.isEmpty()) {
                    boolean headerCachePresenteRispostaBackend = false;
                    for (String hdrName : securityHeaders.keySet()) {
                        if (!HttpConstants.isCacheStatusHeader((String)hdrName) || !TransportUtils.containsKey(properties, (String)hdrName) && (forwardHeader == null || !forwardHeader.containsKey(hdrName))) continue;
                        headerCachePresenteRispostaBackend = true;
                        break;
                    }
                    for (String hdrName : securityHeaders.keySet()) {
                        String hdrValue;
                        if (HttpConstants.isCacheStatusHeader((String)hdrName) && headerCachePresenteRispostaBackend || TransportUtils.containsKey(properties, (String)hdrName) || forwardHeader != null && forwardHeader.containsKey(hdrName) || (hdrValue = securityHeaders.get(hdrName)) == null) continue;
                        TransportUtils.setHeader(properties, (String)hdrName, (String)hdrValue);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, creazione securityHeaders non riuscita: " + e.getMessage(), e);
        }
    }

    public void setInfoProductTransportProperties(Map<String, List<String>> properties) throws HeaderIntegrazioneException {
        this.setTransportProperties(null, properties, null);
    }

    public void setTransportProperties(HeaderIntegrazione integrazione, Map<String, List<String>> properties, Map<String, String> protocolInfos) throws HeaderIntegrazioneException {
        try {
            if (properties != null && integrazione != null) {
                if (integrazione.getBusta() != null) {
                    if (integrazione.getBusta().getTipoMittente() != null && this.keySetEnabled_HeaderIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_MITTENTE).booleanValue()) {
                        TransportUtils.setHeader(properties, (String)this.keyValueIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_MITTENTE), (String)integrazione.getBusta().getTipoMittente());
                    }
                    if (integrazione.getBusta().getMittente() != null && this.keySetEnabled_HeaderIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_MITTENTE).booleanValue()) {
                        TransportUtils.setHeader(properties, (String)this.keyValueIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_MITTENTE), (String)integrazione.getBusta().getMittente());
                    }
                    if (integrazione.getBusta().getTipoDestinatario() != null && this.keySetEnabled_HeaderIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_DESTINATARIO).booleanValue()) {
                        TransportUtils.setHeader(properties, (String)this.keyValueIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_DESTINATARIO), (String)integrazione.getBusta().getTipoDestinatario());
                    }
                    if (integrazione.getBusta().getDestinatario() != null && this.keySetEnabled_HeaderIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_DESTINATARIO).booleanValue()) {
                        TransportUtils.setHeader(properties, (String)this.keyValueIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_DESTINATARIO), (String)integrazione.getBusta().getDestinatario());
                    }
                    if (integrazione.getBusta().getTipoServizio() != null && this.keySetEnabled_HeaderIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_SERVIZIO).booleanValue()) {
                        TransportUtils.setHeader(properties, (String)this.keyValueIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_SERVIZIO), (String)integrazione.getBusta().getTipoServizio());
                    }
                    if (integrazione.getBusta().getServizio() != null && this.keySetEnabled_HeaderIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO).booleanValue()) {
                        TransportUtils.setHeader(properties, (String)this.keyValueIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO), (String)integrazione.getBusta().getServizio());
                    }
                    if (integrazione.getBusta().getVersioneServizio() != null && this.keySetEnabled_HeaderIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_VERSIONE_SERVIZIO).booleanValue()) {
                        TransportUtils.setHeader(properties, (String)this.keyValueIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_VERSIONE_SERVIZIO), (String)("" + integrazione.getBusta().getVersioneServizio()));
                    }
                    if (integrazione.getBusta().getAzione() != null && this.keySetEnabled_HeaderIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_AZIONE).booleanValue()) {
                        TransportUtils.setHeader(properties, (String)this.keyValueIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_AZIONE), (String)integrazione.getBusta().getAzione());
                    }
                    if (integrazione.getBusta().getID() != null && this.keySetEnabled_HeaderIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_MESSAGGIO).booleanValue()) {
                        TransportUtils.setHeader(properties, (String)this.keyValueIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_MESSAGGIO), (String)integrazione.getBusta().getID());
                    }
                    if (integrazione.getBusta().getRiferimentoMessaggio() != null && this.keySetEnabled_HeaderIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_RIFERIMENTO_MESSAGGIO).booleanValue()) {
                        TransportUtils.setHeader(properties, (String)this.keyValueIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_RIFERIMENTO_MESSAGGIO), (String)integrazione.getBusta().getRiferimentoMessaggio());
                    }
                    if (integrazione.getBusta().getIdCollaborazione() != null && this.keySetEnabled_HeaderIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_COLLABORAZIONE).booleanValue()) {
                        TransportUtils.setHeader(properties, (String)this.keyValueIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_COLLABORAZIONE), (String)integrazione.getBusta().getIdCollaborazione());
                    }
                }
                if (integrazione.getIdApplicativo() != null && this.keySetEnabled_HeaderIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_APPLICATIVO).booleanValue()) {
                    TransportUtils.setHeader(properties, (String)this.keyValueIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_APPLICATIVO), (String)integrazione.getIdApplicativo());
                }
                if (integrazione.getServizioApplicativo() != null && this.keySetEnabled_HeaderIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO_APPLICATIVO).booleanValue()) {
                    TransportUtils.setHeader(properties, (String)this.keyValueIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO_APPLICATIVO), (String)integrazione.getServizioApplicativo());
                }
                if (integrazione.getTipoSoggettoProprietarioApplicativoToken() != null && this.keySetEnabled_HeaderIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_MITTENTE_TOKEN).booleanValue()) {
                    TransportUtils.setParameter(properties, (String)this.keyValueIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_MITTENTE_TOKEN), (String)integrazione.getTipoSoggettoProprietarioApplicativoToken());
                }
                if (integrazione.getNomeSoggettoProprietarioApplicativoToken() != null && this.keySetEnabled_HeaderIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_MITTENTE_TOKEN).booleanValue()) {
                    TransportUtils.setParameter(properties, (String)this.keyValueIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_MITTENTE_TOKEN), (String)integrazione.getNomeSoggettoProprietarioApplicativoToken());
                }
                if (integrazione.getServizioApplicativoToken() != null && this.keySetEnabled_HeaderIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO_APPLICATIVO_TOKEN).booleanValue()) {
                    TransportUtils.setParameter(properties, (String)this.keyValueIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO_APPLICATIVO_TOKEN), (String)integrazione.getServizioApplicativoToken());
                }
                if (integrazione.getIdTransazione() != null && this.keySetEnabled_HeaderIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_TRANSAZIONE).booleanValue()) {
                    TransportUtils.setHeader(properties, (String)this.keyValueIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_TRANSAZIONE), (String)integrazione.getIdTransazione());
                }
            }
            if (properties != null) {
                boolean userAgent;
                boolean infoProduct = this.keySetEnabled_HeaderIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_INFO);
                if (infoProduct) {
                    if (!properties.containsKey("GovWay-Version")) {
                        TransportUtils.setHeader(properties, (String)"GovWay-Version", (String)this.openspcoopProperties.getHttpServer());
                    }
                    if (this.openspcoopProperties.getHttpXPdDDetails() != null && !"".equals(this.openspcoopProperties.getHttpXPdDDetails()) && !properties.containsKey("GovWay-Version-Info")) {
                        TransportUtils.setHeader(properties, (String)"GovWay-Version-Info", (String)this.openspcoopProperties.getHttpXPdDDetails());
                    }
                }
                if (userAgent = this.keySetEnabled_HeaderIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_USER_AGENT).booleanValue()) {
                    if (this.request) {
                        if (!properties.containsKey("User-Agent")) {
                            TransportUtils.setHeader(properties, (String)"User-Agent", (String)this.openspcoopProperties.getHttpUserAgent());
                        }
                    } else if (!properties.containsKey("Server")) {
                        TransportUtils.setHeader(properties, (String)"Server", (String)this.openspcoopProperties.getHttpUserAgent());
                    }
                }
                if (this.keySetEnabled_HeaderIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_PROTOCOL_INFO).booleanValue() && protocolInfos != null && protocolInfos.size() > 0) {
                    String prefixProtocolInfo = this.keyValueIntegrazioneTrasporto.get(CostantiPdD.HEADER_INTEGRAZIONE_PROTOCOL_INFO);
                    for (String name : protocolInfos.keySet()) {
                        String value = protocolInfos.get(name);
                        String nameWithPrefix = prefixProtocolInfo != null ? prefixProtocolInfo.trim() + name : name;
                        TransportUtils.setHeader(properties, (String)nameWithPrefix, (String)value);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, creazione delle proprieta' dell'header non riuscita: " + e.getMessage(), e);
        }
    }

    public void readHeader(OpenSPCoop2SoapMessage message, HeaderIntegrazione integrazione, String actorIntegrazione) throws HeaderIntegrazioneException {
        try {
            String actorCheck;
            if (actorIntegrazione == null) {
                throw new Exception("Actor non definito");
            }
            SOAPHeader header = message.getSOAPHeader();
            if (header == null) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().debug("SOAPHeader non presente");
                return;
            }
            SOAPHeaderElement headerElement = null;
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext() && !actorIntegrazione.equals(actorCheck = SoapUtils.getSoapActor((SOAPHeaderElement)(headerElement = (SOAPHeaderElement)it.next()), (MessageType)message.getMessageType()))) {
                headerElement = null;
            }
            if (headerElement == null) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().debug("Header di integrazione non presente");
                return;
            }
            if (MessageType.SOAP_11.equals((Object)message.getMessageType())) {
                ValidatoreXSD validatoreXSD_soap11 = this.getValidatoreXSD(false, message.getFactory());
                if (validatoreXSD_soap11 == null) {
                    throw new Exception("Validatore XSD (Soap11) non istanziato");
                }
                validatoreXSD_soap11.valida((InputStream)new ByteArrayInputStream(message.getAsByte((Node)headerElement, false)));
            } else if (MessageType.SOAP_12.equals((Object)message.getMessageType())) {
                ValidatoreXSD validatoreXSD_soap12 = this.getValidatoreXSD(false, message.getFactory());
                if (validatoreXSD_soap12 == null) {
                    throw new Exception("Validatore XSD (Soap12) non istanziato");
                }
                validatoreXSD_soap12.valida((InputStream)new ByteArrayInputStream(message.getAsByte((Node)headerElement, false)));
            } else {
                throw MessageNotSupportedException.newMessageNotSupportedException((MessageType)message.getMessageType());
            }
            String tipoMittente = null;
            try {
                if (this.keyReadEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_MITTENTE).booleanValue()) {
                    tipoMittente = headerElement.getAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_MITTENTE));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tipoMittente != null && tipoMittente.compareTo("") != 0) {
                integrazione.getBusta().setTipoMittente(tipoMittente);
            }
            String mittente = null;
            try {
                if (this.keyReadEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_MITTENTE).booleanValue()) {
                    mittente = headerElement.getAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_MITTENTE));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (mittente != null && mittente.compareTo("") != 0) {
                integrazione.getBusta().setMittente(mittente);
            }
            String tipoDestinatario = null;
            try {
                if (this.keyReadEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_DESTINATARIO).booleanValue()) {
                    tipoDestinatario = headerElement.getAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_DESTINATARIO));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tipoDestinatario != null && tipoDestinatario.compareTo("") != 0) {
                integrazione.getBusta().setTipoDestinatario(tipoDestinatario);
            }
            String destinatario = null;
            try {
                if (this.keyReadEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_DESTINATARIO).booleanValue()) {
                    destinatario = headerElement.getAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_DESTINATARIO));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (destinatario != null && destinatario.compareTo("") != 0) {
                integrazione.getBusta().setDestinatario(destinatario);
            }
            String tipoServizio = null;
            try {
                if (this.keyReadEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_SERVIZIO).booleanValue()) {
                    tipoServizio = headerElement.getAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_SERVIZIO));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tipoServizio != null && tipoServizio.compareTo("") != 0) {
                integrazione.getBusta().setTipoServizio(tipoServizio);
            }
            String servizio = null;
            try {
                if (this.keyReadEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO).booleanValue()) {
                    servizio = headerElement.getAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (servizio != null && servizio.compareTo("") != 0) {
                integrazione.getBusta().setServizio(servizio);
            }
            String versioneServizio = null;
            try {
                if (this.keyReadEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_VERSIONE_SERVIZIO).booleanValue()) {
                    versioneServizio = headerElement.getAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_VERSIONE_SERVIZIO));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (versioneServizio != null && versioneServizio.compareTo("") != 0) {
                try {
                    integrazione.getBusta().setVersioneServizio(Integer.parseInt(versioneServizio));
                }
                catch (Exception e) {
                    throw new Exception("Formato versione [" + versioneServizio + "] non corretto: " + e.getMessage(), e);
                }
            }
            String azione = null;
            try {
                if (this.keyReadEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_AZIONE).booleanValue()) {
                    azione = headerElement.getAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_AZIONE));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (azione != null && azione.compareTo("") != 0) {
                integrazione.getBusta().setAzione(azione);
            }
            String idBusta = null;
            try {
                if (this.keyReadEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_MESSAGGIO).booleanValue()) {
                    idBusta = headerElement.getAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_MESSAGGIO));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (idBusta != null && idBusta.compareTo("") != 0) {
                integrazione.getBusta().setID(idBusta);
            }
            String riferimentoMessaggio = null;
            try {
                if (this.keyReadEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_RIFERIMENTO_MESSAGGIO).booleanValue()) {
                    riferimentoMessaggio = headerElement.getAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_RIFERIMENTO_MESSAGGIO));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (riferimentoMessaggio != null && riferimentoMessaggio.compareTo("") != 0) {
                integrazione.getBusta().setRiferimentoMessaggio(riferimentoMessaggio);
            }
            String collaborazione = null;
            try {
                if (this.keyReadEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_COLLABORAZIONE).booleanValue()) {
                    collaborazione = headerElement.getAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_COLLABORAZIONE));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (collaborazione != null && collaborazione.compareTo("") != 0) {
                integrazione.getBusta().setIdCollaborazione(collaborazione);
            }
            String idApplicativo = null;
            try {
                if (this.keyReadEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_APPLICATIVO).booleanValue()) {
                    idApplicativo = headerElement.getAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_APPLICATIVO));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (idApplicativo != null && idApplicativo.compareTo("") != 0) {
                integrazione.setIdApplicativo(idApplicativo);
            }
            String sa = null;
            try {
                if (this.keyReadEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO_APPLICATIVO).booleanValue()) {
                    sa = headerElement.getAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO_APPLICATIVO));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (sa != null && sa.compareTo("") != 0) {
                integrazione.setServizioApplicativo(sa);
            }
            String tipoMittenteToken = null;
            try {
                if (this.keyReadEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_MITTENTE_TOKEN).booleanValue()) {
                    tipoMittenteToken = headerElement.getAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_MITTENTE_TOKEN));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tipoMittenteToken != null && tipoMittenteToken.compareTo("") != 0) {
                integrazione.setTipoSoggettoProprietarioApplicativoToken(tipoMittenteToken);
            }
            String mittenteToken = null;
            try {
                if (this.keyReadEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_MITTENTE_TOKEN).booleanValue()) {
                    mittenteToken = headerElement.getAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_MITTENTE_TOKEN));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (mittenteToken != null && mittenteToken.compareTo("") != 0) {
                integrazione.setNomeSoggettoProprietarioApplicativoToken(mittenteToken);
            }
            String saToken = null;
            try {
                if (this.keyReadEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO_APPLICATIVO_TOKEN).booleanValue()) {
                    saToken = headerElement.getAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO_APPLICATIVO_TOKEN));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (sa != null && sa.compareTo("") != 0) {
                integrazione.setServizioApplicativoToken(saToken);
            }
            String idTransazione = null;
            try {
                if (this.keyReadEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_TRANSAZIONE).booleanValue()) {
                    idTransazione = headerElement.getAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_TRANSAZIONE));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (idTransazione != null && idTransazione.compareTo("") != 0) {
                integrazione.setIdTransazione(idTransazione);
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, lettura dell'header soap non riuscita: " + e.getMessage(), e);
        }
    }

    public void updateHeader(OpenSPCoop2SoapMessage message, IDSoggetto soggettoFruitore, IDServizio idServizio, String idBusta, String servizioApplicativo, String correlazioneApplicativa, String riferimentoCorrelazioneApplicativaRichiesta, String idTransazione, String actorIntegrazione, String nomeElemento, String prefix, String namespace, String proprietaProtocolloNomeElemento, String proprietaProtocolloNomeTipoElemento, Map<String, String> protocolInfos) throws Exception {
        this.updateHeader(message, soggettoFruitore, idServizio, idBusta, null, servizioApplicativo, correlazioneApplicativa, riferimentoCorrelazioneApplicativaRichiesta, idTransazione, actorIntegrazione, nomeElemento, prefix, namespace, proprietaProtocolloNomeElemento, proprietaProtocolloNomeTipoElemento, protocolInfos);
    }

    public void updateHeader(OpenSPCoop2SoapMessage message, IDSoggetto soggettoFruitore, IDServizio idServizio, String idBusta, String idBustaRisposta, String servizioApplicativo, String correlazioneApplicativa, String riferimentoCorrelazioneApplicativaRichiesta, String idTransazione, String actorIntegrazione, String nomeElemento, String prefix, String namespace, String proprietaProtocolloNomeElemento, String proprietaProtocolloNomeTipoElemento, Map<String, String> protocolInfos) throws Exception {
        HeaderIntegrazione integrazione = new HeaderIntegrazione(idTransazione);
        integrazione.setIdApplicativo(correlazioneApplicativa);
        integrazione.setServizioApplicativo(servizioApplicativo);
        HeaderIntegrazioneBusta busta = new HeaderIntegrazioneBusta();
        busta.setTipoMittente(soggettoFruitore.getTipo());
        busta.setMittente(soggettoFruitore.getNome());
        busta.setTipoDestinatario(idServizio.getSoggettoErogatore().getTipo());
        busta.setDestinatario(idServizio.getSoggettoErogatore().getNome());
        busta.setTipoServizio(idServizio.getTipo());
        busta.setServizio(idServizio.getNome());
        busta.setVersioneServizio(idServizio.getVersione());
        busta.setAzione(idServizio.getAzione());
        if (idBustaRisposta == null) {
            busta.setID(idBusta);
        } else {
            busta.setID(idBustaRisposta);
            busta.setRiferimentoMessaggio(idBusta);
        }
        integrazione.setBusta(busta);
        this.updateHeader(message, integrazione, actorIntegrazione, nomeElemento, prefix, namespace, proprietaProtocolloNomeElemento, proprietaProtocolloNomeTipoElemento, protocolInfos);
    }

    public void updateHeader(OpenSPCoop2SoapMessage message, HeaderIntegrazione integrazione, String actorIntegrazione, String nomeElemento, String prefix, String namespace, String proprietaProtocolloNomeElemento, String proprietaProtocolloNomeTipoElemento, Map<String, String> protocolInfos) throws Exception {
        SOAPElement tmp;
        if (actorIntegrazione == null) {
            throw new Exception("Actor non definito");
        }
        SOAPHeader header = message.getSOAPHeader();
        SOAPHeaderElement headerIntegrazione = null;
        if (header == null) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().debug("SOAPHeader non presente: add soapHeader");
            header = message.getSOAPPart().getEnvelope().addHeader();
        } else {
            String actorCheck;
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext() && !actorIntegrazione.equals(actorCheck = SoapUtils.getSoapActor((SOAPHeaderElement)(headerIntegrazione = (SOAPHeaderElement)it.next()), (MessageType)message.getMessageType()))) {
                headerIntegrazione = null;
            }
            if (headerIntegrazione == null) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().debug("Header di integrazione non presente, lo creo");
            }
        }
        ArrayList<SOAPElement> v = new ArrayList<SOAPElement>();
        if (headerIntegrazione != null) {
            Iterator it = headerIntegrazione.getChildElements();
            if (it.hasNext()) {
                tmp = (SOAPElement)it.next();
                v.add(tmp);
            }
            header.removeChild((Node)headerIntegrazione);
        }
        SOAPHeaderElement headerIntegrazioneNEW = this.buildHeader(integrazione, nomeElemento, prefix, namespace, actorIntegrazione, message, proprietaProtocolloNomeElemento, proprietaProtocolloNomeTipoElemento, protocolInfos);
        while (v.size() > 0) {
            tmp = (SOAPElement)v.remove(0);
            headerIntegrazioneNEW.addChildElement(tmp);
        }
        message.addHeaderElement(header, headerIntegrazioneNEW);
    }

    public SOAPHeaderElement buildHeader(HeaderIntegrazione integrazione, String nomeElemento, String prefix, String namespace, String actor, OpenSPCoop2SoapMessage m, String proprietaProtocolloNomeElemento, String proprietaProtocolloNomeTipoElemento, Map<String, String> protocolInfos) throws HeaderIntegrazioneException {
        try {
            SOAPHeader soapHeader = m.getSOAPHeader();
            if (soapHeader == null) {
                soapHeader = m.getSOAPPart().getEnvelope().addHeader();
            }
            SOAPHeaderElement header = m.newSOAPHeaderElement(soapHeader, new QName(namespace, nomeElemento, prefix));
            header.setActor(actor);
            header.setMustUnderstand(false);
            this.setAttributes(integrazione, header);
            if (this.keySetEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_PROTOCOL_INFO).booleanValue() && protocolInfos != null && protocolInfos.size() > 0) {
                String prefixProtocolInfo = this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_PROTOCOL_INFO);
                for (String name : protocolInfos.keySet()) {
                    String value = protocolInfos.get(name);
                    String nameWithPrefix = prefixProtocolInfo != null ? prefixProtocolInfo.trim() + name : name;
                    SOAPElement element = header.addChildElement(new QName(namespace, proprietaProtocolloNomeElemento, prefix));
                    element.setTextContent(value);
                    SOAPElement sOAPElement = element.addAttribute(new QName(proprietaProtocolloNomeTipoElemento), nameWithPrefix);
                }
            }
            return header;
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, creazione dell'header soap non riuscita: " + e.getMessage(), e);
        }
    }

    public void setAttributes(HeaderIntegrazione integrazione, SOAPHeaderElement header) {
        if (integrazione.getBusta() != null) {
            if (integrazione.getBusta().getTipoMittente() != null && this.keySetEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_MITTENTE).booleanValue()) {
                header.setAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_MITTENTE), integrazione.getBusta().getTipoMittente());
            }
            if (integrazione.getBusta().getMittente() != null && this.keySetEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_MITTENTE).booleanValue()) {
                header.setAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_MITTENTE), integrazione.getBusta().getMittente());
            }
            if (integrazione.getBusta().getTipoDestinatario() != null && this.keySetEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_DESTINATARIO).booleanValue()) {
                header.setAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_DESTINATARIO), integrazione.getBusta().getTipoDestinatario());
            }
            if (integrazione.getBusta().getDestinatario() != null && this.keySetEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_DESTINATARIO).booleanValue()) {
                header.setAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_DESTINATARIO), integrazione.getBusta().getDestinatario());
            }
            if (integrazione.getBusta().getTipoServizio() != null && this.keySetEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_SERVIZIO).booleanValue()) {
                header.setAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_SERVIZIO), integrazione.getBusta().getTipoServizio());
            }
            if (integrazione.getBusta().getServizio() != null && this.keySetEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO).booleanValue()) {
                header.setAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO), integrazione.getBusta().getServizio());
            }
            if (integrazione.getBusta().getVersioneServizio() != null && this.keySetEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_VERSIONE_SERVIZIO).booleanValue()) {
                header.setAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_VERSIONE_SERVIZIO), "" + integrazione.getBusta().getVersioneServizio());
            }
            if (integrazione.getBusta().getAzione() != null && this.keySetEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_AZIONE).booleanValue()) {
                header.setAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_AZIONE), integrazione.getBusta().getAzione());
            }
            if (integrazione.getBusta().getID() != null && this.keySetEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_MESSAGGIO).booleanValue()) {
                header.setAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_MESSAGGIO), integrazione.getBusta().getID());
            }
            if (integrazione.getBusta().getRiferimentoMessaggio() != null && this.keySetEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_RIFERIMENTO_MESSAGGIO).booleanValue()) {
                header.setAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_RIFERIMENTO_MESSAGGIO), integrazione.getBusta().getRiferimentoMessaggio());
            }
            if (integrazione.getBusta().getIdCollaborazione() != null && this.keySetEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_COLLABORAZIONE).booleanValue()) {
                header.setAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_COLLABORAZIONE), integrazione.getBusta().getIdCollaborazione());
            }
        }
        if (integrazione.getIdApplicativo() != null && this.keySetEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_APPLICATIVO).booleanValue()) {
            header.setAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_APPLICATIVO), integrazione.getIdApplicativo());
        }
        if (integrazione.getServizioApplicativo() != null && this.keySetEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO_APPLICATIVO).booleanValue()) {
            header.setAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO_APPLICATIVO), integrazione.getServizioApplicativo());
        }
        if (integrazione.getTipoSoggettoProprietarioApplicativoToken() != null && this.keySetEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_MITTENTE_TOKEN).booleanValue()) {
            header.setAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_MITTENTE_TOKEN), integrazione.getTipoSoggettoProprietarioApplicativoToken());
        }
        if (integrazione.getNomeSoggettoProprietarioApplicativoToken() != null && this.keySetEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_MITTENTE_TOKEN).booleanValue()) {
            header.setAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_MITTENTE_TOKEN), integrazione.getNomeSoggettoProprietarioApplicativoToken());
        }
        if (integrazione.getServizioApplicativoToken() != null && this.keySetEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO_APPLICATIVO_TOKEN).booleanValue()) {
            header.setAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO_APPLICATIVO_TOKEN), integrazione.getServizioApplicativoToken());
        }
        if (integrazione.getIdTransazione() != null && this.keySetEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_TRANSAZIONE).booleanValue()) {
            header.setAttribute(this.keyValueIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_TRANSAZIONE), integrazione.getIdTransazione());
        }
        if (this.keySetEnabled_HeaderIntegrazioneSoap.get(CostantiPdD.HEADER_INTEGRAZIONE_INFO).booleanValue()) {
            header.setAttribute("version", this.openspcoopProperties.getHeaderIntegrazioneSOAPPdDVersione());
            if (this.openspcoopProperties.getHeaderIntegrazioneSOAPPdDDetails() != null && !"".equals(this.openspcoopProperties.getHeaderIntegrazioneSOAPPdDDetails())) {
                header.setAttribute("versionInfo", this.openspcoopProperties.getHeaderIntegrazioneSOAPPdDDetails());
            }
        }
    }

    public void deleteHeader(OpenSPCoop2SoapMessage message, String actorIntegrazione) throws HeaderIntegrazioneException {
        try {
            String actorCheck;
            if (actorIntegrazione == null) {
                throw new Exception("Actor non definito");
            }
            SOAPHeader header = message.getSOAPHeader();
            if (header == null) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().debug("SOAPHeader non presente");
                return;
            }
            SOAPHeaderElement headerElement = null;
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext() && !actorIntegrazione.equals(actorCheck = SoapUtils.getSoapActor((SOAPHeaderElement)(headerElement = (SOAPHeaderElement)it.next()), (MessageType)message.getMessageType()))) {
                headerElement = null;
            }
            if (headerElement == null) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().debug("Header di integrazione non presente");
                return;
            }
            header.removeChild((Node)headerElement);
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, eliminazione dell'header soap non riuscita: " + e.getMessage(), e);
        }
    }

    public static String getIdTransazione(PdDContext context) {
        if (context != null) {
            return (String)context.getObject(Costanti.ID_TRANSAZIONE);
        }
        return null;
    }
}

