/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.integrazione;

import java.util.Iterator;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.soap.wsaddressing.WSAddressingHeader;
import org.openspcoop2.message.soap.wsaddressing.WSAddressingUtilities;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneBusta;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.slf4j.Logger;

public class UtilitiesIntegrazioneWSAddressing {
    private static final String WSA_TO_FORMAT = "http://<providerType>_<provider>.govway.org/services/<serviceType>_<service>/<serviceVersion>";
    private static final String WSA_FROM_FORMAT = "http://[<application>.]<senderType>_<sender>.govway.org";
    private static final String WSA_ACTION_FORMAT = "http://<providerType>_<provider>.govway.org/services/<serviceType>_<service>/<serviceVersion>/<action>";
    private static final String WSA_ID_FORMAT = "uuid:<id>";
    private static final String WSA_RELATES_TO_FORMAT = "uuid:<id>";
    public static final boolean INTERPRETA_COME_ID_BUSTA = true;
    public static final boolean INTERPRETA_COME_ID_APPLICATIVO = false;
    private static final boolean MUST_UNDERSTAND = false;
    private static UtilitiesIntegrazioneWSAddressing utilitiesIntegrazione = null;

    public static void _readDatiWSAToOrAction(String wsaValue, String format, HeaderIntegrazione integrazione) throws HeaderIntegrazioneException {
        int indexVersioneServizio;
        String servizio;
        int indexSoggetto;
        String type = null;
        boolean action = false;
        if (WSA_TO_FORMAT.equals(format)) {
            type = "WSAddressingTo";
        } else if (WSA_ACTION_FORMAT.equals(format)) {
            type = "WSAddressingAction";
            action = true;
        } else {
            throw new HeaderIntegrazioneException("Format [" + format + "] Not Supported");
        }
        if (wsaValue == null) {
            throw new HeaderIntegrazioneException(type + " value is null");
        }
        if (!(wsaValue = wsaValue.trim()).startsWith("http://")) {
            throw new HeaderIntegrazioneException(type + " Value is not valid: " + format);
        }
        if (!wsaValue.contains(".govway.org/services/")) {
            throw new HeaderIntegrazioneException(type + " Value is not valid: " + format);
        }
        String soggetto = (wsaValue = wsaValue.substring(7, wsaValue.length())).substring(0, indexSoggetto = wsaValue.indexOf(".govway.org/services/"));
        if (soggetto == null) {
            throw new HeaderIntegrazioneException(type + " Value is not valid (Soggetto non identificabile): " + format);
        }
        if (!soggetto.contains("_")) {
            throw new HeaderIntegrazioneException(type + " Value is not valid (Soggetto non identificabile, '_' non trovato ): " + format);
        }
        String[] soggetto_split = soggetto.split("_");
        if (soggetto_split == null || soggetto_split.length < 2) {
            throw new HeaderIntegrazioneException(type + " Value is not valid (Soggetto non identificabile, formato errato ): " + format);
        }
        String tipoSoggetto = soggetto_split[0];
        if (tipoSoggetto != null) {
            tipoSoggetto = tipoSoggetto.trim();
        }
        if (tipoSoggetto == null || "".equals(tipoSoggetto)) {
            throw new HeaderIntegrazioneException(type + " Value is not valid (TipoSoggetto non identificabile): " + format);
        }
        String nomeSoggetto = soggetto.substring((tipoSoggetto + "_").length());
        if (nomeSoggetto != null) {
            nomeSoggetto = nomeSoggetto.trim();
        }
        if (nomeSoggetto == null || "".equals(nomeSoggetto)) {
            throw new HeaderIntegrazioneException(type + " Value is not valid (NomeSoggetto non identificabile): " + format);
        }
        if (!action) {
            integrazione.getBusta().setTipoDestinatario(tipoSoggetto);
            integrazione.getBusta().setDestinatario(nomeSoggetto);
        }
        if ((servizio = wsaValue.substring(indexSoggetto + ".govway.org/services/".length(), wsaValue.length())) == null) {
            throw new HeaderIntegrazioneException(type + " Value is not valid (Servizio non identificabile): " + format);
        }
        if (!servizio.contains("_")) {
            throw new HeaderIntegrazioneException(type + " Value is not valid (Servizio non identificabile, '_' non trovato ): " + format);
        }
        String[] servizio_split = servizio.split("_");
        if (servizio_split == null || servizio_split.length < 2) {
            throw new HeaderIntegrazioneException(type + " Value is not valid (Servizio non identificabile, formato errato ): " + format);
        }
        String tipoServizio = servizio_split[0];
        if (tipoServizio != null) {
            tipoServizio = tipoServizio.trim();
        }
        if (tipoServizio == null || "".equals(tipoServizio)) {
            throw new HeaderIntegrazioneException(type + " Value is not valid (TipoServizio non identificabile): " + format);
        }
        String nomeVersioneServizio = servizio.substring((tipoServizio + "_").length());
        if (nomeVersioneServizio != null) {
            nomeVersioneServizio = nomeVersioneServizio.trim();
        }
        if (nomeVersioneServizio == null || "".equals(nomeVersioneServizio)) {
            throw new HeaderIntegrazioneException(type + " Value is not valid (Nome e VersioneServizio non identificabile): " + format);
        }
        if (!nomeVersioneServizio.contains("/")) {
            throw new HeaderIntegrazioneException(type + " Value is not valid (Nome e VersioneServizio non identificabile, '/' non trovato ): " + format);
        }
        if (action) {
            int indexAzione = nomeVersioneServizio.lastIndexOf("/");
            if (indexAzione <= 0) {
                throw new HeaderIntegrazioneException(type + " Value is not valid (Azione non identificabile, '/' non trovato, index(" + indexAzione + ") ): " + format);
            }
            String azione = nomeVersioneServizio.substring(indexAzione + 1);
            if (azione != null) {
                azione = azione.trim();
            }
            if (azione == null || "".equals(azione)) {
                throw new HeaderIntegrazioneException(type + " Value is not valid (Azione non identificabile): " + format);
            }
            integrazione.getBusta().setAzione(azione);
            nomeVersioneServizio = nomeVersioneServizio.substring(0, indexAzione);
            if (nomeVersioneServizio != null) {
                nomeVersioneServizio = nomeVersioneServizio.trim();
            }
            if (nomeVersioneServizio == null || "".equals(nomeVersioneServizio)) {
                throw new HeaderIntegrazioneException(type + " Value is not valid (Nome e VersioneServizio non identificabile non identificabile prima dell'Azione): " + format);
            }
        }
        if ((indexVersioneServizio = nomeVersioneServizio.lastIndexOf("/")) <= 0) {
            throw new HeaderIntegrazioneException(type + " Value is not valid (VersioneServizio non identificabile, '/' non trovato, index(" + indexVersioneServizio + ") ): " + format);
        }
        String nomeServizio = nomeVersioneServizio.substring(0, indexVersioneServizio);
        if (nomeServizio != null) {
            nomeServizio = nomeServizio.trim();
        }
        if (nomeServizio == null || "".equals(nomeServizio)) {
            throw new HeaderIntegrazioneException(type + " Value is not valid (NomeServizio non identificabile): " + format);
        }
        String tmpVersioneServizio = nomeVersioneServizio.substring(indexVersioneServizio + 1);
        if (tmpVersioneServizio != null) {
            tmpVersioneServizio = tmpVersioneServizio.trim();
        }
        if (tmpVersioneServizio == null || "".equals(tmpVersioneServizio)) {
            throw new HeaderIntegrazioneException(type + " Value is not valid (VersioneServizio non identificabile): " + format);
        }
        Integer versioneServizio = null;
        try {
            versioneServizio = Integer.parseInt(tmpVersioneServizio);
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException(type + " Value is not valid (VersioneServizio non identificabile, formato errato " + e.getMessage() + "): " + format);
        }
        if (!action) {
            integrazione.getBusta().setTipoServizio(tipoServizio);
            integrazione.getBusta().setServizio(nomeServizio);
            integrazione.getBusta().setVersioneServizio(versioneServizio);
        }
    }

    public static void readDatiWSATo(String wsaTO, HeaderIntegrazione integrazione) throws HeaderIntegrazioneException {
        UtilitiesIntegrazioneWSAddressing._readDatiWSAToOrAction(wsaTO, WSA_TO_FORMAT, integrazione);
    }

    public static String buildDatiWSATo(String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio) {
        return "http://" + tipoSoggettoErogatore + "_" + nomeSoggettoErogatore + ".govway.org/services/" + tipoServizio + "_" + nomeServizio + "/" + versioneServizio;
    }

    public static SOAPHeaderElement buildWSATo(OpenSPCoop2SoapMessage msg, String actor, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio) throws Exception {
        return WSAddressingUtilities.buildWSATo((OpenSPCoop2SoapMessage)msg, (String)actor, (boolean)false, (String)UtilitiesIntegrazioneWSAddressing.buildDatiWSATo(tipoSoggettoErogatore, nomeSoggettoErogatore, tipoServizio, nomeServizio, versioneServizio));
    }

    public static void readDatiWSAFrom(String wsaFrom, HeaderIntegrazione integrazione) throws HeaderIntegrazioneException {
        int indexSoggetto;
        if (wsaFrom == null) {
            throw new HeaderIntegrazioneException("WSAFrom value is null");
        }
        if (!(wsaFrom = wsaFrom.trim()).startsWith("http://")) {
            throw new HeaderIntegrazioneException("WSAFrom Value is not valid: http://[<application>.]<senderType>_<sender>.govway.org");
        }
        if (!wsaFrom.contains(".govway.org")) {
            throw new HeaderIntegrazioneException("WSAFrom Value is not valid: http://[<application>.]<senderType>_<sender>.govway.org");
        }
        String soggetto = (wsaFrom = wsaFrom.substring(7, wsaFrom.length())).substring(0, indexSoggetto = wsaFrom.indexOf(".govway.org"));
        if (soggetto == null) {
            throw new HeaderIntegrazioneException("WSAFrom Value is not valid (Soggetto non identificabile): http://[<application>.]<senderType>_<sender>.govway.org");
        }
        if (!soggetto.contains("_")) {
            throw new HeaderIntegrazioneException("WSAFrom Value is not valid (Soggetto non identificabile, '_' non trovato ): http://[<application>.]<senderType>_<sender>.govway.org");
        }
        String[] soggetto_split = soggetto.split("_");
        if (soggetto_split == null || soggetto_split.length < 2) {
            throw new HeaderIntegrazioneException("WSAFrom Value is not valid (Soggetto non identificabile, formato errato ): http://[<application>.]<senderType>_<sender>.govway.org");
        }
        String tipoSoggetto = soggetto_split[0];
        if (tipoSoggetto != null) {
            tipoSoggetto = tipoSoggetto.trim();
        }
        if (tipoSoggetto == null || "".equals(tipoSoggetto)) {
            throw new HeaderIntegrazioneException("WSAFrom Value is not valid (TipoSoggetto non identificabile): http://[<application>.]<senderType>_<sender>.govway.org");
        }
        String nomeSoggetto = soggetto.substring((tipoSoggetto + "_").length());
        if (nomeSoggetto != null) {
            nomeSoggetto = nomeSoggetto.trim();
        }
        if (nomeSoggetto == null || "".equals(nomeSoggetto)) {
            throw new HeaderIntegrazioneException("WSAFrom Value is not valid (NomeSoggetto non identificabile): http://[<application>.]<senderType>_<sender>.govway.org");
        }
        if (tipoSoggetto.contains(".")) {
            String[] split = tipoSoggetto.split("\\.");
            tipoSoggetto = split[1];
            String sa = split[0];
            if (tipoSoggetto == null) {
                throw new HeaderIntegrazioneException("WSAFrom Value is not valid (TipoSoggetto non identificabile dopo parsing ServizioApplicativo): http://[<application>.]<senderType>_<sender>.govway.org");
            }
            if (sa == null) {
                throw new HeaderIntegrazioneException("WSAFrom Value is not valid (ServizioApplicativo non identificabile): http://[<application>.]<senderType>_<sender>.govway.org");
            }
            tipoSoggetto = tipoSoggetto.trim();
            sa = sa.trim();
            integrazione.setServizioApplicativo(sa);
        }
        integrazione.getBusta().setTipoMittente(tipoSoggetto);
        integrazione.getBusta().setMittente(nomeSoggetto);
    }

    public static String buildDatiWSAFrom(String servizioApplicativoFruitore, String tipoSoggetto, String nomeSoggetto) {
        if (servizioApplicativoFruitore == null) {
            return "http://" + tipoSoggetto + "_" + nomeSoggetto + ".govway.org";
        }
        return "http://" + servizioApplicativoFruitore + "." + tipoSoggetto + "_" + nomeSoggetto + ".govway.org";
    }

    public static SOAPHeaderElement buildWSAFrom(OpenSPCoop2SoapMessage msg, String actor, String servizioApplicativoFruitore, String tipoSoggetto, String nomeSoggetto) throws Exception {
        return WSAddressingUtilities.buildWSAFrom((OpenSPCoop2SoapMessage)msg, (String)actor, (boolean)false, (String)UtilitiesIntegrazioneWSAddressing.buildDatiWSAFrom(servizioApplicativoFruitore, tipoSoggetto, nomeSoggetto));
    }

    public static void readDatiWSAAction(String wsaAction, HeaderIntegrazione integrazione) throws HeaderIntegrazioneException {
        UtilitiesIntegrazioneWSAddressing._readDatiWSAToOrAction(wsaAction, WSA_ACTION_FORMAT, integrazione);
    }

    public static String buildDatiWSAAction(String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, String azione) {
        return "http://" + tipoSoggettoErogatore + "_" + nomeSoggettoErogatore + ".govway.org/services/" + tipoServizio + "_" + nomeServizio + "/" + versioneServizio + "/" + azione;
    }

    public static SOAPHeaderElement buildWSAAction(OpenSPCoop2SoapMessage msg, String actor, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, String azione) throws Exception {
        return WSAddressingUtilities.buildWSAAction((OpenSPCoop2SoapMessage)msg, (String)actor, (boolean)false, (String)UtilitiesIntegrazioneWSAddressing.buildDatiWSAAction(tipoSoggettoErogatore, nomeSoggettoErogatore, tipoServizio, nomeServizio, versioneServizio, azione));
    }

    public static void readDatiWSAID(String wsaID, HeaderIntegrazione integrazione, boolean interpretaComeIDBusta) throws HeaderIntegrazioneException {
        if (wsaID == null) {
            throw new HeaderIntegrazioneException("WSAID value is null");
        }
        if (!(wsaID = wsaID.trim()).startsWith("uuid:")) {
            throw new HeaderIntegrazioneException("WSAID Value is not valid: uuid:<id>");
        }
        wsaID = wsaID.substring(5, wsaID.length());
        if (interpretaComeIDBusta) {
            integrazione.getBusta().setID(wsaID);
        } else {
            integrazione.setIdApplicativo(wsaID);
        }
    }

    public static String buildDatiWSAID(String id) {
        return "uuid:" + id;
    }

    public static SOAPHeaderElement buildWSAID(OpenSPCoop2SoapMessage msg, String actor, String wsaID) throws Exception {
        return WSAddressingUtilities.buildWSAID((OpenSPCoop2SoapMessage)msg, (String)actor, (boolean)false, (String)UtilitiesIntegrazioneWSAddressing.buildDatiWSAID(wsaID));
    }

    public static void readDatiWSARelatesTo(String wsaRelatesTo, HeaderIntegrazione integrazione) throws HeaderIntegrazioneException {
        if (wsaRelatesTo == null) {
            throw new HeaderIntegrazioneException("WSARelatesTo value is null");
        }
        if (!(wsaRelatesTo = wsaRelatesTo.trim()).startsWith("uuid:")) {
            throw new HeaderIntegrazioneException("WSARelatesTo Value is not valid: uuid:<id>");
        }
        wsaRelatesTo = wsaRelatesTo.substring(5, wsaRelatesTo.length());
        integrazione.getBusta().setRiferimentoMessaggio(wsaRelatesTo);
    }

    public static String buildDatiWSARelatesTo(String id) {
        return "uuid:" + id;
    }

    public static SOAPHeaderElement buildWSARelatesTo(OpenSPCoop2SoapMessage msg, String actor, String id) throws Exception {
        return WSAddressingUtilities.buildWSARelatesTo((OpenSPCoop2SoapMessage)msg, (String)actor, (boolean)false, (String)UtilitiesIntegrazioneWSAddressing.buildDatiWSARelatesTo(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UtilitiesIntegrazioneWSAddressing getInstance(Logger log) {
        if (utilitiesIntegrazione != null) return utilitiesIntegrazione;
        Class<UtilitiesIntegrazioneWSAddressing> clazz = UtilitiesIntegrazioneWSAddressing.class;
        synchronized (UtilitiesIntegrazioneWSAddressing.class) {
            UtilitiesIntegrazioneWSAddressing.initialize(log);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return utilitiesIntegrazione;
        }
    }

    private static synchronized void initialize(Logger log) {
        if (utilitiesIntegrazione == null) {
            utilitiesIntegrazione = new UtilitiesIntegrazioneWSAddressing(log);
        }
    }

    private UtilitiesIntegrazioneWSAddressing(Logger log) {
        if (log != null) {
            // empty if block
        }
    }

    public void readHeader(OpenSPCoop2SoapMessage message, HeaderIntegrazione integrazione, boolean interpretaIDComeIDBusta, String actorIntegrazione) throws HeaderIntegrazioneException {
        try {
            if (actorIntegrazione == null) {
                throw new Exception("Actor non definito");
            }
            Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            SOAPHeader header = message.getSOAPHeader();
            if (header == null) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().debug("SOAPHeader non presente");
                return;
            }
            SOAPHeaderElement wsaTO = null;
            SOAPHeaderElement wsaFROM = null;
            SOAPHeaderElement wsaAction = null;
            SOAPHeaderElement wsaID = null;
            SOAPHeaderElement wsaRelatesTo = null;
            WSAddressingUtilities wsaddressingUtilities = new WSAddressingUtilities(log);
            WSAddressingHeader hdrReaded = wsaddressingUtilities.read(message, actorIntegrazione, false);
            if (hdrReaded != null) {
                wsaTO = hdrReaded.getTo();
                wsaFROM = hdrReaded.getFrom();
                wsaAction = hdrReaded.getAction();
                wsaID = hdrReaded.getId();
                wsaRelatesTo = hdrReaded.getRelatesTo();
            }
            if (wsaTO == null && wsaFROM == null && wsaAction == null && wsaID == null && wsaRelatesTo == null) {
                log.debug("Header di integrazione non presente");
                return;
            }
            log.debug("Validazione XSD...");
            wsaddressingUtilities.validate(message, hdrReaded);
            log.debug("Validazione XSD effettuate");
            if (wsaTO != null) {
                log.debug("Read dati da WSATo...");
                UtilitiesIntegrazioneWSAddressing.readDatiWSATo(hdrReaded.getToValue(), integrazione);
            }
            if (wsaFROM != null) {
                log.debug("Read dati da WSAFrom...");
                UtilitiesIntegrazioneWSAddressing.readDatiWSAFrom(hdrReaded.getFromValue(), integrazione);
            }
            if (wsaAction != null) {
                log.debug("Read dati da WSAAction...");
                UtilitiesIntegrazioneWSAddressing.readDatiWSAAction(hdrReaded.getActionValue(), integrazione);
            }
            if (wsaID != null) {
                log.debug("Read dati da WSAId...");
                UtilitiesIntegrazioneWSAddressing.readDatiWSAID(hdrReaded.getIdValue(), integrazione, interpretaIDComeIDBusta);
            }
            if (wsaRelatesTo != null) {
                log.debug("Read dati da WSARelatesTo...");
                UtilitiesIntegrazioneWSAddressing.readDatiWSARelatesTo(hdrReaded.getRelatesToValue(), integrazione);
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, lettura dell'header soap non riuscita: " + e.getMessage(), e);
        }
    }

    public void updateHeader(OpenSPCoop2SoapMessage message, IDSoggetto soggettoFruitore, IDServizio idServizio, String idBusta, String servizioApplicativo, String correlazioneApplicativa, String idTransazione, String actorIntegrazione) throws Exception {
        this.updateHeader(message, soggettoFruitore, idServizio, idBusta, null, servizioApplicativo, correlazioneApplicativa, idTransazione, actorIntegrazione);
    }

    public void updateHeader(OpenSPCoop2SoapMessage message, IDSoggetto soggettoFruitore, IDServizio idServizio, String idBusta, String idBustaRisposta, String servizioApplicativo, String correlazioneApplicativa, String idTransazione, String actorIntegrazione) throws Exception {
        HeaderIntegrazione integrazione = new HeaderIntegrazione(idTransazione);
        integrazione.setIdApplicativo(correlazioneApplicativa);
        integrazione.setServizioApplicativo(servizioApplicativo);
        HeaderIntegrazioneBusta busta = new HeaderIntegrazioneBusta();
        busta.setTipoMittente(soggettoFruitore.getTipo());
        busta.setMittente(soggettoFruitore.getNome());
        busta.setTipoDestinatario(idServizio.getSoggettoErogatore().getTipo());
        busta.setDestinatario(idServizio.getSoggettoErogatore().getNome());
        busta.setTipoServizio(idServizio.getTipo());
        busta.setServizio(idServizio.getNome());
        busta.setVersioneServizio(idServizio.getVersione());
        busta.setAzione(idServizio.getAzione());
        if (idBustaRisposta == null) {
            busta.setID(idBusta);
        } else {
            busta.setID(idBustaRisposta);
            busta.setRiferimentoMessaggio(idBusta);
        }
        integrazione.setBusta(busta);
        this.updateHeader(message, integrazione, actorIntegrazione);
    }

    public void updateHeader(OpenSPCoop2SoapMessage message, HeaderIntegrazione integrazione, String actorIntegrazione) throws Exception {
        SOAPHeader header = message.getSOAPHeader();
        SOAPHeaderElement wsaTO = null;
        SOAPHeaderElement wsaFROM = null;
        SOAPHeaderElement wsaAction = null;
        SOAPHeaderElement wsaID = null;
        SOAPHeaderElement wsaRelatesTo = null;
        Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (header == null) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().debug("SOAPHeader non presente: add soapHeader");
            header = message.getSOAPPart().getEnvelope().addHeader();
        } else {
            WSAddressingUtilities wsaddressingUtilities = new WSAddressingUtilities(log);
            WSAddressingHeader hdrReaded = wsaddressingUtilities.read(message, actorIntegrazione, false);
            if (hdrReaded != null) {
                wsaTO = hdrReaded.getTo();
                wsaFROM = hdrReaded.getFrom();
                wsaAction = hdrReaded.getAction();
                wsaID = hdrReaded.getId();
                wsaRelatesTo = hdrReaded.getRelatesTo();
            }
        }
        if (integrazione.getBusta() != null) {
            HeaderIntegrazioneBusta hBusta = integrazione.getBusta();
            if (hBusta.getDestinatario() != null && hBusta.getServizio() != null) {
                if (wsaTO != null) {
                    wsaTO.setValue(UtilitiesIntegrazioneWSAddressing.buildDatiWSATo(hBusta.getTipoDestinatario(), hBusta.getDestinatario(), hBusta.getTipoServizio(), hBusta.getServizio(), hBusta.getVersioneServizio()));
                } else {
                    wsaTO = UtilitiesIntegrazioneWSAddressing.buildWSATo(message, actorIntegrazione, hBusta.getTipoDestinatario(), hBusta.getDestinatario(), hBusta.getTipoServizio(), hBusta.getServizio(), hBusta.getVersioneServizio());
                    message.addHeaderElement(header, wsaTO);
                }
                if (hBusta.getAzione() != null) {
                    if (wsaAction != null) {
                        wsaAction.setValue(UtilitiesIntegrazioneWSAddressing.buildDatiWSAAction(hBusta.getTipoDestinatario(), hBusta.getDestinatario(), hBusta.getTipoServizio(), hBusta.getServizio(), hBusta.getVersioneServizio(), hBusta.getAzione()));
                    } else {
                        wsaAction = UtilitiesIntegrazioneWSAddressing.buildWSAAction(message, actorIntegrazione, hBusta.getTipoDestinatario(), hBusta.getDestinatario(), hBusta.getTipoServizio(), hBusta.getServizio(), hBusta.getVersioneServizio(), hBusta.getAzione());
                        message.addHeaderElement(header, wsaTO);
                    }
                }
            }
            if (hBusta.getMittente() != null) {
                if (wsaFROM != null) {
                    Iterator itFROM = wsaFROM.getChildElements();
                    while (itFROM.hasNext()) {
                        SOAPElement s;
                        Object o = itFROM.next();
                        if (o == null || !(o instanceof SOAPElement) || !"Address".equals((s = (SOAPElement)o).getLocalName())) continue;
                        s.setValue(UtilitiesIntegrazioneWSAddressing.buildDatiWSAFrom(integrazione.getServizioApplicativo(), hBusta.getTipoMittente(), hBusta.getMittente()));
                        break;
                    }
                } else {
                    wsaFROM = UtilitiesIntegrazioneWSAddressing.buildWSAFrom(message, actorIntegrazione, integrazione.getServizioApplicativo(), hBusta.getTipoMittente(), hBusta.getMittente());
                    message.addHeaderElement(header, wsaFROM);
                }
            }
            if (hBusta.getID() != null) {
                if (wsaID != null) {
                    wsaID.setValue(UtilitiesIntegrazioneWSAddressing.buildDatiWSAID(hBusta.getID()));
                } else {
                    wsaID = UtilitiesIntegrazioneWSAddressing.buildWSAID(message, actorIntegrazione, hBusta.getID());
                    message.addHeaderElement(header, wsaID);
                }
            }
            if (hBusta.getRiferimentoMessaggio() != null || hBusta.getIdCollaborazione() != null) {
                String rif = hBusta.getRiferimentoMessaggio();
                if (rif == null) {
                    rif = hBusta.getIdCollaborazione();
                }
                if (wsaRelatesTo != null) {
                    wsaRelatesTo.setValue(UtilitiesIntegrazioneWSAddressing.buildDatiWSARelatesTo(rif));
                } else {
                    wsaRelatesTo = UtilitiesIntegrazioneWSAddressing.buildWSARelatesTo(message, actorIntegrazione, rif);
                    message.addHeaderElement(header, wsaRelatesTo);
                }
            }
        }
    }

    public void deleteHeader(OpenSPCoop2SoapMessage message, String actorIntegrazione) throws HeaderIntegrazioneException {
        try {
            if (actorIntegrazione == null) {
                throw new Exception("Actor non definito");
            }
            Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            SOAPHeader header = message.getSOAPHeader();
            if (header == null) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().debug("SOAPHeader non presente");
                return;
            }
            WSAddressingUtilities wsaddressingUtilities = new WSAddressingUtilities(log);
            wsaddressingUtilities.delete(message, actorIntegrazione);
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, lettura dell'header soap non riuscita: " + e.getMessage(), e);
        }
    }
}

