/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.integrazione.backward_compatibility;

import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePD;
import org.openspcoop2.pdd.core.integrazione.InRequestPDMessage;
import org.openspcoop2.pdd.core.integrazione.InResponsePDMessage;
import org.openspcoop2.pdd.core.integrazione.OutRequestPDMessage;
import org.openspcoop2.pdd.core.integrazione.OutResponsePDMessage;
import org.openspcoop2.pdd.core.integrazione.backward_compatibility.UtilitiesIntegrazioneBC;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.constants.TipoIntegrazione;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public abstract class AbstractGestoreIntegrazionePDTrasportoBC
extends AbstractCore
implements IGestoreIntegrazionePD {
    UtilitiesIntegrazioneBC utilitiesRequestBC = null;
    UtilitiesIntegrazioneBC utilitiesResponseBC = null;
    private Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();

    public AbstractGestoreIntegrazionePDTrasportoBC(boolean openspcoop2, boolean x_prefix) {
        if (this.log == null) {
            this.log = LoggerWrapperFactory.getLogger(AbstractGestoreIntegrazionePDTrasportoBC.class);
        }
        try {
            this.utilitiesRequestBC = UtilitiesIntegrazioneBC.getInstancePDRequest(this.log, openspcoop2, x_prefix);
            this.utilitiesResponseBC = UtilitiesIntegrazioneBC.getInstancePDResponse(this.log, openspcoop2, x_prefix);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'inizializzazione delle UtilitiesIntegrazione: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void readInRequestHeader(HeaderIntegrazione integrazione, InRequestPDMessage inRequestPDMessage) throws HeaderIntegrazioneException {
        try {
            String protocollo = this.getProtocolFactory() != null ? this.getProtocolFactory().getProtocol() : null;
            this.utilitiesRequestBC.readTransportProperties(inRequestPDMessage.getUrlProtocolContext().getHeaders(), integrazione, protocollo);
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDTrasporto, " + e.getMessage(), e);
        }
    }

    @Override
    public void setOutRequestHeader(HeaderIntegrazione integrazione, OutRequestPDMessage outRequestPDMessage) throws HeaderIntegrazioneException {
    }

    @Override
    public void readInResponseHeader(HeaderIntegrazione integrazione, InResponsePDMessage inResponsePDMessage) throws HeaderIntegrazioneException {
    }

    @Override
    public void setOutResponseHeader(HeaderIntegrazione integrazione, OutResponsePDMessage outResponsePDMessage) throws HeaderIntegrazioneException {
        try {
            String protocollo = this.getProtocolFactory() != null ? this.getProtocolFactory().getProtocol() : null;
            this.utilitiesResponseBC.setTransportProperties(integrazione, outResponsePDMessage.getHeaders(), this.getProtocolFactory().createProtocolManager().buildIntegrationProperties(outResponsePDMessage.getBustaRichiesta(), false, TipoIntegrazione.TRASPORTO), protocollo);
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDTrasporto, " + e.getMessage(), e);
        }
    }
}

